/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao;

import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.LatestDeviceBackupInfo;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.OdbFolderNameTODeviceUUIDMapping;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDeviceAccessControl;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;

public interface DeviceDao {
    public List<Device> getAll(int var1, String var2);

    public List<Device> getAllSinceTimeStamp(int var1, String var2, long var3);

    public Device saveUUID(int var1, String var2, Device var3);

    public Device register(int var1, String var2, Device var3);

    public Device getDeviceInfoByUUID(int var1, String var2, String var3);

    public Device blockUnblockDevice(int var1, String var2, Device var3, boolean var4);

    public Device updateDeviceInfo(int var1, String var2, Device var3);

    public List<Device> getAllDevicesByUUID(int var1, String var2, String var3);

    public long getDeviceCount(int var1, String var2, boolean var3);

    public long getDeviceCount(int var1, String var2);

    public void deleteAllDeviceByUser(int var1, String var2, User var3);

    public List<Device> getAllDeviceByUser(int var1, String var2, User var3);

    public long getDeviceCountOfUser(int var1, String var2, User var3);

    public Device getDeviceByName(int var1, String var2, String var3, String var4, String var5);

    public List<Device> getDeviceByNameForBackup(int var1, String var2, String var3, String var4);

    public List<Device> getActiveDeviceByName(int var1, String var2, String var3, String var4);

    public List<Device> getActiveDeviceByNameAndUser(int var1, String var2, String var3, String var4);

    public void updateDeviceDecoupled(int var1, String var2, String var3);

    public List<Device> getActiveDevicesForNoBackup(int var1, String var2, int var3);

    public Device getDeviceByName(int var1, String var2, String var3);

    public Device getDeviceByNameAndUser(int var1, String var2, String var3);

    public void blockUnblockDevice(int var1, String var2, String var3, boolean var4);

    public Device getDeviceByNameForUserId(int var1, String var2, String var3, ObjectId var4, String var5);

    public Map<String, List<Device>> getAllDeviceByUser(int var1, List<User> var2);

    public Map<String, List<Device>> getAllDevicesByUserName(int var1);

    public List<Device> getAllDeviceByUserName(int var1, String var2);

    public List<Device> getAllWithPagination(int var1, int var2);

    public List<Device> findDeviceByNames(int var1, List<String> var2);

    public List<Device> getAllDeviceByUserName(int var1, String var2, List<String> var3);

    public Map<String, List<Device>> getAllDevicesByUser(int var1);

    public void updateDevice(int var1, Device var2);

    public Map<String, List<Device>> getAllDevicesByUser(int var1, int var2);

    public Object[] getCloudOverView(int var1);

    public List<Device> getAllActiveDevices(int var1);

    public void updateClientVersion(int var1, String var2, String var3);

    public List<Device> getAllDevicesByName(int var1, String var2);

    public List<Device> getAllActiveDevices(int var1, int var2);

    public void markAllDevicesAsInActiveForUser(int var1, String var2, User var3);

    public void deleteAllDeviceByUserName(int var1, String var2, String var3);

    public Device getDeviceById(int var1, ObjectId var2);

    public List<Device> getAllDeletedDevices(int var1, String var2);

    public void markAllDevicesAsDeletedForUser(int var1, String var2, User var3);

    public List<Device> getActiveDevicesForNoBackup(int var1);

    public void updateLastHeardTime(int var1, ObjectId var2);

    public void updateLastHeardTimeAndPolicyModifiedTime(int var1, ObjectId var2, long var3);

    public void updateClientServiceVersion(int var1, String var2, String var3);

    public List<Device> getAllDevicesByUser(int var1, User var2);

    public void deleteDeviceByDeviceUUID(int var1, String var2);

    public void deleteDeviceBackupOverviewById(int var1, ObjectId var2);

    public DeviceBackupOverView getDeviceBkpOverviewForDeviceUUID(int var1, String var2);

    public void updateUserInfoInDeviceBkpOverview(int var1, User var2);

    public void updatedeviceInfoInDeviceBkpOverview(int var1, Device var2);

    public void updatePolicyNameInDeviceBkpOverview(int var1, String var2, String var3);

    public void deleteAllDeviceBkpoverviewByUser(int var1, User var2);

    public void markUserAndDeviceAsDeleteInDeviceBkpOverview(int var1, User var2);

    public List<DeviceBackupOverView> getAllOverviews(int var1);

    public List<DeviceBackupOverView> getAllOverviews(int var1, String var2);

    public List<DeviceBackupOverView> getAllOverviews(int var1, int var2);

    public void updateDeviceStatusInOverview(int var1, String var2, boolean var3);

    public List<DeviceBackupOverView> getDeviceBkpOverviewForUserName(int var1, String var2);

    public void updateDeviceName(int var1, String var2, String var3);

    public List<DeviceBackupOverView> getDeviceBkpOverviewForPolicyNames(int var1, List<String> var2, boolean var3, String var4);

    public List<DeviceBackupOverView> getDeviceBkpOverviewForUserNameAndDeviceName(int var1, String var2, String var3);

    public void updateClientVersionInOverview(int var1, String var2, String var3);

    public List<Device> getAllActiveDeviceByUserName(int var1, String var2);

    public List<Device> findDeviceByUserNames(int var1, List<String> var2);

    public void blockOldDeviceBkpInfo(int var1, String var2);

    public void saveLatestDeviceBkpInfo(int var1, LatestDeviceBackupInfo var2);

    public LatestDeviceBackupInfo getLatestDeviceBkpInfo(int var1, String var2);

    public List<DeviceBackupOverView> getDeviceBkpOverviewForUserNames(int var1, List<String> var2);

    public List<Device> getDeviceByUserName(int var1, String var2);

    public List<LatestDeviceBackupInfo> getAllLatestDeviceBkpInfo(int var1, String var2);

    public List<Device> getAllDevices(int var1);

    public void deleteLatestBkpInfoBuDeviceUUID(int var1, String var2);

    public Device getOneDriveDeviceforUser(int var1, String var2);

    public Object[] getODBCloudOverView(int var1);

    public long getDeviceBackupOverviewCountByDeviceUUID(int var1, String var2);

    public List<Device> getAllUserByDeviceName(int var1, String var2);

    public Device getDeviceByUserNameAndDeviceName(int var1, String var2, String var3);

    public void updateODBPolicyNameInDeviceBkpOverview(int var1, String var2, String var3);

    public void saveO365BlackListUser(int var1, O365BlackListUser var2);

    public void removeO365BlackListUser(int var1, String var2);

    public List<UserDeviceAccessControl> getUserDeviceAccessControl(int var1, ObjectId var2);

    public void saveUserDeviceAccessControl(int var1, UserDeviceAccessControl var2);

    public void deleteUserDeviceAccess(int var1, ObjectId var2, ObjectId var3);

    public List<UserDeviceAccessControl> getUserDeviceAccessControlByUserID(int var1, ObjectId var2);

    public List<Device> getAllDevicesByIds(int var1, List<String> var2);

    public List<DeviceBackupOverView> getAllOverviews(int var1, int var2, int var3);

    public long getCountAllOverviews(int var1, List<String> var2);

    public List<DeviceBackupOverView> getDeviceBkpOverviewForPolicyNames(int var1, List<String> var2, boolean var3, int var4, int var5);

    public long getDeviceBkpOverviewCountForUserNames(int var1, List<String> var2);

    public long getAllDeviceCount(int var1);

    public void updateDevDisplayName(int var1, String var2, String var3);

    public void updateDevDisplayNameInOverview(int var1, String var2, String var3);

    public List<Device> getDevicesByUserName(int var1, String var2);

    public Device getUsersWithoutOutlookDevices(int var1, String var2);

    public List<DeviceBackupOverView> getAllODBOverviews(int var1);

    public void updateSizeDeviceBackupOverView(int var1, String var2, Long var3, Long var4);

    public void updateSizeDeviceBackupOverView(int var1, String var2, Long var3, Long var4, Long var5, Long var6);

    public List<Device> getAllBackupDeviceByUserName(int var1, String var2);

    public List<Device> getAllOfficeDevicesByUserName(int var1, String var2);

    public void saveMailBackupBatch(int var1, MailBackupBatch var2, EventHub var3);

    public MailBackupBatch getMailBackupBatch(int var1, String var2);

    public List<Device> getAllOneDriveDeviceByUserName(int var1, String var2);

    public List<ObjectId> loadAllDeviceUserIds(int var1, boolean var2);

    public List<String> getUniqueUserNamesInDevice(int var1, List<String> var2);

    public long getCountFullBkpCompleted(int var1, List<String> var2);

    public List<String> getUniqueUserNamesInDevice(int var1);

    public List<DeviceBackupOverView> getAllBkpOverviews(int var1);

    public List<DeviceBackupOverView> getDeviceBackupOVerviewList(int var1, ReportQueryElement var2);

    public List<DeviceBackupOverView> getDeviceBkpOverviewForUserNameAndDeviceName(int var1, String var2, String var3, int var4);

    public List<DeviceBackupOverView> getDeviceBkpOverviewForUserName(int var1, String var2, int var3);

    public List<DeviceBackupOverView> getLastAgentHeardDeviceBkpOverviews(int var1, ReportQueryElement var2);

    public List<DeviceBackupOverView> getAllDeviceBackupOVerviewList(int var1, ReportQueryElement var2);

    public long getCountStorageUtilizeReport(int var1, ReportQueryElement var2);

    public long getCountDeviceAccessControl(int var1);

    public List<DeviceBackupOverView> getAllDeviceBkpOverviewsForDeviceUUID(int var1, String var2);

    public List<Device> getAllUserDeviceAccessControl(int var1);

    public List<DeviceBackupOverView> getAllOverViewWithPagination(int var1, int var2, List<String> var3);

    public void updateUserStatusInDeviceBkpOverview(int var1, User var2);

    public void saveOdbFolderNameTODeviceUUIDMapping(int var1, OdbFolderNameTODeviceUUIDMapping var2);

    public List<DeviceBackupOverView> getAllOverviewsBasedOnProductType(int var1, String var2);

    public List<String> getUniqueUserNamesInDeviceByProductType(int var1, String var2);

    public List<String> getUniqueUserNamesInDeviceByProductType(int var1, List<String> var2, String var3);

    public long getCountFullBkpCompletedByProductType(int var1, List<String> var2, String var3);

    public void updatedeviceToken(int var1, String var2);

    public Device getDeviceFromDbInfoByUUID(int var1, String var2, String var3);
}

