/*
 * Decompiled with CFR 0.152.
 */
package com.pg.dao.impl;

import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.OdbFolderName;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.Proxy;
import com.parablu.pcbd.domain.User;
import com.pg.dao.Office365Dao;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class Office365DaoImpl
implements Office365Dao {
    public static final String EXCEPTION = "Exception  ";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT = "Accept";
    public static final String BEARER = "Bearer ";
    public static final String AUTHORIZATION = "Authorization";
    private static Logger logger = LogManager.getLogger(Office365DaoImpl.class);
    private static final String TOKEN_URL = "https://login.windows.net/common/oauth2/token";
    private static final String UTF_8 = "UTF-8";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String APPLICATION_JSON_ODATA_VERBOSE = "application/json;odata=verbose";
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PciAuthorizationTokenElement getAccessToken(PciAuthorizationTokenElement elementParam) {
        String accessToken = "";
        String refreshToken = "";
        PciAuthorizationTokenElement element = elementParam;
        URL url = null;
        URLConnection conn = null;
        HttpURLConnection connection = null;
        String data = null;
        InputStream inputStream = null;
        java.net.Proxy proxy = this.getProxy();
        logger.debug("  proxy getAccessToken............HttpURLConnection.............................");
        try {
            String line;
            data = URLEncoder.encode("grant_type", UTF_8) + "=" + URLEncoder.encode(REFRESH_TOKEN, UTF_8);
            data = data + "&" + URLEncoder.encode(REFRESH_TOKEN, UTF_8) + "=" + URLEncoder.encode(element.getRefreshToken(), UTF_8);
            data = data + "&" + URLEncoder.encode("client_id", UTF_8) + "=" + URLEncoder.encode(element.getClientId(), UTF_8);
            data = data + "&" + URLEncoder.encode("client_secret", UTF_8) + "=" + URLEncoder.encode(element.getClientSecret(), UTF_8);
            url = new URL(TOKEN_URL);
            conn = proxy == null ? url.openConnection() : url.openConnection(proxy);
            conn.setDoOutput(true);
            conn.setConnectTimeout(1800000);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            connection = (HttpURLConnection)conn;
            if (connection.getResponseCode() == 400) {
                logger.error("TOKEN has expired for user ...... " + element.getAccountId());
                PciAuthorizationTokenElement pciAuthorizationTokenElement = null;
                this.closeConnection(connection, inputStream);
                return pciAuthorizationTokenElement;
            }
            inputStream = conn.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder response = new StringBuilder("");
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            wr.close();
            rd.close();
            JSONObject jsonObject = new JSONObject(response.toString());
            logger.debug("Json object>>>>>>>>>>>>>>>>>" + jsonObject.toString());
            accessToken = jsonObject.optString("access_token");
            refreshToken = jsonObject.optString(REFRESH_TOKEN);
            element.setAccessToken(accessToken);
            element.setRefreshToken(refreshToken);
            this.closeConnection(connection, inputStream);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" ERROR trying to get access token ...HttpURLConnection " + e.getMessage());
            element = null;
        }
        finally {
            this.closeConnection(connection, inputStream);
        }
        return element;
    }

    private void closeConnection(HttpURLConnection connection, InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (connection != null) {
            connection.disconnect();
        }
    }

    @Override
    public boolean createParaBluFolderIfNotExists(String office365baseUrl, String token, String url, String emailId, String userName, String suffixFolderPath, String pbFolderName) {
        logger.debug("URL ........... " + url);
        boolean success = true;
        boolean isFolderExists = this.isFolderExists(url, token);
        logger.debug(isFolderExists + "URL ........... " + url);
        if (!isFolderExists) {
            String createFolderUrl = PCHelperConstant.getCreateFolderUrl((String)office365baseUrl, (String)emailId);
            logger.debug(isFolderExists + "URL ..createFolderUrl........ " + createFolderUrl);
            success = this.createFolder(createFolderUrl, token, userName, suffixFolderPath, pbFolderName);
        } else {
            logger.debug(" Folder already exists  ........... " + url);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFolderExists(String url, String token) {
        HttpURLConnection con = null;
        try {
            URL obj = new URL(url);
            logger.debug("  proxy isFolderExists.........................................");
            java.net.Proxy proxy = this.getProxy();
            con = proxy == null ? (HttpURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection(proxy);
            con.setRequestMethod("GET");
            con.setRequestProperty(AUTHORIZATION, BEARER + token);
            con.setRequestProperty(ACCEPT, APPLICATION_JSON_ODATA_VERBOSE);
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception while checking folder exists:" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return false;
    }

    @Override
    public boolean createLibraryIfNotExists(String office365baseUrl, String token, String emailId, String libraryName, String folderPath) {
        logger.debug(" URL for  createLibraryIfNotExists ........... ");
        boolean isLibraryExists = this.isLibraryExists(office365baseUrl, token, libraryName, emailId);
        logger.debug(isLibraryExists + "  .....isLibraryExists URL ........... ");
        if (!isLibraryExists) {
            isLibraryExists = this.createLibrary(office365baseUrl, token, libraryName, emailId);
            if (isLibraryExists) {
                return this.createFolderInsideLibrary(office365baseUrl, token, libraryName, folderPath, emailId);
            }
            return false;
        }
        return this.createFolderInsideLibrary(office365baseUrl, token, libraryName, folderPath, emailId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLibraryExists(String baseurl, String token, String libraryName, String emailId) {
        boolean success = false;
        HttpURLConnection con = null;
        String url = PCHelperConstant.getPersonalSite((String)baseurl, (String)emailId) + "/_api/web/lists/GetByTitle('" + libraryName + "')";
        try {
            URL obj = new URL(url);
            logger.debug("  ......proxy isLibraryExists.........." + url);
            java.net.Proxy proxy = this.getProxy();
            con = proxy == null ? (HttpURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection(proxy);
            con.setRequestMethod("GET");
            con.setRequestProperty(AUTHORIZATION, BEARER + token);
            con.setRequestProperty(ACCEPT, APPLICATION_JSON_ODATA_VERBOSE);
            int responseCode = con.getResponseCode();
            logger.debug("....status code  for isLibraryExists....." + responseCode);
            if (responseCode == 200) {
                success = true;
            }
        }
        catch (Exception e) {
            logger.trace("Exception " + e);
            logger.error("Exception while checking isLibraryExists:" + e.getMessage());
            success = false;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createLibrary(String baseurl, String token, String libraryName, String emailId) {
        String url = PCHelperConstant.getPersonalSite((String)baseurl, (String)emailId) + "/_api/web/lists";
        java.net.Proxy proxy = this.getProxy();
        boolean success = true;
        URL obj = null;
        HttpURLConnection con = null;
        try {
            String line;
            logger.debug("  proxy createLibrary.....HttpURLConnection....................................");
            obj = new URL(url);
            con = proxy == null ? (HttpURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection(proxy);
            con.setUseCaches(false);
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            String folderNameBody = "{ '__metadata': { 'type': 'SP.List' }, 'AllowContentTypes': true, 'BaseTemplate': 101,'ContentTypesEnabled': true, 'Description': 'My Documents Library', 'Title': '" + libraryName + "' }";
            con.setRequestProperty(AUTHORIZATION, BEARER + token);
            con.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON_ODATA_VERBOSE);
            con.setRequestProperty(ACCEPT, APPLICATION_JSON_ODATA_VERBOSE);
            con.connect();
            OutputStream os = con.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os, UTF_8);
            osw.write(folderNameBody);
            osw.flush();
            osw.close();
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), UTF_8));
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
        }
        catch (Exception e) {
            success = false;
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        logger.debug("**********************createLibrary****************" + success);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createFolderInsideLibrary(String baseurl, String token, String libraryName, String pbFolderPath, String emailId) {
        String url = PCHelperConstant.getPersonalSite((String)baseurl, (String)emailId) + "/_api/web/folders";
        java.net.Proxy proxy = this.getProxy();
        boolean success = true;
        Path p = Paths.get(pbFolderPath, new String[0]);
        String path = "";
        for (Path element : p) {
            path = StringUtils.isEmpty((String)path) ? "" + element : path + "/" + element;
            URL obj = null;
            HttpURLConnection con = null;
            try {
                logger.debug("  proxy createFolder.....HttpURLConnection...................................." + url + "...." + path);
                obj = new URL(url);
                con = proxy == null ? (HttpURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection(proxy);
                con.setUseCaches(false);
                con.setDoInput(true);
                con.setDoOutput(true);
                con.setRequestMethod("POST");
                String folderNameVal = "{\"__metadata\": {\"type\": \"SP.Folder\"}, \"ServerRelativeUrl\"  : \"" + libraryName + "/" + path + "\"}";
                con.setRequestProperty(AUTHORIZATION, BEARER + token);
                con.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON_ODATA_VERBOSE);
                con.setRequestProperty(ACCEPT, APPLICATION_JSON_ODATA_VERBOSE);
                con.connect();
                OutputStream os = con.getOutputStream();
                OutputStreamWriter osw = new OutputStreamWriter(os, UTF_8);
                osw.write(folderNameVal);
                osw.flush();
                osw.close();
                StringBuilder sb = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), UTF_8));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
            }
            catch (Exception e) {
                success = false;
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
            finally {
                if (con == null) continue;
                con.disconnect();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createFolder(String url, String token, String userNameParam, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        java.net.Proxy proxy = this.getProxy();
        boolean success = true;
        URL obj = null;
        HttpURLConnection con = null;
        try {
            String userName = userNameParam;
            logger.debug("  proxy createFolder.....HttpURLConnection....................................");
            obj = new URL(url);
            con = proxy == null ? (HttpURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection(proxy);
            con.setUseCaches(false);
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            if (!StringUtils.isEmpty((String)userNameParam)) {
                userName = "/" + userNameParam;
            }
            if (StringUtils.isEmpty((String)pbFolderName)) {
                pbFolderName = "PB";
            }
            String folderNameVal = "{\"__metadata\": {\"type\": \"MS.FileServices.Folder\"}, \"Name\" : \"" + pbFolderName + "/" + suffixFolderPath + "\"}";
            con.setRequestProperty(AUTHORIZATION, BEARER + token);
            con.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON_ODATA_VERBOSE);
            con.setRequestProperty(ACCEPT, APPLICATION_JSON_ODATA_VERBOSE);
            con.connect();
            OutputStream os = con.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os, UTF_8);
            osw.write(folderNameVal);
            osw.flush();
            osw.close();
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), UTF_8));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
        }
        catch (Exception e) {
            success = false;
            logger.debug(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return success;
    }

    private java.net.Proxy getProxy() {
        int port;
        String host;
        String passwordVal;
        String userNameVal;
        Proxy proxy = this.getProxy(1);
        if (proxy != null) {
            userNameVal = proxy.getUserName();
            passwordVal = proxy.getPassword();
            host = proxy.getHost();
            port = Integer.parseInt(proxy.getPort());
        } else {
            userNameVal = PCHelperConstant.getProxyUserName();
            passwordVal = PCHelperConstant.getProxyPassword();
            host = PCHelperConstant.getProxyHost();
            port = PCHelperConstant.getProxyPort();
        }
        final String userName = userNameVal;
        final String password = passwordVal;
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
            return null;
        }
        Authenticator authenticator = new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password.toCharArray());
            }
        };
        Authenticator.setDefault(authenticator);
        return new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
    }

    public Proxy getProxy(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List proxies = mongoTemplate.findAll(Proxy.class);
        if (CollectionUtils.isEmpty((Collection)proxies)) {
            return null;
        }
        return (Proxy)proxies.get(0);
    }

    @Override
    @Cacheable(value={"getOdbFolderName"})
    public String getOdbFolderName(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List odbFolderNames = mongoTemplate.findAll(OdbFolderName.class);
        if (CollectionUtils.isEmpty((Collection)odbFolderNames)) {
            return null;
        }
        OdbFolderName odbFolderName = (OdbFolderName)odbFolderNames.get(0);
        String folderName = "";
        if (odbFolderName != null) {
            folderName = odbFolderName.getFolderName();
        }
        return folderName;
    }

    @Override
    public void updatePciAuthorizationTokensForServiceAcct(int cloudId, String accessToken, String refreshToken) {
        Query query = new Query();
        Update update = new Update();
        update.set("accessToken", (Object)accessToken);
        update.set("refreshToken", (Object)refreshToken);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, PciAuthorizationTokens.class);
    }

    private User getUserInfo(int cloudId, String cloudName, String userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        return (User)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public PciAuthorizationTokenElement getMSGTokenElement(int cloudId, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSGTokens msgTokens = (MSGTokens)mongoTemplate.findOne(new Query(), MSGTokens.class);
        PciAuthorizationTokenElement element = null;
        if (msgTokens != null) {
            element = new PciAuthorizationTokenElement();
            element.setAccessToken(msgTokens.getAccessToken());
            element.setClientId(msgTokens.getClientId());
            element.setClientSecret(msgTokens.getClientSecret());
            element.setRedirectUri(msgTokens.getRedirectUri());
            element.setRefreshToken(msgTokens.getRefreshToken());
            element.setAccountId(msgTokens.getAccountId());
            element.setSharePointUrl(msgTokens.getSharePointUrl());
            element.setCloudName(msgTokens.getCloudName());
            if (StringUtils.isEmpty((String)userName)) {
                User user = this.getUserInfo(1, "", msgTokens.getUserId().toString());
                if (user != null) {
                    element.setUserName(user.getUserName());
                }
            } else {
                element.setUserName(userName);
            }
        }
        return element;
    }

    @Override
    public MSGTokens getMSGTokens(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MSGTokens)mongoTemplate.findOne(new Query(), MSGTokens.class);
    }
}

