/*
 * Decompiled with CFR 0.152.
 */
package com.pg.dao.impl;

import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.util.JSON;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.ReBackUpImage;
import com.parablu.pcbd.domain.RestoreBackUpImage;
import com.parablu.pcbd.domain.RestoredFiles;
import com.parablu.pcbd.domain.User;
import com.parablu.query.util.BackupFileQueryElement;
import com.pg.dao.BackupFileDao;
import com.pg.domain.BackupFile;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class BackupFileDaoImpl
implements BackupFileDao {
    private static Logger logger = LogManager.getLogger(BackupFileDaoImpl.class);
    private static final String FOLDER = "folder";
    private static final String DEVICE = "device";
    private static final String PRESENT = "present";
    private static final String DEVICE_PATH = "devicePath";
    private static final String PRIVACY_GATEWAY_OD = "privacy_gateway_od_";
    private static final String MACINTOSH = "Macintosh";
    private static final String FILEPATH = "filePath";
    private static final String PREFIX_DOLLAR_MATCH = "$match";
    private static final String PREFIX_DOLLAR_PROJECT = "$project";
    private static final String PREFIX_DOLLAR_FILENAME = "$fileName";
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String PREFIX_DOLLAR_LAST = "$last";
    private static final String PREFIX_DOLLAR_GROUP = "$group";
    private static final String DEVICE_DOLLAR_ID = "device.$id";
    private static final String STORAGEPLACE = "storagePlace";
    private static final String MD5CHECKUM = "md5Checksum";
    private static final String CHUNKFILES = "chunkFiles";
    private static final String COMPRESSED = "compressed";
    private BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;
    private MongoOperations mongoOps;

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    public MongoOperations getMongoOps() {
        return this.mongoOps;
    }

    public void setMongoOps(MongoOperations mongoOps) {
        this.mongoOps = mongoOps;
    }

    @Override
    public long totalCountOfAllBackupFileVersions(int cloudId, String cloudName, String deviceUUID, String devicePath, String fileName, String userName) {
        logger.error(" START of totalCountOfAllBackupFileVersions ...");
        String tableName = "BACKUP";
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        logger.error(" START Mongo template count ...." + userName);
        Device device = this.getDeviceForDeviceUUID(cloudId, deviceUUID);
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)devicePath)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
        } else if (!StringUtils.isEmpty((String)devicePath) && StringUtils.isEmpty((String)fileName)) {
            Criteria criteria2 = new Criteria();
            criteria2.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)Pattern.compile(devicePath)), Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)DEVICE).is((Object)device), criteria2, Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        long count = mongoTemplate.count(query, BackUpImage.class);
        logger.error(" END Mongo template count ...." + count);
        return count;
    }

    private Device getDeviceForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    private String getDeviceIdforUUID(String deviceUUID, MongoTemplate mongoTemplate) {
        String deviceId = "";
        MongoCollection backupCollection = mongoTemplate.getCollection("DEVICE");
        Bson query = Filters.eq((String)DEVICE_UUID, (Object)deviceUUID);
        FindIterable find = backupCollection.find(query);
        for (Document dbObject : find) {
            deviceId = dbObject.get((Object)"_id").toString();
        }
        return deviceId;
    }

    @Override
    public long totalCountOfAllFileVersions(int cloudId, String cloudName, String userName, String deviceUUID, String devicePath, String fileName) {
        String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        Document document = new Document();
        String macOs = MACINTOSH;
        if (!StringUtils.isEmpty((String)devicePath) && !devicePath.startsWith(MACINTOSH)) {
            String devicePathSeparator = "\\\\";
            String devicePathVar = devicePath.replace("/", devicePathSeparator);
            document.append(FILEPATH, (Object)Pattern.compile(devicePathVar));
        }
        if (!StringUtils.isEmpty((String)fileName)) {
            document.append("fileName", (Object)Pattern.compile(fileName));
        }
        document.append(DEVICE_UUID, (Object)deviceUUID);
        MongoCollection backupCollection = mongoTemplate.getCollection(tableName);
        return backupCollection.countDocuments((Bson)document);
    }

    @Override
    public long countOfBackupFileLatestRecords(int cloudId, String cloudName, String deviceUUID, String devicePath, String fileName, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<Bson> pipeline = this.getCountCriteriaForBackupLatestVersions(mongoTemplate, deviceUUID, devicePath, fileName, userName);
        String tableName = "BACKUP";
        MongoCollection collection = mongoTemplate.getCollection(tableName);
        AggregateIterable documents = collection.aggregate(pipeline);
        long totalCount = 0L;
        for (Document next : documents) {
            ++totalCount;
        }
        logger.error(" newcount query .............. " + totalCount);
        return totalCount;
    }

    @Override
    public long countOfLatestRecords(int cloudId, String cloudName, String userName, String deviceUUID, String devicePath, String fileName) {
        List<Bson> pipeline = BackupFileDaoImpl.getCountCriteriaForLatestVersions(deviceUUID, devicePath, fileName);
        String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        MongoCollection collection = mongoTemplate.getCollection(tableName);
        AggregateIterable documents = collection.aggregate(pipeline);
        long totalCount = 0L;
        for (Document next : documents) {
            ++totalCount;
        }
        return totalCount;
    }

    private static List<Bson> getCountCriteriaForLatestVersions(String deviceUUID, String devicePath, String fileName) {
        Document document = new Document();
        document.append(DEVICE_UUID, (Object)deviceUUID);
        String macOs = MACINTOSH;
        if (!StringUtils.isEmpty((String)devicePath) && !devicePath.startsWith(MACINTOSH)) {
            String devicePathSeparator = "\\\\";
            String devicePathVar = devicePath.replace("/", devicePathSeparator);
            document.append(FILEPATH, (Object)Pattern.compile(devicePathVar));
        }
        if (!StringUtils.isEmpty((String)fileName)) {
            document.append("fileName", (Object)fileName);
        }
        Bson matchQuery = Filters.and((Bson[])new Bson[]{document});
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)document.append("_id", (Object)document.append(FILEPATH, (Object)"$filePath")).append("fileName", (Object)PREFIX_DOLLAR_FILENAME), (BsonField[])new BsonField[]{new BsonField("oid", (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)"$_id"))}));
        pipeline.add(Aggregates.project((Bson)document.append("_id", (Object)1)));
        return pipeline;
    }

    private List<Bson> getCountCriteriaForBackupLatestVersions(MongoTemplate mongoTemplate, String deviceUUID, String devicePath, String fileName, String userName) {
        String deviceId = this.getDeviceIdforUUID(deviceUUID, mongoTemplate);
        Document document = new Document();
        if (!StringUtils.isEmpty((String)userName)) {
            document.append("userName", (Object)userName);
        }
        if (!StringUtils.isEmpty((String)deviceId)) {
            document.append(DEVICE_DOLLAR_ID, (Object)new ObjectId(deviceId));
        }
        if (!StringUtils.isEmpty((String)devicePath)) {
            document.append(DEVICE_PATH, (Object)Pattern.compile(devicePath));
        }
        if (!StringUtils.isEmpty((String)fileName)) {
            document.append("fileName", (Object)fileName);
        }
        document.append(PRESENT, (Object)true);
        document.append(FOLDER, (Object)false);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{document});
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)document.append("_id", (Object)document.append(DEVICE_PATH, (Object)"$devicePath")).append("fileName", (Object)PREFIX_DOLLAR_FILENAME), (BsonField[])new BsonField[]{new BsonField("lastServerModifiedTime", (Bson)new Document("$max", (Object)"$lastServerModifiedTime"))}));
        pipeline.add(Aggregates.project((Bson)document.append("_id", (Object)1).append("lastServerModifiedTime", (Object)1)));
        return pipeline;
    }

    @Override
    public List<BackupFile> getBackupFilesForGivenPathfromBackup(BackupFileQueryElement backupFileQueryElement) {
        int cloudId = backupFileQueryElement.getCloudId();
        String cloudName = backupFileQueryElement.getCloudName();
        String userName = backupFileQueryElement.getUserName();
        String devicePath = backupFileQueryElement.getDevicePath();
        String fileName = backupFileQueryElement.getFileName();
        String deviceUUID = backupFileQueryElement.getDeviceUUID();
        int skipValue = backupFileQueryElement.getSkipValue();
        Map<String, Long> fileVersionMap = backupFileQueryElement.getFileVersionMap();
        List<BackupFile> backupFiles = new ArrayList<BackupFile>();
        try {
            logger.debug("RESTORE-QUERY ............");
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Device device = this.getDeviceForDeviceUUID(cloudId, deviceUUID);
            Criteria criteria = new Criteria();
            this.addCriteriaForGivenPAth(userName, devicePath, fileName, criteria, device);
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
            query.limit(PCHelperConstant.getRestoreQueryLimit());
            query.skip((long)(skipValue * PCHelperConstant.getRestoreQueryLimit()));
            List list = mongoTemplate.find(query, BackUpImage.class);
            ArrayList<ObjectId> backupIds = new ArrayList<ObjectId>();
            HashMap<String, String> md5Map = new HashMap<String, String>();
            list.removeAll(Collections.singleton(null));
            for (BackUpImage backUpImage : list) {
                BackupFile backupFile = this.convertBkpImageToBackupFile(backUpImage);
                if (!CollectionUtils.isEmpty(backUpImage.getChunkFiles())) {
                    backupFile.setMd5(backUpImage.getMd5Checksum());
                    backupFiles.add(backupFile);
                    continue;
                }
                backupIds.add(backUpImage.getId());
                md5Map.put(backUpImage.getId().toString(), backUpImage.getMd5Checksum());
            }
            logger.debug("END-RESTORE-QUERY ............");
            backupFiles = this.getBackupFilesForBackupImageId(cloudName, userName, deviceUUID, cloudId, fileVersionMap, backupIds, md5Map);
            logger.error("##End Trying to get devicepath list andoperator .........." + backupFiles.size());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception while get backup files for given path:" + e.getMessage());
        }
        return backupFiles;
    }

    @Override
    public List<BackUpImage> getBackupFilesForGivenPathfromBackupImage(String isImmediateFolderLevel, BackupFileQueryElement backupFileQueryElement, Device device, boolean onlyLatestVersion, String serverModifiedTime, boolean restoreDeletedFiles) {
        List<Object> list = new ArrayList();
        ArrayList<BackUpImage> bkpImages = new ArrayList<BackUpImage>();
        long modifiedTime = 0L;
        if (!org.springframework.util.StringUtils.isEmpty((Object)serverModifiedTime)) {
            modifiedTime = Long.parseLong(serverModifiedTime);
        }
        logger.debug("Restore based on time stamp .................... " + modifiedTime);
        int cloudId = backupFileQueryElement.getCloudId();
        String deviceUUID = backupFileQueryElement.getDeviceUUID();
        int skipValue = backupFileQueryElement.getSkipValue();
        String devicePath = backupFileQueryElement.getDevicePath();
        String fileName = backupFileQueryElement.getFileName();
        logger.debug("deviceUUID...... " + deviceUUID);
        logger.debug("skipValue...... " + skipValue);
        logger.debug("devicePath...... " + devicePath);
        logger.debug("fileName...... " + fileName);
        logger.debug("isImmediateFolderLevel...... " + isImmediateFolderLevel);
        try {
            List results;
            logger.debug("RESTORE-QUERY ..getBackupFilesForGivenPathfromBackupImage..........");
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            Criteria criteria = new Criteria();
            if (restoreDeletedFiles) {
                logger.debug("inside restoreDeletedFiles ");
                if (StringUtils.isEmpty((String)devicePath)) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                } else if (!StringUtils.isEmpty((String)devicePath) && StringUtils.isEmpty((String)fileName)) {
                    if (StringUtils.isEmpty((String)isImmediateFolderLevel)) {
                        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)Pattern.compile(devicePath)), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                    } else {
                        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                    }
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                }
            } else {
                logger.debug("inside dont restoreDeletedFiles ");
                if (StringUtils.isEmpty((String)devicePath)) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)FOLDER).is((Object)false)});
                } else if (!StringUtils.isEmpty((String)devicePath) && StringUtils.isEmpty((String)fileName)) {
                    if (StringUtils.isEmpty((String)isImmediateFolderLevel)) {
                        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)Pattern.compile(devicePath)), Criteria.where((String)FOLDER).is((Object)false)});
                    } else {
                        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)false)});
                    }
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)FOLDER).is((Object)false)});
                }
            }
            Query query = new Query((CriteriaDefinition)criteria);
            logger.debug("qurey........" + query.toString());
            logger.debug("criteria........" + criteria.toString());
            query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
            query.limit(PCHelperConstant.getRestoreQueryLimit());
            query.skip((long)(skipValue * PCHelperConstant.getRestoreQueryLimit()));
            List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
            for (String string : queryTablesList) {
                results = mongoTemplate.find(query, BackUpImage.class, string);
                if (CollectionUtils.isEmpty((Collection)results)) continue;
                list.addAll(results);
            }
            logger.debug("....count of list..." + list.size());
            if (this.isDeviceQueryCheckEnabled(cloudId)) {
                logger.debug("Inside getBackupFilesForGivenPathfromBackupImage for devicequery");
                criteria = new Criteria();
                if (StringUtils.isEmpty((String)devicePath)) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)FOLDER).is((Object)false)});
                } else if (!StringUtils.isEmpty((String)devicePath) && StringUtils.isEmpty((String)fileName)) {
                    if (StringUtils.isEmpty((String)isImmediateFolderLevel)) {
                        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)Pattern.compile(devicePath)), Criteria.where((String)FOLDER).is((Object)false)});
                    } else {
                        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)false)});
                    }
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)FOLDER).is((Object)false)});
                }
                query = new Query((CriteriaDefinition)criteria);
                query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
                query.limit(PCHelperConstant.getRestoreQueryLimit());
                query.skip((long)(skipValue * PCHelperConstant.getRestoreQueryLimit()));
                for (String string : queryTablesList) {
                    results = mongoTemplate.find(query, BackUpImage.class, string);
                    if (CollectionUtils.isEmpty((Collection)results)) continue;
                    list.addAll(results);
                }
            }
            if (modifiedTime != 0L) {
                if (!CollectionUtils.isEmpty(list)) {
                    for (BackUpImage backUpImage : list) {
                        if (backUpImage.getLastServerModifiedTime() > modifiedTime) continue;
                        bkpImages.add(backUpImage);
                    }
                }
            } else {
                bkpImages.addAll(list);
            }
            list = onlyLatestVersion ? this.getFilteredBackupImageList(bkpImages) : this.getFilteredBackupImageListForVersions(bkpImages);
            logger.error("##End getBackupFilesForGivenPathfromBackupImage .........." + list.size());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" Exception while getting filefrom backupimage:" + e.getMessage());
            return null;
        }
        if (!CollectionUtils.isEmpty(list)) {
            logger.debug("final list size :" + list.size());
            return list;
        }
        return new ArrayList<BackUpImage>();
    }

    @Override
    public void deleteRestoredFilesBySkipValue(int cloudId, String userName, String devicePath, long skipValue, String restoreId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"skipValue").is((Object)skipValue)});
        Query query = new Query((CriteriaDefinition)criteria);
        String collectionName = this.getRestoreFileCollectionName(restoreId);
        mongoTemplate.findAllAndRemove(query, RestoredFiles.class, collectionName.toUpperCase());
    }

    private BackupFile convertBkpImageToBackupFile(BackUpImage backUpImage) {
        BackupFile backupFile = new BackupFile();
        if (backUpImage == null || CollectionUtils.isEmpty(backUpImage.getChunkFiles())) {
            return null;
        }
        BeanUtils.copyProperties((Object)backUpImage, (Object)backupFile);
        backupFile.setBackupId(backUpImage.getId());
        backupFile.setFilePath(backUpImage.getDevicePath());
        return backupFile;
    }

    private Device getDeviceForUUId(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    @Override
    public List<BackupFile> getBackupFilesForBackupImageId(String cloudName, String userName, String deviceUUID, int cloudId, Map<String, Long> fileVersionMap, List<ObjectId> backupIds, Map<String, String> md5Map) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        ArrayList<BackupFile> backupFiles = new ArrayList<BackupFile>();
        Bson query = Filters.eq((String)"_id", (Object)new Document("$in", backupIds));
        String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
        tableName = tableName.toUpperCase();
        MongoCollection collection = mongoTemplate.getCollection(tableName);
        FindIterable documents = collection.find((Bson)new Document().append("_id", (Object)new Document("$in", backupIds)));
        long totalCount = 0L;
        for (Document dbObject : documents) {
            BackupFile backupFile = this.getConvertedObject(deviceUUID, dbObject);
            String mapKey = backupFile.getFilePath() + backupFile.getFileName();
            if (fileVersionMap.containsKey(mapKey)) {
                Long versionVal = fileVersionMap.get(mapKey);
                fileVersionMap.remove(mapKey);
                long newVersion = versionVal + 1L;
                fileVersionMap.put(mapKey, newVersion);
                int lastDot = backupFile.getFileName().lastIndexOf(46);
                String newFileName = backupFile.getFileName().substring(0, lastDot) + "(Version-" + newVersion + ")" + backupFile.getFileName().substring(lastDot);
                backupFile.setFileName(newFileName);
            } else {
                fileVersionMap.put(mapKey, 1L);
            }
            String md5CheckSum = md5Map.get(backupFile.getBackupId().toString());
            backupFile.setMd5(md5CheckSum);
            Long clientModifiedTime = this.getClientModifiedTime(backupFile.getBackupId().toString(), mongoTemplate, tableName);
            if (clientModifiedTime != null) {
                backupFile.setUploadedTimestamp(clientModifiedTime);
            }
            backupFiles.add(backupFile);
        }
        return backupFiles;
    }

    @Override
    public List<BackupFile> getLatestBackupFilesForGivenPath(int cloudId, String cloudName, String userName, String deviceUUID, String devicePath, String fileName, int skipValue) {
        ArrayList<BackupFile> backupFiles = new ArrayList<BackupFile>();
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            if (!mongoTemplate.collectionExists(tableName)) {
                mongoTemplate.createCollection(tableName);
            }
            List<Bson> pipeline = BackupFileDaoImpl.criteriaForLatestFiles(deviceUUID, devicePath, fileName, skipValue);
            MongoCollection collection = mongoTemplate.getCollection(tableName);
            AggregateIterable documents = collection.aggregate(pipeline);
            long totalCount = 0L;
            for (Document next : documents) {
                BackupFile backupFile = BackupFileDaoImpl.getConvertedObjectForAggregation(deviceUUID, next);
                backupFiles.add(backupFile);
            }
            logger.error("##End of getting latest files .........." + backupFiles.size());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception while getting latest backupfiles:" + e.getMessage());
        }
        return backupFiles;
    }

    @Override
    public List<BackupFile> getLatestBackupFilesForGivenPathFromBackup(BackupFileQueryElement backupFileQueryElement) {
        int cloudId = backupFileQueryElement.getCloudId();
        String cloudName = backupFileQueryElement.getCloudName();
        String userName = backupFileQueryElement.getUserName();
        String deviceUUID = backupFileQueryElement.getDeviceUUID();
        String devicePath = backupFileQueryElement.getDevicePath();
        String fileName = backupFileQueryElement.getFileName();
        int skipValue = backupFileQueryElement.getSkipValue();
        Map<String, Long> fileVersionMap = backupFileQueryElement.getFileVersionMap();
        List<BackupFile> backupFiles = new ArrayList<BackupFile>();
        try {
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            Device device = this.getDeviceForUUId(cloudId, deviceUUID);
            this.addCriteriaForGivenPAth(userName, devicePath, fileName, criteria, device);
            TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{DEVICE_PATH, "fileName"}).max("lastServerModifiedTime").as("lastServerModifiedTime"), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{DEVICE_PATH, "fileName", "lastServerModifiedTime"}), Aggregation.project((String[])new String[]{DEVICE_PATH, "fileName", "lastServerModifiedTime"}), Aggregation.skip((int)(skipValue * PCHelperConstant.getRestoreQueryLimit())), Aggregation.limit((long)PCHelperConstant.getRestoreQueryLimit())}).withOptions(Aggregation.newAggregationOptions().allowDiskUse(true).build());
            List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
            for (String dest : queryTablesList) {
                MongoCursor<Document> cursor = this.getCursorForPath(mongoTemplate, device, (TypedAggregation<BackUpImage>)aggregation, dest);
                ArrayList<ObjectId> backupIds = new ArrayList<ObjectId>();
                HashMap<String, String> md5Map = new HashMap<String, String>();
                ArrayList<BackupFile> backupFilesList = new ArrayList<BackupFile>();
                while (cursor.hasNext()) {
                    Document dbObject = (Document)cursor.next();
                    BackupFile backupFile = this.getConvertedObjectForBkpImage(cloudId, device, dbObject, true);
                    Long clientModifiedTime = this.getClientModifiedTime(backupFile.getBackupId().toString(), mongoTemplate, dest);
                    if (clientModifiedTime != null) {
                        backupFile.setUploadedTimestamp(clientModifiedTime);
                    }
                    this.getBackupFiles(backupIds, md5Map, backupFilesList, dbObject, backupFile);
                }
                cursor.close();
                logger.error("after backupids size .................. " + backupIds.size());
                backupFiles = this.getBackupFilesForBackupImageId(cloudName, userName, deviceUUID, cloudId, fileVersionMap, backupIds, md5Map);
                backupFiles.addAll(backupFilesList);
            }
            logger.error("##End of getting latest files from Backup .........." + backupFiles.size());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception in latest backup files:" + e.getMessage());
        }
        return backupFiles;
    }

    private MongoCursor<Document> getCursorForPath(MongoTemplate mongoTemplate, Device device, TypedAggregation<BackUpImage> aggregation, String dest) {
        ArrayList<Long> latestTimestamps = new ArrayList<Long>();
        AggregationResults result = mongoTemplate.aggregate(aggregation, dest, Document.class);
        List stateStatsList = result.getMappedResults();
        for (Document dbObject : stateStatsList) {
            latestTimestamps.add((Long)dbObject.get((Object)"lastServerModifiedTime"));
        }
        Document document = new Document();
        String deviceId = device.getId().toString();
        if (!StringUtils.isEmpty((String)deviceId)) {
            document.append(DEVICE_DOLLAR_ID, (Object)new ObjectId(deviceId));
        }
        document.append("lastServerModifiedTime", (Object)new Document("$in", latestTimestamps));
        MongoCollection collection = mongoTemplate.getCollection(dest);
        FindIterable findIterable = collection.find((Bson)document);
        return findIterable.iterator();
    }

    private void getBackupFiles(List<ObjectId> backupIds, Map<String, String> md5Map, List<BackupFile> backupFilesList, Document dbObject, BackupFile backupFile) {
        if (backupFile != null && !CollectionUtils.isEmpty(backupFile.getChunkFiles())) {
            if (dbObject.get((Object)MD5CHECKUM) != null) {
                backupFile.setMd5(dbObject.get((Object)MD5CHECKUM).toString());
            }
            backupFilesList.add(backupFile);
        } else {
            String backupId = dbObject.get((Object)"_id").toString();
            backupIds.add(new ObjectId(backupId));
            if (dbObject.get((Object)MD5CHECKUM) != null) {
                md5Map.put(backupId, dbObject.get((Object)MD5CHECKUM).toString());
            }
        }
    }

    private void addCriteriaForGivenPAth(String userName, String devicePath, String fileName, Criteria criteria, Device device) {
        if (StringUtils.isEmpty((String)devicePath)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)STORAGEPLACE).exists(true)});
        } else if (!StringUtils.isEmpty((String)devicePath) && StringUtils.isEmpty((String)fileName)) {
            Criteria criteria2 = new Criteria();
            criteria2.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)Pattern.compile(devicePath)), Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)DEVICE).is((Object)device), criteria2, Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)STORAGEPLACE).exists(true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)STORAGEPLACE).exists(true)});
        }
    }

    @Override
    public List<BackUpImage> getLatestBackupFilesForGivenPathFromBackupImage(BackupFileQueryElement backupFileQueryElement, String isImmediateFolderLevel, String serverModifiedTime) {
        boolean retry;
        int cloudId = backupFileQueryElement.getCloudId();
        String deviceUUID = backupFileQueryElement.getDeviceUUID();
        String devicePath = backupFileQueryElement.getDevicePath();
        String fileName = backupFileQueryElement.getFileName();
        Device device = this.getDeviceForDeviceUUID(cloudId, deviceUUID);
        long modifiedTime = Long.parseLong(serverModifiedTime);
        int skipValue = backupFileQueryElement.getSkipValue();
        ArrayList<BackUpImage> bkpImages = new ArrayList<BackUpImage>();
        List<BackUpImage> filteredImages = new ArrayList<BackUpImage>();
        int retryCount = 0;
        do {
            retry = false;
            try {
                MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
                mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
                Criteria criteria = new Criteria();
                if (StringUtils.isEmpty((String)devicePath)) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                } else if (!StringUtils.isEmpty((String)devicePath) && StringUtils.isEmpty((String)fileName)) {
                    if (StringUtils.isEmpty((String)isImmediateFolderLevel)) {
                        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)Pattern.compile(devicePath)), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                    } else {
                        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                    }
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                }
                Query query = new Query((CriteriaDefinition)criteria);
                query.limit(10);
                query.skip((long)(skipValue * 10));
                logger.debug("Before executing  query>>>>");
                List backUpImages = mongoTemplate.find(query, BackUpImage.class);
                if (this.isDeviceQueryCheckEnabled(cloudId)) {
                    logger.debug("INSIDE for device query...................");
                    criteria = new Criteria();
                    if (StringUtils.isEmpty((String)devicePath)) {
                        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                    } else if (!StringUtils.isEmpty((String)devicePath) && StringUtils.isEmpty((String)fileName)) {
                        if (StringUtils.isEmpty((String)isImmediateFolderLevel)) {
                            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)Pattern.compile(devicePath)), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                        } else {
                            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT)});
                        }
                    } else {
                        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                    }
                    query = new Query((CriteriaDefinition)criteria);
                    query.limit(10);
                    query.skip((long)(skipValue * 10));
                    backUpImages.addAll(mongoTemplate.find(query, BackUpImage.class));
                }
                filteredImages = this.getFilteredBackupImageList(bkpImages);
                logger.error("##########444NEWWWWWWWEnd of getting latest files from Backup .........." + bkpImages.size());
            }
            catch (Exception e) {
                retry = true;
                ++retryCount;
                logger.debug("insode mongo db exception so sleep and retry######");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e1) {
                    logger.error("InterruptedException while thread sleep" + e1.getMessage());
                    logger.error("InterruptedException while thread sleep" + e1);
                }
                logger.trace("" + e);
                logger.error("Exception while getting latest files :" + e.getMessage());
                if (retryCount != 3) continue;
                return null;
            }
        } while (retry && retryCount < 3);
        return filteredImages;
    }

    private static List<Bson> criteriaForLatestFiles(String deviceUUID, String devicePath, String fileName, int skipValue) {
        Document document = new Document();
        document.append(DEVICE_UUID, (Object)deviceUUID);
        String macOs = MACINTOSH;
        if (!StringUtils.isEmpty((String)devicePath) && !devicePath.startsWith(MACINTOSH)) {
            String devicePathSeparator = "\\\\";
            String devicePathVar = devicePath.replace("/", devicePathSeparator);
            document.append(FILEPATH, (Object)Pattern.compile(devicePathVar));
        }
        if (!StringUtils.isEmpty((String)fileName)) {
            document.append("fileName", (Object)fileName);
        }
        Bson matchQuery = Filters.and((Bson[])new Bson[]{document});
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)document.append("_id", (Object)document.append(FILEPATH, (Object)"$filePath")).append("fileName", (Object)PREFIX_DOLLAR_FILENAME), (BsonField[])new BsonField[]{new BsonField(CHUNKFILES, (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)"$chunkFiles")), new BsonField("oid", (Bson)new Document(PREFIX_DOLLAR_LAST, (Object)"$_id"))}));
        pipeline.add(Aggregates.project((Bson)document.append("_id", (Object)1).append("oid", (Object)1).append(CHUNKFILES, (Object)"$chunkFiles")));
        pipeline.add(Aggregates.skip((int)(skipValue * PCHelperConstant.getRestoreQueryLimit())));
        pipeline.add(Aggregates.limit((int)PCHelperConstant.getRestoreQueryLimit()));
        return pipeline;
    }

    private BackupFile getConvertedObject(String deviceUUID, Document dbObject) {
        BackupFile backupFile = new BackupFile();
        String objectId = dbObject.get((Object)"_id").toString();
        List<com.pg.domain.ChunkFile> chunkFiles = BackupFileDaoImpl.getChunkFiles(dbObject);
        logger.debug("isCompressed>>>" + dbObject.get((Object)COMPRESSED));
        if (dbObject.get((Object)COMPRESSED) != null) {
            backupFile.setCompressed(Boolean.valueOf(dbObject.get((Object)COMPRESSED).toString()));
        }
        backupFile.setId(objectId);
        backupFile.setBackupId(new ObjectId(objectId));
        backupFile.setFileName(dbObject.get((Object)"fileName").toString());
        backupFile.setFilePath(dbObject.get((Object)FILEPATH).toString());
        backupFile.setDeviceUUID(deviceUUID);
        backupFile.setChunkFiles(chunkFiles);
        return backupFile;
    }

    private BackupFile getConvertedObjectForBkpImage(int cloudId, Device device, Document dbObject, boolean getDeletedFilesLatestVersion) {
        BackupFile backupFile = new BackupFile();
        String objectId = dbObject.get((Object)"_id").toString();
        List<com.pg.domain.ChunkFile> chunkFiles = BackupFileDaoImpl.getChunkFiles(dbObject);
        if (CollectionUtils.isEmpty(chunkFiles) && dbObject.get((Object)STORAGEPLACE) != null) {
            logger.debug("chunk list is empty so get chunk from parent file");
            chunkFiles = this.getParentChunks(cloudId, device, dbObject);
            logger.debug("chunk size after getting chunk from parent file:" + chunkFiles.size());
        }
        logger.debug(objectId + "isCompressed>>>" + dbObject.get((Object)COMPRESSED));
        if (dbObject.get((Object)COMPRESSED) != null) {
            backupFile.setCompressed(Boolean.valueOf(dbObject.get((Object)COMPRESSED).toString()));
        }
        backupFile.setId(objectId);
        backupFile.setBackupId(new ObjectId(objectId));
        backupFile.setFileName(dbObject.get((Object)"fileName").toString());
        String fileName = backupFile.getFileName();
        try {
            fileName = URLDecoder.decode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        backupFile.setFileName(fileName);
        if (dbObject.get((Object)DEVICE_PATH) != null) {
            backupFile.setFilePath(dbObject.get((Object)DEVICE_PATH).toString());
        }
        if (dbObject.get((Object)"size") != null) {
            backupFile.setSize(Long.parseLong(dbObject.get((Object)"size").toString()));
        }
        if (dbObject.get((Object)"sizeInBytes") != null && StringUtils.isNotEmpty((String)dbObject.get((Object)"sizeInBytes").toString())) {
            backupFile.setSizeInBytes(Long.parseLong(dbObject.get((Object)"sizeInBytes").toString()));
        }
        if (dbObject.get((Object)"gatewayName") != null) {
            backupFile.setGatewayName(dbObject.get((Object)"gatewayName").toString());
            logger.debug("... gateway name available... " + dbObject.get((Object)"gatewayName").toString());
        }
        backupFile.setDeviceUUID(device.getDeviceUUID());
        if (dbObject.get((Object)"userName") != null) {
            backupFile.setUserName(dbObject.get((Object)"userName").toString());
        }
        backupFile.setChunkFiles(chunkFiles);
        if (dbObject.get((Object)"lastServerModifiedTime") != null) {
            backupFile.setLastServerModifiedTime(Long.parseLong(dbObject.get((Object)"lastServerModifiedTime").toString()));
        }
        if (device.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            backupFile.setMail(Boolean.parseBoolean(dbObject.get((Object)"isMail").toString()));
            if (dbObject.get((Object)"ewsId") != null) {
                backupFile.setEwsId(dbObject.get((Object)"ewsId").toString());
            }
        }
        if (!getDeletedFilesLatestVersion && StringUtils.isNotEmpty((String)dbObject.get((Object)PRESENT).toString())) {
            logger.debug(" ............" + dbObject.get((Object)PRESENT));
            if (!dbObject.get((Object)PRESENT).toString().equalsIgnoreCase("true")) {
                backupFile = null;
            }
        }
        return backupFile;
    }

    private List<com.pg.domain.ChunkFile> getParentChunks(int cloudId, Device device, Document dbObject) {
        BackUpImage parentImage;
        ArrayList<com.pg.domain.ChunkFile> chunkList = new ArrayList<com.pg.domain.ChunkFile>();
        if (dbObject.get((Object)MD5CHECKUM) != null && !StringUtils.isEmpty((String)dbObject.get((Object)MD5CHECKUM).toString()) && (parentImage = this.getParentBackupImageForMd5(cloudId, dbObject.get((Object)MD5CHECKUM).toString(), device)) != null && !CollectionUtils.isEmpty(parentImage.getChunkFiles())) {
            for (ChunkFile chunk : parentImage.getChunkFiles()) {
                com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunk, (Object)chunkFile);
                chunkList.add(chunkFile);
            }
        }
        return chunkList;
    }

    private static BackupFile getConvertedObjectForAggregation(String deviceUUID, Document dbObject) {
        BackupFile backupFile = new BackupFile();
        String objectId = dbObject.get((Object)"oid").toString();
        List<com.pg.domain.ChunkFile> chunkFiles = BackupFileDaoImpl.getChunkFiles(dbObject);
        backupFile.setId(objectId);
        backupFile.setBackupId(new ObjectId(objectId));
        Object object = dbObject.get((Object)"_id");
        String json = JSON.serialize((Object)object);
        DBObject bsonObj = (DBObject)JSON.parse((String)json);
        backupFile.setFileName(bsonObj.get("fileName").toString());
        backupFile.setFilePath(bsonObj.get(FILEPATH).toString());
        backupFile.setDeviceUUID(deviceUUID);
        backupFile.setChunkFiles(chunkFiles);
        if (dbObject.get((Object)COMPRESSED) != null) {
            backupFile.setCompressed(Boolean.valueOf(dbObject.get((Object)COMPRESSED).toString()));
        }
        return backupFile;
    }

    private static List<com.pg.domain.ChunkFile> getChunkFiles(Document dbObject) {
        List list = (List)dbObject.get((Object)CHUNKFILES);
        ArrayList<com.pg.domain.ChunkFile> chunkFiles = new ArrayList<com.pg.domain.ChunkFile>();
        if (CollectionUtils.isEmpty((Collection)list)) {
            logger.error("###PARA chunk list empty.... ");
            return chunkFiles;
        }
        for (Document chunk : list) {
            logger.error("###PARA display chunk .... " + chunk);
            if (chunk == null) continue;
            try {
                com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                if (chunk.get((Object)"fileId") != null) {
                    chunkFile.setFileId(chunk.get((Object)"fileId").toString());
                }
                if (chunk.get((Object)"size") != null) {
                    chunkFile.setSize(Long.parseLong(chunk.get((Object)"size").toString()));
                }
                if (chunk.get((Object)"fileName") != null) {
                    chunkFile.setFileName(chunk.get((Object)"fileName").toString());
                }
                if (chunk.get((Object)"fSPath") != null) {
                    chunkFile.setfSPath(chunk.get((Object)"fSPath").toString());
                }
                if (chunk.get((Object)"uploadedTimeStamp") != null) {
                    chunkFile.setUploadedTimeStamp((Long)chunk.get((Object)"uploadedTimeStamp"));
                }
                if (chunk.get((Object)"md5") != null) {
                    chunkFile.setMd5(chunk.get((Object)"md5").toString());
                }
                if (chunk.get((Object)"cloudStoragePath") != null) {
                    chunkFile.setCloudStoragePath(chunk.get((Object)"cloudStoragePath").toString());
                }
                chunkFiles.add(chunkFile);
            }
            catch (Exception e) {
                logger.error("Exception while getting latest files:" + e.getMessage());
                logger.error("Exception while getting latest files:" + e);
            }
        }
        return chunkFiles;
    }

    @Override
    public BackupFile getBackupFilesForId(int cloudId, String cloudName, String userName, Device device, String backupId, boolean getDeletedFilesLatestVersion) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        BackupFile backupFile = null;
        Document query = new Document("_id", (Object)new ObjectId(backupId));
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        for (String dest : queryTablesList) {
            logger.debug("...trying to download from ..... " + dest);
            MongoCollection backupCollection = mongoTemplate.getCollection(dest);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            backupCollection.withReadPreference(ReadPreference.secondary());
            FindIterable cursor = backupCollection.find((Bson)query);
            for (Document dbObject : cursor) {
                Long clientModifiedTime;
                backupFile = this.getConvertedObjectForBkpImage(cloudId, device, dbObject, getDeletedFilesLatestVersion);
                logger.error(dest + " ##FILEFROM BACKUP..........." + backupFile);
                if (backupFile == null || CollectionUtils.isEmpty(backupFile.getChunkFiles())) continue;
                if (dbObject.get((Object)MD5CHECKUM) != null) {
                    backupFile.setMd5(dbObject.get((Object)MD5CHECKUM).toString());
                }
                if ((clientModifiedTime = Long.valueOf(this.getClientModifiedTime(backupId, mongoTemplate, dest))) == null) break;
                backupFile.setUploadedTimestamp(clientModifiedTime);
                break;
            }
            if (backupFile == null) continue;
            break;
        }
        return backupFile;
    }

    private List<String> getCollectionsForBkpQuery(Device device) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)device.getDestCollection())) {
            queryTablesList.add(device.getDestCollection());
        }
        if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            queryTablesList.add("BACKUP");
        }
        return queryTablesList;
    }

    @Override
    public BackupBatch getBackupBatch(int cloudId, String cloudName, String backupBatchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupBatchId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List backupBatchList = mongoTemplate.find(query, BackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)backupBatchList)) {
            return (BackupBatch)backupBatchList.get(0);
        }
        return null;
    }

    private long getClientModifiedTime(String backupId, MongoTemplate mongoTemplate, String dest) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        Query bkpquery = new Query((CriteriaDefinition)criteria);
        bkpquery.limit(1);
        BackUpImage bkpImage = (BackUpImage)mongoTemplate.findOne(bkpquery, BackUpImage.class, dest);
        Long clientModifiedTime = null;
        if (bkpImage != null) {
            clientModifiedTime = bkpImage.getLastClientModifiedTime();
        }
        return clientModifiedTime;
    }

    @Override
    public BackUpImage getBackupImageForMd5(int cloudId, String md5Checksum) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)MD5CHECKUM).is((Object)md5Checksum), Criteria.where((String)STORAGEPLACE).exists(true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"active").is((Object)true), Criteria.where((String)"backupEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        long count = paracloudMongoTemplate.count(query, User.class);
        ArrayList<User> userList = new ArrayList<User>();
        logger.error("total users ...... " + count);
        int size = 1000;
        int skipValue = 0;
        while (size == 1000) {
            query.skip((long)(skipValue * 1000));
            query.limit(1000);
            List users = paracloudMongoTemplate.find(query, User.class);
            if (!CollectionUtils.isEmpty((Collection)users)) {
                size = users.size();
                userList.addAll(users);
                logger.error(++skipValue + " no of users... " + size);
                continue;
            }
            size = 0;
        }
        userList.removeAll(Collections.singleton(null));
        logger.error(count + " end of user query... " + userList.size());
        return userList;
    }

    @Override
    public List<PrivacyGateway> getAllGateways(int cloudId) {
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAll(PrivacyGateway.class);
    }

    @Override
    public String getDeviceUUIDForId(int cloudId, String cloudName, String userName, String backupID) {
        logger.error(userName + "#$$$$$  inside getting device uuid for backupID>>>" + backupID);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupID)});
        Query query = new Query((CriteriaDefinition)criteria);
        List<String> queryTablesList = this.getAllDestForUser(cloudId, userName);
        String deviceUUID = "";
        for (String dest : queryTablesList) {
            BackUpImage bkpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest);
            if (bkpImage == null) continue;
            deviceUUID = bkpImage.getDeviceUUID();
            break;
        }
        return deviceUUID;
    }

    private List<String> getAllDestForUser(int cloudId, String userName) {
        ArrayList<String> destList = new ArrayList<String>();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = this.getUserInfoByName(cloudId, userName);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)user.getUserName())});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = mongoTemplate.find(query, Device.class);
        for (Device device : list) {
            if (device == null) continue;
            destList.add(device.getDestCollection());
        }
        if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            destList.add("BACKUP");
        }
        return destList;
    }

    public User getUserInfoByName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2)), criteria.orOperator(new Criteria[]{Criteria.where((String)"deleted").is((Object)false), Criteria.where((String)"deleted").exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public BackUpImage getBackupFileForIDOnly(int cloudId, ObjectId backupId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public boolean deleteBackupFileForIDFromReBackup(int cloudId, ObjectId backupId) {
        try {
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
            Query query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.remove(query, ReBackUpImage.class);
            return true;
        }
        catch (MongoException e) {
            logger.error("error in removing the fileinfo form rebackup..." + e.getMessage());
            logger.error("error in removing the fileinfo form rebackup..." + (Object)((Object)e));
            return false;
        }
    }

    private List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        logger.debug("Inside grouping backup images....");
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        for (BackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (!filteredBackUpImage.isPresent()) continue;
            filteredBackUpImagesList.add(filteredBackUpImage);
        }
        return filteredBackUpImagesList;
    }

    private List<BackUpImage> getFilteredBackupImageListForVersions(List<BackUpImage> backUpImages) {
        logger.debug("Inside grouping backup images");
        ArrayList iterateList = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        Map<String, Map<String, Map<Long, List<BackUpImage>>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName, Collectors.groupingBy(BackUpImage::getLastServerModifiedTime))));
        for (Map.Entry<String, Map<String, Map<Long, List<BackUpImage>>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> ((Map)p.getValue()).entrySet().stream().forEach(k -> iterateList.add(((List)k.getValue()).stream().findFirst().get())));
        }
        for (BackUpImage filteredBackUpImage : iterateList) {
            if (!filteredBackUpImage.isPresent()) continue;
            filteredBackUpImagesList.add(filteredBackUpImage);
        }
        return filteredBackUpImagesList;
    }

    public boolean isDeviceQueryCheckEnabled(int cloudId) {
        List cloudProps = this.mongoOps.findAll(CloudProperties.class);
        if (cloudProps != null && !cloudProps.isEmpty()) {
            return ((CloudProperties)cloudProps.get(0)).isDeviceQueryCheckEnabled();
        }
        return false;
    }

    @Override
    public BackUpImage getParentBackupImageForMd5(int cloudId, String md5Checksum, Device device) {
        String dest;
        List backupImageList;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)MD5CHECKUM).is((Object)md5Checksum)});
        Query query = new Query((CriteriaDefinition)criteria);
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        BackUpImage backUpImage = new BackUpImage();
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && ((backUpImage = (BackUpImage)(backupImageList = mongoTemplate.find(query, BackUpImage.class, dest = iterator.next())).stream().filter(bkpImage -> !StringUtils.isEmpty((String)bkpImage.getStoragePlace()) && !CollectionUtils.isEmpty(bkpImage.getChunkFiles())).findFirst().orElse(null)) == null || CollectionUtils.isEmpty(backUpImage.getChunkFiles()))) {
        }
        return backUpImage;
    }

    @Override
    public BackUpImage getBkpFileByIdAndDevice(int cloudId, ObjectId backupId, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, device.getDestCollection());
    }

    @Override
    public void saveImageToBackUp(int cloudId, BackUpImage backUpImage, Device device) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (StringUtils.isNotEmpty((String)device.getDestCollection())) {
            mongoTemplate.save((Object)backUpImage, device.getDestCollection());
        }
    }

    @Override
    public List<BackUpImage> getBaseFoldersForDevice(int cloudId, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)DEVICE_PATH).exists(false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class, device.getDestCollection());
    }

    public List<BackUpImage> getRestBackupFilesForGivenPathfromBackupImage(BackupFileQueryElement backupFileQueryElement, String isImmediateFolderLevel, Device device, boolean onlyLatestVersion, String serverModifiedTime) {
        List<Object> list = new ArrayList();
        ArrayList<BackUpImage> bkpImages = new ArrayList<BackUpImage>();
        long modifiedTime = 0L;
        if (!org.springframework.util.StringUtils.isEmpty((Object)serverModifiedTime)) {
            modifiedTime = Long.parseLong(serverModifiedTime);
        }
        logger.debug("Restore based on time stamp .................... " + modifiedTime);
        int cloudId = backupFileQueryElement.getCloudId();
        String deviceUUID = backupFileQueryElement.getDeviceUUID();
        int skipValue = backupFileQueryElement.getSkipValue();
        String devicePath = backupFileQueryElement.getDevicePath();
        String fileName = backupFileQueryElement.getFileName();
        try {
            List results;
            logger.debug("RESTORE-QUERY ..getBackupFilesForGivenPathfromBackupImage..........");
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            Criteria criteria = new Criteria();
            if (StringUtils.isEmpty((String)devicePath)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
            } else if (!StringUtils.isEmpty((String)devicePath) && StringUtils.isEmpty((String)fileName)) {
                if (StringUtils.isEmpty((String)isImmediateFolderLevel)) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)Pattern.compile(devicePath)), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                }
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
            }
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
            query.limit(PCHelperConstant.getRestoreQueryLimit());
            query.skip((long)(skipValue * PCHelperConstant.getRestoreQueryLimit()));
            List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
            for (String string : queryTablesList) {
                results = mongoTemplate.find(query, BackUpImage.class, string);
                if (CollectionUtils.isEmpty((Collection)results)) continue;
                list.addAll(results);
            }
            logger.debug("....count of list..." + list.size());
            logger.debug("....count of list after ..." + list.size());
            if (this.isDeviceQueryCheckEnabled(cloudId)) {
                logger.debug("Inside getBackupFilesForGivenPathfromBackupImage for devicequery");
                criteria = new Criteria();
                if (StringUtils.isEmpty((String)devicePath)) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                } else if (!StringUtils.isEmpty((String)devicePath) && StringUtils.isEmpty((String)fileName)) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
                }
                query = new Query((CriteriaDefinition)criteria);
                query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
                query.limit(PCHelperConstant.getRestoreQueryLimit());
                query.skip((long)(skipValue * PCHelperConstant.getRestoreQueryLimit()));
                for (String string : queryTablesList) {
                    results = mongoTemplate.find(query, BackUpImage.class, string);
                    if (CollectionUtils.isEmpty((Collection)results)) continue;
                    list.addAll(results);
                }
            }
            if (modifiedTime != 0L) {
                if (!CollectionUtils.isEmpty(list)) {
                    for (BackUpImage backUpImage : list) {
                        if (backUpImage.getLastServerModifiedTime() > modifiedTime) continue;
                        bkpImages.add(backUpImage);
                    }
                }
            } else {
                bkpImages.addAll(list);
            }
            list = onlyLatestVersion ? this.getFilteredBackupImageList(bkpImages) : this.getFilteredBackupImageListForVersions(bkpImages);
            logger.error("##End getBackupFilesForGivenPathfromBackupImage ..........");
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" Exception while getting filefrom backupimage:" + e.getMessage());
            return null;
        }
        if (!CollectionUtils.isEmpty(list)) {
            logger.debug("final list size :" + list.size());
            return list;
        }
        return new ArrayList<BackUpImage>();
    }

    @Override
    public List<BackUpImage> getAllVersionsFromBackupImage(int cloudId, String devicePath, String fileName, Device device) {
        List<BackUpImage> list = new ArrayList<BackUpImage>();
        logger.debug("Restore based on time stamp .................... ");
        String deviceUUID = device.getDeviceUUID();
        try {
            logger.debug("RESTORE-QUERY ..getAllVersionsFromBackupImage..........");
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
            List results = mongoTemplate.find(query, BackUpImage.class, device.getDestCollection());
            if (!CollectionUtils.isEmpty((Collection)results)) {
                list.addAll(results);
            }
            logger.debug("....count of list..." + list.size());
            list = this.getFilteredBackupImageListForVersions(list);
            logger.error("##End getBackupFilesForGivenPathfromBackupImage ..........");
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" Exception while getting filefrom backupimage:" + e.getMessage());
            return list;
        }
        return list;
    }

    @Override
    public RestoredFiles getRestoredFiles(int cloudId, String userName, String devicePath, String fileName, String restoreId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"fileName").is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        String collectionName = this.getRestoreFileCollectionName(restoreId);
        return (RestoredFiles)mongoTemplate.findOne(query, RestoredFiles.class, collectionName.toUpperCase());
    }

    private String getRestoreFileCollectionName(String restoreId) {
        String collectionName = "RESTORE_" + restoreId;
        return collectionName;
    }

    @Override
    public void saveRestoredFiles(int cloudId, RestoredFiles restoredFiles, String restoreId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String collectionName = this.getRestoreFileCollectionName(restoreId);
        mongoTemplate.save((Object)restoredFiles, collectionName.toUpperCase());
    }

    @Override
    public List<RestoreBackUpImage> getBaseFoldersForDeviceLatest(int cloudId, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)DEVICE_PATH).exists(false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, RestoreBackUpImage.class, device.getDestCollection());
    }
}

