/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.paracloud.util;

import com.parablu.helper.utils.MD5Generator;
import com.parablu.paracloud.constant.PCHelperConstant;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ParacloudUtils {
    private static Logger logger = LogManager.getLogger(ParacloudUtils.class);

    private ParacloudUtils() {
    }

    public static String getLocalIP() {
        StringBuilder localIp = new StringBuilder();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            block2: while (en.hasMoreElements()) {
                NetworkInterface networkInterface = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = networkInterface.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                    localIp.append(inetAddress.getHostAddress());
                    if (localIp.length() <= 0) continue;
                    continue block2;
                }
            }
        }
        catch (SocketException ex) {
            logger.debug("SocketException " + ex);
            logger.debug("Exception", (Throwable)ex);
            return localIp.toString();
        }
        return localIp.toString();
    }

    public static String getPublicIP() {
        StringBuilder publicIp = new StringBuilder();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            block2: while (en.hasMoreElements()) {
                NetworkInterface networkInterface = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = networkInterface.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                    publicIp.append(inetAddress.getHostAddress());
                    if (publicIp.length() <= 0) continue;
                    continue block2;
                }
            }
        }
        catch (SocketException ex) {
            logger.debug("SocketException " + ex);
            logger.debug("Exception", (Throwable)ex);
            return publicIp.toString();
        }
        return publicIp.toString();
    }

    public static void saveCloudName(String cloudName) {
        File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "cloudName");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                logger.debug("Exception", (Throwable)ex);
            }
        }
        BufferedWriter out = null;
        try (FileWriter fstream = new FileWriter(file, false);){
            out = new BufferedWriter(fstream);
            out.write(cloudName);
        }
        catch (IOException ex) {
            logger.debug("Exception", (Throwable)ex);
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ex) {
            logger.debug("Exception", (Throwable)ex);
        }
    }

    public static String parseFileExtention(String fileName) {
        int fileIndex = fileName.lastIndexOf(46);
        if (fileIndex != -1) {
            return fileName.substring(fileIndex);
        }
        return "unknown";
    }

    public static String generateToken(String randomKey, char uniqueKey, char uniqueKeyReplace, int randomInteger) {
        String randomStringToken = MD5Generator.generateMD5OfString(randomKey).replace(uniqueKey, uniqueKeyReplace);
        for (int i = 0; i < randomInteger; ++i) {
            randomStringToken = MD5Generator.generateMD5OfString(randomStringToken);
        }
        return randomStringToken;
    }
}

