/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.paracloud.util;

import com.parablu.paracloud.element.ClientUpgradeRequestElement;
import com.parablu.paracloud.element.CloudAndHostMachineDataElement;
import com.parablu.paracloud.element.CloudInformationElement;
import com.parablu.paracloud.element.CloudRegistrationElement;
import com.parablu.paracloud.element.LicenseElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.paracloud.element.UpgradeRequestElement;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JaxBSerializerHelper {
    private static Logger logger = LogManager.getLogger(JaxBSerializerHelper.class);

    private JaxBSerializerHelper() {
    }

    public static String marshallMiniCloudElementList(MiniCloudElementList cloudElement) throws IOException {
        String outputXml = null;
        try (StringWriter stringwriter = new StringWriter();){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MiniCloudElementList.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)cloudElement, (Writer)stringwriter);
            outputXml = stringwriter.toString();
        }
        catch (JAXBException e) {
            logger.debug("Exception", (Throwable)e);
            return null;
        }
        return outputXml;
    }

    public static String marshallCloudAndHostMachineDataElement(CloudAndHostMachineDataElement cloudElement) throws IOException {
        String outputXml = null;
        try (StringWriter stringwriter = new StringWriter();){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CloudAndHostMachineDataElement.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)cloudElement, (Writer)stringwriter);
            outputXml = stringwriter.toString();
        }
        catch (JAXBException e) {
            logger.debug("Exception", (Throwable)e);
            return null;
        }
        return outputXml;
    }

    public static String unmarshallCloudAndHostMachineDataElement(CloudAndHostMachineDataElement cloudElement) {
        return null;
    }

    public static LicenseElement unmarshallLicenseElement(String licenseElementString) {
        LicenseElement licenseElement = null;
        try (StringReader stringReader = new StringReader(licenseElementString);){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{LicenseElement.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            licenseElement = (LicenseElement)unmarshaller.unmarshal((Reader)stringReader);
        }
        catch (JAXBException e) {
            logger.debug("Exception", (Throwable)e);
            return null;
        }
        if (licenseElement == null) {
            return new LicenseElement();
        }
        return licenseElement;
    }

    public static CloudRegistrationElement unmarshallCloudRegistrationElement(String registrationElementString) {
        CloudRegistrationElement regElement = null;
        try (StringReader stringReader = new StringReader(registrationElementString);){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CloudRegistrationElement.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            regElement = (CloudRegistrationElement)unmarshaller.unmarshal((Reader)stringReader);
        }
        catch (JAXBException e) {
            logger.debug("Exception", (Throwable)e);
            return null;
        }
        if (regElement == null) {
            return new CloudRegistrationElement();
        }
        return regElement;
    }

    public static String marshallCloudInformationElement(CloudInformationElement cloudInformationElement) {
        String outputXml = null;
        try (StringWriter stringwriter = new StringWriter();){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CloudInformationElement.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)cloudInformationElement, (Writer)stringwriter);
            outputXml = stringwriter.toString();
        }
        catch (IOException | JAXBException e) {
            logger.debug("Exception", e);
            return null;
        }
        return outputXml;
    }

    public static String marshallUpgradeRequestElement(UpgradeRequestElement upgradeRequestElement) throws IOException {
        String outputXml = null;
        try (StringWriter stringwriter = new StringWriter();){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{UpgradeRequestElement.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)upgradeRequestElement, (Writer)stringwriter);
            outputXml = stringwriter.toString();
        }
        catch (JAXBException e) {
            logger.debug("Exception", (Throwable)e);
            return null;
        }
        return outputXml;
    }

    public static UpgradeRequestElement unmarshallUpgradeRequestElement(String upgradeElementString) {
        UpgradeRequestElement upgradeElement = null;
        try (StringReader stringReader = new StringReader(upgradeElementString);){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{UpgradeRequestElement.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            upgradeElement = (UpgradeRequestElement)unmarshaller.unmarshal((Reader)stringReader);
        }
        catch (JAXBException e) {
            logger.debug("Exception", (Throwable)e);
            return null;
        }
        if (upgradeElement == null) {
            return new UpgradeRequestElement();
        }
        return upgradeElement;
    }

    public static ClientUpgradeRequestElement unMarshallClientUpgradeRequestElement(String clientUpgradeElementString) {
        ClientUpgradeRequestElement upgradeElement = null;
        try (StringReader stringReader = new StringReader(clientUpgradeElementString);){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ClientUpgradeRequestElement.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            upgradeElement = (ClientUpgradeRequestElement)unmarshaller.unmarshal((Reader)stringReader);
        }
        catch (JAXBException e) {
            logger.debug("Exception", (Throwable)e);
            return null;
        }
        if (upgradeElement == null) {
            return new ClientUpgradeRequestElement();
        }
        return upgradeElement;
    }

    public static String marshallClientUpgradeRequestElement(ClientUpgradeRequestElement clientUpgradeRequestElement) throws IOException {
        String outputXml = null;
        try (StringWriter stringwriter = new StringWriter();){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ClientUpgradeRequestElement.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)clientUpgradeRequestElement, (Writer)stringwriter);
            outputXml = stringwriter.toString();
        }
        catch (JAXBException e) {
            logger.debug("Exception", (Throwable)e);
            return null;
        }
        return outputXml;
    }
}

