/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.paracloud.util;

import com.parablu.paracloud.element.EmailTemplate;
import com.parablu.paracloud.element.EmailTemplateList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.CollectionUtils;

public class EmailCacher {
    private static Logger logger = LogManager.getLogger(EmailCacher.class);
    public static final String EMAILS_XML_PATH = "/hbm-mapping/emails.xml";
    public static Map<String, EmailTemplate> emails = null;

    private EmailCacher() {
    }

    public static void reloadTemplates() {
        List<EmailTemplate> temaplates = EmailCacher.getTemplates(EMAILS_XML_PATH);
        for (EmailTemplate e : temaplates) {
            logger.debug("Action Loaded :   : " + e.getAction());
            emails.put(e.getAction(), e);
        }
    }

    public static List<EmailTemplate> getTemplates(String templateFilePath) {
        try {
            EmailTemplateList list;
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EmailTemplateList.class, EmailTemplate.class});
            Unmarshaller um = context.createUnmarshaller();
            ClassPathResource resource = new ClassPathResource(templateFilePath);
            if (templateFilePath.equalsIgnoreCase(EMAILS_XML_PATH)) {
                list = (EmailTemplateList)um.unmarshal((Reader)new FileReader(resource.getFile().getAbsolutePath()));
            } else {
                File customTemplateFile = new File(templateFilePath);
                list = (EmailTemplateList)um.unmarshal((Reader)new FileReader(customTemplateFile));
            }
            if (list != null && !list.getTemplates().isEmpty()) {
                logger.debug("List size retrived " + list.getTemplates().size());
                emails = new HashMap<String, EmailTemplate>();
                List<EmailTemplate> templates = list.getTemplates();
                return templates;
            }
            logger.debug("$$$EMAIL NOT LOADED null values");
        }
        catch (FileNotFoundException e) {
            logger.trace(" File Not FoundException  :" + e);
            logger.error(" File Not FoundException  :" + e.getMessage());
        }
        catch (IOException e) {
            logger.trace(" IOException  :" + e);
            logger.error(" IOException  :" + e.getMessage());
        }
        catch (JAXBException e) {
            logger.trace(" JAXB Exception  :" + (Object)((Object)e));
            logger.error(" JAXB Exception  :" + e.getMessage());
        }
        return new ArrayList<EmailTemplate>();
    }

    public static void reloadTemplates(List<EmailTemplate> temaplates) {
        EmailCacher.reloadTemplates();
        if (!CollectionUtils.isEmpty(temaplates)) {
            temaplates.parallelStream().forEach(template -> emails.put(template.getAction(), (EmailTemplate)template));
        } else {
            logger.debug("No custom template specified");
        }
    }
}

