/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.paracloud.util;

import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.util.CacheHelper;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiskSpaceHelper {
    private static Logger logger = LogManager.getLogger(DiskSpaceHelper.class);
    private static CacheHelper diskSpaceMap = null;

    private DiskSpaceHelper() {
    }

    public static boolean isEnoughSpaceAvailable(String cloudName) {
        long totalSpaceBytes;
        File root = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long usableSpaceInKB = root.getFreeSpace();
        return !((double)usableSpaceInKB <= 0.1 * (double)(totalSpaceBytes = root.getTotalSpace()));
    }

    public static boolean isEnoughSpaceAvailable(String cloudName, long sizeOfFileToUploadInBytes) {
        File root = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long usableSpaceInKB = root.getFreeSpace() - sizeOfFileToUploadInBytes;
        long totalSpaceBytes = root.getTotalSpace();
        return usableSpaceInKB > 0L && !((double)usableSpaceInKB <= 0.1 * (double)totalSpaceBytes);
    }

    public static boolean isEnoughSpaceAvailable(String cloudName, long sizeOfFileToUploadInBytes, long allowedDiskSpaceInBytes) {
        File root = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long usableSpaceInKB = root.getFreeSpace() - sizeOfFileToUploadInBytes;
        long totalSpaceBytes = root.getTotalSpace();
        if (usableSpaceInKB <= 0L || (double)usableSpaceInKB <= 0.1 * (double)totalSpaceBytes) {
            logger.error(root.getFreeSpace() + " @@FAILED-IN-FIRST-CHECK ......... " + sizeOfFileToUploadInBytes);
            logger.error(totalSpaceBytes + " @@FAILED-IN-FIRST-CHECK ......... ");
            return false;
        }
        Long cachedDiskSpace = diskSpaceMap.getCachedDiskSpace(cloudName);
        if (cachedDiskSpace > allowedDiskSpaceInBytes) {
            logger.error(root.getFreeSpace() + " @@FAILED-IN-SECOND-CHECK ......... " + sizeOfFileToUploadInBytes);
            logger.error(totalSpaceBytes + "@@FAILED-IN-SECOND-CHECK ......... ");
            return false;
        }
        return true;
    }

    public static long spaceUsedInKB(String cloudName) {
        return diskSpaceMap.getCachedDiskSpace(cloudName) / 1024L;
    }

    public static long spaceUsedInMB(String cloudName) {
        return diskSpaceMap.getCachedDiskSpace(cloudName) / 1024L / 1024L;
    }

    public static Long spaceUsed(String cloudName) {
        return diskSpaceMap.getCachedDiskSpace(cloudName);
    }

    public static long updateCloudSize(String cloudName, int typeOfSizeChange, long sizeOfFileMoved) {
        switch (typeOfSizeChange) {
            case 2: {
                return DiskSpaceHelper.updateSizeFileAddedToCloud(cloudName, sizeOfFileMoved);
            }
            case 0: {
                return DiskSpaceHelper.updateSizeFileDeletedCompletelyFromTrash(cloudName, sizeOfFileMoved);
            }
            case 1: {
                return DiskSpaceHelper.updateSizeFileDeletedCompletelyFromParablu(cloudName, sizeOfFileMoved);
            }
            case 3: {
                return DiskSpaceHelper.updateSizeFileMovedToTrash(cloudName, sizeOfFileMoved);
            }
            case 4: {
                return DiskSpaceHelper.updateSizeFileRestoredFromTrash(cloudName, sizeOfFileMoved);
            }
        }
        return DiskSpaceHelper.spaceUsed(cloudName);
    }

    private static long updateSizeFileMovedToTrash(String cloudName, long sizeOfFileMoved) {
        return diskSpaceMap.getCachedDiskSpace(cloudName);
    }

    private static long updateSizeFileDeletedCompletelyFromTrash(String cloudName, long sizeOfFileMoved) {
        return diskSpaceMap.decrCachedDiskSpace(cloudName, sizeOfFileMoved);
    }

    private static long updateSizeFileDeletedCompletelyFromParablu(String cloudName, long sizeOfFileMoved) {
        return diskSpaceMap.decrCachedDiskSpace(cloudName, sizeOfFileMoved);
    }

    private static long updateSizeFileAddedToCloud(String cloudName, long sizeOfFileMoved) {
        return diskSpaceMap.incrCachedDiskSpace(cloudName, sizeOfFileMoved);
    }

    private static long updateSizeFileRestoredFromTrash(String cloudName, long sizeOfFileMoved) {
        return diskSpaceMap.getCachedDiskSpace(cloudName);
    }

    public static long forceReinitialiseDiskSpace(String cloudName, long size1) {
        long size = size1;
        Long oldUsedDiskspace = diskSpaceMap.getCachedDiskSpace(cloudName);
        if (oldUsedDiskspace == null) {
            diskSpaceMap.putCachedDiskSpace(cloudName, size);
        } else {
            long diff = size - oldUsedDiskspace;
            size = diff > 0L ? diskSpaceMap.incrCachedDiskSpace(cloudName, diff) : diskSpaceMap.decrCachedDiskSpace(cloudName, -diff);
        }
        return size;
    }

    static {
        try {
            diskSpaceMap = new CacheHelper();
        }
        catch (IOException e) {
            logger.debug((Object)e);
        }
    }
}

