/*
 * Decompiled with CFR 0.152.
 */
package com.parablu;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FilesSizes {
    private static final int ENTRIES_PER_SHEET = 50;

    public static void main(String[] args) {
        if (args.length == 1) {
            String folderPath = args[0];
            Path folder = Paths.get(folderPath, new String[0]);
            if (Files.exists(folder, new LinkOption[0]) && Files.isDirectory(folder, new LinkOption[0])) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (XSSFWorkbook workbook = new XSSFWorkbook();){
                        Sheet sheet = workbook.createSheet("File Information");
                        Sheet errorSheet = workbook.createSheet("Error Log");
                        Row headerRow = sheet.createRow(0);
                        headerRow.createCell(0).setCellValue("Filename");
                        headerRow.createCell(1).setCellValue("Folder Path");
                        headerRow.createCell(2).setCellValue("Size");
                        Row errorHeaderRow = errorSheet.createRow(0);
                        errorHeaderRow.createCell(0).setCellValue("Folder Path");
                        errorHeaderRow.createCell(1).setCellValue("File Name");
                        Files.walkFileTree(folder, new FileVisitor(folder, sheet, errorSheet));
                        try {
                            Throwable throwable2 = null;
                            Object var11_16 = null;
                            try (FileOutputStream outputStream = new FileOutputStream("FileInformation.xlsx");){
                                workbook.write(outputStream);
                                System.out.println("Excel file created successfully.");
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (IOException e) {
                            System.out.println("Error occurred while creating the Excel file.");
                            e.printStackTrace();
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    System.out.println("Error occurred while processing the folder: " + folderPath);
                    e.printStackTrace();
                }
            } else {
                System.out.println("Invalid folder path or the folder does not exist.");
            }
        } else {
            System.out.println("Please provide the folder path");
        }
    }

    private static String convertSize(long size) {
        String[] units = new String[]{"B", "KB", "MB", "GB"};
        int unitIndex = 0;
        double fileSize = size;
        while (fileSize >= 1024.0 && unitIndex < units.length - 1) {
            fileSize /= 1024.0;
            ++unitIndex;
        }
        return String.format("%.2f %s", fileSize, units[unitIndex]);
    }

    private static Sheet createNewSheet(Workbook workbook, String sheetName) {
        Sheet newSheet = workbook.createSheet(sheetName);
        Row headerRow = newSheet.createRow(0);
        headerRow.createCell(0).setCellValue("Filename");
        headerRow.createCell(1).setCellValue("Folder Path");
        headerRow.createCell(2).setCellValue("Size");
        return newSheet;
    }

    private static class FileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path rootFolder;
        private final Sheet sheet;
        private final Sheet errorSheet;
        private int entryCount;
        private int sheetCount;
        private Sheet currentSheet;
        private int rowIndex;
        private int errorRowIndex;

        public FileVisitor(Path rootFolder, Sheet sheet, Sheet errorSheet) {
            this.rootFolder = rootFolder;
            this.sheet = sheet;
            this.errorSheet = errorSheet;
            this.entryCount = 0;
            this.sheetCount = 1;
            this.currentSheet = sheet;
            this.rowIndex = 1;
            this.errorRowIndex = 1;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (attrs.isRegularFile()) {
                try {
                    Row dataRow = this.currentSheet.createRow(this.rowIndex++);
                    dataRow.createCell(0).setCellValue(file.getFileName().toString());
                    dataRow.createCell(1).setCellValue(this.rootFolder.toString());
                    dataRow.createCell(2).setCellValue(FilesSizes.convertSize(attrs.size()));
                    ++this.entryCount;
                    if (this.entryCount >= 50) {
                        this.currentSheet = FilesSizes.createNewSheet(this.sheet.getWorkbook(), "File Information " + ++this.sheetCount);
                        this.rowIndex = 1;
                        this.entryCount = 0;
                    }
                }
                catch (Exception e) {
                    Row errorRow = this.errorSheet.createRow(this.errorRowIndex++);
                    errorRow.createCell(0).setCellValue(this.rootFolder.toString());
                    errorRow.createCell(1).setCellValue(file.getFileName().toString());
                    System.out.println("Error occurred while processing the file: " + file);
                    e.printStackTrace();
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

