/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.springboot.repository;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.OldOfficeBackupPolicy;
import com.parablu.pcbd.domain.OldUser;
import com.parablu.pcbd.domain.User;
import com.parablu.springboot.repository.OfficeBackupPolicyRepository;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class OfficeBackupPolicyRepositoryImpl
implements OfficeBackupPolicyRepository {
    public String getDatabaseName() {
        return "parablu001";
    }

    public MongoDatabaseFactory mongoDbFactory(String mongoMainIP, String mongoMainPort) {
        return new SimpleMongoClientDatabaseFactory("mongodb://neil:parablu@" + mongoMainIP + ":" + mongoMainPort + "/parablu001");
    }

    public MongoTemplate mongoTemplate(String mongoMainIP, String mongoMainPort) {
        return new MongoTemplate(this.mongoDbFactory(mongoMainIP, mongoMainPort));
    }

    public MongoClient mongoClient() {
        MongoCredential credential = MongoCredential.createCredential((String)"neil", (String)this.getDatabaseName(), (char[])"parablu".toCharArray());
        MongoClientOptions options = MongoClientOptions.builder().build();
        MongoClient client = new MongoClient(Arrays.asList(new ServerAddress("localhost", 48765), new ServerAddress("localhost", 48765), new ServerAddress("localhost", 48765)), credential, options);
        return client;
    }

    public MongoDatabaseFactory mongoDbFactory() {
        return new SimpleMongoClientDatabaseFactory("mongodb://neil:parablu@localhost:48765/parablu001");
    }

    public MongoTemplate mongoTemplate() {
        return new MongoTemplate(this.mongoDbFactory());
    }

    public List<OldOfficeBackupPolicy> loadAll() {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        return mongoTemplate.findAll(OldOfficeBackupPolicy.class);
    }

    public OfficeBackupPolicy getNewPolicy(String policyName) {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        return (OfficeBackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), OfficeBackupPolicy.class);
    }

    public List<OldUser> getAllUsersForPolicyName(String policyName) {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"odbPolicyName").is((Object)policyName)});
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), OldUser.class);
    }

    public void saveUser(User user) {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        mongoTemplate.save((Object)user);
    }

    public void saveNewPolicy(OfficeBackupPolicy newPolicy, String mongoMainIP, String mongoMainPort) {
        MongoTemplate mongoTemplate = this.mongoTemplate(mongoMainIP, mongoMainPort);
        mongoTemplate.save((Object)newPolicy);
    }

    public DeviceBackupOverView getDeviceBkpOverview(String policyName, String name, String mongoMainIP, String mongoMainPort) {
        MongoTemplate mongoTemplate = this.mongoTemplate(mongoMainIP, mongoMainPort);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)name), Criteria.where((String)"odbPolicyName").is((Object)policyName)});
        return (DeviceBackupOverView)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), DeviceBackupOverView.class);
    }

    public void saveOverView(DeviceBackupOverView backupOverView) {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        mongoTemplate.save((Object)backupOverView);
    }

    public Device getDeviceForUUID(String deviceUUID, String mongoMainIP, String mongoMainPort) {
        MongoTemplate mongoTemplate = this.mongoTemplate(mongoMainIP, mongoMainPort);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        return (Device)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), Device.class);
    }
}

