/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.springboot;

import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.springboot.repository.CloudRepository;
import com.parablu.springboot.repository.MainParaBluMsgRepository;
import com.parablu.springboot.repository.OfficeBackupPolicyRepository;
import com.parablu.springboot.repository.ParaBluMsgRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.data.mongo.MongoRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.util.CollectionUtils;

@SpringBootApplication
@EnableAutoConfiguration(exclude={MongoAutoConfiguration.class, MongoRepositoriesAutoConfiguration.class, MongoDataAutoConfiguration.class})
public class ExistingUpgradeLatest
implements CommandLineRunner {
    @Autowired
    OfficeBackupPolicyRepository officeBackupPolicyRepo;
    @Autowired
    CloudRepository cloudRepository;
    @Autowired
    ParaBluMsgRepository paraBluMsgRepository;
    @Autowired
    MainParaBluMsgRepository mainParaBluMsgRepository;

    public static void main(String[] args) {
        SpringApplication.run(ExistingUpgradeLatest.class, (String[])args);
    }

    public void run(String ... args) {
        System.out.println(".....started.....");
        PropertiesConfiguration config = null;
        try {
            config = new PropertiesConfiguration(args[0]);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        String mongoMainIP = config.getProperty("mongoMainIP").toString();
        String mongoMainPort = config.getProperty("mongoMainPort").toString();
        if (StringUtils.isEmpty((CharSequence)mongoMainIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoMainPort);
        Set loadAllCollectionNames = this.paraBluMsgRepository.loadAllCollectionNames(mongoMainPort);
        ArrayList<String> batchNames = new ArrayList<String>();
        for (String collecName : loadAllCollectionNames) {
            System.out.println("....collectname...." + collecName);
            if (!collecName.startsWith("BACKUP_BATCH_")) continue;
            batchNames.add(collecName);
        }
        for (String batchdb : batchNames) {
            System.out.println("....testing....." + batchdb);
            List odbBackupBatchs = this.paraBluMsgRepository.loadAll(batchdb, mongoMainPort);
            if (!CollectionUtils.isEmpty((Collection)odbBackupBatchs)) {
                System.out.println("....odbBackupBatchs....." + odbBackupBatchs.size());
                for (ODBBackupBatch backupBatch : odbBackupBatchs) {
                    String newDbName;
                    String oldDbName;
                    System.out.println(batchdb + "...batch..." + backupBatch.getUserName());
                    Device device = this.officeBackupPolicyRepo.getDeviceForUUID(backupBatch.getDeviceUUID(), mongoMainIP, mongoMainPort);
                    if (device == null) continue;
                    System.out.println(device.getDeviceType() + "...device not null..." + backupBatch.getDeviceUUID());
                    if (Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(device.getDeviceType())) {
                        oldDbName = batchdb;
                        newDbName = batchdb;
                        newDbName = batchdb.replaceAll("BACKUP_BATCH_", "");
                        newDbName = "BACKUP_BATCH_ODB_" + newDbName;
                        System.out.println(backupBatch.getId().toString() + "...device not null..." + newDbName);
                        System.out.println(mongoMainPort + "...device not null..." + mongoMainIP);
                        this.mainParaBluMsgRepository.saveBatch(backupBatch, newDbName, mongoMainIP, mongoMainPort);
                        this.paraBluMsgRepository.removeBatch(backupBatch, oldDbName, mongoMainPort);
                        continue;
                    }
                    if (!Device.TYPE.OUTLOOK.toString().equalsIgnoreCase(device.getDeviceType())) continue;
                    oldDbName = batchdb;
                    newDbName = batchdb;
                    newDbName = batchdb.replaceAll("BACKUP_BATCH_", "");
                    newDbName = "BACKUP_BATCH_EX_" + newDbName;
                    this.mainParaBluMsgRepository.saveBatch(backupBatch, newDbName, mongoMainIP, mongoMainPort);
                    this.paraBluMsgRepository.removeBatch(backupBatch, oldDbName, mongoMainPort);
                }
                continue;
            }
            System.out.println("....emptyodbBackupBatchs.....");
        }
        boolean mainMachine = false;
        try {
            Scanner scanner = new Scanner(new File("/parablu-scripts/Installable/config/parablu_config.sh"));
            while (scanner.hasNextLine()) {
                String nextLine = scanner.nextLine();
                System.out.println(".....script lines....." + nextLine);
                if (StringUtils.isEmpty((CharSequence)nextLine) || !nextLine.equalsIgnoreCase("SERVER_TYPE=\"0\"")) continue;
                mainMachine = true;
            }
            scanner.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!mainMachine) {
            this.paraBluMsgRepository.updateAllDeltaPath(mongoMainIP, mongoMainPort);
        }
        System.out.println(".....completed...." + mainMachine);
        System.exit(0);
    }
}

