/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.backupmigrateutility.dao;

import com.parablu.backupmigrateutility.dao.CMMigrationMetaDataDao;
import com.parablu.backupmigrateutility.domain.CMMigrationMetaData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class CMMigrationMetaDataDaoImpl
implements CMMigrationMetaDataDao {
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String OFFSET = "offset";
    private static final String STATUS = "status";
    private static final String COLLECTION_NAME = "CM_MIGRATION_META_DATA";
    @Autowired
    private MongoTemplate mongoTemplate;

    public CMMigrationMetaData getMigrationMetaDataForDeviceUUID(String deviceUUID) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID));
        CMMigrationMetaData cmMigrationMetaData = (CMMigrationMetaData)this.mongoTemplate.findOne(query, CMMigrationMetaData.class);
        return cmMigrationMetaData;
    }

    public void removeCmMetaData() {
        this.mongoTemplate.dropCollection(COLLECTION_NAME);
    }

    public void updateCmMetaData(CMMigrationMetaData cmMigrationMetaData) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)DEVICE_UUID).is((Object)cmMigrationMetaData.getDeviceUUID()));
        Update update = new Update().set(OFFSET, (Object)cmMigrationMetaData.getOffset()).set(STATUS, (Object)cmMigrationMetaData.getStatus());
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, CMMigrationMetaData.class);
    }

    public void insertCmMigrationMetaData(CMMigrationMetaData cmMigrationMetaData) {
        this.mongoTemplate.insert((Object)cmMigrationMetaData);
    }
}

