/*
 * Decompiled with CFR 0.152.
 */
package com.pg.gzip;

import com.pg.gzip.GZipStreamSource;
import java.io.IOException;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

public class GZipMessageConveter<T>
extends AbstractHttpMessageConverter<Object> {
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private static final String GZIP = "gzip";
    private static final String APPLICATION = "application";
    private static final String XML = "xml";
    private static final String TEXT = "text";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static Logger log = LogManager.getLogger(GZipMessageConveter.class);

    public GZipMessageConveter(Jaxb2Marshaller marshaller, Jaxb2Marshaller unmarshaller) {
        super(new MediaType[]{new MediaType(APPLICATION, XML), new MediaType(TEXT, XML), new MediaType(APPLICATION, "*+xml")});
        log.debug("Enterring GZipMessageConveter.readInternal");
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException {
        boolean isRequestGzip = false;
        HttpHeaders headers = inputMessage.getHeaders();
        List contentEncoding = headers.get((Object)CONTENT_ENCODING);
        log.debug("Enterring GZipMessageConveter.readInternal");
        if (contentEncoding != null) {
            for (String contentEncodingString : contentEncoding) {
                if (contentEncodingString == null || !GZIP.equalsIgnoreCase(contentEncodingString.trim())) continue;
                isRequestGzip = true;
            }
        }
        StreamSource streamSource = isRequestGzip ? new GZipStreamSource(inputMessage.getBody()) : new StreamSource(inputMessage.getBody());
        return this.readFromSource(clazz, inputMessage.getHeaders(), streamSource);
    }

    protected void writeInternal(Object t, HttpOutputMessage outputMessage) throws IOException {
        this.writeToResult(t, outputMessage.getHeaders(), new StreamResult(new GZIPOutputStream(outputMessage.getBody())));
    }

    protected Object readFromSource(Class<?> clazz, HttpHeaders headers, Source source) throws IOException {
        try {
            return this.unmarshaller.unmarshal(source);
        }
        catch (UnmarshallingFailureException ex) {
            throw new HttpMessageNotReadableException("Could not read " + clazz, (Throwable)ex);
        }
    }

    protected void writeToResult(Object object, HttpHeaders headers, Result result) throws IOException {
        try {
            this.marshaller.marshal(object, result);
        }
        catch (MarshallingFailureException ex) {
            throw new HttpMessageNotWritableException("Could not write " + object, (Throwable)ex);
        }
    }

    protected boolean supports(Class<?> clazz) {
        return this.unmarshaller.supports(clazz);
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }
}

