/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.BlockedDeviceUser;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.User;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronTrigger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@DisallowConcurrentExecution
public class DeleteBlockedUserDeviceDBCleanerJob
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(DeleteBlockedUserDeviceDBCleanerJob.class);
    private UtilService utilService;

    public UtilService getUtilService() {
        return this.utilService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public static void deleteFilesOlderThan(File directory, long cutoffDate) {
        if (directory.exists() && directory.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                logger.error("....unable to delete path...." + directory);
            }
        }
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        String cronExpression = "";
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger())) continue;
                    if (job.getTrigger() instanceof CronTrigger) {
                        CronTrigger cronTrigger = (CronTrigger)job.getTrigger();
                        cronExpression = cronTrigger.getCronExpression();
                    }
                    if (job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        if (!PCHelperConstant.isJobEnabled((String)"deleteBlockedUserDeviceDBCleanerJobTrigger")) {
            logger.debug("DeleteBlockedUserDeviceDBCleanerJob ............... disabled");
            return;
        }
        logger.debug("************* Delete Blocked UserDevice DBCleanerJob started ***********" + cronExpression);
        int cloudId = 1;
        Cloud cloud = this.utilService.getCloud(cloudId);
        List blockedUsers = this.utilService.getAllBlockedUsers(cloudId);
        for (User blockUser : blockedUsers) {
            List blockedDevices = this.utilService.getAllBlockedDevices(cloudId, blockUser.getUserName());
            for (Device device : blockedDevices) {
                if (device.isFilesDelStorageIssue()) continue;
                DeviceBackupOverView deviceBackupOverView = this.utilService.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
                long cutoffDate = System.currentTimeMillis() - (long)(cloud.getNoDayOldFilesDelForBlockedUser() * 24 * 60 * 60 * 1000);
                Calendar time = Calendar.getInstance();
                int hour = time.get(11);
                logger.debug(deviceBackupOverView.getLastHeardTime() + "...cutoffdate...." + cutoffDate + "...ime..." + hour);
                if (deviceBackupOverView.getLastHeardTime() < cutoffDate) {
                    logger.debug("...delete-user-db datadelete....." + blockUser.getUserName() + "....." + device.getDeviceName() + "...." + device.getDeviceUUID());
                    BlockedDeviceUser blockedDeviceUser = this.utilService.getBlockedDeviceUser(cloudId, device.getDeviceUUID(), blockUser.getUserName());
                    if (blockedDeviceUser == null || blockedDeviceUser.isDbRecDeleted()) continue;
                    logger.debug("...delete-user-dbrecord....." + blockUser.getUserName() + "....." + device.getDeviceUUID());
                    boolean allRecDeleted = this.utilService.deleteAllBlukryptDbForDeviceUUID(cloud, device.getDeviceUUID(), device.getUserName(), device.getDestCollection());
                    if (!allRecDeleted) continue;
                    this.utilService.updateBlockedDeviceDBProgress(cloudId, device.getDeviceUUID(), blockUser.getUserName(), true);
                    continue;
                }
                logger.debug("...return getLastHeardTime  < cutoffDate..." + hour);
            }
        }
        logger.debug("************* Delete Blocked UserDevice DBCleanerJob ended ***********");
    }
}

