/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.RateLimiter;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.parablu.pcbd.dao.BlackListUserDao;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.BlackListUser;
import com.parablu.pcbd.domain.BluKryptStorageMapping;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.pg.dao.SyncFileDao;
import com.pg.dao.UtilDao;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.odb.util.BackBlazeUtil;
import com.pg.odb.util.GoogleDriveUtil;
import com.pg.odb.util.LocalDriveUtil;
import com.pg.odb.util.OneDriveUtil;
import com.pg.service.CloudSupportService;
import com.pg.service.GraphDownloadService;
import com.pg.service.Office365DownloadService;
import com.pg.service.impl.Office365UploadServiceImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.azureblob.AzureBlobApiMetadata;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.b2.B2Api;
import org.jclouds.b2.B2ApiMetadata;
import org.jclouds.b2.B2ResponseException;
import org.jclouds.b2.domain.B2Object;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.domain.Location;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.Payload;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.SwiftApiMetadata;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.ObjectApi;
import org.jclouds.s3.S3ApiMetadata;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.S3Object;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class CloudSupportServiceImpl
implements CloudSupportService {
    public static final String BACK_BLAZE = "b2";
    public static final String LOCAL_STORAGE = "localStorage";
    private static final String NUM_1048576 = "1048576";
    private static final String UPLOADING_TO_CLOUD = " uploading to cloud .... ";
    private static final String CONTAINER_NAME_IS_EMPTY_REMOVE_THIS_LOGIC_TESTING_PURPOSE = " CONTAINER NAME IS EMPTY............ Remove this logic ... Testing purpose";
    private static final String FAILED = " failed.";
    private static final String AWS_S3 = "aws-s3";
    private static final String S3 = "s3";
    private static final String PARABLU = "ParaBlu";
    private static final String IN_CONTAINER = " in container ...";
    private static final String EXCEPTION_WHILE_DOWNLOAD_FROM_LOCAL_SERVER = "Exception While Download File From Local Server :";
    private SyncFileDao syncFileDao;
    @Autowired
    private Office365DownloadService office365DownloadService;
    @Autowired
    private UtilDao utilDao;
    @Autowired
    private Office365UploadServiceImpl office365UploadService;
    @Autowired
    private GraphDownloadService graphDownloadService;
    @Autowired
    private PciAuthorizationTokensDao pciAuthorizationTokensDao;
    @Autowired
    private BlackListUserDao blackListUserDao;
    private Logger logger = LogManager.getLogger(CloudSupportServiceImpl.class);
    private static final int BUFFER_CHUNK_SIZE = 1024;
    @Autowired
    private UserDao userDao;

    public void setSyncFileDao(SyncFileDao syncFileDao) {
        this.syncFileDao = syncFileDao;
    }

    public void setOffice365DownloadService(Office365DownloadService office365DownloadService) {
        this.office365DownloadService = office365DownloadService;
    }

    public void setUtilDao(UtilDao utilDao) {
        this.utilDao = utilDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    private BlobStoreContext getBlobStoreContext(String providerId, String identity, String passKey, String endpointUrl, String partSize, int numThreads, String blobTagName) {
        Properties properties = new Properties();
        if (!org.springframework.util.StringUtils.isEmpty((Object)identity)) {
            properties.setProperty(providerId + ".identity", identity);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)passKey)) {
            properties.setProperty(providerId + ".credential", passKey);
        }
        properties.setProperty("jclouds.mpu.parts.size", partSize);
        properties.setProperty("jclouds.mpu.parallel.degree", Integer.toString(numThreads));
        if (!org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
            this.logger.debug("..inside proxy....for jclouds..." + PCHelperConstant.getProxyHost());
            properties.setProperty("jclouds.proxy-host", PCHelperConstant.getProxyHost());
            properties.setProperty("jclouds.proxy-port", "" + PCHelperConstant.getProxyPort());
            if (!org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyUserName()) && !org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyPassword())) {
                properties.setProperty("jclouds.proxy-user", PCHelperConstant.getProxyUserName());
                properties.setProperty("jclouds.proxy-password", PCHelperConstant.getProxyPassword());
            }
        }
        if ("azureblob".equalsIgnoreCase(providerId) && !org.springframework.util.StringUtils.isEmpty((Object)blobTagName)) {
            properties.put("jclouds.user-agent", blobTagName);
            properties.put("HTTP_USER_AGENT", blobTagName);
            this.logger.debug("...usingagent value to write/read..." + blobTagName);
        }
        ContextBuilder credentials = ContextBuilder.newBuilder((String)providerId).overrides(properties);
        if ("swift".equalsIgnoreCase(providerId) || S3.equalsIgnoreCase(providerId)) {
            credentials.endpoint(endpointUrl);
        }
        return (BlobStoreContext)credentials.buildView(BlobStoreContext.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean uploadToCloud(String provider, String identity, String passKey, String endpointUrl, String containerName, File file, String directoryName, boolean isSync, Cloud cloud, boolean isChunkDeleteProcessStarted, String blobTagName) {
        boolean uploadSuccess = false;
        String containerNameTemp = containerName;
        String fileName = file.getName();
        this.logger.debug("...........$$$$$$$$$$$$$$$$$$$$..........." + fileName);
        try {
            String unwantedChar;
            if (fileName.contains("_") && fileName.contains(".") && !org.springframework.util.StringUtils.isEmpty((Object)(unwantedChar = fileName.substring(fileName.lastIndexOf("_"), fileName.lastIndexOf("."))))) {
                fileName = fileName.replace(unwantedChar, "");
            }
        }
        catch (Exception e1) {
            this.logger.trace("" + e1);
            this.logger.error(fileName + " ....unwantedChar.... " + e1.getMessage());
        }
        this.logger.debug("AFTER...&&&&&&&&&...........$$$$$$$$$$$$$$$$$$$$..........." + fileName);
        this.logger.error(" inside uploadtocloud..........." + provider);
        try (BlobStoreContext context = null;){
            context = this.getBlobStoreContext(provider, identity, passKey, endpointUrl, NUM_1048576, 2, blobTagName);
            containerNameTemp = this.checkPreConditionForCreateContainer(containerNameTemp, cloud);
            directoryName = this.checkPreConditionForCreateContainer(directoryName, cloud);
            ApiMetadata apiMetadata = context.unwrap().getProviderMetadata().getApiMetadata();
            BlobStore blobStore = context.getBlobStore();
            Location location = null;
            if (apiMetadata instanceof SwiftApiMetadata) {
                location = (Location)Iterables.getFirst((Iterable)blobStore.listAssignableLocations(), null);
            }
            boolean blobExists = this.createContainerIfNotExists(containerNameTemp, blobStore, location);
            this.logger.debug(provider + " blob exists vals......... " + blobExists);
            if (!blobExists) {
                boolean bl = false;
                return bl;
            }
            if (isChunkDeleteProcessStarted) {
                fileName = fileName + "_1";
            }
            if ((AWS_S3.equalsIgnoreCase(provider) || S3.equalsIgnoreCase(provider) || BACK_BLAZE.equalsIgnoreCase(provider)) && !org.springframework.util.StringUtils.isEmpty((Object)directoryName)) {
                if (isSync) {
                    directoryName = PARABLU.toLowerCase();
                }
                fileName = directoryName + "/" + fileName;
            }
            this.logger.debug(provider + " upload to dir ...." + directoryName + ". flag..." + isSync + "...filename..." + fileName + "..blobexists .." + blobExists + "...file length..." + file.length());
            String putBlobStr = "";
            Blob blob = blobStore.blobBuilder(fileName).payload(file).contentLength(file.length()).build();
            if (file.length() > 0x500000L && BACK_BLAZE.equalsIgnoreCase(provider)) {
                BackBlazeUtil backBlazeUtil = new BackBlazeUtil();
                backBlazeUtil.uploadToBlackBlaze(identity, passKey, containerNameTemp, file, directoryName);
            } else {
                this.logger.debug("upload @@SUCCESSFUL....without multipart..." + fileName);
                putBlobStr = blobStore.putBlob(containerNameTemp, blob);
            }
            this.logger.debug(putBlobStr + "...upload @@SUCCESSFUL......." + fileName);
            uploadSuccess = true;
        }
        return uploadSuccess;
    }

    private boolean createContainerIfNotExists(String containerNameTemp, BlobStore blobStore, Location location) {
        boolean blobExists = false;
        try {
            boolean containerExists = blobStore.containerExists(containerNameTemp);
            if (containerExists) {
                blobExists = true;
            } else {
                boolean isContainerCreated = blobStore.createContainerInLocation(location, containerNameTemp);
                if (isContainerCreated) {
                    blobExists = true;
                }
            }
        }
        catch (B2ResponseException ee) {
            if (ee.getResponse().getStatusCode() == 429) {
                String value = ee.getResponse().getFirstHeaderOrNull("Retry-After");
                this.logger.error(" ... 429 erro so try after 30 sec ... " + value);
                try {
                    Long sleeplong = 30000L;
                    if (value != null) {
                        sleeplong = Long.parseLong(value);
                        sleeplong = sleeplong * 1000L;
                    }
                    this.logger.error(" ... 429 erro so try after value from retry sec ... " + sleeplong);
                    Thread.sleep(sleeplong);
                    this.createContainerIfNotExists(containerNameTemp, blobStore, location);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.logger.debug(" unable to connect to ccloud ... " + (Object)((Object)ee));
            this.logger.error("Exception while conecting cloud " + ee.getMessage());
            blobExists = false;
        }
        catch (Exception ee) {
            this.logger.debug(" unable to connect to ccloud ... " + ee);
            this.logger.error("Exception while conecting cloud " + ee.getMessage());
            blobExists = false;
        }
        return blobExists;
    }

    private String checkPreConditionForCreateContainer(String containerName, Cloud cloud) {
        String containerNameTemp = containerName;
        containerNameTemp = containerNameTemp.toLowerCase();
        StringBuilder sb = new StringBuilder();
        if (!org.springframework.util.StringUtils.isEmpty((Object)containerNameTemp)) {
            boolean isLocalStorageEnabled;
            if (containerNameTemp.length() < 3) {
                containerNameTemp = containerNameTemp + "-parablu";
            }
            if (isLocalStorageEnabled = this.isLocalStorageEnabled(cloud)) {
                containerNameTemp = containerNameTemp.replaceAll("[^A-Za-z0-9,]", "-");
                containerNameTemp = containerNameTemp.replaceAll(" ", "-");
            } else {
                containerNameTemp = containerNameTemp.replace(" ", "-");
                containerNameTemp = containerNameTemp.replace(".", "-46");
                containerNameTemp = containerNameTemp.replace("@", "-64");
                containerNameTemp = containerNameTemp.replace("_", "-95");
            }
            sb.append(containerNameTemp);
            return sb.toString();
        }
        return containerNameTemp;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileStatusElement uploadToCloud(Cloud cloud, String containerName, File encryptedFile, com.parablu.pcbd.domain.User user, boolean isSync, String lastStoragePathForSameFile, RateLimiter rateLimiter, com.pg.domain.BackupFile backupFile, String gateWayName, boolean isChunkDeleteProcessStarted, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        String containerNameTemp = containerName;
        String userNameTemp = "";
        boolean allCloudUploadSuccess = false;
        FileStatusElement fileStatusElement = new FileStatusElement();
        String cloudName = "";
        try {
            PciAuthorizationTokenElement pciTokenElement;
            if (user != null) {
                userNameTemp = user.getUserName();
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)containerNameTemp)) {
                containerNameTemp = PARABLU.toLowerCase();
            }
            ArrayList<Object> cloudCredentialsList = cloud.getCloudCredentials();
            boolean isODBEnabled = false;
            boolean isGDEnabled = false;
            boolean isODBUserLevelEnabled = false;
            boolean isSPDestEnabled = false;
            if (cloud.getBlukryptStorageEnabled() == 1) {
                BluKryptStorageMapping pgStorageMapping = this.utilDao.getBluKryptStorageMapping(cloud.getCloudId());
                this.logger.debug(".....inside pgstoragemapping ...." + PCHelperConstant.getComponentName());
                cloudCredentialsList = new ArrayList<CloudCredentials>();
                if (pgStorageMapping != null) {
                    List cloudCredentialsTypeList = pgStorageMapping.getCloudCredentials();
                    if (!CollectionUtils.isEmpty((Collection)cloudCredentialsTypeList)) {
                        for (String cloudCredentialsType : pgStorageMapping.getCloudCredentials()) {
                            for (CloudCredentials cloudCredentials : cloud.getCloudCredentials()) {
                                if (cloudCredentials == null || !cloudCredentialsType.equalsIgnoreCase(cloudCredentials.getCloudName())) continue;
                                cloudCredentialsList = new ArrayList();
                                cloudCredentialsList.add(cloudCredentials);
                            }
                        }
                    }
                    this.logger.debug(cloudCredentialsTypeList + ".....inside pgstoragemapping1 ...." + PCHelperConstant.getComponentName());
                    isODBEnabled = pgStorageMapping.isODBEnabled();
                    isGDEnabled = pgStorageMapping.isGDEnabled();
                    this.logger.debug(cloudCredentialsTypeList + ".....inside pgstoragemapping latest 2...." + isODBEnabled + "....");
                }
            } else {
                CloudCredentials cloudCredentials;
                BackupPolicy backupPolicy;
                this.logger.debug("......blukrypt general storage .....");
                if (user != null && !org.springframework.util.StringUtils.isEmpty((Object)user.getPolicyName()) && (backupPolicy = this.utilDao.getBackupPolicy(cloud.getCloudId(), user.getPolicyName())) != null && (cloudCredentials = backupPolicy.getCloudCredentials()) != null) {
                    cloudCredentialsList.add(cloudCredentials);
                }
                if (CollectionUtils.isEmpty((Collection)cloudCredentialsList)) {
                    cloudCredentialsList = cloud.getCloudCredentials();
                }
                List licenseDetails = cloud.getCloudCustomisableDetails();
                isODBEnabled = this.isODBEnabled(licenseDetails);
                isGDEnabled = this.isGDEnabled(licenseDetails);
                isODBUserLevelEnabled = this.isODBUserLevelEnabled(licenseDetails);
                isSPDestEnabled = this.isSPDestEnabled(licenseDetails);
                if (CollectionUtils.isEmpty(cloudCredentialsList) && !isODBEnabled && !isGDEnabled && !PCHelperConstant.getPropertyFileValueLocalStorageEnabled()) {
                    fileStatusElement.setUploadStatus(false);
                    String userBlockedForWrite = "404_" + userNameTemp;
                    Object object = MemoryStore.get((String)userBlockedForWrite);
                    if (object == null) {
                        MemoryStore.add((String)userBlockedForWrite, (Object)userNameTemp, (long)1800000L);
                    }
                    return fileStatusElement;
                }
            }
            boolean isLocalStorageEnabled = false;
            if (!CollectionUtils.isEmpty(cloudCredentialsList)) {
                for (CloudCredentials cloudCredentials : cloudCredentialsList) {
                    if (cloudCredentials == null) continue;
                    this.logger.debug(UPLOADING_TO_CLOUD + cloudCredentials.getCloudName());
                    if (LOCAL_STORAGE.equalsIgnoreCase(cloudCredentials.getCloudName())) {
                        this.logger.debug(" local storage flag ..... ");
                        isLocalStorageEnabled = true;
                    }
                    if (org.springframework.util.StringUtils.isEmpty((Object)cloudCredentials.getProvider())) continue;
                    try {
                        cloudName = cloudCredentials.getCloudName();
                        String directoryName = "";
                        if (AWS_S3.equalsIgnoreCase(cloudCredentials.getProvider()) || S3.equalsIgnoreCase(cloudCredentials.getProvider()) || BACK_BLAZE.equalsIgnoreCase(cloudCredentials.getProvider())) {
                            directoryName = userNameTemp;
                            containerNameTemp = cloudCredentials.getContainerName();
                            if (org.springframework.util.StringUtils.isEmpty((Object)cloudCredentials.getContainerName())) {
                                containerNameTemp = cloudCredentials.getIdentity();
                                this.logger.error(CONTAINER_NAME_IS_EMPTY_REMOVE_THIS_LOGIC_TESTING_PURPOSE + containerNameTemp);
                            }
                        }
                        this.logger.debug("... trying to upload to cloud ..... " + cloudCredentials.getCloudName());
                        boolean uploadToCloud = this.uploadToCloud(cloudCredentials.getProvider(), cloudCredentials.getIdentity(), cloudCredentials.getCredential(), cloudCredentials.getEndPointUrl(), containerNameTemp, encryptedFile, directoryName, isSync, cloud, isChunkDeleteProcessStarted, cloudCredentials.getBlobTagName());
                        fileStatusElement.setUploadStatus(uploadToCloud);
                        if (!uploadToCloud && encryptedFile.length() > 0x500000L && BACK_BLAZE.equalsIgnoreCase(cloudCredentials.getProvider())) {
                            this.logger.error("..... backblaze jcloud does not support large file so return false ....");
                            fileStatusElement.setUploadStatus(uploadToCloud);
                            fileStatusElement.setUploadStatuscode(6789);
                            return fileStatusElement;
                        }
                        String cloudUploadedName = encryptedFile.getName();
                        if (isChunkDeleteProcessStarted) {
                            cloudUploadedName = cloudUploadedName + "_1";
                        }
                        fileStatusElement.setEncodedFileName(cloudUploadedName);
                        allCloudUploadSuccess = uploadToCloud;
                        if (uploadToCloud) {
                            this.logger.debug(UPLOADING_TO_CLOUD + cloudCredentials.getCloudName() + " completed ..");
                            continue;
                        }
                        this.logger.debug(UPLOADING_TO_CLOUD + cloudCredentials.getCloudName() + " failed ..");
                    }
                    catch (Exception e) {
                        this.logger.trace("" + e);
                        this.logger.error(" $$ upload to blob storage cloud  " + cloudName + FAILED + e.getMessage());
                        fileStatusElement.setUploadStatus(false);
                    }
                }
            }
            if (PCHelperConstant.getPropertyFileValueSyncFtpEnabled()) {
                cloudName = "Ftp-Server";
                this.uploadFileToFTPPath(encryptedFile);
                fileStatusElement.setUploadStatus(true);
                allCloudUploadSuccess = true;
            }
            if (isSPDestEnabled) {
                this.logger.debug("....upload to sharepoint...... ");
                this.logger.error(userNameTemp + " ISODB ENABLED ........ " + isODBEnabled + "......" + user.getOdbLoginId());
                if (isSync) {
                    userNameTemp = this.getUserNameForSync(backupFile, userNameTemp);
                }
                this.logger.debug("...userOdbriveid1....." + user.getOdbDriveid());
                if (graphClient != null) {
                    void var25_41;
                    OneDriveUtil odbUtil = OneDriveUtil.getInstance();
                    String string = user.getOdbDriveid();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)string)) {
                        try {
                            int val = Integer.parseInt(string);
                            String string2 = "";
                        }
                        catch (Exception val) {
                            // empty catch block
                        }
                    }
                    if (org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                        this.logger.debug("....sp dest is null for user...." + user.getUserName());
                        fileStatusElement.setUploadStatus(false);
                        return fileStatusElement;
                    }
                    String storagePooldestination = user.getOdbLoginId();
                    String string3 = "";
                    this.logger.error(string3 + ".... storagePooldestination........ " + storagePooldestination + "......");
                    if (StringUtils.isEmpty((String)string3) || "400".equalsIgnoreCase(string3) || "404".equalsIgnoreCase(string3) || "409".equals(string3)) {
                        this.logger.debug(user.getUserName() + "%%%%%%%%%%%%%%%%%%%%get try to get driveid%%%%%%%%%%%%%%%%%%");
                        String string4 = OneDriveUtil.getPBFolderItemIdForSPWithErrorCode(storagePooldestination);
                        this.logger.debug("%%%%%%%%%%%%%%%%%%%%test%%%%%%%%%%%%%%%%%%" + string4);
                        if (!(org.springframework.util.StringUtils.isEmpty((Object)string4) && "404".equals(string4) && "409".equals(string4))) {
                            user.setOdbDriveid(string4);
                        }
                        this.logger.debug(user.getOdbDriveid() + "%%%%%%%%%%%%%^^^%%%%%%%%%%%%%%%%%%%%%%%%%" + user.getAzureUniqueId());
                        this.utilDao.updateAzureProperties(cloud.getCloudId(), user.getUserName(), string4);
                    }
                    String encryptedFileName = this.removeIdFromChunkName(backupFile.getId(), encryptedFile);
                    fileStatusElement = odbUtil.uploadToSPUsingGraph((String)var25_41, isSync, fileStatusElement, encryptedFile, lastStoragePathForSameFile, backupFile.getDeviceUUID(), user, gateWayName, encryptedFileName, graphClient, okHttpClient, storagePooldestination);
                    if (user != null && !user.isBackupTargetAssigned() && fileStatusElement.isUploadStatus()) {
                        this.logger.debug("...File uploaded but backup target assigned is false so update as true..." + user.getUserName());
                        this.utilDao.updateBkpTargetStatus(cloud.getCloudId(), user.getUserName());
                    }
                    if (fileStatusElement.isUploadStatus()) {
                        this.blackListUserDao.deleteBlackListUserByUserName(1, user.getUserName());
                    }
                    allCloudUploadSuccess = true;
                } else {
                    allCloudUploadSuccess = false;
                    this.logger.error(" Onedrive account has expired or not configured for user ..msg tokens null.. " + userNameTemp);
                }
            } else if (isODBEnabled) {
                this.logger.error(userNameTemp + " ISODB ENABLED ........ " + isODBEnabled + "......" + user.getOdbLoginId());
                if (cloud.getGraphApiEnabled() == 1) {
                    if (graphClient != null) {
                        PciAuthorizationTokenElement pciTokenElement2 = null;
                        pciTokenElement2 = new PciAuthorizationTokenElement();
                        pciTokenElement2.setCloudName(cloudName);
                        pciTokenElement2.setUserName(userNameTemp);
                        OneDriveUtil oneDriveUtil = OneDriveUtil.getInstance();
                        String emailId = user.getEmailId();
                        if (!org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                            emailId = user.getOdbLoginId();
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)user.getDestOdbLoginId())) {
                            emailId = user.getDestOdbLoginId();
                        }
                        pciTokenElement2.setAccountId(emailId.toLowerCase());
                        boolean muxedEnabled = false;
                        if (StringUtils.isNotEmpty((String)PCHelperConstant.getOneDriveBackupType()) && PCHelperConstant.getOneDriveBackupType().equalsIgnoreCase("MUX")) {
                            muxedEnabled = true;
                        }
                        this.logger.debug("...muxedEnabled......user OdbLoginId is empty or return..." + muxedEnabled);
                        if (user != null && muxedEnabled && org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                            fileStatusElement.setUploadStatus(false);
                            this.logger.debug("...muxedEnabled..." + muxedEnabled + "...user OdbLoginId is empty or return...");
                            user.setBackupTargetAssigned(false);
                            user.setBackupTargetErrorCode(204);
                            this.utilDao.saveUser(1, user);
                            return fileStatusElement;
                        }
                        if (StringUtils.isNotEmpty((String)PCHelperConstant.getOneDriveBackupType()) && PCHelperConstant.getOneDriveBackupType().equalsIgnoreCase("MIX")) {
                            if (org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                                pciTokenElement2.setAccountId(user.getEmailId().toLowerCase());
                            } else {
                                pciTokenElement2.setAccountId(user.getOdbLoginId().toLowerCase());
                            }
                        } else if (StringUtils.isNotEmpty((String)PCHelperConstant.getOneDriveBackupType()) && PCHelperConstant.getOneDriveBackupType().equalsIgnoreCase("NONMUX")) {
                            pciTokenElement2.setAccountId(user.getEmailId().toLowerCase());
                        }
                        String driveId = user.getOdbDriveid();
                        if (!org.springframework.util.StringUtils.isEmpty((Object)driveId)) {
                            try {
                                int val = Integer.parseInt(driveId);
                                driveId = "";
                            }
                            catch (Exception val) {
                                // empty catch block
                            }
                        }
                        if (StringUtils.isEmpty((String)driveId) || "404".equalsIgnoreCase(driveId) || "409".equals(driveId)) {
                            this.logger.debug(user.getUserName() + "%%%%%%%%%%%%%%%%%%%%get user for email%%%%%%%%%%%%%%%%%%" + emailId.toLowerCase());
                            driveId = OneDriveUtil.getPBFolderItemIdWithErrorCode(emailId.toLowerCase());
                            this.logger.debug("%%%%%%%%%%%%%%%%%%%%test%%%%%%%%%%%%%%%%%%" + driveId);
                            if (!(org.springframework.util.StringUtils.isEmpty((Object)driveId) && "404".equals(driveId) && "409".equals(driveId))) {
                                user.setOdbDriveid(driveId);
                            }
                            this.logger.debug(user.getOdbDriveid() + "%%%%%%%%%%%%%^^^%%%%%%%%%%%%%%%%%%%%%%%%%" + user.getAzureUniqueId());
                            this.utilDao.updateAzureProperties(cloud.getCloudId(), user.getUserName(), driveId);
                        }
                        if (org.springframework.util.StringUtils.isEmpty((Object)driveId)) {
                            return this.handle404And403Cases(userNameTemp, fileStatusElement, user, pciTokenElement2);
                        }
                        String encryptedFileName = this.removeIdFromChunkName(backupFile.getId(), encryptedFile);
                        fileStatusElement = oneDriveUtil.uploadToODBUsingGraph(pciTokenElement2, isSync, fileStatusElement, encryptedFile, lastStoragePathForSameFile, backupFile.getDeviceUUID(), user, gateWayName, encryptedFileName, driveId, graphClient, okHttpClient);
                        if (user != null && !user.isBackupTargetAssigned() && fileStatusElement.isUploadStatus()) {
                            this.logger.debug("...File uploaded but backup target assigned is false so update as true..." + user.getUserName());
                            this.utilDao.updateBkpTargetStatus(cloud.getCloudId(), user.getUserName());
                        }
                        if (fileStatusElement.isUploadStatus()) {
                            this.blackListUserDao.deleteBlackListUserByUserName(1, user.getUserName());
                        }
                        allCloudUploadSuccess = true;
                    } else {
                        allCloudUploadSuccess = false;
                        this.logger.error(" Onedrive account has expired or not configured for user ..msg tokens null.. " + userNameTemp);
                    }
                } else {
                    void var25_45;
                    boolean isServiceAcct = false;
                    if (isODBUserLevelEnabled) {
                        PciAuthorizationTokens pciAuthorizationTokens = this.utilDao.getPciAuthorizationTokensForUserName(cloud.getCloudId(), userNameTemp);
                    } else {
                        PciAuthorizationTokens pciAuthorizationTokens = this.utilDao.getPciAuthorizationTokens(cloud.getCloudId());
                        isServiceAcct = true;
                    }
                    if (var25_45 != null) {
                        pciTokenElement = this.getTokenElement((PciAuthorizationTokens)var25_45);
                        pciTokenElement.setUserName(userNameTemp);
                        pciTokenElement.setServiceAcct(isServiceAcct);
                        boolean muxedEnabled = false;
                        if (StringUtils.isNotEmpty((String)PCHelperConstant.getOneDriveBackupType()) && PCHelperConstant.getOneDriveBackupType().equalsIgnoreCase("MUX")) {
                            muxedEnabled = true;
                        }
                        this.logger.debug("...muxedEnabled......user OdbLoginId is empty or return..." + muxedEnabled);
                        if (user != null && muxedEnabled && org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                            fileStatusElement.setUploadStatus(false);
                            this.logger.debug("...muxedEnabled..." + muxedEnabled + "...user OdbLoginId is empty or return...");
                            user.setBackupTargetAssigned(false);
                            user.setBackupTargetErrorCode(204);
                            this.utilDao.saveUser(1, user);
                            return fileStatusElement;
                        }
                        OneDriveUtil odbUtil = OneDriveUtil.getInstance();
                        if (StringUtils.isNotEmpty((String)PCHelperConstant.getOneDriveBackupType()) && PCHelperConstant.getOneDriveBackupType().equalsIgnoreCase("MIX")) {
                            if (org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                                pciTokenElement.setAccountId(user.getEmailId().toLowerCase());
                            } else {
                                pciTokenElement.setAccountId(user.getOdbLoginId().toLowerCase());
                            }
                        } else if (StringUtils.isNotEmpty((String)PCHelperConstant.getOneDriveBackupType()) && PCHelperConstant.getOneDriveBackupType().equalsIgnoreCase("NONMUX")) {
                            pciTokenElement.setAccountId(user.getEmailId().toLowerCase());
                        }
                        this.logger.debug(user.getOdbLoginId() + " ....uploading using odbutil for user login id....... " + user.getEmailId());
                        String encryptedFileName = this.removeIdFromChunkName(backupFile.getId(), encryptedFile);
                        fileStatusElement = odbUtil.uploadToODB(pciTokenElement, isSync, fileStatusElement, encryptedFile, lastStoragePathForSameFile, backupFile.getDeviceUUID(), user.getUserName(), gateWayName, encryptedFileName, isChunkDeleteProcessStarted);
                        if (user != null && !user.isBackupTargetAssigned() && fileStatusElement.isUploadStatus()) {
                            this.logger.debug("...File uploaded but backup target assigned is false so update as true..." + user.getUserName());
                            this.utilDao.updateBkpTargetStatus(cloud.getCloudId(), user.getUserName());
                        }
                        if (fileStatusElement.isUploadStatus()) {
                            this.blackListUserDao.deleteBlackListUserByUserName(1, user.getUserName());
                        }
                        allCloudUploadSuccess = true;
                    } else {
                        allCloudUploadSuccess = false;
                        this.logger.error(" Onedrive account has expired or not configured for user ... " + userNameTemp);
                    }
                }
            }
            if (isGDEnabled) {
                void var25_49;
                boolean isGDServiceAcctEnabled;
                this.logger.error(userNameTemp + " Google drive ENABLED ........ " + isGDEnabled + "......" + user.getOdbLoginId());
                if (isSync) {
                    userNameTemp = this.getUserNameForSync(backupFile, userNameTemp);
                }
                if (isGDServiceAcctEnabled = this.isGDServiceAcctEnabled(cloud.getCloudCustomisableDetails())) {
                    PciAuthorizationTokens pciAuthorizationTokens = this.utilDao.getPciAuthorizationTokens(cloud.getCloudId());
                } else {
                    PciAuthorizationTokens pciAuthorizationTokens = this.utilDao.getPciAuthorizationTokensForUserName(cloud.getCloudId(), userNameTemp);
                }
                if (var25_49 != null) {
                    pciTokenElement = this.getTokenElement((PciAuthorizationTokens)var25_49);
                    pciTokenElement.setUserName(userNameTemp);
                    GoogleDriveUtil googleDriveUtil = GoogleDriveUtil.getInstance();
                    if (org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                        pciTokenElement.setAccountId(user.getEmailId());
                    } else {
                        pciTokenElement.setAccountId(user.getOdbLoginId());
                    }
                    pciTokenElement.setCloudName(cloud.getCloudName());
                    String cloudChunkName = encryptedFile.getName();
                    this.logger.debug(user.getOdbLoginId() + " ....uploading using googleDriveUtil for user login id....... " + user.getEmailId());
                    fileStatusElement = googleDriveUtil.uploadToGD(pciTokenElement, isSync, fileStatusElement, encryptedFile, lastStoragePathForSameFile, cloudChunkName, backupFile.getDeviceUUID(), user);
                    allCloudUploadSuccess = true;
                } else {
                    allCloudUploadSuccess = false;
                    this.logger.error(" Google drive account has expired or not configured for user ... " + userNameTemp);
                }
            }
            if (isLocalStorageEnabled) {
                this.logger.debug(" local storage flag ..... ");
                cloudName = "Local";
                boolean uploadSuccess = false;
                String string = this.getLocalStoragePath(cloudCredentialsList);
                lastStoragePathForSameFile = isSync ? user.getCloudSyncStoragePath() : user.getCloudBkpStoragePath();
                if (isODBEnabled) {
                    lastStoragePathForSameFile = fileStatusElement.getCloudStoragePath();
                }
                fileStatusElement = this.uploadFileToLocalStorage(encryptedFile, uploadSuccess, userNameTemp, isSync, lastStoragePathForSameFile, cloud.getCloudName(), string, isChunkDeleteProcessStarted);
                allCloudUploadSuccess = true;
            }
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(" $$ upload to cloud  " + cloudName + FAILED + e.getMessage());
            if (e.getMessage().contains("ResourceNotFound")) {
                fileStatusElement.setUploadStatus(false);
                this.logger.debug("URL not found of that user so make backupTargetAssigned as false for " + user.getUserName());
                user.setBackupTargetAssigned(false);
                user.setBackupTargetErrorCode(404);
                this.utilDao.saveUser(1, user);
                BlackListUser blackListUserObj = this.blackListUserDao.getBlackListUserbyName(1, userNameTemp, PCHelperConstant.getComponentName());
                if (blackListUserObj == null) {
                    BlackListUser blackListUser = new BlackListUser();
                    blackListUser.setResponseCode("404");
                    blackListUser.setUserName(userNameTemp);
                    blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                    this.blackListUserDao.saveBlackListUser(1, blackListUser);
                } else if (!blackListUserObj.getResponseCode().equalsIgnoreCase("404")) {
                    this.blackListUserDao.updateBlackListUserWithCode(1, userNameTemp, PCHelperConstant.getComponentName(), "404");
                }
            }
            allCloudUploadSuccess = false;
        }
        this.logger.debug(allCloudUploadSuccess + " upload variable ");
        if (!allCloudUploadSuccess) {
            fileStatusElement.setUploadStatus(false);
        }
        return fileStatusElement;
    }

    private boolean isSPDestEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isSPDestEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"SharePoint Dest Enabled".equalsIgnoreCase(license.getName())) continue;
            isSPDestEnabled = true;
            break;
        }
        return isSPDestEnabled;
    }

    private User getAzureUser(String emailId) {
        User userFound;
        block4: {
            userFound = null;
            try {
                String authorityHost = "https://login.microsoftonline.com";
                ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("https://graph.microsoft.com/.default");
                TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
                GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
                ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
                requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
                UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    if (!emailId.equalsIgnoreCase(userObj.mail) || !emailId.equalsIgnoreCase(userObj.userPrincipalName)) continue;
                    userFound = userObj;
                    break;
                }
                if (userFound != null) break block4;
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    if (!emailId.equalsIgnoreCase(userObj.mail)) continue;
                    userFound = userObj;
                    break;
                }
            }
            catch (ClientException e) {
                this.logger.error("...unable to fetch user latest....." + emailId);
                e.printStackTrace();
            }
        }
        return userFound;
    }

    private String removeIdFromChunkName(String bkpFileId, File encryptedFile) {
        String encryptedFileName = encryptedFile.getName();
        try {
            this.logger.debug(encryptedFileName + ">>>>>>>>>>>>>>> BEFORE...." + encryptedFileName);
            if (encryptedFileName.contains("." + bkpFileId)) {
                encryptedFileName = encryptedFileName.replaceAll("." + bkpFileId, "");
            }
            this.logger.debug(encryptedFileName);
            if (encryptedFileName.contains("_")) {
                encryptedFileName = encryptedFileName.substring(0, encryptedFileName.indexOf("_"));
            }
        }
        catch (Exception e) {
            this.logger.error("error in Encoding the chunk name " + encryptedFileName + e.getMessage());
            this.logger.trace("" + e);
        }
        return encryptedFileName;
    }

    private String getUserNameForSync(com.pg.domain.BackupFile backupFile, String userNameTemp) {
        String mcNameForPath;
        List miniCloudElementList = this.syncFileDao.getAllMiniClouds(1);
        boolean isPathIsideMiniCloud = this.isPathInsideMC(miniCloudElementList, mcNameForPath = CloudSupportServiceImpl.getMCName(backupFile.getFilePath()));
        if (isPathIsideMiniCloud) {
            return this.getMiniCloudOwner(miniCloudElementList, mcNameForPath);
        }
        return userNameTemp;
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private boolean isODBUserLevelEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB User Level Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private boolean isGDEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isGDEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"Google Drive Enabled".equalsIgnoreCase(license.getName())) continue;
            isGDEnabled = true;
            break;
        }
        return isGDEnabled;
    }

    private boolean isGDServiceAcctEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isGDServiceAcctEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"GD Service Account Enabled".equalsIgnoreCase(license.getName())) continue;
            isGDServiceAcctEnabled = true;
            break;
        }
        return isGDServiceAcctEnabled;
    }

    private PciAuthorizationTokenElement getTokenElement(PciAuthorizationTokens pciAuthorizationTokens) {
        PciAuthorizationTokenElement tokenElement = new PciAuthorizationTokenElement();
        if (pciAuthorizationTokens == null) {
            return tokenElement;
        }
        tokenElement.setAccessToken(pciAuthorizationTokens.getAccessToken());
        tokenElement.setAuthenticationToken(pciAuthorizationTokens.getAuthenticationToken());
        tokenElement.setClientId(pciAuthorizationTokens.getClientId());
        tokenElement.setClientSecret(pciAuthorizationTokens.getClientSecret());
        tokenElement.setEmailId(pciAuthorizationTokens.getEmailId());
        tokenElement.setRedirectUri(pciAuthorizationTokens.getRedirectUri());
        tokenElement.setRefreshToken(pciAuthorizationTokens.getRefreshToken());
        tokenElement.setCloudStorageType(pciAuthorizationTokens.getCloudStorageType().getName());
        tokenElement.setAccountId(pciAuthorizationTokens.getAccountId());
        tokenElement.setSharePointUrl(pciAuthorizationTokens.getSharePointUrl());
        tokenElement.setCloudName(pciAuthorizationTokens.getCloudName());
        com.parablu.pcbd.domain.User user = this.utilDao.getUserInfo(1, "", pciAuthorizationTokens.getUserId().toString());
        if (user != null) {
            tokenElement.setUserName(user.getUserName());
        }
        return tokenElement;
    }

    private FileStatusElement uploadFileToLocalStorage(File encryptedFile, boolean uploadSuccess, String userName, boolean isSync, String lastStoragePathForSameFile, String cloudName, String localStoragePath, boolean isChunkDeleteProcessStarted) {
        FileStatusElement fileStatusElement = new FileStatusElement();
        String lastCloudStoragePath = lastStoragePathForSameFile;
        String containerName = "backup";
        Properties properties = new Properties();
        String intermediateUploadFolder = PCHelperConstant.getPropertyFileValueSyncUploadPath();
        this.logger.debug(isSync + " local upload path for file@@@ .... " + intermediateUploadFolder + " ... storage path ...." + lastCloudStoragePath);
        File intermediateFolder = new File(intermediateUploadFolder);
        if (!intermediateFolder.exists() && !intermediateFolder.mkdirs()) {
            throw new ParacloudBackupException("Folder Cannot be created", 500);
        }
        String bkpPath = null;
        if (isSync) {
            containerName = "sync";
            this.logger.debug(" ### inside sync path .......... " + containerName);
            bkpPath = localStoragePath + "/sync";
        } else {
            this.logger.debug(" ### inside backup path .......... " + containerName);
            try {
                bkpPath = localStoragePath + "/backup";
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Exception While Uploading File Local Storage :" + e.getMessage());
            }
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)lastCloudStoragePath)) {
            lastCloudStoragePath = "1";
            this.userDao.updateUserStoragePath(1, userName, lastCloudStoragePath, isSync);
        }
        try {
            String cloudChunkName = encryptedFile.getName();
            if (isChunkDeleteProcessStarted) {
                cloudChunkName = cloudChunkName + "_1";
            }
            String filePath = bkpPath + "/" + userName + "/" + lastCloudStoragePath;
            int filesInFoldercount = this.getFolderPathCount(filePath);
            LocalDriveUtil instance = LocalDriveUtil.getInstance();
            this.logger.debug("...filcount...." + filesInFoldercount + "...." + filePath);
            if (filesInFoldercount >= instance.getMaxFileCount()) {
                lastCloudStoragePath = instance.getNextFolderPath(userName, isSync, cloudName, bkpPath, filePath, filesInFoldercount);
            }
            String bkpCompletePath = bkpPath + "/" + userName + "/" + lastCloudStoragePath + "/" + cloudChunkName;
            this.logger.debug("....................***************..............." + bkpCompletePath);
            FileUtils.copyFile((File)encryptedFile.getAbsoluteFile(), (File)new File(bkpCompletePath));
            fileStatusElement.setUploadStatus(true);
            fileStatusElement.setCloudStoragePath(lastCloudStoragePath);
            fileStatusElement.setEncodedFileName(cloudChunkName);
        }
        catch (IOException e) {
            this.logger.debug("..........Inside exception.........");
            this.logger.trace("" + e);
            this.logger.error("Exception While Uploading File Local Storage :" + e.getMessage());
            fileStatusElement.setUploadStatus(false);
        }
        return fileStatusElement;
    }

    private int getFolderPathCount(String filePath) {
        int filesInFoldercount = 0;
        File folderPath = new File(filePath);
        if (folderPath.exists()) {
            filesInFoldercount = folderPath.list().length;
        }
        return filesInFoldercount;
    }

    private synchronized String getSyncStoragePath(String userName, FileStatusElement fileStatusElement, String lastCloudStoragePath, ArrayList<Integer> folderNameList, String containerName, Properties properties, String localStoragePath) throws IOException {
        String containerNameTemp = containerName;
        String syncPath = localStoragePath + "/" + containerNameTemp;
        File file = new File(syncPath + "/" + lastCloudStoragePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        Stream<Path> list = Files.list(Paths.get(syncPath + "/" + lastCloudStoragePath, new String[0]));
        long count = list.count();
        list.close();
        String cloudStoragePath = this.checkDriveStoragePathAndCount(folderNameList, (int)count);
        String syncNewPath = syncPath + "/" + cloudStoragePath;
        File newfile = new File(syncNewPath);
        if (!newfile.exists()) {
            newfile.mkdirs();
        }
        containerNameTemp = newfile.getName();
        properties.setProperty("jclouds.filesystem.basedir", newfile.getParent());
        fileStatusElement.setCloudStoragePath(containerNameTemp);
        this.logger.debug(cloudStoragePath + " .................sync................... " + count + "  .... containername .... " + containerNameTemp);
        return containerNameTemp;
    }

    private synchronized String getBkpCurrentStoragePath(String userName, FileStatusElement fileStatusElement, String lastCloudStoragePath, ArrayList<Integer> folderNameList, Properties properties, String bkpPath) throws IOException {
        String bkpCompletePath = bkpPath + "/" + userName + "/" + lastCloudStoragePath;
        File file = new File(bkpCompletePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        Stream<Path> list = Files.list(Paths.get(bkpCompletePath, new String[0]));
        long count = list.count();
        list.close();
        String cloudStoragePath = this.checkDriveStoragePathAndCount(folderNameList, (int)count);
        String bkpNewPath = bkpPath + "/" + userName + "/" + cloudStoragePath;
        File newfile = new File(bkpNewPath);
        if (!newfile.exists()) {
            newfile.mkdirs();
        }
        String containerName = newfile.getName();
        properties.setProperty("jclouds.filesystem.basedir", newfile.getParent());
        fileStatusElement.setCloudStoragePath(containerName);
        this.logger.debug(cloudStoragePath + " ............backup..........getBkpCurrentStoragePath.............. " + count + "  .... containername .... " + containerName);
        return containerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadFileToFTPPath(File file) {
        boolean success = true;
        FTPClient ftpClient = new FTPClient();
        try {
            ftpClient.connect(PCHelperConstant.getSyncFtpHostProperty());
            boolean login = ftpClient.login(PCHelperConstant.getSyncFtpUserProperty(), PCHelperConstant.getSyncFtpPwdProperty());
            ftpClient.setFileType(2);
            if (login) {
                this.logger.debug("Connection established...");
                FileInputStream inputStream = new FileInputStream(file);
                boolean uploaded = ftpClient.storeFile(PCHelperConstant.getPropertyFileValueSyncUploadPath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + file.getName(), (InputStream)inputStream);
                this.logger.debug(file.getPath() + " .....File path and file name....   " + file.getName());
                if (uploaded) {
                    this.logger.debug("File uploaded successfully !");
                } else {
                    success = false;
                    this.logger.debug("Error in uploading file !!!!! " + ftpClient.getReplyCode());
                }
                boolean logout = ftpClient.logout();
                if (logout) {
                    this.logger.debug("Connection close...");
                }
            } else {
                success = false;
                this.logger.debug("Connection fail...");
            }
        }
        catch (Exception e) {
            success = false;
            this.logger.trace("" + e);
            this.logger.error("Exception While Uploading File to FTP Path :" + e.getMessage());
        }
        finally {
            try {
                ftpClient.disconnect();
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Exception While Uploading File to FTP Path :" + e.getMessage());
            }
        }
        return success;
    }

    private void downloadFileFromLocalServer(String fileName, String cloudName, String deviceUUID) {
        String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path + "tempdownloadsync");
        FTPClient ftpClient = new FTPClient();
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdir();
        }
        try {
            String downloadFileName = tempdownloadDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
            FileOutputStream outputStream = null;
            ftpClient.connect(PCHelperConstant.getSyncFtpHostProperty());
            boolean login = ftpClient.login(PCHelperConstant.getSyncFtpUserProperty(), PCHelperConstant.getSyncFtpPwdProperty());
            if (login) {
                this.logger.debug("Connection established...");
                outputStream = new FileOutputStream(downloadFileName);
                ftpClient.setFileType(2);
                ftpClient.enterLocalPassiveMode();
                ftpClient.setAutodetectUTF8(true);
                boolean downloaded = ftpClient.retrieveFile(PCHelperConstant.getPropertyFileValueSyncUploadPath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName, (OutputStream)outputStream);
                if (downloaded) {
                    this.logger.debug("File downloaded successfully !");
                } else {
                    this.logger.debug("Error in downloaded file !");
                }
                boolean logout = ftpClient.logout();
                if (logout) {
                    this.logger.debug("Connection close...");
                }
            } else {
                this.logger.debug("Connection fail...");
            }
        }
        catch (IOException e) {
            this.logger.trace("" + e);
            this.logger.error(EXCEPTION_WHILE_DOWNLOAD_FROM_LOCAL_SERVER + e.getMessage());
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(EXCEPTION_WHILE_DOWNLOAD_FROM_LOCAL_SERVER + e.getMessage());
            throw new ParacloudBackupException("Azure download error", 507);
        }
        finally {
            try {
                ftpClient.disconnect();
            }
            catch (IOException e) {
                this.logger.error("Exception while closing the Ftp connection..." + e.getMessage());
                this.logger.error("Exception while closing the Ftp connection..." + e);
            }
        }
    }

    private InputStream convertFileToInputStream(String downloadFileName) {
        FileInputStream is = null;
        this.logger.debug("inside converting to file stream!!!!!!!!!!!!!!!!!1");
        try {
            FileInputStream fis;
            is = fis = new FileInputStream(downloadFileName);
        }
        catch (FileNotFoundException e) {
            this.logger.trace("" + e);
            this.logger.error("File does not exist in path ..... " + downloadFileName + e.getMessage());
        }
        return is;
    }

    @Override
    public BufferedInputStream downloadFile(Cloud cloud, String restorePathDir, String fileNameToDownload, String userName, String deviceUUID, String containerName, com.pg.domain.ChunkFile chunkFile, boolean isSync1, com.pg.domain.BackupFile backupFile, FileStatusElement fileStatusElement, String folderName, ChunkDetail chunkDetail, String driveId, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        String originalFileName;
        String chunkuserName;
        PciAuthorizationTokenElement pciTokenElement;
        MSGTokens msgTokens;
        String mcNameForPath;
        List miniCloudElementList;
        BackupPolicy backupPolicy;
        this.logger.debug("--- Download File DeviceUUID --- " + deviceUUID);
        String containerNameTemp = containerName;
        String userNameTemp = userName;
        BufferedInputStream bufferedInputStream = null;
        String cloudName = cloud.getCloudName();
        boolean isSync = isSync1;
        long currentTime = System.currentTimeMillis();
        File tempdownloadDir = this.downloadPathDir(deviceUUID, cloudName, isSync, restorePathDir);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        String downloadFileName = tempdownloadDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileNameToDownload;
        this.logger.debug(" Before download .... " + downloadFileName);
        CloudCredentials cc = null;
        com.parablu.pcbd.domain.User user = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)userNameTemp)) {
            user = this.utilDao.getUserForName(cloud.getCloudId(), userNameTemp);
        }
        if (user != null && !org.springframework.util.StringUtils.isEmpty((Object)user.getPolicyName()) && (backupPolicy = this.utilDao.getBackupPolicy(cloud.getCloudId(), user.getPolicyName())) != null) {
            cc = backupPolicy.getCloudCredentials();
        }
        boolean isODBEnabled = false;
        boolean isGDEnabled = false;
        boolean isODBUserLevelEnabled = false;
        boolean isSPDestEnabled = false;
        if (cloud.getBlukryptStorageEnabled() == 1) {
            cc = null;
            BluKryptStorageMapping pgStorageMapping = this.utilDao.getBluKryptStorageMapping(cloud.getCloudId());
            this.logger.debug(".....inside pgstoragemapping ...." + PCHelperConstant.getComponentName());
            if (pgStorageMapping != null) {
                this.logger.debug(pgStorageMapping.getCloudCredentials() + ".....inside pgstoragemapping1 ...." + PCHelperConstant.getComponentName());
                isODBEnabled = pgStorageMapping.isODBEnabled();
                isGDEnabled = pgStorageMapping.isGDEnabled();
                List cloudCredentialsTypeList = pgStorageMapping.getCloudCredentials();
                if (!CollectionUtils.isEmpty((Collection)cloudCredentialsTypeList)) {
                    for (String cloudCredentialsType : pgStorageMapping.getCloudCredentials()) {
                        for (CloudCredentials cloudCredentials : cloud.getCloudCredentials()) {
                            if (cloudCredentials == null || !cloudCredentialsType.equalsIgnoreCase(cloudCredentials.getCloudName())) continue;
                            cc = cloudCredentials;
                        }
                    }
                }
                this.logger.debug(pgStorageMapping.getCloudCredentials() + ".....inside pgstoragemapping latest 2...." + isODBEnabled + "...." + cc);
            }
        } else {
            List cloudCredentialsList;
            this.logger.debug(".....inside noraml cloud ....");
            if (cc == null && !CollectionUtils.isEmpty((Collection)(cloudCredentialsList = cloud.getCloudCredentials()))) {
                cc = (CloudCredentials)cloudCredentialsList.get(0);
            }
            List licenseDetails = cloud.getCloudCustomisableDetails();
            isODBEnabled = this.isODBEnabled(licenseDetails);
            isGDEnabled = this.isGDEnabled(licenseDetails);
            isODBUserLevelEnabled = this.isODBUserLevelEnabled(licenseDetails);
            isSPDestEnabled = this.isSPDestEnabled(licenseDetails);
        }
        this.logger.debug(isSync + "...cloud credentials...." + containerNameTemp);
        if (cc != null) {
            this.logger.debug(cc.getEndPointUrl() + "...cloud credentials nane...." + cc.getCloudName());
            if (LOCAL_STORAGE.equalsIgnoreCase(cc.getCloudName())) {
                String localStoragePath = cc.getEndPointUrl();
                String completeDownloadpath = localStoragePath + "/sync";
                completeDownloadpath = completeDownloadpath + "/" + chunkDetail.getUserName();
                if (org.springframework.util.StringUtils.isEmpty((Object)containerNameTemp) && isSync1) {
                    containerNameTemp = PARABLU;
                }
                this.logger.debug("Is Sync value inside local storage>>" + isSync + "cloudStorage path>>" + chunkFile.getCloudStoragePath());
                if (!isSync) {
                    completeDownloadpath = localStoragePath + "/backup" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + containerNameTemp;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)chunkFile.getCloudStoragePath())) {
                    completeDownloadpath = completeDownloadpath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkFile.getCloudStoragePath();
                }
                this.logger.debug(" download from local storage ....... " + completeDownloadpath);
                downloadFileName = completeDownloadpath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileNameToDownload;
                this.logger.debug(" @##@#@#@#@#download from local storage in path ....... " + downloadFileName);
                try {
                    File file = new File(downloadFileName);
                    if (!file.exists()) {
                        this.logger.debug("File not exists...");
                        if (org.springframework.util.StringUtils.isEmpty((Object)chunkFile.getCloudStoragePath())) {
                            this.logger.debug("Chunk storage path is empty to try in folder 1");
                            completeDownloadpath = completeDownloadpath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "1";
                            downloadFileName = completeDownloadpath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileNameToDownload;
                            this.logger.debug(" @##@#@#@#@# retry download from local storage in path ....... " + downloadFileName);
                            file = new File(downloadFileName);
                        }
                    }
                    if (!file.exists() && chunkDetail != null && !org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getEncodedName())) {
                        this.logger.debug("File not exists...");
                        this.logger.debug("Chunk storage path is empty to try in folder " + chunkDetail.getEncodedName());
                        downloadFileName = completeDownloadpath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkDetail.getEncodedName();
                        this.logger.debug(" @##@#@#@#@# retry download from local storage in path ....... " + downloadFileName);
                        file = new File(downloadFileName);
                    }
                    if (PCHelperConstant.isGlobalCheckForLocalStorage()) {
                        this.logger.debug("global check is enabled for restore ...");
                        if (!file.exists()) {
                            this.logger.debug(" @##@#@#@#@# retry file does not exist after adding cloud storage path and checking encoded name: so try brute force with md5" + completeDownloadpath + "md5....." + chunkDetail.getMd5());
                            File dir = new File(completeDownloadpath);
                            Object[] destFiles = dir.list((FilenameFilter)new PrefixFileFilter(chunkDetail.getMd5()));
                            this.logger.debug("Check file exist or not for after adding md5 prefix :" + completeDownloadpath);
                            if (ArrayUtils.isNotEmpty((Object[])destFiles)) {
                                file = new File(completeDownloadpath + "/" + (String)destFiles[0]);
                            }
                            this.logger.debug("End of brute force checking for local storage download....");
                        }
                    }
                    if (!PCHelperConstant.isGlobalCheckForLocalStorage()) {
                        this.logger.debug("global check is disabled for restore ...");
                    }
                    if (!file.exists()) {
                        this.logger.debug("..file not exists3....");
                        fileStatusElement.setUploadStatuscode(507);
                        bufferedInputStream = null;
                    }
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 1024);
                }
                catch (Exception e) {
                    this.logger.trace("" + e);
                    this.logger.error(" FILE DOES NOT EXISTS IN LOCAL STORAGE ...." + fileNameToDownload + e.getMessage());
                }
                if (bufferedInputStream != null) {
                    return bufferedInputStream;
                }
            } else {
                if (AWS_S3.equalsIgnoreCase(cc.getProvider()) || S3.equalsIgnoreCase(cc.getProvider()) || BACK_BLAZE.equalsIgnoreCase(cc.getProvider())) {
                    containerNameTemp = cc.getContainerName();
                    if (org.springframework.util.StringUtils.isEmpty((Object)cc.getContainerName())) {
                        containerNameTemp = cc.getIdentity();
                        this.logger.error(CONTAINER_NAME_IS_EMPTY_REMOVE_THIS_LOGIC_TESTING_PURPOSE + containerNameTemp);
                    }
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)containerNameTemp)) {
                    containerNameTemp = PARABLU.toLowerCase();
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)folderName)) {
                    folderName = this.checkPreConditionForCreateContainer(folderName, cloud);
                }
                this.logger.debug(cc.getProvider() + "....folder name after preconditioning......" + folderName);
                boolean isFileDownloaded = this.downloadFromCloud(cc.getProvider(), cc.getIdentity(), cc.getCredential(), cc.getEndPointUrl(), containerNameTemp.toLowerCase(), userNameTemp.toLowerCase(), tempdownloadDir.getPath(), fileNameToDownload, cloudName, deviceUUID, isSync, fileStatusElement, folderName, cloud, cc.getBlobTagName(), currentTime);
                if (!isFileDownloaded) {
                    if (chunkDetail != null && !org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getEncodedName())) {
                        String encodedName = chunkDetail.getEncodedName();
                        chunkDetail.setEncodedName(chunkDetail.getEncodedName() + "-" + System.currentTimeMillis());
                        this.logger.debug("trying file name download in " + chunkDetail.getEncodedName());
                        isFileDownloaded = this.downloadFromCloud(cc.getProvider(), cc.getIdentity(), cc.getCredential(), cc.getEndPointUrl(), containerNameTemp.toLowerCase(), userNameTemp.toLowerCase(), tempdownloadDir.getPath(), chunkDetail.getEncodedName(), cloudName, deviceUUID, isSync, fileStatusElement, folderName, cloud, cc.getBlobTagName(), currentTime);
                        chunkDetail.setEncodedName(encodedName);
                    }
                    if (!isFileDownloaded) {
                        fileStatusElement.setUploadStatuscode(507);
                        return null;
                    }
                }
                downloadFileName = tempdownloadDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileNameToDownload + "-" + currentTime;
                bufferedInputStream = this.getStream(bufferedInputStream, tempdownloadDir, downloadFileName);
                return bufferedInputStream;
            }
        }
        this.logger.error(userNameTemp + " ISODB ENABLED ...or sp enabled.for Download....... " + isODBEnabled + "..." + isSPDestEnabled);
        if (isSPDestEnabled) {
            boolean isPathIsideMiniCloud;
            if (isSync && (isPathIsideMiniCloud = this.isPathInsideMC(miniCloudElementList = this.syncFileDao.getAllMiniClouds(1), mcNameForPath = CloudSupportServiceImpl.getMCName(backupFile.getFilePath())))) {
                userNameTemp = this.getMiniCloudOwner(miniCloudElementList, mcNameForPath);
            }
            this.logger.debug("...inside graph api.....");
            msgTokens = this.pciAuthorizationTokensDao.getMSGTokens(cloud.getCloudId());
            pciTokenElement = this.getMSGTokenElement(msgTokens, user);
            this.logger.debug(userNameTemp + "...username...." + chunkDetail.getUserName());
            chunkuserName = "";
            if (!org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getUserName())) {
                chunkuserName = chunkDetail.getUserName();
            }
            originalFileName = fileNameToDownload;
            if (chunkDetail != null && !org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getEncodedName())) {
                if (userNameTemp != null && !userNameTemp.equalsIgnoreCase(chunkuserName)) {
                    fileNameToDownload = chunkDetail.getEncodedName().replaceAll("/", "_");
                    user = this.utilDao.getUserForName(cloud.getCloudId(), chunkuserName);
                } else {
                    fileNameToDownload = this.getEncodedFileName(fileNameToDownload);
                }
            } else {
                fileNameToDownload = this.getEncodedFileName(fileNameToDownload);
            }
            if (chunkFile.getfSPath() == null) {
                chunkFile.setfSPath(this.convertStringTOBase64(originalFileName).replaceAll("/", "_"));
            }
            if (chunkFile.getCloudStoragePath() == null) {
                chunkFile.setCloudStoragePath("1");
            }
            this.logger.debug(userNameTemp + "...before downloading..." + user);
            if (user == null) {
                user = this.utilDao.getUserForName(cloud.getCloudId(), userNameTemp);
            }
            chunkFile.setOdbLoginId(chunkDetail.getOdbLoginId());
            if (!StringUtils.isEmpty((String)chunkDetail.getDriveId())) {
                fileStatusElement.setDriveId(chunkDetail.getDriveId());
                driveId = chunkDetail.getDriveId();
            } else {
                this.logger.debug(driveId + "....empty driveiddetails1...." + user.getOdbDriveid());
                fileStatusElement.setDriveId(user.getOdbDriveid());
                driveId = user.getOdbDriveid();
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getDeviceUUID())) {
                deviceUUID = chunkDetail.getDeviceUUID();
            }
            bufferedInputStream = this.graphDownloadService.downloadFileFromSPWithPriority1(pciTokenElement, fileNameToDownload, chunkFile, deviceUUID, user.getUserName(), driveId, user, fileStatusElement, graphClient, okHttpClient);
        } else if (isODBEnabled) {
            boolean isPathIsideMiniCloud;
            if (isSync && (isPathIsideMiniCloud = this.isPathInsideMC(miniCloudElementList = this.syncFileDao.getAllMiniClouds(1), mcNameForPath = CloudSupportServiceImpl.getMCName(backupFile.getFilePath())))) {
                userNameTemp = this.getMiniCloudOwner(miniCloudElementList, mcNameForPath);
            }
            cloud.setGraphApiEnabled(1);
            if (cloud.getGraphApiEnabled() == 1) {
                this.logger.debug("...inside graph api.....");
                msgTokens = this.pciAuthorizationTokensDao.getMSGTokens(cloud.getCloudId());
                pciTokenElement = this.getMSGTokenElement(msgTokens, user);
                this.logger.debug(userNameTemp + "...username...." + chunkDetail.getUserName());
                chunkuserName = "";
                if (!org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getUserName())) {
                    chunkuserName = chunkDetail.getUserName();
                }
                originalFileName = fileNameToDownload;
                if (chunkDetail != null && !org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getEncodedName())) {
                    fileNameToDownload = userNameTemp != null && !userNameTemp.equalsIgnoreCase(chunkuserName) ? chunkDetail.getEncodedName().replaceAll("/", "_") : this.getEncodedFileName(fileNameToDownload);
                    user = this.utilDao.getUserForName(cloud.getCloudId(), chunkuserName);
                } else {
                    fileNameToDownload = this.getEncodedFileName(fileNameToDownload);
                }
                if (chunkFile.getfSPath() == null) {
                    chunkFile.setfSPath(this.convertStringTOBase64(originalFileName).replaceAll("/", "_"));
                }
                if (chunkFile.getCloudStoragePath() == null) {
                    chunkFile.setCloudStoragePath("1");
                }
                if (user == null) {
                    user = this.utilDao.getUserForName(cloud.getCloudId(), userNameTemp);
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)chunkDetail.getFileId())) {
                    chunkFile.setFileId(chunkDetail.getFileId());
                } else {
                    chunkFile.setFileId("");
                }
                if (!StringUtils.isEmpty((String)chunkDetail.getDriveId())) {
                    fileStatusElement.setDriveId(chunkDetail.getDriveId());
                    driveId = chunkDetail.getDriveId();
                } else {
                    this.logger.debug(driveId + "....empty driveiddetails1...." + user.getOdbDriveid());
                    fileStatusElement.setDriveId(user.getOdbDriveid());
                    driveId = user.getOdbDriveid();
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)user.getMigratedFolderName())) {
                    String emailId = user.getEmailId();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                        emailId = user.getOdbLoginId();
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)user.getDestOdbLoginId())) {
                        emailId = user.getDestOdbLoginId();
                    }
                    driveId = OneDriveUtil.getPBFolderItemIdWithErrorCode(emailId);
                    fileStatusElement.setDriveId(driveId);
                    chunkFile.setDriveId(driveId);
                }
                this.logger.debug("--- DeviceUUID ODB --- " + deviceUUID);
                if (!org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getDeviceUUID())) {
                    deviceUUID = chunkDetail.getDeviceUUID();
                }
                bufferedInputStream = this.graphDownloadService.downloadFileFromOneDriveWithPriority1(pciTokenElement, fileNameToDownload, chunkFile, deviceUUID, user.getUserName(), driveId, user, fileStatusElement, graphClient, okHttpClient, isSync);
            } else {
                this.logger.debug("...inside sharepoint old api.....");
                PciAuthorizationTokens pciAuthorizationTokens = isODBUserLevelEnabled ? this.utilDao.getPciAuthorizationTokensForUserName(cloud.getCloudId(), userNameTemp) : this.utilDao.getPciAuthorizationTokens(cloud.getCloudId());
                if (pciAuthorizationTokens != null) {
                    pciTokenElement = this.getTokenElement(pciAuthorizationTokens);
                    pciTokenElement.setUserName(userNameTemp);
                    fileNameToDownload = chunkDetail != null && !org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getEncodedName()) ? chunkDetail.getEncodedName().replaceAll("/", "_") : this.convertStringTOBase64(fileNameToDownload).replaceAll("/", "_");
                    if (chunkFile.getfSPath() == null) {
                        chunkFile.setfSPath(this.convertStringTOBase64(fileNameToDownload).replaceAll("/", "_"));
                    }
                    if (chunkFile.getCloudStoragePath() == null) {
                        chunkFile.setCloudStoragePath("1");
                    }
                    this.logger.error(chunkFile.getfSPath() + " Try to download  from ODB..." + chunkFile.getCloudStoragePath());
                    if (user != null) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                            pciTokenElement.setAccountId(user.getEmailId());
                        } else {
                            pciTokenElement.setAccountId(user.getOdbLoginId());
                        }
                    } else if (chunkDetail != null && !org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getOdbLoginId())) {
                        user = new com.parablu.pcbd.domain.User();
                        pciTokenElement.setAccountId(chunkDetail.getOdbLoginId());
                    }
                    if (!isODBUserLevelEnabled) {
                        pciTokenElement.setServiceAcct(true);
                    }
                    long uploadedTimeStamp = 0L;
                    if (chunkDetail != null && !org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getId())) {
                        uploadedTimeStamp = chunkDetail.getId().getTime();
                    } else if (backupFile != null && !org.springframework.util.StringUtils.isEmpty((Object)backupFile.getId())) {
                        uploadedTimeStamp = backupFile.getBackupId().getTime();
                    }
                    bufferedInputStream = this.office365DownloadService.downloadFileFromOneDrive(pciTokenElement, fileNameToDownload, chunkFile, deviceUUID, user, uploadedTimeStamp, isSync);
                    if (bufferedInputStream == null) {
                        fileStatusElement.setUploadStatuscode(507);
                    }
                    this.logger.error(" After down load from ODB..." + bufferedInputStream);
                }
            }
        }
        if (isGDEnabled) {
            boolean isGDServiceAcctEnabled;
            PciAuthorizationTokens pciAuthorizationTokens;
            if (isSync) {
                userNameTemp = this.getUserNameForSync(backupFile, userNameTemp);
            }
            if ((pciAuthorizationTokens = (isGDServiceAcctEnabled = this.isGDServiceAcctEnabled(cloud.getCloudCustomisableDetails())) ? this.utilDao.getPciAuthorizationTokens(cloud.getCloudId()) : this.utilDao.getPciAuthorizationTokensForUserName(cloud.getCloudId(), userNameTemp)) != null) {
                GoogleDriveUtil googleDriveUtil;
                PciAuthorizationTokenElement pciTokenElement2 = this.getTokenElement(pciAuthorizationTokens);
                pciTokenElement2.setUserName(userNameTemp);
                if (chunkFile.getfSPath() == null) {
                    chunkFile.setfSPath(this.convertStringTOBase64(chunkFile.getFileName()).replaceAll("/", "_"));
                }
                if (chunkFile.getCloudStoragePath() == null) {
                    chunkFile.setCloudStoragePath("1");
                }
                this.logger.error(chunkFile.getfSPath() + " Try to download  from GD..." + chunkFile.getCloudStoragePath());
                if (user != null) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                        pciTokenElement2.setAccountId(user.getEmailId());
                    } else {
                        pciTokenElement2.setAccountId(user.getOdbLoginId());
                    }
                    if (org.springframework.util.StringUtils.isEmpty((Object)userNameTemp)) {
                        pciTokenElement2.setUserName(user.getUserName());
                    } else {
                        pciTokenElement2.setUserName(userNameTemp);
                    }
                }
                if ((bufferedInputStream = (googleDriveUtil = GoogleDriveUtil.getInstance()).downloadFileFromGD(pciTokenElement2, fileNameToDownload, isGDServiceAcctEnabled)) == null) {
                    fileStatusElement.setUploadStatuscode(507);
                }
                this.logger.error(" After down load from GD..." + bufferedInputStream);
            }
        }
        return bufferedInputStream;
    }

    private String getEncodedFileName(String fileNameToDownload) {
        fileNameToDownload = fileNameToDownload.startsWith("part") ? this.removeIdFromChunkName(fileNameToDownload) : CloudSupportServiceImpl.getMd5FromFileName(fileNameToDownload);
        fileNameToDownload = this.convertStringTOBase64(fileNameToDownload).replaceAll("/", "_");
        return fileNameToDownload;
    }

    private PciAuthorizationTokenElement getMSGTokenElement(MSGTokens msgTokens, com.parablu.pcbd.domain.User user) {
        PciAuthorizationTokenElement tokenElement = new PciAuthorizationTokenElement();
        if (msgTokens == null) {
            return tokenElement;
        }
        tokenElement.setAccessToken(msgTokens.getAccessToken());
        tokenElement.setClientId(msgTokens.getClientId());
        tokenElement.setClientSecret(msgTokens.getClientSecret());
        tokenElement.setRedirectUri(msgTokens.getRedirectUri());
        tokenElement.setRefreshToken(msgTokens.getRefreshToken());
        tokenElement.setAccountId(msgTokens.getAccountId());
        tokenElement.setSharePointUrl(msgTokens.getSharePointUrl());
        tokenElement.setCloudName(msgTokens.getCloudName());
        if (user != null) {
            if (org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                tokenElement.setAccountId(user.getEmailId());
            } else {
                tokenElement.setAccountId(user.getOdbLoginId());
            }
            tokenElement.setUserName(user.getUserName());
        }
        return tokenElement;
    }

    private String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5((String)name);
            byte[] bytesEncoded = Base64.encodeBase64((byte[])bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            this.logger.debug("ecncoded value for given string is " + base64EncodeString);
        }
        return base64EncodeString;
    }

    private static String getMd5FromFileName(String fileName) {
        int occurance = org.springframework.util.StringUtils.countOccurrencesOf((String)fileName, (String)".");
        String md5 = "";
        if (occurance == 1 && !fileName.startsWith("part")) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance == 1 && fileName.startsWith("part")) {
            md5 = fileName.substring(fileName.lastIndexOf(46) + 1);
        } else if (occurance == 0) {
            md5 = fileName;
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)md5) && md5.contains("_")) {
            md5 = md5.substring(0, md5.lastIndexOf("_"));
        }
        return md5;
    }

    private File downloadPathDir(String deviceUUID, String cloudName, boolean isSync, String restorePath) {
        File tempdownloadDir;
        if (isSync) {
            String path = restorePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            tempdownloadDir = new File(restorePath);
            this.logger.debug(tempdownloadDir.getPath() + " path inside sync ........... " + path);
            if (!tempdownloadDir.exists()) {
                tempdownloadDir.mkdirs();
            }
        } else {
            String path = restorePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            tempdownloadDir = new File(path + "tempdownloadbackup");
            if (!tempdownloadDir.exists()) {
                tempdownloadDir.mkdirs();
            }
        }
        return tempdownloadDir;
    }

    private BufferedInputStream getStream(BufferedInputStream bufferedInputStream, File tempdownloadDir, String downloadFileName) {
        File file;
        BufferedInputStream bufferedInputStreamTemp = bufferedInputStream;
        InputStream inputStream = this.convertFileToInputStream(downloadFileName);
        if (inputStream != null) {
            this.logger.debug("inside change input stream..................");
            bufferedInputStreamTemp = new BufferedInputStream(inputStream, 1024);
        }
        if ((file = new File(downloadFileName)).exists()) {
            file.delete();
        }
        return bufferedInputStreamTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadFromCloud(String provider, String identity, String passKey, String endpointUrl, String containerName, String userName, String filePath, String fileName, String cloudName, String deviceUUID, boolean isSync, FileStatusElement fileStatusElement, String folderName, Cloud cloud, String blobTagName, long currentTime) {
        this.logger.debug("--- Download from cloud DeviceUUID --- " + deviceUUID);
        String containerNameTemp = containerName;
        boolean isFileDownloaded = false;
        String fileNameToWrite = fileName + "-" + currentTime;
        ContextBuilder credentials = ContextBuilder.newBuilder((String)provider).credentials(identity, passKey);
        if ("swift".equalsIgnoreCase(provider) || S3.equalsIgnoreCase(provider)) {
            credentials.endpoint(endpointUrl);
        }
        containerNameTemp = this.checkPreConditionForCreateContainer(containerNameTemp, cloud);
        try (BlobStoreContext context = this.getBlobStoreContext(provider, identity, passKey, endpointUrl, NUM_1048576, 2, blobTagName);){
            if (org.springframework.util.StringUtils.isEmpty((Object)containerNameTemp)) {
                containerNameTemp = PARABLU.toLowerCase();
            }
            containerNameTemp = containerNameTemp.replaceAll(" ", "-");
            ApiMetadata apiMetadata = context.unwrap().getProviderMetadata().getApiMetadata();
            if (apiMetadata instanceof S3ApiMetadata) {
                this.logger.debug(folderName + " downloading  from S3 .... " + fileName + IN_CONTAINER + containerNameTemp);
                S3Client api = (S3Client)context.unwrapApi(S3Client.class);
                String as3fileName = folderName + "/" + fileName;
                S3Object result = api.getObject(containerNameTemp, as3fileName, new GetOptions[]{new GetOptions()});
                Payload payload = result.getPayload();
                this.writeFile(filePath, fileNameToWrite, payload);
                isFileDownloaded = true;
            } else if (apiMetadata instanceof SwiftApiMetadata) {
                this.logger.debug(" downloading  from IBM Softlayer .... " + fileName + IN_CONTAINER + containerNameTemp);
                SwiftApi swiftApi = (SwiftApi)context.unwrapApi(SwiftApi.class);
                ObjectApi objectApi = swiftApi.getObjectApi("RegionOne", containerNameTemp);
                SwiftObject result = objectApi.get(fileName, new GetOptions());
                Payload payload = result.getPayload();
                this.writeFile(filePath, fileNameToWrite, payload);
                isFileDownloaded = true;
            } else if (apiMetadata instanceof AzureBlobApiMetadata) {
                this.logger.debug(" downloading  from Azure blob .... " + fileName + IN_CONTAINER + containerNameTemp);
                AzureBlobClient api = (AzureBlobClient)context.unwrapApi(AzureBlobClient.class);
                AzureBlob result = api.getBlob(containerNameTemp, fileName, new GetOptions[]{new GetOptions()});
                if (result == null) {
                    this.logger.debug("Blob doesnt exist in the azure....");
                    fileStatusElement.setUploadStatuscode(507);
                    isFileDownloaded = false;
                } else {
                    isFileDownloaded = true;
                    Payload payload = result.getPayload();
                    this.writeFile(filePath, fileNameToWrite, payload);
                }
            } else if (apiMetadata instanceof B2ApiMetadata) {
                this.logger.debug(folderName + " downloading  from b2 .... " + fileName + IN_CONTAINER + containerNameTemp);
                B2Api b2Api = (B2Api)context.unwrapApi(B2Api.class);
                String b2fileName = folderName + "/" + fileName;
                B2Object downloadFileByName = b2Api.getObjectApi().downloadFileByName(containerNameTemp, b2fileName, new GetOptions());
                Payload payload = downloadFileByName.payload();
                this.writeFile(filePath, fileNameToWrite, payload);
                isFileDownloaded = true;
                this.logger.debug(" downloaded  from b2 .... ");
            }
        }
        if (PCHelperConstant.getPropertyFileValueSyncFtpEnabled()) {
            this.downloadFileFromLocalServer(fileName, cloudName, deviceUUID);
            isFileDownloaded = true;
        }
        return isFileDownloaded;
    }

    private void writeFile(String filePath, String fileName, Payload payload) {
        try (InputStream inputStream = payload.openStream();
             FileOutputStream outputStream = new FileOutputStream(new File(filePath + "/" + fileName));){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
            outputStream.close();
            this.logger.debug("Done!............. " + filePath + "/" + fileName + "..File length>>>" + new File(filePath + "/" + fileName).length());
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(filePath + " Error  trying to download .... " + e.getMessage());
        }
    }

    private synchronized String checkDriveStoragePath(String cloudName, String userName, boolean isSync) {
        BackupFile latestFile = isSync ? this.syncFileDao.getLastSyncFile(1, cloudName, userName) : this.utilDao.getLastBackupFile(1, cloudName, userName);
        this.logger.debug(isSync + "**************************8 latest files ...... " + latestFile);
        String cloudStoragePath = "1";
        if (latestFile != null) {
            this.logger.debug("latestfile storagepath>>>>>>>>>>>>  " + latestFile.getId().toString());
            cloudStoragePath = this.getLastStoragePath(latestFile);
        }
        this.logger.debug(userName + "Inside check storagepath>>>>>>>>>>>>" + cloudStoragePath);
        return cloudStoragePath;
    }

    private ArrayList<Integer> splitPathAndGetFolderDepth(String cloudStoragePath) {
        ArrayList<Integer> pathListNumbers = new ArrayList<Integer>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)cloudStoragePath)) {
            String[] pathList;
            for (String path : pathList = cloudStoragePath.split("/")) {
                pathListNumbers.add(Integer.parseInt(path));
            }
        }
        return pathListNumbers;
    }

    private synchronized String checkDriveStoragePathAndCount(ArrayList<Integer> folderNameList, int count) {
        int countTemp = count;
        String cloudStoragePath = "";
        int folderDepthSize = folderNameList.size();
        int maxFileCount = 4000;
        if (folderDepthSize == 1) {
            int folderValue = folderNameList.get(0);
            if (folderValue <= 900) {
                if (countTemp < maxFileCount) {
                    cloudStoragePath = String.valueOf(folderValue);
                } else if (folderValue < 900) {
                    countTemp = 0;
                    folderNameList.set(0, folderValue + 1);
                    cloudStoragePath = String.valueOf(folderValue + 1);
                } else if (folderValue >= 900) {
                    folderNameList.clear();
                    countTemp = 0;
                    folderNameList.add(0, 1);
                    folderNameList.add(1, 1);
                    cloudStoragePath = "1/1";
                }
            }
            ++countTemp;
        } else {
            int lastFolder = folderNameList.get(folderDepthSize - 1);
            int previousFolder = folderNameList.get(folderDepthSize - 2);
            if (lastFolder <= 900) {
                if (countTemp < maxFileCount) {
                    cloudStoragePath = String.valueOf(previousFolder + "/" + lastFolder);
                } else if (lastFolder < 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, lastFolder + 1);
                    cloudStoragePath = String.valueOf(previousFolder + "/" + ++lastFolder);
                } else if (lastFolder >= 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, 1);
                    folderNameList.set(folderDepthSize - 2, previousFolder + 1);
                    cloudStoragePath = ++previousFolder + "/1";
                }
            }
            ++countTemp;
        }
        this.logger.debug(maxFileCount + " max size " + cloudStoragePath + " endo of method ........" + countTemp);
        return cloudStoragePath;
    }

    private String getLastStoragePath(BackupFile fileInfo) {
        String lastStoragePathForSameFile = "1";
        List files = fileInfo.getChunkFiles();
        if (!CollectionUtils.isEmpty((Collection)files)) {
            Collections.sort(files, new Comparator<ChunkFile>(){

                @Override
                public int compare(ChunkFile c1, ChunkFile c2) {
                    long t1 = c1.getUploadedTimeStamp();
                    long t2 = c2.getUploadedTimeStamp();
                    if (t2 > t1) {
                        return 1;
                    }
                    if (t1 > t2) {
                        return -1;
                    }
                    return 0;
                }
            });
            ChunkFile chunkFile = (ChunkFile)files.get(0);
            if (!org.springframework.util.StringUtils.isEmpty((Object)chunkFile.getCloudStoragePath())) {
                lastStoragePathForSameFile = chunkFile.getCloudStoragePath();
            }
        }
        return lastStoragePathForSameFile;
    }

    private boolean isPathInsideMC(List<MiniCloud> cloudElementList, String mcNameFromPath) {
        if (org.springframework.util.StringUtils.isEmpty((Object)mcNameFromPath)) {
            return false;
        }
        boolean isPathInsideMC = false;
        for (MiniCloud miniCloudElement : cloudElementList) {
            if (!mcNameFromPath.equalsIgnoreCase(miniCloudElement.getMiniCloudName())) continue;
            isPathInsideMC = true;
            break;
        }
        return isPathInsideMC;
    }

    private static String getMCName(String path) {
        String[] list = path.split("/");
        if (list != null && list.length == 1) {
            return "";
        }
        return list[1];
    }

    private String getMiniCloudOwner(List<MiniCloud> miniCloudList, String miniCloudName) {
        for (MiniCloud miniCloud : miniCloudList) {
            if (!miniCloud.getMiniCloudName().equalsIgnoreCase(miniCloudName)) continue;
            return miniCloud.getOwner();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileStatusElement deleteFromCloud(Cloud cloud, String containerName, String fileName, String userName, boolean isSync, ChunkDetail chunkDetail) {
        block29: {
            block30: {
                containerNameTemp = containerName;
                userNameTemp = userName;
                fileElement = new FileStatusElement();
                fileElement.setDeleteStatus(false);
                cloudName = "";
                user = null;
                try {
                    cloudCredentialsList = cloud.getCloudCredentials();
                    user = this.utilDao.getUserForName(cloud.getCloudId(), userNameTemp);
                    if (user != null && !org.springframework.util.StringUtils.isEmpty((Object)user.getPolicyName()) && (backupPolicy = this.utilDao.getBackupPolicy(cloud.getCloudId(), user.getPolicyName())) != null && (cloudCredentials = backupPolicy.getCloudCredentials()) != null) {
                        cloudCredentialsList.add(cloudCredentials);
                    }
                    if (CollectionUtils.isEmpty((Collection)cloudCredentialsList)) {
                        cloudCredentialsList = cloud.getCloudCredentials();
                    }
                    isODBEnabled = false;
                    isGDEnabled = false;
                    if (cloud.getBlukryptStorageEnabled() == 1) {
                        cloudCredentialsList = new ArrayList<CloudCredentials>();
                        pgStorageMapping = this.utilDao.getBluKryptStorageMapping(cloud.getCloudId());
                        this.logger.debug(".....inside pgstoragemapping ...." + PCHelperConstant.getComponentName());
                        if (pgStorageMapping != null) {
                            cloudCredentialsTypeList = pgStorageMapping.getCloudCredentials();
                            if (CollectionUtils.isEmpty((Collection)cloudCredentialsTypeList)) break block29;
                            var17_21 = pgStorageMapping.getCloudCredentials().iterator();
                            break block30;
                        }
                    } else {
                        cloudCredentialsList = cloud.getCloudCredentials();
                        licenseDetails = cloud.getCloudCustomisableDetails();
                        isODBEnabled = this.isODBEnabled(licenseDetails);
                        isGDEnabled = this.isGDEnabled(licenseDetails);
                    }
lbl31:
                    // 3 sources

                    while (true) {
                        cloud.setGraphApiEnabled(1);
                        licenseDetails = cloud.getCloudCustomisableDetails();
                        this.logger.debug("######is isGDEnabled....." + isGDEnabled);
                        this.logger.debug(cloud.getGraphApiEnabled() + " graph ######is odb enabled....." + isODBEnabled);
                        if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                            this.logger.debug("###### graph enabled....." + cloud.getGraphApiEnabled());
                            if (user == null && (deletedUser = this.utilDao.getDeletedUserForName(cloud.getCloudId(), userNameTemp)) != null) {
                                user = new com.parablu.pcbd.domain.User();
                                BeanUtils.copyProperties((Object)deletedUser, (Object)user);
                            }
                            emailId = chunkDetail.getOdbLoginId();
                            driveId = chunkDetail.getDriveId();
                            if (org.springframework.util.StringUtils.isEmpty((Object)emailId) && user == null) {
                                this.utilDao.moveChunkDetailToDeleteCollection(cloud.getCloudId(), chunkDetail);
                                this.logger.debug("chunk user not found ..." + chunkDetail.getUserName());
                                fileStatusElement = new FileStatusElement();
                                fileStatusElement.setDeleteStatus(true);
                                return fileStatusElement;
                            }
                            if (org.springframework.util.StringUtils.isEmpty((Object)emailId)) {
                                emailId = user.getEmailId();
                                if (!org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                                    emailId = user.getOdbLoginId();
                                }
                                if (!org.springframework.util.StringUtils.isEmpty((Object)user.getDestOdbLoginId())) {
                                    emailId = user.getDestOdbLoginId();
                                }
                                driveId = user.getOdbDriveid();
                            }
                            if (StringUtils.isEmpty((String)driveId) || "404".equalsIgnoreCase(driveId) || "409".equals(driveId) || "400".equalsIgnoreCase(driveId)) {
                                driveId = OneDriveUtil.getPBFolderItemIdWithErrorCode(emailId.toLowerCase());
                            }
                            this.logger.debug(chunkDetail.getUserName() + ".....drive id...." + driveId);
                            fileElement = this.deleteFileFromODBUsingGraph(cloud, fileName, isSync, chunkDetail, userNameTemp, fileElement, user, driveId);
                        } else if (isODBEnabled) {
                            fileElement = this.deleteFileFromODB(cloud, fileName, isSync, chunkDetail, userNameTemp, fileElement, user, licenseDetails);
                        }
                        if (!CollectionUtils.isEmpty(cloudCredentialsList)) {
                            isLocalStorageEnabled = false;
                            for (CloudCredentials cc : cloudCredentialsList) {
                                if (cc == null) continue;
                                this.logger.debug(" uploading to cloud .... " + cc.getCloudName());
                                try {
                                    cloudName = cc.getCloudName();
                                    if ("localStorage".equalsIgnoreCase(cc.getCloudName())) {
                                        isLocalStorageEnabled = true;
                                    }
                                    directoryName = "";
                                    if ("aws-s3".equalsIgnoreCase(cc.getProvider()) || "s3".equalsIgnoreCase(cc.getProvider()) || "b2".equalsIgnoreCase(cc.getProvider())) {
                                        directoryName = userNameTemp;
                                        containerNameTemp = cc.getContainerName();
                                        if (org.springframework.util.StringUtils.isEmpty((Object)cc.getContainerName())) {
                                            containerNameTemp = cc.getIdentity();
                                            this.logger.error(" CONTAINER NAME IS EMPTY............ Remove this logic ... Testing purpose" + containerNameTemp);
                                        }
                                    }
                                    if (isLocalStorageEnabled) {
                                        this.deleteChunkFromLocalStorage(isSync, chunkDetail, fileElement, cloudCredentialsList, cc);
                                        return fileElement;
                                    }
                                    fileElement.setDeleteStatus(this.deleteFromAppropriateCloud(cc.getProvider(), cc.getIdentity(), cc.getCredential(), cc.getEndPointUrl(), containerNameTemp, fileName, directoryName, isSync, cloud, cc.getBlobTagName()));
                                    this.logger.debug(" uploading to cloud .... " + cc.getCloudName() + " completed .." + fileElement.getDeleteStatuscode());
                                    return fileElement;
                                }
                                catch (Exception e) {
                                    this.logger.trace("" + e);
                                    this.logger.error(" $$ upload to blob storage cloud  " + cloudName + " failed." + e.getMessage());
                                }
                            }
                        }
                        if (isGDEnabled) {
                            return this.deleteChunkFromGD(cloud, chunkDetail, userNameTemp, fileElement, user, licenseDetails, isODBEnabled);
                        }
                        if (!PCHelperConstant.getPropertyFileValueSyncFtpEnabled()) {
                            // empty if block
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.trace("" + e);
                    this.logger.error(" $$ upload to cloud  " + cloudName + " failed." + e.getMessage());
                    fileElement.setDeleteStatus(false);
                }
                this.logger.debug(fileElement.isDeleteStatus() + " deleteFromCloud status ");
                return fileElement;
            }
            while (var17_21.hasNext()) {
                cloudCredentialsType = (String)var17_21.next();
                for (CloudCredentials cloudCredentials : cloud.getCloudCredentials()) {
                    if (cloudCredentials == null || !cloudCredentialsType.equalsIgnoreCase(cloudCredentials.getCloudName())) continue;
                    cloudCredentialsList = new ArrayList<E>();
                    cloudCredentialsList.add(cloudCredentials);
                }
            }
        }
        this.logger.debug(cloudCredentialsTypeList + ".....inside pgstoragemapping1 ...." + PCHelperConstant.getComponentName());
        isODBEnabled = pgStorageMapping.isODBEnabled();
        isGDEnabled = pgStorageMapping.isGDEnabled();
        this.logger.debug(cloudCredentialsTypeList + ".....inside pgstoragemapping latest 2...." + isODBEnabled + "....");
        ** while (true)
    }

    private FileStatusElement deleteFileFromODBUsingGraph(Cloud cloud, String fileName, boolean isSync, ChunkDetail chunkDetail, String userNameTemp, FileStatusElement fileElement, com.parablu.pcbd.domain.User user1, String driveId) {
        List devices;
        if (isSync) {
            // empty if block
        }
        this.logger.debug("...inside delete from cloud....");
        OneDriveUtil odbUtil = OneDriveUtil.getInstance();
        String deviceUUID = chunkDetail.getDeviceUUID();
        this.logger.debug(chunkDetail.getEncodedName() + "....fileName........." + fileName);
        String chunkuserName = "";
        if (!org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getUserName())) {
            chunkuserName = chunkDetail.getUserName();
        }
        if (chunkDetail != null && !org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getEncodedName()) && !userNameTemp.equalsIgnoreCase(chunkuserName)) {
            fileName = chunkDetail.getEncodedName().replaceAll("/", "_");
        } else {
            if (org.springframework.util.StringUtils.isEmpty((Object)fileName)) {
                fileName = chunkDetail.getMd5();
                this.logger.debug(chunkDetail.getMd5() + ".....nulfilename....." + fileName);
            }
            this.logger.debug(".....filename....." + fileName);
            fileName = this.getEncodedFileName(fileName);
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)deviceUUID)) {
            try {
                String path = chunkDetail.getFsPath();
                if (!org.springframework.util.StringUtils.isEmpty((Object)path)) {
                    String[] parts = path.split("/");
                    deviceUUID = parts[4];
                    chunkDetail.setDeviceUUID(deviceUUID);
                }
            }
            catch (Exception e) {
                this.logger.error(chunkDetail.getUserName() + "....unable to get deviceuuid for delete.." + chunkDetail.getId());
            }
        }
        this.logger.debug(deviceUUID + ".....deletelogic...." + fileName);
        this.logger.debug(chunkDetail.getCloudChunkName() + "...fileName.....fileName...." + fileName);
        if (org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getDeviceUUID()) && !CollectionUtils.isEmpty((Collection)(devices = this.utilDao.getAllDevicesForUser(cloud.getCloudId(), chunkDetail.getUserName())))) {
            for (Device device : devices) {
                if (device == null || !(fileElement = odbUtil.deleteFromODBUsingGraph(fileName, chunkDetail.getCloudStoragePath(), device.getDeviceUUID(), driveId)).isDeleteStatus()) continue;
                return fileElement;
            }
        }
        fileElement = odbUtil.deleteFromODBUsingGraph(fileName, chunkDetail.getCloudStoragePath(), deviceUUID, driveId);
        return fileElement;
    }

    private FileStatusElement deleteFileFromODB(Cloud cloud, String fileName, boolean isSync, ChunkDetail chunkDetail, String userNameTemp, FileStatusElement fileElement, com.parablu.pcbd.domain.User user, List<CloudCustomisableDetails> licenseDetails) {
        PciAuthorizationTokens pciAuthorizationTokens;
        boolean isODBUserLevelEnabled = this.isODBUserLevelEnabled(licenseDetails);
        this.logger.error(userNameTemp + " ISODB ENABLED inside delete file from odb........ ");
        if (isSync) {
            // empty if block
        }
        boolean isServiceAcct = false;
        if (isODBUserLevelEnabled) {
            pciAuthorizationTokens = this.utilDao.getPciAuthorizationTokensForUserName(cloud.getCloudId(), userNameTemp);
        } else {
            pciAuthorizationTokens = this.utilDao.getPciAuthorizationTokens(cloud.getCloudId());
            isServiceAcct = true;
        }
        if (pciAuthorizationTokens != null) {
            List devices;
            PciAuthorizationTokenElement pciTokenElement = this.getTokenElement(pciAuthorizationTokens);
            pciTokenElement.setUserName(userNameTemp);
            pciTokenElement.setServiceAcct(isServiceAcct);
            OneDriveUtil odbUtil = OneDriveUtil.getInstance();
            if (user != null) {
                if (org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                    pciTokenElement.setAccountId(user.getEmailId().toLowerCase());
                } else {
                    pciTokenElement.setAccountId(user.getOdbLoginId().toLowerCase());
                }
                this.logger.debug(user.getOdbLoginId() + " ....uploading using odbutil for user login id....... " + user.getEmailId());
            } else {
                this.logger.debug("user is null inside delete from odb...");
            }
            String deviceUUID = chunkDetail.getDeviceUUID();
            this.logger.debug("fileName........." + fileName);
            fileName = chunkDetail != null && !org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getEncodedName()) ? chunkDetail.getEncodedName().replaceAll("/", "_") : this.getEncodedFileName(fileName);
            this.logger.debug("fileName.....fileName...." + fileName);
            if (org.springframework.util.StringUtils.isEmpty((Object)chunkDetail.getDeviceUUID()) && !CollectionUtils.isEmpty((Collection)(devices = this.utilDao.getAllDevicesForUser(cloud.getCloudId(), user.getUserName())))) {
                for (Device device : devices) {
                    if (device == null || !(fileElement = odbUtil.deleteFromODB(pciTokenElement, fileName, chunkDetail.getCloudStoragePath(), device.getDeviceUUID(), isSync)).isDeleteStatus()) continue;
                    return fileElement;
                }
            }
            fileElement = odbUtil.deleteFromODB(pciTokenElement, fileName, chunkDetail.getCloudStoragePath(), deviceUUID, isSync);
        }
        return fileElement;
    }

    private String removeIdFromChunkName(String encryptedFileName) {
        try {
            long count = encryptedFileName.chars().filter(ch -> ch == 46).count();
            if (count >= 2L) {
                String[] split = encryptedFileName.split("\\.");
                encryptedFileName = encryptedFileName.replaceAll("." + split[2], "");
            }
            if (encryptedFileName.contains("_")) {
                encryptedFileName = encryptedFileName.substring(0, encryptedFileName.indexOf("_"));
            }
        }
        catch (Exception e) {
            this.logger.error("error in Encoding the chunk name " + encryptedFileName + e.getMessage());
            this.logger.trace("" + e);
        }
        this.logger.debug("..encryptedFileName.." + encryptedFileName);
        return encryptedFileName;
    }

    private void deleteChunkFromLocalStorage(boolean isSync, ChunkDetail chunkDetail, FileStatusElement fileElement, List<CloudCredentials> cloudCredentialsList, CloudCredentials cc) {
        cc.setProvider("filesystem");
        fileElement.setDeleteStatus(this.deleteFromLocalStorage(cloudCredentialsList, cc.getProvider(), chunkDetail.getContainerName(), chunkDetail.getCloudChunkName(), chunkDetail.getCloudStoragePath(), isSync));
    }

    private FileStatusElement deleteChunkFromGD(Cloud cloud, ChunkDetail chunkDetail, String userNameTemp, FileStatusElement fileElement, com.parablu.pcbd.domain.User user1, List<CloudCustomisableDetails> licenseDetails, boolean isODBEnabled) {
        boolean isGDServiceAcctEnabled = this.isGDServiceAcctEnabled(licenseDetails);
        String odbLoginId = "";
        this.logger.error(userNameTemp + " Google drive ENABLED ........ " + isODBEnabled + "......" + odbLoginId);
        PciAuthorizationTokens pciAuthorizationTokens = isGDServiceAcctEnabled ? this.utilDao.getPciAuthorizationTokens(cloud.getCloudId()) : this.utilDao.getPciAuthorizationTokensForUserName(cloud.getCloudId(), userNameTemp);
        if (pciAuthorizationTokens != null) {
            PciAuthorizationTokenElement pciTokenElement = this.getTokenElement(pciAuthorizationTokens);
            pciTokenElement.setUserName(userNameTemp);
            GoogleDriveUtil googleDriveUtil = GoogleDriveUtil.getInstance();
            pciTokenElement.setCloudName(cloud.getCloudName());
            this.logger.debug(odbLoginId + " ....uploading using googleDriveUtil for user login id....... ");
            boolean deleteStatus = googleDriveUtil.deleteFromGD(pciTokenElement, chunkDetail.getCloudChunkName(), isGDServiceAcctEnabled);
            this.logger.debug("Chunk got deleted.........." + deleteStatus);
            fileElement.setDeleteStatus(deleteStatus);
        } else {
            fileElement.setDeleteStatus(false);
            this.logger.error(" Google drive account has expired or not configured for user ... " + userNameTemp);
        }
        return fileElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFromAppropriateCloud(String provider, String identity, String passKey, String endpointUrl, String containerName, String fileName, String directoryName, boolean isSync, Cloud cloud, String blobTagName) {
        boolean deleteSuccess = false;
        String containerNameTemp = containerName;
        BlobStoreContext context = this.getBlobStoreContext(provider, identity, passKey, endpointUrl, NUM_1048576, 2, blobTagName);
        containerNameTemp = this.checkPreConditionForCreateContainer(containerNameTemp, cloud);
        try {
            ApiMetadata apiMetadata = context.unwrap().getProviderMetadata().getApiMetadata();
            BlobStore blobStore = context.getBlobStore();
            Location location = null;
            if (apiMetadata instanceof SwiftApiMetadata) {
                location = (Location)Iterables.getFirst((Iterable)blobStore.listAssignableLocations(), null);
            }
            if (!blobStore.containerExists(containerNameTemp)) {
                blobStore.createContainerInLocation(location, containerNameTemp);
            }
            if ((AWS_S3.equalsIgnoreCase(provider) || S3.equalsIgnoreCase(provider) || BACK_BLAZE.equalsIgnoreCase(provider)) && !org.springframework.util.StringUtils.isEmpty((Object)directoryName)) {
                if (isSync) {
                    directoryName = PARABLU.toLowerCase();
                }
                fileName = directoryName + "/" + fileName;
            }
            this.logger.debug("containerNameTemp..." + containerNameTemp + provider + " upload to dir ...." + directoryName + ". flag..." + isSync + ".....fileName....." + fileName);
            blobStore.removeBlob(containerNameTemp, fileName);
            this.logger.debug("delete @@SUCCESSFUL.......");
            deleteSuccess = true;
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(" ....delete failed .... " + e.getMessage());
            deleteSuccess = false;
        }
        finally {
            context.close();
        }
        return deleteSuccess;
    }

    private boolean isLocalStorageEnabled(Cloud cloud) {
        boolean isLocalStorageEnabled = false;
        for (CloudCredentials cc : cloud.getCloudCredentials()) {
            if (cc == null || !LOCAL_STORAGE.equalsIgnoreCase(cc.getCloudName())) continue;
            isLocalStorageEnabled = true;
            break;
        }
        return isLocalStorageEnabled;
    }

    private boolean deleteFromLocalStorage(List<CloudCredentials> cloudCredentialsList, String provider, String containerName, String fileName, String cloudStoragePath, boolean isSync) {
        String pathByProductType;
        String pathByContainerName;
        String chunkFolderPath;
        File newfile;
        boolean deleteSuccess = false;
        String productType = "";
        String loaclStorageBasePath = this.getLocalStoragePath(cloudCredentialsList);
        this.logger.debug("..........loaclStorageBasePath...." + loaclStorageBasePath);
        productType = isSync ? "sync" : "backup";
        if (org.springframework.util.StringUtils.isEmpty((Object)cloudStoragePath)) {
            cloudStoragePath = "1";
        }
        if (!(newfile = new File(chunkFolderPath = (pathByContainerName = (pathByProductType = loaclStorageBasePath + "/" + productType) + "/" + containerName) + "/" + cloudStoragePath)).exists()) {
            newfile.mkdirs();
        }
        try {
            this.logger.debug(provider + " upload to dir ...." + cloudStoragePath + ". flag..." + isSync);
            File localFile = new File(newfile.getAbsolutePath() + "/" + fileName);
            if (localFile.exists()) {
                localFile.delete();
            } else {
                this.logger.debug("File not exists...:");
            }
            this.logger.debug("delete @@SUCCESSFUL.......");
            deleteSuccess = true;
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(" ....delete failed .... " + e.getMessage());
            deleteSuccess = false;
        }
        return deleteSuccess;
    }

    @Override
    public void deleteFile(Cloud cloud, com.pg.domain.BackupFile backupFile) {
        List cloudCredentialsList = cloud.getCloudCredentials();
        CloudCredentials cc = null;
        if (!CollectionUtils.isEmpty((Collection)cloudCredentialsList)) {
            cc = (CloudCredentials)cloudCredentialsList.get(0);
        }
        List chunkFiles = backupFile.getChunkFiles();
        if (cc != null) {
            for (com.pg.domain.ChunkFile file : chunkFiles) {
                String fileNameToDelete = file.getFileName() + "." + backupFile.getId();
                this.logger.debug(" file to delete from cloud ........." + fileNameToDelete);
                this.deleteFromCloud(cc.getProvider(), cc.getIdentity(), cc.getCredential(), cc.getEndPointUrl(), fileNameToDelete, cloud, cc.getBlobTagName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFromCloud(String provider, String identity, String passKey, String endpointUrl, String fileName, Cloud cloud, String blobTagName) {
        String containerNameTemp = PARABLU.toLowerCase();
        BlobStoreContext context = this.getBlobStoreContext(provider, identity, passKey, endpointUrl, NUM_1048576, 2, blobTagName);
        containerNameTemp = this.checkPreConditionForCreateContainer(containerNameTemp, cloud);
        try {
            ApiMetadata apiMetadata = context.unwrap().getProviderMetadata().getApiMetadata();
            BlobStore blobStore = context.getBlobStore();
            Location location = null;
            if (apiMetadata instanceof SwiftApiMetadata) {
                location = (Location)Iterables.getFirst((Iterable)blobStore.listAssignableLocations(), null);
            }
            if (!blobStore.containerExists(containerNameTemp)) {
                blobStore.createContainerInLocation(location, containerNameTemp);
            }
            blobStore.removeBlob(containerNameTemp, fileName);
            this.logger.debug("delete @@SUCCESSFUL.......");
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(" ....delete failed .... " + e.getMessage());
        }
        finally {
            context.close();
        }
    }

    private String getLocalStoragePath(List<CloudCredentials> cloudCredentialsList) {
        String cloudStoragePath = PCHelperConstant.getPropertyFileValueParacloudMountPoint();
        for (CloudCredentials cc : cloudCredentialsList) {
            if (cc == null) continue;
            this.logger.debug(UPLOADING_TO_CLOUD + cc.getCloudName());
            if (!LOCAL_STORAGE.equalsIgnoreCase(cc.getCloudName())) continue;
            cloudStoragePath = cc.getEndPointUrl();
        }
        return cloudStoragePath;
    }

    public void setOffice365UploadService(Office365UploadServiceImpl office365UploadService) {
        this.office365UploadService = office365UploadService;
    }

    @Override
    public int getCountOfFilesInFolder(Cloud cloud, String cloudStoragePath, String deviceUUID, String userName, boolean isSync) {
        int itemCount = 0;
        com.parablu.pcbd.domain.User user = this.utilDao.getUserForName(cloud.getCloudId(), userName);
        String emailId = user.getEmailId();
        if (!org.springframework.util.StringUtils.isEmpty((Object)user.getOdbLoginId())) {
            emailId = user.getOdbLoginId();
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)user.getDestOdbLoginId())) {
            emailId = user.getDestOdbLoginId();
        }
        itemCount = OneDriveUtil.getInstance().getCountOFFilesInFolderUsingGraph(emailId, deviceUUID, cloudStoragePath, user, isSync);
        this.logger.debug(cloudStoragePath + "...check itemcount before delete...." + user.getUserName() + "...." + itemCount);
        return itemCount;
    }

    @Override
    public String checkOdbFolders(Cloud cloud, String userName, String odbLoginId, Map<String, Long> foldersMap, StringBuilder response) {
        boolean isODBUserLevelEnabled = this.isODBUserLevelEnabled(cloud.getCloudCustomisableDetails());
        PciAuthorizationTokens pciAuthorizationTokens = isODBUserLevelEnabled ? this.utilDao.getPciAuthorizationTokensForUserName(cloud.getCloudId(), userName) : this.utilDao.getPciAuthorizationTokens(cloud.getCloudId());
        if (pciAuthorizationTokens != null) {
            PciAuthorizationTokenElement pciTokenElement = this.getTokenElement(pciAuthorizationTokens);
            pciTokenElement.setUserName(userName);
            pciTokenElement.setAccountId(odbLoginId);
            if (!isODBUserLevelEnabled) {
                pciTokenElement.setServiceAcct(true);
            }
            String folderUrl = PCHelperConstant.getParabluLibrarySizeUrl((String)pciTokenElement.getSharePointUrl(), (String)pciTokenElement.getAccountId(), (String)"PB");
            return this.office365UploadService.checkOdbFolders(pciTokenElement, folderUrl, foldersMap, response);
        }
        this.logger.debug("token is empty.....");
        return "";
    }

    @Override
    public void uploadToOneDrive(int cloudId, String userName, File decryptedFile, com.pg.domain.BackupFile backupFile, String customPath, boolean inplaceRestore, String driveId, boolean c2cRestore) {
        this.logger.debug("...custompath...." + customPath);
        String userNameTemp = userName;
        com.parablu.pcbd.domain.User userByName = this.utilDao.getUserForName(1, userNameTemp);
        PciAuthorizationTokenElement pciTokenElement = new PciAuthorizationTokenElement();
        pciTokenElement.setUserName(userNameTemp);
        OneDriveUtil odbUtil = OneDriveUtil.getInstance();
        String path = backupFile.getFilePath();
        if (!org.springframework.util.StringUtils.isEmpty((Object)path)) {
            if ((path = path.replaceAll("Files/", "")).equalsIgnoreCase("Files")) {
                path = "";
            }
            path = path.replaceAll(":", "_Drive");
            path = path.replaceAll("#", "_HASH");
            path = path.replaceAll("%", "_PERCENTAGE");
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)customPath)) {
            customPath = FilenameUtils.separatorsToUnix((String)customPath);
            customPath = customPath.replaceAll("//", "/");
            path = !inplaceRestore ? customPath + "/" + path : customPath;
            path = path.replaceAll(":", "_Drive");
            path = path.replaceAll("#", "_HASH");
            path = path.replaceAll("%", "_PERCENTAGE");
        }
        FileStatusElement fileStatusElement = odbUtil.uploadToOneDriveUsingGraph(pciTokenElement, decryptedFile, backupFile.getFileName(), driveId, path, userByName, c2cRestore);
    }

    @Override
    public void uploadToSP(int cloudId, String userName, File decryptedFile, com.pg.domain.BackupFile backupFile, String customPath, boolean inplaceRestore, String driveId) {
        this.logger.debug("...custompath...." + customPath);
        String userNameTemp = userName;
        com.parablu.pcbd.domain.User userByName = this.utilDao.getUserForName(1, userNameTemp);
        PciAuthorizationTokenElement pciTokenElement = new PciAuthorizationTokenElement();
        pciTokenElement.setUserName(userNameTemp);
        OneDriveUtil odbUtil = OneDriveUtil.getInstance();
        String path = backupFile.getFilePath();
        if (!org.springframework.util.StringUtils.isEmpty((Object)path)) {
            if ((path = path.replaceAll("Files/", "")).equalsIgnoreCase("Files")) {
                path = "";
            }
            path = path.replaceAll(":", "_Drive");
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)customPath)) {
            customPath = FilenameUtils.separatorsToUnix((String)customPath);
            customPath = customPath.replaceAll("//", "/");
            path = !inplaceRestore ? customPath + "/" + path : customPath;
        }
        this.logger.debug("...custompath before...." + path);
        if (inplaceRestore) {
            path = path.replaceFirst("Files", "");
            path = path.replaceFirst(userByName.getUserName() + "/Documents", "");
        }
        this.logger.debug("...custompath after...." + path);
        FileStatusElement fileStatusElement = odbUtil.uploadToSPUsingGraph(pciTokenElement, decryptedFile, backupFile.getFileName(), driveId, path, userByName);
    }

    private FileStatusElement handle404And403Cases(String userName, FileStatusElement fileStatusElement, com.parablu.pcbd.domain.User userByName, PciAuthorizationTokenElement pciTokenElement) {
        String errorDriveId = OneDriveUtil.getPBFolderItemIdWithErrorCode(pciTokenElement.getAccountId());
        this.logger.debug("......error code from getPBFolderItemIdWithErrorCode " + errorDriveId);
        if (!org.springframework.util.StringUtils.isEmpty((Object)errorDriveId)) {
            BlackListUser blackListUserObj = this.blackListUserDao.getBlackListUserbyName(1, userName, PCHelperConstant.getComponentName());
            if ("404".equals(errorDriveId)) {
                fileStatusElement.setUploadStatus(false);
                userByName.setBackupTargetAssigned(false);
                userByName.setBackupTargetErrorCode(404);
                this.utilDao.saveUser(1, userByName);
                if (blackListUserObj == null) {
                    BlackListUser blackListUser = new BlackListUser();
                    blackListUser.setResponseCode("404");
                    blackListUser.setUserName(userName);
                    blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                    this.blackListUserDao.saveBlackListUser(1, blackListUser);
                } else if (!blackListUserObj.getResponseCode().equalsIgnoreCase("404")) {
                    this.blackListUserDao.updateBlackListUserWithCode(1, userName, PCHelperConstant.getComponentName(), "404");
                }
            }
            if ("403".equals(errorDriveId)) {
                userByName.setBackupTargetAssigned(false);
                userByName.setBackupTargetErrorCode(403);
                this.utilDao.saveUser(1, userByName);
                String userBlockedForWrite = "403_" + userName;
                Object obj = MemoryStore.get((String)"BlackListUsers");
                obj = MemoryStore.get((String)userBlockedForWrite);
                if (obj == null) {
                    MemoryStore.add((String)userBlockedForWrite, (Object)userName, (long)1800000L);
                    if (blackListUserObj == null) {
                        BlackListUser blackListUser = new BlackListUser();
                        blackListUser.setResponseCode("403");
                        blackListUser.setUserName(userName);
                        blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                        this.blackListUserDao.saveBlackListUser(1, blackListUser);
                    }
                }
            }
        }
        return fileStatusElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkAzureBlobConnection(Cloud cloud) {
        try (BlobStoreContext context = null;){
            List cloudCredentialsList = cloud.getCloudCredentials();
            CloudCredentials cc = null;
            if (!CollectionUtils.isEmpty((Collection)cloudCredentialsList)) {
                cc = (CloudCredentials)cloudCredentialsList.get(0);
            }
            if (cc != null && "azureblob".equalsIgnoreCase(cc.getProvider())) {
                context = this.getBlobStoreContext(cc.getProvider(), cc.getIdentity(), cc.getCredential(), cc.getEndPointUrl(), NUM_1048576, 2, cc.getBlobTagName());
                String containerNameTemp = "PB";
                BlobStore blobStore = context.getBlobStore();
                Location location = null;
                boolean blobExists = this.createContainerIfNotExists(containerNameTemp = this.checkPreConditionForCreateContainer(containerNameTemp, cloud), blobStore, location);
                if (!blobExists) {
                    this.logger.error("...unable to create blob....");
                    return;
                }
                String fileName = "checkConnectivitiy.txt";
                AzureBlobClient api = (AzureBlobClient)context.unwrapApi(AzureBlobClient.class);
                AzureBlob result = api.getBlob(containerNameTemp, fileName, new GetOptions[]{new GetOptions()});
                if (result == null) {
                    this.logger.debug("Blob doesnt exist in the azure....");
                    Blob blob = blobStore.blobBuilder(fileName).payload("Test azure connectivity".getBytes()).contentLength((long)"Test azure connectivity".length()).build();
                    blobStore.putBlob(containerNameTemp, blob);
                    this.logger.debug("upload @@SUCCESSFUL...." + fileName);
                }
                Thread.sleep(5000L);
                Payload payload = result.getPayload();
                this.logger.debug("...file downloaded...");
                Thread.sleep(5000L);
                blobStore.removeBlob(containerNameTemp, fileName);
                this.logger.debug("....file deleted....");
            }
        }
    }

    @Override
    public boolean deleteUserFolderInsidePB(ChunkDetail chunkDetail) {
        return OneDriveUtil.getInstance().deleteUserFolderInsidePBData(chunkDetail);
    }
}

