/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.ActivityHistoryImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.support.SupportHelper;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.adapter.pcb.CloudAdapter;
import com.parablu.epa.core.adapter.pcb.UpdateAdapter;
import com.parablu.epa.core.adapter.tcp.ListnerAdapter;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.helper.UpdateHelper;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.helper.utils.PBCountDownTimer;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.alarm.ManualSyncHelper;
import com.parablu.epa.service.backup.WindowsCheckSyncPolicy;
import com.parablu.epa.service.notifications.DirectoryRefreshHelper;
import com.parablu.epa.service.notifications.UIHelper;
import com.parablu.epa.service.notifications.WindowsEventsManagement;
import com.parablu.epa.service.settings.VersionHelper;
import com.parablu.epa.service.settings.WindowsSettingsHelper;
import com.parablu.epa.view.BluSyncLauncher;
import com.parablu.epa.view.ConsolidatedView;
import com.parablu.epa.view.ProxySettingsView;
import com.parablu.epa.view.RestoreBackup;
import com.parablu.epa.view.RestoreManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTrayUI
extends BaseView {
    private static Logger logger = LoggerFactory.getLogger(SystemTrayUI.class);
    private Shell systrayShell;
    private TrayItem systrayItem;
    private static File uiFile;
    private static FileLock uiFileLock;
    private static FileChannel uiFileChannel;
    private static RandomAccessFile randomAccessFile;
    private ConsolidatedView instance = null;
    private boolean forcestop = true;
    private ImageData systrayImageData = null;
    private Image systrayImage = null;
    private Tray tray = null;
    private Display display = null;
    private Menu menu = null;
    private MenuItem systemStartCrawlMenuItem = null;
    private MenuItem searchMenuItem = null;
    private Timer systrayTimer = null;
    private static CloudAdapter cloudAdapter;
    public static final String RESOURCE = "resource";
    private static final String IMG = "img";
    public static final String FILE_SEPARATOR;
    public static final String PARABLU_LICENSE_EXPIRED_IMAGE;
    private static String userName;
    private static String iP;
    private static String port;
    private static String token;
    private static String cloudName;
    private MenuItem systemStartBackupMenuItem = null;
    private RestoreBackup restoreInstance = null;
    private MenuItem systemPolicyRefreshMenuItem = null;
    private int uiVersion = -1;
    private Menu subMenuForSync = null;
    private Menu subMenuForBackup = null;
    private Menu subMenuForSupport = null;
    private MenuItem restoreMenuItem = null;
    private MenuItem pauseBackup = null;
    private MenuItem stopBackup = null;
    private static final String EXCEPTION = "Exception :";
    private static final String HTTPS_PROTOCOL = "https://";
    private static final String PORTAL_URL_CLOUD_NAME = "/portal/auth?c=";
    private static final String PORTAL_URL_PARAM = "&param=";
    private static final String PORTAL_URL = "&url=";
    private static final String FILE = "files\n";
    private static final String ENCODE_UTF_8 = "UTF-8";
    private MenuItem systemSyncPolicyRefreshMenuItem = null;
    private WindowsEventsManagement windowsEventsManagement;
    private static boolean isStopBackupPressed;
    private static boolean isPauseBackupPressed;
    private MenuItem updateAgent = null;
    private boolean isUpdateAgent = false;
    private String backupTooltip = "";
    private String syncTooltip = "";
    private static SystemTrayUI systemTrayUI;
    private ProxySettingsView ProxySettinginstance = null;
    String password;
    boolean result = false;

    private SystemTrayUI() {
    }

    public static SystemTrayUI getSystemtrayInstance() {
        if (systemTrayUI == null) {
            systemTrayUI = new SystemTrayUI();
        }
        return systemTrayUI;
    }

    public void relaunchSystemTray() {
        try {
            SystemTrayUI.unlockFileUI();
            if (this.restoreInstance != null) {
                this.restoreInstance.cancelRestoreDisplayTimer();
            }
            if (this.systrayItem != null) {
                logger.debug("systrayItem is not null....");
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        logger.debug("systrayItem is enabled  null......");
                        SystemTrayUI.this.loadSystemTray(false);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("error..", (Object)e.getMessage());
        }
    }

    public void loadSystemTray(boolean showtoolTip) {
        this.windowsEventsManagement = new WindowsEventsManagement();
        if (SettingHelper.isLicenseActive()) {
            if (this.systrayTimer != null) {
                this.systrayTimer.cancel();
            }
            this.systrayTimer = new Timer();
            this.systrayTimer.schedule((TimerTask)new SystrayNotificationTask(), 500L, 2000L);
        }
        if (Display.getCurrent() != null && !Display.getCurrent().isDisposed()) {
            try {
                Display.getCurrent().dispose();
            }
            catch (Exception e) {
                logger.error("Exception", (Throwable)e);
            }
        }
        if (this.display != null) {
            logger.debug(Thread.currentThread().getName() + " display closed22222.....");
            this.display = null;
        }
        if (this.display == null) {
            this.display = new Display();
            logger.debug(Thread.currentThread().getName() + " display is there2222222.....");
        }
        this.tray = this.display.getSystemTray();
        if (this.tray == null) {
            return;
        }
        logger.debug("Loading systray");
        if (SettingHelper.getUiVersion() != 0) {
            this.uiVersion = SettingHelper.getUiVersion();
            logger.debug("UI version in systray" + this.uiVersion);
        }
        this.systrayImageData = new ImageData(SyncConstants.SYNCING_IMAGE);
        ImageData systrayLicenseExpiredImageData = new ImageData(PARABLU_LICENSE_EXPIRED_IMAGE);
        this.systrayShell = new Shell(this.display);
        ToolTip toolTip = new ToolTip(this.systrayShell, 4098);
        boolean disabled = true;
        if (disabled) {
            Listener listener2;
            Listener listener;
            Listener listener3;
            if (SettingHelper.isLicenseActive()) {
                this.systrayImage = new Image((Device)this.display, this.systrayImageData.scaledTo(24, 24));
                toolTip.setText(PropertyHelper.SYSTRAY_BALLOONTIP_LABEL);
                toolTip.setMessage(PropertyHelper.SYSTRAY_BALLOONTIP_BELOW_LABEL);
            } else {
                this.systrayImage = new Image((Device)this.display, systrayLicenseExpiredImageData.scaledTo(24, 24));
                toolTip.setText("Server License Expired");
                toolTip.setMessage("Server License Expired");
            }
            logger.debug("Before loading systray icon>>>>>");
            this.systrayItem = new TrayItem(this.tray, 0);
            this.systrayItem.setToolTipText(PropertyHelper.SYSTRAY_TOOLTIP_LABEL);
            this.systrayItem.setImage(this.systrayImage);
            logger.debug("After loading systray icon>>>>>");
            if (SettingHelper.getSyncLicenced().equals("true")) {
                listener3 = event -> {
                    Runnable runnable = () -> {
                        if (!NotificationHelper.isUpdateDialogueOpened) {
                            logger.debug("Parablu folder clicked is selected.");
                            Program.launch((String)(SettingHelper.getParabluSyncFolder() + StringLiterals.FILE_SEPARATOR + "ParaBlu"));
                        }
                    };
                    new Thread(runnable).start();
                };
                this.systrayItem.addListener(14, listener3);
            }
            if (!this.isCommonFeatureEnabled(SettingHelper.isBackuptoolTipNotificationBlocked(), SettingHelper.isSynctoolTipNotificationBlocked())) {
                this.systrayItem.setToolTip(toolTip);
                toolTip.setAutoHide(true);
                this.setTooltip(toolTip, showtoolTip);
            }
            this.menu = new Menu((Decorations)this.systrayShell, 8);
            if (SettingHelper.getSyncLicenced().equalsIgnoreCase("true") && SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
                MenuItem syncMenuItem = new MenuItem(this.menu, 64);
                syncMenuItem.setText("&Sync and Share");
                this.subMenuForSync = new Menu(this.menu);
                syncMenuItem.setMenu(this.subMenuForSync);
                MenuItem backupMenuItem = new MenuItem(this.menu, 64);
                backupMenuItem.setText("&Backup");
                this.subMenuForBackup = new Menu(this.menu);
                backupMenuItem.setMenu(this.subMenuForBackup);
                if (this.isCommonFeatureEnabled(SettingHelper.isSupportBackupInterfaceEnabled(), SettingHelper.isSupportSyncInterfaceEnabled())) {
                    MenuItem supportMenuItem = new MenuItem(this.menu, 64);
                    supportMenuItem.setText("&Support");
                    this.subMenuForSupport = new Menu(this.menu);
                    supportMenuItem.setMenu(this.subMenuForSupport);
                }
            } else {
                this.subMenuForSupport = this.menu;
                if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
                    this.subMenuForBackup = this.menu;
                } else if (SettingHelper.getSyncLicenced().equalsIgnoreCase("true")) {
                    this.subMenuForSync = this.menu;
                }
            }
            if (SettingHelper.getSyncLicenced().equals("true")) {
                if (SettingHelper.isOpenSyncFolderInterfaceEnabled()) {
                    MenuItem parabluMenuItem = new MenuItem(this.subMenuForSync, 8);
                    parabluMenuItem.setText(PropertyHelper.SYSTRAY_OPEN_SHORTCUT_FOLDER_LABEL);
                    listener = event -> {
                        Runnable runnable = () -> {
                            logger.debug("Clicked to open Parablu folder.");
                            Program.launch((String)(SettingHelper.getParabluSyncFolder() + StringLiterals.FILE_SEPARATOR + "ParaBlu"));
                        };
                        new Thread(runnable).start();
                    };
                    parabluMenuItem.addListener(13, listener);
                }
                if (SettingHelper.isSyncNowInterfaceEnabled()) {
                    this.systemStartCrawlMenuItem = new MenuItem(this.subMenuForSync, 8);
                    if (SettingHelper.isLicenseActive()) {
                        this.systemStartCrawlMenuItem.setText("Sync Now");
                    } else {
                        this.systemStartCrawlMenuItem.setText("License Expired");
                        this.systemStartCrawlMenuItem.setEnabled(false);
                    }
                    listener2 = event -> {
                        ManualSyncHelper.startManualSync();
                        this.systemStartCrawlMenuItem.setEnabled(false);
                        this.systemStartCrawlMenuItem.setText("");
                        this.systemStartCrawlMenuItem.setText("Currently Syncing...");
                        UIHelper.displaySyncingGif();
                    };
                    this.systemStartCrawlMenuItem.addListener(13, listener2);
                }
            }
            if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true") && SettingHelper.isBackupFilesInterfaceEnabled()) {
                MenuItem portalMenuItem = new MenuItem(this.subMenuForBackup, 8);
                portalMenuItem.setText("My Backup Files");
                listener = event -> new Thread(new Runnable(){

                    @Override
                    public void run() {
                        logger.debug("Launch Portal Now");
                        try {
                            String authToken = SystemTrayUI.getUserAuthenticationToken();
                            this.launchPortal(authToken);
                        }
                        catch (Exception e) {
                            logger.debug(SystemTrayUI.EXCEPTION, (Throwable)e);
                        }
                    }

                    private void launchPortal(String proxyToken) {
                        cloudName = SettingHelper.getCloudName();
                        String EncodeuserName = null;
                        try {
                            EncodeuserName = URLEncoder.encode(userName, SystemTrayUI.ENCODE_UTF_8);
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.error("error in url encoding...");
                        }
                        String url = port != null ? SystemTrayUI.HTTPS_PROTOCOL + iP + ":" + port + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + EncodeuserName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + "mydevices" + SystemTrayUI.PORTAL_URL_PARAM : SystemTrayUI.HTTPS_PROTOCOL + iP + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + EncodeuserName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + "mydevices" + SystemTrayUI.PORTAL_URL_PARAM;
                        Program.launch((String)url);
                    }
                }).start();
                portalMenuItem.addListener(13, listener);
            }
            if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true") && SettingHelper.isRestoreInterfaceEnabled()) {
                this.restoreMenuItem = new MenuItem(this.subMenuForBackup, 8);
                this.restoreMenuItem.setText("Restore");
                listener3 = event -> {
                    logger.debug("Launch Restore window now.....");
                    this.loadRestoreUI();
                };
                this.restoreMenuItem.addListener(13, listener3);
            }
            if (SettingHelper.getSyncLicenced().equalsIgnoreCase("true") && SettingHelper.isSyncFilesInterfaceEnabled()) {
                MenuItem syncFilesMenuItem = new MenuItem(this.subMenuForSync, 8);
                syncFilesMenuItem.setText("My Files");
                listener = event -> new Thread(new Runnable(){

                    @Override
                    public void run() {
                        logger.debug("Launch My files Now");
                        try {
                            String authToken = SystemTrayUI.getUserAuthenticationToken();
                            this.launchPortal(authToken);
                        }
                        catch (Exception e) {
                            logger.debug(SystemTrayUI.EXCEPTION, (Throwable)e);
                        }
                    }

                    private void launchPortal(String proxyToken) {
                        cloudName = SettingHelper.getCloudName();
                        String EncodeuserName = null;
                        try {
                            EncodeuserName = URLEncoder.encode(userName, SystemTrayUI.ENCODE_UTF_8);
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.error("error in url encoding...");
                        }
                        String url = port != null ? SystemTrayUI.HTTPS_PROTOCOL + iP + ":" + port + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + EncodeuserName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + SystemTrayUI.FILE + SystemTrayUI.PORTAL_URL_PARAM : SystemTrayUI.HTTPS_PROTOCOL + iP + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + EncodeuserName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + SystemTrayUI.FILE + SystemTrayUI.PORTAL_URL_PARAM;
                        Program.launch((String)url);
                    }
                }).start();
                syncFilesMenuItem.addListener(13, listener);
            }
            if (SettingHelper.getBackupLicenced().contentEquals("true") && (SettingHelper.isBackupSettingsInterfaceEnabled() || SettingHelper.isRefreshBackupPolicyInterfaceEnabled())) {
                new MenuItem(this.subMenuForBackup, 2);
            }
            if (SettingHelper.getBackupLicenced().contentEquals("true") && SettingHelper.isBackupSettingsInterfaceEnabled()) {
                MenuItem newSettingsMenuItem = new MenuItem(this.subMenuForBackup, 8);
                newSettingsMenuItem.setText("Backup Settings");
                listener = event -> new Thread(new Runnable(){

                    @Override
                    public void run() {
                        logger.debug("Launch new settings UI Now");
                        try {
                            String authToken = SystemTrayUI.getUserAuthenticationToken();
                            this.launchnewSettings(authToken);
                        }
                        catch (Exception e) {
                            logger.debug(SystemTrayUI.EXCEPTION, (Throwable)e);
                        }
                    }

                    private void launchnewSettings(String proxyToken) {
                        String deviceName = null;
                        cloudName = SettingHelper.getCloudName();
                        String EncodeuserName = null;
                        try {
                            EncodeuserName = URLEncoder.encode(userName, SystemTrayUI.ENCODE_UTF_8);
                        }
                        catch (UnsupportedEncodingException e1) {
                            logger.error("error in url encoding...");
                        }
                        try {
                            deviceName = URLEncoder.encode(SettingHelper.getDeviceName(), SystemTrayUI.ENCODE_UTF_8);
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.error(SystemTrayUI.EXCEPTION, (Object)e.getMessage());
                        }
                        String url = port != null ? SystemTrayUI.HTTPS_PROTOCOL + iP + ":" + port + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + EncodeuserName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + "mybackup" + SystemTrayUI.PORTAL_URL_PARAM + "&v=" + VersionHelper.getProductVersion() + "&action=" + deviceName : SystemTrayUI.HTTPS_PROTOCOL + iP + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + EncodeuserName + "&t=" + proxyToken + SystemTrayUI.PORTAL_URL + "mybackup" + SystemTrayUI.PORTAL_URL_PARAM + "&v=" + VersionHelper.getProductVersion() + "&id=" + SettingHelper.getDeviceUUId() + "&action=" + SettingHelper.getDeviceName();
                        Program.launch((String)url);
                    }
                }).start();
                newSettingsMenuItem.addListener(13, listener);
            }
            if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true") && SettingHelper.isRefreshBackupPolicyInterfaceEnabled()) {
                this.systemPolicyRefreshMenuItem = new MenuItem(this.subMenuForBackup, 8);
                this.systemPolicyRefreshMenuItem.setText("Refresh Policy");
                listener3 = event -> {
                    Runnable runnable = () -> {
                        this.windowsEventsManagement.refreshPolicyTask();
                        String toolTipMessage = "Policy Refresh";
                        String toolTipmessage1 = "Policy update finished";
                        UIHelper.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
                    };
                    new Thread(runnable).start();
                };
                this.systemPolicyRefreshMenuItem.addListener(13, listener3);
            }
            if (SettingHelper.getBackupLicenced().contentEquals("true") && (SettingHelper.isInitiateBackupInterfaceEnabled() || SettingHelper.isPauseBackupInterfaceEnabled() || SettingHelper.isStopBackupInterfaceEnabled())) {
                new MenuItem(this.subMenuForBackup, 2);
            }
            if (SettingHelper.getBackupLicenced().contentEquals("true") && SettingHelper.isInitiateBackupInterfaceEnabled()) {
                this.systemStartBackupMenuItem = new MenuItem(this.subMenuForBackup, 8);
                if (SettingHelper.isLicenseActive()) {
                    this.systemStartBackupMenuItem.setText("Initiate Backup");
                } else {
                    this.systemStartBackupMenuItem.setText("License Expired");
                    this.systemStartBackupMenuItem.setEnabled(false);
                }
                listener3 = event -> {
                    ManualSyncHelper.startManualBackup();
                    this.systemStartBackupMenuItem.setEnabled(false);
                    this.systemStartBackupMenuItem.setText("");
                    this.systemStartBackupMenuItem.setText("Backup in progress");
                    UIHelper.displaySyncingGif();
                };
                this.systemStartBackupMenuItem.addListener(13, listener3);
            }
            if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true") && SettingHelper.isPauseBackupInterfaceEnabled()) {
                this.pauseBackup = new MenuItem(this.subMenuForBackup, 8);
                this.pauseBackup.setText("Pause Backup");
                this.pauseBackup.setEnabled(false);
                listener2 = event -> {
                    if (NotificationHelper.isBackUpStarted()) {
                        logger.debug("Calling pause backup.");
                        isPauseBackupPressed = true;
                        if (this.stopBackup != null && !this.stopBackup.isDisposed()) {
                            this.stopBackup.setEnabled(false);
                        }
                        this.pauseBackup.setText("Pausing Backup...");
                        BlusyncThreadHelper.cancelCurrentBackupProcess(true, false, false);
                    }
                };
                this.pauseBackup.addListener(13, listener2);
            }
            if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true") && SettingHelper.isStopBackupInterfaceEnabled()) {
                this.stopBackup = new MenuItem(this.subMenuForBackup, 8);
                this.stopBackup.setText("Stop Backup");
                listener2 = event -> {
                    Shell shell = new Shell(this.display);
                    MessageBox dialog = new MessageBox(shell, 200);
                    dialog.setText("Stop Backup");
                    dialog.setMessage("You have chosen to stop the current backup\nAre you sure?");
                    int result = dialog.open();
                    if (result == 64) {
                        this.stopBackup.setEnabled(false);
                        if (NotificationHelper.isBackUpStarted()) {
                            logger.debug("Calling stop backup.");
                            isStopBackupPressed = true;
                            if (this.pauseBackup != null && !this.pauseBackup.isDisposed()) {
                                this.pauseBackup.setEnabled(false);
                            }
                            this.stopBackup.setText("Stopping Backup...");
                            BlusyncThreadHelper.cancelCurrentBackupProcess(true, true, false);
                        }
                    }
                };
                this.stopBackup.addListener(13, listener2);
            }
            if (SettingHelper.getSyncLicenced().contentEquals("true") && SettingHelper.isSyncSettingsInterfaceEnabled()) {
                MenuItem syncSettingsMenuItem = new MenuItem(this.subMenuForSync, 8);
                syncSettingsMenuItem.setText("Sync Settings");
                listener = event -> {
                    logger.debug("Settings or Preferences is selected.");
                    this.loadParaBluClient();
                };
                syncSettingsMenuItem.addListener(13, listener);
            }
            if (SettingHelper.getSyncLicenced().equals("true") && SettingHelper.isSearchInterfaceEnabled()) {
                this.searchMenuItem = new MenuItem(this.subMenuForSync, 8);
                this.searchMenuItem.setText("Search ");
                if (!SettingHelper.isLicenseActive()) {
                    this.searchMenuItem.setEnabled(false);
                }
                listener3 = event -> new Thread(new Runnable(){

                    @Override
                    public void run() {
                        logger.debug("Launch Search");
                        String authToken = null;
                        try {
                            authToken = SystemTrayUI.getUserAuthenticationToken();
                            this.searchFolder(authToken);
                        }
                        catch (Exception e) {
                            logger.debug(SystemTrayUI.EXCEPTION, (Throwable)e);
                        }
                    }

                    private void searchFolder(String authToken) throws UnsupportedEncodingException {
                        cloudName = SettingHelper.getCloudName();
                        String EncodeuserName = URLEncoder.encode(userName, SystemTrayUI.ENCODE_UTF_8);
                        String url = port != null ? SystemTrayUI.HTTPS_PROTOCOL + iP + ":" + Integer.valueOf(port) + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + EncodeuserName + "&t=" + authToken + SystemTrayUI.PORTAL_URL + "search" + SystemTrayUI.PORTAL_URL_PARAM + URLEncoder.encode("ParaBlu", SystemTrayUI.ENCODE_UTF_8) : SystemTrayUI.HTTPS_PROTOCOL + iP + SystemTrayUI.PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + EncodeuserName + "&t=" + authToken + SystemTrayUI.PORTAL_URL + "search" + SystemTrayUI.PORTAL_URL_PARAM + URLEncoder.encode("ParaBlu", SystemTrayUI.ENCODE_UTF_8);
                        Program.launch((String)url);
                    }
                }).start();
                this.searchMenuItem.addListener(13, listener3);
            }
            if (SettingHelper.getSyncLicenced().equals("true") && SettingHelper.isRefreshSyncPolicyInterfaceEnabled()) {
                this.systemSyncPolicyRefreshMenuItem = new MenuItem(this.subMenuForSync, 8);
                this.systemSyncPolicyRefreshMenuItem.setText("Refresh Sync Policy");
                Listener lstner = event -> {
                    Runnable runnable = () -> {
                        WindowsCheckSyncPolicy.pullSyncPolicy();
                        BlusyncThreadHelper.resetSyncTimer();
                        this.windowsEventsManagement.refreshPolicyTask();
                        String toolTipMessage = "Policy Refresh";
                        String toolTipmessage1 = "Policy update finished";
                        UIHelper.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
                    };
                    new Thread(runnable).start();
                };
                this.systemSyncPolicyRefreshMenuItem.addListener(13, lstner);
            }
            if (SettingHelper.getBackupLicenced().contentEquals("true") && SettingHelper.getSyncLicenced().contentEquals("false") && (this.isCommonFeatureEnabled(SettingHelper.isSupportBackupInterfaceEnabled(), SettingHelper.isSupportSyncInterfaceEnabled()) || this.isCommonFeatureEnabled(SettingHelper.isDecoupleBackupInterfaceEnabled(), SettingHelper.isDecoupleSyncInterfaceEnabled()) || this.isCommonFeatureEnabled(SettingHelper.isUpdateAgentBackupInterfaceEnabled(), SettingHelper.isUpdateAgentSyncInterfaceEnabled()))) {
                new MenuItem(this.subMenuForBackup, 2);
            }
            if (this.isCommonFeatureEnabled(SettingHelper.isUpdateAgentBackupInterfaceEnabled(), SettingHelper.isUpdateAgentSyncInterfaceEnabled())) {
                this.updateAgent = new MenuItem(this.menu, 8);
                this.updateAgent.setText("Check for Update");
                listener3 = event -> {
                    this.isUpdateAgent = false;
                    Runnable runnable = () -> {
                        NotificationHelper.setUpdateagentstarted((boolean)true);
                        String cloudVersion = this.getCloudVersion();
                        logger.debug("version from server " + cloudVersion);
                        boolean isInstalledversionLatest = false;
                        if (StringUtils.isNotEmpty((String)cloudVersion) && !cloudVersion.equals("UpdateDisabled")) {
                            isInstalledversionLatest = UpdateHelper.isInstalledversionLatest((String)cloudVersion, (String)VersionHelper.getProductVersion());
                        }
                        if (StringUtils.isEmpty((String)cloudVersion)) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Shell shell = new Shell(SystemTrayUI.this.display);
                                    MessageBox messageBox = new MessageBox(shell, 34);
                                    messageBox.setText("Check for Update");
                                    messageBox.setMessage("No updates found!");
                                    messageBox.open();
                                }
                            });
                        } else if (StringUtils.isNotEmpty((String)cloudVersion) && cloudVersion.equals(VersionHelper.getProductVersion())) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Shell shell = new Shell(SystemTrayUI.this.display);
                                    MessageBox messageBox = new MessageBox(shell, 34);
                                    messageBox.setText("Check for Update");
                                    messageBox.setMessage("Agent is up to date");
                                    messageBox.open();
                                }
                            });
                        } else if (StringUtils.isNotEmpty((String)cloudVersion) && cloudVersion.equals("UpdateDisabled")) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Shell shell = new Shell(SystemTrayUI.this.display);
                                    MessageBox messageBox = new MessageBox(shell, 34);
                                    messageBox.setText("Check for Update");
                                    messageBox.setMessage("Please contact your administrator!");
                                    messageBox.open();
                                }
                            });
                        } else if (StringUtils.isNotEmpty((String)cloudVersion) && !cloudVersion.equals("UpdateDisabled") && !cloudVersion.equals(VersionHelper.getProductVersion())) {
                            ListnerAdapter listnerAdapter = new ListnerAdapter();
                            if (isInstalledversionLatest && !UpdateHelper.isRollbackEnabled()) {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        Shell shell = new Shell(SystemTrayUI.this.display);
                                        MessageBox messageBox = new MessageBox(shell, 40);
                                        messageBox.setText("Check for Update");
                                        messageBox.setMessage("Already installed latest version");
                                        messageBox.open();
                                    }
                                });
                            } else if (listnerAdapter.checkForService()) {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        Shell shell = new Shell(SystemTrayUI.this.display);
                                        MessageBox messageBox = new MessageBox(shell, 196);
                                        messageBox.setText("Check for Update");
                                        messageBox.setMessage("New update found.Do you want to continue?");
                                        int result = messageBox.open();
                                        if (result == 64) {
                                            SystemTrayUI.this.isUpdateAgent = true;
                                        }
                                    }
                                });
                                if (this.isUpdateAgent) {
                                    BluSyncLauncher.UpdateTask.downloadAndExecuteUpdate(listnerAdapter, true);
                                }
                            } else {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        Shell shell = new Shell(SystemTrayUI.this.display);
                                        MessageBox messageBox = new MessageBox(shell, 40);
                                        messageBox.setText("Check for Update");
                                        messageBox.setMessage("Unable to update the agent.\nPlease check the parablu service is running?");
                                        messageBox.open();
                                    }
                                });
                            }
                        }
                        NotificationHelper.setUpdateagentstarted((boolean)false);
                    };
                    new Thread(runnable).start();
                };
                this.updateAgent.addListener(13, listener3);
            }
            if (this.isCommonFeatureEnabled(SettingHelper.isSupportBackupInterfaceEnabled(), SettingHelper.isSupportSyncInterfaceEnabled())) {
                MenuItem supportLogMenuItem = new MenuItem(this.subMenuForSupport, 8);
                supportLogMenuItem.setText("Support Request");
                listener = event -> {
                    Shell shell = new Shell(this.display);
                    MessageBox supportLogAttachMsgBox = new MessageBox(shell, 196);
                    supportLogAttachMsgBox.setMessage("Do you want to add end point logs with request?");
                    supportLogAttachMsgBox.setText("Support request");
                    int response = supportLogAttachMsgBox.open();
                    if (response == 64) {
                        if (SupportHelper.isSupportRequestInitiated()) {
                            logger.debug("Support Request is Initiated: " + SupportHelper.isSupportRequestInitiated());
                            return;
                        }
                        int logsSent = SupportHelper.sendNewSupportLogs((String)SettingHelper.getCloudName(), (String)SettingHelper.getUserName(), (String)SettingHelper.getDeviceName(), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (String)"PULL_AGENTLOGS");
                        if (logsSent == 2) {
                            Clipboard clipboard = new Clipboard(Display.getCurrent());
                            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
                            clipboard.setContents(new Object[]{SupportHelper.getSupportRequestId()}, transfers);
                            clipboard.dispose();
                            MessageBox messageBox = new MessageBox(shell, 34);
                            messageBox.setText("Logs have been sent Successfully");
                            messageBox.setMessage("Logs have been sent Successfully to our server.\nLog id will be attached in your request mail.");
                            messageBox.open();
                        } else if (logsSent == 1) {
                            MessageBox messageBox = new MessageBox(shell, 40);
                            messageBox.setMessage("Failed to send logs.\nYou can still write to us.");
                            messageBox.setText("Request Failed");
                            messageBox.open();
                        }
                    }
                    logger.debug("Clicked on Help Hyperlink");
                    String mailto = PropertyHelper.HELP_LINK_SEND_MAIL + "?subject=" + SystemTrayUI.encode(SupportHelper.getSupportRequestId());
                    Program.launch((String)mailto);
                    SupportHelper.setSupportRequestId(null);
                };
                supportLogMenuItem.addListener(13, listener);
            }
            if (this.isCommonFeatureEnabled(SettingHelper.isDecoupleBackupInterfaceEnabled(), SettingHelper.isDecoupleSyncInterfaceEnabled())) {
                MenuItem decoupleMenuItem = new MenuItem(this.menu, 8);
                decoupleMenuItem.setText("Decouple Device");
                decoupleMenuItem.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        boolean decoupleAgent;
                        logger.debug("Settings decouple is selected.");
                        Shell shell = new Shell(SystemTrayUI.this.display);
                        MessageBox dialog = new MessageBox(shell, 200);
                        dialog.setText("Decouple Device");
                        dialog.setMessage("This action will de-couple the device from Parablu server and will trigger a full backup if you choose to re-couple it again later.\nAre you sure you want to proceed?");
                        int result = dialog.open();
                        if (result == 64 && (decoupleAgent = SystemTrayUI.this.validateWithPassword())) {
                            logger.debug("Clicked on Decouple button");
                            int response = this.sendDecoupleRequest();
                            if (response == 200) {
                                if (NotificationHelper.isBackUpStarted()) {
                                    PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)913);
                                    PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit((String)"STOPPED", (boolean)false);
                                }
                                WindowsSettingsHelper.dsconnectWebDAVasNetworkDrive();
                                DirectoryRefreshHelper directoryRefreshHelper = new DirectoryRefreshHelper();
                                directoryRefreshHelper.refreshDirectory();
                                BluSyncLauncher.changeAccount();
                            } else {
                                MessageBox msg = new MessageBox(shell, 34);
                                msg.setText("Cannot Decouple");
                                msg.setMessage("Could not connect to server. User will not be decoupled from the device.");
                                msg.open();
                            }
                        }
                    }

                    private int sendDecoupleRequest() {
                        BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                        int response = 0;
                        try {
                            response = backupAdapter.getDecoupleResponse(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), SettingHelper.readTokenFromFile());
                        }
                        catch (Exception e) {
                            logger.trace("" + e);
                            logger.error(SystemTrayUI.EXCEPTION + e.getMessage());
                        }
                        return response;
                    }
                });
            }
            if (SettingHelper.getBackupLicenced().contentEquals("true") && this.isCommonFeatureEnabled(SettingHelper.isAboutBackupInterfaceEnabled(), SettingHelper.isAboutSyncInterfaceEnabled())) {
                new MenuItem(this.subMenuForBackup, 2);
            }
            if (this.isCommonFeatureEnabled(SettingHelper.isAboutBackupInterfaceEnabled(), SettingHelper.isAboutSyncInterfaceEnabled())) {
                MenuItem SettingsMenuItem = new MenuItem(this.menu, 8);
                SettingsMenuItem.setText("About");
                listener = event -> {
                    logger.debug("about page  is selected.");
                    this.loadParaBluAbout();
                };
                SettingsMenuItem.addListener(13, listener);
            }
            if (SettingHelper.getBackupLicenced().contentEquals("true") && SettingHelper.getSyncLicenced().contentEquals("false") && this.isCommonFeatureEnabled(SettingHelper.isExitBackupInterfaceEnabled(), SettingHelper.isExitSyncInterfaceEnabled())) {
                new MenuItem(this.subMenuForBackup, 2);
            }
            if (this.isCommonFeatureEnabled(SettingHelper.isExitBackupInterfaceEnabled(), SettingHelper.isExitSyncInterfaceEnabled())) {
                MenuItem systemTrayExit = new MenuItem(this.menu, 8);
                systemTrayExit.setText("Exit");
                Listener listener22 = event -> {
                    boolean exitAgent = this.validateWithPassword();
                    if (exitAgent) {
                        if (NotificationHelper.isBackUpStarted()) {
                            PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)911);
                            PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit((String)"STOPPED", (boolean)false);
                        }
                        if (this.restoreInstance != null) {
                            if (NotificationHelper.restoreStarted) {
                                this.restoreInstance.restoreBatchUpdateBeforeExit();
                            }
                            this.restoreInstance.cancelRestoreDisplayTimer();
                        } else if (this.restoreInstance == null && NotificationHelper.restoreStarted) {
                            RestoreManager.restoreBatchUpdateBeforeExit();
                        }
                        this.stopTimer();
                        SystemTrayUI.unlockFileUI();
                        if (this.instance != null) {
                            this.instance.close(true);
                            this.instance = null;
                        }
                        this.systrayItem.dispose();
                        this.systrayShell.getDisplay().dispose();
                        this.systrayShell.dispose();
                        this.checkCrawlStatusAndUpdateTable();
                        if (SettingHelper.process != null) {
                            SettingHelper.process.destroy();
                        }
                        SettingHelper.deleteParaBluFolderPathTempFile();
                        SettingHelper.deleteUserValidityFilePath();
                        SettingHelper.deleteNotSyncedFile();
                        DirectoryRefreshHelper directoryRefreshHelper = new DirectoryRefreshHelper();
                        directoryRefreshHelper.refreshDirectory();
                        System.exit(0);
                    }
                };
                systemTrayExit.addListener(13, listener22);
            }
            Listener lstnr = event -> {
                logger.debug("System Tray - Menu Detection Listener");
                this.menu.setVisible(true);
                if (SettingHelper.getUiVersion() != -1) {
                    this.uiVersion = SettingHelper.getUiVersion();
                }
            };
            this.systrayItem.addListener(35, lstnr);
            UIHelper.setSystemTrayUI(this, this.display);
            while (this.systrayShell != null && !this.systrayShell.isDisposed() && this.forcestop) {
                if (this.display.isDisposed() || this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
            this.stopTimer();
            logger.debug("Clean Exit Dispose All Objects");
            if (this.systrayImage != null && !this.systrayImage.isDisposed()) {
                this.systrayImage.dispose();
            }
            if (this.systrayItem != null && !this.systrayItem.isDisposed()) {
                this.systrayItem.dispose();
            }
            if (this.systrayShell != null && !this.systrayShell.isDisposed()) {
                this.systrayShell.dispose();
            }
            if (this.display != null && !this.display.isDisposed()) {
                this.display.dispose();
            }
            this.systrayItem = null;
            this.systrayImage = null;
            this.display = null;
            this.systrayShell = null;
        }
    }

    private boolean validateWithPassword() {
        this.result = false;
        this.password = null;
        logger.debug("Exiting Client Application");
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        BackupPolicyTO currentPolicy = null;
        if (currentDetails != null && (currentPolicy = (BackupPolicyTO)currentDetails.get(0)).getAgentPassword() != null) {
            this.password = currentPolicy.getAgentPassword();
        }
        if (currentPolicy.isSwitchAgentPassword()) {
            if (!StringUtils.isEmpty((String)this.password)) {
                this.password = SystemTrayUI.decodeBase64UTFString(this.password);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        final Shell shell = new Shell(SystemTrayUI.this.display);
                        shell.setLayout((Layout)new GridLayout());
                        shell.setText("Password");
                        shell.setLayoutData((Object)new GridData());
                        SystemTrayUI.this.systrayImage = new Image((Device)SystemTrayUI.this.display, SystemTrayUI.this.systrayImageData.scaledTo(24, 24));
                        shell.setImage(SystemTrayUI.this.systrayImage);
                        Composite shellComposite = new Composite((Composite)shell, 2048);
                        GridLayout shellGroupGridLayout = new GridLayout();
                        shellGroupGridLayout.numColumns = 1;
                        shellGroupGridLayout.makeColumnsEqualWidth = false;
                        shellGroupGridLayout.verticalSpacing = 5;
                        shellComposite.setLayout((Layout)shellGroupGridLayout);
                        shellComposite.setLayoutData((Object)new GridData(768));
                        Composite textComposite = new Composite(shellComposite, 0x1000000);
                        GridLayout textGroupGridLayout = new GridLayout();
                        textGroupGridLayout.numColumns = 1;
                        textGroupGridLayout.makeColumnsEqualWidth = false;
                        textGroupGridLayout.verticalSpacing = 5;
                        textComposite.setLayout((Layout)textGroupGridLayout);
                        textComposite.setLayoutData((Object)new GridData(768));
                        Label lbel = new Label(textComposite, 0);
                        lbel.setText("Enter the password to exit/decouple the agent");
                        lbel.setLayoutData((Object)new GridData(768));
                        final Text pswdtext = new Text(textComposite, 2048);
                        pswdtext.setEchoChar('*');
                        pswdtext.setLayoutData((Object)new GridData(768));
                        Composite buttonComposite = new Composite(shellComposite, 0x1000000);
                        GridLayout groupGridLayout = new GridLayout();
                        groupGridLayout.numColumns = 4;
                        groupGridLayout.makeColumnsEqualWidth = false;
                        groupGridLayout.marginTop = 10;
                        groupGridLayout.verticalSpacing = 5;
                        buttonComposite.setLayout((Layout)groupGridLayout);
                        buttonComposite.setLayoutData((Object)new GridData(768));
                        GridData saveGridData = new GridData();
                        saveGridData.horizontalAlignment = 2;
                        saveGridData.widthHint = 66;
                        Button dummybutton = new Button(buttonComposite, 8);
                        dummybutton.setText("Okkkkkk");
                        dummybutton.setVisible(false);
                        Button buttonForOk = new Button(buttonComposite, 8);
                        buttonForOk.setText("OK");
                        buttonForOk.setLayoutData((Object)saveGridData);
                        buttonForOk.setAlignment(0x1000000);
                        Button dummybutton1 = new Button(buttonComposite, 8);
                        dummybutton1.setText("OK");
                        dummybutton1.setVisible(false);
                        buttonForOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                String pswd = pswdtext.getText().trim();
                                if (pswd.contentEquals(SystemTrayUI.this.password)) {
                                    SystemTrayUI.this.result = true;
                                    shell.close();
                                } else {
                                    MessageBox msg = new MessageBox(shell, 33);
                                    msg.setText("Password");
                                    msg.setMessage(" Incorrect Password    ");
                                    msg.open();
                                    SystemTrayUI.this.result = false;
                                    shell.close();
                                }
                            }
                        });
                        Button buttonForCancel = new Button(buttonComposite, 8);
                        buttonForCancel.setText(" Cancel ");
                        buttonForCancel.setLayoutData((Object)saveGridData);
                        buttonForCancel.setAlignment(0x1000000);
                        buttonForCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                shell.close();
                            }
                        });
                        shell.setSize(350, 160);
                        shell.open();
                        while (!shell.isDisposed()) {
                            if (SystemTrayUI.this.display.readAndDispatch()) continue;
                            SystemTrayUI.this.display.sleep();
                        }
                    }
                });
            } else {
                this.result = true;
            }
        } else {
            this.result = true;
        }
        logger.debug("result...." + this.result);
        return this.result;
    }

    static String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), ENCODE_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UnsupportedEncodingException" + e);
        }
        return decodedString;
    }

    private void setTooltip(ToolTip toolTip, Boolean showtooltip) {
        toolTip.setVisible(showtooltip.booleanValue());
    }

    private String getCloudVersion() {
        String cloudVersion = null;
        try {
            UpdateAdapter adapter = new UpdateAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            cloudVersion = adapter.checkCloudForVersion(SettingHelper.getCurrentCloudIpAddress(), null, VersionHelper.getProductVersion(), "service");
            logger.debug("Version from system  " + VersionHelper.getProductVersion());
            if (cloudVersion == null && SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpsPort() != null) {
                cloudVersion = adapter.checkCloudForVersion(SettingHelper.getCurrentCloudIpAddress(), Integer.valueOf(SettingHelper.getHttpsPort()), VersionHelper.getProductVersion(), "service");
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage() + EXCEPTION);
        }
        return cloudVersion;
    }

    protected void checkCrawlStatusAndUpdateTable() {
        if (NotificationHelper.getMainStatus() != 101 || NotificationHelper.getCurrentActivityState() != 8) {
            return;
        }
        ActivityHistoryImpl activityHistoryHandle = new ActivityHistoryImpl(SettingHelper.getActivityDBUrl());
        ActivityTO activity = new ActivityTO();
        Date crawlDate = new Date(Long.valueOf(NotificationHelper.getCurrentCrawlTimeStamp()));
        activity.setActivityTimeStamp(crawlDate);
        activity.setActivityName(CrawlLifecycle.EXITED.name());
        activity.setUploadCount(NotificationHelper.getUploadCount());
        activity.setDownloadCount(NotificationHelper.getDowloadCount());
        activity.setActivityID(NotificationHelper.getCurrentActivityId());
        activityHistoryHandle.updateEventToActivityHistoryTable(activity);
    }

    public synchronized void stopTimer() {
        if (this.systrayTimer != null) {
            this.systrayTimer.cancel();
            this.systrayTimer = null;
        }
    }

    public void loadParaBluClient() {
        try {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.acquireLockForNewUI();
            this.createConsolidatedViewInstance();
        }
        catch (Exception e) {
            logger.error("Exception while creating BluSync GUI" + e);
        }
    }

    private void createConsolidatedViewInstance() {
        Runnable runnable = () -> {
            try {
                this.instance = null;
                this.instance = new ConsolidatedView(uiFileLock);
                this.instance.openShell();
            }
            catch (Exception e) {
                logger.error("Exception during instantiation of UI" + e);
            }
        };
        this.display.asyncExec(runnable);
    }

    public void loadRestoreUI() {
        try {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.acquireLockForNewUI();
            this.createRestoreBkupInstance();
        }
        catch (Exception e) {
            logger.error("Exception while creating BluSync GUI" + e);
        }
    }

    private void createRestoreBkupInstance() {
        Runnable runnable = () -> {
            try {
                this.restoreInstance = null;
                this.restoreInstance = new RestoreBackup(uiFileLock);
                this.restoreInstance.setText("Restore Backup");
                this.restoreInstance.startRestoreBackup();
                this.restoreInstance.openShell();
            }
            catch (Exception e) {
                logger.error("Exception during instantiation of UI neww" + e);
            }
        };
        this.display.asyncExec(runnable);
    }

    public void acquireLockForNewUI() throws Exception {
        boolean fileLockSuccess = false;
        uiFile = new File(SettingHelper.getUiLockUrl());
        if (uiFile.exists()) {
            logger.debug("Trying to delete uiFile");
            uiFile.delete();
        }
        randomAccessFile = new RandomAccessFile(uiFile, "rw");
        uiFileChannel = randomAccessFile.getChannel();
        try {
            uiFileLock = uiFileChannel.tryLock();
            logger.debug("Trying to acquire uiFileLock");
            fileLockSuccess = true;
        }
        catch (IOException e) {
            logger.error("IOException; UI Already active,cant acquire file Lock." + e);
        }
        catch (OverlappingFileLockException e) {
            logger.error("UI Already active,cant acquire file Lock" + e);
        }
        if (!fileLockSuccess || uiFileLock == null) {
            uiFileChannel.close();
            if (this.instance != null && this.instance.shell != null) {
                logger.debug("Trying to maximise");
                this.instance.shell.open();
            }
            throw new Exception("Instance already running. Unable to acquire lock. Terminate application.");
        }
        ShutdownHookUI shutdownHook = new ShutdownHookUI();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static synchronized void unlockFileUI() {
        try {
            if (uiFileLock != null) {
                uiFileLock.release();
            }
        }
        catch (IOException e) {
            logger.error("IOException in uiFileLock" + e);
        }
        logger.debug("Trying to delete the UI File");
        try {
            if (uiFileChannel != null) {
                uiFileChannel.close();
            }
        }
        catch (IOException e1) {
            logger.error("IOException in uiFileChannel" + e1);
        }
        catch (Exception e1) {
            logger.error(EXCEPTION + e1);
        }
        if (uiFile != null && uiFile.exists()) {
            logger.debug("Deleting UI File");
            uiFile.delete();
        }
        uiFile = null;
        uiFileLock = null;
        uiFileChannel = null;
    }

    public synchronized void disposeSystrayUIShells() {
        this.stopTimer();
        if (this.instance != null) {
            this.instance.close(false);
            SystemTrayUI.unlockFileUI();
        }
        try {
            this.menu.dispose();
            this.systrayImage.dispose();
            this.systrayItem.dispose();
            this.systrayShell.dispose();
            this.tray.dispose();
            this.display.dispose();
        }
        catch (Exception e) {
            logger.error("error in disposing fields.", (Throwable)e);
        }
    }

    private static String encode(String strData) {
        String data = strData;
        if (data == null) {
            data = "";
        }
        try {
            return URLEncoder.encode(data, ENCODE_UTF_8).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.debug("UnsupportedEncodingException:" + e.getMessage());
            return data;
        }
    }

    public static String getUserAuthenticationToken() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        iP = SettingHelper.getCurrentCloudIpAddress();
        port = SettingHelper.getCurrentHttpsPort();
        token = SettingHelper.readTokenFromFile();
        cloudName = SettingHelper.getCloudName();
        userName = SettingHelper.getUserName();
        cloudAdapter = new CloudAdapter(cloudName, SettingHelper.getKeystorePath());
        String proxyToken = null;
        String[] resArray = port == null ? cloudAdapter.getAuthenticationToken(iP, null, token, userName) : cloudAdapter.getAuthenticationToken(iP, Integer.valueOf(port), token, userName);
        if (resArray != null) {
            proxyToken = resArray[0];
            SettingHelper.setCloudName((String)resArray[1]);
            cloudName = SettingHelper.getCloudName();
        }
        return proxyToken;
    }

    public boolean isCommonFeatureEnabled(boolean backupFeatureEnabled, boolean syncFeatureEnabled) {
        boolean interfaceFetureEnabled = false;
        if ("true".equalsIgnoreCase(SettingHelper.getBackupLicenced()) && backupFeatureEnabled && ("true".equalsIgnoreCase(SettingHelper.getSyncLicenced()) && syncFeatureEnabled || !"true".equalsIgnoreCase(SettingHelper.getSyncLicenced())) || this.isSyncCommonFeatureEnabled(syncFeatureEnabled)) {
            interfaceFetureEnabled = true;
        }
        return interfaceFetureEnabled;
    }

    private boolean isSyncCommonFeatureEnabled(boolean syncFeatureEnabled) {
        return !"true".equalsIgnoreCase(SettingHelper.getBackupLicenced()) && "true".equalsIgnoreCase(SettingHelper.getSyncLicenced()) && syncFeatureEnabled;
    }

    public MenuItem getSystemStartCrawl() {
        return this.systemStartCrawlMenuItem;
    }

    public MenuItem getSearchMenuItem() {
        return this.searchMenuItem;
    }

    public Shell getSystrayShell() {
        return this.systrayShell;
    }

    public void setSystrayShell(Shell systrayShell) {
        this.systrayShell = systrayShell;
    }

    public TrayItem getSystrayItem() {
        return this.systrayItem;
    }

    public void setSystrayItem(TrayItem systrayItem) {
        this.systrayItem = systrayItem;
    }

    public ConsolidatedView getInstance() {
        return this.instance;
    }

    public MenuItem systemStartBackupMenuItem() {
        return this.systemStartBackupMenuItem;
    }

    public MenuItem systemPolicyRefreshMenuItem() {
        return this.systemPolicyRefreshMenuItem;
    }

    public MenuItem systemSyncPolicyRefreshMenuItem() {
        return this.systemSyncPolicyRefreshMenuItem;
    }

    public void loadParaBluAbout() {
        try {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.acquireLockForNewUI();
            this.createAboutViewInstance();
        }
        catch (Exception e) {
            logger.error("Exception while creating BluSync GUI" + e);
        }
    }

    static void launchSyncSettings(String proxyToken) {
        String deviceName = null;
        cloudName = SettingHelper.getCloudName();
        String EncodeuserName = null;
        try {
            EncodeuserName = URLEncoder.encode(userName, ENCODE_UTF_8);
            deviceName = URLEncoder.encode(SettingHelper.getDeviceName(), ENCODE_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(EXCEPTION, (Object)e.getMessage());
        }
        String url = port != null ? HTTPS_PROTOCOL + iP + ":" + port + PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + EncodeuserName + "&t=" + proxyToken + PORTAL_URL + "failedFiles" + PORTAL_URL_PARAM + "&v=" + VersionHelper.getProductVersion() + "&action=" + deviceName : HTTPS_PROTOCOL + iP + PORTAL_URL_CLOUD_NAME + cloudName + "&u=" + EncodeuserName + "&t=" + proxyToken + PORTAL_URL + "failedFiles" + PORTAL_URL_PARAM + "&v=" + VersionHelper.getProductVersion() + "&id=" + SettingHelper.getDeviceUUId() + "&action=" + deviceName;
        logger.debug("url;;;;;" + url);
        Program.launch((String)url);
    }

    private void createAboutViewInstance() {
        Runnable runnable = () -> {
            try {
                this.instance = null;
                this.instance = new ConsolidatedView(uiFileLock);
                this.instance.openAboutShell();
            }
            catch (Exception e) {
                logger.error("Exception during instantiation of UI" + e);
            }
        };
        this.display.asyncExec(runnable);
    }

    public void closeRestoreWindow() {
        this.restoreInstance.closeRestoreWindow();
    }

    public void loadProxySettings() {
        try {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.acquireLockForNewUI();
            this.createProxyViewInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createProxyViewInstance() {
        Runnable runnable = () -> {
            try {
                this.ProxySettinginstance = null;
                this.ProxySettinginstance = new ProxySettingsView(uiFileLock);
                this.ProxySettinginstance.openShell();
            }
            catch (Exception e) {
                logger.error("Exception during instantiation of UI" + e);
            }
        };
        this.display.asyncExec(runnable);
    }

    static {
        cloudAdapter = null;
        FILE_SEPARATOR = System.getProperty("file.separator");
        PARABLU_LICENSE_EXPIRED_IMAGE = RESOURCE + FILE_SEPARATOR + IMG + FILE_SEPARATOR + "ParaBlu_2.png";
        userName = null;
        iP = null;
        port = null;
        token = null;
        cloudName = null;
        systemTrayUI = null;
    }

    class SystrayNotificationTask
    extends TimerTask {
        SystrayNotificationTask() {
        }

        @Override
        public void run() {
            if (SystemTrayUI.this.display == null) {
                return;
            }
            Runnable runnable = () -> {
                try {
                    if (NotificationHelper.getMainStatus() == 100 && !NotificationHelper.isBackUpStarted() && SystemTrayUI.this.systrayItem != null && !SystemTrayUI.this.systrayItem.isDisposed()) {
                        SystemTrayUI.this.systrayItem.setToolTipText(PropertyHelper.SYSTRAY_TOOLTIP_LABEL);
                        SystemTrayUI.this.syncTooltip = "";
                        SystemTrayUI.this.backupTooltip = PropertyHelper.SYSTRAY_TOOLTIP_LABEL;
                    }
                    if (SettingHelper.getSyncLicenced().equalsIgnoreCase("true")) {
                        this.handleSyncPolicyRefreshButton();
                    }
                    if (SystemTrayUI.this.isCommonFeatureEnabled(SettingHelper.getBackupLicenced().equalsIgnoreCase("true"), SettingHelper.getSyncLicenced().equalsIgnoreCase("true"))) {
                        this.handleUpdateAgent();
                    }
                    if (SettingHelper.getBackupLicenced().contentEquals("true")) {
                        if (NotificationHelper.restoreStarted) {
                            if (SystemTrayUI.this.restoreMenuItem != null && !SystemTrayUI.this.restoreMenuItem.isDisposed()) {
                                SystemTrayUI.this.restoreMenuItem.setEnabled(false);
                            }
                        } else if (!NotificationHelper.restoreStarted && SystemTrayUI.this.restoreMenuItem != null && !SystemTrayUI.this.restoreMenuItem.isDisposed()) {
                            SystemTrayUI.this.restoreMenuItem.setEnabled(true);
                        }
                    }
                    if (NotificationHelper.getMainStatus() == 100) {
                        if (SystemTrayUI.this.systrayItem != null && !SystemTrayUI.this.systrayItem.isDisposed()) {
                            SystemTrayUI.this.syncTooltip = "";
                        }
                        if (!(SystemTrayUI.this.systemStartCrawlMenuItem == null || SystemTrayUI.this.systemStartCrawlMenuItem.isDisposed() || SystemTrayUI.this.systemStartCrawlMenuItem.getEnabled() || SettingHelper.getSyncLicenced().contentEquals("false"))) {
                            SystemTrayUI.this.systemStartCrawlMenuItem.setEnabled(true);
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("");
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("Sync Now");
                        }
                        return;
                    }
                    if (NotificationHelper.getCurrentActivityState() != 9) {
                        SystemTrayUI.this.syncTooltip = "\nSync Download-" + NotificationHelper.getDowloadCount() + " file(s)\nSync Upload-" + NotificationHelper.getUploadCount() + " file(s)";
                        SystemTrayUI.this.systrayItem.setToolTipText(SystemTrayUI.this.backupTooltip + SystemTrayUI.this.syncTooltip);
                        if (SystemTrayUI.this.systemStartCrawlMenuItem != null && !SystemTrayUI.this.systemStartCrawlMenuItem.isDisposed() && SystemTrayUI.this.systemStartCrawlMenuItem.getEnabled()) {
                            SystemTrayUI.this.systemStartCrawlMenuItem.setEnabled(false);
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("");
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("Currently Syncing...");
                            UIHelper.displaySyncingGif();
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    logger.error("Exception during the crawl process ", (Throwable)e);
                }
            };
            SystemTrayUI.this.display.asyncExec(runnable);
            SystemTrayUI.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
                            if (NotificationHelper.policyRefreshStarted) {
                                if (SystemTrayUI.this.systemPolicyRefreshMenuItem != null && !SystemTrayUI.this.systemPolicyRefreshMenuItem.isDisposed() && SystemTrayUI.this.systemPolicyRefreshMenuItem.getEnabled()) {
                                    SystemTrayUI.this.systemPolicyRefreshMenuItem.setEnabled(false);
                                    if (NotificationHelper.isChangeTextOfBackupPolicyMenu()) {
                                        SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("");
                                        SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("Refreshing Policy");
                                    }
                                }
                            } else if (SystemTrayUI.this.systemPolicyRefreshMenuItem != null && !SystemTrayUI.this.systemPolicyRefreshMenuItem.isDisposed()) {
                                SystemTrayUI.this.systemPolicyRefreshMenuItem.setEnabled(true);
                                SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("");
                                SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("Refresh Policy");
                            }
                        }
                        if (SettingHelper.getBackupLicenced().contentEquals("true")) {
                            if (NotificationHelper.backUpStarted) {
                                this.updateBackupProgressTooltip();
                                if (isStopBackupPressed) {
                                    SystemTrayUI.this.stopBackup.setEnabled(false);
                                }
                                if (isPauseBackupPressed) {
                                    SystemTrayUI.this.pauseBackup.setEnabled(false);
                                }
                                if (!(SystemTrayUI.this.pauseBackup == null || SystemTrayUI.this.pauseBackup.isDisposed() || isPauseBackupPressed || isStopBackupPressed)) {
                                    if (NotificationHelper.getBackupStatus() == 2) {
                                        SystemTrayUI.this.pauseBackup.setEnabled(false);
                                    } else {
                                        SystemTrayUI.this.pauseBackup.setEnabled(true);
                                    }
                                }
                                if (!(SystemTrayUI.this.stopBackup == null || SystemTrayUI.this.stopBackup.isDisposed() || isPauseBackupPressed || isStopBackupPressed)) {
                                    SystemTrayUI.this.stopBackup.setEnabled(true);
                                }
                                if (SystemTrayUI.this.systemStartBackupMenuItem != null && !SystemTrayUI.this.systemStartBackupMenuItem.isDisposed() && SystemTrayUI.this.systemStartBackupMenuItem.getEnabled()) {
                                    SystemTrayUI.this.systemStartBackupMenuItem.setEnabled(false);
                                    SystemTrayUI.this.systemStartBackupMenuItem.setText("");
                                    SystemTrayUI.this.systemStartBackupMenuItem.setText("Backup in progress");
                                    UIHelper.displaySyncingGif();
                                }
                                return;
                            }
                            if (SystemTrayUI.this.systrayItem != null && !SystemTrayUI.this.systrayItem.isDisposed()) {
                                SystemTrayUI.this.backupTooltip = PropertyHelper.SYSTRAY_TOOLTIP_LABEL;
                            }
                            if (SystemTrayUI.this.systemStartBackupMenuItem != null && !SystemTrayUI.this.systemStartBackupMenuItem.isDisposed()) {
                                SystemTrayUI.this.systemStartBackupMenuItem.setText("");
                                SystemTrayUI.this.systemStartBackupMenuItem.setText("Initiate Backup");
                                if (NotificationHelper.restoreStarted) {
                                    if (NotificationHelper.isSuspendBackup) {
                                        SystemTrayUI.this.systemStartBackupMenuItem.setEnabled(false);
                                    }
                                } else {
                                    SystemTrayUI.this.systemStartBackupMenuItem.setEnabled(true);
                                }
                            }
                            if (SystemTrayUI.this.pauseBackup != null && !SystemTrayUI.this.pauseBackup.isDisposed()) {
                                SystemTrayUI.this.pauseBackup.setText("Pause Backup");
                                SystemTrayUI.this.pauseBackup.setEnabled(false);
                                isPauseBackupPressed = false;
                            }
                            if (SystemTrayUI.this.stopBackup != null && !SystemTrayUI.this.stopBackup.isDisposed()) {
                                SystemTrayUI.this.stopBackup.setText("Stop Backup");
                                SystemTrayUI.this.stopBackup.setEnabled(false);
                                isStopBackupPressed = false;
                            }
                            if (NotificationHelper.getMainStatus() == 100) {
                                UIHelper.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                            }
                            return;
                        }
                    }
                    catch (Exception e) {
                        logger.error("Exception during the crawl process " + e);
                    }
                }

                private void updateBackupProgressTooltip() {
                    if (NotificationHelper.getBackupStatus() != 4) {
                        if (NotificationHelper.getBackupStatus() == 6) {
                            SystemTrayUI.this.backupTooltip = NotificationHelper.getCurrentBackupStatus() + PBCountDownTimer.getCountDownTimer() + "(mm:ss)";
                        } else {
                            SystemTrayUI.this.backupTooltip = NotificationHelper.getCurrentBackupStatus();
                        }
                        SystemTrayUI.this.systrayItem.setToolTipText(SystemTrayUI.this.backupTooltip + SystemTrayUI.this.syncTooltip);
                    } else if (NotificationHelper.getBackupStatus() == 4) {
                        String filesCount = NotificationHelper.getTotalBackupCount() + "/" + NotificationHelper.getNoOfFilesToBeBackedUp();
                        String toolTipText1 = NotificationHelper.getCurrentBackupStatus() + filesCount + SystemTrayUI.FILE;
                        String toolTipText2 = !NotificationHelper.getBackupChunkFileDetails().isEmpty() ? NotificationHelper.getBackupChunkFileDetails() : NotificationHelper.getBackupFileChunkingStatus();
                        SystemTrayUI.this.backupTooltip = "";
                        SystemTrayUI.this.backupTooltip = toolTipText1 + toolTipText2;
                        SystemTrayUI.this.systrayItem.setToolTipText(SystemTrayUI.this.backupTooltip + SystemTrayUI.this.syncTooltip);
                    }
                }
            });
        }

        private void handleSyncPolicyRefreshButton() {
            if (NotificationHelper.syncPolicyRefreshStarted) {
                if (SystemTrayUI.this.systemSyncPolicyRefreshMenuItem != null && !SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.isDisposed() && SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.getEnabled()) {
                    SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setEnabled(false);
                    SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setText("");
                    SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setText("Refreshing Policy");
                }
            } else if (SystemTrayUI.this.systemSyncPolicyRefreshMenuItem != null && !SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.isDisposed()) {
                SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setEnabled(true);
                SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setText("");
                SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setText("Refresh Sync Policy");
            }
        }

        private void handleUpdateAgent() {
            if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
                if (NotificationHelper.isUpdateagentstarted()) {
                    if (SystemTrayUI.this.updateAgent != null && !SystemTrayUI.this.updateAgent.isDisposed() && SystemTrayUI.this.updateAgent.getEnabled()) {
                        SystemTrayUI.this.updateAgent.setEnabled(false);
                        SystemTrayUI.this.updateAgent.setText("");
                        SystemTrayUI.this.updateAgent.setText("Checking Update");
                    }
                } else if (SystemTrayUI.this.updateAgent != null && !SystemTrayUI.this.updateAgent.isDisposed()) {
                    SystemTrayUI.this.updateAgent.setEnabled(true);
                    SystemTrayUI.this.updateAgent.setText("");
                    SystemTrayUI.this.updateAgent.setText("Check for Update");
                }
            }
        }
    }

    static class ShutdownHookUI
    extends Thread {
        ShutdownHookUI() {
        }

        @Override
        public void run() {
            SystemTrayUI.unlockFileUI();
        }
    }
}

