/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.dao.ActivityHistoryImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.SystemTrayUI;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActivityHistoryView
extends BaseView {
    private static Logger logger = LoggerFactory.getLogger(ActivityHistoryView.class);
    FontsManager fontsManager;
    private static final int TOTAL_ITEM_COUNT = 13;
    private boolean pageToggle = true;
    private int activityPageNumberIndex = 0;
    private Timer activityTimer = null;
    private TimerTask activityTimerTask = null;
    private Label horizontalLine = null;
    private Composite refreshPanel = null;
    private Button firstButton = null;
    private Button nextButton = null;
    private Button previousButton = null;
    private Button lastButton = null;
    private Composite activityHistoryPanel = null;
    private Table activityHistoryTable = null;
    private TableColumn[] column = null;
    private static final int CURRENT_OFFSET = 0;
    private Image nextImage = null;
    private ImageData nextImageData = null;
    private ImageData previousImageData = null;
    private Image previousImage = null;
    private ImageData imageFirstData = null;
    private ImageData imageLastData = null;
    private Image imageFirst = null;
    private Image imageLast = null;
    public static final String RESOURCE = "resource";
    private static final String IMG = "img";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String BLUSYNC_NEXT_ICON_PATH = "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "next.png";
    public static final String BLUSYNC_PREVIOUS_ICON_PATH = "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "previous.png";
    public static final String BLUSYNC_FIRST_ICON_PATH = "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "first.png";
    public static final String BLUSYNC_LAST_ICON_PATH = "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "last.png";
    private static final String FINISHED_ACTIVITY_REFRESH = "Activity Refreshed";
    private Link infectedFilesLink = null;

    public ActivityHistoryView(Composite composite) {
        this.mainParentComposite = composite;
        this.generateUI();
    }

    private void generateUI() {
        GridData activityHistoryPanelGridData = new GridData(1808);
        activityHistoryPanelGridData.heightHint = 400;
        activityHistoryPanelGridData.widthHint = 400;
        GridLayout settingsGroupGridLayout = new GridLayout();
        GridLayout activityHistoryPanelCompositeLayout = new GridLayout();
        GridLayout refreshPanelGridLayout = new GridLayout();
        Display display = this.mainParentComposite.getDisplay();
        this.fontsManager = new FontsManager(display);
        this.nextImageData = new ImageData(BLUSYNC_NEXT_ICON_PATH);
        this.previousImageData = new ImageData(BLUSYNC_PREVIOUS_ICON_PATH);
        this.nextImage = new Image((Device)display, this.nextImageData);
        this.previousImage = new Image((Device)display, this.previousImageData);
        this.imageFirstData = new ImageData(BLUSYNC_FIRST_ICON_PATH);
        this.imageLastData = new ImageData(BLUSYNC_LAST_ICON_PATH);
        this.imageFirst = new Image((Device)display, this.imageFirstData);
        this.imageLast = new Image((Device)display, this.imageLastData);
        this.baseGroup = new Composite(this.mainParentComposite, 65600);
        this.baseGroup.setLayoutData((Object)new GridData());
        settingsGroupGridLayout.numColumns = 1;
        settingsGroupGridLayout.marginTop = 0;
        settingsGroupGridLayout.marginLeft = 0;
        settingsGroupGridLayout.marginHeight = 0;
        settingsGroupGridLayout.marginWidth = 0;
        settingsGroupGridLayout.marginRight = 0;
        this.baseGroup.setLayout((Layout)settingsGroupGridLayout);
        this.activityHistoryPanel = new Composite(this.baseGroup, 4);
        activityHistoryPanelCompositeLayout.numColumns = 1;
        activityHistoryPanelCompositeLayout.marginTop = 0;
        activityHistoryPanelCompositeLayout.marginWidth = 0;
        activityHistoryPanelCompositeLayout.marginHeight = 0;
        activityHistoryPanelCompositeLayout.marginRight = 0;
        this.activityHistoryPanel.setLayout((Layout)activityHistoryPanelCompositeLayout);
        activityHistoryPanelGridData.horizontalSpan = 1;
        this.activityHistoryPanel.setLayoutData((Object)activityHistoryPanelGridData);
        this.activityHistoryTable = new Table(this.activityHistoryPanel, 65536);
        this.activityHistoryTable.setLayoutData((Object)new GridData(1808));
        this.column = new TableColumn[4];
        this.column[0] = new TableColumn(this.activityHistoryTable, 16384);
        this.column[0].setText("Sync start time");
        this.column[0].setWidth(130);
        this.column[0].setMoveable(true);
        this.column[1] = new TableColumn(this.activityHistoryTable, 16384);
        this.column[1].setText("Status");
        this.column[1].setWidth(130);
        this.column[1].setMoveable(true);
        this.column[2] = new TableColumn(this.activityHistoryTable, 16384);
        this.column[2].setText("Upload");
        this.column[2].setWidth(65);
        this.column[2].setMoveable(true);
        this.column[3] = new TableColumn(this.activityHistoryTable, 16384);
        this.column[3].setText("Download");
        this.column[3].setWidth(75);
        this.column[3].setMoveable(true);
        this.activityHistoryTable.setHeaderVisible(true);
        this.activityHistoryTable.setParent(this.activityHistoryPanel);
        this.activityHistoryTable.setLinesVisible(false);
        this.activityHistoryTable.setFont(this.fontsManager.getSmallNormalFont());
        this.activityHistoryTable.setItemCount(13);
        this.infectedFilesLink = new Link(this.activityHistoryPanel, 256);
        this.infectedFilesLink.setText(" <a>View Infected Files </a>");
        this.infectedFilesLink.setFont(this.fontsManager.getMediumNormalFont());
        this.infectedFilesLink.setLayoutData((Object)new GridData());
        Listener listener1 = event1 -> {
            logger.debug("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$.....");
            String authToken = null;
            try {
                authToken = SystemTrayUI.getUserAuthenticationToken();
            }
            catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                e.printStackTrace();
            }
            SystemTrayUI.launchSyncSettings(authToken);
        };
        this.infectedFilesLink.addListener(13, listener1);
        this.horizontalLine = new Label(this.baseGroup, 258);
        this.horizontalLine.setLayoutData((Object)new GridData(768));
        this.refreshPanel = new Composite(this.baseGroup, 0);
        refreshPanelGridLayout.numColumns = 4;
        refreshPanelGridLayout.makeColumnsEqualWidth = false;
        refreshPanelGridLayout.horizontalSpacing = 30;
        refreshPanelGridLayout.marginLeft = 75;
        this.refreshPanel.setLayout((Layout)refreshPanelGridLayout);
        this.firstButton = new Button(this.refreshPanel, 8);
        this.firstButton.setLayoutData((Object)new GridData());
        this.firstButton.setImage(this.imageFirst);
        this.firstButton.setToolTipText("Click to see the first page");
        this.firstButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ActivityHistoryView.this.activityPageNumberIndex = 0;
                ActivityHistoryView.this.pageToggle = true;
                logger.info("Refreshing Activity Table");
                ActivityHistoryView.this.refreshActivityTable();
            }
        });
        this.previousButton = new Button(this.refreshPanel, 8);
        this.previousButton.setLayoutData((Object)new GridData());
        this.previousButton.setImage(this.previousImage);
        this.previousButton.setToolTipText("Click to see the previous page");
        this.previousButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                logger.debug("Trying To Refresh Activity History on Previous click");
                if (ActivityHistoryView.this.pageToggle) {
                    if (ActivityHistoryView.this.activityPageNumberIndex > 0) {
                        ActivityHistoryView.this.activityPageNumberIndex--;
                        ActivityHistoryView.this.refreshActivityTable();
                    }
                } else {
                    ActivityHistoryView.this.activityPageNumberIndex++;
                    ActivityHistoryView.this.refreshActivityTable();
                }
                logger.debug(ActivityHistoryView.FINISHED_ACTIVITY_REFRESH);
            }
        });
        this.nextButton = new Button(this.refreshPanel, 8);
        this.nextButton.setLayoutData((Object)new GridData());
        this.nextButton.setImage(this.nextImage);
        this.nextButton.setToolTipText("Click to see the next page");
        this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                logger.debug("Trying To Refresh Activity History on Next click");
                if (ActivityHistoryView.this.pageToggle) {
                    ActivityHistoryView.this.activityPageNumberIndex++;
                    ActivityHistoryView.this.refreshActivityTable();
                } else if (ActivityHistoryView.this.activityPageNumberIndex > 0) {
                    ActivityHistoryView.this.activityPageNumberIndex--;
                    ActivityHistoryView.this.refreshActivityTable();
                }
                logger.debug(ActivityHistoryView.FINISHED_ACTIVITY_REFRESH);
            }
        });
        this.lastButton = new Button(this.refreshPanel, 8);
        this.lastButton.setImage(this.imageLast);
        this.lastButton.setToolTipText("Click to see the last page");
        this.lastButton.setLayoutData((Object)new GridData());
        this.lastButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                logger.debug("Trying To Refresh Activity History on Last click");
                ActivityHistoryView.this.activityPageNumberIndex = 0;
                ActivityHistoryView.this.pageToggle = false;
                ActivityHistoryView.this.refreshActivityTable();
                logger.debug("Finished Refresh on Last click");
            }
        });
        this.refreshActivityTable();
    }

    protected synchronized void refreshActivityTable() {
        logger.debug("Entering refresh Activity Table");
        ActivityHistoryImpl activity = new ActivityHistoryImpl(SettingHelper.getActivityDBUrl());
        int endCount = 13;
        int begginCount = 0 + this.activityPageNumberIndex * 13;
        List listOfActivityRecords = activity.getSelectRecordsFromHistoryActivityHistoryTable(this.pageToggle, (long)begginCount, (long)endCount);
        if (listOfActivityRecords == null || listOfActivityRecords.isEmpty()) {
            logger.debug("List Of Activity Records is null");
            if (this.activityPageNumberIndex > 0) {
                --this.activityPageNumberIndex;
            }
            return;
        }
        if (this.activityHistoryTable == null || this.activityHistoryTable.isDisposed()) {
            logger.debug("Activity History Table is null");
            return;
        }
        int itemCount = this.activityHistoryTable.getItemCount();
        if (itemCount > 0) {
            this.activityHistoryTable.removeAll();
        }
        for (ActivityTO activityType : listOfActivityRecords) {
            int columnCount = 0;
            TableItem item = this.pageToggle ? new TableItem(this.activityHistoryTable, 0) : new TableItem(this.activityHistoryTable, 0, 0);
            String crawlStartTime = this.getHumanReadableDate(activityType.getActivityTimeStamp());
            if (!activityType.getActivityName().equals(CrawlLifecycle.EXITED.name()) && !activityType.getActivityName().equals(CrawlLifecycle.UNEXPECTED_TERMINATION.name())) {
                item.setText(columnCount++, crawlStartTime == null ? "0" : crawlStartTime);
            }
            int n = ++columnCount;
            ++columnCount;
            item.setText(n, String.valueOf(activityType.getActivityName()));
            String uploadCount = activityType.getUploadCount();
            String downloadCount = activityType.getDownloadCount();
            if (uploadCount != null && "null".equals(uploadCount)) {
                uploadCount = "0/0";
            }
            if (downloadCount != null && "null".equals(downloadCount)) {
                downloadCount = "0/0";
            }
            if (activityType.getActivityName().equals(CrawlLifecycle.UPLOAD_DOWNLOAD_RUNNING.name())) {
                uploadCount = NotificationHelper.getUploadCount();
                downloadCount = NotificationHelper.getDowloadCount();
            }
            item.setText(columnCount++, uploadCount == null ? "0/0" : uploadCount);
            item.setText(columnCount, downloadCount == null ? "0/0" : downloadCount);
        }
    }

    public void startActivityTimerTask() {
        if (this.activityTimer == null) {
            this.activityTimer = new Timer();
        }
        if (this.activityTimerTask == null) {
            this.activityTimerTask = new TimerTask(){

                @Override
                public void run() {
                    logger.info("refreshing ActivityTimerTask");
                    ActivityHistoryView.this.refreshAsyncTask();
                }
            };
            this.activityTimer.schedule(this.activityTimerTask, 10L, 10000L);
        }
    }

    protected synchronized void refreshAsyncTask() {
        Display display = this.mainParentComposite.getDisplay();
        if (display == null) {
            logger.debug("Current Display is null");
            return;
        }
        Runnable runnable = () -> {
            try {
                logger.debug("Trying To Refresh Activity History");
                this.refreshActivityTable();
                logger.debug(FINISHED_ACTIVITY_REFRESH);
            }
            catch (Exception e) {
                logger.error("Exception in activityhistoryview; refresh Async Task: " + e);
            }
        };
        display.asyncExec(runnable);
    }

    private void stopActivityTimerTask() {
        this.activityTimer.cancel();
        this.activityTimer = null;
        this.activityTimerTask = null;
    }

    private String getHumanReadableDate(Date crawlStartTime) {
        if (crawlStartTime != null) {
            SimpleDateFormat activityLogdateFmt = new SimpleDateFormat("d MMM HH:mm:ss");
            return activityLogdateFmt.format(crawlStartTime);
        }
        return null;
    }

    public void disposeAllActivityHistoryFields() {
        this.stopActivityTimerTask();
        this.fontsManager.disposeFonts();
        this.disposeRefreshFields();
        this.disposeMainActivityFields();
        if (this.refreshPanel != null) {
            this.refreshPanel.dispose();
        }
        if (this.activityHistoryPanel != null) {
            this.activityHistoryPanel.dispose();
        }
        if (this.nextImage != null && !this.nextImage.isDisposed()) {
            this.nextImage.dispose();
        }
        if (this.previousImage != null && !this.previousImage.isDisposed()) {
            this.previousImage.dispose();
        }
        if (this.imageFirst != null && !this.imageFirst.isDisposed()) {
            this.imageFirst.dispose();
        }
        if (this.imageLast != null && !this.imageLast.isDisposed()) {
            this.imageLast.dispose();
        }
        this.imageFirst = null;
        this.imageLast = null;
        this.imageFirstData = null;
        this.imageLastData = null;
        this.previousImage = null;
        this.nextImage = null;
        this.nextImageData = null;
        this.previousImageData = null;
        this.refreshPanel = null;
        this.activityHistoryPanel = null;
    }

    private void disposeMainActivityFields() {
        if (this.activityHistoryTable == null || this.activityHistoryTable.isDisposed()) {
            return;
        }
        this.activityHistoryTable.dispose();
        this.activityHistoryTable = null;
    }

    private void disposeRefreshFields() {
        if (this.nextButton != null) {
            this.nextButton.dispose();
        }
        if (this.previousButton != null) {
            this.previousButton.dispose();
        }
        if (this.firstButton != null) {
            this.firstButton.dispose();
        }
        if (this.lastButton != null) {
            this.lastButton.dispose();
        }
        this.previousButton = null;
        this.nextButton = null;
        this.lastButton = null;
        this.firstButton = null;
    }
}

