/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.backup;

import com.parablu.epa.common.service.backup.MultiThreadResendFilesUpload;
import com.parablu.epa.common.service.backup.ReSendFilesJob;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.service.proxy.ProxyDetector;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.helper.BackupCrawlUtility;
import com.parablu.epa.helper.utils.RegistryUtils;
import com.parablu.epa.helper.windows.VolumeShadowService;
import com.parablu.epa.service.backup.WindowsResendFilesUploadJob;
import com.parablu.epa.service.notifications.UIHelper;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZMQ;

public class WindowsResendFilesJob
extends ReSendFilesJob {
    private Logger logger = LoggerFactory.getLogger(WindowsResendFilesJob.class);
    int lastSuccessfulCrawledTime = 0;
    private MultiThreadResendFilesUpload backUpUpload = null;
    private VolumeShadowService volumeShadowService = new VolumeShadowService();

    public WindowsResendFilesJob(boolean manualVal) {
        super(manualVal);
    }

    public void startBackUpThread(List<BackupTO> backUpList) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.logger.debug("BACKUP JOB UPLOAD START");
        this.backUpUpload = new WindowsResendFilesUploadJob(SettingHelper.getCurrentCloudIpAddress(), this.currentPort, SettingHelper.getCloudName(), SettingHelper.readTokenFromFile(), SettingHelper.getBackUpDbUrl(), backUpList);
        this.backUpUpload.setName("BackUpUpload");
        this.backUpUpload.start();
        this.backUpUpload.join();
    }

    public void updateSystrayToolTipNotification(String toolTipMessage, String toolTipmessage1) {
        UIHelper.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
    }

    protected void scanFileSystemByType(BackupFolderTO backupFolderTO) {
        BackupCrawlUtility backupCrawlUtility = new BackupCrawlUtility();
        backupCrawlUtility.crawlFolderEfficientStoringFullPaths(backupFolderTO.getFolderPath(), null);
    }

    public void updateSystrayImageAccordingToStage(String syncingImage) {
        if (NotificationHelper.getMainStatus() == 100) {
            UIHelper.updateSystrayImageAccordingToStage(syncingImage);
        } else {
            UIHelper.displaySyncingGif();
        }
    }

    public void pauseBackup(boolean isManualStop) {
        if (this.backUpUpload != null && this.backUpUpload.isAlive()) {
            try {
                this.logger.debug("stopping the thread");
                if (isManualStop) {
                    PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)1992);
                }
                this.backUpUpload.interrupt();
                this.logger.debug("Interrupted backup thread");
                this.backUpUpload.join(10000L);
                this.backUpUpload.interrupt();
                this.logger.debug("Interrupted backup thread again");
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Exception" + e.getMessage());
            }
        }
    }

    public void deleteVsnapshot(List<BackupFolderTO> listOfFolder) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"action", (Object)"deletevss");
        JSONArray list = new JSONArray();
        for (BackupFolderTO folder : listOfFolder) {
            list.add((Object)folder.getFolderPath());
            this.logger.debug("snapfolders to delete : " + folder.getFolderPath());
        }
        obj.put((Object)"folderPaths", (Object)list);
        ZMQ.Context context = ZMQ.context((int)1);
        this.logger.debug("Connecting to hello world server");
        ZMQ.Socket socket = context.socket(3);
        String port = RegistryUtils.getServicePortNumberFromReg((String)ProxyDetector.getOsType());
        socket.connect("tcp://localhost:" + port);
        this.logger.debug("calling to delete");
        for (int requestNbr = 0; requestNbr != 1; ++requestNbr) {
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            ZMQ.PollItem[] items = new ZMQ.PollItem[]{new ZMQ.PollItem(socket, 1)};
            int rc = ZMQ.poll((ZMQ.PollItem[])items, (long)300000L);
            if (rc == -1) break;
            if (items[0].isReadable()) {
                String reply = socket.recvStr();
                this.logger.debug("Received " + new String(reply) + " " + requestNbr);
                continue;
            }
            this.logger.debug("Service TIME OUT");
        }
        socket.close();
        context.term();
    }

    public void createVsnapshot(List<BackupFolderTO> listOfFolder) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"action", (Object)"createvss");
        JSONArray list = new JSONArray();
        for (BackupFolderTO folder : listOfFolder) {
            list.add((Object)folder.getFolderPath());
            this.logger.debug("snapfolders to create : " + folder.getFolderPath());
        }
        obj.put((Object)"folderPaths", (Object)list);
        ZMQ.Context context = ZMQ.context((int)1);
        this.logger.debug("Connecting to hello world server");
        ZMQ.Socket socket = context.socket(3);
        String port = RegistryUtils.getServicePortNumberFromReg((String)ProxyDetector.getOsType());
        socket.connect("tcp://localhost:" + port);
        for (int requestNbr = 0; requestNbr != 1; ++requestNbr) {
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            ZMQ.PollItem[] items = new ZMQ.PollItem[]{new ZMQ.PollItem(socket, 1)};
            int rc = ZMQ.poll((ZMQ.PollItem[])items, (long)300000L);
            if (rc == -1) break;
            if (items[0].isReadable()) {
                String reply = socket.recvStr();
                this.logger.debug("Received " + new String(reply) + " " + requestNbr);
                continue;
            }
            this.logger.debug("Service TIME OUT");
        }
        socket.close();
        context.term();
    }

    public boolean runScripts(String type, boolean isManual) {
        return this.volumeShadowService.runScript(type, isManual);
    }
}

