/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.backup;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.service.backup.MultiThreadBackupUpload;
import com.parablu.epa.common.service.backup.NewBackUpJob;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.service.proxy.ProxyDetector;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.helper.BackupCrawlUtility;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.helper.utils.RegistryUtils;
import com.parablu.epa.helper.windows.VolumeShadowService;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.backup.WindowsBackupUploadJob;
import com.parablu.epa.service.backup.WindowsCheckBackupPolicy;
import com.parablu.epa.service.notifications.UIHelper;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZMQ;

public class WindowsBackupJob
extends NewBackUpJob {
    private Logger logger = LoggerFactory.getLogger(WindowsBackupJob.class);
    int lastSuccessfulCrawledTime = 0;
    private MultiThreadBackupUpload backUpUpload = null;
    private VolumeShadowService volumeShadowService = new VolumeShadowService();
    private NewBackUpJob backUpJob = null;

    public WindowsBackupJob(boolean manualVal, boolean isFullBackup) {
        super(manualVal, isFullBackup);
    }

    public void startBackUpThread(Set<DedupTO> dedupTOs, boolean restart, long restartId, String backupType) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.logger.debug("BACKUP JOB UPLOAD START");
        this.backUpUpload = new WindowsBackupUploadJob(SettingHelper.getCurrentCloudIpAddress(), this.currentPort, SettingHelper.getCloudName(), SettingHelper.readTokenFromFile(), SettingHelper.getBackUpDbUrl(), dedupTOs, restart, restartId, backupType);
        this.backUpUpload.setName("BackUpUpload");
        this.backUpUpload.setPriority(this.setThreadPriority());
        this.backUpUpload.start();
        this.backUpUpload.join();
    }

    private int setThreadPriority() {
        return SettingHelper.getCurrentBackupPolicy().getThreadPriorityForcpuThrottle();
    }

    public void updateSystrayToolTipNotification(String toolTipMessage, String toolTipmessage1) {
        UIHelper.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
    }

    protected void scanFileSystemByType(BackupFolderTO backupFolderTO) {
        BackupCrawlUtility backupCrawlUtility = new BackupCrawlUtility();
        backupCrawlUtility.crawlFolderEfficientStoringFullPaths(backupFolderTO.getFolderPath(), null);
    }

    public void updateSystrayImageAccordingToStage(String syncingImage) {
        if (NotificationHelper.getMainStatus() == 100) {
            UIHelper.updateSystrayImageAccordingToStage(syncingImage);
        } else {
            UIHelper.displaySyncingGif();
        }
    }

    public void pauseBackup(boolean isManualStop, boolean hardStop, NewBackUpJob newBackUpJob, boolean isActionFromPortal) {
        try {
            BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
            BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
            if (backupActivityTO.getBatchStatus().equals(BackupLifeCycle.STARTED.toString()) && this.backUpUpload != null && this.backUpUpload.isAlive()) {
                this.logger.debug("stopping the thread");
                this.backUpUpload.interrupt();
                this.logger.debug("Interrupted backup thread");
                this.backUpUpload.join(10000L);
                this.backUpUpload.interrupt();
            }
            if ((backupActivityTO.getBatchStatus().equals(BackupLifeCycle.SCANNING.toString()) || backupActivityTO.getBatchStatus().equals(BackupLifeCycle.PRESCAN_COMMAND_EXECUTION.toString())) && newBackUpJob != null) {
                newBackUpJob.interrupt();
            }
            this.logger.debug("Interrupted backup thread again ismanual stop: " + isManualStop + "is hardStop: " + hardStop + "fromPortal " + isActionFromPortal);
            if (isManualStop && !hardStop && !isActionFromPortal) {
                this.logger.debug("updating error code as user stopped backup");
                PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)1992);
            } else if (isManualStop && hardStop && !isActionFromPortal) {
                this.logger.debug("updating error code as user hard stopped backup");
                PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)1207);
            } else if (isManualStop && !hardStop && isActionFromPortal) {
                this.logger.debug("updating error code as user stopped backup");
                PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)1208);
            } else if (isManualStop && hardStop && isActionFromPortal) {
                this.logger.debug("updating error code as user hard stopped backup");
                PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)1209);
            }
            this.logger.debug("After updating the error code as user stopped backup");
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception" + e.getMessage());
        }
    }

    public void deleteVsnapshot(List<BackupFolderTO> listOfFolder) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"action", (Object)"deletevss");
        JSONArray list = new JSONArray();
        String fileSnapshotPath = ParabluFileSystemUtils.getOldInstallationDir();
        if (StringUtils.equalsIgnoreCase((String)fileSnapshotPath, (String)"null")) {
            fileSnapshotPath = ParabluFileSystemUtils.getInstallationDir();
        }
        for (BackupFolderTO folder : listOfFolder) {
            list.add((Object)folder.getFolderPath());
            this.logger.debug("snapfolders to delete : " + folder.getFolderPath());
        }
        obj.put((Object)"folderPaths", (Object)list);
        obj.put((Object)"snapShotPath", (Object)(fileSnapshotPath + "\\Snapshots"));
        ZMQ.Context context = ZMQ.context((int)1);
        this.logger.debug("Connecting to hello world server");
        ZMQ.Socket socket = context.socket(3);
        String port = RegistryUtils.getServicePortNumberFromReg((String)ProxyDetector.getOsType());
        socket.connect("tcp://localhost:" + port);
        this.logger.debug("calling to delete");
        for (int requestNbr = 0; requestNbr != 1; ++requestNbr) {
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            ZMQ.PollItem[] items = new ZMQ.PollItem[]{new ZMQ.PollItem(socket, 1)};
            int rc = ZMQ.poll((ZMQ.PollItem[])items, (long)300000L);
            if (rc == -1) break;
            if (items[0].isReadable()) {
                String reply = socket.recvStr();
                this.logger.debug("Received " + new String(reply) + " " + requestNbr);
                continue;
            }
            this.logger.debug("Service TIME OUT");
        }
        this.closeSocketAndTerminateContext(context, socket);
    }

    public boolean createVsnapshot(List<BackupFolderTO> listOfFolder) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"action", (Object)"createvss");
        JSONArray list = new JSONArray();
        String fileSnapshotPath = ParabluFileSystemUtils.getOldInstallationDir();
        boolean result = false;
        if (StringUtils.equalsIgnoreCase((String)fileSnapshotPath, (String)"null")) {
            fileSnapshotPath = ParabluFileSystemUtils.getInstallationDir();
        }
        for (BackupFolderTO folder : listOfFolder) {
            list.add((Object)folder.getFolderPath());
            this.logger.debug("snapfolders to create : " + folder.getFolderPath());
        }
        obj.put((Object)"folderPaths", (Object)list);
        obj.put((Object)"snapShotPath", (Object)(fileSnapshotPath + "\\Snapshots"));
        ZMQ.Context context = ZMQ.context((int)1);
        this.logger.debug("Connecting to hello world server");
        ZMQ.Socket socket = context.socket(3);
        String port = RegistryUtils.getServicePortNumberFromReg((String)ProxyDetector.getOsType());
        socket.connect("tcp://localhost:" + port);
        for (int requestNbr = 0; requestNbr != 1; ++requestNbr) {
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            ZMQ.PollItem[] items = new ZMQ.PollItem[]{new ZMQ.PollItem(socket, 1)};
            int rc = ZMQ.poll((ZMQ.PollItem[])items, (long)300000L);
            if (rc == -1) break;
            if (items[0].isReadable()) {
                String reply = socket.recvStr();
                this.logger.debug("Received " + new String(reply) + " " + requestNbr);
                if (!reply.equalsIgnoreCase(String.valueOf(200))) continue;
                result = true;
                continue;
            }
            this.logger.debug("Service TIME OUT");
        }
        this.closeSocketAndTerminateContext(context, socket);
        return result;
    }

    private void closeSocketAndTerminateContext(ZMQ.Context context, ZMQ.Socket socket) {
        this.logger.debug("before closing the socket..");
        socket.close();
        this.logger.debug("After closing the socket..");
        context.term();
        this.logger.debug("After terminating the context..");
    }

    public boolean runScripts(String type, boolean isManual) {
        return this.volumeShadowService.runScript(type, isManual);
    }

    public void startBackupPolicyRefresh() {
        try {
            WindowsCheckBackupPolicy.checkGroupPolicy();
            Thread.sleep(1000L);
            BlusyncThreadHelper.resetBackupTimer();
            BlusyncThreadHelper.validateDomainCheck();
        }
        catch (InterruptedException e) {
            this.logger.error("", (Object)e.getMessage());
            this.logger.trace("", (Throwable)e);
        }
    }

    public void updateSystrayToolTipNotification() {
        UIHelper.updateSystrayToolTipNotification("Parablu Blusync", "You have no folders configured for backup");
    }

    public boolean runCommandUsingService(String command, String filename) {
        boolean result = false;
        JSONObject obj = new JSONObject();
        obj.put((Object)"action", (Object)"runcmd");
        obj.put((Object)"command", (Object)command);
        obj.put((Object)"filename", (Object)filename);
        this.logger.debug(command);
        JSONArray list = new JSONArray();
        ZMQ.Context context = ZMQ.context((int)1);
        this.logger.debug("Connecting to hello world server");
        ZMQ.Socket socket = context.socket(3);
        String port = RegistryUtils.getServicePortNumberFromReg((String)ProxyDetector.getOsType());
        socket.connect("tcp://localhost:" + port);
        int connectionTimeFromRegieditInMin = this.getConnecionTimeFromRegedit();
        for (int requestNbr = 0; requestNbr != 1; ++requestNbr) {
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            ZMQ.PollItem[] items = new ZMQ.PollItem[]{new ZMQ.PollItem(socket, 1)};
            int rc = ZMQ.poll((ZMQ.PollItem[])items, (long)((long)(connectionTimeFromRegieditInMin * 1000) * 60L));
            if (rc == -1) break;
            if (items[0].isReadable()) {
                String reply = socket.recvStr();
                this.logger.debug("Received " + new String(reply) + " " + requestNbr);
                if (!reply.equalsIgnoreCase(String.valueOf(200))) continue;
                result = true;
                this.logger.debug("status is ok ....");
                continue;
            }
            this.logger.debug("Service TIME OUT");
        }
        this.closeSocketAndTerminateContext(context, socket);
        return result;
    }

    private int getConnecionTimeFromRegedit() {
        int connectionTimeFromRegieditInMin = 300;
        String platformNo = SettingHelper.getOsVersion();
        String timerdelayinString = "";
        try {
            timerdelayinString = platformNo.contains("64 bit") ? RegistryUtils.getRegistryValue((String)"HKLM", (String)"SOFTWARE\\WOW6432Node\\ParaBlu\\BluSync\\Params", (String)"ConnectionTimeOutInMins") : RegistryUtils.getRegistryValue((String)"HKLM", (String)"SOFTWARE\\ParaBlu\\BluSync\\Params", (String)"ConnectionTimeOutInMins");
            if (StringUtils.isNotEmpty((String)timerdelayinString)) {
                connectionTimeFromRegieditInMin = Integer.parseInt(timerdelayinString);
            }
        }
        catch (Exception e) {
            this.logger.debug("exception getting sleeptime from reg edit:" + e);
        }
        return connectionTimeFromRegieditInMin;
    }
}

