/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper;

import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.RestoreActivityHistoryDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.to.BackupOrRestoreStatusTo;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.RestoreActivityTO;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.helper.windows.ExecuteCalloutScript;
import com.parablu.epa.helper.windows.VolumeShadowService;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.alarm.ManualSyncHelper;
import com.parablu.epa.service.backup.WindowsCheckBackupPolicy;
import com.parablu.epa.service.notifications.DirectoryRefreshHelper;
import com.parablu.epa.service.settings.WindowsSettingsHelper;
import com.parablu.epa.view.BluSyncLauncher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZMQ;

public class CommandListenerService
extends AbstractExecutionThreadService {
    ZMQ.Context context;
    ZMQ.Socket server;
    private Logger logger = LoggerFactory.getLogger(CommandListenerService.class);
    private JSONParser parser;
    private static String port = PropertyHelper.AGENT_LISTNER_PORT;
    private static boolean listnerLock = false;
    private static String sourcePath;
    private BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
    private String uploadIpForGateway = "";
    private static String batchId;
    private static RestoreElement restoreElement;
    private static final String BACKUP_TYPE_FULL = "FULL";
    private static final String STR_TRUE = "true";

    protected void shutDown() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.server.close();
        this.context.term();
        this.logger.debug("in shutdown");
        this.logger.debug("after shutdown isRunning :" + this.isRunning());
    }

    protected void triggerShutdown() {
        try {
            this.logger.debug("trigger  shut");
            ZMQ.Socket peer = this.context.socket(8);
            peer.connect("tcp://localhost:" + port);
            peer.send("STOP", 0);
            peer.close();
        }
        catch (Exception ex) {
            this.logger.debug("Failed to stop service" + ex);
        }
    }

    protected void startUp() throws Exception {
        try {
            this.logger.debug("IN STARTUP");
            this.context = ZMQ.context((int)1);
            this.server = this.context.socket(4);
            this.server.bind("tcp://*:" + port);
            this.parser = new JSONParser();
        }
        catch (Exception e) {
            this.logger.error("Exception in start up :" + e);
        }
    }

    protected void run() throws Exception {
        this.logger.debug("in run");
        try {
            while (this.isRunning()) {
                String request = this.server.recvStr();
                this.logger.debug("Recived request JSON: " + request);
                JSONObject reqObject = null;
                if ((reqObject = this.parseJsonString(request, reqObject)) == null) continue;
                String action = null;
                if ((action = this.getActionFrmJsonObj(reqObject, action)) != null) {
                    Actions act = null;
                    if ((act = this.getActValFrmAction(action, act)) == null) {
                        this.logger.debug("inside act is nullable:");
                        act = Actions.OTHERS;
                    }
                    switch (act) {
                        case BACKUP: {
                            if (!listnerLock) {
                                if (this.isRestoreOrBackupStarted()) break;
                                listnerLock = true;
                                this.server.send(String.valueOf(200));
                                this.callBackup(reqObject);
                                break;
                            }
                            this.listenerLocknotAcquired();
                            break;
                        }
                        case RESTORE: {
                            if (!listnerLock) {
                                if (this.isRestoreOrBackupStarted()) break;
                                listnerLock = true;
                                this.callRestore(request);
                                break;
                            }
                            this.listenerLocknotAcquired();
                            break;
                        }
                        case REFRESHPOLICY: {
                            if (!listnerLock) {
                                listnerLock = true;
                                this.callRefreshPolicy();
                                break;
                            }
                            this.listenerLocknotAcquired();
                            break;
                        }
                        case STOPBACKUP: {
                            this.server.send(String.valueOf(200));
                            ExecuteCalloutScript.terminateScripts();
                            BlusyncThreadHelper.cancelCurrentBackupProcess(true, false, true);
                            break;
                        }
                        case ISRESTORERUNNING: {
                            if (!listnerLock) {
                                listnerLock = true;
                                if (this.isRestoreOrBackupStarted()) break;
                                this.server.send(String.valueOf(200));
                                break;
                            }
                            this.logger.debug("Unable to acquire listner lock");
                            this.server.send(String.valueOf(601));
                            break;
                        }
                        case EXIT: {
                            if (!listnerLock) {
                                listnerLock = true;
                                this.logger.debug("received 99");
                                break;
                            }
                            this.listenerLocknotAcquired();
                            break;
                        }
                        case DECOUPLE: {
                            this.logger.debug("Clicked on Decouple button");
                            this.sendDecoupleRequest();
                            WindowsSettingsHelper.dsconnectWebDAVasNetworkDrive();
                            DirectoryRefreshHelper directoryRefreshHelper = new DirectoryRefreshHelper();
                            directoryRefreshHelper.refreshDirectory();
                            BluSyncLauncher.changeAccount();
                            break;
                        }
                        case OTHERS: {
                            this.logger.debug("Recived improper request");
                            this.logger.debug("received something else");
                            this.logger.debug("sending the httpstatus");
                            this.server.send(String.valueOf(400));
                            break;
                        }
                        default: {
                            this.logger.debug("Recived improper request");
                            this.server.send(String.valueOf(200));
                        }
                    }
                    this.logger.debug("Listner lock " + listnerLock);
                    listnerLock = false;
                    continue;
                }
                this.logger.debug("Invalid command");
                this.server.send(String.valueOf(400));
            }
        }
        catch (IllegalStateException se) {
            this.logger.debug("IllegalStateException in executing :" + se);
            this.server.send(String.valueOf(400));
        }
        catch (Exception e) {
            this.logger.debug("Exception in get and parse request :" + e);
            this.server.send(String.valueOf(400));
        }
    }

    private boolean isRestoreOrBackupStarted() {
        if (NotificationHelper.backUpStarted) {
            this.logger.debug("Backup running :" + NotificationHelper.backUpStarted);
            this.server.send(String.valueOf(600));
            return true;
        }
        if (NotificationHelper.restoreStarted) {
            this.logger.debug("Backup running :" + NotificationHelper.backUpStarted);
            this.server.send(String.valueOf(601));
            return true;
        }
        return false;
    }

    private void callBackup(JSONObject reqObject) {
        if (SettingHelper.getBackupLicenced().contentEquals(STR_TRUE) && SettingHelper.isLicenseActive()) {
            BackUpFolderDAOImpl backUpFolderDAOImpl;
            List listOfFolder;
            this.logger.debug("Received backup");
            NotificationHelper.setBackupStatus((int)1);
            if (STR_TRUE.equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                this.setBackupType(reqObject);
                this.setBackupContainerDetails(reqObject);
            }
            if ((listOfFolder = (backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl())).getAllFolderToBackUpFiles()).isEmpty()) {
                this.logger.error("No folders configued for backup exist");
                NotificationHelper.setBackupStatus((int)2);
            } else {
                ManualSyncHelper.startManualBackup();
            }
        }
    }

    private void callRestore(String request) {
        this.server.send(String.valueOf(200));
        this.logger.debug("status code sent successfully");
        Runnable runnable = () -> {
            JSONObject reqObject1 = null;
            try {
                reqObject1 = (JSONObject)this.parser.parse(request);
            }
            catch (ParseException e) {
                this.logger.debug("inside restore parse exception");
                this.server.send(String.valueOf(400));
            }
            try {
                if (STR_TRUE.equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                    this.setBackupContainerDetails(reqObject1);
                    NotificationHelper.setCurrentContainerName((String)NotificationHelper.getScheduledContainerNames());
                    this.logger.debug("container Name: " + NotificationHelper.getCurrentContainerName());
                }
                this.logger.debug("request before initiate req:" + reqObject1);
                this.initiateRestore(reqObject1);
            }
            catch (Exception e) {
                this.logger.debug("Exception inside run:" + e);
            }
        };
        new Thread(runnable).start();
    }

    private void listenerLocknotAcquired() {
        this.logger.debug("Unable to acquire listner lock");
        this.server.send(String.valueOf(425));
    }

    private void callRefreshPolicy() {
        this.logger.debug("Received Refresh policy");
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase(STR_TRUE) && STR_TRUE.equalsIgnoreCase(SettingHelper.getBackupLicenced())) {
            Runnable runnable = () -> {
                this.logger.debug("inside refresh policy thread");
                WindowsCheckBackupPolicy.checkGroupPolicy();
                BlusyncThreadHelper.resetBackupTimer();
            };
            new Thread(runnable).start();
        }
        this.logger.debug("sending http status code");
        this.server.send(String.valueOf(200));
    }

    private Actions getActValFrmAction(String action, Actions a) {
        Actions act = a;
        try {
            act = Actions.valueOf(action);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("inside action illegal argument exception:" + e.getMessage());
            this.logger.trace("" + e);
            act = Actions.OTHERS;
        }
        catch (IllegalStateException e) {
            this.logger.error("inside action illegal state exception:" + e.getMessage());
            this.logger.trace("" + e);
        }
        catch (Exception e) {
            this.logger.debug("Exception : " + e);
            this.server.send(String.valueOf(400));
        }
        return act;
    }

    private String getActionFrmJsonObj(JSONObject reqObject, String actn) {
        String action = actn;
        try {
            action = (String)reqObject.get((Object)"action");
        }
        catch (Exception e) {
            this.logger.error("inside action general exception>>>>>" + e.getMessage());
            this.logger.trace("" + e);
        }
        return action;
    }

    private JSONObject parseJsonString(String request, JSONObject req) {
        JSONObject reqObject = req;
        try {
            this.logger.debug("parsing the request>>>>");
            reqObject = (JSONObject)this.parser.parse(request);
        }
        catch (ParseException e) {
            this.logger.error("inside parse exception:" + e.getMessage());
            this.logger.trace("" + (Object)((Object)e));
            this.server.send(String.valueOf(400));
        }
        catch (Exception e) {
            this.logger.debug("Exception : " + e);
            this.server.send(String.valueOf(400));
            this.logger.debug("sent bad_request response");
        }
        return reqObject;
    }

    private void setBackupContainerDetails(JSONObject reqObject) {
        String containerName = (String)reqObject.get((Object)"containerName");
        NotificationHelper.setScheduledContainerNames((String)containerName);
    }

    private void setBackupType(JSONObject reqObject) {
        String type = (String)reqObject.get((Object)"type");
        if (type.equalsIgnoreCase(BACKUP_TYPE_FULL)) {
            NotificationHelper.setServerBackupType((String)"F");
        } else {
            NotificationHelper.setServerBackupType((String)"I");
        }
        this.logger.debug("Set tyoe ::::::::::::::::: " + NotificationHelper.getServerBackupType());
    }

    private void callForDeviceRestore(String deviceUid, String selectedPathForRestore, String allVersion) {
        this.logger.debug("inside call for device level restore");
        restoreElement = new RestoreElement();
        String status = BackupLifeCycle.STARTED.toString();
        batchId = this.restoreBatchInitiated(status, "", "0/0");
        RestoreActivityTO restoreActivityTo = new RestoreActivityTO();
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        Thread t = null;
        try {
            Runnable runnable = () -> this.createRestoreElementAndInitiateRestore(deviceUid, selectedPathForRestore, allVersion, status, restoreActivityTo, restoreActivityHistoryDAOImpl);
            t = new Thread(runnable);
        }
        catch (Exception e) {
            this.logger.error("Exceptoin in callForDeviceRestore thread" + e);
        }
        this.startThread(t);
        NotificationHelper.setRestoreStarted((boolean)false);
        NotificationHelper.restoreFinished = true;
        this.logger.debug("after thread starts restore status:" + NotificationHelper.isRestoreStarted());
        this.logger.debug("after thread starts restore finished status:" + NotificationHelper.restoreFinished);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRestoreElementAndInitiateRestore(String deviceUid, String selectedPathForRestore, String allVersion, String initialStatus, RestoreActivityTO restoreActivityTo, RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl) {
        try {
            this.logger.debug("selected path for restore:" + selectedPathForRestore);
            if (!batchId.equals("") && !"-1".equals(batchId)) {
                this.validatePreviousBatchStatus(restoreActivityHistoryDAOImpl);
                this.logger.debug("Inserting into restore table");
                restoreActivityTo.setRestoreBatchStatus(initialStatus);
                restoreActivityTo.setRestoreBatchId(batchId);
                restoreActivityHistoryDAOImpl.addEventToRestoreActivity(restoreActivityTo);
            }
            restoreElement.setFileUserOwner(SettingHelper.getUserName());
            restoreElement.setCloudName(SettingHelper.getCloudName());
            restoreElement.setRestoreBatchId(batchId);
            restoreElement.setDestinationPath(selectedPathForRestore);
            restoreElement.setDeviceUUid(deviceUid);
            restoreElement.setRestoreAllVersions(false);
            if (allVersion != null && allVersion.equalsIgnoreCase(STR_TRUE)) {
                restoreElement.setRestoreAllVersions(true);
            }
            this.getUploadIPForGateway();
            this.logger.debug("uploadIpForGateway  " + this.uploadIpForGateway);
            this.attemptRestore(restoreElement, this.uploadIpForGateway);
        }
        catch (Exception e) {
            NotificationHelper.successfulRestore = 0;
            this.logger.error("unsuccessfulRestore, Exception: ", (Throwable)e);
        }
        finally {
            if (NotificationHelper.successfulRestore == 1) {
                String restoreCount;
                String status = BackupLifeCycle.COMPLETED.toString();
                batchId = this.restoreBatchInitiated(status, batchId, restoreCount = restoreElement.getRestoreCount());
                if (batchId != null && batchId != "-1") {
                    restoreActivityTo.setRestoreBatchStatus(status);
                    restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                }
            } else {
                String restoreCount;
                String status = BackupLifeCycle.FAILED.toString();
                batchId = this.restoreBatchInitiated(status, batchId, restoreCount = restoreElement.getRestoreCount());
                if (batchId != null && batchId != "-1") {
                    restoreActivityTo.setRestoreBatchStatus(status);
                    restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                }
            }
        }
    }

    void initiateRestore(JSONObject reqObject) {
        try {
            this.logger.debug("request:" + reqObject);
            NotificationHelper.successfulRestore = 1;
            NotificationHelper.setRestoreStarted((boolean)true);
            NotificationHelper.restoreFinished = false;
            String isRestoreAllVersionsDevice = (String)reqObject.get((Object)"isRestoreAllVersions");
            this.logger.debug("restore all version for device restore:" + isRestoreAllVersionsDevice);
            String deviceUid = (String)reqObject.get((Object)"deviceUUID");
            VolumeShadowService volumeShadowService = new VolumeShadowService();
            String selectedPathForRestore = (String)reqObject.get((Object)"destinationPath");
            String isDeviceLevelRestore = (String)reqObject.get((Object)"isDeviceLevel");
            this.logger.debug("Device level restore:" + isDeviceLevelRestore);
            if (isDeviceLevelRestore != null && isDeviceLevelRestore.equalsIgnoreCase(STR_TRUE)) {
                this.callForDeviceRestore(deviceUid, selectedPathForRestore, isRestoreAllVersionsDevice);
            } else {
                this.logger.debug("insider folder or file level restore");
                JSONArray array = (JSONArray)reqObject.get((Object)"paths");
                for (int i = 0; i < array.size(); ++i) {
                    this.logger.debug("i  " + i);
                    JSONObject paths = (JSONObject)array.get(i);
                    RestoreActivityTO restoreActivityTo = new RestoreActivityTO();
                    RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
                    volumeShadowService.runScript("preRestoreF", true);
                    restoreElement = new RestoreElement();
                    Runnable runnable = () -> this.startRestoreThread(deviceUid, selectedPathForRestore, paths, restoreActivityTo, restoreActivityHistoryDAOImpl);
                    Thread t = new Thread(runnable);
                    this.startThread(t);
                    if (NotificationHelper.successfulRestore != 1 || !SettingHelper.getServerBackupLicensed().equalsIgnoreCase(STR_TRUE)) continue;
                    Map<String, String> env = this.getEnvironmentVariable(reqObject);
                    sourcePath = sourcePath.replace("/", "\\");
                    env.put("-myPath", sourcePath);
                    NotificationHelper.setCurrentPolicyName((String)VolumeShadowService.getPolicyForContainer(NotificationHelper.getCurrentContainerName()));
                    volumeShadowService.runScript("postRestoreF", true, env);
                }
            }
            this.logger.debug("getting status of restore.......");
            NotificationHelper.setRestoreStarted((boolean)false);
            NotificationHelper.restoreFinished = true;
            this.logger.debug("is restore started......" + NotificationHelper.isRestoreStarted());
        }
        catch (Exception e) {
            this.logger.debug("inside initiate restore catch");
            this.logger.debug("error message:" + e);
        }
    }

    private void startThread(Thread t) {
        try {
            t.start();
            t.join();
        }
        catch (Exception e) {
            this.logger.debug("" + e);
        }
    }

    private Map<String, String> getEnvironmentVariable(JSONObject reqObject) {
        HashMap<String, String> env = new HashMap<String, String>();
        JSONObject timeObj = (JSONObject)reqObject.get((Object)"options");
        this.logger.debug("timestamp ::: " + (String)timeObj.get((Object)"timestamp"));
        env.put("-timeStamp", (String)timeObj.get((Object)"timestamp"));
        return env;
    }

    void attemptRestore(RestoreElement restoreElement, String uploadIpForGateway) {
        try {
            if ((SettingHelper.getBackupLicenced().equalsIgnoreCase(STR_TRUE) || SettingHelper.getServerBackupLicensed().equalsIgnoreCase(STR_TRUE)) && SettingHelper.getIsExternalStorageSelected().equalsIgnoreCase(STR_TRUE)) {
                Integer portForParacloud = Integer.getInteger(SettingHelper.getHttpsPort());
                AtomicInteger skipValue = new AtomicInteger(0);
                int response1 = this.backupAdapter.downloadFileViaGateway1(uploadIpForGateway, portForParacloud, SettingHelper.readTokenFromFile(), SettingHelper.getCloudName(), restoreElement, skipValue, SettingHelper.getDeviceUUId(), SettingHelper.getKeystorePath());
                if (response1 == 204) {
                    NotificationHelper.successfulRestore = 5;
                    this.logger.debug("failed state of restore" + response1);
                }
                if (response1 != 4) {
                    NotificationHelper.successfulRestore = 0;
                }
            }
        }
        catch (Exception e) {
            NotificationHelper.successfulRestore = 0;
            this.logger.error("Unsuccessful Restore, Exception: ", (Throwable)e);
        }
    }

    private void getUploadIPForGateway() {
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase(STR_TRUE) || SettingHelper.getServerBackupLicensed().equalsIgnoreCase(STR_TRUE)) {
            try {
                GatewayTO uploadGatewayTo = PolicyManagementServerHelper.getPrivacyGatewayIP((String)BACKUP_TYPE_FULL, (String)"BACKUP");
                if (uploadGatewayTo != null) {
                    this.uploadIpForGateway = uploadGatewayTo.getGatewayName();
                }
            }
            catch (Exception e) {
                this.logger.debug("Error in get privacy gateway ip" + e);
            }
            this.logger.debug("Restore Privacy Gateway IP:" + this.uploadIpForGateway);
        }
    }

    private String restoreBatchInitiated(String batchStatus, String batchID, String restoreCount) {
        String btchId = batchID;
        Integer restoredCount = 0;
        String jobType = "RESTORE";
        try {
            BackupOrRestoreStatusTo backupOrRestoreStatusTo = new BackupOrRestoreStatusTo();
            backupOrRestoreStatusTo.setStatus(batchStatus);
            backupOrRestoreStatusTo.setIp(SettingHelper.getCurrentCloudIpAddress());
            backupOrRestoreStatusTo.setToken(SettingHelper.readTokenFromFile());
            backupOrRestoreStatusTo.setBatchId(batchId);
            backupOrRestoreStatusTo.setJobType(jobType);
            backupOrRestoreStatusTo.setDeviceName(SettingHelper.getDeviceName());
            backupOrRestoreStatusTo.setTotalCount(restoredCount.intValue());
            backupOrRestoreStatusTo.setErrorCode(909);
            backupOrRestoreStatusTo.setDeviceUUID(SettingHelper.getDeviceUUId());
            backupOrRestoreStatusTo.setTotalUploadSize(0L);
            backupOrRestoreStatusTo.setTotalUploadedCount(restoreCount);
            backupOrRestoreStatusTo.setCrawlCount(0);
            backupOrRestoreStatusTo.setCrawlTimeStamp("0");
            backupOrRestoreStatusTo.setFullBackup(false);
            backupOrRestoreStatusTo.setDiskSpaceDetails(new ParabluFileSystemUtils().getSystemSpace());
            backupOrRestoreStatusTo.setPolicyConfiguredFolders("");
            btchId = this.backupAdapter.sendEmailNotification(backupOrRestoreStatusTo);
        }
        catch (Exception e) {
            btchId = "-1";
            this.logger.debug(" Exception inside send email notification  " + e);
        }
        return btchId;
    }

    private void validatePreviousBatchStatus(RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl) {
        RestoreActivityTO activityTO = restoreActivityHistoryDAOImpl.getCurrentStatusFromRestoreActivityHistoryTable(true);
        if (activityTO != null && activityTO.getRestoreBatchStatus().equals(BackupLifeCycle.STARTED.toString())) {
            this.logger.debug("User exit the app or network connection failed. so failed status to be sent");
            activityTO.setRestoreBatchStatus(BackupLifeCycle.FAILED.toString());
            String currentBatchId = activityTO.getRestoreBatchId();
            this.logger.debug("Batchid is" + currentBatchId);
            restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(activityTO);
            this.restoreBatchInitiated(activityTO.getRestoreBatchStatus(), currentBatchId, "0/0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRestoreThread(String deviceUid, String selectedPathForRestore, JSONObject paths, RestoreActivityTO restoreActivityTo, RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl) {
        try {
            this.checkPathAndStartRestore(deviceUid, selectedPathForRestore, paths, restoreActivityTo, restoreActivityHistoryDAOImpl);
        }
        catch (Exception e1) {
            NotificationHelper.successfulRestore = 0;
            this.logger.error("unsuccessfulRestore, Exception e1: ", (Throwable)e1);
        }
        finally {
            if (NotificationHelper.successfulRestore == 1) {
                String restoreCount;
                String status = BackupLifeCycle.COMPLETED.toString();
                batchId = this.restoreBatchInitiated(status, batchId, restoreCount = restoreElement.getRestoreCount());
                if (batchId != null && batchId != "-1") {
                    restoreActivityTo.setRestoreBatchStatus(status);
                    restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                }
            } else {
                int count = 0;
                String status = BackupLifeCycle.FAILED.toString();
                String restoreCount = restoreElement.getRestoreCount();
                if (restoreCount != null) {
                    count += Integer.parseInt(restoreCount.trim());
                }
                this.logger.debug("calculating no of files restored:" + count);
                batchId = this.restoreBatchInitiated(status, batchId, restoreCount);
                if (batchId != null && batchId != "-1") {
                    restoreActivityTo.setRestoreBatchStatus(status);
                    restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                }
            }
        }
    }

    private void checkPathAndStartRestore(String deviceUid, String selectedPathForRestore, JSONObject paths, RestoreActivityTO restoreActivityTo, RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl) {
        String isFolder = (String)paths.get((Object)"isFolder");
        String devicePath = (String)paths.get((Object)"path");
        String revisionId = (String)paths.get((Object)"backupId");
        String fileName = (String)paths.get((Object)"name");
        String isRestoreAllVersions = (String)paths.get((Object)"isRestoreAllVersions");
        String version = (String)paths.get((Object)"version");
        this.logger.debug("selected file version" + version);
        this.logger.debug("restore all Version:" + isRestoreAllVersions);
        String destinationPath = selectedPathForRestore;
        if (isFolder.equalsIgnoreCase(STR_TRUE)) {
            this.logger.debug("folder level restore");
            if (selectedPathForRestore != null && !selectedPathForRestore.isEmpty()) {
                if (devicePath.contains("/")) {
                    destinationPath = SettingHelper.getServerBackupLicensed().equalsIgnoreCase(STR_TRUE) ? selectedPathForRestore.concat("\\").concat(NotificationHelper.getCurrentContainerName()).concat(devicePath.substring(devicePath.lastIndexOf(47), devicePath.length())) : selectedPathForRestore.concat(devicePath.substring(devicePath.lastIndexOf(47), devicePath.length()));
                    this.logger.debug("device path:" + devicePath);
                } else {
                    destinationPath = selectedPathForRestore.concat("\\" + devicePath.replace(":", "_drive"));
                }
            }
        } else {
            if (version == null || "0".equalsIgnoreCase(version)) {
                fileName = devicePath.substring(devicePath.lastIndexOf(47) + 1);
            } else {
                String name = fileName.substring(0, fileName.lastIndexOf(46));
                name = name.concat("(version-" + version + ")");
                String extension = fileName.substring(fileName.indexOf(46), fileName.length());
                fileName = name.concat(extension);
            }
            this.logger.debug("fileName:" + fileName);
            devicePath = devicePath.substring(0, devicePath.lastIndexOf(47));
            restoreElement.setFileName(fileName);
            if (revisionId != null) {
                restoreElement.setFileBackupId(revisionId);
            }
        }
        String userName = (String)paths.get((Object)"userName");
        String status = BackupLifeCycle.STARTED.toString();
        batchId = this.restoreBatchInitiated(status, "", "0/0");
        if (!"".equals(batchId) && !"-1".equals(batchId)) {
            this.validatePreviousBatchStatus(restoreActivityHistoryDAOImpl);
            restoreActivityTo.setRestoreBatchStatus(status);
            restoreActivityTo.setRestoreBatchId(batchId);
            restoreActivityHistoryDAOImpl.addEventToRestoreActivity(restoreActivityTo);
        }
        sourcePath = destinationPath != null ? destinationPath.concat("\\") : devicePath.replace("/", "\\");
        this.logger.debug("sourcePath  >>>>> >>>> " + sourcePath);
        restoreElement.setDevicePath(devicePath);
        restoreElement.setFileUserOwner(userName);
        restoreElement.setCloudName(SettingHelper.getCloudName());
        restoreElement.setRestoreBatchId(batchId);
        restoreElement.setDestinationPath(destinationPath);
        restoreElement.setDeviceUUid(deviceUid);
        restoreElement.setRestoreAllVersions(false);
        if (isRestoreAllVersions != null && isRestoreAllVersions.equalsIgnoreCase(STR_TRUE)) {
            this.logger.debug("setting the all versions to true");
            restoreElement.setRestoreAllVersions(true);
        }
        this.getUploadIPForGateway();
        this.attemptRestore(restoreElement, this.uploadIpForGateway);
    }

    private int sendDecoupleRequest() {
        int response = 0;
        try {
            response = this.backupAdapter.getDecoupleResponse(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), SettingHelper.readTokenFromFile());
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception" + e.getMessage());
        }
        return response;
    }

    static {
        batchId = "";
        restoreElement = null;
    }

    static enum Actions {
        BACKUP,
        RESTORE,
        REFRESHPOLICY,
        STOPBACKUP,
        ISRESTORERUNNING,
        EXIT,
        OTHERS,
        DECOUPLE;

    }
}

