/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.pcb;

import com.parablu.epa.core.adapter.BaseAdapter;
import com.parablu.epa.core.element.CloudInfoElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.CloudStorageTO;
import com.parablu.epa.core.to.ResponseTO;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudAdapter
extends BaseAdapter {
    private static final String PARACLOUD_USAGE_STATS = "/files/root";
    private static final String PARACLOUD_CONSOLIDATED_REGISTERURL = "/register/device";
    private static final String PARACLOUD_AUTHENTICATION_TOKEN = "/auth/gen";
    private static final String PARACLOUD_CERT_AUTHENTICATION = "/validateCertificate/";
    private static final String PARACLOUD_USER_EXIT = "/user/exit";
    private static final String CLIENT_PROTOCOL_EXCEPTION = "ClientProtocol Exception ";
    private static final String IO_EXCEPTION = "IOException Exception ";
    private static final String EXCEPTION = "Exception ";
    private HttpResponse response = null;
    private HttpGet httpGet = null;
    private HttpPost httpPost = null;
    private static final String PARACLOUD_BASE_VERSION_NUMBER = "/versions/";
    private String versionNumber = "2.4";
    private static final Logger logger = LoggerFactory.getLogger(CloudAdapter.class);

    public CloudAdapter(String cloudName, String keyStorePath) {
        super(cloudName, keyStorePath);
    }

    public CloudAdapter(InputStream inputStream, String cloudName) {
        super(inputStream, cloudName);
    }

    public String[] getAuthenticationToken(String ip, Integer port, String token, String userName) {
        this.response = null;
        String resToken = null;
        String cloudNameFromResponse = null;
        String[] resArray = null;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_AUTHENTICATION_TOKEN) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_AUTHENTICATION_TOKEN);
            logger.trace(uri.toString());
            this.httpGet = new HttpGet(uri);
            this.httpGet.setHeader("userName", userName);
            this.httpGet.setHeader("token", token);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpGet);
            int responseCode = this.response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                resArray = new String[2];
                Header responseToken = this.response.getFirstHeader("token");
                Header responseCloudName = this.response.getFirstHeader("cloudName");
                resToken = responseToken.getValue();
                cloudNameFromResponse = responseCloudName.getValue();
                resArray[0] = resToken;
                resArray[1] = cloudNameFromResponse;
            }
            logger.trace("Response code is " + responseCode);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e);
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        finally {
            this.closeResponseEntity();
        }
        return resArray;
    }

    public ResponseTO registerDevice(String ip, Integer port, String requestXml, String userName, String passwordHash, String deviceAlreadyRegistered, String encPwd, String productVersion, String forceRegCheck) {
        String responseString = null;
        int responseCode = 0;
        this.response = null;
        HttpPost httppost = null;
        ByteArrayEntity httpEntity = null;
        ResponseTO responseTO = null;
        String token = null;
        String syncEnabled = null;
        String serverBackupEnabled = null;
        String backupEnabled = null;
        String ldapEnabled = null;
        String restoreEnabled = null;
        String cloudName = null;
        String isExternalStorageSelected = null;
        String uiVersion = "1";
        String aadEndPointRedirectUri = "";
        String aadClientId = "";
        String aadTenantName = "";
        String loginMode = "";
        String accessToken = "";
        String userConsent = "false";
        try {
            URI uri = port != null ? this.formHttpsUri(ip, "/paracloud/versions/" + this.versionNumber + "/cloud" + this.cloudName + PARACLOUD_CONSOLIDATED_REGISTERURL) : this.formHttpsUri(ip, "/paracloud/versions/" + this.versionNumber + "/cloud" + this.cloudName + PARACLOUD_CONSOLIDATED_REGISTERURL);
            logger.debug(uri.toString());
            httppost = new HttpPost(uri);
            httppost.setHeader("Content-Type", "application/xml");
            httppost.setHeader("userName", userName);
            logger.debug("user name:" + userName);
            logger.debug(deviceAlreadyRegistered);
            httppost.setHeader("password", passwordHash);
            httppost.setHeader("firstRegistration", deviceAlreadyRegistered);
            httppost.setHeader("checkForMultipleUserandDevice", forceRegCheck);
            httppost.setHeader("encPwd", encPwd);
            httppost.setHeader("aadAuthCode", StringUtils.isEmpty((String)ParabluFileSystemUtils.getAADAuthCode()) ? "" : ParabluFileSystemUtils.getAADAuthCode());
            httppost.setHeader("aadAccessToken", StringUtils.isEmpty((String)ParabluFileSystemUtils.getAADAccessToken()) ? "" : ParabluFileSystemUtils.getAADAccessToken());
            logger.debug("Product version....." + productVersion);
            logger.debug("access token....." + ParabluFileSystemUtils.getAADAccessToken());
            httppost.setHeader("productVersion", productVersion);
            httppost.setHeader("macAddress", this.getMacAddress());
            httpEntity = new ByteArrayEntity(requestXml.getBytes("UTF-8"));
            httppost.setEntity((HttpEntity)httpEntity);
            this.response = this.httpclient.execute((HttpUriRequest)httppost);
            if (this.response == null) {
                logger.error("Resonse for registration is null");
                throw new CrawlAdapterException("Response is null");
            }
            responseCode = this.response.getStatusLine().getStatusCode();
            if (responseCode == 400 || responseCode == 404) {
                logger.error("URL not found");
                throw new CrawlAdapterException("Response is null");
            }
            logger.debug("response code is " + responseCode);
            if (responseCode == 201) {
                HttpEntity responseEntity = this.response.getEntity();
                if (responseEntity != null) {
                    responseString = EntityUtils.toString((HttpEntity)responseEntity);
                }
                token = this.response.getFirstHeader("token").getValue();
                syncEnabled = this.response.getFirstHeader("sync-enabled").getValue();
                backupEnabled = this.response.getFirstHeader("backup-enabled").getValue();
                ldapEnabled = this.response.getFirstHeader("isLdapEnabled").getValue();
                restoreEnabled = this.response.getFirstHeader("restore-enabled").getValue();
                serverBackupEnabled = this.response.getFirstHeader("serverBackup-enabled").getValue();
                cloudName = this.response.getFirstHeader("cloudName").getValue();
                isExternalStorageSelected = this.response.getFirstHeader("isExternalStorageSelected").getValue();
                uiVersion = this.response.getFirstHeader("uiVersion").getValue();
                userConsent = this.response.getFirstHeader("user-consent-given").getValue();
                if ("true".equalsIgnoreCase(serverBackupEnabled)) {
                    backupEnabled = "true";
                }
            }
            for (Header header : this.response.getAllHeaders()) {
                logger.debug(header.getName() + ":" + header.getValue());
            }
            if (responseCode == 444) {
                aadClientId = this.getHeaderValue("clientId");
                aadEndPointRedirectUri = this.getHeaderValue("endpointRedirectURI");
                aadTenantName = this.getHeaderValue("tenantName");
                loginMode = this.getHeaderValue("loginMode");
                logger.debug("AAD client id:" + aadClientId);
            }
            if (responseCode == 431 || responseCode == 432 || responseCode == 433) {
                accessToken = this.getHeaderValue("access-token");
            }
            responseTO = new ResponseTO();
            responseTO.setResponseCode(responseCode);
            responseTO.setResponse(responseString);
            responseTO.setToken(token);
            responseTO.setSyncEnabled(syncEnabled);
            responseTO.setBackupEnabled(backupEnabled);
            responseTO.setServerBackupEnabled(serverBackupEnabled);
            responseTO.setIsLDAPEnabled("true");
            responseTO.setRestoreEnabled(restoreEnabled);
            responseTO.setCloudName(cloudName);
            responseTO.setUiVersion(Integer.valueOf(uiVersion));
            responseTO.setClientId(aadClientId);
            responseTO.setEndPointRedirectUri(aadEndPointRedirectUri);
            responseTO.setTenantName(aadTenantName);
            responseTO.setLoginMode(loginMode);
            responseTO.setAccessToken(accessToken);
            responseTO.setIsExternalStorageSelected(isExternalStorageSelected);
            responseTO.setUserConsentGiven(Boolean.valueOf(userConsent));
            logger.debug("User Conset Given: " + responseTO.isUserConsentGiven());
            logger.debug("Sync Enabled is: " + syncEnabled);
            logger.debug("Backup Enabled is: " + backupEnabled);
            logger.debug("Server Backup Enabled is: " + serverBackupEnabled);
            logger.debug("Ldap Enabled is: " + ldapEnabled);
            logger.debug("Restore Enabled is: " + restoreEnabled);
            logger.debug("Cloud Name is:" + cloudName);
            logger.debug("External Storage Selected:" + isExternalStorageSelected);
            logger.debug("AAD client id:" + aadClientId);
            logger.debug("AAD login mod:" + loginMode);
            logger.debug("AAD access token:" + accessToken);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e);
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        finally {
            this.closeResponseEntity();
        }
        return responseTO;
    }

    private String getHeaderValue(String key) {
        if (this.response.getFirstHeader(key) != null && StringUtils.isNotEmpty((String)this.response.getFirstHeader(key).getValue())) {
            return this.response.getFirstHeader(key).getValue();
        }
        return "";
    }

    private String getMacAddress() {
        String macAddr = "";
        String ipAddr = "";
        try {
            InetAddress ip = InetAddress.getLocalHost();
            ipAddr = ip.getHostAddress();
            logger.debug("Current IP address : " + ipAddr);
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            logger.debug("MAc address:" + sb.toString());
            sb.append("_").append(ipAddr);
            macAddr = sb.toString();
            logger.debug("MAc address with ip addr:" + macAddr);
        }
        catch (UnknownHostException e) {
            logger.error("UnknownHostException creating mac address0,", (Throwable)e);
        }
        catch (SocketException e) {
            logger.error("SocketException creating mac address0,", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("UnknownException creating mac address0,", (Throwable)e);
        }
        return macAddr;
    }

    private void closeResponseEntity() {
        if (this.response != null && this.response.getEntity().isStreaming()) {
            try {
                this.response.getEntity().getContent().close();
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error(e.getMessage());
            }
        }
    }

    public CloudStorageTO getCloudStorageInfo(String ip, Integer port) throws CrawlAdapterException {
        logger.trace("ParacloudAdapter.getCloudStorageInformation");
        String responseXmlAsString = null;
        CloudStorageTO cloudStorage = new CloudStorageTO();
        try {
            HttpEntity responseEntity;
            URI uri = port != null ? this.formHttpsUri(ip, port, this.cloudName + PARACLOUD_USAGE_STATS) : this.formHttpsUri(ip, this.cloudName + PARACLOUD_USAGE_STATS);
            logger.trace(uri.toString());
            this.httpGet = new HttpGet(uri);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpGet);
            int responseCode = this.response.getStatusLine().getStatusCode();
            if (responseCode == 200 && (responseEntity = this.response.getEntity()) != null) {
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                logger.trace(responseXmlAsString);
                CloudInfoElement cloudElement = Xmlparser.parseCloudInformation(responseXmlAsString);
                cloudStorage = ObjectUtils.converToCloudStorage(cloudElement);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            throw new CrawlAdapterException("Exception ::", ex);
        }
        finally {
            this.closeResponseEntity();
        }
        return cloudStorage;
    }

    public String validateDeviceCertAuthentication(String ip, Integer port, byte[] keyBytes) {
        String responseString = null;
        this.response = null;
        ByteArrayEntity httpEntity = null;
        String certAuth = "false";
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_CERT_AUTHENTICATION) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_CERT_AUTHENTICATION);
            logger.debug(uri.toString());
            this.httpPost = new HttpPost(uri);
            httpEntity = new ByteArrayEntity(keyBytes);
            this.httpPost.setEntity((HttpEntity)httpEntity);
            this.httpPost.setHeader("Content-type", "application/octet-stream");
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPost);
            int responseCode = this.response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                Header responseToken = this.response.getFirstHeader("certAuth");
                certAuth = responseToken.getValue();
            }
            logger.debug("Is DEVICE VALID: " + certAuth);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e);
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        finally {
            logger.debug(responseString);
            this.closeResponseEntity();
        }
        return certAuth;
    }

    public int notifyUserExit(String ip, Integer port, String userName, String deviceName) {
        String responseString = null;
        this.response = null;
        int responseCode = 0;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_USER_EXIT) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_USER_EXIT);
            logger.debug(uri.toString());
            this.httpGet = new HttpGet(uri);
            this.httpGet.setHeader("userName", userName);
            this.httpGet.setHeader("deviceName", deviceName);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpGet);
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug("Exit response code is " + responseCode);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e);
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        finally {
            logger.debug(responseString);
            this.closeResponseEntity();
        }
        return responseCode;
    }

    public int checkNetworkConnetivity(String ip) {
        int responseValue = 0;
        URI uri = this.formHttpsUri(ip, "");
        HttpGet httpGet = new HttpGet(uri.toString());
        try {
            logger.debug("the uri to cehck connectivity is:" + uri);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + e.getMessage());
            logger.trace("" + (Object)((Object)e));
            this.closeResponseEntity();
            return responseValue;
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            return responseValue;
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e.getMessage());
            logger.trace("" + e);
            this.closeResponseEntity();
            return responseValue;
        }
        responseValue = this.response.getStatusLine().getStatusCode();
        logger.debug("The ping response for paracloud is:" + responseValue);
        this.closeResponseEntity();
        return responseValue;
    }

    public HttpGet getHttpGet() {
        return this.httpGet;
    }

    public void cancelHttpget() {
        if (this.httpGet != null) {
            this.httpGet.abort();
            this.httpGet = null;
        }
    }
}

