/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.dao.FullBackupInfoTableDAOImpl;
import com.parablu.epa.common.dao.SyncPolicyDAOImpl;
import com.parablu.epa.common.service.backup.FilesBeSkippedAsPerPolicy;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.BackupHelper;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.CheckBackupPolicy;
import com.parablu.epa.common.service.settings.HashChecker;
import com.parablu.epa.common.service.settings.InterfaceManagementService;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.settings.WinDrives;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.adapter.pcb.SyncAdapter;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BkPolicyExcludedFolderListElement;
import com.parablu.epa.core.element.BkPolicyFolderPathElement;
import com.parablu.epa.core.element.BluVaultMappingElement;
import com.parablu.epa.core.element.BluVaultMappingListElement;
import com.parablu.epa.core.element.DayArray;
import com.parablu.epa.core.element.DeviceContainerElement;
import com.parablu.epa.core.element.EndpointUIPreferencesElement;
import com.parablu.epa.core.element.EndpointUiDisabledPreferencesElement;
import com.parablu.epa.core.element.ExceptionsToExclusionElement;
import com.parablu.epa.core.element.ExceptionsToExclusionsFolderPathElement;
import com.parablu.epa.core.element.ExcludedFolderPathElement;
import com.parablu.epa.core.element.FolderPathElement;
import com.parablu.epa.core.element.GatewayElement;
import com.parablu.epa.core.element.GatewayNameElement;
import com.parablu.epa.core.element.GroupPolicyElement;
import com.parablu.epa.core.element.GroupPolicyElementList;
import com.parablu.epa.core.element.InclusionFilterElement;
import com.parablu.epa.core.element.Schedule;
import com.parablu.epa.core.element.ScheduleElement;
import com.parablu.epa.core.element.SyncPolicyElement;
import com.parablu.epa.core.element.Throttling;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupOrRestoreStatusTo;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BluVaultTO;
import com.parablu.epa.core.to.ContainerBackupStatusTo;
import com.parablu.epa.core.to.ContainerDetailsTo;
import com.parablu.epa.core.to.DeviceTo;
import com.parablu.epa.core.to.FullBackupInfoTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.InclusionTO;
import com.parablu.epa.core.to.NWThrottlingTO;
import com.parablu.epa.core.to.ScheduleTO;
import com.parablu.epa.core.to.ShareDetailsTo;
import com.parablu.epa.core.to.SyncPolicyTo;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyManagementServerHelper {
    private static String cloudName = SettingHelper.getCloudName();
    private static String keyStorePath = SettingHelper.getKeystorePath();
    public static BackupAdapter backUpAdapter = new BackupAdapter(cloudName, keyStorePath);
    private static BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
    private static BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
    private static SyncPolicyDAOImpl syncPolicyDAOImpl = new SyncPolicyDAOImpl(SettingHelper.getSyncdburl());
    private static Logger logger = LoggerFactory.getLogger(PolicyManagementServerHelper.class);
    static int policyRefreshIntervalInHrs = -1;
    static int statisticsRefreshIntervalInHrs = -1;
    private static Set<String> rootFilesList;
    private static final String USERHOME_CONTAINS = "{user.home}";
    public static SyncAdapter syncAdapter;
    private static FullBackupInfoTableDAOImpl fullBackupInfoTableDAOImpl;
    static BackupPolicyTO currentPolicy;

    private PolicyManagementServerHelper() {
    }

    public static GatewayTO getPrivacyGatewayIP(String backupType, String action) {
        GatewayTO selectedPg = null;
        switch (action.toUpperCase()) {
            case "BACKUP": {
                selectedPg = PolicyManagementServerHelper.getBackupPrivacyGateway(backupType);
                break;
            }
            case "RESTORE": {
                selectedPg = PolicyManagementServerHelper.getRestorePrivacyGateway(backupType);
                break;
            }
            case "SYNC": {
                selectedPg = PolicyManagementServerHelper.getSyncPrivacyGateway(backupType);
                break;
            }
            default: {
                logger.debug("Unexpected Input");
            }
        }
        return selectedPg;
    }

    private static GatewayTO getSyncPrivacyGateway(String backupType) {
        logger.debug("Inside product type sync");
        List<GatewayTO> gatewayList = null;
        SyncPolicyTo syncPolicyTo = PolicyManagementServerHelper.getCurrentSyncPolicy();
        if (syncPolicyTo != null) {
            String policyName = syncPolicyTo.getPolicyGroupName();
            gatewayList = HashChecker.getGatewayList(policyName);
        }
        GatewayTO selectedPg = PolicyManagementServerHelper.getNearestPrivacyGatewaySync(backupType, gatewayList);
        return selectedPg;
    }

    private static GatewayTO getRestorePrivacyGateway(String backupType) {
        logger.debug("Inside product type restore");
        BackupPolicyTO backupPolicyTO = PolicyManagementServerHelper.getCurrentBackupPolicy();
        String policyName = backupPolicyTO.getPolicyGroupName();
        List<GatewayTO> gatewayList = HashChecker.getGatewayList(policyName);
        GatewayTO selectedPg = PolicyManagementServerHelper.getNearestPrivacyGatewaySync(backupType, gatewayList);
        return selectedPg;
    }

    private static GatewayTO getBackupPrivacyGateway(String backupType) {
        logger.debug("Inside product type backup");
        BackupPolicyTO backupPolicyTO = PolicyManagementServerHelper.getCurrentBackupPolicy();
        String policyName = backupPolicyTO.getPolicyGroupName();
        String pgSelectionAlgo = backupPolicyTO.getBlukryptSelectionAlgorithm();
        List<GatewayTO> gatewayList = HashChecker.getGatewayList(policyName);
        GatewayTO selectedPg = StringUtils.isEmpty((String)pgSelectionAlgo) || "NEAREST".equalsIgnoreCase(pgSelectionAlgo) ? PolicyManagementServerHelper.getNearestPrivacyGateway(backupType, gatewayList) : PolicyManagementServerHelper.getPrioritisedPrivacyGateway(backupType, gatewayList);
        return selectedPg;
    }

    private static GatewayTO getNearestPrivacyGateway(String backupType, List<GatewayTO> recivedGatewayList) {
        List<GatewayTO> gatewayList = recivedGatewayList;
        if (gatewayList == null || gatewayList.isEmpty()) {
            gatewayList = HashChecker.getGatewayList(null);
        }
        ArrayList<GatewayTO> removeGatewayList = new ArrayList<GatewayTO>();
        if (gatewayList != null && !gatewayList.isEmpty()) {
            for (GatewayTO gatewayTO : gatewayList) {
                if (!gatewayTO.getGatewayName().startsWith("localhost")) continue;
                logger.debug("inside localhost skipping others : " + gatewayTO.getGatewayName());
                return gatewayTO;
            }
        }
        for (GatewayTO gatewayTO : gatewayList) {
            int response;
            logger.debug("Gateway is  :" + gatewayTO.getGatewayName());
            long beforeTime = System.currentTimeMillis();
            try {
                response = backUpAdapter.pingGatewayIP(gatewayTO.getGatewayName(), SettingHelper.getDeviceUUId());
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Error in ping Nearest privacy gateway1" + e.getMessage());
                removeGatewayList.add(gatewayTO);
                continue;
            }
            if (response == 200) {
                long totalHitTime = System.currentTimeMillis() - beforeTime;
                gatewayTO.setHitTime(totalHitTime);
                backUpFolderDAOImpl.updateHitTime(gatewayTO);
                continue;
            }
            logger.error("Error in ping Nearest privacy gateway2");
            removeGatewayList.add(gatewayTO);
        }
        for (GatewayTO gatewayTO : removeGatewayList) {
            gatewayList.remove(gatewayTO);
        }
        List<GatewayTO> sortedPGs = PolicyManagementServerHelper.getPGTypeAndOrder(backupType, gatewayList);
        logger.debug("GATEWAY SIZE AFTER PING : " + sortedPGs.size());
        if (!sortedPGs.isEmpty()) {
            for (GatewayTO gatewayTO : sortedPGs) {
                logger.debug("SORTED PG before sorting" + gatewayTO.getGatewayName());
            }
            sortedPGs.stream().sorted(Comparator.comparing(GatewayTO::getHitTime));
            for (GatewayTO gatewayTO : sortedPGs) {
                logger.debug("\nSORTED PG after sorting" + gatewayTO.getGatewayName());
            }
        }
        PolicyManagementServerHelper.addOtherPossibilities(backupType, gatewayList, sortedPGs);
        for (GatewayTO gatewayTO : sortedPGs) {
            logger.debug("\nSORTED PG after adding other possibilities" + gatewayTO.getGatewayName());
        }
        if (sortedPGs.isEmpty()) {
            return null;
        }
        return PolicyManagementServerHelper.getElegibleGateway(sortedPGs);
    }

    private static GatewayTO getNearestPrivacyGatewaySync(String backupType, List<GatewayTO> recivedGatewayList) {
        List<GatewayTO> gatewayList = recivedGatewayList;
        if (gatewayList == null || gatewayList.isEmpty()) {
            gatewayList = HashChecker.getGatewayList(null);
        }
        ArrayList<Long> minimumTime = new ArrayList<Long>();
        ArrayList<GatewayTO> removeGatewayList = new ArrayList<GatewayTO>();
        for (GatewayTO gatewayTO : gatewayList) {
            int response;
            logger.debug("Gateway is:" + gatewayTO.getGatewayName());
            long beforeTime = System.currentTimeMillis();
            try {
                response = backUpAdapter.pingGatewayIP(gatewayTO.getGatewayName(), SettingHelper.getDeviceUUId());
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Error in ping Nearest privacy gateway" + e.getMessage());
                removeGatewayList.add(gatewayTO);
                continue;
            }
            if (response == 200) {
                long totalHitTime = System.currentTimeMillis() - beforeTime;
                gatewayTO.setHitTime(totalHitTime);
                minimumTime.add(totalHitTime);
                backUpFolderDAOImpl.updateHitTime(gatewayTO);
                continue;
            }
            logger.error("Error in ping Nearest privacy gateway2");
            removeGatewayList.add(gatewayTO);
        }
        for (GatewayTO gatewayTO : removeGatewayList) {
            gatewayList.remove(gatewayTO);
        }
        for (GatewayTO gatewayTO : gatewayList) {
            logger.debug("SORTED PG " + gatewayTO.getGatewayName());
        }
        PolicyManagementServerHelper.sortOutMinimumTime(minimumTime, gatewayList);
        logger.debug("GATEWAY SIZE AFTER PING : " + gatewayList.size());
        Collections.sort(minimumTime);
        Random r = new Random();
        int random = r.nextInt(1000);
        if (!gatewayList.isEmpty()) {
            random %= gatewayList.size();
        }
        for (int i = 0; i < gatewayList.size(); ++i) {
            if (gatewayList.get(random).getHitTime() == ((Long)minimumTime.get(0)).longValue()) {
                GatewayTO uploadGatewayTo = gatewayList.get(random);
                logger.debug("MINIMUM TIME FOR PRIVACY GATEWAY IS : " + uploadGatewayTo.getHitTime() + "GATEWAY NAME IS : " + uploadGatewayTo.getGatewayName() + "RANDOM NO : " + random);
                return uploadGatewayTo;
            }
            random = (random + 1) % gatewayList.size();
        }
        return null;
    }

    private static void sortOutMinimumTime(List<Long> minimumTime, List<GatewayTO> sortedPGs) {
        minimumTime.clear();
        for (GatewayTO gatewayTO : sortedPGs) {
            minimumTime.add(gatewayTO.getHitTime());
        }
    }

    private static GatewayTO getElegibleGateway(List<GatewayTO> gatewayList) {
        for (GatewayTO gatewayTO : gatewayList) {
            int response;
            logger.debug("Gateway in select available gateway:" + gatewayTO.getGatewayName());
            try {
                response = backUpAdapter.isGatewayAvailable(gatewayTO, SettingHelper.getDeviceUUId());
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Error in select available  privacy gateway" + e.getMessage());
                continue;
            }
            if (response != 200) continue;
            logger.debug("The eligible gateway is :" + gatewayTO.getGatewayName());
            return gatewayTO;
        }
        return null;
    }

    private static List<GatewayTO> getPGTypeAndOrder(String backupType, List<GatewayTO> gatewayList) {
        ArrayList<GatewayTO> sortedGatewayList = new ArrayList<GatewayTO>();
        for (GatewayTO gatewayTO : gatewayList) {
            if (gatewayTO.getType() == null || !gatewayTO.getType().equalsIgnoreCase(backupType)) continue;
            sortedGatewayList.add(gatewayTO);
        }
        return sortedGatewayList;
    }

    private static void addOtherPossibilities(String backupType, List<GatewayTO> gatewayList, List<GatewayTO> sortedPGs) {
        for (GatewayTO gatewayTO : gatewayList) {
            if (gatewayTO.getType() == null || !"BOTH".equalsIgnoreCase(gatewayTO.getType())) continue;
            sortedPGs.add(gatewayTO);
        }
        for (GatewayTO gatewayTO : gatewayList) {
            if (gatewayTO.getType() == null || "BOTH".equalsIgnoreCase(gatewayTO.getType()) || gatewayTO.getType().equalsIgnoreCase(backupType)) continue;
            sortedPGs.add(gatewayTO);
        }
        if (sortedPGs.isEmpty()) {
            sortedPGs.addAll(gatewayList);
        }
    }

    public static void loadBackupPolicyElement(String deviceName) {
        block9: {
            if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                try {
                    List deviceContainerElements = backUpAdapter.getContainerDetails(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName()).getDeviceContainerElement();
                    PolicyManagementServerHelper.createContainerDetalis(backupPolicyDAOImpl, deviceContainerElements);
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error("error in loading the backup policy elements" + e.getMessage());
                }
            }
            BackupPolicyTO backupPolicyTo = new BackupPolicyTO();
            try {
                logger.debug("Getting GROUP POLICY ELEMENT#######################");
                GroupPolicyElementList groupPolicyElementList = backUpAdapter.getGroupPolicyElement(SettingHelper.getCurrentCloudIpAddress(), deviceName, SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
                if (groupPolicyElementList == null || groupPolicyElementList.getGroupPolicyElement().isEmpty()) break block9;
                try {
                    for (GroupPolicyElement groupPolicyElement : groupPolicyElementList.getGroupPolicyElement()) {
                        if (groupPolicyElement.getStatus() == 416) {
                            SettingHelper.setLicenseActive(false);
                            continue;
                        }
                        SettingHelper.setLicenseActive(true);
                        PolicyManagementServerHelper.createGroupPolicyAndChildDetails(backupPolicyDAOImpl, backupPolicyTo, groupPolicyElementList);
                    }
                }
                catch (Exception e) {
                    logger.error("Error in create group  policy:" + e);
                }
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("error in getting the group policy elements" + e.getMessage());
            }
        }
    }

    public static void createGroupPolicyAndChildDetails(BackupPolicyDAOImpl backupPolicyDAOImpl, BackupPolicyTO backupPolicyTo, GroupPolicyElementList groupPolicyElementList) {
        if (!groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
            backupPolicyDAOImpl.deleteGroupPolicyAndChildDetails();
            ArrayList<String> policyStoredToDb = new ArrayList<String>();
            for (GroupPolicyElement groupPolicyElement : groupPolicyElementList.getGroupPolicyElement()) {
                Object throttlings2;
                if (policyStoredToDb.contains(groupPolicyElement.getPolicygroupName())) continue;
                List listFolderPathElement = groupPolicyElement.getFolderPathElement();
                List excludedFolderListElement = groupPolicyElement.getExcludedFolderPathElement();
                List exceptionsToExclusions = groupPolicyElement.getExceptionalInclusions();
                try {
                    backupPolicyTo.setPolicyGroupName(groupPolicyElement.getPolicygroupName());
                    backupPolicyTo.setMaxFileSize(groupPolicyElement.getMaxFileSize());
                    backupPolicyTo.setMaxVersions(groupPolicyElement.getMaxVersions());
                    backupPolicyTo.setOsType(groupPolicyElement.getOsType());
                    backupPolicyTo.setLastModifiedTime(groupPolicyElement.getLastModifiedTime());
                    backupPolicyTo.setPftEnabled(groupPolicyElement.getPftEnabled());
                    backupPolicyTo.setPftSize(groupPolicyElement.getPftSize());
                    backupPolicyTo.setCpuUtilization(groupPolicyElement.getCpuUtilization());
                    backupPolicyTo.setPolicyRefreshInterval(PolicyManagementServerHelper.changeTimeToMin(groupPolicyElement.getPolicyRefreshInterval()));
                    backupPolicyTo.setStatisticsRefreshInterval(PolicyManagementServerHelper.changeTimeToMin(groupPolicyElement.getStatisticsRefreshInterval()));
                    backupPolicyTo.setCrawlLimit(groupPolicyElement.getCrawlLimit());
                    backupPolicyTo.setIsStatisticsCollectorEnabled(groupPolicyElement.getIsStatisticsEnabled());
                    backupPolicyTo.setLegalHoldEnabled(groupPolicyElement.getLegalHoldEnabled());
                    backupPolicyTo.setBackupSystemFilesEnabled(groupPolicyElement.getBackupSystemFilesEnabled());
                    backupPolicyTo.setChunkSize(groupPolicyElement.getChunkSize());
                    backupPolicyTo.setVssEnabled(groupPolicyElement.getVssEnabled());
                    backupPolicyTo.setCompressionEnabled(groupPolicyElement.isCompressionEnabled());
                    backupPolicyTo.setMemoryUtilization(groupPolicyElement.getMemoryUtilisation());
                    backupPolicyTo.setNetworkThrottleSpeed(groupPolicyElement.getNetworkThrottleSpeed());
                    backupPolicyTo.setBlukryptSelectionAlgorithm(groupPolicyElement.getBlukryptSelectionAlgorithm());
                    backupPolicyTo.setSkipHiddenFile(groupPolicyElement.isSkipHiddenfile());
                    backupPolicyTo.setThreadPriorityForcpuThrottle(groupPolicyElement.getThreadPriorityForCpuThrottle());
                    backupPolicyTo.setDoaminCheckEnabled(groupPolicyElement.isDomainCheckEnabled());
                    backupPolicyTo.setAllowedDomains(groupPolicyElement.getAllowedDomains());
                    backupPolicyTo.setClientDedupEnabled(groupPolicyElement.isClientDedupEnabled());
                    backupPolicyTo.setMaxFileSizeinMBBkpbatch(groupPolicyElement.getMaxFileSizeinMBBkpbatch());
                    backupPolicyTo.setSqlBackupEnabled(groupPolicyElement.isSqlbkpEnabled());
                    backupPolicyTo.setPreScanCommand(groupPolicyElement.getPreScanCommand());
                    backupPolicyTo.setPreBackupCommand(groupPolicyElement.getPreBackupCommand());
                    backupPolicyTo.setPostBackupCommand(groupPolicyElement.getPostBackupCommand());
                    backupPolicyTo.setContinueOnPreScan(groupPolicyElement.isContinueOnPreScan());
                    backupPolicyTo.setContinueOnPreBkp(groupPolicyElement.isContinueOnPreBkp());
                    backupPolicyTo.setContinueOnPostBkp(groupPolicyElement.isContinueOnPostBkp());
                    backupPolicyTo.setPreScanCommandEnabled(groupPolicyElement.isPreScanCommandEnabled());
                    backupPolicyTo.setPreBackupCommandEnabled(groupPolicyElement.isPreBackupCommandEnabled());
                    backupPolicyTo.setPostBackupCommandEnabled(groupPolicyElement.isPostBackupCommandEnabled());
                    backupPolicyTo.setSwitchAgentPassword(groupPolicyElement.isSwitchAgentPassword());
                    backupPolicyTo.setUserConsentEnabled(groupPolicyElement.isUserConsentEnabled());
                    backupPolicyTo.setUserConsentDisplayText(groupPolicyElement.getUserConsentDisplayText());
                    backupPolicyTo.setNumberOfThreadsAllowedForBackup(groupPolicyElement.getNumberOfThreadsAllowedForBackup());
                    logger.debug(groupPolicyElement.isUserConsentEnabled() + groupPolicyElement.getUserConsentDisplayText());
                    logger.debug(groupPolicyElement.getAgentPassword() + "........" + groupPolicyElement.isSwitchAgentPassword());
                    String pswd = groupPolicyElement.getAgentPassword();
                    if (StringUtils.isNotEmpty((String)pswd)) {
                        pswd = PolicyManagementServerHelper.encodeBase64UTFString(pswd);
                    }
                    backupPolicyTo.setAgentPassword(pswd);
                    backupPolicyTo.setActive(groupPolicyElement.isActive());
                    backupPolicyTo.setBackupNetworkDrives(groupPolicyElement.isBackupNetworkDrives());
                    backupPolicyTo.setLogUnaccessedFiles(groupPolicyElement.isLogUnaccessedFiles());
                    SettingHelper.setIsStatisticsEnabled(groupPolicyElement.getIsStatisticsEnabled());
                    SettingHelper.setUserMaxStorageLimit(groupPolicyElement.getUserSizeAllowed());
                    SettingHelper.setMaxVersionsToKeep(groupPolicyElement.getMaxVersions());
                    SettingHelper.setDCMEnabled(Boolean.parseBoolean(groupPolicyElement.getDcmEnabled()));
                    SettingHelper.setBackupCrawlLimit(groupPolicyElement.getCrawlLimit());
                    SettingHelper.setIsVssEnabled(groupPolicyElement.getVssEnabled());
                    SettingHelper.setCurrentBackupPolicy(backupPolicyTo);
                    logger.debug(groupPolicyElement.isContinueOnPreScan() + " " + groupPolicyElement.isPreScanCommandEnabled() + " " + groupPolicyElement.getPreScanCommand());
                    logger.debug(groupPolicyElement.isContinueOnPreBkp() + " " + groupPolicyElement.isPreBackupCommandEnabled() + " " + groupPolicyElement.getPreBackupCommand());
                    logger.debug(groupPolicyElement.isContinueOnPostBkp() + " " + groupPolicyElement.isPostBackupCommandEnabled() + " " + groupPolicyElement.getPostBackupCommand());
                    boolean success = backupPolicyDAOImpl.insertBackupPolicyDetailsToTable(backupPolicyTo);
                    logger.debug("Result for inserting backup policy details into table:" + success);
                    if (success) {
                        policyStoredToDb.add(groupPolicyElement.getPolicygroupName());
                        fullBackupInfoTableDAOImpl.createBackupInfoTable();
                        List<FullBackupInfoTO> fullBackupInfos = fullBackupInfoTableDAOImpl.getBackupInfoDetails();
                        FullBackupInfoTO fullBackupInfo = null;
                        if (!fullBackupInfos.isEmpty()) {
                            fullBackupInfo = fullBackupInfos.get(0);
                        }
                        if (groupPolicyElement.getFullBackupEnabled() != null && Boolean.parseBoolean(groupPolicyElement.getFullBackupEnabled()) && groupPolicyElement.getFullBackupStartDate() != 0L) {
                            if (fullBackupInfo == null) {
                                logger.debug("full backup info table is null.....");
                                PolicyManagementServerHelper.updateFullBackupInfoTable(groupPolicyElement, true);
                            } else if (!backupPolicyTo.getPolicyGroupName().equals(fullBackupInfo.getPolicyGroupName()) || groupPolicyElement.getFullBackupStartDate() != fullBackupInfo.getFullBackupStartDate()) {
                                fullBackupInfoTableDAOImpl.clearEntireTable();
                                PolicyManagementServerHelper.updateFullBackupInfoTable(groupPolicyElement, true);
                            }
                        } else if (groupPolicyElement.getFullBackupEnabled() != null && !Boolean.parseBoolean(groupPolicyElement.getFullBackupEnabled()) && fullBackupInfo != null) {
                            logger.debug("reverting back changes for policy changes......");
                            fullBackupInfoTableDAOImpl.clearEntireTable();
                            PolicyManagementServerHelper.updateFullBackupInfoTable(groupPolicyElement, false);
                        }
                    }
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error("Result for inserting backup policy details into table:false" + e.getMessage());
                }
                if (!listFolderPathElement.isEmpty()) {
                    backUpFolderDAOImpl.dropTable();
                    backUpFolderDAOImpl.createBackUpTable();
                    SettingHelper.setBackupPolicyFoldersList(listFolderPathElement);
                    PolicyManagementServerHelper.addBkPolicyFolderToExistingTable(listFolderPathElement, groupPolicyElement.getPolicygroupName());
                }
                if (exceptionsToExclusions != null && !exceptionsToExclusions.isEmpty()) {
                    logger.debug("Inside new changes exceptions to exclusions");
                    backupPolicyDAOImpl.createPolicyExceptionsTOExclusionTable();
                    SettingHelper.setInclusionList(exceptionsToExclusions);
                    PolicyManagementServerHelper.addExceptionsToExclusionsToTable(exceptionsToExclusions, groupPolicyElement.getPolicygroupName());
                }
                if (!excludedFolderListElement.isEmpty()) {
                    backupPolicyDAOImpl.createPolicyExcludedFolderTable();
                    PolicyManagementServerHelper.addBkPolicyExcludedFoldersToTable(excludedFolderListElement);
                }
                List networkThrottlings = groupPolicyElement.getNetworkThrottleElement();
                for (Object throttlings2 : networkThrottlings) {
                    for (Throttling throttling : throttlings2.getThrottlingList()) {
                        NWThrottlingTO nwThrottlingTO = new NWThrottlingTO();
                        nwThrottlingTO.setNwName(throttling.getNetworkThrottlingName());
                        nwThrottlingTO.setStartTime(throttling.getStartTime());
                        nwThrottlingTO.setEndTime(throttling.getEndTime());
                        nwThrottlingTO.setMaxSpeed(throttling.getMaxSpeed());
                        nwThrottlingTO.setUploadSpeed(throttling.getUploadSpeed());
                        nwThrottlingTO.setDownloadSpeed(throttling.getDownloadSpeed());
                        backUpFolderDAOImpl.insertNetworkThrottling(nwThrottlingTO);
                    }
                }
                List scheduleElements = groupPolicyElement.getSchedulesElement();
                throttlings2 = scheduleElements.iterator();
                while (throttlings2.hasNext()) {
                    ScheduleElement scheduleElement = (ScheduleElement)throttlings2.next();
                    ArrayList<ScheduleTO> scheduleTOList = new ArrayList<ScheduleTO>();
                    for (Schedule schedule : scheduleElement.getScheduleList()) {
                        ScheduleTO scheduleTO = new ScheduleTO();
                        logger.debug("schedule name : " + schedule.getScheduleName());
                        scheduleTO.setScheduleName(schedule.getScheduleName());
                        scheduleTO.setStartTime(schedule.getTime());
                        scheduleTO.setDayArray(PolicyManagementServerHelper.toString(PolicyManagementServerHelper.getArrayInt(schedule.getDayArrayElementList().getDayArray())));
                        if (groupPolicyElement.isSqlbkpEnabled()) {
                            scheduleTO.setBackupType("full");
                        } else {
                            scheduleTO.setBackupType("Inc");
                        }
                        scheduleTO.setPolicyName(groupPolicyElement.getPolicygroupName());
                        scheduleTOList.add(scheduleTO);
                    }
                    backUpFolderDAOImpl.insertSchedules(scheduleTOList);
                }
                InclusionFilterElement inclusionElement = groupPolicyElement.getInclusionFilterElement();
                logger.debug("Filter name : " + inclusionElement.getFilterName());
                InclusionTO inclusionTO = new InclusionTO();
                inclusionTO.setFilterName(inclusionElement.getFilterName());
                if (!StringUtils.isEmpty((String)inclusionElement.getFilterType())) {
                    inclusionTO.setFilterType(inclusionElement.getFilterType());
                } else {
                    inclusionTO.setFilterType("inclusion");
                }
                inclusionTO.setExtensionName(inclusionElement.getExtensions());
                inclusionTO.setPolicyName(groupPolicyElement.getPolicygroupName());
                ArrayList<InclusionTO> inclusionList = new ArrayList<InclusionTO>();
                inclusionList.add(inclusionTO);
                backUpFolderDAOImpl.insertInclusions(inclusionList);
                GatewayElement gatewayElement = groupPolicyElement.getGatewayElement();
                List nameElements = gatewayElement.getGatewayList();
                ArrayList<GatewayTO> gatewayTOList = new ArrayList<GatewayTO>();
                for (GatewayNameElement gatewayElements : nameElements) {
                    logger.debug("GATEWAY RECEIVED " + gatewayElements.getName());
                    GatewayTO gatewayTO = new GatewayTO();
                    gatewayTO.setGatewayName(gatewayElements.getName());
                    gatewayTO.setType(gatewayElements.getType());
                    gatewayTO.setPolicyName(groupPolicyElement.getPolicygroupName());
                    gatewayTO.setProductType("BACKUP");
                    gatewayTOList.add(gatewayTO);
                }
                backUpFolderDAOImpl.insertGatewayNames(gatewayTOList);
                BluVaultMappingListElement ebmsMappingListElement = groupPolicyElement.getBluVaultMappingListElements();
                List mappingElements = ebmsMappingListElement.getEBMSList();
                ArrayList<BluVaultTO> bluvaultTOList = new ArrayList<BluVaultTO>();
                for (BluVaultMappingElement ebmsMappingElement : mappingElements) {
                    BluVaultTO bluvaultTO = new BluVaultTO();
                    bluvaultTO.setBluVaultName(ebmsMappingElement.getBluvaultName());
                    bluvaultTO.setProductType("BACKUP");
                    bluvaultTOList.add(bluvaultTO);
                }
                backupPolicyDAOImpl.insertBluVaultNamesToTable(bluvaultTOList);
                List backupUiPreferences = groupPolicyElement.getEndpointUiPreferencesListElement().getEndpointUIPreferencesList();
                logger.debug("backupUiPreferences : " + backupUiPreferences + " empty ? :" + backupUiPreferences.isEmpty());
                if (backupUiPreferences != null && !backupUiPreferences.isEmpty()) {
                    ArrayList<String> uiPreferencesList = new ArrayList<String>();
                    StringBuilder backupUiPreferencesString = new StringBuilder("");
                    for (EndpointUIPreferencesElement e : backupUiPreferences) {
                        logger.debug("Recived preferrences : " + e.getEndpointUiPreference());
                        uiPreferencesList.add(e.getEndpointUiPreference());
                        backupUiPreferencesString.append(e.getEndpointUiPreference()).append(",");
                    }
                    logger.debug("......" + backupUiPreferencesString.toString());
                    logger.debug("......" + SettingHelper.getEndpointBackupUiDetails());
                    if (!backupUiPreferencesString.toString().equals(SettingHelper.getEndpointBackupUiDetails())) {
                        NotificationHelper.setRestartAgentIcon(true);
                        logger.debug("....ui list is changed so set true..");
                    } else {
                        NotificationHelper.setRestartAgentIcon(false);
                    }
                    SettingHelper.setEndpointBackupUiDetails(backupUiPreferencesString.toString());
                } else {
                    InterfaceManagementService.initialiseDefaultUISettings("BACKUP", true);
                    SettingHelper.setEndpointBackupUiDetails("");
                }
                ArrayList<String> uiDisabledList = new ArrayList<String>();
                StringBuilder backupUiDisabledListString = new StringBuilder("");
                if (groupPolicyElement.getEndpointDisabledListElement() != null) {
                    List disabledUiPrepferences = groupPolicyElement.getEndpointDisabledListElement().getEndpointDisabledPreferencesList();
                    logger.debug("uidisabled list ..." + disabledUiPrepferences.isEmpty());
                    if (!disabledUiPrepferences.isEmpty() && disabledUiPrepferences != null) {
                        for (EndpointUiDisabledPreferencesElement list : disabledUiPrepferences) {
                            logger.debug("Recived preferrences for disables ui: " + list.getEndpointdisabledPreference());
                            uiDisabledList.add(list.getEndpointdisabledPreference());
                            backupUiDisabledListString.append(list.getEndpointdisabledPreference()).append(",");
                        }
                        InterfaceManagementService.disableUISettings("BACKUP", uiDisabledList);
                        SettingHelper.setEndpointBackupUiDisabledDetails(backupUiDisabledListString.toString());
                    } else {
                        PolicyManagementServerHelper.setDefaultUISettings();
                    }
                } else {
                    PolicyManagementServerHelper.setDefaultUISettings();
                }
                SettingHelper.applyChangesToSharedPreferences(true);
            }
        }
    }

    private static void setDefaultUISettings() {
        logger.debug("ui disabled list is empty...");
        InterfaceManagementService.initialiseDefaultUISettings("BACKUP", true);
        SettingHelper.setEndpointBackupUiDisabledDetails("");
    }

    private static void updateFullBackupInfoTable(GroupPolicyElement groupPolicyElement, boolean isFull) {
        FullBackupInfoTO fullBackupInfoTO = new FullBackupInfoTO();
        fullBackupInfoTO.setPolicyGroupName(groupPolicyElement.getPolicygroupName());
        fullBackupInfoTO.setFullBackupStartDate(groupPolicyElement.getFullBackupStartDate());
        fullBackupInfoTO.setFullBackup(isFull);
        fullBackupInfoTableDAOImpl.insertIntoBackupInfoTable(fullBackupInfoTO);
    }

    private static int changeTimeToMin(String time) {
        int timeInMin = 0;
        if (!StringUtils.isEmpty((String)time)) {
            String[] hourMin = time.split(":");
            if (hourMin.length == 1) {
                return Integer.parseInt(hourMin[0]);
            }
            int hour = Integer.parseInt(hourMin[0]);
            int mins = Integer.parseInt(hourMin[1]);
            timeInMin = hour * 60 + mins;
        }
        return timeInMin;
    }

    private static int[] getArrayInt(List<DayArray> list) {
        int[] dayArray = new int[list.size()];
        int i = 0;
        for (DayArray arrayElement : list) {
            dayArray[i] = arrayElement.getDayArray();
            ++i;
        }
        return dayArray;
    }

    public static String toString(int[] input) {
        StringBuilder buffer = new StringBuilder();
        if (input.length != 0) {
            buffer.append(input[0]);
            for (int i = 1; i < input.length; ++i) {
                buffer.append(",");
                buffer.append(input[i]);
            }
        }
        return buffer.toString();
    }

    private static void addBkPolicyExcludedFoldersToTable(List<BkPolicyExcludedFolderListElement> excludedFolderListElement) {
        ArrayList<String> excludedFolderPathList = new ArrayList<String>();
        for (BkPolicyExcludedFolderListElement folderListElement : excludedFolderListElement) {
            List folderPathElements = folderListElement.getFolderPathList();
            logger.debug("Adding Folders from policy:");
            for (ExcludedFolderPathElement folderPathElement : folderPathElements) {
                if (folderPathElement.getFolderPath() != null) {
                    if (folderPathElement.getFolderPath().toLowerCase().contains(USERHOME_CONTAINS)) {
                        String newPath = folderPathElement.getFolderPath().toLowerCase().replace(USERHOME_CONTAINS, SettingHelper.getUserHome());
                        folderPathElement.setFolderPath(newPath);
                    }
                    logger.info(" " + folderPathElement.getFolderPath());
                    if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                        excludedFolderPathList.add(folderPathElement.getFolderPath().toLowerCase());
                        continue;
                    }
                    excludedFolderPathList.add(folderPathElement.getFolderPath());
                    continue;
                }
                logger.debug("Excluded folder path is null ");
            }
            logger.debug("Exclusing Folders from policy list size:" + excludedFolderPathList.size());
            backupPolicyDAOImpl.insertPolicyExcludedFoldersToTable(excludedFolderPathList);
        }
    }

    private static void addBkPolicyFolderToExistingTable(List<BkPolicyFolderPathElement> listFolderPathElement, String policyName) {
        boolean isDefaultFoldersLatest = true;
        logger.debug("IS Default Folders Latest:" + isDefaultFoldersLatest);
        if (isDefaultFoldersLatest) {
            PolicyManagementServerHelper.storeSystemRoots();
            for (BkPolicyFolderPathElement bkPolicyFolderPathElement : listFolderPathElement) {
                List folderPathElements = bkPolicyFolderPathElement.getFolderPathList();
                logger.debug("Adding Folders from policy:");
                PolicyManagementServerHelper.checkAllDrivesSelectedForBackup(folderPathElements);
                ArrayList<BackupFolderTO> backupFolderTOList = new ArrayList<BackupFolderTO>();
                for (FolderPathElement folderPathElement : folderPathElements) {
                    BackupFolderTO backupFolderTO = new BackupFolderTO();
                    if (folderPathElement.getFolderPath().toLowerCase().contains(USERHOME_CONTAINS)) {
                        String newPath = folderPathElement.getFolderPath().toLowerCase().replace(USERHOME_CONTAINS, SettingHelper.getUserHome());
                        folderPathElement.setFolderPath(newPath);
                    }
                    if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                        PolicyManagementServerHelper.checkPreconditionsForFolderPath(folderPathElement);
                        String basePathOfTheFolder = folderPathElement.getFolderPath().substring(0, 3).replace("/", "\\");
                        if (!rootFilesList.contains(basePathOfTheFolder.toLowerCase())) {
                            logger.debug("Not Supported Drive....." + basePathOfTheFolder);
                            continue;
                        }
                    }
                    if (SettingHelper.getOsName().toLowerCase().contains("mac")) {
                        String macAppendedPath = "Macintosh" + StringLiterals.FILE_SEPARATOR + folderPathElement.getFolderPath();
                        folderPathElement.setFolderPath(macAppendedPath);
                    }
                    if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                        backupFolderTO.setFolderPath(folderPathElement.getFolderPath().toLowerCase().replace("/", "\\"));
                    } else {
                        backupFolderTO.setFolderPath(folderPathElement.getFolderPath());
                    }
                    backupFolderTO.setCreateBy("IA");
                    backupFolderTO.setPolicyName(policyName);
                    logger.info(" " + backupFolderTO.getFolderPath());
                    backupFolderTOList.add(backupFolderTO);
                }
                backUpFolderDAOImpl.insertListOfBackupFolders(backupFolderTOList);
            }
        }
    }

    private static void checkPreconditionsForFolderPath(FolderPathElement folderPathElement) {
        if (folderPathElement.getFolderPath().length() < 3) {
            switch (folderPathElement.getFolderPath().length()) {
                case 1: {
                    folderPathElement.setFolderPath(new StringBuffer(folderPathElement.getFolderPath()).append(":\\").toString());
                    break;
                }
                case 2: {
                    folderPathElement.setFolderPath(new StringBuffer(folderPathElement.getFolderPath()).append("\\").toString());
                    break;
                }
                default: {
                    logger.debug("Path after verifying " + folderPathElement.getFolderPath());
                }
            }
        }
    }

    private static void checkAllDrivesSelectedForBackup(List<FolderPathElement> folderPathElements) {
        boolean allDriversSelected = false;
        for (FolderPathElement folderPathElement : folderPathElements) {
            if (!folderPathElement.getFolderPath().contentEquals("ALL")) continue;
            logger.debug("Inside all drives selected");
            allDriversSelected = true;
            break;
        }
        if (allDriversSelected) {
            folderPathElements.clear();
            if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                for (String rootfile : rootFilesList) {
                    FolderPathElement folderpathElement = new FolderPathElement();
                    folderpathElement.setFolderPath(rootfile);
                    folderpathElement.setOsType(SettingHelper.getOsName());
                    folderPathElements.add(folderpathElement);
                }
            } else if (SettingHelper.getOsName().toLowerCase().contains("mac")) {
                FolderPathElement folderpathElement = new FolderPathElement();
                folderpathElement.setFolderPath("/");
                folderpathElement.setOsType(SettingHelper.getOsName());
                folderPathElements.add(folderpathElement);
            }
        }
    }

    public static void updateFailCodeToActivityHistory(int errorCode) {
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (backupActivityTO != null && (backupActivityTO.getBatchStatus().equals(BackupLifeCycle.STARTED.toString()) || backupActivityTO.getBatchStatus().equals(BackupLifeCycle.SCANNING.toString()) || backupActivityTO.getBatchStatus().equals(BackupLifeCycle.PRESCAN_COMMAND_EXECUTION.toString())) && backupActivityTO.getFailCode() != 1207 && backupActivityTO.getFailCode() != 1981 && backupActivityTO.getFailCode() != 1996 && backupActivityTO.getFailCode() != 1992 && backupActivityTO.getFailCode() != 1209 && backupActivityTO.getFailCode() != 1208 && backupActivityTO.getFailCode() != 1212) {
            backupActivityTO.setFailCode(errorCode);
            backupActivityHistoryDAOImpl.updateFailCodeToBackupActivityHistoryTable(backupActivityTO);
        }
    }

    private static String backupBatchInitiated(String batchStatus, String batchId, int totalCount, int errorCode, long totalUploadSize, String totalUploadedCount, String crawlTimestamp, boolean isFullBackup, boolean doSleep) {
        String curentbatchId;
        boolean retry;
        String jobType = "BACKUP";
        String originalBatchId = batchId;
        int retryCount = 0;
        int sleepMultiplier = 1;
        int retryCheckCount = 4;
        long sleepTime = 60000L * (long)sleepMultiplier;
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        String currentIPToUse = SettingHelper.getCurrentCloudIpAddress();
        BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
        List<BluVaultTO> ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
        if (!doSleep) {
            retryCheckCount = 1;
        }
        do {
            retry = false;
            logger.debug("Retrying to update backup status.do sleep value:" + doSleep);
            try {
                logger.debug("The status:" + batchStatus + "the count is:" + totalCount);
                BackupOrRestoreStatusTo backupOrRestoreStatusTo = new BackupOrRestoreStatusTo();
                backupOrRestoreStatusTo.setStatus(batchStatus);
                backupOrRestoreStatusTo.setIp(currentIPToUse);
                backupOrRestoreStatusTo.setToken(SettingHelper.readTokenFromFile());
                backupOrRestoreStatusTo.setBatchId(originalBatchId);
                backupOrRestoreStatusTo.setJobType(jobType);
                backupOrRestoreStatusTo.setDeviceName(SettingHelper.getDeviceName());
                backupOrRestoreStatusTo.setTotalCount(totalCount);
                backupOrRestoreStatusTo.setErrorCode(errorCode);
                backupOrRestoreStatusTo.setDeviceUUID(SettingHelper.getDeviceUUId());
                backupOrRestoreStatusTo.setTotalUploadSize(totalUploadSize);
                backupOrRestoreStatusTo.setTotalUploadedCount(totalUploadedCount);
                backupOrRestoreStatusTo.setCrawlCount(0);
                backupOrRestoreStatusTo.setCrawlTimeStamp(crawlTimestamp);
                backupOrRestoreStatusTo.setFullBackup(isFullBackup);
                backupOrRestoreStatusTo.setDiskSpaceDetails(new ParabluFileSystemUtils().getSystemSpace());
                backupOrRestoreStatusTo.setPolicyConfiguredFolders(PolicyManagementServerHelper.getConfiguredBackupFolders());
                if (!backupOrRestoreStatusTo.getStatus().startsWith("STARTED")) {
                    backupOrRestoreStatusTo.setFailedFileslogFile(BackupHelper.getFailedFilesLogFile());
                }
                backUpAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                curentbatchId = backUpAdapter.sendEmailNotification(backupOrRestoreStatusTo);
            }
            catch (Exception e) {
                curentbatchId = "-1";
                logger.trace("" + e);
                logger.error(" Exception inside  put batch " + e.getMessage());
            }
            if (!"-1".equalsIgnoreCase(curentbatchId)) continue;
            retry = true;
            ebmsList = PolicyManagementServerHelper.removeCurrentIp(ebmsList, currentIPToUse);
            logger.debug("ebms list size after removing the current ip:" + ebmsList.size());
            if (ebmsList.isEmpty()) {
                logger.debug("inside ebms list empty cycle finished so sleep and reset");
                ++retryCount;
                if (doSleep) {
                    sleepTime = ParabluFileSystemUtils.sleepForGivenTime((long)sleepTime);
                    ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
                }
            }
            if (ebmsList.isEmpty()) continue;
            currentIPToUse = ebmsList.get(0).getBluVaultName();
        } while (retry && retryCount < retryCheckCount);
        return curentbatchId;
    }

    private static List<BluVaultTO> removeCurrentIp(List<BluVaultTO> ebmsList, String currentIP) {
        List<BluVaultTO> ebmsList1 = ebmsList.stream().filter(p -> !p.getBluVaultName().equalsIgnoreCase(currentIP)).collect(Collectors.toList());
        logger.debug("After removing the ip size:" + ebmsList1.size() + "  current Ip:" + currentIP);
        return ebmsList1;
    }

    public static void sendCurrentStatisticsToServerBeforeExit(String status, boolean doSleep) {
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (backupActivityTO != null && (backupActivityTO.getBatchStatus().equals(BackupLifeCycle.STARTED.toString()) || backupActivityTO.getBatchStatus().equals(BackupLifeCycle.SCANNING.toString()) || backupActivityTO.getBatchStatus().equals(BackupLifeCycle.PRESCAN_COMMAND_EXECUTION.toString()))) {
            logger.debug("User exit the app or network connection failed. so failed status to be sent");
            backupActivityTO.setBatchStatus(status);
            String batchId = backupActivityTO.getBatchId();
            int errorCode = backupActivityTO.getFailCode();
            logger.debug("The fail code is:" + errorCode);
            long totalUploadSize = backupActivityTO.getTotalUploadSize();
            String uploadedList = backupActivityTO.getBackupUploadCount();
            boolean isFullBackup = Boolean.parseBoolean(backupActivityTO.getFullBackup());
            batchId = PolicyManagementServerHelper.backupBatchInitiated(backupActivityTO.getBatchStatus(), batchId, 0, errorCode, totalUploadSize, uploadedList, backupActivityTO.getBackupActivityTimeStamp(), isFullBackup, doSleep);
            if (batchId != null && batchId != "-1") {
                logger.debug("Batch id for this backup is:" + batchId + "status:" + status);
                backupActivityTO.setBatchId(batchId);
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            }
        }
        if (backupActivityTO != null && backupActivityTO.getBackupActivityStatus().equals(CrawlLifecycle.INPROGRESS.toString())) {
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.STOPPED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
        }
    }

    public static Set<String> storeSystemRoots() {
        if (rootFilesList != null) {
            rootFilesList.clear();
        } else {
            rootFilesList = new HashSet<String>();
        }
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            try {
                List<WinDrives.Drive> driveList = WinDrives.getDrives();
                for (WinDrives.Drive drive : driveList) {
                    logger.debug("drive name:" + drive.toString() + " type:" + drive.driveType.toString());
                    logger.debug("backup network drives:" + SettingHelper.getCurrentBackupPolicy().isBackupNetworkDrives());
                    if (drive.driveType.toString().equalsIgnoreCase("Local Disk".replaceAll("\\s", ""))) {
                        logger.debug("Adding drive to list:" + drive.file.getAbsolutePath());
                        rootFilesList.add(drive.file.getAbsolutePath().toLowerCase());
                        continue;
                    }
                    if (!drive.driveType.toString().equalsIgnoreCase("Network Drive".replaceAll("\\s", "")) || !SettingHelper.getCurrentBackupPolicy().isBackupNetworkDrives()) continue;
                    logger.debug("Adding network drive to list:" + drive.file.getAbsolutePath());
                    rootFilesList.add(drive.file.getAbsolutePath().toLowerCase());
                }
            }
            catch (Exception e) {
                logger.error("error to get drives list using win32 api..", (Throwable)e);
                PolicyManagementServerHelper.storeRootFilesMac();
            }
        } else {
            PolicyManagementServerHelper.storeRootFilesMac();
        }
        return rootFilesList;
    }

    private static void storeRootFilesMac() {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File[] files = File.listRoots();
        logger.debug("List of root folders:" + files.length);
        for (File file : files) {
            if (PolicyManagementServerHelper.isDriveSkip(fsv, file) || PolicyManagementServerHelper.isDriveNotValid(fsv, file)) {
                logger.debug("error reading root files" + file.getAbsolutePath());
                continue;
            }
            if (PolicyManagementServerHelper.isDriveValid(fsv, file, "Local Disk")) {
                rootFilesList.add(file.getAbsolutePath().toLowerCase());
                continue;
            }
            if (SettingHelper.getCurrentBackupPolicy().isBackupNetworkDrives() && PolicyManagementServerHelper.isDriveValid(fsv, file, "Network Drive")) {
                rootFilesList.add(file.getAbsolutePath().toLowerCase());
                continue;
            }
            logger.debug("error reading root files" + file.getAbsolutePath());
        }
    }

    private static boolean isDriveSkip(FileSystemView fsv, File file) {
        return !fsv.isDrive(file) || !file.canRead() || !file.canWrite();
    }

    private static boolean isDriveNotValid(FileSystemView fsv, File file) {
        return fsv.getSystemTypeDescription(file).equalsIgnoreCase("Removable Disk") || fsv.getSystemTypeDescription(file).equalsIgnoreCase("CD Drive");
    }

    public static List<WinDrives.Drive> getNetworkDriveLists() {
        ArrayList<WinDrives.Drive> driveList = new ArrayList<WinDrives.Drive>();
        try {
            List<WinDrives.Drive> drivesList = WinDrives.getDrives();
            for (WinDrives.Drive drive : drivesList) {
                if (!drive.driveType.toString().equalsIgnoreCase("Network Drive".replaceAll("\\s", ""))) continue;
                driveList.add(drive);
            }
        }
        catch (Exception e) {
            File[] files;
            logger.error("error getting the drive using winmngmt");
            FileSystemView fsv = FileSystemView.getFileSystemView();
            for (File file : files = File.listRoots()) {
                WinDrives.DriveTypeEnum driveTypeEnum = null;
                if (!fsv.getSystemTypeDescription(file).equalsIgnoreCase("Network Drive")) continue;
                driveTypeEnum = WinDrives.DriveTypeEnum.NetworkDrive;
                WinDrives.Drive drive = new WinDrives.Drive("NTFS", driveTypeEnum, file);
                driveList.add(drive);
            }
        }
        return driveList;
    }

    public static void createContainerDetalis(BackupPolicyDAOImpl backupPolicyDAOImpl2, List<DeviceContainerElement> deviceContainerElements) {
        if (!deviceContainerElements.isEmpty()) {
            backupPolicyDAOImpl2.deleteContainerDetails();
            for (DeviceContainerElement deviceContainerElement : deviceContainerElements) {
                if (deviceContainerElement == null) continue;
                ContainerDetailsTo containerDetailsTo = new ContainerDetailsTo();
                containerDetailsTo.setPolicyname(deviceContainerElement.getBackupPolicyName());
                containerDetailsTo.setGroupName(deviceContainerElement.getGroupName());
                containerDetailsTo.setContainerName(deviceContainerElement.getContainerName());
                containerDetailsTo.setContainerLocation(deviceContainerElement.getContainerLocation());
                containerDetailsTo.setContainerPassword(deviceContainerElement.getPassword());
                containerDetailsTo.setContainerPort(deviceContainerElement.getPort());
                containerDetailsTo.setContainerType(deviceContainerElement.getContainerType());
                containerDetailsTo.setContainerUserName(deviceContainerElement.getUsername());
                boolean success = backupPolicyDAOImpl.insertContainerDetailsToTable(containerDetailsTo);
                logger.debug("Storing container details to database " + success);
            }
        } else {
            logger.debug("Device element list empty");
        }
    }

    public static String getContainerNamesForSchedule(String policyName, BackupPolicyDAOImpl backupPolicyDAOImpl) {
        StringBuilder containerName = new StringBuilder("");
        List<ContainerDetailsTo> containerDetailsTos = backupPolicyDAOImpl.getCurrentContainerDetails(policyName, false);
        for (ContainerDetailsTo container : containerDetailsTos) {
            if ("".equals(containerName.toString())) {
                containerName = containerName.append(container.getContainerName());
                continue;
            }
            containerName = containerName.append("|").append(container.getContainerName());
        }
        return containerName.toString();
    }

    public static String sendServerBackupStatus(BackupAdapter backupAdapter, String status, String processId, String backupSizeOnDisk, int currentStep, boolean isUpdate, String token, String serverBackupStatusId, String recivedEndTime) {
        String recivedBackupStatusId = "";
        String startTime = Long.toString(0L);
        String endTime = Long.toString(0L);
        ContainerBackupStatusTo containerBackupStatusTo = new ContainerBackupStatusTo();
        List<ContainerDetailsTo> containerDetailsTos = backupPolicyDAOImpl.getCurrentContainerDetails(NotificationHelper.getCurrentContainerName(), true);
        if (!containerDetailsTos.isEmpty()) {
            if ("F".equalsIgnoreCase(NotificationHelper.getServerBackupType())) {
                containerBackupStatusTo.setBackupJobType("FULL");
            } else {
                containerBackupStatusTo.setBackupJobType("INCREMENTAL");
            }
            containerBackupStatusTo.setContainerName(NotificationHelper.getCurrentContainerName());
            containerBackupStatusTo.setContainerType(containerDetailsTos.get(0).getContainerType());
            containerBackupStatusTo.setStatus(status);
            containerBackupStatusTo.setProcessId(processId);
            containerBackupStatusTo.setTotalSteps("4");
            containerBackupStatusTo.setBackupSizeOnDiskInMB(backupSizeOnDisk);
            containerBackupStatusTo.setCurrentStep(currentStep);
            if (!isUpdate) {
                startTime = Long.toString(System.currentTimeMillis());
            } else if (!"0".equalsIgnoreCase(recivedEndTime)) {
                endTime = recivedEndTime;
            }
            containerBackupStatusTo.setStartTime(startTime);
            containerBackupStatusTo.setEndTime(endTime);
            try {
                recivedBackupStatusId = backupAdapter.sendCurrentBakupStatus(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), containerBackupStatusTo, isUpdate, token, serverBackupStatusId);
                if (!isUpdate) {
                    NotificationHelper.setCurrentContainerJobId(recivedBackupStatusId);
                }
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("error while sending the server backup status" + e.getMessage());
            }
        } else {
            logger.debug("Container detalis empty");
        }
        logger.debug("Sucessfuly updated bakup status  " + recivedBackupStatusId);
        return recivedBackupStatusId;
    }

    public static DeviceTo getsServerBackupDeviceDetails() {
        String userName = null;
        DeviceTo deviceTo = null;
        try {
            deviceTo = backUpAdapter.getUserForDevice(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId());
            userName = deviceTo.getUserName();
            logger.debug("Server userName " + userName);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.debug("Could not get server user name " + e.getMessage());
        }
        return deviceTo;
    }

    public static void loadSyncPolicyElement(String deviceName) {
        SyncPolicyTo syncPolicyTo = new SyncPolicyTo();
        try {
            SyncPolicyElement syncPolicyElement = syncAdapter.getSyncPolicyElement(SettingHelper.getCurrentCloudIpAddress(), null, deviceName, SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
            PolicyManagementServerHelper.createSyncPolicyAndChildDetails(syncPolicyDAOImpl, syncPolicyTo, syncPolicyElement);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("error in getting the group policy elements" + e.getMessage());
        }
    }

    public static void createSyncPolicyAndChildDetails(SyncPolicyDAOImpl syncPolicyDAOImpl, SyncPolicyTo syncPolicyTo, SyncPolicyElement syncPolicyElement) {
        if (syncPolicyElement != null) {
            syncPolicyDAOImpl.deleteSyncPolicyAndChildDetails();
            syncPolicyDAOImpl.deleteSyncPolicyAndChildDetailsFromBackupdb();
            try {
                syncPolicyTo.setPolicyGroupName(syncPolicyElement.getPolicygroupName());
                syncPolicyTo.setMaxFileSize(syncPolicyElement.getMaxFileSize());
                syncPolicyTo.setMaxVersions(syncPolicyElement.getMaxVersions());
                syncPolicyTo.setLastModifiedTime(syncPolicyElement.getLastModifiedTime());
                syncPolicyTo.setPftEnabled(syncPolicyElement.getPftEnabled());
                syncPolicyTo.setPftSize(syncPolicyElement.getPftSize());
                syncPolicyTo.setCpuUtilization(syncPolicyElement.getCpuUtilization());
                syncPolicyTo.setPolicyRefreshInterval(PolicyManagementServerHelper.changeTimeToMin(syncPolicyElement.getPolicyRefreshInterval()));
                syncPolicyTo.setChunkSize(syncPolicyElement.getChunkSize());
                syncPolicyTo.setCompressionEnabled(syncPolicyElement.isCompressionEnabled());
                syncPolicyTo.setMemoryUtilization(syncPolicyElement.getMemoryUtilisation());
                syncPolicyTo.setAutomaticSync(syncPolicyElement.getAutomaticSync());
                syncPolicyTo.setSyncInterval(syncPolicyElement.getSyncInterval());
                syncPolicyTo.setNetworkThrottleSpeed(syncPolicyElement.getNetworkThrottleSpeed());
                SettingHelper.setUserMaxStorageLimit(syncPolicyElement.getUserSizeAllowed());
                SettingHelper.setMaxVersionsToKeep(syncPolicyElement.getMaxVersions());
                SettingHelper.setDCMEnabled(Boolean.parseBoolean(syncPolicyElement.getDcmEnabled()));
                boolean success = syncPolicyDAOImpl.insertSyncPolicyDetailsToTable(syncPolicyTo);
                logger.debug("Result for inserting sync policy details into table:" + success);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Result for inserting sync policy details into table:false" + e);
            }
            SettingHelper.setPolicySyncInterval(syncPolicyTo.getSyncInterval());
            SettingHelper.setTempEnableBlusync(Boolean.parseBoolean(syncPolicyTo.getAutomaticSync()));
            SettingHelper.applyChangesToSharedPreferences(true);
            InclusionFilterElement inclusionElement = syncPolicyElement.getInclusionFilterElement();
            ShareDetailsTo shareDetailsTo = new ShareDetailsTo();
            shareDetailsTo.setIsComplexPassword(syncPolicyElement.getIsComplexPassword());
            shareDetailsTo.setExpiryPeriod(syncPolicyElement.getExpiryPeriod());
            shareDetailsTo.setIsHighSecure(syncPolicyElement.getIsHighSecure());
            shareDetailsTo.setShareEnabled(syncPolicyElement.getShareEnabled());
            shareDetailsTo.setPolicyName(syncPolicyElement.getPolicygroupName());
            syncPolicyDAOImpl.insertShareDetails(shareDetailsTo);
            logger.debug("Filter name : " + inclusionElement.getFilterName());
            InclusionTO inclusionTO = new InclusionTO();
            inclusionTO.setFilterName(inclusionElement.getFilterName());
            if (!StringUtils.isEmpty((String)inclusionElement.getFilterType())) {
                inclusionTO.setFilterType(inclusionElement.getFilterType());
            } else {
                inclusionTO.setFilterType("inclusion");
            }
            inclusionTO.setExtensionName(inclusionElement.getExtensions());
            inclusionTO.setPolicyName(syncPolicyElement.getPolicygroupName());
            syncPolicyDAOImpl.insertInclusions(inclusionTO);
            GatewayElement gatewayElement = syncPolicyElement.getGatewayElement();
            List nameElements = gatewayElement.getGatewayList();
            ArrayList<GatewayTO> gatewayTOList = new ArrayList<GatewayTO>();
            for (GatewayNameElement gatewayElements : nameElements) {
                logger.debug("GATEWAY RECEIVED " + gatewayElements.getName());
                GatewayTO gatewayTO = new GatewayTO();
                gatewayTO.setGatewayName(gatewayElements.getName());
                gatewayTO.setType(gatewayElements.getType());
                gatewayTO.setPolicyName(syncPolicyElement.getPolicygroupName());
                gatewayTO.setProductType("SYNC");
                gatewayTOList.add(gatewayTO);
            }
            backUpFolderDAOImpl.insertGatewayNames(gatewayTOList);
            BluVaultMappingListElement ebmsMappingListElement = syncPolicyElement.getBluVaultMappingListElements();
            List mappingElements = ebmsMappingListElement.getEBMSList();
            ArrayList<BluVaultTO> ebmsList = new ArrayList<BluVaultTO>();
            for (BluVaultMappingElement ebmsMappingElement : mappingElements) {
                BluVaultTO bluvaultTO = new BluVaultTO();
                bluvaultTO.setBluVaultName(ebmsMappingElement.getBluvaultName());
                bluvaultTO.setProductType("SYNC");
                ebmsList.add(bluvaultTO);
            }
            backupPolicyDAOImpl.insertBluVaultNamesToTable(ebmsList);
            List syncUiPreferences = syncPolicyElement.getEndpointUiPreferencesListElement().getEndpointUIPreferencesList();
            if (syncUiPreferences != null && !syncUiPreferences.isEmpty()) {
                ArrayList<String> uiPreferencesList = new ArrayList<String>();
                StringBuilder syncUiPreferencesString = new StringBuilder("");
                for (EndpointUIPreferencesElement e : syncUiPreferences) {
                    uiPreferencesList.add(e.getEndpointUiPreference());
                    syncUiPreferencesString.append(e.getEndpointUiPreference()).append(",");
                }
                SettingHelper.setEndpointSyncUiDetails(syncUiPreferencesString.toString());
            } else {
                InterfaceManagementService.initialiseDefaultUISettings("SYNC", true);
                SettingHelper.setEndpointSyncUiDetails("");
            }
            ArrayList<String> disabledList = new ArrayList<String>();
            StringBuilder syncdisabledPreferencesString = new StringBuilder("");
            if (syncPolicyElement.getEndpointDisabledListElement() != null) {
                List disabledPrepferences = syncPolicyElement.getEndpointDisabledListElement().getEndpointDisabledPreferencesList();
                logger.debug("ui disabled list ..." + disabledPrepferences.isEmpty());
                if (!disabledPrepferences.isEmpty() && disabledPrepferences != null) {
                    for (EndpointUiDisabledPreferencesElement list : disabledPrepferences) {
                        logger.debug("Recived preferrences for disables ui: " + list.getEndpointdisabledPreference());
                        disabledList.add(list.getEndpointdisabledPreference());
                        syncdisabledPreferencesString.append(list.getEndpointdisabledPreference()).append(",");
                    }
                    InterfaceManagementService.disableUISettings("SYNC", disabledList);
                    SettingHelper.setEndpointSyncUiDisabledDetails(syncdisabledPreferencesString.toString());
                } else {
                    PolicyManagementServerHelper.setDefaultUIsettingsForSync();
                }
            } else {
                PolicyManagementServerHelper.setDefaultUIsettingsForSync();
            }
            SettingHelper.applyChangesToSharedPreferences(true);
        }
    }

    private static void setDefaultUIsettingsForSync() {
        logger.debug("ui disabled list is empty for sync... ");
        InterfaceManagementService.initialiseDefaultUISettings("SYNC", true);
        SettingHelper.setEndpointSyncUiDisabledDetails("");
    }

    public static BackupPolicyTO getCurrentBackupPolicy() {
        List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        BackupPolicyTO currentPolicy = null;
        if (currentDetails != null && !currentDetails.isEmpty()) {
            currentPolicy = currentDetails.get(0);
            currentPolicy = PolicyManagementServerHelper.isHashMatched(currentPolicy);
        }
        if (currentPolicy != null && "true".equals(currentPolicy.getPftEnabled())) {
            return currentPolicy;
        }
        return currentPolicy;
    }

    private static BackupPolicyTO isHashMatched(BackupPolicyTO currentPolicy) {
        boolean hashMatched = HashChecker.isHashMatchForBackupPolicy(currentPolicy);
        if (!hashMatched) {
            logger.debug("Backup policy's hash not matched so ###PULL POLICY### again..");
            CheckBackupPolicy.checkGroupPolicy();
            List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
            currentPolicy = null;
            if (currentDetails != null && !currentDetails.isEmpty()) {
                currentPolicy = currentDetails.get(0);
                return currentPolicy;
            }
        } else {
            logger.debug("hash is  matched so retrun...");
            return currentPolicy;
        }
        return null;
    }

    public static SyncPolicyTo getCurrentSyncPolicy() {
        List<SyncPolicyTo> syncPolicyTos = syncPolicyDAOImpl.getSyncPolicyDetails();
        if (syncPolicyTos != null && !syncPolicyTos.isEmpty()) {
            return syncPolicyTos.get(0);
        }
        return null;
    }

    private static GatewayTO getPrioritisedPrivacyGateway(String backupType, List<GatewayTO> recivedGatewayList) {
        List<GatewayTO> gatewayList = recivedGatewayList;
        if (gatewayList == null || gatewayList.isEmpty()) {
            gatewayList = HashChecker.getGatewayList(null);
        }
        for (GatewayTO gatewayTO : gatewayList) {
            int response;
            logger.debug("Gateway is :" + gatewayTO.getGatewayName());
            try {
                response = backUpAdapter.pingGatewayIP(gatewayTO.getGatewayName(), SettingHelper.getDeviceUUId());
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Error in ping Prioretised privacy gateway" + e.getMessage());
                continue;
            }
            if (response != 200) continue;
            logger.debug("Inside get prioritised gateway ping ok and check availability for :" + gatewayTO.getGatewayName());
            ArrayList<GatewayTO> gatewayList1 = new ArrayList<GatewayTO>();
            gatewayList1.add(gatewayTO);
            GatewayTO gatewayTO2 = PolicyManagementServerHelper.getElegibleGateway(gatewayList1);
            if (gatewayTO2 == null) continue;
            return gatewayTO2;
        }
        return null;
    }

    private static String getConfiguredBackupFolders() {
        List<BackupFolderTO> bkpFolderList = backUpFolderDAOImpl.getAllFolderToBackUpFiles();
        StringBuilder backupFolders = new StringBuilder("");
        if (!bkpFolderList.isEmpty()) {
            for (BackupFolderTO backupFolderTO : bkpFolderList) {
                backupFolders.append(backupFolderTO.getFolderPath()).append("; ");
            }
        }
        return backupFolders.toString();
    }

    public static BackupPolicyTO getCurrentPolicy(String bkDBUrl) {
        try {
            BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(bkDBUrl);
            List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
            if (currentDetails != null && !currentDetails.isEmpty()) {
                currentPolicy = currentDetails.get(0);
            }
            return currentPolicy;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " error in get CurrentPolicy");
            logger.error(e + "");
            e.printStackTrace();
            return currentPolicy;
        }
    }

    public static BackupPolicyTO getCurrentPolicy() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        if (currentDetails != null && !currentDetails.isEmpty()) {
            if (!"".equals(NotificationHelper.getCurrentPolicyName())) {
                for (BackupPolicyTO bkpPolicy : currentDetails) {
                    if (!bkpPolicy.getPolicyGroupName().equals(NotificationHelper.getCurrentPolicyName())) continue;
                    currentPolicy = bkpPolicy;
                }
            } else {
                currentPolicy = currentDetails.get(0);
            }
        }
        return currentPolicy;
    }

    public static void setFilterDetails() {
        Map<String, String> exclusionMap = backUpFolderDAOImpl.getInclusionExtensions();
        if (exclusionMap != null && !exclusionMap.isEmpty()) {
            FilesBeSkippedAsPerPolicy.extensions = exclusionMap.get("extensionName");
            String filterType = exclusionMap.get("filterType");
            FilesBeSkippedAsPerPolicy.filterType = StringUtils.isEmpty((String)filterType) ? "inclusion" : filterType;
        }
    }

    private static boolean isDriveValid(FileSystemView fsv, File file, String driveType) {
        String driveTypeToCompare = fsv.getSystemTypeDescription(file);
        logger.debug("drive and type: " + driveType);
        return driveTypeToCompare.equalsIgnoreCase(driveType);
    }

    public static String getrealPath(String pathString) {
        Path real = null;
        if (SettingHelper.getOsName().toLowerCase().contains("mac")) {
            pathString = PolicyManagementServerHelper.checkForMacBasePath(pathString);
        }
        Path path = Paths.get(pathString, new String[0]);
        String realPath = pathString;
        try {
            real = path.toRealPath(new LinkOption[0]);
            realPath = real.toAbsolutePath().toString();
            realPath = ObjectUtils.createParentPathForMacOrWin((String)realPath);
        }
        catch (IOException e) {
            logger.debug("Real path could not be created !", (Throwable)e);
        }
        logger.debug("Real path from system: " + realPath);
        return realPath;
    }

    public static String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        if (completeParentPath.startsWith("ROOT" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(4);
        }
        return completeParentPath;
    }

    private static void addExceptionsToExclusionsToTable(List<ExceptionsToExclusionElement> exceptionsToExclusions, String policyName) {
        ArrayList<BackupFolderTO> backupFolderTOList = new ArrayList<BackupFolderTO>();
        for (ExceptionsToExclusionElement exceptionsToExclusionElement : exceptionsToExclusions) {
            List folderPathElements = exceptionsToExclusionElement.getExceptionalFolderPathList();
            logger.debug("Adding Exceptional Folders from policy:");
            for (ExceptionsToExclusionsFolderPathElement folderPathElement : folderPathElements) {
                BackupFolderTO backupFolderTO = new BackupFolderTO();
                if (folderPathElement.getFolderPath().toLowerCase().contains(USERHOME_CONTAINS)) {
                    String newPath = folderPathElement.getFolderPath().toLowerCase().replace(USERHOME_CONTAINS, SettingHelper.getUserHome());
                    folderPathElement.setFolderPath(newPath);
                }
                if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                    PolicyManagementServerHelper.checkPreconditionsForFolderPath(folderPathElement);
                    String basePathOfTheFolder = folderPathElement.getFolderPath().substring(0, 3).replace("/", "\\");
                    if (!rootFilesList.contains(basePathOfTheFolder.toLowerCase())) {
                        logger.debug("Not Supported Drive....." + basePathOfTheFolder);
                        continue;
                    }
                }
                if (SettingHelper.getOsName().toLowerCase().contains("mac")) {
                    String macAppendedPath = "Macintosh" + StringLiterals.FILE_SEPARATOR + folderPathElement.getFolderPath();
                    folderPathElement.setFolderPath(macAppendedPath);
                }
                if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                    backupFolderTO.setFolderPath(folderPathElement.getFolderPath().toLowerCase().replace("/", "\\"));
                } else {
                    backupFolderTO.setFolderPath(folderPathElement.getFolderPath());
                }
                backupFolderTO.setCreateBy("IA");
                backupFolderTO.setPolicyName(policyName);
                logger.info(" " + backupFolderTO.getFolderPath());
                backupFolderTOList.add(backupFolderTO);
            }
        }
        backUpFolderDAOImpl.insertIntoExceptionsToExclusions(backupFolderTOList);
    }

    private static void checkPreconditionsForFolderPath(ExceptionsToExclusionsFolderPathElement folderPathElement) {
        if (folderPathElement.getFolderPath().length() < 3) {
            switch (folderPathElement.getFolderPath().length()) {
                case 1: {
                    folderPathElement.setFolderPath(new StringBuffer(folderPathElement.getFolderPath()).append(":\\").toString());
                    break;
                }
                case 2: {
                    folderPathElement.setFolderPath(new StringBuffer(folderPathElement.getFolderPath()).append("\\").toString());
                    break;
                }
                default: {
                    logger.debug("Path after verifying " + folderPathElement.getFolderPath());
                }
            }
        }
    }

    static String encodeBase64UTFString(String encodedString) {
        try {
            return Base64.encodeBase64String((byte[])encodedString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
            return encodedString;
        }
    }

    static {
        syncAdapter = new SyncAdapter(cloudName, keyStorePath);
        fullBackupInfoTableDAOImpl = new FullBackupInfoTableDAOImpl(SettingHelper.getBackUpDbUrl());
        currentPolicy = null;
    }
}

