/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.restore;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.epa.common.service.runnables.RestoreRestartRunnable;
import com.parablu.epa.common.service.runnables.RestoreRunnable;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.to.RestoreActivityTO;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadRestore {
    private Logger logger = LoggerFactory.getLogger(MultiThreadRestore.class);
    private Thread restoreThread = null;
    private Thread restartThread = null;
    final AtomicInteger noOfBatches = new AtomicInteger(0);
    private Timer backupWatchDogTimer = null;
    private TimerTask backupWatchDogTimerTask = null;
    private AtomicBoolean allThreadsStopped = new AtomicBoolean(false);
    private int count = 0;
    ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setNameFormat("multiThreadRestore-$$%d$$");
    int maxThreadCount = 0;
    ExecutorService multiPartRestoreService;
    AtomicInteger restoreCount = new AtomicInteger(0);
    AtomicLong restoredSize = new AtomicLong(0L);
    AtomicBoolean stopRestore = null;
    final BlockingQueue<Future<Integer>> finishedBatchesQueue = new LinkedBlockingQueue<Future<Integer>>();

    public MultiThreadRestore(String threadcount) {
        this.maxThreadCount = this.getMaxThreadCount(threadcount);
        this.logger.debug("Max count to use:" + this.maxThreadCount);
        this.multiPartRestoreService = Executors.newFixedThreadPool(this.maxThreadCount, this.factoryBuilder.build());
    }

    public int restoreFiles(String gatewayName, RestoreElement restoreElement, RestoreActivityTO activityTO, AtomicBoolean stopRestore1, Thread restoreThread1) {
        try {
            this.stopRestore = stopRestore1;
            this.restoreThread = restoreThread1;
            this.logger.debug("Activity to:" + activityTO.getRestoreBatchId());
            this.restoreCount.set(0);
            this.restoredSize.set(0L);
            this.restoreThread = new Thread(new RestoreRunnable(this.multiPartRestoreService, gatewayName, this.restoreCount, this.restoredSize, this.stopRestore, restoreElement, activityTO, this.finishedBatchesQueue, this.noOfBatches));
            this.restoreThread.start();
            this.restartThread = new Thread(new RestoreRestartRunnable(this.noOfBatches, this.finishedBatchesQueue, this.restoreThread, this.stopRestore, restoreElement));
            this.restartThread.start();
            this.startBackupWatchDog();
            try {
                this.restoreThread.join();
                this.restartThread.join();
                this.logger.debug("Restore job finished.......");
                this.allThreadsStopped.set(true);
                this.backupWatchDogTimer.cancel();
            }
            catch (InterruptedException e) {
                this.allThreadsStopped.set(true);
                this.interuptAllThreadAndShutdownServices(this.restoreThread, this.restartThread);
                this.backupWatchDogTimer.cancel();
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void awaitTerminationAfterShutdown(ExecutorService threadPool) {
        threadPool.shutdown();
        try {
            if (!threadPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                threadPool.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private int getMaxThreadCount(String maxCount) {
        int count = 3;
        if (StringUtils.isNotEmpty((String)maxCount)) {
            count = Integer.valueOf(maxCount);
        }
        this.logger.debug("Max count to use:" + count);
        return count;
    }

    public void startBackupWatchDog() {
        if (this.backupWatchDogTimer == null) {
            this.backupWatchDogTimer = new Timer();
        }
        if (this.backupWatchDogTimerTask == null) {
            this.backupWatchDogTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        int retryStopThreadsCount = 0;
                        if (MultiThreadRestore.this.stopRestore.get()) {
                            MultiThreadRestore.this.logger.debug("###############Inside thread nudged watch dogg################");
                            MultiThreadRestore.this.interuptAllThreadAndShutdownServices(MultiThreadRestore.this.restoreThread, MultiThreadRestore.this.restartThread);
                            Thread.currentThread().interrupt();
                            while (!MultiThreadRestore.this.allThreadsStopped.get()) {
                                MultiThreadRestore.this.printlogs("All threads not stopped so wait and intruupt");
                                MultiThreadRestore.this.interuptAllThreadAndShutdownServices(MultiThreadRestore.this.restoreThread, MultiThreadRestore.this.restartThread);
                                if (++retryStopThreadsCount < 50) continue;
                                MultiThreadRestore.this.allThreadsStopped.set(true);
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    catch (Exception e) {
                        MultiThreadRestore.this.logger.error("Error in Stop backup threads", (Throwable)e);
                        MultiThreadRestore.this.allThreadsStopped.set(true);
                    }
                }
            };
            this.backupWatchDogTimer.schedule(this.backupWatchDogTimerTask, 1L, 1L);
        }
    }

    private void interuptAllThreadAndShutdownServices(Thread restoreThread, Thread restartThread) {
        this.printlogs("REstore thread has been NUDGED");
        if (restoreThread.isAlive() && !restoreThread.isInterrupted()) {
            restoreThread.interrupt();
        }
        if (restartThread.isAlive() && !restartThread.isInterrupted()) {
            restartThread.interrupt();
        }
        if (this.multiPartRestoreService != null && !this.multiPartRestoreService.isShutdown()) {
            this.multiPartRestoreService.shutdownNow();
        }
        boolean isTerminated1 = true;
        try {
            if (this.multiPartRestoreService != null) {
                isTerminated1 = this.multiPartRestoreService.awaitTermination(1L, TimeUnit.SECONDS);
            }
            this.printlogs("Nudged thread is TERMINATE : " + isTerminated1);
        }
        catch (InterruptedException e1) {
            this.logger.debug("Nudged thread is TERMINATED : " + isTerminated1, (Object)e1.getMessage());
        }
        this.backupWatchDogTimer.cancel();
    }

    public void printlogs(String log) {
        if (this.count == 0) {
            this.logger.debug(log);
        }
        if ((long)this.count >= 60000000L) {
            this.count = -1;
        }
        ++this.count;
    }
}

