/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.BackupCrawlDAO;
import com.parablu.epa.core.to.BackUpCrawlFileTO;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupFolderTO;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupCrawlDAOImpl
extends BaseDAO
implements BackupCrawlDAO {
    private Logger logger = LoggerFactory.getLogger(BackupCrawlDAOImpl.class);
    private static final String DELETEFROM = "delete from ";
    private static final String SQLEXCEPTION_WHILE_DELETING = "SQLException while delete";

    public BackupCrawlDAOImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBackUpCrawlTable() {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = BluSyncSQLConstants.CREATE_BACKUP_FOLDER_CRAWL_TABLE_QUERY;
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while create backupCrawl table", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertFileNameIntoTable(File file) {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = "insert into CRAWLTABLE_(FileName,filepath) values(?,?);";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into CRAWLTABLE_(FileName,filepath) values(?,?);");
                    this.statement.setString(1, file.getName());
                    this.statement.setString(2, file.getAbsolutePath());
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while insert parent folder into backup crawl table", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackUpCrawlFileTO> getCrawlBackUpFiles() {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = "select * from CRAWLTABLE_";
            ArrayList<BackUpCrawlFileTO> files = null;
            this.statement = null;
            ResultSet resultSet = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("select * from CRAWLTABLE_");
                    resultSet = this.statement.executeQuery();
                    files = new ArrayList<BackUpCrawlFileTO>();
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            BackUpCrawlFileTO backUpCrawlFileTO = new BackUpCrawlFileTO();
                            backUpCrawlFileTO.setCompletePath(resultSet.getString("filepath"));
                            backUpCrawlFileTO.setId(resultSet.getInt("Id"));
                            files.add(backUpCrawlFileTO);
                        }
                    }
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while seelct from backup crawl tabel:", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set while seelct from backup crawl tabel :" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearTable(List<BackUpCrawlFileTO> crawlFileTOs) {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = "delete from CRAWLTABLE_ where Id in (" + this.fetchIds(crawlFileTOs) + ")";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    private String fetchIds(List<BackUpCrawlFileTO> crawlFileTO) {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        for (BackUpCrawlFileTO upCrawlFileTO : crawlFileTO) {
            sb.append(prefix);
            prefix = ",";
            sb.append(upCrawlFileTO.getId());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountOfTable() {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = "SELECT COUNT(*) FROM CRAWLTABLE_ where IsFolder = 'false';";
            this.statement = null;
            ResultSet resultSet = null;
            int count = 0;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("SELECT COUNT(*) FROM CRAWLTABLE_ where IsFolder = 'false';");
                    resultSet = this.statement.executeQuery();
                    while (resultSet.next()) {
                        count = resultSet.getInt(1);
                    }
                    resultSet.close();
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while counting backup crawl table", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException exception) {
                            this.logger.error("SQLException while closing result set for counting backup crawl table" + exception);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEntireTable() {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = "delete from CRAWLTABLE_";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("delete from CRAWLTABLE_");
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListOfFileNamesIntoTable(List<File> files) {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = "insert into CRAWLTABLE_(FileName,filepath,IsFolder) values(?,?,?);";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into CRAWLTABLE_(FileName,filepath,IsFolder) values(?,?,?);");
                    int listsize = files.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        this.statement.setString(1, files.get(recordCount).getName());
                        this.statement.setString(2, files.get(recordCount).getAbsolutePath());
                        this.statement.setString(3, String.valueOf(files.get(recordCount).isDirectory()));
                        this.statement.addBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while insert list of parent folders", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBackUpStatisticsCrawlTable() {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = BluSyncSQLConstants.CREATE_BACKUP_STATISTICS_CRAWL_TABLE_QUERY;
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while create backupCrawl table", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListOfFileNamesIntoBackupStatCrawlTable(List<File> files) {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = "insert into BKUP_STAT_CRAWL(filename,filepath) values(?,?);";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into BKUP_STAT_CRAWL(filename,filepath) values(?,?);");
                    int listsize = files.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        this.statement.setString(1, files.get(recordCount).getName());
                        this.statement.setString(2, files.get(recordCount).getAbsolutePath());
                        this.statement.addBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while insert list of files into backup crawl statistics folders", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEntireBackupStatCrawlTable() {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = "delete from BKUP_STAT_CRAWL";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("delete from BKUP_STAT_CRAWL");
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackUpCrawlFileTO> getBackupStatCrawlBackUpFiles() {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = "select * from BKUP_STAT_CRAWL";
            ArrayList<BackUpCrawlFileTO> files = null;
            this.statement = null;
            ResultSet resultSet = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("select * from BKUP_STAT_CRAWL");
                    resultSet = this.statement.executeQuery();
                    files = new ArrayList<BackUpCrawlFileTO>();
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            BackUpCrawlFileTO backUpCrawlFileTO = new BackUpCrawlFileTO();
                            backUpCrawlFileTO.setCompletePath(resultSet.getString("filepath"));
                            backUpCrawlFileTO.setId(resultSet.getInt("Id"));
                            files.add(backUpCrawlFileTO);
                        }
                    }
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while selct from backup crawl statistcs", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set for geting Previous Image Table Name" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alterTable() {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnectionForCreatingDatabase();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement("ALTER table CRAWLTABLE_ ADD COLUMN IsFolder TEXT;");
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.info("Exeception in CREATE_ACTIVITY_TABLE" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSnapshotCrawlTable() {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = BluSyncSQLConstants.CREATE_SNAPSHOT_FOLDER_CRAWL_TABLE_QUERY;
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                this.logger.debug("inisde if get connections" + query);
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while create SnapshotCrawlTable", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListOfSnapshotFileNamesIntoSnapshotCrawlTable(List<BackupFolderTO> file, BackupActivityTO activity) {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String status = activity.getBatchStatus();
            String batchId = activity.getBatchId();
            String tempBackupTimeStamp = activity.getBackupActivityTimeStamp();
            this.logger.debug("snapshot insert list" + tempBackupTimeStamp + " " + status + " " + batchId);
            String sqlQuery = new StringBuffer().append("INSERT INTO ").append("SNAPSHOTCRAWLTABLE").append(" (").append("batchID").append(",").append("batchStatus").append(",").append("timestamp").append(",").append("filepath").append(")").append(" Values(?,?,?,?);").toString();
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    int listsize = file.size();
                    String folderPaths = "";
                    String comma = "";
                    this.statement = this.conn.prepareStatement(sqlQuery);
                    this.statement.setString(1, batchId);
                    this.statement.setString(2, status);
                    this.statement.setString(3, tempBackupTimeStamp);
                    if (listsize != 0) {
                        for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                            folderPaths = folderPaths + comma + file.get(recordCount).getFolderPath();
                            comma = ",";
                        }
                    }
                    this.logger.debug("insertListOfSnapshotFileNamesIntoSnapshotCrawlTable.. " + folderPaths);
                    this.statement.setString(4, folderPaths);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while insert list of files into SnapshotCrawlTable", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupFolderTO> getSnapshotCrawlBackUpFiles(String batchId) {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            this.logger.debug("inside getSnapshotCrawlBackUpFiles");
            this.logger.debug("batchId-->" + batchId);
            String query = "select * from SNAPSHOTCRAWLTABLE WHERE batchID=='" + batchId + "'";
            this.logger.debug("query-->" + query);
            ArrayList<BackupFolderTO> files = new ArrayList<BackupFolderTO>();
            this.statement = null;
            ResultSet resultSet = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    resultSet = this.statement.executeQuery();
                    List<Object> folderPaths = new ArrayList();
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            String filePath = resultSet.getString("filepath");
                            folderPaths = Arrays.asList(filePath.split(","));
                        }
                        for (String filePath : folderPaths) {
                            BackupFolderTO backupFolderTO = new BackupFolderTO();
                            backupFolderTO.setFolderPath(filePath);
                            files.add(backupFolderTO);
                        }
                    }
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while selct from SnapshotCrawlTable", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set for getting list of files from SnapshotCrawlTable" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEntireSnapshotCrawlTable() {
        BackupCrawlDAOImpl backupCrawlDAOImpl = this;
        synchronized (backupCrawlDAOImpl) {
            String query = "delete from SNAPSHOTCRAWLTABLE";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("delete from SNAPSHOTCRAWLTABLE");
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }
}

