/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.google.gson.JsonPrimitive;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.DriveItemCreateUploadSessionParameterSet;
import com.microsoft.graph.models.DriveSearchParameterSet;
import com.microsoft.graph.models.Folder;
import com.microsoft.graph.models.UploadSession;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.DriveItemCollectionRequest;
import com.microsoft.graph.requests.DriveRequestBuilder;
import com.microsoft.graph.requests.DriveSearchCollectionPage;
import com.microsoft.graph.requests.DriveSearchCollectionRequest;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.serializer.AdditionalDataManager;
import com.microsoft.graph.serializer.DefaultSerializer;
import com.microsoft.graph.tasks.IProgressCallback;
import com.microsoft.graph.tasks.IUploadSession;
import com.microsoft.graph.tasks.LargeFileUploadTask;
import com.parablu.microsoft.graph.models.extensions.PBDriveItemUploadableProperties;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.domain.BlackListUser;
import com.parablu.pcbd.domain.MSGTokens;
import com.pg.controller.Graph;
import com.pg.dao.FileDao;
import com.pg.dao.Office365Dao;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.odb.util.OneDriveUtil;
import com.pg.service.GraphUploadService;
import com.pg.service.UtilService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class GraphUploadServiceImpl
implements GraphUploadService {
    private static Logger logger = LogManager.getLogger(GraphUploadServiceImpl.class);
    private FileDao fileDao;
    private Office365Dao office365Dao;
    @Autowired
    private UtilService utilService;
    @Autowired
    private PciAuthorizationTokensDao pciAuthorizationTokensDao;
    private static final String BEARER = "Bearer ";
    private static final String PARACLOUD_CLOUD_PATH = "/paracloud/cloud/";
    private static final String BLACK_LIST_USERS = "BlackListUsers";
    private static final String COUNT_429 = "CountOf429";
    public static DefaultSerializer serializer;

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setOffice365Dao(Office365Dao office365Dao) {
        this.office365Dao = office365Dao;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    @Override
    public FileStatusElement uploadFileToODB(PciAuthorizationTokenElement pciTokenElement, File encryptedFile, String cloudStoragePath, String deviceUUID, String gateWayName, String uploadingFileName, FileStatusElement fileStatusElement, String driveId, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        String encodedFileName = "";
        PciAuthorizationTokenElement pciTokenElementTemp = pciTokenElement;
        FileStatusElement element = new FileStatusElement();
        logger.debug("...inside uploade..." + pciTokenElementTemp.getUserName());
        if (pciTokenElementTemp != null) {
            String userName = pciTokenElementTemp.getUserName();
            String accountId = pciTokenElementTemp.getAccountId();
            String pbFolderName = this.office365Dao.getOdbFolderName(1);
            if (StringUtils.isEmpty((String)pbFolderName)) {
                pbFolderName = "PB";
            }
            logger.debug("%^%^%^%^%^%^%^ AFTER...." + uploadingFileName);
            encodedFileName = this.convertStringTOBase64(uploadingFileName).replaceAll("/", "_");
            FileStatusElement writeElement = this.write(pciTokenElementTemp.getSharePointUrl(), encryptedFile, accountId, userName, pciTokenElementTemp, cloudStoragePath, encodedFileName, false, pbFolderName, deviceUUID, gateWayName, fileStatusElement, driveId, graphClient, okHttpClient);
            boolean uploadSuccess = writeElement.isUploadStatus();
            element.setUploadStatuscode(writeElement.getUploadStatuscode());
            if (!uploadSuccess) {
                encodedFileName = "";
            }
            element.setEncodedFileName(encodedFileName);
        }
        return element;
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString((String)deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    private Drive getDriveForUser(int cloudId, String userName) {
        Drive drive = null;
        try {
            GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + userName + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + userName);
            drive = graphClient.users(userId).drive().buildRequest(new Option[0]).get();
            if (drive != null) {
                logger.debug(userName + "....drive id for user ... " + drive.id);
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    drive = this.getDriveForUser(cloudId, userName);
                }
                catch (InterruptedException interruptedException) {}
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + userName);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return drive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int uploadPBGraph(String emailId, File file, String userFolder, String path, String encodedFileName, String driveId) {
        int responseCode;
        block17: {
            responseCode = 500;
            InputStream inputStream = null;
            GraphServiceClient<Request> graphClient = null;
            try {
                graphClient = OneDriveUtil.getGraphClient();
                DriveRequestBuilder pbdrive1 = graphClient.drives(driveId);
                PBDriveItemUploadableProperties driveItemUploadableProperties = new PBDriveItemUploadableProperties();
                inputStream = new FileInputStream(file);
                int fileSize = inputStream.available();
                IProgressCallback callback = new IProgressCallback(){

                    public void progress(long current, long max) {
                        logger.debug(String.format("Uploaded %d bytes of %d total bytes", current, max));
                    }
                };
                AdditionalDataManager additionalDataManager = driveItemUploadableProperties.additionalDataManager();
                additionalDataManager.put((Object)"@microsoft.graph.conflictBehavior", (Object)new JsonPrimitive("replace"));
                logger.debug(path + "...graph api file upload started fail if conflict happens... " + encodedFileName);
                DriveItemCreateUploadSessionParameterSet createUploadSessionParameterSet = new DriveItemCreateUploadSessionParameterSet();
                createUploadSessionParameterSet.item = driveItemUploadableProperties;
                UploadSession uploadSession = pbdrive1.root().itemWithPath(userFolder + "/" + path + "/" + encodedFileName).createUploadSession(createUploadSessionParameterSet).buildRequest(new Option[0]).post();
                LargeFileUploadTask largeFileUploadTask = new LargeFileUploadTask((IUploadSession)uploadSession, graphClient, inputStream, (long)fileSize, DriveItem.class);
                largeFileUploadTask.upload(0x320000, null, callback);
                logger.debug("graph api file upload ended ... ");
                responseCode = 201;
            }
            catch (GraphServiceException e) {
                graphClient = null;
                logger.error("Graph excecption:", (Object)e.getMessage());
                if (e.getResponseCode() == 409) {
                    responseCode = 409;
                    logger.error("inside conflict exception so return.");
                    break block17;
                }
                throw e;
            }
            catch (IOException e) {
                logger.error(".... exception......" + e.getMessage());
            }
            finally {
                graphClient = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return responseCode;
    }

    public static void main(String[] args) {
    }

    public static int uploadGraph(String emailId, File file, String path, String encodedFileName, String driveId) {
        int responseCode = 500;
        try {
            GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
            DriveRequestBuilder pbdrive1 = graphClient.drives(driveId);
            PBDriveItemUploadableProperties driveItemUploadableProperties = new PBDriveItemUploadableProperties();
            FileInputStream inputStream = new FileInputStream(file);
            int fileSize = ((InputStream)inputStream).available();
            IProgressCallback callback = new IProgressCallback(){

                public void progress(long current, long max) {
                    logger.debug(String.format("Uploaded %d bytes of %d total bytes", current, max));
                }
            };
            AdditionalDataManager additionalDataManager = driveItemUploadableProperties.additionalDataManager();
            additionalDataManager.put((Object)"@microsoft.graph.conflictBehavior", (Object)new JsonPrimitive("fail"));
            logger.debug(path + "...graph api file upload started fail if conflict happens... " + encodedFileName);
            DriveItemCreateUploadSessionParameterSet createUploadSessionParameterSet = new DriveItemCreateUploadSessionParameterSet();
            createUploadSessionParameterSet.item = driveItemUploadableProperties;
            UploadSession uploadSession = pbdrive1.root().itemWithPath(path + "/" + encodedFileName).createUploadSession(createUploadSessionParameterSet).buildRequest(new Option[0]).post();
            LargeFileUploadTask largeFileUploadTask = new LargeFileUploadTask((IUploadSession)uploadSession, graphClient, (InputStream)inputStream, (long)fileSize, DriveItem.class);
            largeFileUploadTask.upload(0x320000, null, callback);
            logger.debug("graph api file upload ended ... ");
            responseCode = 201;
        }
        catch (IOException e) {
            logger.error(".... exception......" + e.getMessage());
        }
        return responseCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private FileStatusElement write(String sharePointURL, File file, String accountId, String userName, PciAuthorizationTokenElement pciTokenElement, String cloudStoragePath, String encodedFileName, boolean uploadAdminAcc, String pbFolderName, String deviceUUID, String gateWayName, FileStatusElement fileStatusElement, String driveId, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        Object obj;
        int responseCode;
        boolean isProxyEnabled;
        int port;
        String host;
        String password;
        String proxyUserName;
        CloseableHttpClient httpclient;
        CloseableHttpResponse result;
        String fileUrl;
        boolean uploadSuccess;
        int cloudId;
        String userNameToGetUrl;
        FileStatusElement element;
        PciAuthorizationTokenElement pciTokenElementTemp;
        block69: {
            Set blackUsersList;
            pciTokenElementTemp = pciTokenElement;
            element = new FileStatusElement();
            userNameToGetUrl = userName;
            cloudId = 1;
            uploadSuccess = false;
            OneDriveUtil odbUtil = OneDriveUtil.getInstance();
            if (!uploadAdminAcc) {
                userNameToGetUrl = "";
            }
            if (!StringUtils.isEmpty((String)deviceUUID)) {
                userNameToGetUrl = GraphUploadServiceImpl.getUniqueODUserFolder(deviceUUID);
                logger.debug("....device unique id ....... " + userNameToGetUrl);
            }
            if (StringUtils.isEmpty((String)driveId)) {
                element.setUploadStatus(false);
                return element;
            }
            fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root:/" + userNameToGetUrl + "/" + cloudStoragePath + "/" + encodedFileName + ":/content";
            logger.debug(file.length() + "...graph url>>>>>>>>>>>" + fileUrl);
            logger.debug("..check THROTTLE_DECOR..............." + driveId + "...use.." + userNameToGetUrl + "..path.." + cloudStoragePath + "..enc.." + encodedFileName);
            result = null;
            httpclient = null;
            proxyUserName = PCHelperConstant.getProxyUserName();
            password = PCHelperConstant.getProxyPassword();
            host = PCHelperConstant.getProxyHost();
            port = PCHelperConstant.getProxyPort();
            isProxyEnabled = false;
            responseCode = 0;
            obj = MemoryStore.get((String)BLACK_LIST_USERS);
            if (obj == null || !(blackUsersList = (Set)obj).contains(userName)) break block69;
            logger.debug("...user is blacklisted.... " + userName);
            element.setUploadStatus(false);
            element.setUploadStatuscode(555);
            FileStatusElement fileStatusElement2 = element;
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
            return fileStatusElement2;
        }
        try {
            if (!StringUtils.isEmpty((String)driveId)) {
                Response response;
                Call call;
                Request request2;
                RequestBody body;
                if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                    httpclient = HttpClients.createDefault();
                    logger.debug(" filelengths ...." + file.length());
                    if (file.length() > 4000000L) {
                        try {
                            responseCode = GraphUploadServiceImpl.uploadPBGraph(accountId, file, userNameToGetUrl, cloudStoragePath, encodedFileName, driveId);
                        }
                        catch (GraphServiceException e) {
                            logger.error(".... exception......" + e.getMessage());
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            responseCode = GraphUploadServiceImpl.uploadPBGraph(accountId, file, userNameToGetUrl, cloudStoragePath, encodedFileName, driveId);
                        }
                        logger.debug("... large fileuploaded usinggraph...." + responseCode);
                    } else {
                        logger.debug("..uploading small file... ");
                        body = RequestBody.create((byte[])FileUtils.readFileToByteArray((File)file));
                        request2 = new Request.Builder().url(fileUrl).put(body).build();
                        call = okHttpClient.newCall(request2);
                        response = call.execute();
                        responseCode = response.code();
                        logger.debug("...fileuploaded usinggraph...." + responseCode);
                        response.close();
                    }
                } else {
                    httpclient = HttpClients.createDefault();
                    logger.debug(" filelengths ...." + file.length());
                    if (file.length() > 4000000L) {
                        try {
                            responseCode = GraphUploadServiceImpl.uploadPBGraph(accountId, file, userNameToGetUrl, cloudStoragePath, encodedFileName, driveId);
                        }
                        catch (GraphServiceException e) {
                            logger.error(".... exception......" + e.getMessage());
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException request2) {
                                // empty catch block
                            }
                            responseCode = GraphUploadServiceImpl.uploadPBGraph(accountId, file, userNameToGetUrl, cloudStoragePath, encodedFileName, driveId);
                        }
                        logger.debug("... large fileuploaded usinggraph...." + responseCode);
                    } else {
                        logger.debug("..uploading small file... ");
                        body = RequestBody.create((byte[])FileUtils.readFileToByteArray((File)file));
                        request2 = new Request.Builder().url(fileUrl).put(body).build();
                        call = okHttpClient.newCall(request2);
                        response = call.execute();
                        responseCode = response.code();
                        logger.debug("...fileuploaded usinggraph...." + responseCode);
                        response.close();
                    }
                }
            } else {
                logger.error("..driveid is empty.... so return 403");
                responseCode = 403;
            }
            String pathTobeCreated = cloudStoragePath;
            if (!StringUtils.isEmpty((String)userNameToGetUrl)) {
                pathTobeCreated = userNameToGetUrl + "/" + cloudStoragePath;
            }
            if (responseCode == 200 || responseCode == 201 || responseCode == 409) {
                logger.debug("..graph success writing..." + responseCode);
                this.remove429Count();
                uploadSuccess = true;
                if (responseCode == 200) {
                    fileStatusElement.setChunkAlreadyExist(uploadSuccess);
                }
                this.utilService.deleteBlackListUserByUserName(cloudId, userName);
            } else if (responseCode == 401) {
                uploadSuccess = false;
                logger.error(" ... token expired so try after 1 min ... ");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException request) {
                    // empty catch block
                }
                pciTokenElementTemp = this.office365Dao.getMSGTokenElement(1, pciTokenElementTemp.getUserName());
                if (pciTokenElementTemp != null) {
                    uploadSuccess = this.retryWrite(sharePointURL, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId, graphClient, okHttpClient);
                }
            } else {
                String userBlockedForWrite;
                BlackListUser blackListUserObj = this.utilService.getBlackListUserbyNameAndLocalHost(cloudId, userName, gateWayName);
                if (responseCode == 403) {
                    try {
                        logger.debug("%%%%%%%%%%%%%%%%%%%%%%%%%%%INSIDE403..................." + pathTobeCreated);
                        boolean success = this.createLibraryIfNotExistsUsingGraph(driveId, userNameToGetUrl, cloudStoragePath);
                        uploadSuccess = false;
                        if (success) {
                            uploadSuccess = this.retryWrite(sharePointURL, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId, graphClient, okHttpClient);
                        } else {
                            this.utilService.updateUserBackupTargetStatus(cloudId, userName, 403);
                            userBlockedForWrite = "403_" + userName;
                            obj = MemoryStore.get((String)userBlockedForWrite);
                            if (obj == null) {
                                MemoryStore.add((String)userBlockedForWrite, (Object)userName, (long)1800000L);
                                if (blackListUserObj == null) {
                                    BlackListUser blackListUser = new BlackListUser();
                                    blackListUser.setResponseCode("403");
                                    blackListUser.setUserName(userName);
                                    blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                                    this.utilService.saveBlackListUser(cloudId, blackListUser);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("..responseCode 403..... " + e.getMessage());
                        logger.error("..responseCode 403..... " + e);
                    }
                } else if (responseCode == 404) {
                    logger.debug("...before calling createLibraryIfNotExistsUsingGraph... " + pathTobeCreated);
                    boolean success = this.createLibraryIfNotExistsUsingGraph(driveId, userNameToGetUrl, cloudStoragePath);
                    if (!success) {
                        if ((pciTokenElementTemp = this.office365Dao.getMSGTokenElement(1, pciTokenElementTemp.getUserName())) != null) {
                            success = this.createLibraryIfNotExistsUsingGraph(driveId, userNameToGetUrl, cloudStoragePath);
                            if (success) {
                                uploadSuccess = this.retryWrite(sharePointURL, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId, graphClient, okHttpClient);
                            } else {
                                this.utilService.updateUserBackupTargetStatus(cloudId, userName, 404);
                                logger.debug(" user not mapped .... " + userName);
                                uploadSuccess = false;
                                userBlockedForWrite = "404_" + userName;
                                obj = MemoryStore.get((String)userBlockedForWrite);
                                if (obj == null) {
                                    MemoryStore.add((String)userBlockedForWrite, (Object)userName, (long)1800000L);
                                    if (blackListUserObj == null) {
                                        BlackListUser blackListUser = new BlackListUser();
                                        blackListUser.setResponseCode("404");
                                        blackListUser.setUserName(userName);
                                        blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                                        this.utilService.saveBlackListUser(cloudId, blackListUser);
                                    } else if (!blackListUserObj.getResponseCode().equalsIgnoreCase("404")) {
                                        this.utilService.updateBlackListUserWithCode(cloudId, userName, gateWayName, "404");
                                    }
                                } else if (blackListUserObj != null && !blackListUserObj.getResponseCode().equalsIgnoreCase("404")) {
                                    this.utilService.updateBlackListUserWithCode(cloudId, userName, gateWayName, "404");
                                }
                            }
                        }
                    } else {
                        logger.debug("...why failed ..." + responseCode);
                        uploadSuccess = false;
                        uploadSuccess = this.retryWrite(sharePointURL, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId, graphClient, okHttpClient);
                    }
                } else if (responseCode == 400) {
                    String chunkPath = userNameToGetUrl + "/" + cloudStoragePath;
                    uploadSuccess = this.checkIfFileAlreadyExists(userNameToGetUrl, chunkPath, encodedFileName, pbFolderName, proxyUserName, password, host, port, driveId);
                    fileStatusElement.setChunkAlreadyExist(uploadSuccess);
                } else if (responseCode != 200 && responseCode != 201 && responseCode != 409) {
                    logger.debug("... why failed ..." + responseCode);
                    if (responseCode == 429) {
                        try {
                            try {
                                Object countOf429 = MemoryStore.get((String)COUNT_429);
                                logger.debug("....429 get count " + countOf429);
                                if (countOf429 != null) {
                                    int count = (Integer)countOf429 + 1;
                                    logger.debug("....429 adding count " + count);
                                    MemoryStore.add((String)COUNT_429, (Object)count++, (long)1800000L);
                                } else {
                                    logger.debug("....429 user ading count 1");
                                    MemoryStore.add((String)COUNT_429, (Object)1, (long)1800000L);
                                }
                            }
                            catch (Exception e) {
                                logger.trace("" + e);
                                logger.error("Exception While adding in 429 count :" + e.getMessage());
                            }
                            String value = result.getFirstHeader("Retry-After").getValue();
                            logger.debug("*****************429head**************************" + value);
                            long waitTime = Long.parseLong(value);
                            long addn429wait = PCHelperConstant.getAddn429WaitMultiplier();
                            long millis = addn429wait * waitTime * 1000L;
                            this.closeResponse(result);
                            this.closeHttpClient(httpclient);
                            logger.debug("...Sleeping for " + waitTime + "..milli..." + millis + "....for userName..." + userName);
                            logger.debug("...PB429User..." + userName + "...resp code..." + responseCode + "..odbwait.." + waitTime + "..pbwait.." + addn429wait + "..millis to wait.." + millis);
                            this.sleepForGivenTime(millis);
                            logger.debug("...sleep completed........for userName..." + userName);
                        }
                        catch (Exception e) {
                            logger.trace("" + e);
                            logger.error("Exception While Writting :" + e.getMessage());
                        }
                    }
                    uploadSuccess = false;
                    uploadSuccess = this.retryWrite(sharePointURL, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId, graphClient, okHttpClient);
                }
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        }
        catch (GraphServiceException ee) {
            uploadSuccess = false;
            logger.error("......graph exception ..." + ee.getMessage());
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        }
        catch (Exception e) {
            uploadSuccess = false;
            logger.trace("" + e);
            logger.error("Exception While Writting :" + e.getMessage());
            uploadSuccess = this.retryWrite(sharePointURL, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId, graphClient, okHttpClient);
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
            {
                catch (Throwable throwable) {
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    throw throwable;
                }
            }
        }
        if (!uploadSuccess) {
            logger.debug("Response code...:" + responseCode + " for the userName..." + userName);
        }
        if (!uploadSuccess && responseCode != 429 && responseCode != 503 && responseCode != 409) {
            Set<String> blackUsersList = new HashSet<String>();
            Object obj2 = MemoryStore.get((String)BLACK_LIST_USERS);
            if (obj2 != null) {
                blackUsersList = (Set)obj2;
            }
            blackUsersList.add(userName.toLowerCase());
            logger.debug("......marking user as blacklisted ..code..." + responseCode);
            MemoryStore.add((String)BLACK_LIST_USERS, blackUsersList, (long)1800000L);
        }
        element.setUploadStatus(uploadSuccess);
        element.setUploadStatuscode(responseCode);
        return element;
    }

    private void closeHttpClient(CloseableHttpClient httpclient) {
        if (httpclient != null) {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    private void closeResponse(CloseableHttpResponse result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (IOException e) {
                logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    private void remove429Count() {
        try {
            logger.debug("....429 inside remove429Count");
            Object countOf429 = MemoryStore.get((String)COUNT_429);
            if (countOf429 != null) {
                logger.debug("....429 get count for 200 case " + countOf429);
                MemoryStore.delete((String)COUNT_429);
            } else {
                logger.debug("....429 count is empty");
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While adding in 429 count :" + e.getMessage());
        }
    }

    private boolean checkIfFileAlreadyExists(String userNameFol, String cloudStoragePath, String encodedFileName, String pbFolderName, String proxyUserName, String password, String host, int port, String driveId) {
        boolean uploadSuccess = false;
        String downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)userNameFol, (String)cloudStoragePath, (String)encodedFileName);
        logger.debug(" .........graph api new download url from helper................." + downloadurl);
        try {
            Response result = this.executeDownload(proxyUserName, password, host, port, downloadurl);
            int responseCode = result.code();
            logger.debug(" Response status code: " + responseCode);
            if (responseCode == 200) {
                uploadSuccess = true;
                logger.debug(" ... already exists ..." + responseCode);
            }
            result.close();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Downloading File From One Drive :" + e.getMessage());
        }
        return uploadSuccess;
    }

    private Response executeDownload(String proxyUserName, String password, String host, int port, String downloadurl) throws IOException, ClientProtocolException {
        Response result;
        if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
            logger.debug(" without proxy ....");
            OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
            Request request = new Request.Builder().url(downloadurl).addHeader("Accept", "application/json;odata=verbose").addHeader("Content-Type", "*/*").build();
            result = okHttpClient.newCall(request).execute();
        } else {
            logger.debug(" using proxy ....");
            OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
            Request request = new Request.Builder().url(downloadurl).addHeader("Accept", "application/json;odata=verbose").addHeader("Content-Type", "*/*").build();
            result = okHttpClient.newCall(request).execute();
        }
        logger.debug("...Inside execute..." + result.code());
        return result;
    }

    private boolean retryWrite(String sharePointURL, File file, String accountId, String encodedFolderPath, PciAuthorizationTokenElement pciTokenElement, String cloudStoragePath, String encodedFileName, String pbFolderName, boolean proxyEnabled, String gateWayName, FileStatusElement fileStatusElement, String userName1, String driveId, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        boolean retry;
        int retryCount = 0;
        int sleepMultiplier = 1;
        int cloudId = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        Response response = null;
        boolean uploadSuccess = false;
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        do {
            retry = false;
            uploadSuccess = true;
            try {
                BlackListUser blackListUser;
                Object obj;
                String userBlockedForWrite;
                Object obj2;
                String userBlockedForWrite2;
                String value;
                Headers headers;
                Request request;
                RequestBody body2;
                String fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root:/" + encodedFolderPath + "/" + cloudStoragePath + "/" + encodedFileName + ":/content";
                logger.debug("..RETRY THROTTLE_DECOR...............");
                int responseCode = 0;
                if (!proxyEnabled) {
                    if (file.length() > 4000000L) {
                        try {
                            responseCode = GraphUploadServiceImpl.uploadPBGraph(accountId, file, encodedFolderPath, cloudStoragePath, encodedFileName, driveId);
                        }
                        catch (GraphServiceException e) {
                            logger.error(".... exception......" + e.getMessage());
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            responseCode = GraphUploadServiceImpl.uploadPBGraph(accountId, file, encodedFolderPath, cloudStoragePath, encodedFileName, driveId);
                        }
                    } else {
                        body2 = RequestBody.create((byte[])FileUtils.readFileToByteArray((File)file));
                        request = new Request.Builder().url(fileUrl).put(body2).build();
                        Call call = okHttpClient.newCall(request);
                        response = call.execute();
                        responseCode = response.code();
                    }
                } else {
                    body2 = RequestBody.create((byte[])FileUtils.readFileToByteArray((File)file));
                    request = new Request.Builder().url(fileUrl).put(body2).build();
                    Call call = okHttpClient.newCall(request);
                    response = call.execute();
                    responseCode = response.code();
                    logger.debug("...less than 4 mb with proxy success...." + responseCode);
                }
                logger.debug("Response status code: " + responseCode);
                if (responseCode == 401) {
                    logger.error(" ... token expired so try after 1 min ... ");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException body2) {
                        // empty catch block
                    }
                    uploadSuccess = false;
                    retry = true;
                    ++retryCount;
                } else if (responseCode == 429) {
                    uploadSuccess = false;
                    retry = true;
                    retryCount = 3;
                    try {
                        headers = response.headers();
                        value = headers.get("Retry-After");
                        logger.debug("*****************429head**************************" + value);
                        long waitTime = Long.parseLong(value);
                        userBlockedForWrite2 = "429_" + userName1;
                        obj2 = MemoryStore.get((String)userBlockedForWrite2);
                        if (obj2 == null) {
                            MemoryStore.add((String)userBlockedForWrite2, (Object)userName1, (long)(waitTime * 1000L));
                            if (this.utilService.getBlackListUserbyNameAndLocalHost(cloudId, userName1, gateWayName) == null) {
                                BlackListUser blackListUser2 = new BlackListUser();
                                blackListUser2.setResponseCode("429");
                                blackListUser2.setUserName(userName1);
                                blackListUser2.setLocalHost(gateWayName);
                                blackListUser2.setWaitTime(waitTime);
                                this.utilService.saveBlackListUser(cloudId, blackListUser2);
                            }
                        }
                        long millis = waitTime * 1000L;
                        logger.debug("...Sleeping for " + waitTime + "..milli..." + millis + "....for userName..." + userName1);
                        this.sleepForGivenTime(millis);
                    }
                    catch (Exception e) {
                        logger.debug("Exception while retry....." + e.getMessage());
                        logger.debug("Exception while retry....." + e);
                    }
                } else if (responseCode == 403) {
                    userBlockedForWrite = "403_" + userName1;
                    this.utilService.updateUserBackupTargetStatus(cloudId, userName1, 403);
                    obj = MemoryStore.get((String)userBlockedForWrite);
                    if (obj == null) {
                        MemoryStore.add((String)userBlockedForWrite, (Object)userName1, (long)1800000L);
                        if (this.utilService.getBlackListUserbyNameAndLocalHost(cloudId, userName1, gateWayName) == null) {
                            blackListUser = new BlackListUser();
                            blackListUser.setResponseCode("403");
                            blackListUser.setUserName(userName1);
                            blackListUser.setLocalHost(gateWayName);
                            this.utilService.saveBlackListUser(cloudId, blackListUser);
                        }
                    }
                    uploadSuccess = false;
                } else if (responseCode == 404) {
                    userBlockedForWrite = "404_" + userName1;
                    this.utilService.updateUserBackupTargetStatus(cloudId, userName1, 404);
                    obj = MemoryStore.get((String)userBlockedForWrite);
                    if (obj == null) {
                        MemoryStore.add((String)userBlockedForWrite, (Object)userName1, (long)1800000L);
                        if (this.utilService.getBlackListUserbyNameAndLocalHost(cloudId, userName1, gateWayName) == null) {
                            blackListUser = new BlackListUser();
                            blackListUser.setResponseCode("404");
                            blackListUser.setUserName(userName1);
                            blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                            this.utilService.saveBlackListUser(cloudId, blackListUser);
                        }
                    }
                    uploadSuccess = false;
                } else if (responseCode == 400) {
                    String chunkPath = encodedFolderPath + "/" + cloudStoragePath;
                    uploadSuccess = this.checkIfFileAlreadyExists(encodedFolderPath, chunkPath, encodedFileName, pbFolderName, proxyUserName, password, host, port, driveId);
                    fileStatusElement.setChunkAlreadyExist(uploadSuccess);
                } else if (responseCode != 200 || responseCode != 201) {
                    if (responseCode == 503) {
                        if (response != null && response.headers().get("Retry-After") != null) {
                            headers = response.headers();
                            value = headers.get("Retry-After");
                            try {
                                logger.debug("*****************503 head**************************" + value);
                                long waitTime = Long.parseLong(value);
                                userBlockedForWrite2 = "503_" + userName1;
                                obj2 = MemoryStore.get((String)userBlockedForWrite2);
                                if (obj2 == null) {
                                    MemoryStore.add((String)userBlockedForWrite2, (Object)userName1, (long)(waitTime * 1000L));
                                    if (this.utilService.getBlackListUserbyNameAndLocalHost(cloudId, userName1, gateWayName) == null) {
                                        BlackListUser blackListUser3 = new BlackListUser();
                                        blackListUser3.setResponseCode("503");
                                        blackListUser3.setUserName(userName1);
                                        blackListUser3.setLocalHost(PCHelperConstant.getComponentName());
                                        this.utilService.saveBlackListUser(cloudId, blackListUser3);
                                    }
                                }
                            }
                            catch (Exception e) {
                                logger.debug("Exception while retry....." + e.getMessage());
                                logger.debug("Exception while retry....." + e);
                            }
                            logger.debug("......retry for 503...... " + value);
                        } else {
                            logger.debug("result is null and status code is 503....");
                        }
                    }
                    uploadSuccess = false;
                    retry = true;
                    retryCount = 3;
                }
                if (responseCode != 200 && responseCode != 201) continue;
                uploadSuccess = true;
                this.utilService.deleteBlackListUserByUserName(cloudId, userName1);
            }
            catch (UnknownHostException e) {
                logger.error("unknown host exception .... " + e.getMessage());
                logger.error("unknown host exception .... " + e);
                uploadSuccess = false;
                retry = true;
                retryCount = 2;
            }
            catch (SocketException e) {
                logger.error("....SocketException exception .... " + e.getMessage());
                logger.error("....SocketException exception .... " + e);
                uploadSuccess = false;
                retry = true;
                retryCount = 2;
            }
            catch (Exception e) {
                uploadSuccess = false;
                retry = true;
                ++retryCount;
                sleepTime = this.sleepForGivenTime(sleepTime);
                logger.trace("" + e);
                logger.error("Exception While Retrying Writting :" + e.getMessage());
            }
        } while (retry && retryCount < 3);
        return uploadSuccess;
    }

    private long sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            logger.debug("SleepTime is" + sleepTimeTemp);
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException e1) {
            logger.error("Thread interupted error");
        }
        return sleepTimeTemp;
    }

    @Override
    public PciAuthorizationTokenElement getAccessToken(PciAuthorizationTokenElement pciAuthorizationTokenElement) {
        return this.office365Dao.getAccessToken(pciAuthorizationTokenElement);
    }

    @Override
    public long getThreadSize(String cloudName) {
        return this.fileDao.getThreadSize(cloudName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deleteEntryForBackup(String backupId, String cloudName, String userName, String dedupedBkId) {
        logger.debug("Delete entry for backup ..... ");
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        HttpResponse response = null;
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD_PATH + cloudName + "/externalbackup/" + userName + "/delete/";
        HttpPost httpPost = new HttpPost(url);
        try {
            Header[] headerarr;
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("backupId", (ContentBody)new StringBody(backupId));
            entity.addPart("dedupedBkId", (ContentBody)new StringBody(dedupedBkId));
            httpPost.setEntity((HttpEntity)entity);
            response = httpclient.execute((HttpUriRequest)httpPost);
            for (Header header : headerarr = response.getAllHeaders()) {
                if (!"isFileDeleted".equals(header.getName())) continue;
                logger.debug("Deleted backup Id for file ..... " + header.getName());
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Deleting Entry For Backup :" + e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
        }
        return backupId;
    }

    private String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5((String)name);
            byte[] bytesEncoded = Base64.encodeBase64((byte[])bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            logger.debug("ecncoded value for given string is " + base64EncodeString);
        }
        return base64EncodeString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCountOfFilesInFolder(PciAuthorizationTokenElement ppciTokenElement, String cloudStoragePath, String deviceUUID) {
        String userNameToGetUrl = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            userNameToGetUrl = GraphUploadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameToGetUrl);
        }
        PciAuthorizationTokenElement pciTokenElement = ppciTokenElement;
        String pbFolderName = this.office365Dao.getOdbFolderName(1);
        String paraBluFolderPath = PCHelperConstant.getParabluLibraryUrl((String)pciTokenElement.getSharePointUrl(), (String)pciTokenElement.getAccountId(), (String)userNameToGetUrl, (String)cloudStoragePath, (String)pbFolderName);
        logger.debug(" latest PATH from onedrive ............ " + paraBluFolderPath);
        int count = 0;
        String fileUrl = paraBluFolderPath + "/itemcount";
        HttpGet httpGet = new HttpGet(fileUrl);
        httpGet.addHeader("Authorization", BEARER + pciTokenElement.getAccessToken());
        HttpResponse result = null;
        HttpClient httpclient = null;
        try {
            String proxyUserName = PCHelperConstant.getProxyUserName();
            String password = PCHelperConstant.getProxyPassword();
            String host = PCHelperConstant.getProxyHost();
            int port = PCHelperConstant.getProxyPort();
            if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                logger.debug(" #$##$@$ without proxy .getCountOfFilesInFolder.." + fileUrl);
                httpclient = HttpClientUtil.getSSlConnection();
                result = httpclient.execute((HttpUriRequest)httpGet);
            } else {
                logger.debug(" #$##$@$ using proxy .getCountOfFilesInFolder.." + fileUrl);
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(host, port);
                int timeout = 5;
                RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).setProxy(proxy).build();
                httpGet.setConfig(config);
                result = httpclient.execute((HttpUriRequest)httpGet);
            }
            int statusCode = result.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                logger.debug(" token expired ........... retry count .....");
                if (pciTokenElement != null) {
                    String userNameTemp = pciTokenElement.getUserName();
                    MSGTokens msgTokens = this.pciAuthorizationTokensDao.getMSGTokens(1);
                    pciTokenElement = this.getMSGTokenElement(msgTokens, null);
                    pciTokenElement.setUserName(userNameTemp);
                    int config = this.getCountOfFilesInFolder(pciTokenElement, cloudStoragePath, deviceUUID);
                    return config;
                }
            }
            if (statusCode != 200) {
                logger.error(" path doesnot exists ......... " + statusCode);
                int userNameTemp = count;
                return userNameTemp;
            }
            logger.debug(" status code ................ " + statusCode);
            String json = EntityUtils.toString((HttpEntity)result.getEntity());
            JSONObject jsonObject = new JSONObject(json);
            String itemCount = jsonObject.optString("d");
            if (itemCount != null) {
                jsonObject = new JSONObject(new String(itemCount));
                itemCount = jsonObject.optString("ItemCount");
                count = Integer.parseInt(itemCount);
            }
            logger.debug(" item count ................ " + itemCount);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Getting Count of Files In Folder :" + e.getMessage());
        }
        finally {
            httpGet.releaseConnection();
        }
        return count;
    }

    private PciAuthorizationTokenElement getMSGTokenElement(MSGTokens msgTokens, com.parablu.pcbd.domain.User user) {
        PciAuthorizationTokenElement tokenElement = new PciAuthorizationTokenElement();
        if (msgTokens == null) {
            return tokenElement;
        }
        tokenElement.setAccessToken(msgTokens.getAccessToken());
        tokenElement.setClientId(msgTokens.getClientId());
        tokenElement.setClientSecret(msgTokens.getClientSecret());
        tokenElement.setRedirectUri(msgTokens.getRedirectUri());
        tokenElement.setRefreshToken(msgTokens.getRefreshToken());
        tokenElement.setAccountId(msgTokens.getAccountId());
        tokenElement.setSharePointUrl(msgTokens.getSharePointUrl());
        tokenElement.setCloudName(msgTokens.getCloudName());
        if (user != null) {
            if (StringUtils.isEmpty((String)user.getOdbLoginId())) {
                tokenElement.setAccountId(user.getEmailId());
            } else {
                tokenElement.setAccountId(user.getOdbLoginId());
            }
            tokenElement.setUserName(user.getUserName());
        }
        return tokenElement;
    }

    @Override
    public FileStatusElement deleteFileFromODB(String fileName, String cloudStoragePath, String deviceUUID, String driveId) {
        String fileNameTemp = fileName;
        FileStatusElement fileStatusElement = new FileStatusElement();
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            userNameInPath = GraphUploadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        }
        logger.debug("..........before calling getFileId........" + fileNameTemp);
        GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
        String fileId = GraphUploadServiceImpl.getFileId(graphClient, driveId, fileNameTemp);
        if (StringUtils.isEmpty((String)fileId)) {
            logger.debug("File not found on any path so return false ");
            return fileStatusElement;
        }
        int responseCode = GraphUploadServiceImpl.deleteFile(driveId, fileId);
        logger.debug("...response code after delete...." + responseCode);
        if (responseCode == 204) {
            logger.debug("....chunk deleted....." + fileNameTemp);
            fileStatusElement.setDeleteStatus(true);
        }
        return fileStatusElement;
    }

    private static int deleteFile(String driveId, String fileId) {
        String fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/items/" + fileId;
        logger.debug("...delete url...." + fileUrl);
        int responseCode = 0;
        try {
            OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
            Request request = new Request.Builder().url(fileUrl).delete().build();
            Call call = okHttpClient.newCall(request);
            Response response = call.execute();
            responseCode = response.code();
            logger.debug("...deleted usinggraph...." + responseCode);
            response.close();
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException....", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("graph exception to delete:", (Object)e.getMessage());
        }
        return responseCode;
    }

    private static String getFileId(GraphServiceClient<Request> graphClient, String driveId, String fileName) {
        String fileId = "";
        try {
            DriveSearchParameterSet searchset = new DriveSearchParameterSet();
            searchset.q = fileName;
            DriveSearchCollectionPage search = (DriveSearchCollectionPage)((DriveSearchCollectionRequest)graphClient.drives(driveId).search(searchset).buildRequest(new Option[0])).get();
            Iterator iterator = search.getCurrentPage().iterator();
            if (iterator.hasNext()) {
                DriveItem driveItem = (DriveItem)iterator.next();
                logger.debug(driveItem.id + ".. found search file." + driveItem.name);
                fileId = driveItem.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("graph exception to get id:", (Throwable)e);
        }
        return fileId;
    }

    public String getItemIdForPathToDeleteLatest(PciAuthorizationTokenElement authorizationTokenElement, String fileName, String chunkFilePath, String deviceUUID, String driveId) {
        String itemId;
        block4: {
            itemId = "";
            logger.debug(" file delete from ODB latest ");
            try {
                String userNameInPath = "";
                if (!StringUtils.isEmpty((String)deviceUUID)) {
                    userNameInPath = GraphUploadServiceImpl.getUniqueODUserFolder(deviceUUID);
                    logger.debug("....device unique id ....... " + userNameInPath);
                }
                String modifiedPath = chunkFilePath;
                String filePath = userNameInPath + "/" + modifiedPath + "/" + fileName;
                logger.debug(driveId + "...deletefilepath .... " + filePath);
                GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
                DriveItem item = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + filePath, DriveItem.class).buildRequest(new Option[0]).get();
                if (item != null) {
                    itemId = item.id;
                }
                logger.debug("...deletefilepath itemid .... " + itemId);
            }
            catch (GraphServiceException e) {
                logger.error("... failed graph exception ... " + e.getResponseCode());
                if (e.getResponseCode() != 404) break block4;
                itemId = this.searchFileItemInOneDrive(fileName, driveId);
                logger.debug("...got file after search ..." + itemId);
            }
        }
        return itemId;
    }

    protected String searchFileItemInOneDrive(String fileName, String driveId) {
        String fileItemId = "";
        try {
            GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
            DriveSearchParameterSet searchset = new DriveSearchParameterSet();
            searchset.q = fileName;
            logger.debug("...filesearch......" + fileName + "....driveid..." + driveId);
            DriveSearchCollectionPage search = (DriveSearchCollectionPage)((DriveSearchCollectionRequest)graphClient.drives(driveId).search(searchset).buildRequest(new Option[0])).get();
            if (search == null) {
                logger.debug("search not found.....");
                return "404";
            }
            for (DriveItem driveItem : search.getCurrentPage()) {
                logger.debug(driveItem.id + "..itemid and name....." + driveItem.name);
                fileItemId = driveItem.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException", (Throwable)e);
            if (e.getResponseCode() == 401) {
                fileItemId = "401";
            }
        }
        catch (Exception e) {
            logger.error("graph exception to get id:", (Throwable)e);
        }
        logger.debug("search result exis:" + fileItemId);
        return fileItemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getItemIdForPathToDelete(PciAuthorizationTokenElement authorizationTokenElement, String fileName, String chunkFilePath, String deviceUUID, String driveId) {
        boolean retry;
        logger.debug(" file delete from ODB");
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            userNameInPath = GraphUploadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        }
        String downloadurl = "";
        String graphBaseUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root:/";
        String pathVal = userNameInPath + "/" + chunkFilePath + "/" + fileName;
        logger.debug("..... graph path ...." + pathVal);
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        boolean incrementPath = false;
        boolean decrementPath = false;
        boolean newPathCheck = false;
        boolean oldStylePath = false;
        boolean customOldStylePath = false;
        boolean increOldStylePath = false;
        boolean decreOldStylePath = false;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 5000L * (long)sleepMultiplier;
        do {
            retry = false;
            HttpResponse result = null;
            HttpClient httpclient = null;
            HttpGet httpGet = null;
            String modifiedPath = chunkFilePath;
            try {
                String cloudPath;
                downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                logger.debug(downloadurl + "......download path........." + retryCount);
                httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
                if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                    httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                    logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
                }
                if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                    logger.debug(" without proxy ...");
                    httpclient = HttpClientUtil.getSSlConnection();
                    result = httpclient.execute((HttpUriRequest)httpGet);
                } else {
                    logger.debug(" using proxy ...");
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                    httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                    HttpHost proxy = new HttpHost(host, port);
                    RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                    httpGet.setConfig(config);
                    result = httpclient.execute((HttpUriRequest)httpGet);
                }
                int responseCode = result.getStatusLine().getStatusCode();
                logger.debug(">>>>>>>>>>>>>>>>>Retry Response status code: " + responseCode);
                if (responseCode == 200) {
                    logger.debug("File found so return id is " + downloadurl);
                    String json = EntityUtils.toString((HttpEntity)result.getEntity());
                    JSONObject jsonObject = new JSONObject(json);
                    String id = jsonObject.optString("id");
                    logger.debug("...objectid .... " + id);
                    String string = id;
                    return string;
                }
                if (responseCode == 401) {
                    retry = true;
                    ++retryCount;
                    logger.error(" ... token expired so try after 1 min ... ");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException json) {
                        // empty catch block
                    }
                    authorizationTokenElementTemp = this.office365Dao.getMSGTokenElement(1, authorizationTokenElementTemp.getUserName());
                    continue;
                }
                if (responseCode == 200) continue;
                retry = true;
                sleepTime = responseCode != 404 ? this.sleepForGivenTime(sleepTime) : 0L;
                logger.debug("..retry attempt for response code ...." + responseCode + "...." + ++retryCount + "....." + authorizationTokenElementTemp.getEmailId());
                logger.debug("..retry url ...." + downloadurl);
                if (responseCode != 404) continue;
                if (!increOldStylePath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                    modifiedPath = cloudPath;
                    logger.debug("...increOldStylePath..." + modifiedPath);
                    increOldStylePath = true;
                    continue;
                }
                if (!newPathCheck && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                    newPathCheck = true;
                    modifiedPath = cloudPath;
                    logger.debug("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!decrementPath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                    decrementPath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...decre new path..." + modifiedPath);
                    continue;
                }
                if (!incrementPath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                    modifiedPath = cloudPath;
                    logger.debug("...incre new path..." + modifiedPath);
                    incrementPath = true;
                    continue;
                }
                if (!oldStylePath) {
                    downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                    oldStylePath = true;
                    logger.debug("...oldStylePath restore ...");
                    continue;
                }
                if (!customOldStylePath && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                    customOldStylePath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...customOldStylePath retryodbValue ..." + modifiedPath);
                    continue;
                }
                if (decreOldStylePath) continue;
                cloudPath = chunkFilePath;
                if (StringUtils.isNotEmpty((String)cloudPath)) {
                    int path = Integer.parseInt(cloudPath);
                    cloudPath = "" + (path - 1);
                }
                downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                decreOldStylePath = true;
                modifiedPath = cloudPath;
                logger.debug("...decreOldStylePath..." + modifiedPath);
            }
            catch (Exception e) {
                retry = true;
                ++retryCount;
                sleepTime = this.sleepForGivenTime(sleepTime);
                logger.trace("" + e);
                logger.error("Exception While Retying Download File From One Drive :" + e.getMessage());
            }
            finally {
                httpGet.releaseConnection();
            }
        } while (retry && retryCount < 8);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String checkOdbFolders(PciAuthorizationTokenElement authorizationTokenElement, String folderUrl, Map<String, Long> foldersMap, StringBuilder response) {
        logger.debug(".folderUrl.." + folderUrl);
        PciAuthorizationTokenElement pciTokenElement = authorizationTokenElement;
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        HttpClient httpclient = null;
        HttpResponse result = null;
        HttpGet httpGet = new HttpGet(folderUrl);
        try {
            httpGet.addHeader("Authorization", BEARER + authorizationTokenElement.getAccessToken());
            httpGet.addHeader("Accept", "application/json;odata=verbose");
            httpGet.addHeader("Content-Type", "*/*");
            if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
            }
            if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                logger.debug(" without proxy ...");
                httpclient = HttpClientUtil.getSSlConnection();
                result = httpclient.execute((HttpUriRequest)httpGet);
            } else {
                logger.debug(" using proxy ...");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(host, port);
                RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                httpGet.setConfig(config);
                result = httpclient.execute((HttpUriRequest)httpGet);
            }
            int statusCode = result.getStatusLine().getStatusCode();
            logger.debug("..........." + statusCode);
            if (statusCode == 401) {
                logger.error(" ... token expired so try after 1 min ... ");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException proxy) {
                    // empty catch block
                }
                pciTokenElement = this.office365Dao.getMSGTokenElement(1, pciTokenElement.getUserName());
                this.checkOdbFolders(pciTokenElement, folderUrl, foldersMap, response);
            }
            if (statusCode == 200) {
                String folders;
                logger.debug("  path doesnot exists ......... " + statusCode);
                String json = EntityUtils.toString((HttpEntity)result.getEntity());
                logger.debug(json);
                JSONObject jsonObject = new JSONObject(json);
                String itemCount = jsonObject.optString("d");
                if (itemCount != null && StringUtils.isNotEmpty((String)(folders = (jsonObject = new JSONObject(new String(itemCount))).optString("Folders")))) {
                    String reslut = new JSONObject(new String(folders)).get("results").toString();
                    JSONArray jsonArray = new JSONArray(new String(reslut));
                    for (Object jsonObj : jsonArray) {
                        JSONObject folderJson = (JSONObject)jsonObj;
                        JSONObject files = folderJson.getJSONObject("Files");
                        JSONObject __deferred = files.getJSONObject("__deferred");
                        String folderName = __deferred.getString("uri").toString();
                        if (foldersMap.containsKey(folderName)) continue;
                        foldersMap.put(folderName, folderJson.getLong("ItemCount"));
                        logger.debug(".....Path " + folderName.substring(folderName.lastIndexOf("("), folderName.lastIndexOf(")")) + " count " + folderJson.getLong("ItemCount") + "\n");
                        int countOfFiles = PCHelperConstant.getCountOfODBFiles();
                        if (countOfFiles == 0) {
                            countOfFiles = 4500;
                        }
                        logger.debug("checking odb folders " + countOfFiles);
                        if (folderJson.getLong("ItemCount") > (long)countOfFiles) {
                            String path = folderName.substring(folderName.lastIndexOf("("), folderName.lastIndexOf(")"));
                            response.append(authorizationTokenElement.getAccountId() + " Path " + path + " count " + folderJson.getLong("ItemCount") + "\n");
                        }
                        logger.debug(folderName);
                        this.checkOdbFolders(pciTokenElement, folderName.replace("Files", "?$select=StorageMetrics&$expand=Folders"), foldersMap, response);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Retying Download File From One Drive :" + e.getMessage());
        }
        finally {
            httpGet.releaseConnection();
        }
        return response.toString();
    }

    public boolean createLibraryIfNotExistsUsingGraph(String driveId, String userNameFold, String folderPath) {
        logger.debug(" URL for  createLibraryIfNotExistsUsingGraph ........... ");
        boolean isLibraryExists = this.isLibraryExistsUsingGraph(driveId);
        logger.debug(isLibraryExists + "  .....isLibraryExistsUsingGraph URL ........... ");
        if (!isLibraryExists) {
            return false;
        }
        return this.createFolderInsideLibraryUsingGraph(driveId, userNameFold, folderPath);
    }

    private boolean createFolderInsideLibraryUsingGraph(String driveId, String userNameFold, String folderPath) {
        boolean success = false;
        try {
            Folder folder;
            DriveItem driveItem;
            GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
            DriveItem driveItemParent = null;
            try {
                driveItemParent = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + userNameFold, DriveItem.class).buildRequest(new Option[0]).get();
            }
            catch (GraphServiceException graphServiceException) {
                // empty catch block
            }
            if (driveItemParent == null) {
                driveItem = new DriveItem();
                driveItem.name = userNameFold;
                driveItem.folder = folder = new Folder();
                ((DriveItemCollectionRequest)graphClient.drives(driveId).root().children().buildRequest(new Option[0])).post(driveItem);
                driveItemParent = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + userNameFold, DriveItem.class).buildRequest(new Option[0]).get();
            }
            driveItem = new DriveItem();
            driveItem.name = folderPath;
            driveItem.folder = folder = new Folder();
            ((DriveItemCollectionRequest)graphClient.drives(driveId).items(driveItemParent.id).children().buildRequest(new Option[0])).post(driveItem);
            success = true;
        }
        catch (GraphServiceException ee) {
            logger.error("....error trying to create folder ..." + ee.getMessage());
        }
        return success;
    }

    private boolean isLibraryExistsUsingGraph(String driveId) {
        boolean success = false;
        if (!StringUtils.isEmpty((String)driveId)) {
            success = true;
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileStatusElement uploadToOneDriveUsingGraph(PciAuthorizationTokenElement pciTokenElement, File file, String uploadingFileName, String accountId, String userName, String cloudStoragePath) {
        PciAuthorizationTokenElement pciTokenElementTemp = pciTokenElement;
        FileStatusElement element = new FileStatusElement();
        String userNameToGetUrl = userName;
        int cloudId = 1;
        boolean uploadSuccess = false;
        String driveId = "";
        Drive driveForUser = this.getDriveForUser(1, accountId);
        driveId = driveForUser.id;
        String encodedFileName = "";
        Object httpclient = null;
        try {
            encodedFileName = URLEncoder.encode(uploadingFileName, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root:/" + cloudStoragePath + "/" + encodedFileName + ":/content";
        logger.debug(file.length() + "...graph url>>>>>>>>>>>" + fileUrl);
        logger.debug(userName + "..check THROTTLE_DECOR..............." + driveId);
        Object result = null;
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        boolean isProxyEnabled = false;
        int responseCode = 0;
        try {
            block20: {
                RequestBody body;
                OkHttpClient okHttpClient;
                block19: {
                    if (!StringUtils.isEmpty((String)proxyUserName) && !StringUtils.isEmpty((String)password) && !StringUtils.isEmpty((String)host) && port > 0) break block19;
                    logger.debug(driveId + " filelengths  ss...." + file.length());
                    if (file.length() > 4000000L) {
                        try {
                            responseCode = GraphUploadServiceImpl.uploadGraph(accountId, file, cloudStoragePath, encodedFileName, driveId);
                        }
                        catch (GraphServiceException e) {
                            logger.error(".... exception......" + e.getMessage());
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            pciTokenElementTemp = this.office365Dao.getMSGTokenElement(1, pciTokenElementTemp.getUserName());
                            String token = pciTokenElementTemp.getAccessToken();
                            responseCode = GraphUploadServiceImpl.uploadGraph(accountId, file, cloudStoragePath, encodedFileName, driveId);
                        }
                        break block20;
                    } else {
                        okHttpClient = Graph.getInstance().getOkHttpClient();
                        body = RequestBody.create((byte[])FileUtils.readFileToByteArray((File)file));
                        Request request = new Request.Builder().url(fileUrl).put(body).build();
                        Call call = okHttpClient.newCall(request);
                        Response response = call.execute();
                        responseCode = response.code();
                        response.close();
                    }
                    break block20;
                }
                isProxyEnabled = true;
                okHttpClient = Graph.getInstance().getOkHttpClient();
                body = RequestBody.create((byte[])FileUtils.readFileToByteArray((File)file));
                Request request = new Request.Builder().url(fileUrl).put(body).build();
                Call call = okHttpClient.newCall(request);
                Response response = call.execute();
                responseCode = response.code();
                logger.debug("...less than 4 mb with proxy success...." + responseCode);
                response.close();
            }
            logger.debug("... success...." + responseCode);
            if (responseCode == 200 || responseCode == 201) {
                this.remove429Count();
                uploadSuccess = true;
                this.utilService.deleteBlackListUserByUserName(cloudId, userName);
            } else if (responseCode != 401) {
                // empty if block
            }
        }
        catch (Error ee) {
            logger.error("... error found trying to upload ... " + ee.getMessage());
        }
        catch (GraphServiceException ee) {
            uploadSuccess = false;
            logger.error("......graph exception ..." + ee.getMessage());
        }
        catch (Exception e) {
            uploadSuccess = false;
            logger.trace("" + e);
            logger.error("Exception While Writting :" + e.getMessage());
        }
        if (!uploadSuccess) {
            logger.debug("Response code...:" + responseCode + " for the userName..." + userName);
        }
        if (!uploadSuccess && responseCode != 429 && responseCode != 503 && responseCode != 409) {
            Set<String> blackUsersList = new HashSet<String>();
            Object obj = MemoryStore.get((String)BLACK_LIST_USERS);
            if (obj != null) {
                blackUsersList = (Set)obj;
            }
            blackUsersList.add(userName.toLowerCase());
            logger.debug("......marking user as blacklisted ..code..." + responseCode);
            MemoryStore.add((String)BLACK_LIST_USERS, blackUsersList, (long)1800000L);
        }
        element.setUploadStatus(uploadSuccess);
        element.setUploadStatuscode(responseCode);
        return element;
    }
}

