/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.parablu.helper.utils.MD5Generator;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DeleteExternalStorageDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BlocklistedFolders;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.UnreferencedChunkDetail;
import com.pg.domain.ChunkFile;
import com.pg.element.FileStatusElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.odb.util.OneDriveUtil;
import com.pg.service.CloudSupportService;
import com.pg.service.DeleteExternalStorageDataService;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class DeleteExternalStorageDataServiceImpl
implements DeleteExternalStorageDataService {
    public static final String ERROR_IN_DELETE_UNREFERENCED_CHUNKS = "Error in delete unreferenced chunks";
    public static final String CHUNK_DETAIL = "CHUNK_DETAIL";
    private static Logger logger = LogManager.getLogger(DeleteExternalStorageDataServiceImpl.class);
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    private DeleteExternalStorageDao deleteExternalStorageDao;
    private BackupPolicyDao backupPolicyDao;
    @Autowired
    private CloudSupportService cloudSupportService;

    public void setCloudSupportService(CloudSupportService cloudSupportSeervice) {
        this.cloudSupportService = cloudSupportSeervice;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public BackupPolicyDao getBackupPolicyDao() {
        return this.backupPolicyDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    private List<String> getAllChunkBuketNames() {
        ArrayList<String> chunkCollectionNames = new ArrayList<String>();
        int toatalChunkBuckets = PCHelperConstant.getChunkTotalBuckets();
        if (PCHelperConstant.isChunkCollectionQueryRequired()) {
            chunkCollectionNames.add(CHUNK_DETAIL);
        }
        for (int chunkBucket = 0; chunkBucket < toatalChunkBuckets; ++chunkBucket) {
            String chunkBucketName = "CHUNK_DETAIL_" + chunkBucket;
            chunkCollectionNames.add(chunkBucketName);
        }
        return chunkCollectionNames;
    }

    private String getChunkNewCollectionName(String md5) {
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % PCHelperConstant.getChunkTotalBuckets());
        return "CHUNK_DETAIL_" + chunkDetailDest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ChunkDetail> getUnreferencedChunks(int cloudId, List<ObjectId> objectIds, int limit) {
        List chunksToDeletePerCollection;
        ArrayList<ChunkDetail> chunks = new ArrayList<ChunkDetail>();
        List<String> chunkCollectionNames = this.getAllChunkBuketNames();
        ArrayList<ChunkDetail> chunksToDelete = new ArrayList<ChunkDetail>();
        for (String collectionName : chunkCollectionNames) {
            chunksToDeletePerCollection = this.externalStorageBackupFileDao.getChunksToDelete(cloudId, PCHelperConstant.getComponentName(), limit, collectionName, objectIds);
            if (CollectionUtils.isEmpty((Collection)chunksToDeletePerCollection)) continue;
            chunksToDelete.addAll(chunksToDeletePerCollection);
        }
        if (CollectionUtils.isEmpty(chunksToDelete)) {
            logger.debug("Chunks with ref count 0 and ComponentName " + PCHelperConstant.getComponentName() + " is empty so search with out gateway name");
            for (String collectionName : chunkCollectionNames) {
                chunksToDeletePerCollection = this.externalStorageBackupFileDao.getChunksToDelete(cloudId, null, limit, collectionName, objectIds);
                if (CollectionUtils.isEmpty((Collection)chunksToDeletePerCollection)) continue;
                chunksToDelete.addAll(chunksToDeletePerCollection);
            }
            if (!CollectionUtils.isEmpty(chunksToDelete)) {
                logger.debug("chunks with ref count is 0 and without gateway name so update gateway name as " + PCHelperConstant.getComponentName() + " for total " + chunksToDelete.size());
                for (ChunkDetail chunkDetail : chunksToDelete) {
                    String collectionName = this.getChunkNewCollectionName(chunkDetail.getMd5());
                    boolean result = this.externalStorageBackupFileDao.updateChunkWithGatewayName(cloudId, chunkDetail, PCHelperConstant.getComponentName(), collectionName);
                    if (!result) continue;
                    chunks.add(chunkDetail);
                }
                if (CollectionUtils.isEmpty(chunks)) return chunks;
                return chunks;
            }
            logger.debug(" unrefranced chunks is empty....");
            return chunks;
        }
        logger.debug("chunks  to delete ...is found..." + chunksToDelete.size());
        return chunksToDelete;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public FileStatusElement deleteChunkFromCloud(Cloud cloud, ChunkDetail chunkDetail, List<BlocklistedFolders> blockListFolders) {
        FileStatusElement fileStatusElement = new FileStatusElement();
        if (chunkDetail != null && chunkDetail.getRefCount() <= 0) {
            logger.debug("...delete refcount <=0 ...." + chunkDetail.getUserName() + "....." + chunkDetail.getContainerName());
            boolean isChunkPathisBlocklisted = this.checkChunkPathIsBlocklisted(blockListFolders, chunkDetail);
            if (isChunkPathisBlocklisted) {
                logger.debug("......chunk is in blocklisted..." + chunkDetail.getId());
                return fileStatusElement;
            }
            boolean isSync = false;
            if (chunkDetail.getProductType() != null && "SYNC".equals(chunkDetail.getProductType())) {
                isSync = true;
            }
            if ((fileStatusElement = this.cloudSupportService.deleteFromCloud(cloud, chunkDetail.getContainerName(), chunkDetail.getCloudChunkName(), chunkDetail.getUserName(), isSync, chunkDetail)).isDeleteStatus()) {
                this.externalStorageBackupFileDao.deleteChunkDetail(cloud.getCloudId(), chunkDetail);
                if (org.apache.commons.lang.StringUtils.isEmpty((String)chunkDetail.getDeviceUUID())) return fileStatusElement;
                if (chunkDetail.getSize() == 0L) return fileStatusElement;
                long fileUplaodedSize = -chunkDetail.getSize();
                logger.debug("Chunk removed from cloud so reduce size for " + chunkDetail.getDeviceUUID() + "....." + fileUplaodedSize);
                OneDriveUtil.getInstance().updateSizeInDeviceBackupOverview(cloud.getCloudId(), chunkDetail.getDeviceUUID(), null, fileUplaodedSize, null, null);
                return fileStatusElement;
            }
            if (!this.isODBEnabled(cloud)) return fileStatusElement;
            return fileStatusElement;
        } else {
            logger.debug("...deleteUnrefrancedChunkById...");
            this.externalStorageBackupFileDao.deleteUnrefrancedChunkById(cloud.getCloudId(), chunkDetail.getId());
        }
        return fileStatusElement;
    }

    @Override
    public void deleteExternalStorageData(Cloud cloud) {
        logger.debug("inside delete Cloud  DATA..............");
        try {
            this.copyDerefencedChunkToNewCollection(cloud);
            List blockListFolders = this.externalStorageBackupFileDao.getAllBlacklistFolders(cloud.getCloudId());
            ArrayList<ObjectId> chunksId = new ArrayList<ObjectId>();
            boolean hasRecordsToProcess = true;
            while (hasRecordsToProcess) {
                List unReferencedChunksFromNewColl = this.externalStorageBackupFileDao.getUnReferencedChunksFromNewColl(cloud.getCloudId(), chunksId);
                if (CollectionUtils.isEmpty((Collection)unReferencedChunksFromNewColl)) {
                    hasRecordsToProcess = false;
                }
                for (UnreferencedChunkDetail unreferencedChunkDetail : unReferencedChunksFromNewColl) {
                    ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailById(cloud.getCloudId(), unreferencedChunkDetail.getId(), unreferencedChunkDetail.getDestCollection());
                    if (chunkDetail != null && chunkDetail.getRefCount() <= 0) {
                        boolean isChunkPathBlocklisted = this.checkChunkPathIsBlocklisted((List<BlocklistedFolders>)blockListFolders, unreferencedChunkDetail);
                        if (!isChunkPathBlocklisted) {
                            FileStatusElement fileStatusElement;
                            ChunkDetail chunk = new ChunkDetail();
                            BeanUtils.copyProperties((Object)unreferencedChunkDetail, (Object)chunk);
                            boolean isSync = false;
                            if (chunk.getProductType() != null && "SYNC".equals(chunk.getProductType())) {
                                isSync = true;
                            }
                            if ((fileStatusElement = this.cloudSupportService.deleteFromCloud(cloud, chunk.getContainerName(), chunk.getCloudChunkName(), chunk.getContainerName(), isSync, chunk)).isDeleteStatus()) {
                                this.externalStorageBackupFileDao.deleteUnReferencedChunksByIdInChunkDetail(cloud.getCloudId(), unreferencedChunkDetail.getId(), unreferencedChunkDetail.getDestCollection());
                                this.externalStorageBackupFileDao.deleteUnrefrancedChunkById(cloud.getCloudId(), unreferencedChunkDetail.getId());
                                if (org.apache.commons.lang.StringUtils.isEmpty((String)chunk.getDeviceUUID()) || fileStatusElement.getFileSize() == 0L) continue;
                                long fileUplaodedSize = -(fileStatusElement.getFileSize() / 1024L);
                                logger.debug("Chunk removed from cloud so reduce size for " + chunk.getDeviceUUID() + "....." + fileUplaodedSize);
                                OneDriveUtil.getInstance().updateSizeInDeviceBackupOverview(cloud.getCloudId(), chunk.getDeviceUUID(), null, fileUplaodedSize, null, null);
                                continue;
                            }
                            if (!this.isODBEnabled(cloud)) continue;
                            logger.debug("....Fail to delete from ODB ....");
                            int itemCount = this.cloudSupportService.getCountOfFilesInFolder(cloud, chunk.getCloudStoragePath(), chunk.getDeviceUUID(), chunk.getUserName());
                            logger.debug("....itemCount ...." + itemCount);
                            if (itemCount == 0 || itemCount >= 5000) {
                                logger.debug("...item count is zero or greater than 5000 so block list folders...");
                                BlocklistedFolders BlacklistedFolders = new BlocklistedFolders();
                                String cloudStoragePath = chunk.getCloudStoragePath();
                                if (!org.apache.commons.lang.StringUtils.isEmpty((String)chunk.getDeviceUUID())) {
                                    cloudStoragePath = DeleteExternalStorageDataServiceImpl.getUniqueODUserFolder(chunk.getDeviceUUID()) + "/" + chunk.getCloudStoragePath();
                                }
                                BlacklistedFolders.setCloudStoragePath(cloudStoragePath);
                                BlacklistedFolders.setUserName(chunk.getUserName());
                                this.externalStorageBackupFileDao.saveBlockListedFolders(cloud.getCloudId(), BlacklistedFolders);
                                blockListFolders.add(BlacklistedFolders);
                                continue;
                            }
                            logger.debug(".............item count is not zero but check not found....so delete the chunk");
                            this.externalStorageBackupFileDao.deleteUnReferencedChunksByIdInChunkDetail(cloud.getCloudId(), unreferencedChunkDetail.getId(), unreferencedChunkDetail.getDestCollection());
                            this.externalStorageBackupFileDao.deleteUnrefrancedChunkById(cloud.getCloudId(), unreferencedChunkDetail.getId());
                            continue;
                        }
                        logger.debug("......chunk is in blocklisted..." + unreferencedChunkDetail.getId() + " form chunk coll " + unreferencedChunkDetail.getDestCollection());
                        chunksId.add(unreferencedChunkDetail.getId());
                        continue;
                    }
                    this.externalStorageBackupFileDao.deleteUnrefrancedChunkById(cloud.getCloudId(), unreferencedChunkDetail.getId());
                }
            }
        }
        catch (Exception e) {
            logger.debug(ERROR_IN_DELETE_UNREFERENCED_CHUNKS + e);
            logger.error(ERROR_IN_DELETE_UNREFERENCED_CHUNKS + e.getMessage());
        }
    }

    private void proccedToDeleteChunk(Cloud cloud, List<BlocklistedFolders> blockListFolders, List<ObjectId> chunksId, UnreferencedChunkDetail unreferencedChunkDetail) {
        try {
            boolean isChunkPathisBlocklisted = this.checkChunkPathIsBlocklisted(blockListFolders, unreferencedChunkDetail);
            if (!isChunkPathisBlocklisted) {
                FileStatusElement fileStatusElement;
                ChunkDetail chunk = new ChunkDetail();
                BeanUtils.copyProperties((Object)unreferencedChunkDetail, (Object)chunk);
                boolean isSync = false;
                if (chunk.getProductType() != null && "SYNC".equals(chunk.getProductType())) {
                    isSync = true;
                }
                if ((fileStatusElement = this.cloudSupportService.deleteFromCloud(cloud, chunk.getContainerName(), chunk.getCloudChunkName(), chunk.getContainerName(), isSync, chunk)).isDeleteStatus()) {
                    this.externalStorageBackupFileDao.deleteUnrefrancedChunkById(cloud.getCloudId(), unreferencedChunkDetail.getId());
                    if (!org.apache.commons.lang.StringUtils.isEmpty((String)chunk.getDeviceUUID()) && fileStatusElement.getFileSize() != 0L) {
                        long fileUplaodedSize = -(fileStatusElement.getFileSize() / 1024L);
                        logger.debug("Chunk removed from cloud so reduce size for " + chunk.getDeviceUUID() + "....." + fileUplaodedSize);
                        OneDriveUtil.getInstance().updateSizeInDeviceBackupOverview(cloud.getCloudId(), chunk.getDeviceUUID(), null, fileUplaodedSize, null, null);
                    }
                } else if (this.isODBEnabled(cloud)) {
                    logger.debug("....Fail to delete from ODB so cehck item count....");
                    int itemCount = this.cloudSupportService.getCountOfFilesInFolder(cloud, chunk.getCloudStoragePath(), chunk.getDeviceUUID(), chunk.getUserName());
                    logger.debug("....itemCount ...." + itemCount);
                    if (itemCount == 0 || itemCount >= 5000) {
                        logger.debug("...item count is zero so add folder to block list folders");
                        BlocklistedFolders blocklistedFolders = new BlocklistedFolders();
                        String cloudStoragePath = chunk.getCloudStoragePath();
                        if (!org.apache.commons.lang.StringUtils.isEmpty((String)chunk.getDeviceUUID())) {
                            cloudStoragePath = DeleteExternalStorageDataServiceImpl.getUniqueODUserFolder(chunk.getDeviceUUID()) + "/" + chunk.getCloudStoragePath();
                        }
                        blocklistedFolders.setCloudStoragePath(cloudStoragePath);
                        blocklistedFolders.setUserName(chunk.getUserName());
                        this.externalStorageBackupFileDao.saveBlockListedFolders(cloud.getCloudId(), blocklistedFolders);
                        blockListFolders.add(blocklistedFolders);
                    } else {
                        logger.debug(".............item count is not zero but chenk not found....so delete the chunk");
                        this.externalStorageBackupFileDao.deleteUnrefrancedChunkById(cloud.getCloudId(), unreferencedChunkDetail.getId());
                    }
                }
            } else {
                logger.debug("......chunk is in blocklisted..." + unreferencedChunkDetail.getId() + " form chunk coll " + unreferencedChunkDetail.getDestCollection());
                chunksId.add(unreferencedChunkDetail.getId());
            }
        }
        catch (Exception e) {
            logger.debug("ERROR_IN_DELETE_UNREFERENCED_CHUNKS :" + e);
            logger.error(ERROR_IN_DELETE_UNREFERENCED_CHUNKS + e.getMessage());
        }
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString((String)deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    private boolean checkChunkPathIsBlocklisted(List<BlocklistedFolders> blockListFolders, UnreferencedChunkDetail unreferencedChunkDetail) {
        BlocklistedFolders blockListedFolder;
        String cloudStoragePath = unreferencedChunkDetail.getCloudStoragePath();
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)unreferencedChunkDetail.getDeviceUUID())) {
            cloudStoragePath = DeleteExternalStorageDataServiceImpl.getUniqueODUserFolder(unreferencedChunkDetail.getDeviceUUID()) + "/" + unreferencedChunkDetail.getCloudStoragePath();
        }
        String cloudPath = cloudStoragePath;
        boolean isChunkPathisBlocklisted = false;
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)unreferencedChunkDetail.getUserName()) && !org.apache.commons.lang.StringUtils.isEmpty((String)cloudPath) && (blockListedFolder = (BlocklistedFolders)blockListFolders.stream().filter(folder -> folder.getUserName().equalsIgnoreCase(unreferencedChunkDetail.getUserName()) && folder.getCloudStoragePath().equals(cloudPath)).findFirst().orElse(null)) != null) {
            isChunkPathisBlocklisted = true;
        }
        return isChunkPathisBlocklisted;
    }

    private boolean checkChunkPathIsBlocklisted(List<BlocklistedFolders> blockListFolders, ChunkDetail chunkdetail) {
        BlocklistedFolders blockListedFolder;
        String cloudStoragePath = chunkdetail.getCloudStoragePath();
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)chunkdetail.getDeviceUUID())) {
            cloudStoragePath = DeleteExternalStorageDataServiceImpl.getUniqueODUserFolder(chunkdetail.getDeviceUUID()) + "/" + chunkdetail.getCloudStoragePath();
        }
        String cloudPath = cloudStoragePath;
        boolean isChunkPathisBlocklisted = false;
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)chunkdetail.getUserName()) && !org.apache.commons.lang.StringUtils.isEmpty((String)cloudPath) && (blockListedFolder = (BlocklistedFolders)blockListFolders.stream().filter(folder -> folder.getUserName().equalsIgnoreCase(chunkdetail.getUserName()) && folder.getCloudStoragePath().equals(cloudPath)).findFirst().orElse(null)) != null) {
            isChunkPathisBlocklisted = true;
        }
        return isChunkPathisBlocklisted;
    }

    private void copyDerefencedChunkToNewCollection(Cloud cloud) {
        logger.debug("moving derefrenced chunks from chunkDetail to new collection started stared......");
        List<String> queryTablesList = this.getChunkDeltailCollections();
        boolean isGlobalDedupEnabled = this.getdedupValue(cloud);
        try {
            for (String chunkCollection : queryTablesList) {
                logger.debug("moving derefrenced chunks for collection....." + chunkCollection);
                boolean hasRecordsToProcess = true;
                ArrayList objectIds = new ArrayList();
                while (hasRecordsToProcess) {
                    List chunkDetailsList = this.externalStorageBackupFileDao.getUnReferencedChunks(cloud.getCloudId(), chunkCollection, objectIds);
                    if (CollectionUtils.isEmpty((Collection)chunkDetailsList)) {
                        hasRecordsToProcess = false;
                    }
                    for (ChunkDetail chunkDetail : chunkDetailsList) {
                        UnreferencedChunkDetail derfChnk = new UnreferencedChunkDetail();
                        BeanUtils.copyProperties((Object)chunkDetail, (Object)derfChnk);
                        derfChnk.setGlobalDedup(isGlobalDedupEnabled);
                        derfChnk.setDestCollection(chunkCollection);
                        this.externalStorageBackupFileDao.saveDereferancedChunkDetail(cloud.getCloudId(), derfChnk);
                    }
                    objectIds.addAll(chunkDetailsList.stream().filter(chunk -> Objects.nonNull(chunk.getId())).map(chunk -> chunk.getId()).collect(Collectors.toList()));
                }
            }
        }
        catch (Exception e) {
            logger.debug("Error in moveDerefencedChunkToNewCollection Execption :" + e);
            logger.error(ERROR_IN_DELETE_UNREFERENCED_CHUNKS + e.getMessage());
        }
        logger.debug("moving derefrenced chunks from chunkDetail to derefrancedChunkDeails Ended......");
    }

    private boolean getdedupValue(Cloud cloud) {
        List licenseDetails = cloud.getCloudCustomisableDetails();
        boolean isGlobalDedupEnabled = false;
        licenseDetails.removeAll(Collections.singleton(null));
        for (CloudCustomisableDetails cloudCustomisableDetails : licenseDetails) {
            if (!"ODB Enabled".equals(cloudCustomisableDetails.getName())) continue;
            isGlobalDedupEnabled = true;
            break;
        }
        return isGlobalDedupEnabled;
    }

    private boolean isODBEnabled(Cloud cloud) {
        List licenseDetails = cloud.getCloudCustomisableDetails();
        boolean isODBEnabled = false;
        licenseDetails.removeAll(Collections.singleton(null));
        for (CloudCustomisableDetails cloudCustomisableDetails : licenseDetails) {
            if (!"ODB Enabled".equals(cloudCustomisableDetails.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private List<String> getChunkDeltailCollections() {
        int toatalChunkBuckets = PCHelperConstant.getChunkTotalBuckets();
        ArrayList<String> queryTablesList = new ArrayList<String>();
        if (PCHelperConstant.isChunkCollectionQueryRequired()) {
            queryTablesList.add(CHUNK_DETAIL);
        }
        for (int chunkBucket = 0; chunkBucket < toatalChunkBuckets; ++chunkBucket) {
            String chunkBucketName = "CHUNK_DETAIL_" + chunkBucket;
            queryTablesList.add(chunkBucketName);
        }
        return queryTablesList;
    }

    @Override
    public void deleteODTableEntriesAndMarkchunksToDelete(int cloudId, String cloudName, String userName, List<com.pg.domain.BackupFile> deletedBackupFiles) {
        int count = 0;
        logger.debug("backup file Count before>>>>>>>>>>>>>>>>> check" + deletedBackupFiles.size());
        for (com.pg.domain.BackupFile backupFile : deletedBackupFiles) {
            boolean canBeDeleted = this.checkPrelimConditionsBeforeDelete(cloudId, cloudName, userName, backupFile);
            if (!canBeDeleted) continue;
            if (StringUtils.isEmpty((Object)backupFile.getDedupBackupId())) {
                ++count;
                StringBuilder chunkFileName = new StringBuilder(((ChunkFile)backupFile.getChunkFiles().get(0)).getFileName());
                int occurance = org.apache.commons.lang.StringUtils.countMatches((String)chunkFileName.toString(), (String)".");
                if (occurance == 0) {
                    chunkFileName.append(".").append(backupFile.getId());
                }
                this.deleteExternalStorageDao.insertBackupFileForDeletion(cloudId, chunkFileName.toString(), userName, backupFile.getMd5());
            }
            this.externalStorageBackupFileDao.deleteBackupFile(cloudId, cloudName, userName, backupFile.getId());
        }
        logger.debug("backup file Count After>>>>>>>>>>>>>> check" + count);
    }

    private boolean checkPrelimConditionsBeforeDelete(int cloudId, String cloudName, String userName, com.pg.domain.BackupFile backupFile) {
        boolean canBeDeleted = true;
        if (backupFile.getChunkFiles().size() == 1) {
            BackupFile parentFile = this.externalStorageBackupFileDao.getBackupFileForDedupBackupId(cloudId, cloudName, userName, backupFile.getId());
            if (parentFile != null) {
                logger.debug("inside parent file is not null>>>>>>>>" + parentFile.getFileName());
                canBeDeleted = false;
            }
        } else {
            canBeDeleted = false;
        }
        return canBeDeleted;
    }

    public void setDeleteExternalStorageDao(DeleteExternalStorageDao deleteExternalStorageDao) {
        this.deleteExternalStorageDao = deleteExternalStorageDao;
    }

    @Override
    public void updateChunkAsDeleteStarted(int cloudId, ChunkDetail chunkDetail, boolean deleteProcessStarted) {
        this.externalStorageBackupFileDao.updateChunkAsDeleteStarted(cloudId, chunkDetail, deleteProcessStarted);
    }

    @Override
    public boolean deleteZeroedChunkDetailOnlyIfReferencedMoreThanOnce(int cloudId, ChunkDetail chunkDetail, boolean skipThisChunk) {
        List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailListForMd5(cloudId, chunkDetail.getMd5(), "", "", false, false);
        if (chunkDetailList.size() > 1) {
            this.externalStorageBackupFileDao.deleteChunkDetail(cloudId, chunkDetail);
            skipThisChunk = true;
        }
        return skipThisChunk;
    }
}

