/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.models.Contact;
import com.microsoft.graph.models.ConvertIdResult;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.ExchangeIdFormat;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.ProfilePhoto;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.UserTranslateExchangeIdsParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.AttachmentCollectionPage;
import com.microsoft.graph.requests.AttachmentCollectionRequest;
import com.microsoft.graph.requests.DriveItemContentStreamRequestBuilder;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserTranslateExchangeIdsCollectionPage;
import com.microsoft.graph.requests.UserTranslateExchangeIdsCollectionRequest;
import com.parablu.cloudbackup.CloudBackupStorageBridge;
import com.parablu.cloudbackup.OfficeRestoreService;
import com.parablu.cloudbackup.StorageService;
import com.parablu.cloudbackup.UploadStatus;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.FailedFileReason;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.MailAttachment;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.OutlookEmailAddress;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.SearchIndex;
import com.pg.controller.BaseController;
import com.pg.domain.DriveFileInfo;
import com.pg.domain.FileInfo;
import com.pg.element.BackupElement;
import com.pg.element.BluKryptElement;
import com.pg.element.ChunkFileElement;
import com.pg.element.FileUploadDetailsElement;
import com.pg.element.MailAttachmentElement;
import com.pg.element.OutlookEmailAddressElement;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.helper.utils.MemoryStore;
import com.pg.service.BackupService;
import com.pg.service.ChunkableUploadService;
import com.pg.service.ComponentSettingService;
import com.pg.service.DownloadService;
import com.pg.service.JobConfigService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.BsonMaximumSizeExceededException;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.jvnet.hk2.annotations.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@Service
public class CloudBackupController
extends BaseController
implements DisposableBean,
ApplicationContextAware,
Runnable,
CloudBackupStorageBridge {
    private static final Logger logger = LogManager.getLogger(CloudBackupController.class);
    private static final String AUTHORITY = "https://login.microsoftonline.com/";
    private static final String EWS_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    private static final String RESOURCE = "https://outlook.office365.com";
    @Autowired
    private UploadService uploadService;
    @Autowired
    private ChunkableUploadService chunkableUploadService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private ComponentSettingService componentSettingService;
    @Autowired
    private JobConfigService jobConfigService;
    public static final String FILE_NOT_EXISTS = "File Not exists";
    @Autowired
    private SyncDownloadService syncDownloadService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private UtilService utilService;
    static Thread thisThread;
    private static final Semaphore sem;
    private static ApplicationContext applicationContext;
    private static final String USER_STORAGE_LIMIT_REACHED = " User Storage limit reached ..... ";
    private static final String DIRECT_CALL_STORAGE_LIMIT = " direct call .... storage limit .......";
    private static final String UPLOAD_COUNT = "uploadCount";
    private static final String JOB_ID = "JobId";
    private static final String CHUNK = "chunk";
    private static final String ALREADY_EXISTS = "ALREADY_EXISTS";
    private static final String LARGE_MONGO_ENTRY = "LARGE_MONGO_ENTRY";
    private static final String BATCH_ID_LOG = "##batch id >>>>";

    public void setComponentSettingService(ComponentSettingService componentSettingService) {
        this.componentSettingService = componentSettingService;
    }

    public void setJobConfigService(JobConfigService jobConfigService) {
        this.jobConfigService = jobConfigService;
    }

    public void setSyncDownloadService(SyncDownloadService syncDownloadService) {
        this.syncDownloadService = syncDownloadService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        logger.debug("---- Application context is set! ---- ");
        CloudBackupController.applicationContext = applicationContext;
        sem.release();
    }

    public static ApplicationContext getContext() {
        return applicationContext;
    }

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setChunkableUploadService(ChunkableUploadService chunkableUploadService) {
        this.chunkableUploadService = chunkableUploadService;
    }

    public void setBackupService(BackupService backupService) {
        this.backupService = backupService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    CloudBackupController() {
        logger.debug("----------------~~~~~~ CloudBackupBridge ~~~~~~----------------");
        this.runOnce();
    }

    void runOnce() {
        logger.info("Triggered run Once");
        if (thisThread == null) {
            logger.info("Launching thread!");
            thisThread = new Thread(this);
            logger.info("@@@@@@@@@@@@@ ----- @@@@@@@@@@@");
            thisThread.start();
        }
    }

    public void destroy() {
        try {
            StorageService.GETINST.shutdown();
            OfficeRestoreService.GETINST.shutdown();
            try {
                logger.debug("going to sleep no work found");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("Sleep interrupted", (Throwable)e);
            }
            thisThread.join();
        }
        catch (InterruptedException e) {
            logger.error("Exception while destroying", (Throwable)e);
        }
        logger.info("----------------~~~~~~ CloudBackupBridge ~~~~~~----------------");
    }

    private static ChunkFileElement createChunkFileElement(String deviceUUID, BluKryptElement bluKryptElement, String chunkFilechecksum, String chunkFileName, String checkSum, List<String> list) {
        ChunkFileElement chunkFileElement = new ChunkFileElement();
        if (CollectionUtils.isEmpty(list)) {
            logger.info("List is empty sooo adding md5checksum" + checkSum);
            list.add(checkSum);
        }
        chunkFileElement.setFileChunks(list);
        chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
        logger.info("createChunkFileElemet " + bluKryptElement.getFileCompletePath());
        chunkFileElement.setFileName(checkSum);
        chunkFileElement.setMd5checksum(checkSum);
        chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
        if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
            chunkFileElement.setMd5checksum(chunkFilechecksum);
            chunkFileElement.setFileChunks(list);
            logger.info("Create chunk file element " + chunkFileName);
            chunkFileElement.setFileCompletePath(chunkFileName);
            chunkFileElement.setFileName(chunkFileName);
            chunkFileElement.setDeviceUUID(deviceUUID);
        }
        return chunkFileElement;
    }

    private static boolean checkMachineStorage(String fileSizeInString) {
        File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long incomingFileSize = Long.parseLong(fileSizeInString);
        long availableSpaceInServer = file.getFreeSpace();
        logger.info("Total space for this machine.." + file.getTotalSpace() + "FREE_SIZE" + file.getFreeSpace() + "incoming File Size:" + incomingFileSize);
        if (availableSpaceInServer - incomingFileSize <= 0L) {
            logger.info("Space in server is exceeded........");
            return true;
        }
        return false;
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private double getFileSizeInMb(Map<String, String> headerMap) {
        long fileSizeInBytes = Long.parseLong(headerMap.get("file-size"));
        long filesizeInKB = (long)Math.ceil((double)fileSizeInBytes / 1024.0);
        return CloudBackupController.getSizeinMb(filesizeInKB);
    }

    protected FileUploadDetailsElement insertEntryForBackupFromBK(Map<String, Object> request, String cloudName, String userName, String maxVersionsToKeep, Device device, boolean isMail) {
        FileUploadDetailsElement fileUploadDetailsElement;
        block37: {
            fileUploadDetailsElement = new FileUploadDetailsElement();
            try {
                String deviceUUID;
                OutlookEmailAddressElement outlookEmailAddress;
                OutlookEmailAddress add;
                Iterator iterator;
                ArrayList<OutlookEmailAddressElement> llist;
                Object addresses;
                BackupElement fileElement = new BackupElement();
                fileElement.setFileName((String)request.get("file-name"));
                fileElement.setFileCompletePath((String)request.get("file-path"));
                fileElement.setPresent(Boolean.valueOf((String)request.get("is-exists")).booleanValue());
                fileElement.setFolder(Boolean.valueOf((String)request.get("is-folder")).booleanValue());
                fileElement.setMd5Checksum((String)request.get("fileMD5"));
                if (request.get("taskStartDate") != null) {
                    fileElement.setTaskStartDate((Date)request.get("taskStartDate"));
                }
                if (request.get("taskDueDate") != null) {
                    fileElement.setTaskDueDate((Date)request.get("taskDueDate"));
                }
                if (request.get("taskReminderTime") != null) {
                    fileElement.setTaskReminderTime((Date)request.get("taskReminderTime"));
                }
                if (request.get("taskSubject") != null) {
                    fileElement.setTaskSubject((String)request.get("taskSubject"));
                }
                if (request.get("file-size") != null) {
                    if (!StringUtils.isEmpty((Object)((String)request.get("file-size")))) {
                        fileElement.setSize(Long.valueOf((String)request.get("file-size")).longValue());
                    } else {
                        fileElement.setSize(0L);
                    }
                } else {
                    fileElement.setSize(0L);
                }
                if (!isMail) {
                    String fileModifiedTimestamp = (String)request.get("modified");
                    fileElement.setLastClientModifiedTime(Long.valueOf(fileModifiedTimestamp).longValue());
                } else {
                    fileElement.setLastClientModifiedTime(System.currentTimeMillis());
                }
                fileElement.setBaseBackup(Boolean.valueOf((String)request.get("is-base-folder")).booleanValue());
                fileElement.setGatewayName((String)request.get("gatewayName"));
                String version = (String)request.get("maxVersions");
                logger.debug(request.get("parentItemID") + ".... item id iss.... " + request.get("odItemId") + "..ewsid..." + request.get("ewsId"));
                fileElement.setOdItemId((String)request.get("odItemId"));
                if (!StringUtils.isEmpty((Object)request.get("ewsId"))) {
                    fileElement.setEwsId((String)request.get("ewsId"));
                }
                fileElement.setParentItemId((String)request.get("parentItemID"));
                fileElement.setSubject((String)request.get("subject"));
                fileElement.setFrom((String)request.get("from"));
                fileElement.setBodyContent((String)request.get("bodyContent"));
                fileElement.setDisplayContent((String)request.get("displayContent"));
                fileElement.setCcRecipients((String)request.get("ccRecipients"));
                fileElement.setBccRecipients((String)request.get("bccRecipients"));
                fileElement.setToRecipients((String)request.get("toRecipients"));
                if (request.get("hasAttachments") != null) {
                    fileElement.setHasAttachments(((Boolean)request.get("hasAttachments")).booleanValue());
                }
                if (fileElement.isHasAttachments()) {
                    ArrayList<MailAttachmentElement> list = new ArrayList<MailAttachmentElement>();
                    List attachments = (List)request.get("attachments");
                    if (!CollectionUtils.isEmpty((Collection)attachments)) {
                        for (MailAttachment attachment : attachments) {
                            MailAttachmentElement elemen = new MailAttachmentElement();
                            BeanUtils.copyProperties((Object)attachment, (Object)elemen);
                            logger.debug("..pcibusattach..." + elemen.getName());
                            list.add(elemen);
                        }
                    }
                    fileElement.setAttachments(list);
                }
                if (request.get("fromEmailAddress") != null) {
                    addresses = (OutlookEmailAddress)request.get("fromEmailAddress");
                    OutlookEmailAddressElement emailAddress = new OutlookEmailAddressElement();
                    BeanUtils.copyProperties((Object)addresses, (Object)emailAddress);
                    fileElement.setFromEmailAddress(emailAddress);
                }
                if (request.get("toRecipientsAddress") != null) {
                    addresses = (List)request.get("toRecipientsAddress");
                    llist = new ArrayList<OutlookEmailAddressElement>();
                    logger.debug("...ttooo addrr..." + addresses);
                    if (!CollectionUtils.isEmpty((Collection)addresses)) {
                        iterator = addresses.iterator();
                        while (iterator.hasNext()) {
                            add = (OutlookEmailAddress)iterator.next();
                            outlookEmailAddress = new OutlookEmailAddressElement();
                            BeanUtils.copyProperties((Object)add, (Object)outlookEmailAddress);
                            logger.debug("..toadddddd...." + add.getAddress());
                            llist.add(outlookEmailAddress);
                        }
                    }
                    fileElement.setToRecipientsAddress(llist);
                }
                if (request.get("ccRecipientsAddress") != null) {
                    addresses = (List)request.get("ccRecipientsAddress");
                    logger.debug("...cc addrr..." + addresses);
                    llist = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)addresses)) {
                        iterator = addresses.iterator();
                        while (iterator.hasNext()) {
                            add = (OutlookEmailAddress)iterator.next();
                            outlookEmailAddress = new OutlookEmailAddressElement();
                            BeanUtils.copyProperties((Object)add, (Object)outlookEmailAddress);
                            llist.add(outlookEmailAddress);
                        }
                    }
                    fileElement.setCcRecipientsAddress(llist);
                }
                if (request.get("bccRecipientsAddress") != null) {
                    addresses = (List)request.get("bccRecipientsAddress");
                    logger.debug("...bccRecipientsAddress addrr..." + addresses);
                    llist = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)addresses)) {
                        iterator = addresses.iterator();
                        while (iterator.hasNext()) {
                            add = (OutlookEmailAddress)iterator.next();
                            outlookEmailAddress = new OutlookEmailAddressElement();
                            BeanUtils.copyProperties((Object)add, (Object)outlookEmailAddress);
                            llist.add(outlookEmailAddress);
                        }
                    }
                    fileElement.setBccRecipientsAddress(llist);
                }
                fileElement.setSentDate((String)request.get("sentDate"));
                logger.debug("..fileElement.setSentDate.." + request.get("sentDate"));
                String userUnderLegalHold = (String)request.get("userUnderLegalHold");
                boolean isFullBackup = false;
                String fullBackup = (String)request.get("isFullBackup");
                if (!StringUtils.isEmpty((Object)fullBackup)) {
                    isFullBackup = Boolean.parseBoolean(fullBackup);
                }
                if ((deviceUUID = (String)request.get("deviceUUID")) != null) {
                    CloudBackupController.printLogs("Device UUID is not null", PCHelperConstant.isBrevityLogging());
                }
                int uploadCount = 0;
                if (MemoryStore.get((String)UPLOAD_COUNT) != null) {
                    uploadCount = (Integer)MemoryStore.get((String)UPLOAD_COUNT);
                    logger.info(" From MEMSTORE ........... " + uploadCount);
                }
                if (request.get("contactMobile") != null) {
                    fileElement.setContactMobile((String)request.get("contactMobile"));
                }
                if (request.get("contactAddrStreet") != null) {
                    fileElement.setContactAddrStreet((String)request.get("contactAddrStreet"));
                }
                if (request.get("contactAddrCity") != null) {
                    fileElement.setContactAddrCity((String)request.get("contactAddrCity"));
                }
                if (request.get("contactAddrState") != null) {
                    fileElement.setContactAddrState((String)request.get("contactAddrState"));
                }
                if (request.get("contactAddrCountry") != null) {
                    fileElement.setContactAddrCountry((String)request.get("contactAddrCountry"));
                }
                if (request.get("contactAddrPostalCode") != null) {
                    fileElement.setContactAddrPostalCode((String)request.get("contactAddrPostalCode"));
                }
                logger.info(" Before calling uploadExternalFileToBackUp ..........." + fileElement.getSubject() + "..." + fileElement.getTaskDueDate());
                fileUploadDetailsElement = this.backupService.uploadExternalFileToBackUp(1, cloudName, fileElement, device, userUnderLegalHold, isFullBackup);
                logger.info(" After calling uploadExternalFileToBackUp ..........." + fileUploadDetailsElement.getBkpId() + "...." + fileUploadDetailsElement.getFileSize());
                MemoryStore.delete((String)UPLOAD_COUNT);
                MemoryStore.add((String)UPLOAD_COUNT, (Object)(++uploadCount));
            }
            catch (BsonMaximumSizeExceededException ee) {
                logger.error("..large size file.... ");
                fileUploadDetailsElement.setBkpId(LARGE_MONGO_ENTRY);
            }
            catch (Exception e) {
                logger.error("..Exception When Inserting Entry For Backup From BK :....", (Throwable)e);
                if (!(e instanceof BsonMaximumSizeExceededException)) break block37;
                logger.error("..large size file.... ");
                fileUploadDetailsElement.setBkpId(LARGE_MONGO_ENTRY);
            }
        }
        return fileUploadDetailsElement;
    }

    private File createFileInBackupPath(Map<String, Object> headerMap, String cloudName, String fileName, boolean isMail) throws IOException {
        logger.info("Entering createFileInBackupPath ");
        String backupBatchId = (String)headerMap.get("backupBatchId");
        if (StringUtils.isEmpty((Object)backupBatchId)) {
            backupBatchId = "FIXME-INBA";
        }
        String deviceUUID = (String)headerMap.get("deviceUUID");
        String deviceTempPath = PCHelperConstant.getMntTempChunkPath() + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupBatchId;
        File uploadBackupPath = new File(deviceTempPath);
        uploadBackupPath.mkdirs();
        if (isMail) {
            String itemId = (String)headerMap.get("odItemId");
            logger.debug("...changem md5 for filenamemail..." + itemId);
            String md5 = MD5Generator.generateMD5OfString((String)itemId);
            fileName = md5 + ".tmp";
        }
        String filePath = uploadBackupPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName;
        logger.info("File path: " + filePath);
        File tempFilePath = new File(filePath);
        if (tempFilePath.exists()) {
            logger.info("Temp file exists so deleting the file####");
            tempFilePath.delete();
        }
        try {
            tempFilePath.createNewFile();
        }
        catch (IOException e) {
            logger.error("....unable to create filepppp...");
            logger.error(tempFilePath + "....unable to create filepppp..." + e.getMessage());
        }
        logger.info("Leaving createFileInBackupPath");
        return tempFilePath;
    }

    private void checkNThrottleAndUploadFileV2(String cloudName, String gatewayName, InputStream inputStream, long fileSize, ChunkFileElement chunkFileElement, String sourceFilePath, String osType, String indexPath, String batchId) throws InterruptedException {
        this.chunkableUploadService.uploadChunkableFileToBackUp(cloudName, inputStream, chunkFileElement, osType, false, indexPath, batchId);
    }

    private List<String> getBackupIdAppendedToChunks(List<String> newChunkList, String newBackupId) {
        ArrayList<String> resChunkList = new ArrayList<String>();
        for (String chunkName : newChunkList) {
            resChunkList.add(chunkName + "." + newBackupId);
        }
        Collections.sort(resChunkList);
        return resChunkList;
    }

    protected FileInfo getFileInfo(BluKryptElement bluKryptElement, String backupId, String prevBackupId, List<String> list) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setChunkFiles(new ArrayList());
        fileInfo.setFileName(bluKryptElement.getFileName());
        fileInfo.setId(backupId);
        fileInfo.setFilePath(bluKryptElement.getFilePath());
        fileInfo.setDeviceUUID(bluKryptElement.getDeviceUUID());
        fileInfo.setOsType(bluKryptElement.getOsType());
        fileInfo.setPrevBackupId(prevBackupId);
        fileInfo.setUserName(bluKryptElement.getUserName());
        fileInfo.getChunkFiles().addAll(list);
        return fileInfo;
    }

    private String getUploadFilePath(String deviceUUID, String cloudName, String batchId) {
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID;
        if (!StringUtils.isEmpty((Object)batchId)) {
            deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        }
        return deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
    }

    private List<String> moveFilesFromTmpPath(String deviceUUID, List<String> orgChunks, String chunkPath, String batchId) throws Exception {
        ArrayList<String> chunkNames = new ArrayList<String>();
        for (String chunkName : orgChunks) {
            String path = PCHelperConstant.getMntTempChunkPath() + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
            String srcfilePath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
            File fileObj = new File(srcfilePath);
            if (fileObj.exists()) {
                File chunkDir = new File(chunkPath);
                if (!chunkDir.exists()) {
                    chunkDir.mkdirs();
                }
                String destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
                String newChunkName = chunkName;
                int dedupCount = 1;
                while (new File(destPath).exists()) {
                    logger.debug("file is exist in destination path>>>>>>: " + destPath);
                    destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName + "_" + dedupCount;
                    newChunkName = chunkName + "_" + dedupCount;
                    ++dedupCount;
                }
                chunkNames.add(newChunkName);
                logger.debug("newChunkName check exists :" + newChunkName);
                File destFile = new File(destPath);
                if (fileObj.exists()) {
                    Files.move(fileObj.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                logger.debug("destFile :" + destFile.getAbsolutePath());
                continue;
            }
            logger.debug("....file not exixts......" + srcfilePath);
            throw new Exception(FILE_NOT_EXISTS);
        }
        return chunkNames;
    }

    private void closeInputStreamAndDelTempFile(File tempFilePath, InputStream inputStream) {
        if (inputStream != null) {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (tempFilePath != null && tempFilePath.exists()) {
            tempFilePath.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int upload(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        CloudBackupController.printLogs("Entering upload!", PCHelperConstant.isBrevityLogging());
        InputStream inputStream = dataStream;
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1) {
                OfficeBackupPolicy backupPolicy = this.uploadService.getOfficeBackupPolicyForUser(cloudId, bluKryptElement.getUserName());
                boolean isFileAllowed = true;
                if (backupPolicy.isContentIndexEnabled() && isFileAllowed) {
                    isSearchEnabled = true;
                }
            }
            if (isSearchEnabled) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug("index path" + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            assert (Boolean.parseBoolean(isNormalFile));
            logger.debug(" Before calling insert query ...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, false);
            backupId = fileUploadDetailsElement.getBkpId();
            if (StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                int file2;
                File file2;
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, false);
                if (!StringUtils.isEmpty((Object)indexPath) && (file2 = new File(indexPath)).exists()) {
                    file2.delete();
                }
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    file2 = 200;
                    return file2;
                }
                if (ALREADY_EXISTS.equalsIgnoreCase(backupId)) {
                    file2 = 200;
                    return file2;
                }
                file2 = 409;
                return file2;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (headerMap.get("hasAttachments") != null) {
                fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            }
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            if (!StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (!StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            fileInfo.setBatchId(batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean fileExists = false;
            logger.debug("Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            List<String> moveFilesFromTmpPath = this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            fileInfo.getChunkFiles().clear();
            fileInfo.getChunkFiles().addAll(moveFilesFromTmpPath);
            if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(moveFilesFromTmpPath, fileInfo.getId());
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            logger.debug("...isfileexistsisSearchEnabled....." + fileExists + "...." + isSearchEnabled);
            if (fileExists) {
                this.uploadService.updateFileInfo(cloudName, "", fileInfo);
                this.removeDriveItem(driveFileInfoId, false);
            } else {
                fileInfo.setGatewayName(PCHelperConstant.getComponentName());
                this.updateStorageUtilization(cloudName, batchId, deviceUUID, list, fileUploadDetailsElement);
                fileInfo.setReducePGSize(true);
                this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, false);
                logger.debug(".. start of adding search index....");
                bluKryptElement.setDeviceUUID(device.getDeviceUUID());
                if (isSearchEnabled) {
                    SearchIndex index = this.formSearchIndex(1, bluKryptElement, new ObjectId(backupId), fsPath, device.getId());
                    index.setDeviceType(device.getDeviceType());
                    index.setDeviceName(device.getDeviceName());
                    this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                    logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + index.getDeviceId());
                }
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadMail(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud, OfficeBackupPolicy backupPolicy) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        InputStream inputStream = dataStream;
        logger.debug("Entering mail upload!");
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && backupPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            if (isSearchEnabled) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug(".....isSearchEnabled...." + isSearchEnabled);
            logger.debug("index path" + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            logger.debug(" Before calling insert query mail...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, true);
            backupId = fileUploadDetailsElement.getBkpId();
            if (StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, true);
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    int n = 200;
                    return n;
                }
                int n = 409;
                return n;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            fileInfo.setSubject((String)headerMap.get("subject"));
            fileInfo.setFrom((String)headerMap.get("from"));
            fileInfo.setBodyContent((String)headerMap.get("bodyContent"));
            fileInfo.setCcRecipients((String)headerMap.get("ccRecipients"));
            fileInfo.setBccRecipients((String)headerMap.get("bccRecipients"));
            fileInfo.setToRecipients((String)headerMap.get("toRecipients"));
            fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            fileInfo.setFromAddr((String)headerMap.get("fromAddr"));
            fileInfo.setCcRecipientsAddr((String)headerMap.get("ccRecipientsAddr"));
            fileInfo.setBccRecipientsAddr((String)headerMap.get("bccRecipientsAddr"));
            fileInfo.setToRecipientsAddr((String)headerMap.get("toRecipientsAddr"));
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            if (headerMap.get("toRecipientsAddress") != null) {
                fileInfo.setToRecipientsAddress((List)headerMap.get("toRecipientsAddress"));
            }
            if (headerMap.get("ccRecipientsAddress") != null) {
                fileInfo.setCcRecipientsAddress((List)headerMap.get("ccRecipientsAddress"));
            }
            if (headerMap.get("bccRecipientsAddress") != null) {
                fileInfo.setBccRecipientsAddress((List)headerMap.get("bccRecipientsAddress"));
            }
            if (headerMap.get("fromEmailAddress") != null) {
                fileInfo.setFromEmailAddress((OutlookEmailAddress)headerMap.get("fromEmailAddress"));
            }
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (!StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (!StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(list, backupId);
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            fileInfo.setBatchId(batchId);
            logger.debug("..batchidpath...." + batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean isFullBackup = true;
            boolean fileExists = false;
            logger.debug(fileUploadDetailsElement.getFileSize() + "Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            this.updateMailStorageUtilization(deviceUUID, fileUploadDetailsElement);
            fileInfo.setReducePGSize(true);
            boolean isLocalSaveSuccess = this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, true);
            logger.debug("...savelocalsuccess..." + isLocalSaveSuccess);
            logger.debug(".....mail isSearchEnabled...." + isSearchEnabled);
            if (isSearchEnabled) {
                if (headerMap.get("fsMailPath") != null) {
                    // empty if block
                }
                SearchIndex index = this.formMailSearchIndex(1, bluKryptElement, new ObjectId(backupId), fsPath, device.getId());
                index.setSubject(fileInfo.getSubject());
                index.setFrom(fileInfo.getFrom());
                index.setBodyContent(fileInfo.getBodyContent());
                index.setCcRecipients(fileInfo.getCcRecipients());
                index.setBccRecipients(fileInfo.getBccRecipients());
                index.setToRecipients(fileInfo.getToRecipients());
                index.setHasAttachments(fileInfo.isHasAttachments());
                index.setAttachments(fileInfo.getAttachments());
                index.setCcRecipientsAddr(fileInfo.getCcRecipientsAddr());
                index.setFromAddr(fileInfo.getFromAddr());
                index.setBccRecipientsAddr(fileInfo.getBccRecipientsAddr());
                index.setToRecipientsAddr(fileInfo.getToRecipientsAddr());
                logger.debug("....torecepientsaddress ......" + fileInfo.getToRecipientsAddr());
                index.setDeviceType(device.getDeviceType());
                index.setDeviceName(device.getDeviceName());
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + index.getDeviceId());
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadContacts(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud, OfficeBackupPolicy backupPolicy) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        InputStream inputStream = dataStream;
        logger.debug("Entering Contacts upload!");
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            bluKryptElement.setFilePath("Contacts");
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && backupPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            if (isSearchEnabled = false) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug(".....isSearchEnabled...." + isSearchEnabled);
            logger.debug("index path" + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            logger.debug(" Before calling insert query mail...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, true);
            backupId = fileUploadDetailsElement.getBkpId();
            if (StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, true);
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    int n = 200;
                    return n;
                }
                int n = 409;
                return n;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            if (headerMap.get("hasAttachments") == null) {
                headerMap.put("hasAttachments", false);
            }
            logger.debug("..attachphoto...." + headerMap.get("hasAttachments"));
            fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            fileInfo.setSubject((String)headerMap.get("subject"));
            fileInfo.setFrom((String)headerMap.get("from"));
            logger.debug("......mob...." + headerMap.get("contactMobile"));
            if (headerMap.get("contactMobile") != null) {
                fileInfo.setContactMobile((String)headerMap.get("contactMobile"));
            }
            if (headerMap.get("contactAddrStreet") != null) {
                fileInfo.setContactAddrStreet((String)headerMap.get("contactAddrStreet"));
            }
            if (headerMap.get("contactAddrCity") != null) {
                fileInfo.setContactAddrCity((String)headerMap.get("contactAddrCity"));
            }
            if (headerMap.get("contactAddrState") != null) {
                fileInfo.setContactAddrState((String)headerMap.get("contactAddrState"));
            }
            if (headerMap.get("contactAddrCountry") != null) {
                fileInfo.setContactAddrCountry((String)headerMap.get("contactAddrCountry"));
            }
            if (headerMap.get("contactAddrPostalCode") != null) {
                fileInfo.setContactAddrPostalCode((String)headerMap.get("contactAddrPostalCode"));
            }
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (!StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (!StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(list, backupId);
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            fileInfo.setBatchId(batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean isFullBackup = true;
            boolean fileExists = false;
            logger.debug(fileUploadDetailsElement.getFileSize() + "Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            this.updateMailStorageUtilization(deviceUUID, fileUploadDetailsElement);
            fileInfo.setReducePGSize(true);
            boolean isLocalSaveSuccess = this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, true);
            logger.debug("...savelocalsuccess..." + isLocalSaveSuccess);
            logger.debug(".....mail isSearchEnabled...." + isSearchEnabled);
            if (isSearchEnabled) {
                if (headerMap.get("fsMailPath") != null) {
                    // empty if block
                }
                SearchIndex index = this.formMailSearchIndex(1, bluKryptElement, new ObjectId(backupId), fsPath, device.getId());
                index.setSubject(fileInfo.getSubject());
                index.setFrom(fileInfo.getFrom());
                index.setBodyContent(fileInfo.getBodyContent());
                index.setCcRecipients(fileInfo.getCcRecipients());
                index.setBccRecipients(fileInfo.getBccRecipients());
                index.setToRecipients(fileInfo.getToRecipients());
                index.setHasAttachments(fileInfo.isHasAttachments());
                index.setAttachments(fileInfo.getAttachments());
                index.setCcRecipientsAddr(fileInfo.getCcRecipientsAddr());
                index.setFromAddr(fileInfo.getFromAddr());
                index.setBccRecipientsAddr(fileInfo.getBccRecipientsAddr());
                index.setToRecipientsAddr(fileInfo.getToRecipientsAddr());
                logger.debug("....torecepientsaddress ......" + fileInfo.getToRecipientsAddr());
                index.setDeviceType(device.getDeviceType());
                index.setDeviceName(device.getDeviceName());
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + index.getDeviceId());
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadTasks(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud, OfficeBackupPolicy backupPolicy) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        InputStream inputStream = dataStream;
        logger.debug("Entering Contacts upload!");
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            bluKryptElement.setFilePath("Tasks");
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && backupPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            if (isSearchEnabled = false) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug(".....isSearchEnabled...." + isSearchEnabled);
            logger.debug("index path" + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            logger.debug(" Before calling insert query mail...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, true);
            backupId = fileUploadDetailsElement.getBkpId();
            if (StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, true);
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    int n = 200;
                    return n;
                }
                int n = 409;
                return n;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            logger.debug("..attachphoto...." + headerMap.get("hasAttachments"));
            if (headerMap.get("hasAttachments") != null) {
                fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            }
            fileInfo.setSubject((String)headerMap.get("subject"));
            fileInfo.setFrom((String)headerMap.get("from"));
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (!StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (!StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            if (!StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(list, backupId);
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            fileInfo.setBatchId(batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean isFullBackup = true;
            boolean fileExists = false;
            logger.debug(fileUploadDetailsElement.getFileSize() + "Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            this.updateMailStorageUtilization(deviceUUID, fileUploadDetailsElement);
            fileInfo.setReducePGSize(true);
            boolean isLocalSaveSuccess = this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, true);
            logger.debug("...savelocalsuccess..." + isLocalSaveSuccess);
            logger.debug(".....mail isSearchEnabled...." + isSearchEnabled);
            if (isSearchEnabled) {
                if (headerMap.get("fsMailPath") != null) {
                    // empty if block
                }
                SearchIndex index = this.formMailSearchIndex(1, bluKryptElement, new ObjectId(backupId), fsPath, device.getId());
                index.setSubject(fileInfo.getSubject());
                index.setFrom(fileInfo.getFrom());
                index.setBodyContent(fileInfo.getBodyContent());
                index.setCcRecipients(fileInfo.getCcRecipients());
                index.setBccRecipients(fileInfo.getBccRecipients());
                index.setToRecipients(fileInfo.getToRecipients());
                index.setHasAttachments(fileInfo.isHasAttachments());
                index.setAttachments(fileInfo.getAttachments());
                index.setCcRecipientsAddr(fileInfo.getCcRecipientsAddr());
                index.setFromAddr(fileInfo.getFromAddr());
                index.setBccRecipientsAddr(fileInfo.getBccRecipientsAddr());
                index.setToRecipientsAddr(fileInfo.getToRecipientsAddr());
                logger.debug("....torecepientsaddress ......" + fileInfo.getToRecipientsAddr());
                index.setDeviceType(device.getDeviceType());
                index.setDeviceName(device.getDeviceName());
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + index.getDeviceId());
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    protected SearchIndex formSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, String fsPath, ObjectId deviceId) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setCloudId(cloudId);
        searchIndex.setBackup(false);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        searchIndex.setOneDrive(true);
        searchIndex.setDeviceUUID(bluKryptElement.getDeviceUUID());
        searchIndex.setDeviceId(deviceId);
        return searchIndex;
    }

    protected SearchIndex formMailSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, String fsPath, ObjectId deviceId) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setBackup(false);
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        searchIndex.setMail(true);
        searchIndex.setDeviceUUID(bluKryptElement.getDeviceUUID());
        searchIndex.setDeviceId(deviceId);
        return searchIndex;
    }

    private void updateStorageUtilization(String cloudName, String batchId, String deviceUUID, List<String> list, FileUploadDetailsElement fileUploadDetailsElement) {
        long pgChunkSize = 0L;
        if (!CollectionUtils.isEmpty(list)) {
            String chunkFolderPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
            chunkFolderPath = chunkFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            for (String chunkName : list) {
                try {
                    File file = new File(chunkFolderPath + chunkName).getAbsoluteFile();
                    pgChunkSize += file.length() / 1024L;
                }
                catch (Exception e) {
                    logger.debug(".......Exception...." + e.getMessage());
                }
            }
        }
        logger.debug("..................total pgChunkSizeInKB............" + pgChunkSize);
        this.utilService.updateStorageUtilized(1, deviceUUID, fileUploadDetailsElement.getFileSize(), fileUploadDetailsElement.getLatestVersionSize(), pgChunkSize);
    }

    private void updateMailStorageUtilization(String deviceUUID, FileUploadDetailsElement fileUploadDetailsElement) {
        long pgChunkSize = fileUploadDetailsElement.getFileSize();
        logger.debug("..................total pgChunkSizeInKB............" + pgChunkSize);
        this.utilService.updateStorageUtilized(1, deviceUUID, fileUploadDetailsElement.getFileSize(), fileUploadDetailsElement.getLatestVersionSize(), pgChunkSize);
    }

    public static String getPropertyFileValueParabluFolderBasePath(String cloudName) {
        return PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + "/f/";
    }

    public static String getFsPath(String md5) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd-MM-yyyy");
        Date date = new Date();
        String baseFolder = sdfDate.format(date) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + String.valueOf(date.getTime());
        String fileName = md5;
        return baseFolder + fileName;
    }

    @Override
    public void removeDriveItem(String driveFileInfoId, boolean isMail) {
        this.uploadService.removeFileInfoForAlreadyExists(driveFileInfoId, isMail);
    }

    public boolean initialize() {
        boolean success = true;
        if (CloudBackupController.getContext() == null) {
            logger.info("Application context not set!");
            return false;
        }
        try {
            if (this.backupService == null) {
                this.backupService = (BackupService)CloudBackupController.getContext().getBean("BackupServiceImpl", BackupService.class);
                if (this.backupService == null) {
                    success = false;
                    logger.error("failed to get backupService");
                }
            }
            if (this.utilService == null) {
                this.utilService = (UtilService)CloudBackupController.getContext().getBean("UtilServiceImpl", UtilService.class);
                if (this.utilService == null) {
                    success = false;
                    logger.error("failed to get utilService");
                }
            }
            if (this.uploadService == null) {
                this.uploadService = (UploadService)CloudBackupController.getContext().getBean("UploadService", UploadService.class);
                if (this.uploadService == null) {
                    success = false;
                    logger.error("failed to get chunkableUploadService");
                }
            }
            if (this.chunkableUploadService == null) {
                this.chunkableUploadService = (ChunkableUploadService)CloudBackupController.getContext().getBean("ChunkableUploadService", ChunkableUploadService.class);
                if (this.chunkableUploadService != null) {
                    success = false;
                    logger.error("failed to get chunkableUploadService");
                }
            }
            if (this.componentSettingService == null) {
                this.componentSettingService = (ComponentSettingService)CloudBackupController.getContext().getBean("ComponentSettingServiceImpl", ComponentSettingService.class);
                if (this.componentSettingService == null) {
                    success = false;
                    logger.error("failed to get componentSettingService");
                }
            }
            if (this.jobConfigService == null) {
                this.jobConfigService = (JobConfigService)CloudBackupController.getContext().getBean("JobConfigServiceImpl", JobConfigService.class);
                if (this.jobConfigService == null) {
                    success = false;
                    logger.error("failed to get jobConfigService");
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            e.printStackTrace(System.out);
            success = false;
        }
        return success;
    }

    @Override
    public void run() {
        try {
            logger.info("Invoking storage service!");
            try {
                sem.acquire(1);
            }
            catch (InterruptedException e) {
                logger.error("Failed to acquire semaphore! ", (Throwable)e);
            }
            Thread.sleep(100L);
            logger.info("Invoking storage service!");
            if (!StorageService.GETINST.initialize(this, this.utilService, this.componentSettingService, this.jobConfigService)) {
                logger.error("Failed to init storage service!");
                return;
            }
            if (!OfficeRestoreService.GETINST.initialize(this, this.utilService, this.syncDownloadService, this.downloadService)) {
                logger.error("Failed to init OfficeRestoreService  service!");
                return;
            }
            StorageService.GETINST.run();
            OfficeRestoreService.GETINST.run();
            logger.info("^^^^^^^^^^^^^^DONE^^^^^^^^^^^^^^^^^^^");
        }
        catch (InterruptedException e) {
            logger.error("Woke up!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Something bad happened while executing test", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    UploadStatus uploadAsync(UploadStatus status, Map<String, Object> fileProperties) {
        long fileSize = 0L;
        Cloud cloud = this.utilService.getCloud(1);
        String currentUploadIPToUse = PCHelperConstant.getComponentName();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("gatewayName", currentUploadIPToUse);
        parameters.put("dedupifiedBackupId", "false");
        parameters.put("maxVersions", String.valueOf("10"));
        parameters.put("is-base-folder", String.valueOf(false));
        parameters.put("is-folder", String.valueOf(false));
        parameters.put("is-exists", String.valueOf(true));
        String batchId = (String)fileProperties.get("backupBatchId");
        parameters.put("backupBatchId", batchId);
        parameters.put("userUnderLegalHold", String.valueOf(true));
        parameters.put("userName", (String)fileProperties.get("userName"));
        String deviceUUID = (String)fileProperties.get("deviceUUID");
        parameters.put("deviceUUID", deviceUUID);
        parameters.put("file-path", (String)fileProperties.get("file-path"));
        parameters.put("file-name", (String)fileProperties.get("file-name"));
        parameters.put("driveFileInfoId", (String)fileProperties.get("driveFileInfoId"));
        String messageId = (String)fileProperties.get("itemID");
        parameters.put("odItemId", messageId);
        logger.debug(".... parent id set for parameter.... " + fileProperties.get("parentItemID"));
        if (fileProperties.get("parentItemID") != null) {
            parameters.put("parentItemID", (String)fileProperties.get("parentItemID"));
        }
        String cloudName = cloud.getCloudName();
        parameters.put("cloudName", cloudName);
        parameters.put("prevGatewayName", currentUploadIPToUse);
        parameters.put("osType", "Android");
        parameters.put("restartId", String.valueOf(0));
        parameters.put("isFullBackup", Boolean.valueOf(fileProperties.get("isFullBackup").toString()).toString());
        Boolean isMail = Boolean.valueOf(fileProperties.get("isMail").toString());
        Boolean isContact = Boolean.valueOf(fileProperties.get("isContact").toString());
        Boolean isTasks = Boolean.valueOf(fileProperties.get("isTasks").toString());
        Boolean isInPlaceArchive = Boolean.valueOf(fileProperties.get("isInPlaceArchive").toString());
        parameters.put("isMail", isMail.toString());
        File tempFilePath = null;
        logger.debug("....deviceUUID available... " + deviceUUID);
        String accessToken = "";
        isContact = false;
        if (isContact.booleanValue()) {
            Object chunkFiles;
            Object arrObj;
            logger.debug("...inside contacts...... ");
            logger.debug(messageId + "..... contacts uppload...." + fileProperties.get("graphUserId"));
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            String graphuserId = (String)fileProperties.get("graphUserId");
            Contact contact = graphClient.users(graphuserId).contacts(messageId).buildRequest(new Option[0]).get();
            try {
                ProfilePhoto profilePhoto = graphClient.users(graphuserId).contacts(messageId).photo().buildRequest(new Option[0]).get();
                ArrayList<MailAttachment> updatedAttachments = new ArrayList<MailAttachment>();
                if (profilePhoto != null) {
                    String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
                    logger.debug("... profilePhoto available... " + profilePhoto.id);
                    String attachId = profilePhoto.id;
                    String attachname = "photo";
                    String downloadedNameobj = CloudBackupController.downloadPhoto(accessToken, attachId, attachname, graphuserId, messageId, chunkPath, cloudName);
                    logger.debug(downloadedNameobj + "........attachu1.........");
                    arrObj = downloadedNameobj.split("~~");
                    String downloadedName = arrObj[0];
                    String fsPath = arrObj[1];
                    logger.debug(downloadedNameobj + "........attachu........." + downloadedName);
                    MailAttachment updatedAttachmentFile = new MailAttachment();
                    updatedAttachmentFile.setId(attachId);
                    updatedAttachmentFile.setName(attachname);
                    chunkFiles = new ArrayList<String>();
                    updatedAttachmentFile.setChunkFiles(chunkFiles);
                    chunkFiles.add(downloadedName);
                    updatedAttachmentFile.setChunkFiles(chunkFiles);
                    updatedAttachments.add(updatedAttachmentFile);
                    parameters.put("fileMD5", downloadedName);
                    parameters.put("hasAttachments", true);
                }
                parameters.put("attachments", updatedAttachments);
            }
            catch (Error eee) {
                logger.error(".. no photo available");
            }
            catch (GraphServiceException ee) {
                if (ee.getResponseCode() != 404) {
                    logger.error("...error trying to download photo....." + ee.getMessage());
                }
            }
            catch (Exception eee) {
                logger.error(".. excno photo available" + eee.getMessage());
            }
            logger.debug(".....contacts after...." + fileProperties.get("userName"));
            LinkedList<String> empty = new LinkedList<String>();
            String md5val2 = "contact";
            parameters.put("fileMD5", md5val2);
            parameters.put("file-name", contact.displayName);
            logger.debug(contact.displayName + "...disp..." + contact.mobilePhone);
            parameters.put("contactMobile", contact.mobilePhone);
            parameters.put("contactAddrStreet", contact.homeAddress.street);
            parameters.put("contactAddrCity", contact.homeAddress.city);
            parameters.put("contactAddrState", contact.homeAddress.state);
            parameters.put("contactAddrCountry", contact.homeAddress.countryOrRegion);
            parameters.put("contactAddrPostalCode", contact.homeAddress.postalCode);
            OfficeBackupPolicy officeBackupPolicy = this.uploadService.getOfficeBackupPolicyForUser(cloud.getCloudId(), (String)fileProperties.get("userName"));
            parameters.put("graphUserId", graphuserId);
            try {
                tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", true);
                File temp = new File(tempFilePath.getAbsolutePath());
                if (temp.exists()) {
                    temp.delete();
                }
                temp.createNewFile();
                parameters.put("modified", String.valueOf(temp.lastModified()));
            }
            catch (IOException e2) {
                logger.error("error trying to create new files " + e2.getMessage(), (Throwable)e2);
            }
            logger.debug("...json-string ... " + contact.oDataType);
            ByteArrayInputStream inputStream2 = new ByteArrayInputStream(contact.oDataType.getBytes());
            logger.debug(tempFilePath.getAbsolutePath() + "................." + inputStream2);
            Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
            try {
                Files.copy(inputStream2, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException downloadedNameobj) {
                // empty catch block
            }
            try {
                FileInputStream is4 = new FileInputStream(tempFilePath);
                arrObj = null;
                try {
                    try {
                        String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                        logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                        parameters.put("fileMD5", md5);
                    }
                    catch (Exception e3) {
                        logger.error("MD5 computation failed", (Throwable)e3);
                    }
                    fileSize = Files.size(tempFilePath.toPath());
                    parameters.put("file-size", String.valueOf(fileSize));
                    int statusval = this.uploadContacts(parameters, is4, 1, empty, cloud, officeBackupPolicy);
                    logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                    logger.debug(".....Contacts............" + parameters.get("file-size"));
                    fileProperties.put("file-size", parameters.get("file-size"));
                    boolean isSuccess = false;
                    if (statusval == 200) {
                        isSuccess = true;
                    }
                    UploadStatus uploadStatus6 = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                    chunkFiles = uploadStatus6;
                    return chunkFiles;
                }
                catch (Throwable statusval) {
                    arrObj = statusval;
                    throw statusval;
                }
                finally {
                    if (is4 != null) {
                        if (arrObj != null) {
                            try {
                                is4.close();
                            }
                            catch (Throwable throwable2) {
                                ((Throwable)arrObj).addSuppressed(throwable2);
                            }
                        } else {
                            is4.close();
                        }
                    }
                }
            }
            catch (Exception e4) {
                logger.error("Failed to get the file in right path!", (Throwable)e4);
                return status;
            }
        }
        if (isTasks.booleanValue()) {
            Object jsonObject;
            logger.debug("...inside tasks...... ");
            logger.debug(messageId + "..... tasks uppload...." + fileProperties.get("graphUserId"));
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            String graphuserId = (String)fileProperties.get("graphUserId");
            String downloadurl = "https://graph.microsoft.com/beta/users/" + graphuserId + "/outlook/tasks/" + messageId;
            String deltaLinkForNext = "";
            String taskId = "";
            String taskSubject = "";
            Date taskStartDate = null;
            Date taskDueDate = null;
            Date taskReminderTime = null;
            JSONObject taskObject = new JSONObject();
            try {
                String deltaLink = "";
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpGet httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Accept", "application/json");
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
                httpGet.addHeader("Prefer", "odata.maxpagesize=20");
                HttpResponse response = client.execute((HttpUriRequest)httpGet);
                int statusCode = response.getStatusLine().getStatusCode();
                logger.debug(" tasks Response Code : " + statusCode);
                if (statusCode == 200) {
                    String json = EntityUtils.toString((HttpEntity)response.getEntity());
                    jsonObject = new JSONObject(json);
                    if (!StringUtils.isEmpty((Object)json)) {
                        logger.debug("..obj..." + jsonObject);
                        taskId = jsonObject.optString("id");
                        taskStartDate = this.getDateVal(jsonObject.optString("startDateTime"));
                        taskDueDate = this.getDateVal(jsonObject.optString("dueDateTime"));
                        taskReminderTime = this.getDateVal(jsonObject.optString("reminderDateTime"));
                        taskSubject = jsonObject.optString("subject");
                        parameters.put("taskStartDate", taskStartDate);
                        parameters.put("taskDueDate", taskDueDate);
                        parameters.put("taskReminderTime", taskReminderTime);
                        parameters.put("taskSubject", taskSubject);
                    }
                    taskObject = jsonObject;
                }
            }
            catch (Exception e5) {
                logger.error("....error trying to get tasks....." + e5.getMessage());
            }
            logger.debug(taskSubject + ".....tasks after...." + fileProperties.get("userName") + "......" + taskDueDate);
            LinkedList<String> empty = new LinkedList<String>();
            String md5val32 = "task";
            parameters.put("fileMD5", md5val32);
            parameters.put("file-name", taskSubject);
            OfficeBackupPolicy officeBackupPolicy = this.uploadService.getOfficeBackupPolicyForUser(cloud.getCloudId(), (String)fileProperties.get("userName"));
            parameters.put("graphUserId", graphuserId);
            try {
                tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", true);
                File temp = new File(tempFilePath.getAbsolutePath());
                parameters.put("modified", String.valueOf(temp.lastModified()));
            }
            catch (IOException e6) {
                logger.error("..error trying to create msg ..." + e6.getMessage(), (Throwable)e6);
            }
            ByteArrayInputStream inputStream3 = new ByteArrayInputStream(taskObject.toString().getBytes());
            logger.debug(tempFilePath.getAbsolutePath() + "................." + inputStream3);
            Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
            try {
                Files.copy(inputStream3, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException json) {
                // empty catch block
            }
            try {
                FileInputStream is3 = new FileInputStream(tempFilePath);
                jsonObject = null;
                try {
                    UploadStatus uploadStatus5;
                    try {
                        String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                        logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                        parameters.put("fileMD5", md5);
                    }
                    catch (Exception e7) {
                        logger.error("MD5 computation failed", (Throwable)e7);
                    }
                    parameters.put("file-size", String.valueOf(Files.size(tempFilePath.toPath())));
                    fileSize = Files.size(tempFilePath.toPath());
                    int statusval = this.uploadTasks(parameters, is3, 1, empty, cloud, officeBackupPolicy);
                    logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                    logger.debug(".....Tasks............" + parameters.get("file-size"));
                    fileProperties.put("file-size", parameters.get("file-size"));
                    boolean isSuccess = false;
                    if (statusval == 200) {
                        isSuccess = true;
                    }
                    UploadStatus uploadStatus4 = uploadStatus5 = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                    return uploadStatus4;
                }
                catch (Throwable statusval) {
                    jsonObject = statusval;
                    throw statusval;
                }
                finally {
                    if (is3 != null) {
                        if (jsonObject != null) {
                            try {
                                is3.close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)jsonObject).addSuppressed(throwable5);
                            }
                        } else {
                            is3.close();
                        }
                    }
                }
            }
            catch (Exception e82) {
                logger.error("Failed to get the file in right path!", (Throwable)e82);
                return status;
            }
        }
        if (isInPlaceArchive.booleanValue()) {
            return status;
        }
        if (!isMail.booleanValue()) {
            DriveItemContentStreamRequestBuilder content;
            InputStream inputStream;
            block155: {
                logger.debug("...onedrive backup file..");
                GraphServiceClient<Request> graphClient = this.getGraphClient();
                String userName = (String)fileProperties.get("userName");
                com.parablu.pcbd.domain.User user = this.utilService.getUserInfoByName(cloud.getCloudId(), userName);
                String driveId = this.getDriveIdForUser(cloud, user.getEmailId());
                Object drives1 = null;
                inputStream = null;
                content = null;
                String fileName = (String)fileProperties.get("file-name");
                try {
                    if ("$$%^&malarefile.txt".equalsIgnoreCase(fileName)) {
                        this.saveFailedFilesReason(cloud.getCloudId(), userName, 403, fileName, (String)fileProperties.get("file-path"), "malwareDetected", deviceUUID, "ONEDRIVE", batchId);
                        return new UploadStatus(messageId, false, 409, 0L);
                    }
                    logger.debug("...onedrive backup file1..");
                    content = graphClient.drives(driveId).items(messageId).content();
                    inputStream = content.buildRequest(new Option[0]).get();
                    logger.debug(messageId + "...onedrive backup file2......." + inputStream);
                    if (inputStream != null) break block155;
                    logger.debug("...retry one more time...." + messageId);
                    content = graphClient.drives(driveId).items(messageId).content();
                    inputStream = content.buildRequest(new Option[0]).get();
                    logger.debug(messageId + "...onedrive backup file2 after retry......." + inputStream);
                    if (inputStream == null) {
                        logger.debug("..stream is null so create zero kb file...");
                        inputStream = IOUtils.toInputStream((String)"   ");
                    }
                }
                catch (GraphServiceException e9) {
                    logger.error("....unable to get drive .... " + e9.getResponseCode());
                    if (e9.getResponseCode() == 403) {
                        logger.debug(e9.getError().error.message + ".....check for maleware..." + e9.getError().error.code);
                        if (e9.getError() != null && e9.getError().error != null && !StringUtils.isEmpty((Object)e9.getError().error.code) && "malwareDetected".equalsIgnoreCase(e9.getError().error.code)) {
                            this.saveFailedFilesReason(cloud.getCloudId(), userName, 403, fileName, (String)fileProperties.get("file-path"), "malwareDetected", deviceUUID, "ONEDRIVE", batchId);
                            return new UploadStatus(messageId, false, 409, 0L);
                        }
                    }
                    if (e9.getResponseCode() == 429 || e9.getResponseCode() == 401) {
                        logger.debug(".... retry .. after 2 mins.. ");
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException taskObject) {
                            // empty catch block
                        }
                    }
                    if (e9.getResponseCode() == 403) {
                        this.saveBlackListUser(cloud, userName);
                        return new UploadStatus(messageId, false, 403, 0L);
                    }
                    if (e9.getResponseCode() != 404) break block155;
                    try {
                        logger.debug(driveId + "...retry 404 driveid.." + messageId);
                        if ("$$%^&malarefile.txt".equalsIgnoreCase(fileName)) {
                            this.saveFailedFilesReason(cloud.getCloudId(), userName, 403, fileName, (String)fileProperties.get("file-path"), "malwareDetected", deviceUUID, "ONEDRIVE", batchId);
                            return new UploadStatus(messageId, false, 409, 0L);
                        }
                        logger.debug(driveId + "...onedrive backup file1 retry.." + messageId);
                        content = graphClient.drives(driveId).items(messageId).content();
                        inputStream = content.buildRequest(new Option[0]).get();
                        logger.debug(messageId + "...onedrive backup file2......." + inputStream);
                        if (inputStream == null) {
                            logger.debug("...retry one more time...." + messageId);
                            content = graphClient.drives(driveId).items(messageId).content();
                            inputStream = content.buildRequest(new Option[0]).get();
                            logger.debug(messageId + "...onedrive backup file2 after retry......." + inputStream);
                        }
                    }
                    catch (GraphServiceException eee) {
                        logger.debug(eee.getResponseCode() + "...unable to get file...." + messageId);
                        return new UploadStatus(messageId, false, 555, 0L);
                    }
                }
                catch (ClientException ee) {
                    this.sleep5sec();
                    graphClient = this.getGraphClient();
                    logger.debug("...onedrive backup file1..");
                    content = graphClient.drives(driveId).items(messageId).content();
                    inputStream = content.buildRequest(new Option[0]).get();
                    logger.debug("...onedrive backup file2..");
                }
            }
            try {
                tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + System.currentTimeMillis() + ".tmp", isMail);
                File temp = new File(tempFilePath.getAbsolutePath());
                parameters.put("modified", String.valueOf(temp.lastModified()));
            }
            catch (IOException e10) {
                logger.error(e10.getMessage(), (Throwable)e10);
                return new UploadStatus(messageId, false, -1, 0L);
            }
            logger.debug(tempFilePath.getAbsolutePath() + "................." + inputStream);
            Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
            if (!Files.exists(target, LinkOption.NOFOLLOW_LINKS)) {
                logger.error("....unable to download file....");
                return new UploadStatus(messageId, false, -1, 0L);
            }
            try {
                Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                inputStream.close();
            }
            catch (Exception e1) {
                logger.error("....unable to download file....");
                return new UploadStatus(messageId, false, -1, 0L);
            }
            LinkedList<String> empty = new LinkedList<String>();
            try (FileInputStream is2 = new FileInputStream(tempFilePath);){
                UploadStatus uploadStatus3;
                try {
                    String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                    logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloading..... " + md5);
                    parameters.put("fileMD5", md5);
                }
                catch (Exception e11) {
                    logger.error("MD5 computation failed", (Throwable)e11);
                }
                fileSize = Files.size(tempFilePath.toPath());
                parameters.put("file-size", String.valueOf(Files.size(tempFilePath.toPath())));
                logger.debug("Going to launch read");
                int statusval = this.upload(parameters, is2, 1, empty, cloud);
                logger.debug("^^^^^^^^^^^^^^^^^^^^status for onedrive^^^^^^^^^^^^^^^^^^^^^" + statusval);
                boolean isSuccess = false;
                if (statusval == 200) {
                    isSuccess = true;
                }
                if (tempFilePath.exists()) {
                    tempFilePath.delete();
                }
                inputStream.close();
                content = null;
                UploadStatus e82 = uploadStatus3 = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                return e82;
            }
            catch (Exception e12) {
                logger.error("Failed to get the file in right path!", (Throwable)e12);
                return status;
            }
        }
        try {
            List listAttachments;
            AttachmentCollectionPage AttachmentCollectionPage2;
            logger.debug(fileProperties.get("file-name") + "..... mail uppload...." + fileProperties.get("graphUserId"));
            LinkedList<String> empty = new LinkedList<String>();
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            String graphuserId = (String)fileProperties.get("graphUserId");
            Message message = null;
            int count = 0;
            int maxTries = 5;
            while (true) {
                try {
                    logger.debug(messageId + "...trying for time..." + count + "..." + maxTries);
                    message = graphClient.users(graphuserId).messages(messageId).buildRequest(new Option[0]).get();
                }
                catch (Exception ex) {
                    logger.error("...retry error new...." + ex.getMessage());
                    if (ex != null && !StringUtils.isEmpty((Object)ex.getMessage())) {
                        if (ex.getMessage().contains("Error code: ErrorItemNotFound")) return new UploadStatus(messageId, false, 555, 0L);
                        if (ex.getMessage().contains("Error code: ResourceNotFound")) {
                            return new UploadStatus(messageId, false, 555, 0L);
                        }
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException uploadStatus7) {
                        // empty catch block
                    }
                    logger.error(graphuserId + "..slept for 3 secs ....unable to get mail general.... " + messageId);
                    graphClient = this.getGraphClient();
                    if (++count != maxTries) continue;
                }
                break;
            }
            if (message == null) {
                int statusval = 234;
                return new UploadStatus(messageId, false, statusval, 0L);
            }
            try {
                String md5 = "mail";
                parameters.put("fileMD5", md5);
            }
            catch (Exception e) {
                logger.error("MD5 computation failed", (Throwable)e);
            }
            String subject = message.subject;
            if (StringUtils.isEmpty((Object)subject)) {
                subject = "(No subject)";
            }
            logger.debug(".....Subject....." + subject);
            parameters.put("file-name", subject);
            LinkedList<String> inputIdsList = new LinkedList<String>();
            ExchangeIdFormat sourceIdType = ExchangeIdFormat.REST_ID;
            ExchangeIdFormat targetIdType = ExchangeIdFormat.EWS_ID;
            inputIdsList.add(messageId);
            UserTranslateExchangeIdsParameterSet exchangeIdsParameterSet = new UserTranslateExchangeIdsParameterSet();
            exchangeIdsParameterSet.inputIds = inputIdsList;
            exchangeIdsParameterSet.targetIdType = targetIdType;
            exchangeIdsParameterSet.sourceIdType = sourceIdType;
            UserTranslateExchangeIdsCollectionPage post = (UserTranslateExchangeIdsCollectionPage)((UserTranslateExchangeIdsCollectionRequest)graphClient.users(graphuserId).translateExchangeIds(exchangeIdsParameterSet).buildRequest(new Option[0])).post();
            List convertedIdPages = post.getCurrentPage();
            String ewsId = "";
            for (ConvertIdResult convertIdResult : convertedIdPages) {
                logger.debug(inputIdsList.size() + "...converted ewsidsss ...." + convertIdResult.targetId);
                ewsId = convertIdResult.targetId;
            }
            parameters.put("ewsId", ewsId);
            parameters.put("subject", subject);
            if (message.from != null) {
                parameters.put("from", message.from.emailAddress.name);
                parameters.put("fromAddr", message.from.emailAddress.address);
                OutlookEmailAddress senderEmail = new OutlookEmailAddress();
                senderEmail.setAddress(message.from.emailAddress.address);
                senderEmail.setName(message.from.emailAddress.name);
                parameters.put("fromEmailAddress", senderEmail);
            }
            parameters.put("bodyContent", message.body.content);
            String cccRecipients = "";
            String ccRecipientsAddr = "";
            ArrayList<OutlookEmailAddress> ccMails = new ArrayList<OutlookEmailAddress>();
            if (message.ccRecipients != null) {
                cccRecipients = message.ccRecipients.stream().map(a -> String.valueOf(a.emailAddress.name)).collect(Collectors.joining(","));
                ccRecipientsAddr = message.ccRecipients.stream().map(a -> String.valueOf(a.emailAddress.address)).collect(Collectors.joining(","));
                for (Recipient ccRec : message.ccRecipients) {
                    OutlookEmailAddress ccEmail = new OutlookEmailAddress();
                    ccEmail.setAddress(ccRec.emailAddress.address);
                    ccEmail.setName(ccRec.emailAddress.name);
                    ccMails.add(ccEmail);
                }
            }
            parameters.put("ccRecipients", cccRecipients);
            parameters.put("ccRecipientsAddr", ccRecipientsAddr);
            parameters.put("ccRecipientsAddress", ccMails);
            ArrayList<OutlookEmailAddress> bccMails = new ArrayList<OutlookEmailAddress>();
            List bccRecipientsCol = message.bccRecipients;
            String bccRecipients = "";
            String bccRecipientsAddr = "";
            if (bccRecipientsCol != null) {
                bccRecipients = bccRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.name)).collect(Collectors.joining(","));
                bccRecipientsAddr = bccRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.address)).collect(Collectors.joining(","));
                for (Recipient bccRec : bccRecipientsCol) {
                    OutlookEmailAddress bccEmail = new OutlookEmailAddress();
                    bccEmail.setAddress(bccRec.emailAddress.address);
                    bccEmail.setName(bccRec.emailAddress.name);
                    bccMails.add(bccEmail);
                }
            }
            parameters.put("bccRecipients", bccRecipients);
            parameters.put("bccRecipientsAddr", bccRecipientsAddr);
            parameters.put("bccRecipientsAddress", bccMails);
            ArrayList<OutlookEmailAddress> toMails = new ArrayList<OutlookEmailAddress>();
            List toRecipientsCol = message.toRecipients;
            String toRecipients = "";
            String toRecipientsAddr = "";
            if (toRecipientsCol != null) {
                toRecipients = toRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.name)).collect(Collectors.joining(","));
                toRecipientsAddr = toRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.address)).collect(Collectors.joining(","));
                for (Recipient toRec : toRecipientsCol) {
                    OutlookEmailAddress toEmail = new OutlookEmailAddress();
                    toEmail.setAddress(toRec.emailAddress.address);
                    toEmail.setName(toRec.emailAddress.name);
                    toMails.add(toEmail);
                }
            }
            parameters.put("toRecipients", toRecipients);
            parameters.put("toRecipientsAddr", toRecipientsAddr);
            parameters.put("toRecipientsAddress", toMails);
            parameters.put("hasAttachments", (boolean)message.hasAttachments);
            OfficeBackupPolicy officeBackupPolicy = this.uploadService.getOfficeBackupPolicyForUser(cloud.getCloudId(), (String)fileProperties.get("userName"));
            parameters.put("graphUserId", graphuserId);
            if (message.sentDateTime != null && message.sentDateTime.toInstant() != null) {
                SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                String date = df2.format(message.sentDateTime.toInstant().toEpochMilli());
                parameters.put("sentDate", date);
            }
            logger.debug("..attachaaa.." + message.hasAttachments);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
            boolean fileAllowed = true;
            ArrayList<MailAttachment> updatedAttachments = new ArrayList<MailAttachment>();
            if (message.hasAttachments != null && message.hasAttachments.booleanValue() && (AttachmentCollectionPage2 = (AttachmentCollectionPage)((AttachmentCollectionRequest)graphClient.users(graphuserId).messages(messageId).attachments().buildRequest(new Option[0])).get()) != null && !CollectionUtils.isEmpty((Collection)(listAttachments = AttachmentCollectionPage2.getCurrentPage()))) {
                for (Attachment attachment : listAttachments) {
                    try {
                        Attachment attachmentObj = null;
                        do {
                            try {
                                attachmentObj = graphClient.users(graphuserId).messages(messageId).attachments(attachment.id).buildRequest(new Option[0]).get();
                            }
                            catch (ClientException ee) {
                                logger.error("..error trying to  get attachment obj wait for 5 secs....");
                                Thread.sleep(5000L);
                                attachmentObj = null;
                            }
                        } while (attachmentObj == null);
                        logger.debug("... attachments available... " + attachmentObj.id);
                        String attachId = attachmentObj.id;
                        String attachname = attachmentObj.name;
                        boolean skipFileBasedonSize = CloudBackupController.checkFileSize((long)attachment.size, Long.parseLong(officeBackupPolicy.getMailMaxFileSize()));
                        logger.debug("...check skip attachments because of size ..." + skipFileBasedonSize);
                        if (skipFileBasedonSize || !fileAllowed) continue;
                        boolean extcheck = this.checkForExtensions(attachname, officeBackupPolicy.getMailInclusionFilter(), officeBackupPolicy.getMailFilterType());
                        if (!StringUtils.isEmpty((Object)attachname) && (attachname = attachname.trim()).contains("/")) {
                            attachname = attachname.replaceAll("/", "-");
                        }
                        if (StringUtils.isEmpty((Object)attachname)) continue;
                        logger.debug(extcheck + "...EXTCHECK...." + attachname);
                        fileAllowed = extcheck;
                        if (!extcheck) continue;
                        String downloadedNameobj = null;
                        do {
                            try {
                                downloadedNameobj = this.downloadAttachment(accessToken, attachId, attachname, graphuserId, messageId, chunkPath, cloudName);
                            }
                            catch (ClientException ee) {
                                logger.error("..error trying to  get downloadedNameobj obj wait for 5 secs....");
                                Thread.sleep(5000L);
                                downloadedNameobj = null;
                            }
                        } while (StringUtils.isEmpty((Object)downloadedNameobj));
                        logger.debug(downloadedNameobj + "........attachu1.........");
                        String[] arrObj = downloadedNameobj.split("~~");
                        String downloadedName = arrObj[0];
                        String fsPath = arrObj[1];
                        logger.debug(downloadedNameobj + "........attachu........." + downloadedName);
                        MailAttachment updatedAttachmentFile = new MailAttachment();
                        BeanUtils.copyProperties((Object)attachment, (Object)updatedAttachmentFile);
                        updatedAttachmentFile.setId(attachment.id);
                        updatedAttachmentFile.setName(attachment.name);
                        updatedAttachmentFile.setSize(attachment.size);
                        updatedAttachmentFile.setContentType(attachment.contentType);
                        ArrayList<String> chunkFiles = new ArrayList<String>();
                        updatedAttachmentFile.setChunkFiles(chunkFiles);
                        chunkFiles.add(downloadedName);
                        updatedAttachmentFile.setChunkFiles(chunkFiles);
                        updatedAttachments.add(updatedAttachmentFile);
                        parameters.put("fileMD5", downloadedName);
                    }
                    catch (Exception e) {
                        logger.error("..error trying to get attach..... " + e.getMessage());
                    }
                }
                parameters.put("attachments", updatedAttachments);
            }
            if (!fileAllowed) {
                logger.debug("...ext not allowed so exclude...");
                int statusval = 234;
                return new UploadStatus(messageId, false, statusval, 0L);
            }
            if (CollectionUtils.isEmpty(updatedAttachments)) {
                parameters.put("hasAttachments", false);
            }
            try {
                tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", isMail);
                File temp = new File(tempFilePath.getAbsolutePath());
                parameters.put("modified", String.valueOf(temp.lastModified()));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new UploadStatus(messageId, false, -1, 0L);
            }
            logger.debug(graphuserId + "........before downloadmail........." + messageId);
            InputStream inputStream = this.downloadMail(graphuserId, messageId);
            logger.debug(tempFilePath.getAbsolutePath() + "........after download........." + inputStream);
            Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
            if (!Files.exists(target, LinkOption.NOFOLLOW_LINKS)) {
                logger.error("....unable to download file....");
                return new UploadStatus(messageId, false, -1, 0L);
            }
            try {
                Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try (FileInputStream is = new FileInputStream(tempFilePath);){
                UploadStatus uploadStatus2;
                try {
                    String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                    logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                    parameters.put("fileMD5", md5);
                }
                catch (Exception e) {
                    logger.error("MD5 computation failed", (Throwable)e);
                }
                fileSize = Files.size(tempFilePath.toPath());
                parameters.put("file-size", String.valueOf(fileSize));
                logger.debug("Going to launch read" + parameters.get("ewsId"));
                int statusval = this.uploadMail(parameters, is, 1, empty, cloud, officeBackupPolicy);
                logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                logger.debug(".....MAILSIZEEE............" + parameters.get("file-size"));
                fileProperties.put("file-size", parameters.get("file-size"));
                boolean isSuccess = false;
                if (statusval == 200) {
                    isSuccess = true;
                }
                if (tempFilePath.exists()) {
                    tempFilePath.delete();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                UploadStatus uploadStatus = uploadStatus2 = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                return uploadStatus;
            }
            catch (Exception e) {
                logger.error("Failed to get the file in right path!", (Throwable)e);
                return status;
            }
        }
        catch (ClientException e) {
            logger.error(e.getMessage() + "... mail not found1........." + fileProperties.get("file-name"));
            return new UploadStatus(messageId, false, 409, 0L);
        }
    }

    private void sleep5sec() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void saveFailedFilesReason(int cloudId, String userName, int responseCode, String fileName, String filePath, String reason, String deviceUUID, String osType, String batchId) {
        FailedFileReason failedFileReason = new FailedFileReason();
        failedFileReason.setUserName(userName);
        failedFileReason.setResponseCode(responseCode);
        failedFileReason.setFileName(fileName);
        failedFileReason.setFilePath(filePath);
        failedFileReason.setOsType(osType);
        failedFileReason.setDeviceUUID(deviceUUID);
        failedFileReason.setReason(reason);
        failedFileReason.setBatchId(batchId);
        this.utilService.saveFailedFilesReason(cloudId, failedFileReason);
    }

    private void saveBlackListUser(Cloud cloud, String userName) {
        O365BlackListUser o365BlackListUser = new O365BlackListUser();
        o365BlackListUser.setUserName(userName);
        o365BlackListUser.setResponseCode("404");
        o365BlackListUser.setLocalHost(PCHelperConstant.getComponentName());
        this.utilService.saveO365BlackListUser(cloud.getCloudId(), o365BlackListUser);
    }

    private boolean checkForExtensions(String fileName, List<InclusionFilter> inclusionFilterList, String filterType) {
        boolean allow = false;
        if (CollectionUtils.isEmpty(inclusionFilterList)) {
            return true;
        }
        HashSet<String> inclusionFilterExtensions = new HashSet<String>();
        HashSet<String> exclusionFilterExtensions = new HashSet<String>();
        boolean allowAllextensions = false;
        for (InclusionFilter inclusionFilter : inclusionFilterList) {
            if (inclusionFilter == null) continue;
            String[] extensions = inclusionFilter.getExtensionName().split(",");
            if (!StringUtils.isEmpty((Object)filterType) && filterType.equalsIgnoreCase("exclusion")) {
                for (String ext : extensions) {
                    ext = ext.toLowerCase();
                    exclusionFilterExtensions.add(ext);
                }
            } else {
                for (String ext : extensions) {
                    ext = ext.toLowerCase();
                    inclusionFilterExtensions.add(ext);
                }
            }
            if (allowAllextensions) continue;
            allowAllextensions = inclusionFilterExtensions.contains("all");
        }
        logger.debug(inclusionFilterExtensions.size() + "....filterlist... " + exclusionFilterExtensions.size());
        for (String ext : inclusionFilterExtensions) {
            logger.debug(".....inclusion list val..." + ext);
        }
        for (String ext : exclusionFilterExtensions) {
            logger.debug(".....exclusion list val..." + ext);
        }
        if (!allowAllextensions) {
            if (exclusionFilterExtensions.size() > 0 && !exclusionFilterExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
                allow = true;
            } else if (inclusionFilterExtensions.size() > 0 && inclusionFilterExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
                allow = true;
            }
        } else {
            allow = true;
        }
        return allow;
    }

    private Date getDateVal(String dateValue) {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        try {
            JSONObject dateObj = new JSONObject(dateValue);
            date = simpleDateFormat.parse(dateObj.getString("dateTime").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    private static boolean checkFileSize(Long fileSize, long allowedSize) {
        boolean isFileTobeSkipped = true;
        if (allowedSize != 0L && allowedSize != -1L) {
            long fileSizeinBytes = fileSize;
            float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
            if (fileSizeinMb <= (float)allowedSize) {
                isFileTobeSkipped = false;
            }
        } else if (allowedSize == -1L) {
            isFileTobeSkipped = false;
        }
        return isFileTobeSkipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadAttachment(String accessToken, String attachId, String attachname, String userId, String msgId, String filePath, String cloudName) {
        String downloadurl = "https://graph.microsoft.com/v1.0/users/" + userId + "/messages/" + msgId + "/attachments/" + attachId + "/$value";
        String downloadedName = "";
        try {
            logger.debug("...start download attachment .....");
            OkHttpClient okHttpClient = CloudBackupController.getOkHttpClient();
            HttpUrl.Builder httpBuilder = HttpUrl.parse((String)downloadurl).newBuilder();
            Request request = new Request.Builder().url(httpBuilder.build()).build();
            Response response = okHttpClient.newCall(request).execute();
            InputStream inputStream = response.body().byteStream();
            int responseCode = response.code();
            logger.debug("...attachment download responsecode...." + responseCode);
            String fullpath = filePath + "/" + attachname;
            logger.debug("... file PAth...." + fullpath);
            File parent = new File(filePath);
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File file = null;
            try {
                file = new File(fullpath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
            }
            catch (Exception e) {
                fullpath = filePath + "/" + System.currentTimeMillis();
                file = new File(fullpath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
            }
            byte[] b = new byte[4096];
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            try (FileOutputStream outstream = new FileOutputStream(file);){
                int buff = -1;
                while ((buff = inputStream.read(b)) != -1) {
                    outstream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
                logger.error(file.getAbsolutePath() + "  tranferFileFromStream > getSizeinMb(intermediateFile.length()) ................ " + CloudBackupController.getSizeinMb(file.length()));
            }
            catch (FileNotFoundException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception While Transfering File From Stream :" + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            try {
                response.close();
            }
            catch (Exception e1) {
                logger.error("..unable to close....");
            }
            String uploadedFileMd5Checksum = MD5Generator.generateMD5OfFile((File)file);
            File chunkFile = new File(filePath + "/" + uploadedFileMd5Checksum);
            logger.debug(attachname + "....renamechunk...." + uploadedFileMd5Checksum);
            file.renameTo(chunkFile);
            downloadedName = uploadedFileMd5Checksum;
            String fsPath = CloudBackupController.getFsPath(downloadedName);
            try {
                if (file.exists()) {
                    file.delete();
                }
                if (chunkFile.exists()) {
                    chunkFile.delete();
                }
                downloadedName = downloadedName + "~~" + fsPath;
                logger.debug(" end of move file to search path" + downloadedName);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" Error trying to create index file ....... " + e.getMessage());
            }
        }
        catch (ClientProtocolException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Exception", (Throwable)e);
        }
        return downloadedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadPhoto(String accessToken, String attachId, String attachname, String userId, String msgId, String filePath, String cloudName) {
        String downloadurl = "https://graph.microsoft.com/v1.0/users/" + userId + "/contacts/" + msgId + "/photo/$value";
        String downloadedName = "";
        try {
            OkHttpClient okHttpClient = CloudBackupController.getOkHttpClient();
            HttpUrl.Builder httpBuilder = HttpUrl.parse((String)downloadurl).newBuilder();
            Request request = new Request.Builder().url(httpBuilder.build()).build();
            Response response = okHttpClient.newCall(request).execute();
            InputStream inputStream = response.body().byteStream();
            int responseCode = response.code();
            String fullpath = filePath + "/" + attachname;
            logger.debug("... file PAth...." + fullpath);
            File parent = new File(filePath);
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File file = new File(fullpath);
            file.createNewFile();
            byte[] b = new byte[4096];
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            try (FileOutputStream outstream = new FileOutputStream(file);){
                int buff = -1;
                while ((buff = inputStream.read(b)) != -1) {
                    outstream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
                logger.error(file.getAbsolutePath() + "  tranferFileFromStream > getSizeinMb(intermediateFile.length()) ................ " + CloudBackupController.getSizeinMb(file.length()));
            }
            catch (FileNotFoundException e) {
                logger.error("Exception", (Throwable)e);
                file.delete();
            }
            catch (IOException e) {
                logger.error("Exception", (Throwable)e);
                file.delete();
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception While Transfering File From Stream :" + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            response.close();
            String uploadedFileMd5Checksum = MD5Generator.generateMD5OfFile((File)file);
            File chunkFile = new File(filePath + "/" + uploadedFileMd5Checksum);
            logger.debug(attachname + "....renamechunk...." + uploadedFileMd5Checksum);
            file.renameTo(chunkFile);
            downloadedName = uploadedFileMd5Checksum;
            String fsPath = CloudBackupController.getFsPath(downloadedName);
            String indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            logger.debug("...indexpat..." + indexPath);
            try {
                downloadedName = downloadedName + "~~" + fsPath;
                logger.debug(" end of move file to search path" + downloadedName);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" Error trying to create index file ....... " + e.getMessage());
            }
        }
        catch (ClientProtocolException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Exception", (Throwable)e);
        }
        return downloadedName;
    }

    private InputStream downloadMail(String userId, String msgId) {
        GraphServiceClient<Request> graphClient = this.getGraphClient();
        InputStream inputStream = null;
        try {
            inputStream = graphClient.users(userId).messages(msgId).content().buildRequest(new Option[0]).get();
        }
        catch (GraphServiceException e) {
            logger.error("..codeerrror..." + e.getResponseCode());
            if (e.getResponseCode() == 429) {
                List responseHeaders = e.getResponseHeaders();
                for (String responseHeader : responseHeaders) {
                    logger.debug(responseHeader + "...response hearder....");
                }
            }
        }
        catch (ClientException cli) {
            logger.debug("...client exception  wait for 5 sec and retry... ");
            this.sleep5sec();
            inputStream = this.getGraphClient().users(userId).messages(msgId).content().buildRequest(new Option[0]).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(".....exception trying to download email...." + e.getMessage());
        }
        return inputStream;
    }

    private static InputStream downloadContact(String accessToken, String userId, String contactId) {
        String downloadurl = "https://graph.microsoft.com/v1.0/users/" + userId + "/contacts/" + contactId + "/$value";
        InputStream inputStream = null;
        try {
            OkHttpClient okHttpClient = CloudBackupController.getOkHttpClient();
            HttpUrl.Builder httpBuilder = HttpUrl.parse((String)downloadurl).newBuilder();
            Request request = new Request.Builder().url(httpBuilder.build()).build();
            Response response = okHttpClient.newCall(request).execute();
            inputStream = response.body().byteStream();
            int responseCode = response.code();
            response.close();
            logger.debug(" Response status code: " + responseCode);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return inputStream;
    }

    @Override
    public CompletableFuture<UploadStatus> notifyService(Map<String, ? super Object> fileProperties, InputStream buffer) {
        UploadStatus status = new UploadStatus((String)fileProperties.get("messageID"), true, 0, 0L);
        CompletableFuture<UploadStatus> statusWhenDone = new CompletableFuture<UploadStatus>();
        UploadStatus newStatus = this.uploadAsync(status, fileProperties);
        statusWhenDone.complete(newStatus);
        return statusWhenDone;
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoList(int cloudId) {
        return this.utilService.getDriveFileInfoList();
    }

    @Override
    public void deleteBatchFromOdServer(ObjectId id, String policyName) {
        this.utilService.deleteBatchFromOdServer(id, policyName);
    }

    @Override
    public List<ODBBackupBatch> getODBBatchList(int cloudId, String policyName) {
        return this.utilService.getODBBatchList(policyName);
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        return this.utilService.getDriveFileInfoFromListForBatchId(batchId);
    }

    @Override
    public List<MailBackupBatch> getMailBatchList(int cloudId, String policyName) {
        return this.utilService.getMailBatchList(cloudId, policyName);
    }

    @Override
    public List<RestoreEvents> getRestoreEventsList(int cloudId, String policyName) {
        return this.utilService.getRestoreEventsList(cloudId, policyName);
    }

    @Override
    public long getTotalFilesCountByBatchId(int cloudId, String batchId) {
        return this.utilService.getTotalFilesCountByBatchId(batchId);
    }

    @Override
    public List<DriveFileInfo> getOneDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        return this.utilService.getOneDriveFileInfoFromListForBatchId(cloudId, batchId);
    }

    public static synchronized String getEWSAccesToken(EWSAppSetting ewsAppSetting) {
        String accessToken = "";
        try {
            long now = System.currentTimeMillis();
            ExecutorService es = Executors.newFixedThreadPool(2);
            AuthenticationContext context = new AuthenticationContext(AUTHORITY + ewsAppSetting.getTenantId(), false, es);
            AuthenticationCallback<AuthenticationResult> callback = new AuthenticationCallback<AuthenticationResult>(){

                public void onSuccess(AuthenticationResult result) {
                    logger.debug("received token");
                }

                public void onFailure(Throwable exc) {
                    throw new RuntimeException(exc);
                }
            };
            logger.debug("requesting token");
            Future future = context.acquireToken(RESOURCE, new ClientCredential(ewsAppSetting.getClientId(), ewsAppSetting.getClientSecretKey()), (AuthenticationCallback)callback);
            AuthenticationResult result = (AuthenticationResult)future.get(30L, TimeUnit.SECONDS);
            accessToken = result.getAccessToken();
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return accessToken;
    }

    public static ExchangeService getAuthenticatedService(String token, String senderAddr) {
        ExchangeService service = null;
        try {
            service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
            service.getHttpHeaders().put("Authorization", "Bearer " + token);
            service.getHttpHeaders().put("X-AnchorMailbox", senderAddr);
            service.setUrl(new URI(EWS_URL));
            service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.PrincipalName, senderAddr));
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return service;
    }

    @Override
    public void addFailedFiles(DriveFileInfo item, String policyName) {
        this.uploadService.addFailedFiles(item, policyName);
    }

    @Override
    public List<DriveFileInfo> getFailedFiles(String deviceUUID) {
        return this.uploadService.getFailedFiles(deviceUUID);
    }

    @Override
    public List<ODBBackupBatch> getODBBatchList(int cloudId, String policyName, int limit) {
        return this.utilService.getODBBatchList(policyName, limit);
    }

    public static OkHttpClient getOkHttpClient() {
        String authorityHost = "https://login.microsoftonline.com";
        OkHttpClient httpClient = null;
        if (!StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            Authenticator proxyAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)PCHelperConstant.getProxyUserName(), (String)PCHelperConstant.getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            };
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()))).proxyAuthenticator(proxyAuthenticator).build();
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().build();
        }
        return httpClient;
    }

    private GraphServiceClient<Request> getGraphClient() {
        String authorityHost = "https://login.microsoftonline.com";
        logger.debug("...helper constant ...." + PCHelperConstant.getMSClientId());
        GraphServiceClient graphClient = null;
        if (!StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            logger.debug("....using proxy latest......");
            InetSocketAddress proxyInetAddress = new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort());
            logger.debug("....using proxy latest before createDefault 1bb......" + PCHelperConstant.getProxyHost() + "..pwd..." + PCHelperConstant.getProxyPort());
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            HttpClientOptions clientOptions = new HttpClientOptions();
            clientOptions.setProxyOptions(proxyOptions);
            logger.debug("....using proxy latest before createDefault 2a with host latest");
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            OkHttpClient httpClient = null;
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyInetAddress);
            logger.debug("....using proxy latest before createDefault 3a");
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(proxy).build();
            logger.debug("....using proxy latest before createDefault 4");
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)httpClient).buildClient();
            logger.debug("....using proxy latest before createDefault 5");
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
        }
        return graphClient;
    }

    private String getDriveIdForUser(Cloud cloud, String emailId) {
        Drive drive = null;
        try {
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
            int retryDrive = 0;
            do {
                drive = CloudBackupController.getDrive(graphClient, userId);
                logger.debug(++retryDrive + "....drive for user...." + drive);
                Thread.sleep(10000L);
            } while (retryDrive < 5 && drive == null || drive == null);
            if (drive != null) {
                logger.debug(emailId + "....drive id for user ... " + drive.id);
                return drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    return this.getDriveIdForUser(cloud, emailId);
                }
                catch (InterruptedException interruptedException) {
                }
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + emailId);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return null;
    }

    private static Drive getDrive(GraphServiceClient<Request> graphClient, String userId) {
        Drive drive = graphClient.users(userId).drive().buildRequest(new Option[0]).get();
        return drive;
    }

    static {
        sem = new Semaphore(1);
        System.setProperty("DEBUG.MONGO", "true");
        System.setProperty("DB.TRACE", "true");
        try {
            sem.acquire(1);
        }
        catch (InterruptedException e) {
            logger.error("Failed to acquire semaphore! ", (Throwable)e);
        }
    }
}

