/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;

public class RecipientInfo
implements DEREncodable {
    private DEREncodable info;

    public RecipientInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        this.setInfo(keyTransRecipientInfo);
    }

    public RecipientInfo(KeyAgreeRecipientInfo keyAgreeRecipientInfo) {
        this.setInfo(keyAgreeRecipientInfo);
    }

    public RecipientInfo(KEKRecipientInfo kEKRecipientInfo) {
        this.setInfo(kEKRecipientInfo);
    }

    public RecipientInfo(DEREncodable dEREncodable) {
        block5: {
            block4: {
                if (!(dEREncodable instanceof BERTaggedObject)) break block4;
                BERTaggedObject bERTaggedObject = (BERTaggedObject)dEREncodable;
                switch (bERTaggedObject.getTagNo()) {
                    case 1: {
                        this.info = KeyAgreeRecipientInfo.getInstance(bERTaggedObject);
                        break block5;
                    }
                    case 2: {
                        this.info = KEKRecipientInfo.getInstance(bERTaggedObject);
                        break block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid RecipientInfo");
                    }
                }
            }
            this.info = KeyTransRecipientInfo.getInstance(dEREncodable);
        }
    }

    public RecipientInfo(RecipientInfo recipientInfo) {
        this.info = recipientInfo.info;
    }

    public static RecipientInfo getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientInfo) {
            return (RecipientInfo)object;
        }
        if (object instanceof DEREncodable) {
            return new RecipientInfo((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientInfo");
    }

    public static RecipientInfo newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientInfo) {
            return new RecipientInfo((RecipientInfo)object);
        }
        if (object instanceof DEREncodable) {
            return new RecipientInfo((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientInfo");
    }

    public DEREncodable getInfo() {
        return this.info;
    }

    private void setInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        this.info = keyTransRecipientInfo;
    }

    private void setInfo(KeyAgreeRecipientInfo keyAgreeRecipientInfo) {
        this.info = keyAgreeRecipientInfo;
    }

    private void setInfo(KEKRecipientInfo kEKRecipientInfo) {
        this.info = kEKRecipientInfo;
    }

    public DERObject getDERObject() {
        if (this.info instanceof KeyAgreeRecipientInfo) {
            return new BERTaggedObject(1, this.info.getDERObject());
        }
        if (this.info instanceof KEKRecipientInfo) {
            return new BERTaggedObject(2, this.info.getDERObject());
        }
        return this.info.getDERObject();
    }
}

