/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.aspose.email.FileCorruptedException;
import com.aspose.email.License;
import com.aspose.email.MailMessage;
import com.aspose.email.MapiMessage;
import com.aspose.email.PersonalStorage;
import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.microsoft.graph.requests.GraphServiceClient;
import com.parablu.helper.utils.MD5Generator;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.EncryptionKeyDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EncryptionKey;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.MailAttachment;
import com.parablu.pcbd.domain.MailInfo;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.PrivacyGatewayMapping;
import com.parablu.pcbd.domain.PstBatchDetail;
import com.parablu.pcbd.domain.RestoreBackUpImage;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.RestoredFiles;
import com.parablu.pcbd.domain.User;
import com.parablu.query.util.BackupFileQueryElement;
import com.pg.controller.Graph;
import com.pg.dao.BackupFileDao;
import com.pg.dao.FileDao;
import com.pg.dao.OneDriveDao;
import com.pg.dao.SyncFileDao;
import com.pg.domain.FileInfo;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.element.RestoreElement;
import com.pg.encryption.service.FileEncryptionService;
import com.pg.exception.BlukryptClientAbortException;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.odb.util.OneDriveUtil;
import com.pg.paracloud.to.DownloadFileTO;
import com.pg.paracloud.to.DownloadTO;
import com.pg.service.CloudSupportService;
import com.pg.service.DownloadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import com.pg.util.ResourceFileHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletResponse;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.zeroturnaround.zip.ZipUtil;

@Service
public class DownloadServiceImpl
implements DownloadService {
    private static Logger logger = LogManager.getLogger(DownloadServiceImpl.class);
    private static final int BUFFER_CHUNK_SIZE = 1024;
    private static final String STOPPED_BACKUP_ERROR_CODE = "1207";
    private static final String PAUSED_BACKUP_ERROR_CODE = "1992";
    private Timer userRestoreTimer = null;
    private TimerTask userRestoreTimerTask = null;
    @Autowired
    private BackupFileDao backupFileDao;
    private static final String IS_TOMCAT_RUNNING = "isTomcatRunning";
    private static final String ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH = "ERROR Trying to download from orginal source path ..... ";
    private static final String MERGE = "merge";
    private static final String LOOP_BEFORE_DOWNLOAD_FILE = "for loop  BEFORE DOWNLOADING Chunks file  >>>>>> ";
    private static final String DECRYPTED = "decrypted";
    private static final String WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT = "@#@#@#@##### Writing outside to stream ....download count>>";
    private static final String PARABLU_OF = "----PARABLUEOF";
    private static final String CONTENT_DISPOSITION_FORM_DATA = "Content-Disposition: form-data;";
    private static final String CHUNK = "chunk";
    private static final String FILE_NAME = "fileName:";
    private static final String FILE_PATH = "filePath:";
    private static final String CLIENT_MODIFIED_TIME = "clientModifiedTime:";
    private static final String CLIENT_ACCESS_TIME = "accessTime:";
    private static final String MD5_CHECKSUM = "md5Checksum:";
    private static final String FILE_MD5 = " File md5 .......... ";
    private static final String COUNT = "count:";
    private static final String SKIP_VALUE = "skipValue:";
    private static final String ERROR_TRYING_TO_WRITE_DATA = "Error trying to write data .....%%%%%%%%% ";
    private static final String FILE_PATH_STR = "file path>>>";
    private static final String FILE_NAME_STR = "file name>>>";
    private static final String SOCKET_EXCEPTION = "SocketException";
    private static final String CLIENT_ABORT_EXCEPTION = "ClientAbortException";
    private static final String THROW_CLIENT_ABORT_EXCEPTION = " throw client abort exception .......";
    private static final String CLIENT_ABORTED = "Client Aborted";
    private static final String BACKUP = "backup";
    private static final String AZURE_DOWNLOAD_ERROR = "Azure download error";
    private static final String AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY = "Azure download error while get decrypt key";
    private static final String PARAMETERS = "parameters";
    private static final String PREFIX_HTTPS = "https://";
    private static final String NO_MERGE = "!!!!NO MERGE..................";
    private static final String ERROR_WHILE_TRYING_TO_WRITE_DATA = "Error trying to write data ..... ";
    private static final String SENDING_FILE = "Sending file ";
    private static final String IS_COMPRESSED = "$$$$$ isCompressed>>>>";
    private static final String BACKUP_FILE_IS_COMPRESSED = "Backup File is compressed>> ";
    private static final String FINISHED_FILE = "Finished file ";
    private static final String EXCEPTION_WHILE_RESTORE_FROM_CLOUD = "Exception While Restoring Files From Cloud :";
    private static final String EXCEPTION_WHILE_WRITTING_DATA_TO_STREAM = "Exception While Writting Data to Stream :";
    private static final String EXCEPTION_WHILE_GETTING_DECRYPTED_FILE = "Exception While Getting Decrypted File :";
    private static final String EXCEPTION_WHILE_BRUTE_FORCE_RESTORE_FROM_CLOUD = "Exception While Brute Force Restore From Cloud :";
    private static final String EXCEPTION_WHILE_SEARCHING_FOR_REPLICA_AND_RESTORE = "Exception While Searching for Replica and Restore :";
    private static final String COMPRESSION_ENABLED = "isCompressed:";
    private static final String CHUNK_DETAILS_NULL = "Chunk detail is null>>>>>>>>";
    private static final String CLOUD_CHUNK_NAME = "CLOUD CHUNK NAME>>>>>>>>>";
    private static final String VERSION = "(Version-";
    private static final String BACKUP_ID = "backupId";
    private static final String CLOUD_NAME = "cloudName";
    private static final String FILE_INFO_RECEIVED = " fileinfo recieved ....... ";
    private static final String FILE_META_INFO_RECEIVED = " file meta info recieved .... ";
    private static final String FILE_FROM_PG = " file from pg..................";
    private static final String FILEPATH = "filePath";
    private static final String BLUKRYPT_BUILDER_DOWNLOAD_FROM_PG = "/BluKryptBuilder/download/frompg/";
    private static final String FILE_NOT_FOUND = " @@@@@ FILE NOT FOUND .... ";
    private static final String STARTED = "STARTED";
    private static final String COMPLETED = "COMPLETED";
    private static final String COPY = "-copy";
    private static final String SYNC_DECRYPT_KEY = "d8e87c0927539672f54462c837be0b7f";
    private static final String UTF8 = "UTF-8";
    private static final String BATCH_ID_LOG = "##batch id >>>>";
    private TimerTask downloadTimerTask = null;
    private Timer downloadTimer = null;
    private List<PrivacyGateway> gatewayLists = null;
    @Autowired
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    @Autowired
    private EncryptionKeyDao encryptionKeyDao;
    @Autowired
    private BackUpImageDao backUpImageDao;
    @Autowired
    private PciAuthorizationTokensDao pciAuthorizationTokensDao;
    @Autowired
    private FileDao fileDao;
    @Autowired
    private OneDriveDao oneDriveDao;
    @Autowired
    private FileEncryptionService fileEncryptionService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private CloudSupportService cloudSupportService;
    @Autowired
    private SyncDownloadService syncDownloadService;
    @Autowired
    private SyncFileDao syncFileDao;

    public void setSyncFileDao(SyncFileDao syncFileDao) {
        this.syncFileDao = syncFileDao;
    }

    public void setSyncDownloadService(SyncDownloadService syncDownloadService) {
        this.syncDownloadService = syncDownloadService;
    }

    public void setBackupFileDao(BackupFileDao backupFileDao) {
        this.backupFileDao = backupFileDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setEncryptionKeyDao(EncryptionKeyDao encryptionKeyDao) {
        this.encryptionKeyDao = encryptionKeyDao;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setOneDriveDao(OneDriveDao oneDriveDao) {
        this.oneDriveDao = oneDriveDao;
    }

    public void setFileEncryptionService(FileEncryptionService fileEncryptionService) {
        this.fileEncryptionService = fileEncryptionService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setCloudSupportService(CloudSupportService cloudSupportService) {
        this.cloudSupportService = cloudSupportService;
    }

    @Override
    public DownloadTO restoreFileForExternalStorage(PciAuthorizationTokenElement authorizationTokenElement, String fileName, String folderPath, String saltKey, String deviceUUID, String backupId, String gatewayName, boolean isExternalDownload) {
        com.pg.domain.BackupFile dedupifiedFile;
        String mimeType = null;
        long fileSize = 0L;
        logger.debug(" @@@@@ Folder path for external Storage " + folderPath);
        String cloudName = authorizationTokenElement.getCloudName();
        String userName = authorizationTokenElement.getUserName();
        com.pg.domain.BackupFile backupFile = this.fileDao.getBackupFile(userName, cloudName, backupId, gatewayName);
        if (backupFile == null) {
            logger.debug(FILE_NOT_FOUND + backupId);
            throw new ParacloudBackupException(FILE_NOT_FOUND, 507);
        }
        if (!StringUtils.isEmpty((String)backupFile.getDedupBackupId()) && (dedupifiedFile = this.fileDao.getBackupFile(userName, cloudName, backupFile.getDedupBackupId(), gatewayName)) == null) {
            logger.debug(FILE_NOT_FOUND + backupId);
            throw new ParacloudBackupException(FILE_NOT_FOUND, 507);
        }
        ArrayList<String> nameList = new ArrayList<String>();
        logger.debug(" BEFORE DOWNLOADING Chunks  >>>>>> " + backupFile.getDeviceUUID());
        for (com.pg.domain.ChunkFile chunkFile : backupFile.getChunkFiles()) {
            BufferedInputStream inputStream;
            String accessToken = this.oneDriveDao.getOneDriveAccessToken(authorizationTokenElement);
            try {
                String url = "https://apis.live.net/v5.0/" + chunkFile.getFileId() + "/content?download=true&access_token=" + accessToken;
                logger.debug(" *****************NEW DOWNLOAD URL***************** " + url);
                inputStream = this.getInputStreamFromExternalStorage(url);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.debug(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                String url = chunkFile.getFileSource();
                logger.debug(url + "Retry to download ....." + e.getMessage());
                inputStream = this.getInputStreamFromExternalStorage(url);
            }
            this.getDecryptedFile(cloudName, saltKey, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream);
            nameList.add(chunkFile.getFileName());
        }
        logger.debug(" After DOWNLOADING Chunks  >>>>>> " + backupFile.getDeviceUUID());
        String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + backupFile.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String destPath = path + MERGE;
        String destFile = destPath + "/" + backupFile.getFileName();
        File destFolder = new File(destPath);
        if (destFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)destFolder);
        }
        com.pg.util.FileUtils.merge(nameList, (String)(path + DECRYPTED), (String)destFile);
        BufferedInputStream decryptedStream = null;
        try {
            decryptedStream = new BufferedInputStream(new FileInputStream(new File(destFile)), 1024);
            logger.debug("************************DOWNLOADED*********************************" + destFile);
        }
        catch (FileNotFoundException e) {
            logger.trace("" + e);
            logger.error(e + " Unable to get decrypt file stream " + backupFile.getFileName(), (Object)e.getMessage());
        }
        if (isExternalDownload) {
            String downloadPath = PCHelperConstant.getPropertyFileValueDefaultExtDownloadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            File sourceFile = new File(destFile);
            File file = new File(downloadPath + fileName);
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileUtils.copyFile((File)sourceFile, (File)file);
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error("Error trying to copy files to download folder ..... " + e.getMessage());
            }
        }
        DownloadTO downloadTO = new DownloadTO(mimeType, (InputStream)decryptedStream, fileSize, backupFile.getMd5());
        downloadTO.setPath(destFile);
        return downloadTO;
    }

    private BufferedInputStream getInputStreamFromExternalStorage(String url) {
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new URL(url).openStream(), 1024);
        }
        catch (Exception ex) {
            logger.trace("" + ex);
            throw new ParacloudBackupException("Error trying to Open file " + ex.getMessage(), 507);
        }
        return inputStream;
    }

    private File getDecryptedFile(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStream) {
        String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File decryptedDir = new File(path + DECRYPTED);
        if (!decryptedDir.exists()) {
            decryptedDir.mkdir();
        }
        this.createFolders(path);
        File decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        decryptedFile = this.fileEncryptionService.decrypt(saltKey, deviceUUID, inputStream, decryptedFile);
        return decryptedFile;
    }

    private void createFolders(String pathname) {
        File decryptedDir = this.createDecryptedDirs(pathname);
        if (decryptedDir != null) {
            logger.debug("Directory created successfully");
        }
    }

    @Override
    public long countOfFilesToDownload(int cloudId, RestoreElement restoreElement, String userName) {
        String cloudName = restoreElement.getCloudName();
        String deviceUUID = restoreElement.getDeviceUUID();
        String devicePath = restoreElement.getDevicePath();
        String fileName = restoreElement.getFileName();
        if (!StringUtils.isEmpty((String)restoreElement.getBackupId())) {
            return 1L;
        }
        long totalCount = restoreElement.isDownloadAllVersions() ? this.backupFileDao.totalCountOfAllBackupFileVersions(cloudId, cloudName, deviceUUID, devicePath, fileName, userName) : this.backupFileDao.countOfBackupFileLatestRecords(cloudId, cloudName, deviceUUID, devicePath, fileName, userName);
        return totalCount;
    }

    @Override
    public long restoreFilesFromCloud(Cloud cloud, RestoreElement restoreElement, String pUserName, HttpServletResponse response, int skipValue, long totalCount, long downloadedCount, Map<String, Long> fileVersionMap, boolean isEncodedEnabled, String serverModifiedTime) {
        return 0L;
    }

    private PciAuthorizationTokenElement getMSGTokenElement(MSGTokens msgTokens, User user) {
        PciAuthorizationTokenElement tokenElement = new PciAuthorizationTokenElement();
        if (msgTokens == null) {
            return tokenElement;
        }
        tokenElement.setAccessToken(msgTokens.getAccessToken());
        tokenElement.setClientId(msgTokens.getClientId());
        tokenElement.setClientSecret(msgTokens.getClientSecret());
        tokenElement.setRedirectUri(msgTokens.getRedirectUri());
        tokenElement.setRefreshToken(msgTokens.getRefreshToken());
        tokenElement.setAccountId(msgTokens.getAccountId());
        tokenElement.setSharePointUrl(msgTokens.getSharePointUrl());
        tokenElement.setCloudName(msgTokens.getCloudName());
        if (user != null) {
            if (StringUtils.isEmpty((String)user.getOdbLoginId())) {
                tokenElement.setAccountId(user.getEmailId());
            } else {
                tokenElement.setAccountId(user.getOdbLoginId());
            }
            tokenElement.setUserName(user.getUserName());
        }
        return tokenElement;
    }

    private String getDedupValue(String userName) {
        String dedupVal = null;
        User user = this.utilService.getUserInfoByName(1, userName);
        if (user != null) {
            OfficeBackupPolicy odbBackupPolicy;
            logger.debug("...user and policy...... " + userName + "......" + user.getPolicyName() + "......" + user.getOdbPolicyName());
            BackupPolicy backupPolicy = this.utilService.getBackupPolicy(1, user.getPolicyName());
            if (user.isBackupEnabled()) {
                if (backupPolicy != null) {
                    dedupVal = backupPolicy.getDedup();
                }
            } else if ((user.isOnedriveBkpEnabled() || user.isExchangeBkpEnabled()) && (odbBackupPolicy = this.utilService.getODBBackupPolicy(1, user.getOdbPolicyName())) != null) {
                dedupVal = odbBackupPolicy.getDedup();
            }
        }
        return dedupVal;
    }

    @Override
    public long restoreFilesFromCloudNew(Cloud cloud, RestoreElement restoreElement, String pUserName, HttpServletResponse response, int skipValue, long totalCount, long downloadedCount, Map<String, Long> fileVersionMap, String isImmediateFolderLevel, boolean isEncodedEnabled, String serverModifiedTime, boolean getDeletedFilesLatestVersion) {
        ByteArrayInputStream input;
        BufferedInputStream inputStream;
        byte[] bytes;
        GraphServiceClient<Request> graphClient;
        String chunkFilePath;
        Object batchId;
        List chunkFileList;
        String fileName;
        int lastDot;
        boolean isFileSame;
        boolean isGDEnabled;
        List rwlist;
        FileStatusElement fileStatusElement;
        Device device;
        ArrayList<FileInfo> clientDedupEnabledList;
        ArrayList<BackUpImage> pgBkpNoGatewayList;
        ArrayList<BackUpImage> pgBkpList;
        ArrayList<com.pg.domain.BackupFile> list;
        String restorePath;
        String path;
        String restoreId;
        String deviceUUID;
        String cloudName;
        int cloudId;
        Map<String, Long> fileVersionMapTemp;
        long downloadedCountTemp;
        String userName;
        block209: {
            BackupFileQueryElement backupFileQueryElement;
            block206: {
                boolean isFileSame2;
                block207: {
                    boolean isFileSame3;
                    com.pg.domain.BackupFile backupFile;
                    block208: {
                        boolean isFileSame32;
                        userName = pUserName;
                        downloadedCountTemp = downloadedCount;
                        fileVersionMapTemp = fileVersionMap;
                        cloudId = cloud.getCloudId();
                        cloudName = restoreElement.getCloudName();
                        deviceUUID = restoreElement.getDeviceUUID();
                        String devicePath = restoreElement.getDevicePath();
                        String fileNameVal = restoreElement.getFileName();
                        restoreId = restoreElement.getRestoreBatchId();
                        backupFileQueryElement = new BackupFileQueryElement();
                        backupFileQueryElement.setCloudId(cloudId);
                        backupFileQueryElement.setCloudName(cloudName);
                        backupFileQueryElement.setUserName(userName);
                        backupFileQueryElement.setDevicePath(devicePath);
                        backupFileQueryElement.setFileName(fileNameVal);
                        backupFileQueryElement.setDeviceUUID(deviceUUID);
                        backupFileQueryElement.setSkipValue(skipValue);
                        backupFileQueryElement.setFileVersionMap(fileVersionMapTemp);
                        path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
                        restorePath = path + restoreId + "/";
                        File restorePathDir = new File(restorePath);
                        if (!restorePathDir.exists()) {
                            restorePathDir.mkdirs();
                        }
                        list = new ArrayList<com.pg.domain.BackupFile>();
                        pgBkpList = new ArrayList<BackUpImage>();
                        pgBkpNoGatewayList = new ArrayList<BackUpImage>();
                        clientDedupEnabledList = new ArrayList<FileInfo>();
                        device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
                        String driveId = "";
                        fileStatusElement = new FileStatusElement();
                        rwlist = this.fileDao.getRWSampleFilesList(cloud.getCloudId());
                        isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                        if (StringUtils.isEmpty((String)restoreElement.getBackupId())) break block206;
                        logger.debug("...inside file level restore.....");
                        logger.debug(BATCH_ID_LOG + restoreId + " Only backup Id check ............. " + restoreElement.getBackupId());
                        backupFile = this.backupFileDao.getBackupFilesForId(cloudId, cloudName, userName, device, restoreElement.getBackupId(), getDeletedFilesLatestVersion);
                        if (backupFile != null && backupFile.getFileName() != null && (isFileSame32 = this.checkMd5(cloud.getCloudId(), backupFile.getFileName(), rwlist))) {
                            logger.debug("md5/file name is same so skip the file...........");
                            return downloadedCountTemp;
                        }
                        if (backupFile == null || CollectionUtils.isEmpty((Collection)backupFile.getChunkFiles())) break block207;
                        if (StringUtils.isEmpty((String)serverModifiedTime) || Long.parseLong(serverModifiedTime) == 0L) break block208;
                        logger.debug("#####################....." + Long.parseLong(serverModifiedTime));
                        long modifiedTime = Long.parseLong(serverModifiedTime);
                        List backUpImagesList = this.backUpImageDao.getVersions(cloudId, cloudName, backupFileQueryElement.getFileName(), backupFileQueryElement.getDevicePath(), device);
                        BackUpImage backUpImage = backUpImagesList.stream().filter(file -> !file.getStatus().equalsIgnoreCase(PCHelperConstant.REVISION_STATUS.DELETED.toString()) && file.getLastServerModifiedTime() <= modifiedTime).findFirst().orElse(null);
                        if (backUpImage == null) break block209;
                        logger.debug("...filteredImage....." + backUpImage.getId());
                        backupFile = this.backupFileDao.getBackupFilesForId(cloudId, cloudName, userName, device, backUpImage.getId().toString(), getDeletedFilesLatestVersion);
                        if (backupFile != null && backupFile.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), backupFile.getFileName(), rwlist))) {
                            logger.debug("md5/file name is same so skip the file...........");
                            return downloadedCountTemp;
                        }
                        if (backupFile == null) break block209;
                        list.add(backupFile);
                        break block209;
                    }
                    if (backupFile != null && backupFile.getFileName() != null && (isFileSame3 = this.checkMd5(cloud.getCloudId(), backupFile.getFileName(), rwlist))) {
                        logger.debug("md5/file name is same so skip the file...........");
                        return downloadedCountTemp;
                    }
                    list.add(backupFile);
                    break block209;
                }
                BackUpImage bkpImage = this.backUpImageDao.getBackupFileForID(cloudId, new ObjectId(restoreElement.getBackupId()), userName, device, getDeletedFilesLatestVersion);
                if (!StringUtils.isEmpty((String)serverModifiedTime) && Long.parseLong(serverModifiedTime) != 0L) {
                    long modifiedTime = Long.parseLong(serverModifiedTime);
                    List list2 = this.backUpImageDao.getVersions(cloudId, cloudName, backupFileQueryElement.getFileName(), backupFileQueryElement.getDevicePath(), device);
                    bkpImage = list2.stream().filter(file -> !file.getStatus().equalsIgnoreCase(PCHelperConstant.REVISION_STATUS.DELETED.toString()) && file.getLastServerModifiedTime() <= modifiedTime).findFirst().orElse(null);
                }
                if (bkpImage != null && bkpImage.getFileName() != null && (isFileSame2 = this.checkMd5(cloud.getCloudId(), bkpImage.getFileName(), rwlist))) {
                    logger.debug("md5/file name is same so skip the file...........");
                    return downloadedCountTemp;
                }
                if (bkpImage != null && !StringUtils.isEmpty((String)bkpImage.getGatewayName())) {
                    pgBkpList.add(bkpImage);
                }
                if (bkpImage != null && StringUtils.isEmpty((String)bkpImage.getGatewayName()) && StringUtils.isEmpty((String)bkpImage.getStoragePlace())) {
                    pgBkpNoGatewayList.add(bkpImage);
                }
                if (bkpImage == null || !StringUtils.isEmpty((String)bkpImage.getGatewayName())) break block209;
                logger.debug("inside no pg and no chunk files list$$$$$$$$$$$$ ");
                this.createBackupFile(list, bkpImage);
                break block209;
            }
            if (restoreElement.isDownloadAllVersions()) {
                logger.debug("inside download all version...");
                logger.debug(BATCH_ID_LOG + restoreId + " all-versions backup file........");
                backupFileQueryElement.setDownloadAllVersions(restoreElement.isDownloadAllVersions());
                List bkpImagelist = this.backupFileDao.getBackupFilesForGivenPathfromBackupImage(isImmediateFolderLevel, backupFileQueryElement, device, false, serverModifiedTime, getDeletedFilesLatestVersion);
                if (bkpImagelist == null) {
                    logger.debug(BATCH_ID_LOG + restoreId + " bkpimaged is null>>>>>>>>>>>so return");
                    response.setStatus(500);
                    return -1L;
                }
                for (BackUpImage backUpImage : bkpImagelist) {
                    List oldFiles;
                    if (backUpImage != null && StringUtils.isEmpty((String)backUpImage.getGatewayName()) && StringUtils.isEmpty((String)backUpImage.getStoragePlace())) {
                        pgBkpNoGatewayList.add(backUpImage);
                    }
                    if (StringUtils.isEmpty((String)backUpImage.getStoragePlace()) && !StringUtils.isEmpty((String)backUpImage.getGatewayName())) {
                        pgBkpList.add(backUpImage);
                        continue;
                    }
                    ArrayList<ObjectId> backupIds = new ArrayList<ObjectId>();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
                        logger.debug("Chunk is empty so get chunk from MD5");
                        BackUpImage parentBkpImage = this.backupFileDao.getParentBackupImageForMd5(cloudId, backUpImage.getMd5Checksum(), device);
                        if (parentBkpImage != null && !CollectionUtils.isEmpty((Collection)parentBkpImage.getChunkFiles())) {
                            backUpImage.setChunkFiles(parentBkpImage.getChunkFiles());
                            this.backUpImageDao.saveImageToBackUp(cloudId, backUpImage, device);
                        }
                    }
                    com.pg.domain.BackupFile backupFile = this.convertBkpImageToBackupFile(backUpImage);
                    if (backUpImage != null && !CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
                        backupFile.setMd5(backUpImage.getMd5Checksum());
                        list.add(backupFile);
                    } else {
                        backupIds.add(backUpImage.getId());
                        hashMap.put(backUpImage.getId().toString(), backUpImage.getMd5Checksum());
                    }
                    if (CollectionUtils.isEmpty((Collection)(oldFiles = this.backupFileDao.getBackupFilesForBackupImageId(cloudName, userName, deviceUUID, cloudId, fileVersionMapTemp, backupIds, hashMap)))) continue;
                    list.addAll(oldFiles);
                }
                logger.debug(BATCH_ID_LOG + restoreId + " end-all-versions backup file........");
            } else {
                logger.debug(BATCH_ID_LOG + restoreId + " Only latest versions ........");
                List bkpImagesdb = this.backupFileDao.getBackupFilesForGivenPathfromBackupImage(isImmediateFolderLevel, backupFileQueryElement, device, true, serverModifiedTime, getDeletedFilesLatestVersion);
                ArrayList<BackUpImage> bkpImages = new ArrayList<BackUpImage>();
                logger.debug("....restoreId...." + restoreId);
                if (!StringUtils.isEmpty((String)backupFileQueryElement.getDevicePath())) {
                    this.backupFileDao.deleteRestoredFilesBySkipValue(cloudId, backupFileQueryElement.getUserName(), backupFileQueryElement.getDevicePath(), (long)backupFileQueryElement.getSkipValue(), restoreId);
                }
                for (BackUpImage backUpImage : bkpImagesdb) {
                    RestoredFiles restoredFiles = this.backupFileDao.getRestoredFiles(cloudId, backUpImage.getUserName(), backUpImage.getDevicePath(), backUpImage.getFileName(), restoreId);
                    if (restoredFiles == null) {
                        logger.debug("...$$$$...Adding restored files is empty for backUpImage.getUserName().." + backUpImage.getUserName() + "..backUpImage.getDevicePath().." + backUpImage.getDevicePath() + "...backUpImage.getFileName().." + backUpImage.getFileName());
                        RestoredFiles restoredFiles2 = new RestoredFiles();
                        restoredFiles2.setDevicePath(backUpImage.getDevicePath());
                        restoredFiles2.setFileName(backUpImage.getFileName());
                        restoredFiles2.setUserName(backUpImage.getUserName());
                        restoredFiles2.setSkipValue((long)backupFileQueryElement.getSkipValue());
                        this.backupFileDao.saveRestoredFiles(cloudId, restoredFiles2, restoreId);
                        bkpImages.add(backUpImage);
                        continue;
                    }
                    logger.debug("...$$$$...already restored files is exists for backUpImage.getUserName().." + backUpImage.getUserName() + "..backUpImage.getDevicePath().." + backUpImage.getDevicePath() + "...backUpImage.getFileName().." + backUpImage.getFileName());
                }
                if (CollectionUtils.isEmpty((Collection)bkpImagesdb)) {
                    logger.debug(BATCH_ID_LOG + restoreId + " bkpimaged is null>>>>>>>>>>>so return");
                    response.setStatus(500);
                    return -1L;
                }
                if (CollectionUtils.isEmpty(bkpImages)) {
                    logger.debug("backup images are empty increase the skip value...");
                    return downloadedCountTemp;
                }
                ArrayList<ObjectId> backupIds = new ArrayList<ObjectId>();
                HashMap<String, String> md5Map = new HashMap<String, String>();
                for (BackUpImage backUpImage : bkpImages) {
                    if (backUpImage != null && StringUtils.isEmpty((String)backUpImage.getGatewayName()) && StringUtils.isEmpty((String)backUpImage.getStoragePlace()) && CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
                        pgBkpNoGatewayList.add(backUpImage);
                    }
                    if (StringUtils.isEmpty((String)backUpImage.getStoragePlace()) && !StringUtils.isEmpty((String)backUpImage.getGatewayName())) {
                        if (backUpImage == null) continue;
                        pgBkpList.add(backUpImage);
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
                        BackUpImage parentFile = this.backupFileDao.getParentBackupImageForMd5(cloudId, backUpImage.getMd5Checksum(), device);
                        logger.debug("Chunk is empty so get chunk from MD5:" + backUpImage.getChunkFiles());
                        if (parentFile != null && !CollectionUtils.isEmpty((Collection)parentFile.getChunkFiles())) {
                            backUpImage.setChunkFiles(parentFile.getChunkFiles());
                            this.backUpImageDao.saveImageToBackUp(cloudId, backUpImage, device);
                        }
                    }
                    logger.debug(" convert to chunk ....");
                    com.pg.domain.BackupFile backupFile = this.convertBkpImageToBackupFile(backUpImage);
                    if (backUpImage != null && !CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
                        backupFile.setMd5(backUpImage.getMd5Checksum());
                        list.add(backupFile);
                        continue;
                    }
                    backupIds.add(backUpImage.getId());
                    md5Map.put(backUpImage.getId().toString(), backUpImage.getMd5Checksum());
                }
                List list3 = this.backupFileDao.getBackupFilesForBackupImageId(cloudName, userName, deviceUUID, cloudId, fileVersionMapTemp, backupIds, md5Map);
                ArrayList<ObjectId> leftoutBackupIds = new ArrayList<ObjectId>();
                if (!CollectionUtils.isEmpty((Collection)list3)) {
                    list.addAll(list3);
                }
                for (com.pg.domain.BackupFile backupFile : list3) {
                    leftoutBackupIds.add(backupFile.getBackupId());
                }
                backupIds.removeAll(leftoutBackupIds);
                for (BackUpImage backUpImage : bkpImages) {
                    if (!backupIds.contains(backUpImage.getId())) continue;
                    this.createBackupFile(list, backUpImage);
                }
            }
        }
        if (CollectionUtils.isEmpty(list) && CollectionUtils.isEmpty(pgBkpList) && CollectionUtils.isEmpty(pgBkpNoGatewayList)) {
            logger.debug(BATCH_ID_LOG + restoreId + " No files for download .......... ");
            return -1L;
        }
        List licenseDetails = cloud.getCloudCustomisableDetails();
        boolean isODBEnabled = false;
        licenseDetails.removeAll(Collections.singleton(null));
        for (CloudCustomisableDetails cloudCustomisableDetails : licenseDetails) {
            if (!"ODB Enabled".equals(cloudCustomisableDetails.getName())) continue;
            isODBEnabled = true;
            break;
        }
        PciAuthorizationTokenElement element = null;
        if (isODBEnabled) {
            logger.debug("  USER NAME .................... " + userName);
            User user = this.utilService.getUserInfoByName(cloudId, userName);
            element = this.utilService.getPCITokenElement(cloudId, user.getUserId());
            if (user != null && element != null) {
                element.setUserName(user.getUserName());
            }
        }
        fileVersionMapTemp = new HashMap<String, Long>();
        if (!CollectionUtils.isEmpty(list)) {
            Collections.sort(list, new Comparator<com.pg.domain.BackupFile>(){

                @Override
                public int compare(com.pg.domain.BackupFile c1, com.pg.domain.BackupFile c2) {
                    long t1 = c2.getUploadedTimestamp();
                    long t2 = c1.getUploadedTimestamp();
                    if (t2 > t1) {
                        return 1;
                    }
                    if (t1 > t2) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        for (com.pg.domain.BackupFile backupFile : list) {
            if (backupFile != null && backupFile.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), backupFile.getFileName(), rwlist))) {
                logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            String mapKey = backupFile.getFilePath() + backupFile.getFileName();
            if (fileVersionMapTemp.containsKey(mapKey)) {
                String newFileName;
                Long versionVal = fileVersionMapTemp.get(mapKey);
                fileVersionMapTemp.remove(mapKey);
                long newVersion = versionVal + 1L;
                fileVersionMapTemp.put(mapKey, newVersion);
                if (StringUtils.isNotEmpty((String)FilenameUtils.getExtension((String)backupFile.getFileName()))) {
                    lastDot = backupFile.getFileName().lastIndexOf(46);
                    newFileName = backupFile.getFileName().substring(0, lastDot) + VERSION + newVersion + ")" + backupFile.getFileName().substring(lastDot);
                } else {
                    newFileName = backupFile.getFileName() + VERSION + newVersion + ")";
                }
                backupFile.setFileName(newFileName);
                continue;
            }
            fileVersionMapTemp.put(mapKey, 1L);
        }
        if (!CollectionUtils.isEmpty(pgBkpList)) {
            Collections.sort(pgBkpList, new Comparator<BackUpImage>(){

                @Override
                public int compare(BackUpImage c1, BackUpImage c2) {
                    long t1 = c2.getLastClientModifiedTime();
                    long t2 = c1.getLastClientModifiedTime();
                    if (t2 > t1) {
                        return 1;
                    }
                    if (t1 > t2) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        for (BackUpImage backUpImage : pgBkpList) {
            String mapKey;
            if (backUpImage != null && backUpImage.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), backUpImage.getFileName(), rwlist))) {
                logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            PrivacyGatewayMapping privacyGatewayMapping = this.utilService.getPrivacyGatewayMapping(cloudId, backUpImage.getGatewayName());
            if (privacyGatewayMapping != null) {
                logger.debug("........." + privacyGatewayMapping.getGatewayName() + "...........new........" + privacyGatewayMapping.getNewGatewayName());
                backUpImage.setGatewayName(privacyGatewayMapping.getNewGatewayName());
            }
            if (fileVersionMapTemp.containsKey(mapKey = backUpImage.getDevicePath() + backUpImage.getFileName())) {
                Long versionVal = fileVersionMapTemp.get(mapKey);
                fileVersionMapTemp.remove(mapKey);
                long newVersion = versionVal + 1L;
                fileVersionMapTemp.put(mapKey, newVersion);
                lastDot = backUpImage.getFileName().lastIndexOf(46);
                String newFileName = backUpImage.getFileName().substring(0, lastDot) + VERSION + newVersion + ")" + backUpImage.getFileName().substring(lastDot);
                backUpImage.setFileName(newFileName);
                continue;
            }
            fileVersionMapTemp.put(mapKey, 1L);
        }
        for (com.pg.domain.BackupFile backupFile : list) {
            if (backupFile != null && backupFile.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), backupFile.getFileName(), rwlist))) {
                logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            String backupId = backupFile.getId();
            fileName = backupFile.getFileName();
            String folderPath = backupFile.getFilePath();
            List chunkFileList2 = backupFile.getChunkFiles();
            Collections.sort(chunkFileList2, new Comparator<com.pg.domain.ChunkFile>(){

                @Override
                public int compare(com.pg.domain.ChunkFile d1, com.pg.domain.ChunkFile d2) {
                    return d1.getFileName().compareTo(d2.getFileName());
                }
            });
            BufferedInputStream inputStream2 = null;
            ArrayList<String> nameList = new ArrayList<String>();
            logger.debug(backupFile.getFileName() + WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT + downloadedCountTemp);
            boolean isChunksDownloaded = false;
            GraphServiceClient<Request> graphClient2 = null;
            OkHttpClient okHttpClient = null;
            if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                graphClient2 = OneDriveUtil.getGraphClient();
                okHttpClient = Graph.getInstance().getOkHttpClient();
            }
            for (com.pg.domain.ChunkFile chunkFile : chunkFileList2) {
                File copyFile;
                ChunkDetail chunkDetail;
                String saltKey;
                block205: {
                    saltKey = null;
                    chunkDetail = null;
                    isChunksDownloaded = false;
                    copyFile = null;
                    try {
                        String md5 = chunkFile.getMd5();
                        logger.debug(BATCH_ID_LOG + restoreId + " MD5 latest for chunk Fiile $$$$$>>>>>>>>>>>>>>>" + md5);
                        if (StringUtils.isEmpty((String)md5)) {
                            logger.debug("Inside Getting md5 from file name");
                            md5 = DownloadServiceImpl.getMd5FromFileName(chunkFile.getFileName());
                            logger.debug(BATCH_ID_LOG + restoreId + " md5 after filter from filename>>>>" + md5);
                            chunkFile.setMd5(md5);
                        }
                        String dedupVal = this.getDedupValue(userName);
                        List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                        if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                            logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                            chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                        }
                        if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                            for (ChunkDetail detailFromDB : chunkDetailList) {
                                if (detailFromDB.getRefCount() <= 0) continue;
                                chunkDetail = detailFromDB;
                            }
                        }
                        if (chunkDetail == null) {
                            logger.debug(CHUNK_DETAILS_NULL);
                            chunkDetail = new ChunkDetail();
                            if (isGDEnabled && !StringUtils.isEmpty((String)chunkFile.getFileId())) {
                                chunkDetail.setCloudChunkName(chunkFile.getFileId());
                            } else {
                                chunkDetail.setCloudChunkName(chunkFile.getFileName());
                            }
                            chunkDetail.setCloudStoragePath(chunkFile.getCloudStoragePath());
                            chunkDetail.setContainerName(userName.toLowerCase());
                            chunkDetail.setMd5(chunkFile.getMd5());
                            chunkDetail.setUserName(userName.toLowerCase());
                        } else {
                            chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                            if (StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !StringUtils.isEmpty((String)chunkDetail.getProductType()) && !chunkDetail.getProductType().equals("SYNC")) {
                                chunkDetail.setContainerName(userName.toLowerCase());
                            }
                        }
                        logger.debug(BATCH_ID_LOG + restoreId + chunkFile.getFileName() + "...md5...." + chunkFile.getMd5() + "....CLOUD CHUNK NAME>>>>>>>>>" + chunkDetail.getCloudChunkName());
                        StringBuilder fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName());
                        int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                        String chunkProductType = BACKUP;
                        if (chunkDetail != null && !StringUtils.isEmpty((String)chunkDetail.getProductType())) {
                            chunkProductType = chunkDetail.getProductType();
                        }
                        saltKey = this.getEncryptOrDecryptKey(cloudId, chunkDetail.getChunkCreatedTime(), chunkProductType);
                        if (occurance == 0 || occurance == 1 && chunkFileList2.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                            fileNameToDownload.append(".").append(backupId);
                        } else if (occurance == 1 && chunkFileList2.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                            fileNameToDownload.append("." + backupId);
                        }
                        String fileToDownload = fileNameToDownload.toString();
                        if (isGDEnabled) {
                            fileToDownload = chunkDetail.getCloudChunkName();
                        }
                        boolean retry = false;
                        int retryCount = 0;
                        do {
                            retry = false;
                            inputStream2 = this.downloadFileFromCloud(cloud, restorePath, fileToDownload, userName, cloudName, deviceUUID, element, chunkFile, backupFile, chunkDetail.getContainerName(), chunkDetail.getUserName().toLowerCase(), chunkDetail, fileStatusElement, graphClient2);
                            if (inputStream2 == null) continue;
                            File decryptedDir = this.createDecryptedDirs(restorePath);
                            try {
                                copyFile = this.copyInputStreamToAFile(chunkFile.getFileName() + "-temp", inputStream2, decryptedDir);
                            }
                            catch (ParacloudBackupException e) {
                                logger.error("exception coopying the stream so retry download again..", (Throwable)e);
                                retry = true;
                                ++retryCount;
                                inputStream2 = null;
                            }
                        } while (retry && retryCount <= 2);
                        if (inputStream2 == null && occurance == 1 && chunkFileList2.size() > 1) {
                            logger.debug(BATCH_ID_LOG + restoreId + " Before writeDatatoStream bruteForceRestoreFromCloud... ");
                            File decryptedFile = this.bruteForceRestoreFromCloud(cloud, cloudName, userName, backupFile, nameList, saltKey, fileName, folderPath, element, restorePath, device, fileStatusElement);
                            if (decryptedFile == null) {
                                this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 507, restoreId);
                                this.sendEmptyContents(response);
                                break;
                            }
                            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                            downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                            logger.debug(BATCH_ID_LOG + restoreId + " after writeDatatoStream bruteForceRestoreFromCloud... ");
                            continue;
                        }
                    }
                    catch (ParacloudBackupException e) {
                        logger.debug("Exception :" + (Object)((Object)e));
                        logger.error(BATCH_ID_LOG + restoreId + " THE error code is>>>>>$$>>>>>" + e.getResponseCode());
                        if (e.getResponseCode() != 404) break block205;
                        nameList.clear();
                        try {
                            File decryptedFile = this.searchReplicaAndRestore(cloud, cloudName, userName, backupFile, nameList, saltKey, fileName, folderPath, element, restorePath, device, fileStatusElement);
                            logger.debug(" Before writeDatatoStream searchReplicaAndRestore... ");
                            if (decryptedFile == null) {
                                this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                                this.sendEmptyContents(response);
                                break;
                            }
                            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                            downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                            logger.debug(BATCH_ID_LOG + restoreId + " After writeDatatoStream searchReplicaAndRestore... ");
                            continue;
                        }
                        catch (Exception ex) {
                            logger.trace("" + ex);
                            logger.error(BATCH_ID_LOG + restoreId + " Error in searchReplicaAndRestore - File not found ...." + ex.getMessage());
                            try {
                                if (inputStream2 != null) {
                                    inputStream2.close();
                                }
                            }
                            catch (IOException e1) {
                                logger.trace("" + e1);
                                logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
                            }
                            inputStream2 = null;
                        }
                    }
                    catch (Exception e) {
                        try {
                            if (inputStream2 != null) {
                                inputStream2.close();
                            }
                        }
                        catch (IOException e1) {
                            logger.trace("" + e1);
                            logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
                        }
                        logger.trace("" + e);
                        logger.error(BATCH_ID_LOG + restoreId + " Error trying to write data .....22222%%%%%%%%% " + FILE_PATH_STR + backupFile.getFilePath() + FILE_NAME_STR + backupFile.getFileName() + e.getMessage());
                        logger.debug(BATCH_ID_LOG + restoreId + ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH, (Throwable)e);
                        throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                    }
                }
                if (inputStream2 == null) {
                    this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                    try {
                        logger.debug(BATCH_ID_LOG + restoreId + " DEcrypt file is null so send empty contents .....");
                        this.sendEmptyContents(response);
                    }
                    catch (IOException e) {
                        logger.debug("IOException   " + e);
                        logger.error("IOException   " + e.getMessage());
                    }
                    break;
                }
                String decryptUserName = userName;
                String productType = BACKUP;
                if (chunkDetail != null && "ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                    productType = "sync";
                    decryptUserName = SYNC_DECRYPT_KEY;
                }
                if (chunkDetail != null && StringUtils.isNotEmpty((String)chunkDetail.getProductType()) && chunkDetail.getProductType().equals("SYNC")) {
                    productType = "sync";
                    decryptUserName = SYNC_DECRYPT_KEY;
                }
                logger.debug("...productType..." + productType);
                saltKey = this.getEncryptOrDecryptKey(cloudId, chunkDetail.getChunkCreatedTime(), productType);
                if (saltKey == null) {
                    throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                }
                if (!StringUtils.isEmpty((String)chunkDetail.getUserName())) {
                    decryptUserName = chunkDetail.getUserName();
                }
                if (chunkDetail != null && !StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !chunkDetail.getContainerName().equalsIgnoreCase(userName)) {
                    decryptUserName = !StringUtils.isEmpty((String)chunkDetail.getUserName()) ? chunkDetail.getUserName() : chunkDetail.getContainerName();
                }
                if (chunkDetail != null && "ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                    productType = "sync";
                    decryptUserName = SYNC_DECRYPT_KEY;
                }
                logger.debug(BATCH_ID_LOG + restoreId + " close shield input stream decrypt username>>>>>>" + decryptUserName + " ..product type:" + productType);
                try {
                    inputStream2 = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (FileNotFoundException e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                }
                File decryptedFile = this.getDecryptedFile(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), inputStream2, decryptUserName, restorePath, chunkFile, cloudId, chunkDetail);
                if (decryptedFile == null) {
                    if (StringUtils.isNotEmpty((String)fileStatusElement.getFileOwner())) {
                        logger.debug("decryptedFile is null and file owner is not empty.." + fileStatusElement.getFileOwner());
                        BufferedInputStream in = null;
                        try {
                            in = new BufferedInputStream(new FileInputStream(copyFile));
                        }
                        catch (FileNotFoundException e) {
                            logger.trace("" + e);
                            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                        }
                        decryptedFile = this.getDecryptedFile(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), in, fileStatusElement.getFileOwner(), restorePath, chunkFile, cloudId, chunkDetail);
                    }
                    if (copyFile.exists()) {
                        copyFile.delete();
                    }
                    if (decryptedFile == null) break;
                }
                if (copyFile.exists()) {
                    copyFile.delete();
                }
                String isChunk = "true";
                this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, isChunk, skipValue, isEncodedEnabled, 203, restoreId);
                downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                nameList.add(chunkFile.getFileName());
                isChunksDownloaded = true;
            }
            if (isChunksDownloaded) {
                ++downloadedCountTemp;
            }
            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, new com.pg.domain.ChunkFile(), "false", skipValue, isEncodedEnabled, 203, restoreId);
        }
        this.gatewayLists = this.utilService.getAllPrivacyGateways(cloudId);
        for (BackUpImage backUpImage : pgBkpList) {
            if (backUpImage != null && backUpImage.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), backUpImage.getFileName(), rwlist))) {
                logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            String gatewayToUse = backUpImage.getGatewayName();
            String backupId = backUpImage.getId().toString();
            for (PrivacyGateway gateway : this.gatewayLists) {
                if (!gateway.getGatewayName().equalsIgnoreCase(backUpImage.getGatewayName())) continue;
                if (!StringUtils.isNotEmpty((String)gateway.getAlias())) break;
                gatewayToUse = gateway.getAlias();
                break;
            }
            logger.debug(BATCH_ID_LOG + restoreId + backupId + " NEW LOGIC pgBkpList blukrypt gateway .........." + gatewayToUse + "....alias if any");
            HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
            reqFactory.setConnectTimeout(15000);
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
            ArrayList<Object> messageConverters = new ArrayList<Object>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            messageConverters.add(new ByteArrayHttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            HttpHeaders headers = new HttpHeaders();
            headers.add(BACKUP_ID, backupId);
            headers.add(CLOUD_NAME, cloudName);
            HttpEntity entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
            FileInfo fileInfo = null;
            String url = "";
            try {
                url = PREFIX_HTTPS + gatewayToUse + "/BluKryptBuilder/get/fileInfo/";
                ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, FileInfo.class, new Object[0]);
                fileInfo = (FileInfo)result.getBody();
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(BATCH_ID_LOG + restoreId + " error trying to connect to pgs ..." + e.getMessage());
            }
            if (fileInfo == null) {
                logger.debug(" File from mongo new Table........ ");
                fileInfo = this.utilService.getPgFileFromMongo(cloudId, cloudName, backupId, true);
            }
            logger.debug(url + FILE_INFO_RECEIVED + fileInfo);
            if (fileInfo == null) continue;
            if (fileInfo.isClientDedupEnabled()) {
                clientDedupEnabledList.add(fileInfo);
                continue;
            }
            logger.debug(BATCH_ID_LOG + restoreId + backUpImage.getFileName() + " pgBkp file meta info recieved .... " + fileInfo.getId());
            fileInfo.setFileName(backUpImage.getFileName());
            chunkFileList = fileInfo.getChunkFiles();
            Collections.sort(chunkFileList);
            if (backUpImage.getAccessTime() != 0L) {
                fileInfo.setAccessTime(backUpImage.getAccessTime());
            }
            fileInfo.setUploadedTimestamp(Long.valueOf(backUpImage.getLastClientModifiedTime()));
            logger.debug(BATCH_ID_LOG + restoreId + WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT + downloadedCountTemp + "chunk list size..." + chunkFileList.size());
            String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
            batchId = fileInfo.getBatchId();
            if (!StringUtils.isEmpty((String)batchId)) {
                deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + (String)batchId;
            }
            chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
            boolean isChunksDownloaded = false;
            if (!StringUtils.isEmpty((String)fileInfo.getSubject()) || !StringUtils.isEmpty((String)fileInfo.getBodyContent())) {
                this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, fileInfo.getMd5(), skipValue, isEncodedEnabled, restoreId);
                this.restoreMailFromPG(cloudName, response, fileInfo, restoreId);
                isChunksDownloaded = true;
            } else {
                graphClient = null;
                Object okHttpClient = null;
                if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                    graphClient = Graph.getInstance().getGraphClient();
                }
                for (String chunkName : chunkFileList) {
                    int endIndex;
                    isChunksDownloaded = false;
                    String fileNameValue = chunkName;
                    String md5 = DownloadServiceImpl.getMd5FromFileName(chunkName);
                    logger.debug(chunkFilePath + FILE_FROM_PG + chunkName);
                    if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                        chunkName = chunkName.substring(0, endIndex);
                    }
                    String filePath = chunkFilePath + "/" + chunkName;
                    restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
                    messageConverters = new ArrayList();
                    messageConverters.add(new ByteArrayHttpMessageConverter());
                    messageConverters.add(new StringHttpMessageConverter());
                    messageConverters.add(new ResourceHttpMessageConverter());
                    messageConverters.add(new SourceHttpMessageConverter());
                    messageConverters.add(new AllEncompassingFormHttpMessageConverter());
                    restTemplate.setMessageConverters(messageConverters);
                    headers = new HttpHeaders();
                    headers.add(FILEPATH, filePath);
                    headers.setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM));
                    entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
                    url = PREFIX_HTTPS + gatewayToUse + BLUKRYPT_BUILDER_DOWNLOAD_FROM_PG;
                    logger.debug(BATCH_ID_LOG + restoreId + " downloadpgBkpList pg url .............." + url);
                    try {
                        ResponseEntity resultObj = restTemplate.exchange(url, HttpMethod.GET, entity, byte[].class, new Object[]{"1"});
                        bytes = (byte[])resultObj.getBody();
                        if (resultObj.getStatusCode().equals((Object)HttpStatus.NO_CONTENT)) {
                            logger.error(BATCH_ID_LOG + restoreId + " downloadpgBkpList file does not exist in pg..... ");
                            String dedupVal = this.getDedupValue(userName);
                            ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, false);
                            if (chunkDetail == null) {
                                logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                                chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, true);
                            }
                            if (chunkDetail == null) continue;
                            chunkName = chunkDetail.getCloudChunkName();
                            com.pg.domain.ChunkFile chunkFile = this.getChunkFileFromDetail(fileNameValue, chunkDetail);
                            com.pg.domain.BackupFile backupFile = this.getBackupFile(fileInfo);
                            inputStream = this.downloadFileFromCloud(cloud, restorePath, chunkName, chunkDetail.getContainerName().toLowerCase(), cloudName, deviceUUID, element, chunkFile, backupFile, chunkDetail.getContainerName().toLowerCase(), chunkDetail.getUserName().toLowerCase(), chunkDetail, fileStatusElement, graphClient);
                            String saltKey = this.getEncryptOrDecryptKey(cloudId, chunkDetail.getChunkCreatedTime(), BACKUP);
                            if (saltKey == null) {
                                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                            }
                            User user = this.utilService.getUserInfoByName(cloudId, chunkDetail.getContainerName());
                            File decryptedFile = this.getDecryptedFile(cloudName, saltKey, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, user.getUserName(), restorePath, chunkFile, cloudId, chunkDetail);
                            if (decryptedFile == null) {
                                this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                                this.sendEmptyContents(response);
                                break;
                            }
                            this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                            downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                            isChunksDownloaded = true;
                            continue;
                        }
                        input = new ByteArrayInputStream(bytes);
                        this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                        this.writeDataToStream(response, path, fileInfo, chunkName, filePath, input, restoreId);
                        isChunksDownloaded = true;
                    }
                    catch (Exception e) {
                        logger.trace("" + e);
                        logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e.getMessage());
                        try {
                            this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                            this.sendEmptyContents(response);
                        }
                        catch (IOException e1) {
                            logger.trace("" + e);
                            logger.error("##batch id >>>> new " + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e.getMessage());
                        }
                        break;
                    }
                }
            }
            if (isChunksDownloaded) {
                ++downloadedCountTemp;
            }
            try {
                response.getOutputStream().println();
                response.getOutputStream().println(PARABLU_OF);
                String partHeader = CONTENT_DISPOSITION_FORM_DATA;
                response.getOutputStream().println(partHeader);
                String fileNameHeader = this.getEncodedFileName(isEncodedEnabled, fileInfo.getFilePath());
                byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
                response.getOutputStream().write(fileNameBytes);
                response.getOutputStream().println();
                String filePathHeader = this.getEncodedFilePath(isEncodedEnabled, fileInfo.getFilePath());
                byte[] filePathBytes = filePathHeader.getBytes(UTF8);
                response.getOutputStream().write(filePathBytes);
                response.getOutputStream().println();
                String clientModifiedTimeHeader = CLIENT_MODIFIED_TIME + fileInfo.getUploadedTimestamp();
                response.getOutputStream().println(clientModifiedTimeHeader);
                if (fileInfo.getAccessTime() != 0L) {
                    String clientAccessTimeHeader = CLIENT_ACCESS_TIME + fileInfo.getAccessTime();
                    response.getOutputStream().println(clientAccessTimeHeader);
                }
                String chunkMd5 = MD5_CHECKSUM;
                response.getOutputStream().println(chunkMd5);
                response.getOutputStream().println("isAChunkFile:false");
                response.getOutputStream().println(COUNT + downloadedCountTemp);
                response.getOutputStream().println();
            }
            catch (Exception e) {
                logger.error(BATCH_ID_LOG + restoreId + " Download Exception NEW......");
                try {
                    String simpleName = e.getCause().getClass().getSimpleName();
                    logger.trace("" + e);
                    logger.error(BATCH_ID_LOG + restoreId + ERROR_TRYING_TO_WRITE_DATA + simpleName + FILE_PATH_STR + fileInfo.getFilePath() + FILE_NAME_STR + fileInfo.getFileName() + e.getMessage());
                    String exceptionMsg = e.getMessage();
                    if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                        this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                        if (!StringUtils.isEmpty((String)restoreId)) {
                            String pathToDelete = path + restoreId;
                            logger.debug("...deletebase folder..." + pathToDelete);
                            File file2 = new File(pathToDelete);
                            if (file2.exists()) {
                                FileUtils.deleteDirectory((File)file2);
                            }
                        }
                        logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                        throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                    }
                    response.getOutputStream().close();
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
                }
            }
        }
        for (FileInfo fileInfo : clientDedupEnabledList) {
            if (fileInfo != null && fileInfo.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), fileInfo.getFileName(), rwlist))) {
                logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            String backupId = fileInfo.getId();
            fileName = fileInfo.getFileName();
            String folderPath = fileInfo.getFilePath();
            List chunkFileList3 = fileInfo.getChunkFiles();
            Collections.sort(chunkFileList3, new Comparator<String>(){

                @Override
                public int compare(String d1, String d2) {
                    return d1.compareTo(d2);
                }
            });
            BufferedInputStream inputStream2 = null;
            ArrayList<String> nameList = new ArrayList<String>();
            logger.debug(fileInfo.getFileName() + WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT + downloadedCountTemp);
            com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
            List bkpImageList = pgBkpList.parallelStream().filter(bkpImage1 -> bkpImage1.getId().toString().equals(backupId)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(bkpImageList)) {
                BackUpImage bkpImage = (BackUpImage)bkpImageList.get(0);
                backupFile.setAccessTime(Long.valueOf(bkpImage.getAccessTime()));
                backupFile.setBackupId(bkpImage.getId());
                backupFile.setCompressed(fileInfo.isCompressed());
                backupFile.setDeviceUUID(bkpImage.getDeviceUUID());
                backupFile.setFileName(bkpImage.getFileName());
                fileInfo.setFileName(bkpImage.getFileName());
                backupFile.setFilePath(bkpImage.getDevicePath());
                backupFile.setMd5(bkpImage.getMd5Checksum());
                backupFile.setId(bkpImage.getId().toString());
                backupFile.setSize(Long.valueOf(bkpImage.getSize()));
                backupFile.setSizeInBytes(Long.valueOf(bkpImage.getSizeInBytes()));
                backupFile.setUserName(bkpImage.getUserName());
                backupFile.setGatewayName(bkpImage.getGatewayName());
                PrivacyGatewayMapping privacyGatewayMapping = this.utilService.getPrivacyGatewayMapping(cloudId, bkpImage.getGatewayName());
                if (privacyGatewayMapping != null) {
                    logger.debug("........." + privacyGatewayMapping.getGatewayName() + "...........new........" + privacyGatewayMapping.getNewGatewayName());
                    backupFile.setGatewayName(privacyGatewayMapping.getNewGatewayName());
                }
                backupFile.setUploadedTimestamp(Long.valueOf(bkpImage.getLastClientModifiedTime()));
            }
            Object graphClient3 = null;
            Object okHttpClient = null;
            if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                graphClient3 = Graph.getInstance().getGraphClient();
            }
            boolean isChunksDownloaded = false;
            for (String chunkFileStr : chunkFileList3) {
                String saltKey = null;
                ChunkDetail chunkDetail = null;
                isChunksDownloaded = false;
                com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                try {
                    logger.debug(BATCH_ID_LOG + restoreId);
                    logger.debug("Inside Getting md5 from file name");
                    String md5 = DownloadServiceImpl.getMd5FromFileName(chunkFileStr);
                    logger.debug(BATCH_ID_LOG + restoreId + " md5 after filter from filename>>>>" + md5);
                    String dedupVal = this.getDedupValue(userName);
                    List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, md5, dedupVal, userName, true, false);
                    if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, md5, dedupVal, userName, true, true);
                    }
                    if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                        for (ChunkDetail detailFromDB : chunkDetailList) {
                            if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                            chunkDetail = detailFromDB;
                        }
                    }
                    if (chunkDetail == null) {
                        logger.debug(CHUNK_DETAILS_NULL);
                        break;
                    }
                    if (!chunkDetail.isPreEntry()) {
                        if (StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !StringUtils.isEmpty((String)chunkDetail.getProductType()) && !chunkDetail.getProductType().equals("SYNC")) {
                            chunkDetail.setContainerName(userName.toLowerCase());
                        }
                        StringBuilder fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName());
                        int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                        String chunkProductType = BACKUP;
                        if (chunkDetail != null && !StringUtils.isEmpty((String)chunkDetail.getProductType())) {
                            chunkProductType = chunkDetail.getProductType();
                        }
                        saltKey = this.getEncryptOrDecryptKey(cloudId, chunkDetail.getChunkCreatedTime(), chunkProductType);
                        if (occurance == 0 || occurance == 1 && chunkFileList3.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                            fileNameToDownload.append(".").append(backupId);
                        } else if (occurance == 1 && chunkFileList3.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                            fileNameToDownload.append("." + backupId);
                        }
                        String fileToDownload = fileNameToDownload.toString();
                        if (isGDEnabled) {
                            fileToDownload = chunkDetail.getCloudChunkName();
                        }
                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                        chunkFile.setEncodedName(chunkDetail.getEncodedName());
                        chunkFile.setFileId(chunkDetail.getId().toString());
                        chunkFile.setfSPath(chunkDetail.getFsPath());
                        chunkFile.setUploadedTimeStamp(chunkDetail.getChunkCreatedTime());
                        chunkFile.setFileName(chunkDetail.getCloudChunkName());
                        chunkFile.setMd5(chunkDetail.getMd5());
                        inputStream2 = this.downloadFileFromCloud(cloud, restorePath, fileToDownload, userName, cloudName, deviceUUID, element, chunkFile, backupFile, chunkDetail.getContainerName(), chunkDetail.getUserName().toLowerCase(), chunkDetail, fileStatusElement, (GraphServiceClient<Request>)graphClient3);
                        if (inputStream2 == null && occurance == 1 && chunkFileList3.size() > 1) {
                            logger.debug(BATCH_ID_LOG + restoreId + " Before writeDatatoStream bruteForceRestoreFromCloud... ");
                            File decryptedFile = this.bruteForceRestoreFromCloud(cloud, cloudName, userName, backupFile, nameList, saltKey, fileName, folderPath, element, restorePath, device, fileStatusElement);
                            if (decryptedFile == null) {
                                this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                                this.sendEmptyContents(response);
                                break;
                            }
                            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                            downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                            logger.debug(BATCH_ID_LOG + restoreId + " after writeDatatoStream bruteForceRestoreFromCloud... ");
                            continue;
                        }
                        if (inputStream2 == null) {
                            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                            try {
                                logger.debug(BATCH_ID_LOG + restoreId + " DEcrypt file is null so send empty contents .....");
                                this.sendEmptyContents(response);
                            }
                            catch (IOException e) {
                                logger.debug("IOException   " + e);
                                logger.error("IOException   " + e.getMessage());
                            }
                            break;
                        }
                        String decryptUserName = userName;
                        String productType = BACKUP;
                        if (chunkDetail != null && "ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                            productType = "sync";
                            decryptUserName = SYNC_DECRYPT_KEY;
                        }
                        if (chunkDetail != null && StringUtils.isNotEmpty((String)chunkDetail.getProductType()) && chunkDetail.getProductType().equals("SYNC")) {
                            productType = "sync";
                            decryptUserName = SYNC_DECRYPT_KEY;
                        }
                        logger.debug("...productType..." + productType);
                        saltKey = this.getEncryptOrDecryptKey(cloudId, chunkDetail.getChunkCreatedTime(), productType);
                        if (saltKey == null) {
                            throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                        }
                        if (chunkDetail != null && !StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !chunkDetail.getContainerName().equalsIgnoreCase(userName)) {
                            decryptUserName = !StringUtils.isEmpty((String)chunkDetail.getUserName()) ? chunkDetail.getUserName() : chunkDetail.getContainerName();
                        }
                        if (chunkDetail != null && "ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                            productType = "sync";
                            decryptUserName = SYNC_DECRYPT_KEY;
                        }
                        logger.debug(BATCH_ID_LOG + restoreId + " close shield input stream decrypt username>>>>>>" + decryptUserName + " ..product type:" + productType);
                        File decryptedDir = this.createDecryptedDirs(restorePath);
                        File copyFile = this.copyInputStreamToAFile(chunkFile.getFileName() + "-temp", inputStream2, decryptedDir);
                        try {
                            inputStream2 = new BufferedInputStream(new FileInputStream(copyFile));
                        }
                        catch (FileNotFoundException e) {
                            logger.trace("" + e);
                            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                        }
                        File decryptedFile = this.getDecryptedFile(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), inputStream2, decryptUserName, restorePath, chunkFile, cloudId, chunkDetail);
                        if (decryptedFile == null) {
                            if (StringUtils.isNotEmpty((String)fileStatusElement.getFileOwner())) {
                                BufferedInputStream in = null;
                                try {
                                    in = new BufferedInputStream(new FileInputStream(copyFile));
                                }
                                catch (FileNotFoundException e) {
                                    logger.trace("" + e);
                                    logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                                }
                                decryptedFile = this.getDecryptedFile(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), in, fileStatusElement.getFileOwner(), restorePath, chunkFile, cloudId, chunkDetail);
                            }
                            if (copyFile.exists()) {
                                copyFile.delete();
                            }
                            if (decryptedFile == null) break;
                        }
                        if (copyFile.exists()) {
                            copyFile.delete();
                        }
                        String isChunk = "true";
                        this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, isChunk, skipValue, isEncodedEnabled, 203, restoreId);
                        downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                        nameList.add(chunkFile.getFileName());
                        isChunksDownloaded = true;
                        continue;
                    }
                    if (!chunkDetail.isPreEntry()) continue;
                    String gatewayToUse = backupFile.getGatewayName();
                    for (PrivacyGateway gateway : this.gatewayLists) {
                        if (!gateway.getGatewayName().equalsIgnoreCase(backupFile.getGatewayName())) continue;
                        if (!StringUtils.isNotEmpty((String)gateway.getAlias())) break;
                        gatewayToUse = gateway.getAlias();
                        break;
                    }
                    logger.debug(BATCH_ID_LOG + restoreId + chunkFile.getFileName() + " pgBkp file meta info recieved .... " + fileInfo.getId());
                    if (backupFile.getAccessTime() != 0L) {
                        fileInfo.setAccessTime(backupFile.getAccessTime().longValue());
                    }
                    fileInfo.setUploadedTimestamp(backupFile.getUploadedTimestamp());
                    logger.debug(BATCH_ID_LOG + restoreId + WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT + downloadedCountTemp + "chunk list size..." + chunkFileList3.size());
                    isChunksDownloaded = false;
                    String fileNameValue = chunkFileStr;
                    md5 = DownloadServiceImpl.getMd5FromFileName(chunkFileStr);
                    logger.debug(chunkDetail.getFsPath() + FILE_FROM_PG + chunkFileStr);
                    String filePath = chunkDetail.getFsPath();
                    HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
                    reqFactory.setConnectTimeout(15000);
                    RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
                    ArrayList<Object> messageConverters = new ArrayList<Object>();
                    messageConverters.add(new MappingJackson2HttpMessageConverter());
                    messageConverters.add(new ByteArrayHttpMessageConverter());
                    restTemplate.setMessageConverters(messageConverters);
                    HttpHeaders headers = new HttpHeaders();
                    restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
                    messageConverters = new ArrayList();
                    messageConverters.add(new ByteArrayHttpMessageConverter());
                    messageConverters.add(new StringHttpMessageConverter());
                    messageConverters.add(new ResourceHttpMessageConverter());
                    messageConverters.add(new SourceHttpMessageConverter());
                    messageConverters.add(new AllEncompassingFormHttpMessageConverter());
                    restTemplate.setMessageConverters(messageConverters);
                    headers = new HttpHeaders();
                    headers.add(FILEPATH, filePath);
                    headers.setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM));
                    HttpEntity entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
                    String url = PREFIX_HTTPS + gatewayToUse + BLUKRYPT_BUILDER_DOWNLOAD_FROM_PG;
                    logger.debug(BATCH_ID_LOG + restoreId + " downloadpgBkpList pg url .............." + url);
                    try {
                        ResponseEntity resultObj = restTemplate.exchange(url, HttpMethod.GET, entity, byte[].class, new Object[]{"1"});
                        byte[] bytes2 = (byte[])resultObj.getBody();
                        if (resultObj.getStatusCode().equals((Object)HttpStatus.NO_CONTENT)) {
                            logger.error(BATCH_ID_LOG + restoreId + " downloadpgBkpList file does not exist in pg..... ");
                            dedupVal = this.getDedupValue(userName);
                            chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, false);
                            if (chunkDetail == null) {
                                logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                                chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, true);
                            }
                            if (chunkDetail == null) continue;
                            String chunkName = chunkDetail.getCloudChunkName();
                            chunkFile = this.getChunkFileFromDetail(fileNameValue, chunkDetail);
                            com.pg.domain.BackupFile backupFileTemp = this.getBackupFile(fileInfo);
                            inputStream2 = this.downloadFileFromCloud(cloud, restorePath, chunkName, chunkDetail.getContainerName().toLowerCase(), cloudName, deviceUUID, element, chunkFile, backupFileTemp, chunkDetail.getContainerName().toLowerCase(), chunkDetail.getUserName().toLowerCase(), chunkDetail, fileStatusElement, (GraphServiceClient<Request>)graphClient3);
                            saltKey = this.getEncryptOrDecryptKey(cloudId, chunkDetail.getChunkCreatedTime(), BACKUP);
                            if (saltKey == null) {
                                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                            }
                            User user = this.utilService.getUserInfoByName(cloudId, chunkDetail.getContainerName());
                            File decryptedFile = this.getDecryptedFile(cloudName, saltKey, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream2, user.getUserName(), restorePath, chunkFile, cloudId, chunkDetail);
                            if (decryptedFile == null) {
                                this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                                this.sendEmptyContents(response);
                                break;
                            }
                            this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                            downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                            isChunksDownloaded = true;
                            continue;
                        }
                        ByteArrayInputStream input2 = new ByteArrayInputStream(bytes2);
                        this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                        this.writeDataToStream(response, path, fileInfo, chunkFileStr, filePath, input2, restoreId);
                        isChunksDownloaded = true;
                    }
                    catch (Exception e) {
                        logger.trace("" + e);
                        logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e.getMessage());
                        try {
                            this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                            this.sendEmptyContents(response);
                        }
                        catch (IOException e1) {
                            logger.trace("" + e);
                            logger.error("##batch id >>>> new " + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e.getMessage());
                        }
                        break;
                    }
                }
                catch (ParacloudBackupException e) {
                    logger.debug("Exception :" + (Object)((Object)e));
                    logger.error(BATCH_ID_LOG + restoreId + " THE error code is>>>>>$$>>>>>" + e.getResponseCode());
                    if (e.getResponseCode() != 404) continue;
                    nameList.clear();
                    try {
                        File decryptedFile = this.searchReplicaAndRestore(cloud, cloudName, userName, backupFile, nameList, saltKey, fileName, folderPath, element, restorePath, device, fileStatusElement);
                        logger.debug(" Before writeDatatoStream searchReplicaAndRestore... ");
                        if (decryptedFile == null) {
                            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                            this.sendEmptyContents(response);
                            break;
                        }
                        this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                        downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                        logger.debug(BATCH_ID_LOG + restoreId + " After writeDatatoStream searchReplicaAndRestore... ");
                    }
                    catch (Exception ex) {
                        logger.trace("" + ex);
                        logger.error(BATCH_ID_LOG + restoreId + " Error in searchReplicaAndRestore - File not found ...." + ex.getMessage());
                        try {
                            if (inputStream2 != null) {
                                inputStream2.close();
                            }
                        }
                        catch (IOException e1) {
                            logger.trace("" + e1);
                            logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
                        }
                        inputStream2 = null;
                    }
                }
                catch (Exception e) {
                    try {
                        if (inputStream2 != null) {
                            inputStream2.close();
                        }
                    }
                    catch (IOException e1) {
                        logger.trace("" + e1);
                        logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
                    }
                    logger.trace("" + e);
                    logger.error(BATCH_ID_LOG + restoreId + " Error trying to write data .....22222%%%%%%%%% " + FILE_PATH_STR + backupFile.getFilePath() + FILE_NAME_STR + backupFile.getFileName() + e.getMessage());
                    logger.debug(BATCH_ID_LOG + restoreId + ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e);
                    throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                }
            }
            if (isChunksDownloaded) {
                ++downloadedCountTemp;
            }
            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, new com.pg.domain.ChunkFile(), "false", skipValue, isEncodedEnabled, 203, restoreId);
        }
        for (BackUpImage backUpImage : pgBkpNoGatewayList) {
            if (backUpImage != null && backUpImage.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), backUpImage.getFileName(), rwlist))) {
                logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            String backupId = backUpImage.getId().toString();
            logger.error(backupId + "pgBkpNoGatewayList blukrypt gateway .........." + backUpImage.getGatewayName());
            HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
            reqFactory.setConnectTimeout(15000);
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
            ArrayList<Object> messageConverters = new ArrayList<Object>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            messageConverters.add(new ByteArrayHttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            HttpHeaders headers = new HttpHeaders();
            headers.add(BACKUP_ID, backupId);
            headers.add(CLOUD_NAME, cloudName);
            headers.add("userName", backUpImage.getUserName());
            HttpEntity entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
            FileInfo fileInfo = null;
            List pgList = this.backupFileDao.getAllGateways(cloudId);
            String gateWayName = "";
            for (PrivacyGateway privacyGateway : pgList) {
                if (StringUtils.isEmpty((String)privacyGateway.getGatewayName())) continue;
                try {
                    String url = PREFIX_HTTPS + privacyGateway.getGatewayName() + "/BluKryptBuilder/get/user/fileInfo/";
                    ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, FileInfo.class, new Object[0]);
                    fileInfo = (FileInfo)result.getBody();
                    gateWayName = privacyGateway.getGatewayName();
                    logger.error(privacyGateway.getGatewayName() + FILE_INFO_RECEIVED + fileInfo);
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error(" pgBkpNoGatewayList trying to get fileinfo from Pg...... " + e.getMessage());
                }
                if (fileInfo == null) continue;
                break;
            }
            if (fileInfo == null) continue;
            logger.error(BATCH_ID_LOG + restoreId + fileInfo.getFileName() + FILE_META_INFO_RECEIVED + fileInfo.getId());
            chunkFileList = fileInfo.getChunkFiles();
            Collections.sort(chunkFileList);
            fileInfo.setUploadedTimestamp(Long.valueOf(backUpImage.getLastClientModifiedTime()));
            logger.debug(BATCH_ID_LOG + restoreId + WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT + downloadedCountTemp);
            String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
            batchId = fileInfo.getBatchId();
            if (!StringUtils.isEmpty((String)batchId)) {
                deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + (String)batchId;
            }
            chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
            boolean isChunksDownloaded = false;
            graphClient = null;
            if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                graphClient = Graph.getInstance().getGraphClient();
            }
            for (String chunkName : chunkFileList) {
                int endIndex;
                isChunksDownloaded = false;
                String fileNameValue = chunkName;
                logger.debug(BATCH_ID_LOG + restoreId + chunkFilePath + FILE_FROM_PG + chunkName);
                String md5 = DownloadServiceImpl.getMd5FromFileName(chunkName);
                if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                    chunkName = chunkName.substring(0, endIndex);
                }
                String filePath = chunkFilePath + "/" + chunkName;
                restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
                messageConverters = new ArrayList();
                messageConverters.add(new MappingJackson2HttpMessageConverter());
                messageConverters.add(new ByteArrayHttpMessageConverter());
                messageConverters.add(new StringHttpMessageConverter());
                messageConverters.add(new ResourceHttpMessageConverter());
                restTemplate.setMessageConverters(messageConverters);
                headers = new HttpHeaders();
                headers.add(FILEPATH, filePath);
                entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
                String url = PREFIX_HTTPS + gateWayName + BLUKRYPT_BUILDER_DOWNLOAD_FROM_PG;
                logger.debug(" downloadpgBkpNoGatewayList pg url .............." + url);
                try {
                    ResponseEntity resultObj = restTemplate.exchange(url, HttpMethod.GET, entity, byte[].class, new Object[0]);
                    if (resultObj.getStatusCode().equals((Object)HttpStatus.NO_CONTENT)) {
                        logger.debug(BATCH_ID_LOG + restoreId + "file does not exist in pg. try parent file.... ");
                        String dedupVal = this.getDedupValue(userName);
                        ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, false);
                        if (chunkDetail == null) {
                            logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                            chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, true);
                        }
                        if (chunkDetail == null) continue;
                        com.pg.domain.ChunkFile chunkFile = this.getChunkFileFromDetail(fileNameValue, chunkDetail);
                        com.pg.domain.BackupFile backupFile = this.getBackupFile(fileInfo);
                        chunkName = chunkDetail.getCloudChunkName();
                        inputStream = this.downloadFileFromCloud(cloud, restorePath, chunkName, chunkDetail.getContainerName().toLowerCase(), cloudName, deviceUUID, element, chunkFile, backupFile, chunkDetail.getContainerName().toLowerCase(), chunkDetail.getUserName().toLowerCase(), chunkDetail, fileStatusElement, graphClient);
                        String saltKey = this.getEncryptOrDecryptKey(cloudId, chunkDetail.getChunkCreatedTime(), BACKUP);
                        if (saltKey == null) {
                            throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                        }
                        User user = this.utilService.getUserInfoByName(cloudId, chunkDetail.getContainerName());
                        File decryptedFile = this.getDecryptedFile(cloudName, saltKey, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, user.getUserName(), restorePath, chunkFile, cloudId, chunkDetail);
                        if (decryptedFile == null) {
                            this.addHeadersInMultiPartForFilesInOthrPG(response, downloadedCountTemp, path, backUpImage, fileInfo, skipValue, isEncodedEnabled, restoreId);
                            this.sendEmptyContents(response);
                            break;
                        }
                        downloadedCountTemp = this.addHeadersInMultiPartForFilesInOthrPG(response, downloadedCountTemp, path, backUpImage, fileInfo, skipValue, isEncodedEnabled, restoreId);
                        downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                        isChunksDownloaded = true;
                        continue;
                    }
                    bytes = (byte[])resultObj.getBody();
                    input = new ByteArrayInputStream(bytes);
                    downloadedCountTemp = this.addHeadersInMultiPartForFilesInOthrPG(response, downloadedCountTemp, path, backUpImage, fileInfo, skipValue, isEncodedEnabled, restoreId);
                    this.writeDataToStream(response, path, fileInfo, chunkName, filePath, input, restoreId);
                    isChunksDownloaded = true;
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e.getMessage());
                }
            }
            if (isChunksDownloaded) {
                ++downloadedCountTemp;
            }
            downloadedCountTemp = this.addHeadersInMultiPartForFilesInOthrPG(response, downloadedCountTemp, path, backUpImage, fileInfo, skipValue, isEncodedEnabled, restoreId);
        }
        return downloadedCountTemp;
    }

    private File retryWithParentSaltKey(int cloudId, String cloudName, String deviceUUID, String restorePath, com.pg.domain.ChunkFile chunkFile, ChunkDetail chunkDetail, String decryptUserName, BufferedInputStream csis, File decryptedFile1) {
        File decryptedFile = decryptedFile1;
        String saltKey = "";
        if (chunkDetail == null) {
            return null;
        }
        logger.debug("decrypted file is null so get salt key for parent file id>>>>>" + chunkDetail.getCloudChunkName());
        int occurance = StringUtils.countMatches((String)chunkDetail.getCloudChunkName(), (String)".");
        String backupIdOfchunkFile = DownloadServiceImpl.getBackupIdFromFileName(chunkDetail.getCloudChunkName(), occurance);
        logger.debug("Backup id of chunk file is>>>>>>" + backupIdOfchunkFile);
        if (!StringUtils.isEmpty((String)backupIdOfchunkFile)) {
            logger.debug("inside getting bkp image Backup id of chunk file is>>>>>>" + backupIdOfchunkFile);
            BackUpImage bkpImage = this.backUpImageDao.getBackupFileForIDOnly(cloudId, new ObjectId(backupIdOfchunkFile));
            if (bkpImage != null) {
                if (!CollectionUtils.isEmpty((Collection)bkpImage.getChunkFiles())) {
                    logger.debug("Backup image is not null>>>>>>" + bkpImage.getChunkFiles().size());
                    for (ChunkFile chunkFile2 : bkpImage.getChunkFiles()) {
                        if (chunkFile2.getMd5() == null) {
                            chunkFile2.setMd5(DownloadServiceImpl.getMd5FromFileName(chunkFile2.getFileName()));
                        }
                        if (!chunkFile2.getMd5().equals(chunkDetail.getMd5())) continue;
                        logger.debug("BEFORE ####Salt key for retry to get decrypt file with parent file salt key############:");
                        saltKey = this.getEncryptOrDecryptKey(cloudId, chunkDetail.getChunkCreatedTime(), BACKUP);
                        logger.debug("Salt key for retry to get decrypt file with parent file salt key############:" + saltKey);
                        break;
                    }
                    decryptedFile = this.getDecryptedFile1(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), csis, decryptUserName, restorePath);
                } else {
                    List encryptionKeysList = new ArrayList();
                    if (chunkFile.getUploadedTimeStamp() == 0L) {
                        encryptionKeysList = this.encryptionKeyDao.getAllEncryptionKeys(cloudId, BACKUP);
                    }
                    for (EncryptionKey key : encryptionKeysList) {
                        logger.debug("inside else part salt key is>>>>>>" + backupIdOfchunkFile);
                        decryptedFile = this.getDecryptedFile1(cloudName, key.getSaltKey(), deviceUUID, chunkFile.getFileName(), csis, decryptUserName, restorePath);
                        if (decryptedFile == null) {
                            logger.debug("inside getting bkp image is null for id>>>>>>" + backupIdOfchunkFile);
                            continue;
                        }
                        break;
                    }
                }
            } else {
                decryptedFile = this.getDecryptedFile1(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), csis, decryptUserName, restorePath);
                logger.debug("inside getting saltKey is null for id>>>>>>" + saltKey);
            }
        }
        return decryptedFile;
    }

    private void createBackupFile(List<com.pg.domain.BackupFile> list, BackUpImage backUpImage) {
        com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
        BeanUtils.copyProperties((Object)backUpImage, (Object)backupFile);
        backupFile.setBackupId(backUpImage.getId());
        backupFile.setFilePath(backUpImage.getDevicePath());
        backupFile.setUploadedTimestamp(Long.valueOf(backUpImage.getLastClientModifiedTime()));
        backupFile.setMd5(backUpImage.getMd5Checksum());
        ArrayList<com.pg.domain.ChunkFile> pgChunkFiles = new ArrayList<com.pg.domain.ChunkFile>();
        com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
        chunkFile.setFileName(backUpImage.getMd5Checksum() + "." + backUpImage.getId().toString());
        chunkFile.setFileId(backUpImage.getMd5Checksum() + "." + backUpImage.getId().toString());
        chunkFile.setMd5(backUpImage.getMd5Checksum());
        pgChunkFiles.add(chunkFile);
        backupFile.setChunkFiles(pgChunkFiles);
        list.add(backupFile);
    }

    private long addHeadersInMultiPartForFilesInOthrPG(HttpServletResponse response, long downloadedCountTemp, String path, BackUpImage pgBkp, FileInfo fileInfo, int skipValue, Boolean isEncodedEnabled, String restoreId) {
        try {
            response.getOutputStream().println();
            response.getOutputStream().println(PARABLU_OF);
            String partHeader = CONTENT_DISPOSITION_FORM_DATA;
            response.getOutputStream().println(partHeader);
            String fileNameHeader = this.getEncodedFileName(isEncodedEnabled, fileInfo.getFileName());
            byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
            response.getOutputStream().write(fileNameBytes);
            response.getOutputStream().println();
            String filePathHeader = this.getEncodedFilePath(isEncodedEnabled, fileInfo.getFilePath());
            byte[] filePathBytes = filePathHeader.getBytes(UTF8);
            response.getOutputStream().write(filePathBytes);
            response.getOutputStream().println();
            String clientModifiedTimeHeader = CLIENT_MODIFIED_TIME + fileInfo.getUploadedTimestamp();
            response.getOutputStream().println(clientModifiedTimeHeader);
            if (fileInfo.getAccessTime() != 0L) {
                String clientAccessTimeHeader = CLIENT_ACCESS_TIME + fileInfo.getAccessTime();
                response.getOutputStream().println(clientAccessTimeHeader);
            }
            String md5 = MD5_CHECKSUM + pgBkp.getMd5Checksum();
            response.getOutputStream().println(md5);
            logger.debug(FILE_MD5 + md5);
            response.getOutputStream().println(COMPRESSION_ENABLED + String.valueOf(pgBkp.isCompressed()));
            response.getOutputStream().println(COUNT + downloadedCountTemp);
            response.getOutputStream().println(SKIP_VALUE + skipValue);
            response.getOutputStream().println();
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_TRYING_TO_WRITE_DATA + simpleName + FILE_PATH_STR + fileInfo.getFilePath() + FILE_NAME_STR + fileInfo.getFileName() + e.getMessage());
            try {
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error(EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
            }
        }
        return downloadedCountTemp;
    }

    private void addHeadersInMultiPart(HttpServletResponse response, long downloadedCountTemp, String path, com.pg.domain.BackupFile backupFile, com.pg.domain.ChunkFile chunkFile, String isChunk, int skipValue, Boolean isEncodedEnabled, int statusCode, String restoreId) {
        try {
            response.getOutputStream().println();
            response.getOutputStream().println(PARABLU_OF);
            String partHeader = CONTENT_DISPOSITION_FORM_DATA;
            response.getOutputStream().println(partHeader);
            String fileNameHeader = this.getEncodedFileName(isEncodedEnabled, backupFile.getFileName());
            byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
            response.getOutputStream().write(fileNameBytes);
            response.getOutputStream().println();
            String filePathHeader = this.getEncodedFilePath(isEncodedEnabled, backupFile.getFilePath());
            byte[] filePathBytes = filePathHeader.getBytes(UTF8);
            response.getOutputStream().write(filePathBytes);
            response.getOutputStream().println();
            String clientModifiedTimeHeader = CLIENT_MODIFIED_TIME + backupFile.getUploadedTimestamp();
            response.getOutputStream().println(clientModifiedTimeHeader);
            if (backupFile.getAccessTime() != null) {
                String clientAccessTimeHeader = CLIENT_ACCESS_TIME + backupFile.getAccessTime();
                response.getOutputStream().println(clientAccessTimeHeader);
            }
            String md5 = MD5_CHECKSUM + chunkFile.getMd5();
            response.getOutputStream().println(md5);
            logger.debug(FILE_MD5 + md5 + ".....client...." + clientModifiedTimeHeader);
            response.getOutputStream().println(COMPRESSION_ENABLED + String.valueOf(backupFile.isCompressed()));
            response.getOutputStream().println("isAChunkFile:" + isChunk);
            response.getOutputStream().println(SKIP_VALUE + skipValue);
            response.getOutputStream().println("downloadStatus:" + statusCode);
            response.getOutputStream().println(COUNT + downloadedCountTemp);
            response.getOutputStream().println();
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_TRYING_TO_WRITE_DATA + simpleName + FILE_PATH_STR + backupFile.getFilePath() + FILE_NAME_STR + backupFile.getFileName() + e.getMessage());
            try {
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                    if (!StringUtils.isEmpty((String)restoreId)) {
                        String pathToDelete = path + restoreId;
                        logger.debug("...deletebase folder..." + pathToDelete);
                        File file = new File(pathToDelete);
                        if (file.exists()) {
                            FileUtils.deleteDirectory((File)file);
                        }
                    }
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION + path);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error(EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
            }
        }
    }

    private void addHeaderFieldsToMultiPartFrFilesInPG(HttpServletResponse response, long downloadedCountTemp, String path, FileInfo fileInfo, String md5, int skipValue, Boolean isEncodedEnabled, String restoreId) {
        try {
            response.getOutputStream().println();
            response.getOutputStream().println(PARABLU_OF);
            String partHeader = CONTENT_DISPOSITION_FORM_DATA;
            response.getOutputStream().println(partHeader);
            String fileNameHeader = this.getEncodedFileName(isEncodedEnabled, fileInfo.getFileName());
            byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
            response.getOutputStream().write(fileNameBytes);
            response.getOutputStream().println();
            String filePathHeader = this.getEncodedFilePath(isEncodedEnabled, fileInfo.getFilePath());
            byte[] filePathBytes = filePathHeader.getBytes(UTF8);
            response.getOutputStream().write(filePathBytes);
            response.getOutputStream().println();
            String clientModifiedTimeHeader = CLIENT_MODIFIED_TIME + fileInfo.getUploadedTimestamp();
            response.getOutputStream().println(clientModifiedTimeHeader);
            if (fileInfo.getAccessTime() != 0L) {
                String clientAccessTimeHeader = CLIENT_ACCESS_TIME + fileInfo.getAccessTime();
                response.getOutputStream().println(clientAccessTimeHeader);
            }
            String chunkMd5 = MD5_CHECKSUM + md5;
            response.getOutputStream().println(chunkMd5);
            response.getOutputStream().println(COMPRESSION_ENABLED + String.valueOf(fileInfo.isCompressed()));
            logger.debug(FILE_MD5 + chunkMd5);
            response.getOutputStream().println("isAChunkFile:true");
            response.getOutputStream().println(SKIP_VALUE + skipValue);
            response.getOutputStream().println(COUNT + downloadedCountTemp);
            response.getOutputStream().println();
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_TRYING_TO_WRITE_DATA + simpleName + FILE_PATH_STR + fileInfo.getFilePath() + FILE_NAME_STR + fileInfo.getFileName() + e.getMessage());
            try {
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error(EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
            }
        }
    }

    private static String getMd5FromFileName(String fileName) {
        int occurance = StringUtils.countMatches((String)fileName, (String)".");
        String md5 = "";
        logger.debug("File name inside getmd5$$$$>>:" + fileName);
        if (occurance == 0) {
            md5 = fileName;
        } else if (occurance == 1) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        if (StringUtils.isNotEmpty((String)md5) && md5.contains("_")) {
            md5 = md5.substring(0, md5.lastIndexOf("_"));
        }
        return md5;
    }

    private long createEmptyFileContents(HttpServletResponse response, BackUpImage backUpImage, long downloadedCount, long totalCount, Boolean isEncodedEnabled) {
        long downloadedCountTemp = downloadedCount;
        try {
            logger.error("FILESNOTINPG....................." + downloadedCountTemp);
            response.getOutputStream().println();
            response.getOutputStream().println(PARABLU_OF);
            String partHeader = CONTENT_DISPOSITION_FORM_DATA;
            response.getOutputStream().println(partHeader);
            String fileNameHeader = this.getEncodedFileName(isEncodedEnabled, backUpImage.getFileName());
            byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
            response.getOutputStream().write(fileNameBytes);
            response.getOutputStream().println();
            String filePathHeader = this.getEncodedFilePath(isEncodedEnabled, backUpImage.getDevicePath());
            byte[] filePathBytes = filePathHeader.getBytes(UTF8);
            response.getOutputStream().write(filePathBytes);
            response.getOutputStream().println();
            String clientModifiedTimeHeader = CLIENT_MODIFIED_TIME + backUpImage.getLastClientModifiedTime();
            response.getOutputStream().println(clientModifiedTimeHeader);
            if (backUpImage.getAccessTime() != 0L) {
                String clientAccessTimeHeader = CLIENT_ACCESS_TIME + backUpImage.getAccessTime();
                response.getOutputStream().println(clientAccessTimeHeader);
            }
            String md5 = MD5_CHECKSUM + backUpImage.getMd5Checksum();
            response.getOutputStream().println(md5);
            logger.debug(FILE_MD5 + md5);
            response.getOutputStream().println(COUNT + ++downloadedCountTemp);
            this.sendEmptyContents(response);
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_TRYING_TO_WRITE_DATA + simpleName + FILE_PATH_STR + backUpImage.getDevicePath() + FILE_NAME_STR + backUpImage.getFileName() + e.getMessage());
            try {
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error("Exception While Creating Empty Contents :" + e1.getMessage());
            }
        }
        return downloadedCountTemp;
    }

    private void writeDataToStream(HttpServletResponse response, String path, FileInfo fileInfo, String chunkName, String filePath, InputStream input, String restoreId) {
        if (input != null) {
            logger.debug(" writeDataToStream file from pg.size................." + filePath);
            try {
                this.writeDataToStreamForPg(response, path, fileInfo, input, chunkName, restoreId);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(EXCEPTION_WHILE_WRITTING_DATA_TO_STREAM + e.getMessage());
            }
        } else {
            logger.error(" file does not exists........" + filePath);
        }
    }

    private com.pg.domain.ChunkFile getChunkFileFromDetail(String fileNameValue, ChunkDetail chunkDetail) {
        com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
        chunkFile.setMd5(chunkDetail.getMd5());
        chunkFile.setFileName(fileNameValue);
        return chunkFile;
    }

    private com.pg.domain.BackupFile getBackupFile(FileInfo fileInfo) {
        com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
        backupFile.setFileName(fileInfo.getFileName());
        backupFile.setFilePath(fileInfo.getFilePath());
        backupFile.setId(fileInfo.getId());
        backupFile.setBackupId(new ObjectId(fileInfo.getId()));
        return backupFile;
    }

    private long writeDataToStream(HttpServletResponse response, long totalCount, long downloadedCount, String path, String restorePath, com.pg.domain.BackupFile backupFile, File decryptedFile, String restoreId) {
        long downloadedCountTemp = downloadedCount;
        try {
            logger.debug(NO_MERGE);
            downloadedCountTemp = this.writeDataToStream(decryptedFile, backupFile, response, totalCount, downloadedCountTemp, restorePath);
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_WHILE_TRYING_TO_WRITE_DATA + simpleName + e.getMessage());
            try {
                if (decryptedFile.exists()) {
                    decryptedFile.delete();
                }
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error(EXCEPTION_WHILE_WRITTING_DATA_TO_STREAM + e1.getMessage());
            }
        }
        return downloadedCountTemp;
    }

    private void writeDataToStreamForPg(HttpServletResponse response, String path, FileInfo fileInfo, InputStream fif, String fileName, String restoreId) {
        try {
            logger.debug(NO_MERGE);
            this.writeDataToStreamForPg(fileInfo, response, fif, fileName);
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_WHILE_TRYING_TO_WRITE_DATA + simpleName + e.getMessage());
            try {
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error("Exception While Writting Data To Stream For PG :" + e1.getMessage());
            }
        }
    }

    public String getEncryptOrDecryptKey(int cloudId, long timeStamp, String productType) {
        EncryptionKey encryptionKey = this.encryptionKeyDao.getKeyForDecrypt(cloudId, timeStamp, productType);
        String encryptionKeyVal = "";
        if (encryptionKey != null) {
            encryptionKeyVal = encryptionKey.getSaltKey();
            logger.debug("Recieved salt key  for file ..... " + encryptionKeyVal);
        }
        return encryptionKeyVal;
    }

    private File getDecryptedFile(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStream, String userName, String restorePath, com.pg.domain.ChunkFile chunkFile, int cloudId, ChunkDetail chunkDetail) {
        BufferedInputStream inputStreamTemp = inputStream;
        File decryptedDir = this.createDecryptedDirs(restorePath);
        if (inputStreamTemp == null) {
            return null;
        }
        File copyFile = this.copyInputStreamToAFile(fileName, inputStreamTemp, decryptedDir);
        File decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        logger.debug("Before trying with userName normal copy file case>>>>>>" + userName + "inputstreamlength>>>>");
        try {
            inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.trace("" + e);
            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
        }
        decryptedFile = this.fileEncryptionService.decrypt(saltKey, userName, inputStreamTemp, decryptedFile);
        logger.debug("END OF trying with userName normal case>>>>>>");
        if (decryptedFile == null) {
            String userLowerCase = null;
            try {
                userLowerCase = userName.toLowerCase();
                logger.error("Decryptfile is null so try with user lowercase...." + userLowerCase);
                decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
                inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
            }
            decryptedFile = this.fileEncryptionService.decrypt(saltKey, userLowerCase, inputStreamTemp, decryptedFile);
            logger.error("END Of try with user lowercase..");
            if (decryptedFile == null) {
                String userUpperCase = null;
                try {
                    userUpperCase = userName.toUpperCase();
                    logger.error("Decryptfile is null so try with user uppercase.." + userUpperCase);
                    decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
                    inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                }
                decryptedFile = this.fileEncryptionService.decrypt(saltKey, userUpperCase, inputStreamTemp, decryptedFile);
                logger.error("END Of try with user uppercase...\t");
            }
            if (decryptedFile == null) {
                List allEncryptionKeys = this.encryptionKeyDao.getAllEncryptionKeys(1, BACKUP);
                if (!CollectionUtils.isEmpty((Collection)allEncryptionKeys)) {
                    for (EncryptionKey encryptionKey : allEncryptionKeys) {
                        String oldSaltKey;
                        saltKey = oldSaltKey = encryptionKey.getSaltKey();
                        logger.error("Decryptfile is null so try with old saltkey.." + saltKey);
                        decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
                        try {
                            inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
                        }
                        catch (FileNotFoundException e) {
                            logger.trace("" + e);
                            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                        }
                        if ((decryptedFile = this.fileEncryptionService.decrypt(saltKey, userName, inputStreamTemp, decryptedFile)) == null) continue;
                        break;
                    }
                }
                logger.error("END Of try with user old saltkey....\t");
            }
            if (decryptedFile == null) {
                logger.debug("DEcrypted file is null>>>>> so create new file.....");
                decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
                try {
                    inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (FileNotFoundException e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                }
                decryptedFile = this.retryWithParentSaltKey(cloudId, cloudName, deviceUUID, restorePath, chunkFile, chunkDetail, userName, inputStreamTemp, decryptedFile);
            }
        }
        if (copyFile.exists()) {
            copyFile.delete();
        }
        try {
            inputStreamTemp.close();
        }
        catch (IOException e) {
            logger.error("couldn't close the input stream....", (Throwable)e);
        }
        return decryptedFile;
    }

    private File copyInputStreamToAFile(String fileName, BufferedInputStream inputStreamTemp, File decryptedDir) {
        String copyPath = decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName + COPY;
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStreamTemp, (File)new File(copyPath));
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
            throw new ParacloudBackupException(e.getMessage(), 234);
        }
        File copyFile = new File(decryptedDir + "/" + fileName + COPY);
        return copyFile;
    }

    private File createDecryptedDirs(String restorePath) {
        File mergeDir;
        File decryptedDir = new File(restorePath + DECRYPTED);
        if (!decryptedDir.exists()) {
            decryptedDir.mkdir();
        }
        if (!(mergeDir = new File(restorePath + MERGE)).exists()) {
            mergeDir.mkdir();
        }
        return decryptedDir;
    }

    private File getDecryptedFile1(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStreamTemp1, String userName, String restorePath) {
        BufferedInputStream inputStreamTemp = inputStreamTemp1;
        File decryptedDir = this.createDecryptedDirs(restorePath);
        if (inputStreamTemp == null) {
            return null;
        }
        String copyPath = decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName + COPY;
        try {
            if (new File(copyPath).exists()) {
                new File(copyPath).delete();
            }
            FileUtils.copyInputStreamToFile((InputStream)inputStreamTemp, (File)new File(copyPath));
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
        }
        File decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        logger.debug("Before trying with userName normal copy file case>>>>>>" + userName + "decrpted path>>" + decryptedFile.getAbsolutePath());
        File copyFile = new File(decryptedDir + "/" + fileName + COPY);
        try {
            inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
        }
        catch (FileNotFoundException e) {
            logger.debug("FileNotFoundException  :" + e);
            logger.trace("" + e);
            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
        }
        decryptedFile = this.fileEncryptionService.decrypt(saltKey, userName, inputStreamTemp, decryptedFile);
        logger.debug("END OF trying with userName normal case>>>>>>");
        if (decryptedFile == null) {
            String userLowerCase = userName.toLowerCase();
            logger.error("Decryptfile is null so try with user lowercase...." + userLowerCase);
            decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
            try {
                inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
            }
            catch (FileNotFoundException e) {
                logger.trace("" + e);
                logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
            }
            decryptedFile = this.fileEncryptionService.decrypt(saltKey, userLowerCase, inputStreamTemp, decryptedFile);
            logger.error("END Of try with user lowercase..");
            if (decryptedFile == null) {
                String userUpperCase = userName.toUpperCase();
                logger.error("Decryptfile is null so try with user uppercase.." + userUpperCase);
                decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
                try {
                    inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (FileNotFoundException e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                }
                decryptedFile = this.fileEncryptionService.decrypt(saltKey, userUpperCase, inputStreamTemp, decryptedFile);
                logger.error("END Of try with user uppercase...\t");
            }
            if (copyFile.exists()) {
                copyFile.delete();
            }
            if (decryptedFile == null) {
                logger.debug("DEcrypted file is null>>>>> so create new file.....");
                return null;
            }
        }
        if (copyFile.exists()) {
            copyFile.delete();
        }
        try {
            inputStreamTemp.close();
        }
        catch (IOException e) {
            logger.error("couldn't close the input stream....", (Throwable)e);
        }
        return decryptedFile;
    }

    private long writeDataToStream(File file, com.pg.domain.BackupFile backupFile, HttpServletResponse response, long totalCount, long downloadedCount, String path) throws IOException {
        try {
            int buff;
            logger.debug(downloadedCount + SENDING_FILE + file.getName());
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream fif = new BufferedInputStream(fis);
            logger.debug(BACKUP_FILE_IS_COMPRESSED + backupFile.isCompressed());
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
                response.getOutputStream().flush();
            }
            ((InputStream)fif).close();
            logger.debug(file.length() + ".." + FINISHED_FILE + file.getName());
            file.delete();
            logger.debug("deleting  file  under path ....." + file.getPath());
        }
        catch (Exception e) {
            logger.debug("Exception   " + e);
            logger.error("Exception   " + e.getMessage());
        }
        return downloadedCount;
    }

    private void writeDataToStreamForPg(FileInfo fileInfo, HttpServletResponse response, InputStream fif, String fileName) throws IOException {
        int buff;
        InputStream fifTemp = fif;
        logger.debug(SENDING_FILE + fileName);
        logger.debug(BACKUP_FILE_IS_COMPRESSED + fileInfo.isCompressed());
        byte[] b = new byte[4096];
        while ((buff = fifTemp.read(b)) != -1) {
            response.getOutputStream().write(b, 0, buff);
            response.getOutputStream().flush();
        }
        fifTemp.close();
        logger.debug(FINISHED_FILE + fileName);
    }

    private void deleteFilesUnderMergeAndDecrypt(String path, String restoreId) {
        String mergePath = path + MERGE;
        String decryptedPath = path + DECRYPTED;
        logger.debug(mergePath + "...path.." + decryptedPath);
        File mergeFolder = new File(mergePath);
        File decryptedFolder = new File(decryptedPath);
        if (mergeFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)mergeFolder);
        }
        if (decryptedFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)decryptedFolder);
        }
        logger.debug("..restoreid ..." + restoreId);
        if (!StringUtils.isEmpty((String)restoreId)) {
            mergePath = path + restoreId + "/" + MERGE;
            decryptedPath = path + restoreId + "/" + DECRYPTED;
            logger.debug(mergePath + "...restorepath.." + decryptedPath);
            mergeFolder = new File(mergePath);
            decryptedFolder = new File(decryptedPath);
            if (mergeFolder.exists()) {
                ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)mergeFolder);
            }
            if (decryptedFolder.exists()) {
                ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)decryptedFolder);
            }
        }
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private File bruteForceRestoreFromCloud(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, String folderPath, String fileName, PciAuthorizationTokenElement element, String restorePath, Device device, FileStatusElement fileStatusElement) {
        String saltKeyTemp = saltKey;
        int cloudId = cloud.getCloudId();
        File decryptedFile = null;
        logger.debug("FORCE RESTORE STARTS");
        BufferedInputStream inputStream = null;
        String folderPathTemp = backupFile.getFilePath();
        String fileNameTemp = backupFile.getFileName();
        List backupFiles = this.externalStorageBackupFileDao.getBackupFilesForGivenPathAndFileName(cloudId, cloudName, userName, folderPathTemp, fileNameTemp);
        if (CollectionUtils.isEmpty((Collection)backupFiles)) {
            logger.error(" backup files list is empty .......");
            return null;
        }
        String firstRevisionBackupId = new String();
        Map<String, List<ChunkFile>> firstRevisionChunks = this.getFirstRevisionFromExternalStorageTable(cloudName, userName, folderPathTemp, fileNameTemp, backupFiles, firstRevisionBackupId);
        if (firstRevisionChunks != null) {
            firstRevisionBackupId = firstRevisionChunks.keySet().toArray()[0].toString();
        }
        List<ChunkFile> backupChunkFileList = firstRevisionChunks.get(firstRevisionBackupId);
        com.pg.domain.ChunkFile chunkFile2 = new com.pg.domain.ChunkFile();
        logger.debug("FirstVersion backup Iddd>>" + firstRevisionBackupId);
        GraphServiceClient<Request> graphClient = null;
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
            graphClient = OneDriveUtil.getGraphClient();
        }
        for (ChunkFile chunkFile : backupChunkFileList) {
            block16: {
                try {
                    BeanUtils.copyProperties((Object)chunkFile, (Object)chunkFile2);
                    ChunkDetail chunkDetail = new ChunkDetail();
                    BeanUtils.copyProperties((Object)chunkFile, (Object)chunkDetail);
                    String fileNameToDownload = chunkFile.getFileName() + "." + firstRevisionBackupId;
                    logger.debug(" BEFORE DOWNLOADING Chunks file for BruteForce >>>>>> " + fileNameToDownload);
                    logger.debug("File Download from BLOB...........");
                    inputStream = this.downloadFileFromCloud(cloud, restorePath, fileNameToDownload, userName.toLowerCase(), cloudName, backupFile.getDeviceUUID(), element, chunkFile2, backupFile, userName.toLowerCase(), userName.toLowerCase(), chunkDetail, fileStatusElement, graphClient);
                }
                catch (ParacloudBackupException e) {
                    logger.trace("" + (Object)((Object)e));
                    logger.error("THE error code is>>>>>>>>>>" + e.getResponseCode());
                    if (e.getResponseCode() != 404) break block16;
                    nameList.clear();
                    try {
                        this.searchReplicaAndRestore(cloud, cloudName, userName, backupFile, nameList, saltKeyTemp, fileNameTemp, folderPathTemp, element, restorePath, device, fileStatusElement);
                    }
                    catch (ParacloudBackupException backupException) {
                        logger.debug("Exception : " + (Object)((Object)backupException));
                        logger.debug(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + backupException.getMessage());
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        logger.trace("" + e1);
                        logger.error(EXCEPTION_WHILE_BRUTE_FORCE_RESTORE_FROM_CLOUD + e1.getMessage());
                    }
                    return null;
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_WHILE_BRUTE_FORCE_RESTORE_FROM_CLOUD + e.getMessage());
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        logger.trace("" + e1);
                        logger.error(EXCEPTION_WHILE_BRUTE_FORCE_RESTORE_FROM_CLOUD + e1.getMessage());
                    }
                    logger.debug(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                    throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                }
            }
            saltKeyTemp = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), BACKUP);
            if (saltKeyTemp == null) {
                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
            }
            decryptedFile = this.getDecryptedFile(cloudName, saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, restorePath, chunkFile2, cloudId, null);
            nameList.add(chunkFile.getFileName());
        }
        return decryptedFile;
    }

    private Map<String, List<ChunkFile>> getFirstRevisionFromExternalStorageTable(String cloudName, String userName, String folderPath, String fileName, List<BackupFile> backupFiles, String firstversionBackupId) {
        HashMap<String, List<ChunkFile>> firstRevisionsChunks = new HashMap<String, List<ChunkFile>>();
        logger.debug("BACKUP FILE LIST SIZE" + backupFiles.size());
        HashMap<String, List> fileRevisionsList = new HashMap<String, List>();
        HashMap<Long, String> chunkListWithTimstamp = new HashMap<Long, String>();
        if (!CollectionUtils.isEmpty(backupFiles)) {
            for (BackupFile backupFile : backupFiles) {
                if (backupFile == null) continue;
                logger.debug("TimeStamp>>>>>>>" + ((ChunkFile)backupFile.getChunkFiles().get(0)).getUploadedTimeStamp());
                chunkListWithTimstamp.put(((ChunkFile)backupFile.getChunkFiles().get(0)).getUploadedTimeStamp(), backupFile.getId().toString());
                fileRevisionsList.put(backupFile.getId().toString(), backupFile.getChunkFiles());
            }
            Map<Long, String> chunkListWithTimstampInOrder = DownloadServiceImpl.sortByComparator(chunkListWithTimstamp);
            Object myKey = chunkListWithTimstampInOrder.keySet().toArray()[0];
            logger.debug("TimeStamp AFTER SORTING>>>>>>>" + myKey.toString());
            String firstversionBackupIdTemp = chunkListWithTimstampInOrder.get(myKey);
            logger.debug("BackupId AFTER SORTING>>>>>>>" + firstversionBackupIdTemp);
            List backupChunkFileList = (List)fileRevisionsList.get(firstversionBackupIdTemp);
            firstRevisionsChunks.put(firstversionBackupIdTemp, backupChunkFileList);
        }
        return firstRevisionsChunks;
    }

    private static Map<Long, String> sortByComparator(Map<Long, String> unsortMap) {
        LinkedList<Map.Entry<Long, String>> list = new LinkedList<Map.Entry<Long, String>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Long, String>>(){

            @Override
            public int compare(Map.Entry<Long, String> o1, Map.Entry<Long, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        LinkedHashMap<Long, String> sortedMap = new LinkedHashMap<Long, String>();
        for (Map.Entry entry : list) {
            sortedMap.put((Long)entry.getKey(), (String)entry.getValue());
        }
        return sortedMap;
    }

    private File searchReplicaAndRestore(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, String fileName, String folderPath, PciAuthorizationTokenElement element, String restorePath, Device device, FileStatusElement fileStatusElement) {
        String saltKeyTemp = saltKey;
        com.pg.domain.BackupFile backupFileTemp = backupFile;
        int cloudId = cloud.getCloudId();
        logger.debug("GET THE PARENT FILE AND RESTORE");
        File decryptedFile = null;
        BackUpImage list = this.backUpImageDao.getBackupFileForID(cloudId, backupFileTemp.getBackupId(), userName, device, true);
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        if (list != null) {
            logger.debug("GET THE PARENT FILE AND RESTORE BACKUP IMAGE NOT NULL>>" + list.getId());
            backupFileTemp = this.getBackupFileFromDB(cloudName, userName, list.getId().toString());
            if (backupFileTemp != null) {
                GraphServiceClient<Request> graphClient = null;
                if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                    graphClient = OneDriveUtil.getGraphClient();
                }
                BufferedInputStream inputStream = null;
                for (com.pg.domain.ChunkFile chunkFile : backupFileTemp.getChunkFiles()) {
                    try {
                        ChunkDetail chunkDetail = new ChunkDetail();
                        BeanUtils.copyProperties((Object)chunkFile, (Object)chunkDetail);
                        StringBuilder fileNameToDownload = new StringBuilder(chunkFile.getFileName());
                        int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                        if (occurance == 0) {
                            fileNameToDownload.append(".").append(backupFileTemp.getBackupId().toString());
                        } else if (occurance == 1 && backupFileTemp.getChunkFiles().size() > 1) {
                            decryptedFile = this.bruteForceRestoreFromCloud(cloud, cloudName, userName, backupFileTemp, nameList, saltKeyTemp, fileName, folderPath, element, restorePath, device, fileStatusElement);
                            return decryptedFile;
                        }
                        logger.debug(" BEFORE DOWNLOADING Chunks file for REPLICA >>>>>> " + fileNameToDownload);
                        logger.debug("File Download from BLOB...........");
                        inputStream = this.downloadFileFromCloud(cloud, restorePath, fileNameToDownload.toString(), userName.toLowerCase(), cloudName, backupFileTemp.getDeviceUUID(), element, chunkFile, backupFileTemp, userName.toLowerCase(), userName.toLowerCase(), chunkDetail, fileStatusElement, graphClient);
                    }
                    catch (Exception e) {
                        logger.trace("" + e);
                        logger.error(EXCEPTION_WHILE_SEARCHING_FOR_REPLICA_AND_RESTORE + e.getMessage());
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e1) {
                            logger.trace("" + e1);
                            logger.error(EXCEPTION_WHILE_SEARCHING_FOR_REPLICA_AND_RESTORE + e1.getMessage());
                        }
                        logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                        throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                    }
                    try {
                        saltKeyTemp = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), BACKUP);
                        if (saltKeyTemp == null) {
                            throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                        }
                        decryptedFile = this.getDecryptedFile(cloudName, saltKeyTemp, backupFileTemp.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, restorePath, chunkFile, cloudId, null);
                        nameList.add(chunkFile.getFileName());
                    }
                    catch (Exception e) {
                        logger.trace("" + e);
                        logger.error(EXCEPTION_WHILE_SEARCHING_FOR_REPLICA_AND_RESTORE + e.getMessage());
                    }
                }
            } else {
                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
            }
        }
        return decryptedFile;
    }

    private com.pg.domain.BackupFile getBackupFileFromDB(String cloudName, String userName, String backupId) {
        BackupFile file = this.externalStorageBackupFileDao.getBackupFile(1, cloudName, userName, backupId);
        com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
        ArrayList<com.pg.domain.ChunkFile> chunkList = new ArrayList<com.pg.domain.ChunkFile>();
        for (ChunkFile chunkFile : file.getChunkFiles()) {
            com.pg.domain.ChunkFile newChunkFile = new com.pg.domain.ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)newChunkFile);
            chunkList.add(newChunkFile);
        }
        BeanUtils.copyProperties((Object)file, (Object)backupFile);
        backupFile.setBackupId(file.getId());
        backupFile.getChunkFiles().clear();
        backupFile.getChunkFiles().addAll(chunkList);
        return backupFile;
    }

    private BufferedInputStream downloadFileFromCloud(Cloud cloud, String restorePathDir, String fileNameToDownload, String userName, String cloudName, String deviceUUID, PciAuthorizationTokenElement pciAuthorizationTokenElement, com.pg.domain.ChunkFile chunkFile, com.pg.domain.BackupFile backupFile, String containerName, String folderName, ChunkDetail chunkDetail, FileStatusElement fileStatusElement, GraphServiceClient<Request> graphClient) {
        logger.debug(fileStatusElement.getDriveId() + ":drive id downloading files using cloudsupport service  >>>>>> " + fileNameToDownload + "...in container..." + containerName);
        com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
        BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
        BufferedInputStream inputStream = this.cloudSupportService.downloadFile(cloud, restorePathDir, fileNameToDownload, userName, deviceUUID, containerName, pgChunkFile, false, backupFile, fileStatusElement, folderName, chunkDetail, fileStatusElement.getDriveId(), graphClient);
        return inputStream;
    }

    private com.pg.domain.BackupFile convertBkpImageToBackupFile(BackUpImage backUpImage) {
        com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
        if (backUpImage == null || CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
            return null;
        }
        BeanUtils.copyProperties((Object)backUpImage, (Object)backupFile);
        backupFile.setBackupId(backUpImage.getId());
        backupFile.setFilePath(backUpImage.getDevicePath());
        if (backUpImage.getAccessTime() != 0L) {
            backupFile.setAccessTime(Long.valueOf(backUpImage.getAccessTime()));
        }
        List list = backUpImage.getChunkFiles();
        ArrayList<com.pg.domain.ChunkFile> pgChunkFiles = new ArrayList<com.pg.domain.ChunkFile>();
        for (ChunkFile chunkFile : list) {
            com.pg.domain.ChunkFile pgChunk = new com.pg.domain.ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunk);
            pgChunkFiles.add(pgChunk);
        }
        backupFile.setUploadedTimestamp(Long.valueOf(backUpImage.getLastClientModifiedTime()));
        backupFile.setChunkFiles(new ArrayList());
        backupFile.setChunkFiles(pgChunkFiles);
        return backupFile;
    }

    private void sendEmptyContents(HttpServletResponse response) throws IOException {
        response.getOutputStream().write("file is not in pg".getBytes());
        response.getOutputStream().flush();
    }

    private static String getBackupIdFromFileName(String fileName, int occurance) {
        String backupId = "";
        if (occurance == 1 && !fileName.startsWith("part000")) {
            backupId = fileName.substring(fileName.lastIndexOf(46) + 1);
        } else if (occurance > 1) {
            backupId = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        }
        return backupId;
    }

    private void downloadFromCloudForPortal(com.pg.domain.BackupFile backupFileTemp, DownloadFileTO downloadFileTO, HttpServletResponse response, Cloud cloud, String browserType, Device device, DownloadTO downloadTO) {
        block28: {
            String saltKey = null;
            com.pg.domain.BackupFile backupFile = backupFileTemp;
            String cloudName = downloadFileTO.getCloudName();
            String userName = downloadFileTO.getUserName();
            String deviceUUID = downloadFileTO.getDeviceUUID();
            String fileName = backupFile.getFileName();
            boolean isSync = downloadFileTO.isSync();
            if (!StringUtils.isEmpty((String)backupFile.getDedupBackupId()) && isSync) {
                backupFile = this.utilService.getSyncFile(1, cloudName, userName, backupFile.getDedupBackupId());
            }
            ArrayList<String> nameList = new ArrayList<String>();
            logger.debug(backupFile.isMail() + " BEFORE DOWNLOADING File  >>>>>> " + fileName + "bowser type " + browserType);
            String encodedFilename = fileName;
            if (backupFile.isMail()) {
                fileName = fileName + ".eml";
            }
            logger.debug("...usernames..." + backupFile.getUserName() + "..." + userName);
            if (!StringUtils.isEmpty((String)backupFile.getUserName()) && !userName.equalsIgnoreCase(backupFile.getUserName())) {
                userName = backupFile.getUserName();
            }
            boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
            logger.debug("...after usernames..." + backupFile.getUserName() + "..." + userName);
            if (!StringUtils.isEmpty((String)downloadFileTO.getAttachmentId()) || !StringUtils.isEmpty((String)downloadFileTO.getAttachName())) {
                logger.debug("... downaloding attachment .... ");
                BackUpImage backUpImage = this.backUpImageDao.getBackupFileForID(cloud.getCloudId(), backupFile.getBackupId(), userName, device, true);
                Long filesize = backUpImage.getSize();
                List attlist = backUpImage.getAttachments();
                String fileInfoFileName = backUpImage.getFileName();
                String chunk1 = "";
                GraphServiceClient<Request> graphClient = null;
                OkHttpClient okHttpClient = null;
                if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                    graphClient = OneDriveUtil.getGraphClient();
                    okHttpClient = Graph.getInstance().getOkHttpClient();
                }
                MailAttachment attachmentOrg = null;
                for (MailAttachment attachment : attlist) {
                    if (!attachment.getName().equalsIgnoreCase(downloadFileTO.getAttachName())) continue;
                    fileInfoFileName = attachment.getName();
                    if (attachment.getSize() != null) {
                        filesize = (long)attachment.getSize();
                    }
                    attachmentOrg = attachment;
                }
                logger.debug("....trying to download attachment  name..." + fileInfoFileName);
                response.addHeader("Pragma", "public");
                response.addHeader("Expires", String.valueOf(200));
                response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                encodedFilename = fileInfoFileName;
                try {
                    encodedFilename = URLEncoder.encode(fileInfoFileName, UTF8).replace("+", "%20");
                    if (browserType.contains("Firefox")) {
                        response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFilename);
                    } else if (browserType.contains("Chrome")) {
                        response.setHeader("Content-Disposition", "attachment; filename=" + encodedFilename);
                    } else {
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileInfoFileName + "\"");
                    }
                    response.addHeader("Content-Transfer-Encoding", "binary");
                    response.addHeader("filename", fileInfoFileName);
                    response.addHeader("Content-Transfer-Encodingsdasda", "binary");
                    response.setContentType("application/octet-stream");
                    boolean fileExists = true;
                    fileExists = this.syncDownloadService.downloadFileFromCloudForPortal(cloud, cloudName, userName, backupFile, nameList, saltKey, response, fileExists, isSync, downloadFileTO.getAttachName());
                    if (fileExists || !downloadFileTO.isSync()) break block28;
                    nameList = new ArrayList();
                    logger.debug(" portal .. try parent file for md5..........");
                    com.pg.domain.BackupFile backupFileObj = this.syncFileDao.getSyncFileForMd5(1, cloudName, userName, deviceUUID, backupFile.getMd5());
                    if (backupFileObj != null) {
                        logger.debug(" portal .. parent file for md5 exists ..........");
                        this.syncDownloadService.downloadFileFromCloudForPortal(cloud, cloudName, userName, backupFileObj, nameList, saltKey, response, fileExists, isSync, downloadFileTO.getAttachName());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    logger.trace("" + e);
                    logger.error("" + e.getMessage());
                }
            } else {
                try {
                    response.addHeader("Pragma", "public");
                    response.addHeader("Expires", String.valueOf(200));
                    response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                    if (!StringUtils.isEmpty((String)downloadFileTO.getAttachName())) {
                        fileName = downloadFileTO.getAttachName();
                        BackUpImage backUpImage = this.backUpImageDao.getBackupFileForID(cloud.getCloudId(), backupFile.getBackupId(), userName, device, true);
                        if (backUpImage != null && !CollectionUtils.isEmpty((Collection)backUpImage.getAttachments())) {
                            for (MailAttachment attachment : backUpImage.getAttachments()) {
                                if (!fileName.equalsIgnoreCase(attachment.getName())) continue;
                                logger.debug(attachment.getSize() + "...size of attach...." + backupFile.getSize() + "..." + backupFile.getSizeInBytes());
                                backupFile.setSize(Long.valueOf(attachment.getSize().longValue()));
                                backupFile.setSizeInBytes(Long.valueOf(attachment.getSize().longValue()));
                                downloadTO.setSize(attachment.getSize().longValue());
                            }
                        }
                    }
                    encodedFilename = URLEncoder.encode(fileName, UTF8).replace("+", "%20");
                    if (browserType.contains("Firefox") || browserType.contains("Chrome")) {
                        response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFilename);
                    } else {
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                    }
                    response.addHeader("Content-Transfer-Encoding", "binary");
                    if (isSync) {
                        response.addHeader("Content-Length", String.valueOf(backupFile.getSize()));
                    } else if (backupFile.getSizeInBytes() != null && backupFile.getSizeInBytes() != 0L) {
                        response.addHeader("Content-Length", String.valueOf(backupFile.getSizeInBytes()));
                    } else {
                        response.addHeader("Content-Length", String.valueOf((backupFile.getSize() + 1L) * 1024L));
                    }
                    response.addHeader("filename", fileName);
                    response.addHeader("Content-Transfer-Encodingsdasda", "binary");
                    response.setContentType("application/octet-stream");
                    boolean fileExists = true;
                    fileExists = this.syncDownloadService.downloadFileFromCloudForPortal(cloud, cloudName, userName, backupFile, nameList, saltKey, response, fileExists, isSync, downloadFileTO.getAttachName());
                    if (!fileExists && downloadFileTO.isSync()) {
                        nameList = new ArrayList();
                        logger.debug(" portal .. try parent file for md5..........");
                        com.pg.domain.BackupFile backupFileObj = this.syncFileDao.getSyncFileForMd5(1, cloudName, userName, deviceUUID, backupFile.getMd5());
                        if (backupFileObj != null) {
                            logger.debug(" portal .. parent file for md5 exists ..........");
                            this.syncDownloadService.downloadFileFromCloudForPortal(cloud, cloudName, userName, backupFileObj, nameList, saltKey, response, fileExists, isSync, downloadFileTO.getAttachName());
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    logger.trace("" + e);
                    logger.error("" + e.getMessage());
                }
                logger.debug(backupFile.getSize() + "..bytes.." + backupFile.getSizeInBytes() + " After DOWNLOADING File  >>>>>> " + backupFile.getFileName());
            }
        }
    }

    public byte[] downloadFromCloudContactsPhotoForPortal(com.pg.domain.BackupFile backupFileTemp, DownloadFileTO downloadFileTO, Cloud cloud, String browserType, Device device) {
        byte[] bytearr = null;
        String saltKey = null;
        com.pg.domain.BackupFile backupFile = backupFileTemp;
        String cloudName = downloadFileTO.getCloudName();
        String userName = downloadFileTO.getUserName();
        String deviceUUID = downloadFileTO.getDeviceUUID();
        String fileName = backupFile.getFileName();
        boolean isSync = downloadFileTO.isSync();
        if (!StringUtils.isEmpty((String)backupFile.getDedupBackupId()) && isSync) {
            backupFile = this.utilService.getSyncFile(1, cloudName, userName, backupFile.getDedupBackupId());
        }
        ArrayList<String> nameList = new ArrayList<String>();
        logger.debug(backupFile.isMail() + " BEFORE DOWNLOADING File  >>>>>> " + fileName + "bowser type " + browserType);
        String encodedFilename = fileName;
        if (backupFile.isMail()) {
            fileName = fileName + ".eml";
        }
        if (!StringUtils.isEmpty((String)downloadFileTO.getAttachmentId())) {
            logger.debug("... downaloding attachment .... ");
            BackUpImage backUpImage = this.backUpImageDao.getBackupFileForID(cloud.getCloudId(), backupFile.getBackupId(), userName, device, true);
            GraphServiceClient<Request> graphClient = null;
            boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
            if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                graphClient = OneDriveUtil.getGraphClient();
            }
            List attlist = backUpImage.getAttachments();
            String fileInfoFileName = backUpImage.getFileName();
            String chunk = "";
            MailAttachment attachmentOrg = null;
            for (MailAttachment attachment : attlist) {
                if (!attachment.getId().equalsIgnoreCase(downloadFileTO.getAttachmentId())) continue;
                fileInfoFileName = attachment.getName();
                chunk = (String)attachment.getChunkFiles().get(0);
                attachmentOrg = attachment;
            }
            logger.debug(chunk + "....trying to download attachment  name..." + fileInfoFileName);
            ArrayList<String> list = new ArrayList<String>();
            list.add(chunk);
            Collections.sort(list);
            encodedFilename = fileInfoFileName;
            try {
                encodedFilename = URLEncoder.encode(fileInfoFileName, UTF8).replace("+", "%20");
                return this.syncDownloadService.downloadFromCloudContactsPhotoForPortal(cloud, cloudName, userName, backUpImage, nameList, saltKey, isSync, attachmentOrg, graphClient);
            }
            catch (UnsupportedEncodingException e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        }
        return bytearr;
    }

    @Override
    public File getDecryptedFileForPortal(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStream, String userName, String deccryptPath, com.pg.domain.ChunkFile chunkFile, int cloudId, ChunkDetail chunkDetail) {
        return this.getDecryptedFile(cloudName, saltKey, deviceUUID, fileName, inputStream, userName, deccryptPath, chunkFile, cloudId, chunkDetail);
    }

    private boolean isGDEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isGDEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"Google Drive Enabled".equalsIgnoreCase(license.getName())) continue;
            isGDEnabled = true;
            break;
        }
        return isGDEnabled;
    }

    private String getEncodedFileName(boolean isEncodedEnabled, String fileName) {
        String fileNameInHeader = FILE_NAME + fileName;
        try {
            if (isEncodedEnabled) {
                fileNameInHeader = FILE_NAME + this.encodeUTFBase64(fileName);
                return fileNameInHeader;
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("" + e);
        }
        return fileNameInHeader;
    }

    private String getEncodedFilePath(boolean isEncodedEnabled, String filePath) {
        String filePathInHeader = FILE_PATH + filePath;
        try {
            if (isEncodedEnabled) {
                filePathInHeader = FILE_PATH + this.encodeUTFBase64(filePath);
                return filePathInHeader;
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("" + e);
        }
        return filePathInHeader;
    }

    protected String encodeUTFBase64(String input) {
        try {
            return Base64.encodeBase64String((byte[])input.getBytes(UTF8));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
            return input;
        }
    }

    DownloadTO downloadZipFileFromCloudForPortal(DownloadFileTO downloadFileTO, HttpServletResponse response, Cloud cloud, String browserType, DownloadTO downloadTO, Device device, boolean isrestoreDeletedFile, List<String> rwlist) {
        try {
            this.downloadZipFileFromCloudForPortal(cloud, response, downloadFileTO, downloadTO, device, isrestoreDeletedFile, rwlist);
        }
        catch (Exception e) {
            logger.error("Exception" + e.getMessage());
        }
        return downloadTO;
    }

    private void downloadZipFileFromCloudForPortal(Cloud cloud, HttpServletResponse response, DownloadFileTO downloadFileTO, DownloadTO downloadTO, Device device, boolean isrestoreDeletedFile, List<String> rwlist) {
        String deviceUUID = downloadFileTO.getDeviceUUID();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        String userName = downloadFileTO.getUserName();
        String path = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + cloud.getCloudName() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "sync-download" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        long currentMills = System.currentTimeMillis();
        String restorePath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + currentMills + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File restoreFolderPath = new File(restorePath);
        if (!restoreFolderPath.exists()) {
            restoreFolderPath.mkdirs();
        }
        boolean isMail = false;
        if (device.getDeviceName().contains("Microsoft Exchange")) {
            isMail = true;
        }
        String devicePath = downloadFileTO.getFileName();
        logger.debug(devicePath + "Restore folder path is create :" + restoreFolderPath);
        try {
            long folderSize = 0L;
            List<BackUpImage> backupImageList = new ArrayList<BackUpImage>();
            BackUpImage backupImage = this.externalStorageBackupFileDao.getBackupFileById(cloudId, device, downloadFileTO.getBackupID(), isrestoreDeletedFile);
            if (backupImage != null) {
                backupImageList.add(backupImage);
            }
            logger.debug("....backupImage..." + backupImage.getId());
            ArrayList<BackUpImage> backupImages = new ArrayList<BackUpImage>();
            if (!StringUtils.isEmpty((String)backupImage.getDevicePath())) {
                logger.debug("....backupImage devicepath not empty..." + backupImage.getDevicePath());
                this.getAllFolderChildrenByDevicePath(cloudName, userName, backupImage.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImage.getFileName(), device, cloudId, backupImages, isrestoreDeletedFile);
            } else {
                logger.debug("....backupImage devicepath  empty..." + backupImage.getFileName());
                this.getAllFolderChildrenByDevicePath(cloudName, userName, backupImage.getFileName(), device, cloudId, backupImages, isrestoreDeletedFile);
            }
            backupImageList.addAll(backupImages);
            logger.debug("...first Size......." + backupImageList.size());
            if (!StringUtils.isEmpty((String)backupImage.getDevicePath())) {
                backupImageList = this.getFilteredBackupImageList(backupImageList);
            }
            logger.debug("...after filer first Size......." + backupImageList.size());
            if (!CollectionUtils.isEmpty(backupImageList)) {
                for (BackUpImage backupImagedata : backupImageList) {
                    boolean isFileSame;
                    if (backupImagedata != null && backupImagedata.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), backupImagedata.getFileName(), rwlist))) {
                        logger.debug("md5/file name is same so skip the file...........");
                        continue;
                    }
                    List<BackUpImage> backupImagesFolderFile = new ArrayList();
                    if (StringUtils.isNotEmpty((String)backupImagedata.getDevicePath())) {
                        logger.debug("....backupImagedata non empty..." + backupImage.getFileName());
                        backupImagesFolderFile = this.externalStorageBackupFileDao.getBackupFilesForBasePath(cloudId, cloudName, userName, device, backupImagedata.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImagedata.getFileName(), isrestoreDeletedFile);
                        for (BackUpImage img : backupImagesFolderFile) {
                            logger.debug("...path and file......" + img.getDevicePath() + "..." + img.getFileName());
                        }
                    } else {
                        logger.debug(backupImagedata.getFileName() + "....backupImagedata  empty..." + backupImage.getFileName());
                        backupImagesFolderFile = this.externalStorageBackupFileDao.getBackupFilesForBasePath(cloudId, cloudName, userName, device, backupImage.getFileName(), isrestoreDeletedFile);
                        logger.debug("...devuse..." + device.getDeviceUUID() + "...." + userName + "...." + backupImage.getFileName());
                        for (BackUpImage img : backupImagesFolderFile) {
                            logger.debug("...path and file..." + img.getDevicePath() + "..." + img.getFileName());
                        }
                    }
                    logger.debug("...before filer first Size......." + backupImagesFolderFile.size());
                    backupImagesFolderFile = this.getFilteredBackupImageList(backupImagesFolderFile);
                    logger.debug("...after filer first Size......." + backupImagesFolderFile.size());
                    if (CollectionUtils.isEmpty(backupImagesFolderFile)) continue;
                    folderSize = this.restoreBackupFolder(cloud, response, downloadFileTO, deviceUUID, path, tempdownloadDir, backupImagesFolderFile, folderSize, restorePath, isMail, rwlist);
                }
            }
            downloadTO.setSize(folderSize);
            logger.debug("Completed ....." + folderSize);
            String fullyQualifiedPath = path + devicePath + ".zip";
            ZipUtil.pack((File)new File(restorePath), (File)new File(fullyQualifiedPath));
            logger.debug("Path..." + path);
            logger.debug(new File(fullyQualifiedPath).length() + "...file length....");
            downloadTO.setPath(fullyQualifiedPath);
            try {
                logger.debug(new File(restorePath).length() + ".....restore...");
                FileUtils.deleteDirectory((File)new File(restorePath));
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" error trying to delete dir ...." + e.getMessage());
            }
            logger.debug("..full path...." + fullyQualifiedPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception" + e.getMessage());
            logger.trace("Exception" + e);
            logger.trace("Exception", (Throwable)e);
        }
    }

    @Override
    public void getAllFolderChildrenByDevicePath(String cloudName, String userName, String filePath, Device device, int cloudId, List<BackUpImage> backupImages, boolean isrestoreDeletedFile) {
        List backUpImagesTemp = this.externalStorageBackupFileDao.getBackupFolderForBasePath(cloudId, cloudName, userName, device, filePath, isrestoreDeletedFile);
        backupImages.addAll(backUpImagesTemp);
        logger.debug("...folders for path ....." + filePath + "..." + backupImages.size());
        if (!CollectionUtils.isEmpty((Collection)backUpImagesTemp)) {
            Stream stream = backUpImagesTemp.parallelStream();
            stream.forEach(backUpImage -> {
                String devicePath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                logger.debug("Inside loop after getting folders..bkpimages list size:" + backUpImagesTemp.size());
                if (StringUtils.isEmpty((String)backUpImage.getDevicePath())) {
                    devicePath = backUpImage.getFileName();
                }
                logger.debug("Inside loop to get immediate folders deevicePath:" + devicePath);
                this.getAllFolderChildrenByDevicePath(cloudName, userName, devicePath, device, cloudId, backupImages, isrestoreDeletedFile);
            });
        }
    }

    @Override
    public void getAllFolderChildrenByDevicePathLatest(String cloudName, String userName, String filePath, Device device, int cloudId, List<RestoreBackUpImage> backupImages, boolean exchangeRestoreDeletedMail) {
        List backUpImagesTemp = this.externalStorageBackupFileDao.getBackupFolderForBasePathLatest(cloudId, cloudName, userName, device, filePath, true);
        HashSet folderSet = new HashSet();
        backUpImagesTemp.forEach(bkpImage -> {
            if (folderSet.contains(bkpImage.getFileName())) {
                return;
            }
            backupImages.add((RestoreBackUpImage)bkpImage);
            folderSet.add(bkpImage.getFileName());
        });
        if (exchangeRestoreDeletedMail) {
            backUpImagesTemp.forEach(image -> folderSet.add(image.getFileName()));
            List backUpImagesTemp1 = this.externalStorageBackupFileDao.getBackupFolderForBasePathLatest(cloudId, cloudName, userName, device, filePath, false);
            backUpImagesTemp1.forEach(image -> {
                if (image.getStatus().equalsIgnoreCase("ADDED")) {
                    if (folderSet.contains(image.getFileName())) {
                        return;
                    }
                    backupImages.add((RestoreBackUpImage)image);
                    backUpImagesTemp.add(image);
                    folderSet.add(image.getFileName());
                    logger.debug(image.getStatus() + "..Adding deleted folder:" + image.getFileName());
                }
            });
        }
        logger.debug(backUpImagesTemp.size() + "...folders for path ....." + filePath + "..." + backupImages.size());
        if (!CollectionUtils.isEmpty((Collection)backUpImagesTemp)) {
            Stream stream = backUpImagesTemp.parallelStream();
            stream.forEach(backUpImage -> {
                String devicePath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                if (StringUtils.isEmpty((String)backUpImage.getDevicePath())) {
                    devicePath = backUpImage.getFileName();
                }
                logger.debug(backUpImagesTemp.size() + "Inside loop to get immediate folders deevicePath:" + devicePath);
                this.getAllFolderChildrenByDevicePathLatest(cloudName, userName, devicePath, device, cloudId, backupImages, exchangeRestoreDeletedMail);
            });
        }
    }

    @Override
    public DownloadTO downloadBackupFileForPortal(DownloadFileTO downloadFileTO, Cloud cloud, String cloudName, HttpServletResponse response, String browserType) {
        boolean isFileSame;
        FileInfo fileInfo = null;
        com.pg.domain.BackupFile backupFile = null;
        String userName = downloadFileTO.getUserName();
        DownloadTO downloadTO = new DownloadTO("");
        boolean isSync = false;
        int cloudId = cloud.getCloudId();
        String deviceUUID = downloadFileTO.getDeviceUUID();
        if (StringUtils.isEmpty((String)deviceUUID)) {
            deviceUUID = this.backupFileDao.getDeviceUUIDForId(cloudId, cloudName, userName, downloadFileTO.getBackupID());
        }
        List rwlist = this.fileDao.getRWSampleFilesList(cloud.getCloudId());
        logger.debug(downloadFileTO.getBackupID() + " backup id @@@@@ device uuid .... " + deviceUUID);
        if (deviceUUID != null) {
            downloadFileTO.setDeviceUUID(deviceUUID);
        }
        Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
        if (!StringUtils.isEmpty((String)downloadFileTO.getBackupID())) {
            backupFile = this.backupFileDao.getBackupFilesForId(cloudId, cloudName, userName, device, downloadFileTO.getBackupID(), true);
        }
        if (backupFile != null && backupFile.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), backupFile.getFileName(), rwlist))) {
            logger.debug("md5/file name is same so skip the file...........");
            response.setStatus(451);
            return null;
        }
        if (backupFile == null || CollectionUtils.isEmpty((Collection)backupFile.getChunkFiles())) {
            logger.debug("..download fromPG...");
            fileInfo = this.fileDao.getFileFromPG(userName, cloudName, downloadFileTO.getBackupID(), isSync);
            if (fileInfo != null && fileInfo.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), fileInfo.getFileName(), rwlist))) {
                logger.debug("md5/file name is same so skip the file...........");
                response.setStatus(451);
                return null;
            }
            ArrayList nameList = new ArrayList();
            if (!StringUtils.isEmpty((String)downloadFileTO.getAttachName())) {
                logger.debug("... downaloding attachment .... ");
                BackUpImage backUpImage = this.backUpImageDao.getBackupFileForID(cloud.getCloudId(), backupFile.getBackupId(), userName, device, true);
                Long filesize = backUpImage.getSize();
                List attlist = backUpImage.getAttachments();
                String fileInfoFileName = backUpImage.getFileName();
                String chunk1 = "";
                GraphServiceClient<Request> graphClient = null;
                OkHttpClient okHttpClient = null;
                graphClient = OneDriveUtil.getGraphClient();
                okHttpClient = Graph.getInstance().getOkHttpClient();
                MailAttachment attachmentOrg = null;
                for (MailAttachment attachment : attlist) {
                    if (!attachment.getName().equalsIgnoreCase(downloadFileTO.getAttachName())) continue;
                    fileInfoFileName = attachment.getName();
                    if (attachment.getSize() != null) {
                        filesize = (long)attachment.getSize();
                    }
                    attachmentOrg = attachment;
                }
                logger.debug("....trying to download attachment  name..." + fileInfoFileName);
                response.addHeader("Pragma", "public");
                response.addHeader("Expires", String.valueOf(200));
                response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                String encodedFilename = fileInfoFileName;
                try {
                    encodedFilename = URLEncoder.encode(fileInfoFileName, UTF8).replace("+", "%20");
                    if (browserType.contains("Firefox")) {
                        response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFilename);
                    } else if (browserType.contains("Chrome")) {
                        response.setHeader("Content-Disposition", "attachment; filename=" + encodedFilename);
                    } else {
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileInfoFileName + "\"");
                    }
                    response.addHeader("Content-Transfer-Encoding", "binary");
                    response.addHeader("filename", fileInfoFileName);
                    response.addHeader("Content-Transfer-Encodingsdasda", "binary");
                    response.setContentType("application/octet-stream");
                    boolean fileExists = true;
                    fileExists = this.syncDownloadService.downloadMailFromPG(cloud, cloudName, userName, backupFile, response, fileExists, isSync, downloadFileTO.getAttachName(), fileInfo);
                }
                catch (UnsupportedEncodingException e) {
                    logger.trace("" + e);
                    logger.error("" + e.getMessage());
                }
            } else {
                this.syncDownloadService.downloadFileFromPGForPortal(cloud, response, fileInfo, browserType, downloadFileTO.getAttachmentId(), userName, backupFile);
            }
        }
        if (backupFile != null && backupFile.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), backupFile.getFileName(), rwlist))) {
            logger.debug("md5/file name is same so skip the file...........");
            response.setStatus(451);
            return null;
        }
        if (fileInfo != null && fileInfo.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), fileInfo.getFileName(), rwlist))) {
            logger.debug("md5/file name is same so skip the file...........");
            response.setStatus(451);
            return null;
        }
        if (backupFile != null && !StringUtils.isEmpty((String)backupFile.getFileName()) && !StringUtils.isEmpty((String)backupFile.getFilePath())) {
            downloadTO.setFilePath(backupFile.getFilePath());
            downloadTO.setFileName(backupFile.getFileName());
        }
        if (fileInfo != null) {
            downloadTO.setSize(fileInfo.getSize().longValue());
            downloadTO.setFilePath(fileInfo.getFilePath());
            downloadTO.setFileName(fileInfo.getFileName());
            return downloadTO;
        }
        if (backupFile == null) {
            logger.debug(FILE_NOT_FOUND + downloadFileTO.getBackupID());
            throw new ParacloudBackupException(FILE_NOT_FOUND, 507);
        }
        if (backupFile.getSizeInBytes() != null && backupFile.getSizeInBytes() != 0L) {
            downloadTO.setSize(backupFile.getSizeInBytes().longValue());
        } else {
            downloadTO.setSize(backupFile.getSize().longValue());
        }
        this.downloadFromCloudForPortal(backupFile, downloadFileTO, response, cloud, browserType, device, downloadTO);
        return downloadTO;
    }

    @Override
    public byte[] downloadContactsPhotoForPortal(DownloadFileTO downloadFileTO, Cloud cloud, String cloudName, String browserType) {
        Object fileInfo = null;
        com.pg.domain.BackupFile backupFile = null;
        String userName = downloadFileTO.getUserName();
        DownloadTO downloadTO = new DownloadTO("");
        boolean isSync = false;
        int cloudId = cloud.getCloudId();
        String deviceUUID = this.backupFileDao.getDeviceUUIDForId(cloudId, cloudName, userName, downloadFileTO.getBackupID());
        logger.debug(downloadFileTO.getBackupID() + " backup id @@@@@ device uuid .... " + deviceUUID);
        if (deviceUUID != null) {
            downloadFileTO.setDeviceUUID(deviceUUID);
        }
        Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
        if (!StringUtils.isEmpty((String)downloadFileTO.getBackupID())) {
            backupFile = this.backupFileDao.getBackupFilesForId(cloudId, cloudName, userName, device, downloadFileTO.getBackupID(), true);
        }
        if (backupFile == null) {
            logger.debug(FILE_NOT_FOUND + downloadFileTO.getBackupID());
            throw new ParacloudBackupException(FILE_NOT_FOUND, 507);
        }
        if (backupFile.getSizeInBytes() != null && backupFile.getSizeInBytes() != 0L) {
            downloadTO.setSize(backupFile.getSizeInBytes().longValue());
        } else {
            downloadTO.setSize(backupFile.getSize().longValue());
        }
        return this.downloadFromCloudContactsPhotoForPortal(backupFile, downloadFileTO, cloud, browserType, device);
    }

    private void restoreMails(Cloud cloud, ExecutorService executor, CompletionService<String> pool, com.pg.domain.BackupFile backupFile, HttpServletResponse response1, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, String restoreFolderPath, AtomicInteger processedCount, GraphServiceClient<Request> graphClient, BackupBatch backupBatch, String restoreBatchId, AtomicInteger restoredFiles, AtomicInteger restoredSize, String pstBatchId, RestoreEvents restoreEvents) {
        boolean isTomcatRunning = true;
        if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
            isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
        }
        String userName = downloadFileTO.getUserName();
        int cloudId = cloud.getCloudId();
        int errorCode = this.getBatchErrorCode(cloud.getCloudId(), backupBatch.getId().toString());
        logger.debug(isTomcatRunning + ".....restore status...." + errorCode);
        if (errorCode == 1207) {
            logger.debug("delete all pstBatch..." + restoreBatchId);
            return;
        }
        if (errorCode > 0) {
            logger.debug("delete all pstBatch");
            errorCode = 1207;
            this.utilService.updateBackupBatch(cloudId, backupBatch.getId(), "ABORTED", errorCode);
            return;
        }
        logger.debug("...tring file..." + backupFile.getFileName());
        if (backupFile.isFileInPg()) {
            boolean isDownloaded;
            logger.debug("..FILEPG...." + backupFile.getFileName());
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            BackUpImage bkpImg = this.getBackupImageForId(cloudId, device, backupFile.getBackupId().toString());
            boolean noMd5 = false;
            if (StringUtils.isEmpty((String)bkpImg.getMd5Checksum())) {
                noMd5 = true;
            }
            if (!(isDownloaded = this.downloadMailFromPg(cloud, response1, downloadFileTO, restoreFolderPath, backupFile, true, noMd5))) {
                logger.debug("...not-downloaded....");
                if (bkpImg != null) {
                    logger.debug("....md5 file for user..." + bkpImg.getMd5Checksum());
                    BackUpImage backupImggg = this.backupFileDao.getBackupImageForMd5(cloudId, device, bkpImg.getMd5Checksum());
                    logger.debug("....md5-afterfile for user..." + backupImggg);
                    if (backupImggg != null) {
                        logger.debug("....oldimage....");
                        com.pg.domain.BackupFile backupFileObj = this.convertBkpImageToBackupFile(backupImggg);
                        backupFileObj.setId(backupFile.getBackupId().toString());
                        this.downloadMethod(cloud, downloadFileTO, deviceUUID, restoreFolderPath, tempdownloadDir, restoreFolderPath, userName, backupFileObj, graphClient, true);
                    } else {
                        logger.debug(noMd5 + "*****" + bkpImg.getFileName() + "...parentalso not exists...." + backupFile.getBackupId().toString());
                        this.downloadMailFromPgEmpty(bkpImg, cloud, response1, downloadFileTO, restoreFolderPath, backupFile, true, true);
                    }
                } else {
                    logger.debug("....no message bkpimg..." + bkpImg.getId().toString());
                }
            }
        } else {
            boolean isDownloaded = this.downloadMethod(cloud, downloadFileTO, deviceUUID, restoreFolderPath, tempdownloadDir, restoreFolderPath, userName, backupFile, graphClient, true);
            if (!isDownloaded) {
                logger.debug("..unabletodownload so try again..");
                isDownloaded = this.downloadMethod(cloud, downloadFileTO, deviceUUID, restoreFolderPath, tempdownloadDir, restoreFolderPath, userName, backupFile, graphClient, true);
            }
        }
        if (null == pstBatchId) {
            this.utilService.updateRestoreProgress(cloudId, restoredFiles.incrementAndGet(), restoredSize.addAndGet((int)backupFile.getSize().longValue()), 0L, backupFile.getFilePath(), deviceUUID, backupFile.getFileName(), restoreEvents.getActionBy());
        } else {
            this.utilService.updateRestoreProgress(cloudId, restoredFiles.incrementAndGet(), restoredSize.addAndGet((int)backupFile.getSize().longValue()), 0L, backupFile.getFilePath(), pstBatchId, backupFile.getFileName(), restoreEvents.getActionBy());
        }
        this.utilService.removeBackupFileFromBatch(cloud.getCloudId(), backupFile.getId(), backupFile.getBatchId());
        this.updateBackupBatch(backupBatch, cloud, 1, backupFile.getSize());
        if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
            isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
        }
        if (errorCode > 0) {
            errorCode = 1207;
            this.utilService.updateBackupBatch(cloudId, backupBatch.getId(), "ABORTED", errorCode);
            return;
        }
        processedCount.incrementAndGet();
        logger.debug(processedCount + "....thread and file...." + Thread.currentThread().getName() + "..." + backupFile.getFileName());
    }

    private boolean downloadMailFromPgEmpty(BackUpImage backUpImage, Cloud cloud, HttpServletResponse response1, DownloadFileTO downloadFileTO, String restoreFolderPath, com.pg.domain.BackupFile backupFilePg, boolean isMail, boolean noMd5) {
        boolean fileDownloaded = false;
        FileInfo fileInfo = this.fileDao.getFileFromPG(downloadFileTO.getUserName(), cloud.getCloudName(), backupFilePg.getId(), false);
        logger.debug(".....fileinfo informaempty...." + fileInfo);
        if (fileInfo != null && (!CollectionUtils.isEmpty((Collection)fileInfo.getChunkFiles()) || noMd5)) {
            fileInfo.setFilePath(backupFilePg.getFilePath());
            String filePath = fileInfo.getFilePath();
            filePath = filePath.replace("\\", "/");
            fileInfo.setFilePath(filePath);
            fileDownloaded = this.downloadZipFileFromPGForPortal(cloud.getCloudName(), response1, fileInfo, downloadFileTO, restoreFolderPath, isMail);
        }
        if (fileInfo == null) {
            fileInfo = new FileInfo();
            fileInfo.setSubject(backUpImage.getSubject());
            fileInfo.setFilePath(backUpImage.getDevicePath());
            fileInfo.setDeviceUUID(backUpImage.getDeviceUUID());
            fileInfo.setFileName(backUpImage.getFileName());
            fileInfo.setId(backUpImage.getId().toString());
            fileInfo.setBatchId(backUpImage.getDeviceUUID());
            fileInfo.setSentDate(backUpImage.getSentDate());
            fileInfo.setFrom(backUpImage.getFrom());
            fileInfo.setFromAddr(backUpImage.getFromAddr());
            fileInfo.setFromEmailAddress(backUpImage.getFromEmailAddress());
            fileInfo.setCcRecipients(backUpImage.getCcRecipients());
            fileInfo.setCcRecipientsAddr(backUpImage.getCcRecipientsAddr());
            fileInfo.setCcRecipientsAddress(backUpImage.getCcRecipientsAddress());
            fileInfo.setBccRecipients(backUpImage.getBccRecipients());
            fileInfo.setBccRecipientsAddr(backUpImage.getBccRecipientsAddr());
            fileInfo.setBccRecipientsAddress(backUpImage.getBccRecipientsAddress());
            fileInfo.setToRecipients(backUpImage.getToRecipients());
            fileInfo.setToRecipientsAddr(backUpImage.getToRecipientsAddr());
            fileInfo.setToRecipientsAddress(backUpImage.getToRecipientsAddress());
            fileDownloaded = this.downloadZipFileFromPGForPortalEmptyChunks(cloud.getCloudName(), response1, fileInfo, downloadFileTO, restoreFolderPath, isMail);
        }
        return fileDownloaded;
    }

    private boolean downloadZipFileFromPGForPortalEmptyChunks(String cloudName, HttpServletResponse response1, FileInfo fileInfo, DownloadFileTO downloadFileTO, String restoreFolderPath, boolean isMail) {
        boolean fileDownloaded = false;
        String folderPath = "";
        String replaceValue = "";
        if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
            folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        } else {
            folderPath = ":";
            replaceValue = "_DRIVE";
        }
        logger.debug(".....file");
        String backupFileName = fileInfo.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String fileName = backupFileName.replaceAll(folderPath, replaceValue);
        if (StringUtils.isEmpty((String)fileName)) {
            fileName = "NO_SUBJECT";
        }
        String tempPath = fileInfo.getFilePath().replace(":", "_DRIVE");
        logger.debug("....fileName..." + fileName);
        fileName = fileName.replaceAll("//", "\\");
        logger.debug(restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath + "....fileName after replace..." + fileName);
        File tempFile = new File(restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath);
        if (!tempFile.exists()) {
            try {
                tempFile.mkdirs();
            }
            catch (Exception e1) {
                logger.trace("" + e1);
                logger.error("EXCPTION" + e1.getMessage());
            }
        }
        fileName = MD5Generator.generateMD5OfString((String)fileName);
        String fileCompletePath = restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFileName();
        if (isMail) {
            fileCompletePath = restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getId() + "_" + System.currentTimeMillis() + ".eml";
        }
        logger.debug(tempPath + "....fileCompletePath.." + fileCompletePath);
        logger.debug(" file is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
        List list = fileInfo.getChunkFiles();
        Collections.sort(list);
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
            deviceTempPath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getBatchId();
        }
        try {
            MimeMessage mimeMessage = DownloadServiceImpl.convertToMimeMessage(fileInfo);
            logger.debug("....file path for dd downloading..." + fileCompletePath);
            File msgFile = new File(fileCompletePath);
            mimeMessage.writeTo((OutputStream)new FileOutputStream(msgFile));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("....execption......" + e);
        }
        fileDownloaded = true;
        return fileDownloaded;
    }

    public synchronized void updateBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, Long size) {
        logger.debug("calling backup Batch ..." + backupBatchOdb.getNoOfFiles());
        try {
            int cloudId = cloud.getCloudId();
            logger.debug(" ************ ");
            this.utilService.updateBackupBatch(cloudId, backupBatchOdb.getId().toString(), uploadedFiles, size);
            this.utilService.updateUplodedFilesInBackupOverView(cloudId, backupBatchOdb.getDeviceUUID(), uploadedFiles, size, backupBatchOdb.getTotalSizeToUpload());
            logger.debug("[backupBatch][" + backupBatchOdb.getUserName() + "][" + backupBatchOdb.getDeviceUUID() + "][" + backupBatchOdb.getId() + "][" + backupBatchOdb.getStatus() + "][" + backupBatchOdb.getBatchStartTimestamp() + "][" + backupBatchOdb.getBatchEndTimestamp() + "]");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling backup Batch ...");
    }

    public void checkThreadStatusAndStartUploadForUser(Cloud cloud, ExecutorService executor, final CompletionService<String> pool) {
        if (this.userRestoreTimer == null) {
            this.userRestoreTimer = new Timer();
        }
        if (this.userRestoreTimerTask == null) {
            this.userRestoreTimerTask = new TimerTask(){

                @Override
                public void run() {
                    logger.debug("Check the task is completed>>>>>>>>");
                    try {
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("download is done so wait for the next one >>>>>>>>>>>");
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            if (this.userRestoreTimer != null && this.userRestoreTimerTask != null) {
                this.userRestoreTimer.schedule(this.userRestoreTimerTask, 1000L, 1000L);
            }
        }
    }

    private void restoreMails(Cloud cloud, ExecutorService executor, CompletionService<String> pool, com.pg.domain.BackupFile backupFile, HttpServletResponse response1, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, String restoreFolderPath, AtomicInteger processedCount, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient, BackupBatch backupBatch, String restoreBatchId) {
        boolean isTomcatRunning = true;
        if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
            isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
        }
        String userName = downloadFileTO.getUserName();
        int cloudId = cloud.getCloudId();
        int errorCode = this.getBatchErrorCode(cloud.getCloudId(), backupBatch.getId().toString());
        logger.debug(isTomcatRunning + ".....restore status...." + errorCode);
        if (errorCode == 1207) {
            logger.debug("delete all pstBatch..." + restoreBatchId);
            this.utilService.deletePSTBatch(cloudId, restoreBatchId);
            return;
        }
        if (!isTomcatRunning || errorCode > 0) {
            logger.debug("delete all pstBatch");
            this.utilService.deletePSTBatch(cloudId, restoreBatchId);
            errorCode = 1207;
            this.utilService.updateBackupBatch(cloudId, backupBatch.getId(), "ABORTED", errorCode);
            return;
        }
        logger.debug(backupFile.getMd5() + "...tring file..." + backupFile.getFileName());
        if (backupFile.isFileInPg()) {
            boolean isDownloaded;
            logger.debug("..FILEPG...." + backupFile.getFileName());
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            BackUpImage bkpImg = this.getBackupImageForId(cloudId, device, backupFile.getBackupId().toString());
            boolean noMd5 = false;
            if (StringUtils.isEmpty((String)bkpImg.getMd5Checksum())) {
                noMd5 = true;
            }
            if (!(isDownloaded = this.downloadMailFromPg(cloud, response1, downloadFileTO, restoreFolderPath, backupFile, true, noMd5))) {
                logger.debug("...not-downloaded....");
                if (bkpImg != null) {
                    logger.debug("....md5 file for user..." + bkpImg.getMd5Checksum());
                    BackUpImage backupImggg = this.backupFileDao.getBackupImageForMd5(cloudId, device, bkpImg.getMd5Checksum());
                    logger.debug("....md5-afterfile for user..." + backupImggg);
                    if (backupImggg != null) {
                        logger.debug("....oldimage....");
                        com.pg.domain.BackupFile backupFileObj = this.convertBkpImageToBackupFile(backupImggg);
                        backupFileObj.setId(backupFile.getBackupId().toString());
                        this.downloadMethod(cloud, downloadFileTO, deviceUUID, restoreFolderPath, tempdownloadDir, restoreFolderPath, userName, backupFileObj, graphClient, okHttpClient, true);
                    } else {
                        logger.debug(noMd5 + "*****" + bkpImg.getFileName() + "...parentalso not exists...." + backupFile.getBackupId().toString());
                        this.downloadMailFromPgEmpty(bkpImg, cloud, response1, downloadFileTO, restoreFolderPath, backupFile, true, true);
                    }
                } else {
                    logger.debug("....no message bkpimg..." + bkpImg.getId().toString());
                }
            }
        } else {
            logger.debug("..FILECLOUD...." + backupFile.getFileName());
            boolean isDownloaded = this.downloadMethod(cloud, downloadFileTO, deviceUUID, restoreFolderPath, tempdownloadDir, restoreFolderPath, userName, backupFile, graphClient, okHttpClient, true);
            if (!isDownloaded) {
                logger.debug("..unabletodownload so try again..");
                isDownloaded = this.downloadMethod(cloud, downloadFileTO, deviceUUID, restoreFolderPath, tempdownloadDir, restoreFolderPath, userName, backupFile, graphClient, okHttpClient, true);
            }
        }
        this.utilService.removeBackupFileFromBatch(cloud.getCloudId(), backupFile.getId(), backupFile.getBatchId());
        this.updateBackupBatch(backupBatch, cloud, 1, backupFile.getSize());
        if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
            isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
        }
        if (!isTomcatRunning || errorCode > 0) {
            logger.debug("delete all pstBatch");
            errorCode = 1207;
            this.utilService.updateBackupBatch(cloudId, backupBatch.getId(), "ABORTED", errorCode);
            this.utilService.deletePSTBatch(cloudId, restoreBatchId);
            return;
        }
        processedCount.incrementAndGet();
        logger.debug(processedCount + "....thread and file...." + Thread.currentThread().getName() + "..." + backupFile.getFileName());
    }

    private boolean downloadMethod(Cloud cloud, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, String restoreFolderPath, String userName, com.pg.domain.BackupFile backupFile, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient, boolean isMail) {
        boolean fileDownload = false;
        if (StringUtils.isEmpty((String)userName)) {
            logger.debug("...emptry username so assign diffe from file...." + backupFile.getUserName());
            userName = backupFile.getUserName();
        }
        String folderPath = "";
        String replaceValue = "";
        if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
            folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        } else {
            folderPath = ":";
            replaceValue = "_DRIVE";
        }
        String fileNameMeta = backupFile.getFileName();
        if (StringUtils.isEmpty((String)fileNameMeta)) {
            fileNameMeta = "NO_SUBJECT";
        }
        fileNameMeta = fileNameMeta.replaceAll("/", "_");
        logger.debug(fileNameMeta + "....filess before233....");
        String backupFileName = backupFile.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileNameMeta;
        String fileName = backupFileName.replaceAll(folderPath, replaceValue);
        String tempPath = backupFile.getFilePath().replace(":", "_DRIVE");
        logger.debug(backupFile.getUserName() + "....fileName..." + fileName);
        if (!StringUtils.isEmpty((String)backupFile.getUserName()) && !userName.equalsIgnoreCase(backupFile.getUserName())) {
            userName = backupFile.getUserName();
        }
        logger.debug("...after usernames..." + backupFile.getUserName() + "..." + userName);
        try {
            fileName = fileName.replaceAll("//", "\\");
        }
        catch (Exception e4) {
            logger.error(".....replace..." + fileName);
        }
        logger.debug(tempPath + "....fileName after replace..." + fileName);
        String fileCompletePath = restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath;
        File tempFile = new File(fileCompletePath);
        if (tempFile != null && tempFile.exists() && tempFile.list() != null) {
            logger.debug(tempFile.getName() + "...beforesaving folder ..." + tempFile.list().length);
        }
        logger.debug(tempPath + "....fileCompletePath.." + fileCompletePath);
        File file = new File(fileCompletePath);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception e1) {
                logger.trace("" + e1);
                logger.error("EXCPTION" + e1.getMessage());
            }
        }
        fileNameMeta = MD5Generator.generateMD5OfString((String)fileNameMeta);
        fileCompletePath = fileCompletePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileNameMeta;
        if (isMail) {
            fileCompletePath = fileCompletePath + "_" + backupFile.getId() + ".eml";
        }
        logger.debug(".#############...fileCompletePath.." + fileCompletePath);
        List chunkFilesList = backupFile.getChunkFiles();
        int totalChunks = chunkFilesList.size();
        Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

            @Override
            public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
            }
        });
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        if (new File(fileCompletePath).exists()) {
            logger.debug(".....alreadylocal file exists...." + fileCompletePath);
        } else {
            logger.debug(".....file-does-not-exists...." + fileCompletePath);
        }
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileCompletePath));){
            for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
                BufferedInputStream inputStream;
                ChunkDetail chunkDetail;
                block47: {
                    logger.debug("chunk file-------" + chunkFile.toString());
                    String syncDecryptKey = SYNC_DECRYPT_KEY;
                    String productType = "sync";
                    String dedupVal = this.getDedupValue(userName);
                    logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + chunkFile.getMd5());
                    chunkDetail = null;
                    List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                    if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                    }
                    if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                        for (ChunkDetail detailFromDB : chunkDetailList) {
                            if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                            chunkDetail = detailFromDB;
                        }
                    }
                    if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                        graphClient = OneDriveUtil.getGraphClient();
                        okHttpClient = Graph.getInstance().getOkHttpClient();
                    }
                    inputStream = null;
                    try {
                        chunkDetail = this.getChunkDetailElement(userName, chunkFile, chunkDetail);
                        inputStream = this.getInputStream(cloud, tempdownloadDir, userName, backupFile, graphClient, okHttpClient, chunkFilesList, chunkFile, chunkDetail);
                        if (inputStream != null) break block47;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.trace("" + e);
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e1) {
                            logger.trace("" + e1);
                            logger.error("EXCPTION" + e1.getMessage());
                        }
                        logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH, (Throwable)e);
                        throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                    }
                }
                String saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkDetail.getChunkCreatedTime(), BACKUP);
                String chunkFileNameVal = chunkFile.getFileName();
                chunkFileNameVal = chunkFileNameVal + backupFile.getId() + System.currentTimeMillis();
                File decryptedFile = this.getDecryptedFileForPortal(cloud.getCloudName(), saltKeyTemp, deviceUUID, chunkFileNameVal, inputStream, chunkDetail.getUserName(), path, chunkFile, cloud.getCloudId(), chunkDetail);
                try {
                    int buff;
                    FileInputStream copyFileInput = new FileInputStream(decryptedFile.getAbsolutePath());
                    FilterInputStream fif = new BufferedInputStream(copyFileInput);
                    logger.debug(IS_COMPRESSED + backupFile.isCompressed());
                    if (backupFile.isCompressed()) {
                        fif = new GZIPInputStream(copyFileInput);
                    }
                    byte[] b = new byte[4096];
                    while ((buff = ((InputStream)fif).read(b)) != -1) {
                        bos.write(b, 0, buff);
                    }
                    ((InputStream)fif).close();
                    decryptedFile.delete();
                }
                catch (IOException e) {
                    logger.error("Exceptiondecrypt new retry" + e.getMessage());
                }
                logger.debug(" remaining chunks ......" + --totalChunks);
                logger.debug("....Download Done for " + fileNameMeta + "...");
                fileDownload = true;
            }
        }
        catch (FileNotFoundException e2) {
            logger.error("EXCPTION", (Throwable)e2);
            fileDownload = false;
        }
        catch (IOException e3) {
            logger.error("EXCPTION", (Throwable)e3);
            fileDownload = false;
        }
        catch (Exception e) {
            logger.error("EXCPTION", (Throwable)e);
            fileDownload = false;
        }
        logger.debug(backupFile.getFileName() + "...file-downloadstatus...." + fileDownload);
        try {
            if (!fileDownload) {
                logger.debug("...file failed....");
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return fileDownload;
    }

    private BufferedInputStream getInputStream(Cloud cloud, File tempdownloadDir, String userName, com.pg.domain.BackupFile backupFile, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient, List<com.pg.domain.ChunkFile> chunkFilesList, com.pg.domain.ChunkFile chunkFile, ChunkDetail chunkDetail) {
        String syncDecryptKey = "";
        String productType = "";
        logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
        String backupId = backupFile.getId();
        String containerName = null;
        containerName = chunkDetail.getContainerName();
        StringBuilder fileNameToDownload = new StringBuilder();
        fileNameToDownload.append(chunkDetail.getCloudChunkName());
        int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
        if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
            fileNameToDownload.append(".").append(backupId);
        }
        if (chunkDetail != null) {
            containerName = chunkDetail.getContainerName();
            if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
            }
        }
        if (!StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !"ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
            productType = BACKUP;
            syncDecryptKey = chunkDetail.getContainerName();
        }
        com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
        BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
        boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
        String fileToDownload = fileNameToDownload.toString();
        if (isGDEnabled) {
            fileToDownload = chunkDetail.getCloudChunkName();
            logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
        }
        logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
        FileStatusElement fileStatusElement = new FileStatusElement();
        BufferedInputStream inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, false, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient);
        return inputStream;
    }

    private void restoreMailsForPst(Cloud cloud, HttpServletResponse response1, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, String restoreBatchId, String restoreFolderPath, BackupBatch backupBatch) {
        logger.debug(restoreBatchId + "..total fileslist...");
        logger.debug(".....restorpath..." + restoreFolderPath);
        List<com.pg.domain.BackupFile> backupFiles = this.utilService.getFilesForMailBatchId(cloud.getCloudId(), restoreBatchId);
        int officeThreads = 1;
        ExecutorService executor = Executors.newFixedThreadPool(officeThreads);
        AtomicInteger processedCount = new AtomicInteger();
        ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
        GraphServiceClient<Request> graphClient = null;
        OkHttpClient okHttpClient = null;
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        do {
            List<Object> threadList = new ArrayList();
            threadList = !CollectionUtils.isEmpty(backupFiles) && backupFiles.size() > officeThreads ? backupFiles.subList(0, officeThreads) : backupFiles;
            for (com.pg.domain.BackupFile backupFile : backupFiles) {
                this.restoreMails(cloud, executor, pool, backupFile, response1, downloadFileTO, deviceUUID, path, tempdownloadDir, restoreFolderPath, processedCount, graphClient, okHttpClient, backupBatch, restoreBatchId);
            }
            backupFiles = this.utilService.getFilesForMailBatchId(cloud.getCloudId(), restoreBatchId);
            logger.debug("trynext list...." + backupFiles.size());
        } while (!CollectionUtils.isEmpty(backupFiles));
    }

    private void restoreUserData(Cloud cloud, ExecutorService executor, CompletionService<String> pool, HttpServletResponse response1, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, String restoreFolderPath, AtomicInteger processedCount, GraphServiceClient<Request> graphClient, String restoreBatchId, BackupBatch backupBatch, AtomicInteger restoredFiles, AtomicInteger restoredSize, String pstBatchId, RestoreEvents restoreEvents) {
        List<com.pg.domain.BackupFile> backupFiles = this.utilService.getFilesForMailBatchId(cloud.getCloudId(), restoreBatchId);
        if (!CollectionUtils.isEmpty(backupFiles)) {
            logger.debug("....iteratorsize...." + backupFiles.size());
            ListIterator<com.pg.domain.BackupFile> listIterator = backupFiles.listIterator();
            do {
                com.pg.domain.BackupFile myFile;
                com.pg.domain.BackupFile backupFile = myFile = listIterator.next();
                logger.debug(listIterator.hasNext() + ".....file to process...." + backupFile.getFileName());
                Runnable uploadJob = () -> {
                    if (null != restoreEvents && this.utilService.getRestoreEvents(cloud.getCloudId(), restoreEvents.getActionOnDeviceUUID()) != null) {
                        this.restoreMails(cloud, executor, pool, backupFile, response1, downloadFileTO, deviceUUID, path, tempdownloadDir, restoreFolderPath, processedCount, graphClient, backupBatch, restoreBatchId, restoredFiles, restoredSize, pstBatchId, restoreEvents);
                    } else {
                        logger.debug("Cancelling and deleting the download as pst");
                        int errorCode = 1207;
                        this.utilService.updateBackupBatch(cloud.getCloudId(), backupBatch.getId(), "ABORTED", errorCode);
                        this.utilService.removeBackupFileFromBatch(cloud.getCloudId(), null, backupFile.getBatchId());
                    }
                };
                pool.submit(uploadJob, "");
                if (listIterator.hasNext()) continue;
                this.sleep10Sec();
                logger.debug("....iterator-val... empty so reassign....");
                backupFiles = this.utilService.getFilesForMailBatchId(cloud.getCloudId(), restoreBatchId);
                if (CollectionUtils.isEmpty(backupFiles)) continue;
                listIterator = null;
                backupFiles = this.utilService.getFilesForMailBatchId(cloud.getCloudId(), restoreBatchId);
                listIterator = backupFiles.listIterator();
                logger.debug("...added next set of files...." + backupFiles.size());
            } while (listIterator.hasNext());
            logger.debug("....restore completed...." + processedCount);
            executor.shutdown();
        } else {
            executor.shutdown();
            logger.debug(".....shutdown....");
        }
    }

    private void sleep10Sec() {
        try {
            logger.debug("....wait for 10 sec...");
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void restoreMailsForPst(Cloud cloud, HttpServletResponse response1, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, String restoreBatchId, String restoreFolderPath, BackupBatch backupBatch, AtomicInteger restoredFiles, AtomicInteger restoredSize, String pstBatchId, RestoreEvents restoreEvents) {
        logger.debug(restoreBatchId + "..total fileslist...");
        logger.debug(".....restorpath..." + restoreFolderPath);
        List<com.pg.domain.BackupFile> backupFiles = this.utilService.getFilesForMailBatchId(cloud.getCloudId(), restoreBatchId);
        int officeThreads = 1;
        ExecutorService executor = Executors.newFixedThreadPool(officeThreads);
        AtomicInteger processedCount = new AtomicInteger();
        ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
        GraphServiceClient<Request> graphClient = null;
        OkHttpClient okHttpClient = null;
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        do {
            List<Object> threadList = new ArrayList();
            threadList = !CollectionUtils.isEmpty(backupFiles) && backupFiles.size() > officeThreads ? backupFiles.subList(0, officeThreads) : backupFiles;
            for (com.pg.domain.BackupFile backupFile : backupFiles) {
                this.restoreMails(cloud, executor, pool, backupFile, response1, downloadFileTO, deviceUUID, path, tempdownloadDir, restoreFolderPath, processedCount, graphClient, okHttpClient, backupBatch, restoreBatchId);
            }
            backupFiles = this.utilService.getFilesForMailBatchId(cloud.getCloudId(), restoreBatchId);
            logger.debug("trynext list...." + backupFiles.size());
        } while (!CollectionUtils.isEmpty(backupFiles));
    }

    private boolean downloadMethod(Cloud cloud, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, String restoreFolderPath, String userName, com.pg.domain.BackupFile backupFile, GraphServiceClient<Request> graphClient, boolean isMail) {
        boolean fileDownload = false;
        if (StringUtils.isEmpty((String)userName)) {
            logger.debug("...emptry username so assign diffe from file...." + backupFile.getUserName());
            userName = backupFile.getUserName();
        }
        String folderPath = "";
        String replaceValue = "";
        if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
            folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        } else {
            folderPath = ":";
            replaceValue = "_DRIVE";
        }
        String fileNameMeta = backupFile.getFileName();
        if (StringUtils.isEmpty((String)fileNameMeta)) {
            fileNameMeta = "NO_SUBJECT";
        }
        fileNameMeta = fileNameMeta.replaceAll("/", "_");
        logger.debug(fileNameMeta + "....filess before233....");
        String backupFileName = backupFile.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileNameMeta;
        String fileName = backupFileName.replaceAll(folderPath, replaceValue);
        String tempPath = backupFile.getFilePath().replace(":", "_DRIVE");
        logger.debug(backupFile.getUserName() + "....fileName..." + fileName);
        if (!StringUtils.isEmpty((String)backupFile.getUserName()) && !userName.equalsIgnoreCase(backupFile.getUserName())) {
            userName = backupFile.getUserName();
        }
        logger.debug("...after usernames..." + backupFile.getUserName() + "..." + userName);
        try {
            fileName = fileName.replaceAll("//", "\\");
        }
        catch (Exception e4) {
            logger.error(".....replace..." + fileName);
        }
        logger.debug(tempPath + "....fileName after replace..." + fileName);
        String fileCompletePath = restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath;
        logger.debug(tempPath + "....fileCompletePath.." + fileCompletePath);
        File file = new File(fileCompletePath);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception e1) {
                logger.trace("" + e1);
                logger.error("EXCPTION" + e1.getMessage());
            }
        }
        fileCompletePath = fileCompletePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileNameMeta;
        if (isMail) {
            fileCompletePath = fileCompletePath + "_" + backupFile.getId() + ".eml";
        }
        logger.debug(".#############...fileCompletePath.." + fileCompletePath);
        List chunkFilesList = backupFile.getChunkFiles();
        int totalChunks = chunkFilesList.size();
        Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

            @Override
            public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
            }
        });
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileCompletePath));){
            for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
                BufferedInputStream inputStream;
                ChunkDetail chunkDetail;
                block41: {
                    logger.debug("chunk file-------" + chunkFile.toString());
                    String dedupVal = this.getDedupValue(userName);
                    logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + chunkFile.getMd5());
                    chunkDetail = null;
                    List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                    if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                    }
                    if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                        for (ChunkDetail detailFromDB : chunkDetailList) {
                            if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                            chunkDetail = detailFromDB;
                        }
                    }
                    if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
                        graphClient = Graph.getInstance().getGraphClient();
                    }
                    inputStream = null;
                    try {
                        chunkDetail = this.getChunkDetailElement(userName, chunkFile, chunkDetail);
                        inputStream = this.getInputStream(cloud, tempdownloadDir, userName, backupFile, graphClient, chunkFilesList, chunkFile, chunkDetail);
                        if (inputStream != null) break block41;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.trace("" + e);
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e1) {
                            logger.trace("" + e1);
                            logger.error("EXCPTION" + e1.getMessage());
                        }
                        logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH, (Throwable)e);
                        throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                    }
                }
                String saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkDetail.getChunkCreatedTime(), BACKUP);
                String chunkFileNameVal = chunkFile.getFileName();
                chunkFileNameVal = chunkFileNameVal + backupFile.getId() + System.currentTimeMillis();
                File decryptedFile = this.getDecryptedFileForPortal(cloud.getCloudName(), saltKeyTemp, deviceUUID, chunkFileNameVal, inputStream, chunkDetail.getUserName(), path, chunkFile, cloud.getCloudId(), chunkDetail);
                try {
                    int buff;
                    FileInputStream copyFileInput = new FileInputStream(decryptedFile.getAbsolutePath());
                    FilterInputStream fif = new BufferedInputStream(copyFileInput);
                    logger.debug(IS_COMPRESSED + backupFile.isCompressed());
                    if (backupFile.isCompressed()) {
                        fif = new GZIPInputStream(copyFileInput);
                    }
                    byte[] b = new byte[4096];
                    while ((buff = ((InputStream)fif).read(b)) != -1) {
                        bos.write(b, 0, buff);
                    }
                    ((InputStream)fif).close();
                    decryptedFile.delete();
                }
                catch (IOException e) {
                    logger.error("Exceptiondecrypt new retry" + e.getMessage());
                }
                logger.debug(" remaining chunks ......" + --totalChunks);
                logger.debug("....Download Done for " + fileNameMeta + "...");
                fileDownload = true;
            }
        }
        catch (FileNotFoundException e2) {
            logger.error("EXCPTION", (Throwable)e2);
            fileDownload = false;
        }
        catch (IOException e3) {
            logger.error("EXCPTION", (Throwable)e3);
            fileDownload = false;
        }
        catch (Exception e) {
            logger.error("EXCPTION", (Throwable)e);
            fileDownload = false;
        }
        return fileDownload;
    }

    private BufferedInputStream getInputStream(Cloud cloud, File tempdownloadDir, String userName, com.pg.domain.BackupFile backupFile, GraphServiceClient<Request> graphClient, List<com.pg.domain.ChunkFile> chunkFilesList, com.pg.domain.ChunkFile chunkFile, ChunkDetail chunkDetail) {
        logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
        String backupId = backupFile.getId();
        String containerName = null;
        containerName = chunkDetail.getContainerName();
        StringBuilder fileNameToDownload = new StringBuilder();
        fileNameToDownload.append(chunkDetail.getCloudChunkName());
        int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
        if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
            fileNameToDownload.append(".").append(backupId);
        }
        if (chunkDetail != null) {
            containerName = chunkDetail.getContainerName();
            if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
            }
        }
        com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
        BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
        boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
        String fileToDownload = fileNameToDownload.toString();
        if (isGDEnabled) {
            fileToDownload = chunkDetail.getCloudChunkName();
            logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
        }
        logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
        FileStatusElement fileStatusElement = new FileStatusElement();
        BufferedInputStream inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, false, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "", graphClient);
        return inputStream;
    }

    private ChunkDetail getChunkDetailElement(String userName, com.pg.domain.ChunkFile chunkFile, ChunkDetail chunkDetail) {
        if (chunkDetail == null) {
            logger.debug(CHUNK_DETAILS_NULL);
            chunkDetail = new ChunkDetail();
            chunkDetail.setCloudChunkName(chunkFile.getFileName());
            chunkDetail.setUserName(userName);
            chunkDetail.setContainerName(userName.toLowerCase());
            chunkDetail.setMd5(chunkFile.getMd5());
        }
        return chunkDetail;
    }

    private boolean downloadMailFromPg(Cloud cloud, HttpServletResponse response1, DownloadFileTO downloadFileTO, String restoreFolderPath, com.pg.domain.BackupFile backupFilePg, boolean isMail, boolean noMd5) {
        boolean fileDownloaded = false;
        FileInfo fileInfo = this.fileDao.getFileFromPG(downloadFileTO.getUserName(), cloud.getCloudName(), backupFilePg.getId(), false);
        logger.debug(".....fileinfo informa...." + fileInfo);
        if (fileInfo != null && (!CollectionUtils.isEmpty((Collection)fileInfo.getChunkFiles()) || noMd5)) {
            fileInfo.setFilePath(backupFilePg.getFilePath());
            String filePath = fileInfo.getFilePath();
            filePath = filePath.replace("\\", "/");
            fileInfo.setFilePath(filePath);
            fileDownloaded = this.downloadZipFileFromPGForPortal(cloud.getCloudName(), response1, fileInfo, downloadFileTO, restoreFolderPath, isMail);
        }
        return fileDownloaded;
    }

    @Override
    public DownloadTO restoreFolderForPortal(Cloud cloud, String cloudName, String userName, String fileName, String filePath, String saltKey, String deviceUUID, String syncRevisionId, String gatewayName, boolean b, HttpServletResponse response, String browserType) {
        DownloadTO downloadTO = new DownloadTO("");
        return null;
    }

    private void convertBackupImageToBackupFile(BackUpImage backupImage, com.pg.domain.BackupFile backupFileData) {
        BeanUtils.copyProperties((Object)backupImage, (Object)backupFileData);
        ArrayList<com.pg.domain.ChunkFile> chunkList = new ArrayList<com.pg.domain.ChunkFile>();
        for (ChunkFile chunkFile : backupImage.getChunkFiles()) {
            com.pg.domain.ChunkFile file = new com.pg.domain.ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)file);
            chunkList.add(file);
        }
        backupFileData.setChunkFiles(chunkList);
        backupFileData.setFilePath(backupImage.getDevicePath());
    }

    private boolean downloadZipFileFromPGForPortal(String cloudName, HttpServletResponse response1, FileInfo fileInfo, DownloadFileTO downloadFileTO, String restoreFolderPath, boolean isMail) {
        boolean fileDownloaded = false;
        String folderPath = "";
        String replaceValue = "";
        if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
            folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        } else {
            folderPath = ":";
            replaceValue = "_DRIVE";
        }
        logger.debug(".....file");
        String backupFileName = fileInfo.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String fileName = backupFileName.replaceAll(folderPath, replaceValue);
        if (StringUtils.isEmpty((String)fileName)) {
            fileName = "NO_SUBJECT";
        }
        String tempPath = fileInfo.getFilePath().replace(":", "_DRIVE");
        logger.debug("....fileName..." + fileName);
        fileName = fileName.replaceAll("//", "\\");
        logger.debug(restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath + "....fileName after replace..." + fileName);
        File tempFile = new File(restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath);
        if (!tempFile.exists()) {
            try {
                tempFile.mkdirs();
            }
            catch (Exception e1) {
                logger.trace("" + e1);
                logger.error("EXCPTION" + e1.getMessage());
            }
        }
        fileName = MD5Generator.generateMD5OfString((String)fileName);
        String fileCompletePath = restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFileName();
        if (isMail) {
            fileCompletePath = restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getId() + "_" + System.currentTimeMillis() + ".eml";
        }
        logger.debug(tempPath + "....fileCompletePath.." + fileCompletePath);
        logger.debug(" file is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
        List list = fileInfo.getChunkFiles();
        Collections.sort(list);
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
            deviceTempPath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getBatchId();
        }
        String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        if (!StringUtils.isEmpty((String)fileInfo.getSubject()) || !StringUtils.isEmpty((String)fileInfo.getFrom())) {
            fileCompletePath = fileCompletePath + ".eml";
        }
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileCompletePath));){
            for (String chunkName : list) {
                int endIndex;
                if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                    chunkName = chunkName.substring(0, endIndex);
                }
                logger.debug(FILE_FROM_PG + chunkName);
                String filePath = chunkFilePath + "/" + chunkName;
                File file = new File(filePath);
                if (file.exists()) {
                    long size = file.length();
                    logger.debug(size + " file from pg.size................." + filePath);
                    try {
                        int buff;
                        FileInputStream copyFileInput = new FileInputStream(file.getAbsolutePath());
                        FilterInputStream fif = new BufferedInputStream(copyFileInput);
                        if (fileInfo.isCompressed()) {
                            fif = new GZIPInputStream(copyFileInput);
                        }
                        byte[] b = new byte[4096];
                        while ((buff = ((InputStream)fif).read(b)) != -1) {
                            bos.write(b, 0, buff);
                        }
                        ((InputStream)fif).close();
                    }
                    catch (IOException e) {
                        logger.debug("....execption......" + e);
                    }
                    continue;
                }
                logger.error(" file does not exists........" + filePath);
                break;
            }
        }
        catch (Exception e1) {
            logger.error("Exception" + e1.getMessage(), (Throwable)e1);
            return fileDownloaded;
        }
        fileDownloaded = true;
        return fileDownloaded;
    }

    @Override
    public DownloadTO downloadBackupFolderForPortal(DownloadFileTO downloadFileTO, Cloud cloud, HttpServletResponse response, String browserType, boolean isrestoreDeletedFile) {
        String userName = downloadFileTO.getUserName();
        int cloudId = cloud.getCloudId();
        String deviceUUID = downloadFileTO.getDeviceUUID();
        logger.debug("..existing deviuuid..." + deviceUUID);
        if (StringUtils.isEmpty((String)deviceUUID) && !StringUtils.isEmpty((String)(deviceUUID = this.backupFileDao.getDeviceUUIDForId(cloudId, cloud.getCloudName(), userName, downloadFileTO.getBackupID())))) {
            downloadFileTO.setDeviceUUID(deviceUUID);
        }
        Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
        DownloadTO downloadTO = new DownloadTO("");
        List rwlist = this.fileDao.getRWSampleFilesList(cloud.getCloudId());
        return this.downloadZipFileFromCloudForPortal(downloadFileTO, response, cloud, browserType, downloadTO, device, isrestoreDeletedFile, rwlist);
    }

    private void restoreMailFromPG(String cloudName, HttpServletResponse response, FileInfo fileInfo, String restoreId) {
        if (fileInfo != null) {
            String fileInfoFileName = fileInfo.getFileName() + ".eml";
            Long filesize = fileInfo.getSize();
            String encodedFilename = fileInfoFileName;
            try {
                logger.debug(" file mail is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
                List list = fileInfo.getChunkFiles();
                Collections.sort(list);
                String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                    deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                }
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                logger.debug(" file mail s from pg.................." + encodedFilename);
                File tempdownloadDir = new File(chunkFilePath);
                if (!tempdownloadDir.exists()) {
                    tempdownloadDir.mkdirs();
                }
                String filePath = chunkFilePath + "/" + encodedFilename;
                try {
                    MimeMessage mimeMessage = DownloadServiceImpl.convertToMimeMessage(fileInfo);
                    logger.debug("....file path for dd downloading..." + filePath);
                    File msgFile = new File(filePath);
                    mimeMessage.writeTo((OutputStream)new FileOutputStream(msgFile));
                    if (msgFile.exists()) {
                        long size = msgFile.length();
                        logger.debug(size + " file from pg.size................." + filePath + "...msg file name." + fileInfoFileName);
                        FileInputStream input = new FileInputStream(msgFile);
                        this.writeDataToStream(response, filePath, fileInfo, fileInfoFileName, filePath, input, restoreId);
                    } else {
                        logger.error(" file does not exists........" + filePath);
                    }
                }
                catch (Exception e) {
                    logger.error(".. unable to download mail..." + e.getMessage());
                }
                logger.debug(" before returning.........");
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        }
    }

    private void restoreMailFromCloud(String cloudName, HttpServletResponse response, FileInfo fileInfo, String restoreId) {
        if (fileInfo != null) {
            String fileInfoFileName = fileInfo.getFileName() + ".eml";
            Long filesize = fileInfo.getSize();
            String encodedFilename = fileInfoFileName;
            try {
                logger.debug(" file mail is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
                List list = fileInfo.getChunkFiles();
                Collections.sort(list);
                String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                    deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                }
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                logger.debug(" file mail s from pg.................." + encodedFilename);
                File tempdownloadDir = new File(chunkFilePath);
                if (!tempdownloadDir.exists()) {
                    tempdownloadDir.mkdirs();
                }
                String filePath = chunkFilePath + "/" + encodedFilename;
                try {
                    MimeMessage mimeMessage = DownloadServiceImpl.convertToMimeMessage(fileInfo);
                    logger.debug("....file path for dd downloading..." + filePath);
                    File msgFile = new File(filePath);
                    mimeMessage.writeTo((OutputStream)new FileOutputStream(msgFile));
                    if (msgFile.exists()) {
                        long size = msgFile.length();
                        logger.debug(size + " file from pg.size................." + filePath + "...msg file name." + fileInfoFileName);
                        FileInputStream input = new FileInputStream(msgFile);
                        this.writeDataToStream(response, filePath, fileInfo, fileInfoFileName, filePath, input, restoreId);
                    } else {
                        logger.error(" file does not exists........" + filePath);
                    }
                }
                catch (Exception e) {
                    logger.error(".. unable to download mail..." + e.getMessage());
                }
                logger.debug(" before returning.........");
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        }
    }

    private static MimeMessage convertToMimeMessage(FileInfo fileInfo) throws Exception {
        Properties p = System.getProperties();
        Session session = Session.getInstance((Properties)p);
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setSubject(fileInfo.getSubject());
        mimeMessage.setSentDate(fileInfo.getSentDate());
        InternetAddress fromMailbox = new InternetAddress();
        if (fileInfo.getFromEmailAddress() != null) {
            fromMailbox.setAddress(fileInfo.getFromEmailAddress().getAddress());
            if (fileInfo.getFromEmailAddress() != null) {
                fromMailbox.setPersonal(fileInfo.getFromEmailAddress().getName());
            } else {
                fromMailbox.setPersonal(fileInfo.getFromEmailAddress().getName());
            }
        }
        mimeMessage.setFrom((Address)fromMailbox);
        fileInfo.getCcRecipientsAddress().forEach(ccrec -> {
            try {
                mimeMessage.setRecipient(Message.RecipientType.CC, (Address)new InternetAddress(ccrec.getAddress(), ccrec.getName()));
            }
            catch (Exception e) {
                logger.error(".... exception......" + e.getMessage());
            }
        });
        fileInfo.getBccRecipientsAddress().forEach(bccrec -> {
            try {
                mimeMessage.setRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bccrec.getAddress(), bccrec.getName()));
            }
            catch (Exception e) {
                logger.error(".... exception......" + e.getMessage());
            }
        });
        fileInfo.getToRecipientsAddress().forEach(torec -> {
            try {
                mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(torec.getAddress(), torec.getName()));
            }
            catch (Exception e) {
                logger.error(".... exception......" + e.getMessage());
            }
        });
        MimeMultipart rootMultipart = new MimeMultipart();
        MimeMultipart contentMultipart = new MimeMultipart();
        MimeBodyPart contentBodyPart = new MimeBodyPart();
        contentBodyPart.setContent((Multipart)contentMultipart);
        MimeBodyPart htmlBodyPart = new MimeBodyPart();
        htmlBodyPart.setContent((Object)fileInfo.getBodyContent(), "text/html; charset=utf-8");
        contentMultipart.addBodyPart((BodyPart)htmlBodyPart);
        rootMultipart.addBodyPart((BodyPart)contentBodyPart);
        mimeMessage.setContent((Multipart)rootMultipart);
        return mimeMessage;
    }

    @Override
    public com.pg.domain.BackupFile getBackupFileForId(int cloudId, String userName, String backupID) {
        com.pg.domain.BackupFile backupFile = null;
        if (!StringUtils.isEmpty((String)backupID)) {
            String deviceUUID = this.backupFileDao.getDeviceUUIDForId(cloudId, "", userName, backupID);
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            backupFile = this.backupFileDao.getBackupFilesForId(cloudId, "", userName, device, backupID, true);
        }
        return backupFile;
    }

    @Override
    public BackUpImage getBackupImageForId(int cloudId, Device device, String backupID) {
        return this.externalStorageBackupFileDao.getBackupImageForId(cloudId, backupID, device);
    }

    @Override
    public List<BackUpImage> getBackupFilesForBasePath(int cloudId, String cloudName, String userName, Device device, String devcePath) {
        return this.externalStorageBackupFileDao.getBackupFilesForBasePath(cloudId, cloudName, userName, device, devcePath, true);
    }

    @Override
    public List<BackUpImage> getBaseFoldersForDevice(int cloudId, Device device) {
        return this.backupFileDao.getBaseFoldersForDevice(cloudId, device);
    }

    @Override
    public FileInfo getFileFromPG(int cloudId, String userName, String backupId) {
        return this.fileDao.getFileFromPG(userName, "", backupId, false);
    }

    private void writeDataToStream(File file, HttpServletResponse response) throws IOException {
        try {
            int buff;
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream fif = new BufferedInputStream(fis);
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
                response.getOutputStream().flush();
            }
            ((InputStream)fif).close();
            logger.debug(FINISHED_FILE + file.getName());
            file.delete();
            logger.debug("deleting  file  under path ....." + file.getPath());
        }
        catch (Exception e) {
            logger.debug("Exception   " + e);
            logger.error("Exception   " + e.getMessage());
        }
    }

    @Override
    public List<RestoreBackUpImage> getBaseFoldersForDeviceLatest(int cloudId, Device device) {
        return this.backupFileDao.getBaseFoldersForDeviceLatest(cloudId, device);
    }

    @Override
    public List<RestoreBackUpImage> getBackupFilesForBasePathLatest(int cloudId, String cloudName, String userName, Device device, String devcePath) {
        return this.externalStorageBackupFileDao.getBackupFilesForBasePathLatest(cloudId, cloudName, userName, device, devcePath);
    }

    private List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        logger.debug("Inside grouping backup images....");
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        for (BackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (!filteredBackUpImage.isPresent()) continue;
            filteredBackUpImagesList.add(filteredBackUpImage);
        }
        return filteredBackUpImagesList;
    }

    @Override
    public DownloadTO downloadPstBackupFolderForPortal(DownloadFileTO downloadFileTO, Cloud cloud, HttpServletResponse response, String browserType, String pstBatchId, boolean isrestoreDeletedFile, String restoreBy) {
        String userName = downloadFileTO.getUserName();
        int cloudId = cloud.getCloudId();
        String deviceUUID = downloadFileTO.getDeviceUUID();
        logger.debug(pstBatchId + "..existing deviuuid..." + deviceUUID + "...restoreby..." + restoreBy);
        if (StringUtils.isEmpty((String)deviceUUID) && !StringUtils.isEmpty((String)downloadFileTO.getBackupID()) && !StringUtils.isEmpty((String)(deviceUUID = this.backupFileDao.getDeviceUUIDForId(cloudId, cloud.getCloudName(), userName, downloadFileTO.getBackupID())))) {
            downloadFileTO.setDeviceUUID(deviceUUID);
        }
        Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
        DownloadTO downloadTO = new DownloadTO("");
        return this.downloadPstFileFromCloudForPortal(downloadFileTO, response, cloud, browserType, downloadTO, device, pstBatchId, isrestoreDeletedFile, restoreBy);
    }

    DownloadTO downloadPstFileFromCloudForPortal(DownloadFileTO downloadFileTO, HttpServletResponse response, Cloud cloud, String browserType, DownloadTO downloadTO, Device device, String pstBatchId, boolean isrestoreDeletedFile, String restoreBy) {
        try {
            this.downloadPstFileFromCloudForPortal(cloud, response, downloadFileTO, downloadTO, device, pstBatchId, isrestoreDeletedFile, restoreBy);
        }
        catch (Exception e) {
            logger.error("Exception" + e.getMessage());
        }
        return downloadTO;
    }

    private long restoreBackupFolder(Cloud cloud, HttpServletResponse response, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, List<BackUpImage> backupImages, long folderSize, String restoreFolderPath, boolean isMail, List<String> rwlist) {
        ArrayList<com.pg.domain.BackupFile> backupFiles = new ArrayList<com.pg.domain.BackupFile>();
        ArrayList<com.pg.domain.BackupFile> backupFilesForPg = new ArrayList<com.pg.domain.BackupFile>();
        long zipFileSize = 0L;
        logger.debug("restoreBackupFolder Size..." + backupImages.size());
        for (BackUpImage backupImage : backupImages) {
            boolean isFileSame;
            if (backupImage != null && backupImage.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), backupImage.getFileName(), rwlist))) {
                logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            com.pg.domain.BackupFile backupFileData = new com.pg.domain.BackupFile();
            if (StringUtils.isNotEmpty((String)backupImage.getStoragePlace()) && backupImage.getStoragePlace().equalsIgnoreCase("CLOUD") && !CollectionUtils.isEmpty((Collection)backupImage.getChunkFiles())) {
                this.convertBackupImageToBackupFile(backupImage, backupFileData);
                backupFiles.add(backupFileData);
                zipFileSize += backupImage.getSize();
            } else {
                this.convertBackupImageToBackupFile(backupImage, backupFileData);
                backupFileData.setId(backupImage.getId().toString());
                backupFilesForPg.add(backupFileData);
                zipFileSize += backupImage.getSize();
            }
            if (backupImage.getSizeInBytes() != 0L) {
                folderSize += backupImage.getSizeInBytes();
                continue;
            }
            folderSize += backupImage.getSize();
        }
        zipFileSize += zipFileSize;
        logger.debug("total size required create zip " + zipFileSize);
        this.restoreBackupFolder(cloud, response, downloadFileTO, deviceUUID, path, tempdownloadDir, backupFiles, backupFilesForPg, restoreFolderPath, isMail, rwlist);
        return folderSize;
    }

    private void restoreBackupFolder(Cloud cloud, HttpServletResponse response1, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, List<com.pg.domain.BackupFile> backupFiles, List<com.pg.domain.BackupFile> backupFilesForPg, String restoreFolderPath, boolean isMail, List<String> rwlist) {
        String userName = downloadFileTO.getUserName();
        logger.debug(backupFiles.size() + "....backupFiles count ...." + backupFilesForPg.size());
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        GraphServiceClient<Request> graphClient = null;
        if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
            graphClient = Graph.getInstance().getGraphClient();
        }
        ListIterator<com.pg.domain.BackupFile> listIterator = backupFilesForPg.listIterator();
        int pgsize = backupFilesForPg.size();
        while (listIterator.hasNext()) {
            boolean isFileSame;
            String backupFilePath = "";
            com.pg.domain.BackupFile nextBackupFile = listIterator.next();
            if (nextBackupFile != null && nextBackupFile.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), nextBackupFile.getFileName(), rwlist))) {
                logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            backupFilePath = nextBackupFile.getFilePath();
            listIterator.remove();
            this.downloadMailFromPg(cloud, response1, downloadFileTO, restoreFolderPath, nextBackupFile, isMail, false);
            logger.debug(backupFilePath + "..remaininglist...." + --pgsize);
        }
        logger.debug(".....backupfilescloud...." + backupFiles.size());
        listIterator = backupFiles.listIterator();
        int cloudsize = backupFiles.size();
        String backupFilePath = "";
        while (listIterator.hasNext()) {
            boolean isFileSame;
            com.pg.domain.BackupFile nextBackupFile = listIterator.next();
            if (nextBackupFile != null && nextBackupFile.getFileName() != null && (isFileSame = this.checkMd5(cloud.getCloudId(), nextBackupFile.getFileName(), rwlist))) {
                logger.debug("md5/file name is same so skip the file...........");
                continue;
            }
            backupFilePath = nextBackupFile.getFilePath();
            listIterator.remove();
            this.downloadMethod(cloud, downloadFileTO, deviceUUID, path, tempdownloadDir, restoreFolderPath, userName, nextBackupFile, graphClient, isMail);
            logger.debug(backupFilePath + "..remaininglist...." + --cloudsize);
        }
    }

    @Override
    public long restoreMailForBackupFolder(Cloud cloud, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, List<BackUpImage> backupImages, long folderSize, String restoreFolderPath, String batchId, boolean isrestoreDeletedFile, Device device, BackupBatch backupBatch) {
        ArrayList<com.pg.domain.BackupFile> backupFiles = new ArrayList<com.pg.domain.BackupFile>();
        ArrayList<com.pg.domain.BackupFile> backupFilesForPg = new ArrayList<com.pg.domain.BackupFile>();
        long zipFileSize = 0L;
        logger.debug("restoreBackupFolder Size..." + backupImages.size());
        for (BackUpImage backupImage : backupImages) {
            if (backupImage.isFolder()) continue;
            backupImage = this.externalStorageBackupFileDao.getBackupImageForId(cloud.getCloudId(), backupImage.getId().toString(), device);
            com.pg.domain.BackupFile backupFileData = new com.pg.domain.BackupFile();
            if (StringUtils.isNotEmpty((String)backupImage.getStoragePlace()) && backupImage.getStoragePlace().equalsIgnoreCase("CLOUD") && !CollectionUtils.isEmpty((Collection)backupImage.getChunkFiles())) {
                this.convertBackupImageToBackupFile(backupImage, backupFileData);
                backupFileData.setId(backupImage.getId().toString());
                backupFileData.setBackupId(backupImage.getId());
                this.utilService.saveFileForPstDownload(backupFileData, batchId);
                backupFiles.add(backupFileData);
                zipFileSize += backupImage.getSize();
            } else {
                this.convertBackupImageToBackupFile(backupImage, backupFileData);
                backupFileData.setId(backupImage.getId().toString());
                backupFileData.setBackupId(backupImage.getId());
                backupFileData.setFileInPg(true);
                backupFilesForPg.add(backupFileData);
                this.utilService.saveFileForPstDownload(backupFileData, batchId);
                zipFileSize += backupImage.getSize();
            }
            if (backupImage.getSizeInBytes() != 0L) {
                folderSize += backupImage.getSizeInBytes();
                continue;
            }
            folderSize += backupImage.getSize();
        }
        zipFileSize += zipFileSize;
        logger.debug("total size required create zip " + zipFileSize);
        return folderSize;
    }

    @Override
    public String startBackupBatch(String deviceUUID, int cloudId, String restoreBy) {
        logger.debug("calling start restore backup Batch ..." + restoreBy);
        String batchId = "";
        try {
            String jobType = "RESTORE";
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            BackupBatch backupBatch = new BackupBatch();
            backupBatch.setUserName(restoreBy);
            backupBatch.setDeviceName(device.getDeviceName());
            backupBatch.setDeviceUUID(deviceUUID);
            backupBatch.setStatus("SCANNING");
            backupBatch.setJobType(jobType);
            backupBatch.setBatchStartTimestamp(System.currentTimeMillis());
            backupBatch.setTotalNoOfFiles("0");
            backupBatch.setUploadedFiles("0/0");
            backupBatch.setDeviceName(device.getDeviceName());
            backupBatch.setBatchEndTimestamp(System.currentTimeMillis());
            backupBatch.setNoOfFiles(0L);
            backupBatch.setTotalSizeToUpload(0L);
            batchId = this.utilService.saveRestoreBatch(cloudId, backupBatch);
            backupBatch.setId(new ObjectId(batchId));
            logger.debug("[backupBatch][" + backupBatch.getUserName() + "][" + backupBatch.getDeviceUUID() + "][" + backupBatch.getId() + "][" + backupBatch.getStatus() + "][" + backupBatch.getBatchStartTimestamp() + "][" + backupBatch.getBatchEndTimestamp() + "]");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling method backup Batch ..." + batchId);
        return batchId;
    }

    private void downloadPstFileFromCloudForPortal(Cloud cloud, HttpServletResponse response, DownloadFileTO downloadFileTO, DownloadTO downloadTO, Device device, String pstBatchId, boolean isrestoreDeletedFile, String restoreBy) {
        String deviceUUID = downloadFileTO.getDeviceUUID();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        String userName = downloadFileTO.getUserName();
        String path = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloud.getCloudName() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "sync-download" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        long currentMills = System.currentTimeMillis();
        String restorePath = path + currentMills + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File restoreFolderPath = new File(restorePath);
        if (!restoreFolderPath.exists()) {
            restoreFolderPath.mkdirs();
        }
        String restoreBatchId = "restore_" + System.currentTimeMillis();
        String restoreFolder = "";
        String devicePath = downloadFileTO.getFileName();
        logger.debug(devicePath + "Restore folder path is create :" + restoreFolderPath);
        boolean allFolders = false;
        StringBuffer addStr = new StringBuffer();
        try {
            int errorCode;
            long folderSize = 0L;
            ArrayList<BackUpImage> backupImageUniqList = new ArrayList<BackUpImage>();
            List<Object> backupImageList = new ArrayList<BackUpImage>();
            ArrayList<BackUpImage> backupImagesList = new ArrayList<BackUpImage>();
            if (!StringUtils.isEmpty((String)downloadFileTO.getBackupID())) {
                String[] backupImgList;
                for (String backupId : backupImgList = downloadFileTO.getBackupID().split(",")) {
                    BackUpImage backupImage = this.externalStorageBackupFileDao.getBackupFileById(cloudId, device, backupId);
                    if (backupImage == null) continue;
                    backupImagesList.add(backupImage);
                    logger.debug("...folderstodownload..." + backupImage.getFileName());
                    restoreFolder = backupImage.getFileName();
                    addStr.append(restoreFolder + ",");
                }
                if (backupImgList.length > 1) {
                    String val = addStr.toString();
                    if (val.endsWith(",")) {
                        val = val.substring(0, val.length() - 1);
                    }
                    restoreFolder = val;
                }
            }
            String batchId = this.startBackupBatch(deviceUUID, cloud.getCloudId(), restoreBy);
            User user = this.utilService.getUserInfoByName(cloudId, restoreBy);
            BackupBatch backupBatch = this.utilService.getBackupBatchById(cloudId, batchId);
            String fullyQualifiedPathVal = path + devicePath;
            boolean isPstAborted = false;
            this.saveRestoreHistory(cloudId, restoreFolder, backupBatch, "" + folderSize, devicePath + ".pst", isrestoreDeletedFile, device, device, cloudName, user, devicePath + ".pst");
            backupImageList = this.getFilteredBackupImageListByGroupingForMail(backupImageList, isrestoreDeletedFile);
            if (!CollectionUtils.isEmpty(backupImagesList)) {
                for (BackUpImage backupImage : backupImagesList) {
                    ArrayList<BackUpImage> backupImages;
                    backupImageList = new ArrayList();
                    if (!backupImage.isFolder()) {
                        logger.debug("..single mail restore...");
                        backupImages = new ArrayList<BackUpImage>();
                        backupImages.add(backupImage);
                        downloadFileTO.setFileName(backupImage.getFileName());
                        downloadTO.setFileName(backupImage.getFileName());
                        folderSize = this.restoreMailForBackupFolder(cloud, downloadFileTO, deviceUUID, path, tempdownloadDir, backupImages, folderSize, restorePath, restoreBatchId, isrestoreDeletedFile, device, backupBatch);
                        continue;
                    }
                    logger.debug("....backupImage..." + backupImage.getId());
                    backupImages = new ArrayList();
                    if (!StringUtils.isEmpty((String)backupImage.getDevicePath())) {
                        logger.debug("....backupImage devicepath not empty..." + backupImage.getDevicePath());
                        this.getAllFolderChildrenByDevicePath(cloudName, userName, backupImage.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImage.getFileName(), device, cloudId, backupImages, false);
                    } else {
                        logger.debug("....backupImage devicepath  empty..." + backupImage.getFileName());
                        this.getAllFolderChildrenByDevicePath(cloudName, userName, backupImage.getFileName(), device, cloudId, backupImages, false);
                    }
                    int errorCode2 = this.getBatchErrorCode(cloudId, batchId);
                    if (errorCode2 == 1207) {
                        isPstAborted = true;
                        break;
                    }
                    backupImageList.addAll(backupImages);
                    backupImageList.add(backupImage);
                    logger.debug("...filesinpath..." + backupImage.getFileName() + "..." + backupImageList.size());
                    logger.debug("...first Size..." + backupImageList.size());
                    int totalFilesToRestore = 0;
                    HashSet<String> unique = new HashSet<String>();
                    for (BackUpImage backUpImage : backupImageList) {
                        if (backUpImage == null) continue;
                        String pathAndFileName = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                        logger.debug(".......processingfolder..." + pathAndFileName);
                        if (unique.contains(pathAndFileName)) continue;
                        unique.add(pathAndFileName);
                        backupImageUniqList.add(backUpImage);
                    }
                    if (CollectionUtils.isEmpty(backupImageUniqList)) continue;
                    for (BackUpImage backUpImage : backupImageUniqList) {
                        logger.debug(".......processingfolder..." + backUpImage.getFileName());
                        int skipValue = 0;
                        List<BackUpImage> backupImagesFolderFile = new ArrayList();
                        int filesInFolder = 0;
                        do {
                            backupImagesFolderFile = new ArrayList();
                            errorCode2 = this.getBatchErrorCode(cloudId, batchId);
                            if (errorCode2 == 1207) {
                                isPstAborted = true;
                                break;
                            }
                            if (StringUtils.isNotEmpty((String)backUpImage.getDevicePath())) {
                                logger.debug(backUpImage.getDevicePath() + "....backupImagedata non empty..." + backUpImage.getFileName());
                                backupImagesFolderFile = this.externalStorageBackupFileDao.getBackupFilesForBasePathSkipValue(cloudId, cloudName, userName, device, backUpImage.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getFileName(), skipValue);
                            } else {
                                logger.debug(backUpImage.getFileName() + "....backupImagedata  empty..." + backupImage.getFileName());
                                backupImagesFolderFile = this.externalStorageBackupFileDao.getBackupFilesForBasePathSkipValue(cloudId, cloudName, userName, device, backUpImage.getFileName(), skipValue);
                                logger.debug("...devuse..." + device.getDeviceUUID() + "...." + userName + "...." + backupImage.getFileName());
                            }
                            if (!CollectionUtils.isEmpty(backupImagesFolderFile)) {
                                folderSize = this.restoreMailForBackupFolder(cloud, downloadFileTO, deviceUUID, path, tempdownloadDir, backupImagesFolderFile, folderSize, restorePath, restoreBatchId, isrestoreDeletedFile, device, backupBatch);
                            }
                            logger.debug(++skipValue + "....files under path  " + backupImage.getFileName() + "..." + (filesInFolder += backupImagesFolderFile.size()));
                        } while (!CollectionUtils.isEmpty(backupImagesFolderFile));
                        logger.debug(backUpImage.getFileName() + "....foldercompleted...." + filesInFolder + "....totalfilesrestored..." + (totalFilesToRestore += filesInFolder));
                    }
                }
            } else {
                logger.debug("..pstbatch save....");
                List<PstBatchDetail> pstBatchDetails = this.utilService.getPstBatchDetails(pstBatchId);
                ArrayList<BackUpImage> backupImages = new ArrayList<BackUpImage>();
                if (!CollectionUtils.isEmpty(pstBatchDetails)) {
                    for (PstBatchDetail pstBatchDetail : pstBatchDetails) {
                        device = this.utilService.getDeviceForUUID(cloudId, pstBatchDetail.getDeviceUUID());
                        BackUpImage backupImageObj = this.externalStorageBackupFileDao.getBackupFileById(cloudId, device, pstBatchDetail.getBackupId());
                        if (backupImageObj == null) continue;
                        backupImages.add(backupImageObj);
                    }
                }
                folderSize = this.restoreMailForBackupFolder(cloud, downloadFileTO, deviceUUID, path, tempdownloadDir, backupImages, folderSize, restorePath, restoreBatchId, isrestoreDeletedFile, device, backupBatch);
            }
            if ((errorCode = this.getBatchErrorCode(cloudId, batchId)) == 1207) {
                this.utilService.updateAbortBackBatch(cloudId, backupBatch.getId());
                errorCode = 1207;
                this.utilService.updateBackupBatch(cloudId, backupBatch.getId(), "ABORTED", errorCode);
                logger.debug("..pst aborted...");
                return;
            }
            this.saveRestoreHistory(cloudId, restoreFolder, backupBatch, "" + folderSize, devicePath + ".pst", isrestoreDeletedFile, device, device, cloudName, user, devicePath + ".pst");
            long totalNoOfFiles = this.utilService.countFilesForMailBatchId(cloudId, restoreBatchId);
            logger.debug(restoreBatchId + "...total no of files-for-restore..." + totalNoOfFiles);
            this.updateBackupBatchStatusAndSize(backupBatch, cloud, folderSize, totalNoOfFiles);
            try {
                logger.debug("...wait for 10 sec for status update..");
                Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.restoreMailsForPst(cloud, response, downloadFileTO, deviceUUID, devicePath, tempdownloadDir, restoreBatchId, restorePath, backupBatch, new AtomicInteger(), new AtomicInteger(), null, null);
            downloadTO.setSize(folderSize);
            errorCode = this.getBatchErrorCode(cloudId, batchId);
            if (errorCode != 1207) {
                String fullyQualifiedPath = this.createPstLatest(restorePath, fullyQualifiedPathVal, ".pst");
                logger.debug("Completed ....." + folderSize);
                logger.debug(fullyQualifiedPath + "...fullPath..." + path);
                logger.debug(new File(fullyQualifiedPath).length() + "...file length...." + fullyQualifiedPath);
                downloadTO.setPath(fullyQualifiedPath);
                this.updateBatchAndOverview(cloud.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), 0);
            } else {
                this.utilService.updateAbortBackBatch(cloudId, backupBatch.getId());
            }
            try {
                logger.debug(new File(restorePath).length() + ".....restore...");
                FileUtils.deleteDirectory((File)new File(restorePath));
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" error trying to delete dir ...." + e.getMessage());
            }
            logger.debug("..completed....");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception" + e.getMessage());
            logger.trace("Exception" + e);
        }
    }

    private int getBatchErrorCode(int cloudId, String batchId) {
        BackupBatch pbBkpBatch = this.utilService.getBackupBatchById(cloudId, batchId);
        int errorCode = 0;
        if (pbBkpBatch != null && StringUtils.isNotEmpty((String)pbBkpBatch.getErrorCode()) && (pbBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) || pbBkpBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE))) {
            errorCode = pbBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) ? Integer.parseInt(STOPPED_BACKUP_ERROR_CODE) : Integer.parseInt(PAUSED_BACKUP_ERROR_CODE);
        }
        return errorCode;
    }

    private void updateBackupBatchStatusAndSize(BackupBatch backupBatch, Cloud cloud, long folderSize, long totalNoOfFiles) {
        this.utilService.updateBackupBatchStatusAndSize(cloud.getCloudId(), backupBatch.getId(), STARTED, folderSize, totalNoOfFiles);
    }

    private void updateBatchAndOverview(int cloudId, ObjectId backupBatchId, String status, String deviceUUID, int errorCode) {
        this.utilService.updateBackupBatch(cloudId, backupBatchId, status, errorCode);
    }

    private void updateRestoreHistoryValues(BackupBatch backupBatch, Device device, String totalSizeRestore, String destFolder, boolean restoredInDiffPath, RestoreHistory restoreHistoy, Device destDevice) {
        restoreHistoy.setUserName(device.getUserName());
        restoreHistoy.setDeviceName(device.getDeviceName());
        restoreHistoy.setDeviceUUID(device.getDeviceUUID());
        restoreHistoy.setRestoreByDeviceName(destDevice.getDeviceName());
        restoreHistoy.setRestoreByUserName(backupBatch.getUserName());
        restoreHistoy.setRestoreByDeviceUUID(destDevice.getDeviceUUID());
        restoreHistoy.setRestoredSize(totalSizeRestore);
        restoreHistoy.setDestFolder(destFolder);
        restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
    }

    private void saveRestoreHistory(int cloudId, String restoreFolder, BackupBatch backupBatch, String totalSizeRestore, String destFolder, boolean restoredInDiffPath, Device device, Device destDevice, String cloudName, User user1, String fileName) {
        RestoreHistory restoreHistoy = new RestoreHistory();
        try {
            if (backupBatch.getId() != null) {
                RestoreHistory history = this.utilService.getRestoreHistoryById(cloudId, backupBatch.getId());
                if (history == null) {
                    logger.debug(destDevice.getDeviceName() + "...totalSizeRestore...." + totalSizeRestore);
                    BeanUtils.copyProperties((Object)backupBatch, (Object)restoreHistoy);
                    if (!StringUtils.isEmpty((String)restoreFolder)) {
                        restoreHistoy.setRestoreFolder(restoreFolder);
                    }
                    this.updateRestoreHistoryValues(backupBatch, device, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, destDevice);
                    restoreHistoy.setPstRestore(true);
                    restoreHistoy.setPstFileName(fileName);
                    this.utilService.saveRestoreHistory(cloudId, restoreHistoy);
                } else {
                    logger.debug("......restore history already exists :" + backupBatch.getId() + "...." + backupBatch.getStatus());
                    history.setDestFolder(destFolder);
                    restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
                    restoreHistoy.setPstRestore(true);
                    restoreHistoy.setPstFileName(fileName);
                    this.utilService.saveRestoreHistory(cloudId, history);
                }
            } else {
                BeanUtils.copyProperties((Object)backupBatch, (Object)restoreHistoy);
                this.updateRestoreHistoryValues(backupBatch, device, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, destDevice);
                restoreHistoy.setPstRestore(true);
                restoreHistoy.setPstFileName(fileName);
                this.utilService.saveRestoreHistory(cloudId, restoreHistoy);
            }
        }
        catch (Exception e) {
            logger.trace("Error failed to saveRestoreHistory..." + e);
            logger.error("Error failed to saveRestoreHistory ..." + e.getMessage());
        }
    }

    private List<BackUpImage> getFilteredBackupImageListByGroupingForMail(List<BackUpImage> backUpImages, boolean restoreDeletedFiles) {
        logger.debug(restoreDeletedFiles + "...Inside grouping backup images..." + backUpImages.size());
        List<Object> folderBackUpImages = new ArrayList();
        folderBackUpImages = backUpImages.stream().filter(f -> f.isFolder()).collect(Collectors.toList());
        List<Object> fileBackUpImages = new ArrayList();
        fileBackUpImages = backUpImages.stream().filter(f -> !f.isFolder()).collect(Collectors.toList());
        backUpImages = fileBackUpImages;
        Comparator<BackUpImage> compareByName = new Comparator<BackUpImage>(){

            @Override
            public int compare(BackUpImage o1, BackUpImage o2) {
                return o1.getFileName().compareTo(o2.getFileName());
            }
        };
        Map<String, List<BackUpImage>> foldermap = folderBackUpImages.stream().filter(p -> p.isFolder()).collect(Collectors.groupingBy(BackUpImage::getFileName));
        ArrayList filteredFolderBackUpImages = new ArrayList();
        foldermap.entrySet().stream().forEach(p -> filteredFolderBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        ArrayList<BackUpImage> filteredfolderBackUpImages = new ArrayList<BackUpImage>();
        ArrayList<BackUpImage> delefolderBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage filteredBackUpImage : filteredFolderBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                filteredfolderBackUpImages.add(filteredBackUpImage);
                continue;
            }
            delefolderBackUpImages.add(filteredBackUpImage);
        }
        Collections.sort(filteredfolderBackUpImages, compareByName);
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList<BackUpImage> deletedBackUpImagesList = new ArrayList<BackUpImage>();
        Map<String, List<BackUpImage>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getOdItemId));
        int i = 0;
        map.entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        for (BackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                ++i;
                filteredBackUpImagesList.add(filteredBackUpImage);
                continue;
            }
            deletedBackUpImagesList.add(filteredBackUpImage);
        }
        logger.debug(deletedBackUpImagesList.size() + "...filtered list ..." + filteredBackUpImagesList.size());
        if (restoreDeletedFiles) {
            backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().orElse(null)));
            Map<String, Map<String, List<BackUpImage>>> map1 = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getOdItemId)));
            for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map1.entrySet()) {
                entry.getValue().entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().orElse(null)));
            }
            logger.debug(deltedBackUpImages.size() + "...delelted..." + deletedBackUpImagesList.size());
            for (BackUpImage bkpimage : deletedBackUpImagesList) {
                logger.debug(filteredBackUpImagesList.size() + "...trying file...." + bkpimage.getFileName());
                for (BackUpImage bkpimage1 : deltedBackUpImages) {
                    if (bkpimage1 == null) continue;
                    if (StringUtils.isEmpty((String)bkpimage1.getFileName())) {
                        bkpimage1.setFileName("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage.getFileName())) {
                        bkpimage.setFileName("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage1.getDevicePath())) {
                        bkpimage1.setDevicePath("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage.getDevicePath())) {
                        bkpimage.setDevicePath("");
                    }
                    if (!bkpimage.getFileName().equals(bkpimage1.getFileName()) || !bkpimage.getDevicePath().equals(bkpimage1.getDevicePath())) continue;
                    bkpimage1.setPresent(false);
                    filteredBackUpImagesList.add(bkpimage1);
                }
            }
        }
        filteredBackUpImagesList.stream().sorted(Comparator.comparing(MailInfo::getSentDate, Comparator.nullsLast(Comparator.reverseOrder())));
        ArrayList<BackUpImage> overAllList = new ArrayList<BackUpImage>();
        overAllList.addAll(filteredfolderBackUpImages);
        overAllList.addAll(filteredBackUpImagesList);
        return overAllList;
    }

    static String getUniquePath(String path, String extension) {
        int i = 1;
        String newPath = path + extension;
        if (new File(newPath).exists()) {
            while (new File(newPath).exists()) {
                newPath = path + "(" + i + ")" + extension;
                ++i;
            }
        }
        return newPath;
    }

    @Override
    public String createPstLatest(String mailFolder, String pstFilePathVal, String extension) {
        String pstFilePath = DownloadServiceImpl.getUniquePath(pstFilePathVal, extension);
        logger.debug("...creating unique pst files....." + pstFilePath);
        File fileObj = new File(pstFilePath);
        PersonalStorage pst = PersonalStorage.create((String)pstFilePath, (int)0);
        License license = new License();
        String encryptedFilePath = "/parablu/mail/aspose.encrypted";
        String key = "ParaBlu@12Aspose";
        ByteArrayInputStream licenseStream = DownloadServiceImpl.decrypt(key, encryptedFilePath);
        license.setLicense((InputStream)licenseStream);
        AtomicInteger addedFiles = new AtomicInteger();
        File fold = new File(mailFolder);
        List<File> filesList = Arrays.asList(fold.listFiles());
        logger.debug("..list of files...." + mailFolder + "...path..files..." + fold.listFiles().length);
        filesList.forEach(file -> DownloadServiceImpl.getFilesRecursive(file, mailFolder, pst, addedFiles));
        pst.dispose();
        fileObj = new File(pstFilePath);
        File copied = new File("/parablu/Downloads/" + fileObj.getName());
        try {
            FileUtils.copyFile((File)fileObj, (File)copied);
        }
        catch (IOException e) {
            logger.error("...unable to download file....");
            e.printStackTrace();
        }
        if (fileObj.exists()) {
            fileObj.delete();
        }
        return pstFilePath;
    }

    private static void getFilesRecursive(File pFile, String mailFolder, PersonalStorage pst, AtomicInteger addedFiles) {
        if (pFile.isDirectory()) {
            for (File file : pFile.listFiles()) {
                logger.debug(pFile.getAbsolutePath() + "....totalcount..." + pFile.listFiles().length);
                if (file.isDirectory()) {
                    List<File> filesList = Arrays.asList(file.listFiles());
                    logger.debug(file.getAbsolutePath() + "....totalcountfor subpath..." + file.listFiles().length);
                    filesList.forEach(fileObj -> DownloadServiceImpl.getFilesRecursive(fileObj, mailFolder, pst, addedFiles));
                    continue;
                }
                DownloadServiceImpl.addEmlToPst(mailFolder, pst, file, addedFiles);
            }
        } else {
            DownloadServiceImpl.addEmlToPst(mailFolder, pst, pFile, addedFiles);
        }
    }

    private static void addEmlToPst(String mailFolder, PersonalStorage pst, File file, AtomicInteger addedFiles) {
        if (file.exists()) {
            MailMessage eml = MailMessage.load((String)file.getPath());
            logger.debug(file.getPath() + "...file..." + file.getName());
            String path = file.getParent();
            String folderName = path.replaceAll(mailFolder, "");
            logger.debug(addedFiles.get() + "..inc.." + folderName + "...pathinside...." + file.getPath() + ".." + file.getName());
            try {
                pst.getRootFolder().addSubFolder(folderName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                addedFiles.incrementAndGet();
                pst.getRootFolder().getSubFolder(folderName).addMessage(MapiMessage.fromMailMessage((MailMessage)eml));
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (FileCorruptedException ee) {
                logger.error("....mail eml corrupted....");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ByteArrayInputStream decrypt(String key, String inputFilePath) {
        String ALGORITHM = "AES";
        String TRANSFORMATION = "AES";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayInputStream licenseStream = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), ALGORITHM);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, secretKey);
            File inputFile = new File(inputFilePath);
            FileInputStream inputStream = new FileInputStream(inputFile);
            byte[] inputBytes = new byte[(int)inputFile.length()];
            inputStream.read(inputBytes);
            licenseStream = new ByteArrayInputStream(cipher.doFinal(inputBytes));
            inputStream.close();
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            System.out.println("Error encrypting/decrypting file");
        }
        return licenseStream;
    }

    private List<BackUpImage> getFilteredBackupImageListByGrouping(List<BackUpImage> backUpImages, boolean restoreDeletedFiles) {
        logger.debug("Inside grouping backup images");
        logger.debug(restoreDeletedFiles + "...Inside grouping backup images..." + backUpImages.size());
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList<BackUpImage> deletedBackUpImagesList = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            logger.debug(backUpImage.getId().toString() + "...path and filename..." + backUpImage.getDevicePath() + "...." + backUpImage.getFileName());
        }
        backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        logger.debug("..overall mapsize...." + map.size());
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        for (BackUpImage backUpImage : filteredBackUpImages) {
            if (backUpImage.isPresent()) {
                filteredBackUpImagesList.add(backUpImage);
                continue;
            }
            deletedBackUpImagesList.add(backUpImage);
        }
        logger.debug(deletedBackUpImagesList.size() + "...filtered list ..." + filteredBackUpImagesList.size());
        if (restoreDeletedFiles) {
            backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().orElse(null)));
            Map<String, Map<String, List<BackUpImage>>> map2 = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
            for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map2.entrySet()) {
                entry.getValue().entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().orElse(null)));
            }
            logger.debug(deltedBackUpImages.size() + "...delelted..." + deletedBackUpImagesList.size());
            for (BackUpImage bkpimage : deletedBackUpImagesList) {
                logger.debug(filteredBackUpImagesList.size() + "...trying file...." + bkpimage.getFileName());
                for (BackUpImage bkpimage1 : deltedBackUpImages) {
                    if (bkpimage1 == null) continue;
                    logger.debug("...filebkpimage.change..." + bkpimage.getFileName() + "...." + bkpimage1.getFileName());
                    if (StringUtils.isEmpty((String)bkpimage1.getFileName())) {
                        bkpimage1.setFileName("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage.getFileName())) {
                        bkpimage.setFileName("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage1.getDevicePath())) {
                        bkpimage1.setDevicePath("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage.getDevicePath())) {
                        bkpimage.setDevicePath("");
                    }
                    if (!bkpimage.getFileName().equals(bkpimage1.getFileName()) || !bkpimage.getDevicePath().equals(bkpimage1.getDevicePath())) continue;
                    bkpimage1.setPresent(false);
                    filteredBackUpImagesList.add(bkpimage1);
                    logger.debug("....filter list added....");
                }
            }
        }
        return filteredBackUpImagesList;
    }

    private boolean checkMd5(int cloudId, String fileName, List<String> rwlist) {
        logger.debug("..........md5ofChunk........" + fileName);
        boolean isfileNamesame = false;
        if (StringUtils.isNotEmpty((String)fileName)) {
            for (String md51 : rwlist) {
                if (!fileName.equalsIgnoreCase(md51)) continue;
                isfileNamesame = true;
                break;
            }
        }
        return isfileNamesame;
    }

    @Override
    public void downloadPstFileFromCloudForPortal(String currentMills, String cloudName, String fileName) {
        String restorePath;
        File restoreFolderPath;
        String path = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "sync-download" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        if (!(restoreFolderPath = new File(restorePath = path + currentMills + GeneralHelperConstant.CLOUD_PATH_SEPARATOR)).exists()) {
            restoreFolderPath.mkdirs();
        }
        String devicePath = fileName;
        logger.debug(devicePath + "Restore folder path is create :" + restoreFolderPath);
        try {
            long folderSize = 0L;
            logger.debug("Completed ....." + folderSize);
            String fullyQualifiedPathVal = path + devicePath;
            String fullyQualifiedPath = DownloadServiceImpl.updateExistingPst(restorePath, fullyQualifiedPathVal, ".pst");
            logger.debug(fullyQualifiedPath + "...fullPath..." + path);
            logger.debug(new File(fullyQualifiedPath).length() + "...file length...." + fullyQualifiedPath);
            try {
                logger.debug(new File(restorePath).length() + ".....restore...");
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" error trying to delete dir ...." + e.getMessage());
            }
            logger.debug("..full path...." + fullyQualifiedPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception" + e.getMessage());
            logger.trace("Exception" + e);
        }
    }

    private static String updateExistingPst(String mailFolder, String pstFilePathVal, String extension) {
        String pstFilePath = DownloadServiceImpl.getUniquePath(pstFilePathVal, extension);
        logger.debug("...creating unique pst files....." + pstFilePath);
        File fileObj = new File(pstFilePath);
        PersonalStorage pst = PersonalStorage.create((String)pstFilePath, (int)0);
        License license = new License();
        String encryptedFilePath = "/parablu/mail/aspose.encrypted";
        String key = "ParaBlu@12Aspose";
        ByteArrayInputStream licenseStream = DownloadServiceImpl.decrypt(key, encryptedFilePath);
        license.setLicense((InputStream)licenseStream);
        AtomicInteger addedFiles = new AtomicInteger();
        File fold = new File(mailFolder);
        List<File> filesList = Arrays.asList(fold.listFiles());
        logger.debug("..list of files...." + mailFolder + "...path..files..." + fold.listFiles().length);
        filesList.forEach(file -> DownloadServiceImpl.getFilesRecursive(file, mailFolder, pst, addedFiles));
        pst.dispose();
        fileObj = new File(pstFilePath);
        File copied = new File("/parablu/Downloads/" + fileObj.getName());
        try {
            FileUtils.copyFile((File)fileObj, (File)copied);
        }
        catch (IOException e) {
            logger.error("...unable to download file....");
            e.printStackTrace();
        }
        if (fileObj.exists()) {
            fileObj.delete();
        }
        return pstFilePath;
    }
}

