/*
 * Decompiled with CFR 0.152.
 */
package com.pg.odb.util;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.ListInfo;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.DriveCollectionPage;
import com.microsoft.graph.requests.DriveCollectionRequest;
import com.microsoft.graph.requests.DriveCollectionRequestBuilder;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.ListCollectionRequest;
import com.microsoft.graph.requests.SiteCollectionPage;
import com.microsoft.graph.requests.SiteCollectionRequest;
import com.microsoft.graph.requests.SiteCollectionRequestBuilder;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserRequestBuilder;
import com.parablu.pcbd.dao.BackupOverViewDao;
import com.parablu.pcbd.domain.RetryPolicyTable;
import com.parablu.pcbd.domain.User;
import com.pg.controller.C2CGraphClient;
import com.pg.controller.Graph;
import com.pg.dao.Office365Dao;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.service.GraphUploadService;
import com.pg.service.Office365UploadService;
import com.pg.service.RetryService;
import com.pg.service.UtilService;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class OneDriveUtil {
    private static final int MAX_FILE_COUNT = 4000;
    @Autowired
    private UtilService utilService;
    @Autowired
    private Office365UploadService office365UploadService;
    @Autowired
    private GraphUploadService graphUploadService;
    @Autowired
    private BackupOverViewDao backupOverViewDao;
    @Autowired
    private Office365Dao office365Dao;
    @Autowired
    private RetryService retryService;
    private static OneDriveUtil singleton = new OneDriveUtil();
    private static Logger logger = LogManager.getLogger(OneDriveUtil.class);
    Map<String, UserOdbElement> userCountMap = new ConcurrentHashMap<String, UserOdbElement>();
    Map<String, Object> userObjectMap = new ConcurrentHashMap<String, Object>();

    private OneDriveUtil() {
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setOffice365UploadService(Office365UploadService office365UploadService) {
        this.office365UploadService = office365UploadService;
    }

    public static OneDriveUtil getInstance() {
        return singleton;
    }

    private synchronized void setUserElementUsingGraph(boolean isSync, String emailId, User user, String deviceUUID, String actualUserName) {
        logger.error("MAP-VAL................" + this.userCountMap + "...." + emailId);
        if (this.userCountMap.get(actualUserName) == null) {
            ArrayList<Integer> folderNameList;
            logger.debug("inside getUserElement nulll " + actualUserName);
            String lastCloudStoragePath = this.checkOneDriveStoragePath(user.getUserName(), isSync, user);
            int count = this.getCountOFFilesInFolderUsingGraph(emailId, deviceUUID, lastCloudStoragePath, user);
            logger.debug(".......folder count before assigning setuserElement..... " + count);
            while (count >= 4000 && (count = this.getCountOFFilesInFolderUsingGraph(emailId, deviceUUID, lastCloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList = this.splitPathAndGetFolderDepth(lastCloudStoragePath), count), user)) >= 4000) {
            }
            logger.debug(".......folder count after assigning setuserElement..... " + count + "......." + lastCloudStoragePath);
            UserOdbElement userOdbElement = new UserOdbElement(count, System.currentTimeMillis(), lastCloudStoragePath);
            this.userCountMap.put(actualUserName, userOdbElement);
        }
    }

    private synchronized void setUserElementForSPUsingGraph(boolean isSync, User user, String deviceUUID, String actualUserName, String siteName) {
        logger.error("MAP-VAL................" + this.userCountMap + "...." + siteName);
        if (this.userCountMap.get(actualUserName) == null) {
            ArrayList<Integer> folderNameList;
            logger.debug("inside getUserElement nulll " + actualUserName);
            String lastCloudStoragePath = this.checkOneDriveStoragePath(user.getUserName(), isSync, user);
            int count = this.getCountOFFilesInFolderForSPUsingGraph(deviceUUID, lastCloudStoragePath, user, siteName);
            logger.debug(".......folder count before assigning setuserElement..... " + count);
            while (count >= 4000 && (count = this.getCountOFFilesInFolderForSPUsingGraph(deviceUUID, lastCloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList = this.splitPathAndGetFolderDepth(lastCloudStoragePath), count), user, siteName)) >= 4000) {
            }
            logger.debug(".......folder count after assigning setuserElement..... " + count + "......." + lastCloudStoragePath);
            UserOdbElement userOdbElement = new UserOdbElement(count, System.currentTimeMillis(), lastCloudStoragePath);
            this.userCountMap.put(actualUserName, userOdbElement);
        }
    }

    public int getCountOFFilesInFolderUsingGraph(String emailId, String deviceUUID, String path, User user) {
        DriveItem item;
        int countVal;
        block7: {
            String driveId;
            countVal = 0;
            GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
            emailId = user.getEmailId();
            if (!StringUtils.isEmpty((Object)user.getOdbLoginId())) {
                emailId = user.getOdbLoginId();
            }
            if (!StringUtils.isEmpty((Object)user.getDestOdbLoginId())) {
                emailId = user.getDestOdbLoginId();
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(driveId = user.getOdbDriveid()))) {
                driveId = OneDriveUtil.getPBFolderItemIdWithErrorCode(emailId.toLowerCase());
            }
            String userNameToGetUrl = "";
            if (!StringUtils.isEmpty((Object)deviceUUID)) {
                userNameToGetUrl = OneDriveUtil.getUniqueODUserFolder(deviceUUID);
                logger.debug("....device unique id ....... " + userNameToGetUrl);
            }
            item = null;
            try {
                item = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + userNameToGetUrl + "/" + path, DriveItem.class).buildRequest(new Option[0]).get();
            }
            catch (GraphServiceException e) {
                logger.error("....excep..." + e.getResponseCode());
                if (e.getResponseCode() != 404) break block7;
                return 0;
            }
        }
        if (item != null && item.folder != null) {
            countVal = item.folder.childCount;
        }
        return countVal;
    }

    public int getCountOFFilesInFolderForSPUsingGraph(String deviceUUID, String path, User user, String siteName) {
        DriveItem item;
        int countVal;
        block5: {
            countVal = 0;
            GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
            String driveId = user.getOdbDriveid();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)driveId)) {
                driveId = OneDriveUtil.getPBFolderItemIdForSPWithErrorCode(siteName);
            }
            String userNameToGetUrl = "";
            if (!StringUtils.isEmpty((Object)deviceUUID)) {
                userNameToGetUrl = OneDriveUtil.getUniqueODUserFolder(deviceUUID);
                logger.debug("....device unique id ....... " + userNameToGetUrl);
            }
            item = null;
            try {
                item = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + userNameToGetUrl + "/" + path, DriveItem.class).buildRequest(new Option[0]).get();
            }
            catch (GraphServiceException e) {
                logger.error("....excep..." + e.getResponseCode());
                if (e.getResponseCode() != 404) break block5;
                return 0;
            }
        }
        if (item != null && item.folder != null) {
            countVal = item.folder.childCount;
        }
        return countVal;
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty((Object)deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString((String)deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    public static GraphServiceClient<Request> getC2CGraphClient() {
        C2CGraphClient c2cGraphClient = C2CGraphClient.getInstance();
        GraphServiceClient<Request> graphClient = c2cGraphClient.getGraphClient();
        return graphClient;
    }

    public static GraphServiceClient<Request> getGraphClient() {
        String authorityHost = "https://login.microsoftonline.com";
        logger.debug("...helper constant ...." + PCHelperConstant.getMSClientId());
        GraphServiceClient graphClient = null;
        if (!StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            logger.debug("....using proxy latest......");
            InetSocketAddress proxyInetAddress = new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort());
            logger.debug("....using proxy latest before createDefault 1bb......" + PCHelperConstant.getProxyHost() + "..pwd..." + PCHelperConstant.getProxyPort());
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            HttpClientOptions clientOptions = new HttpClientOptions();
            clientOptions.setProxyOptions(proxyOptions);
            logger.debug("....using proxy latest before createDefault 2a with host latest");
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            OkHttpClient httpClient = null;
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyInetAddress);
            logger.debug("....using proxy latest before createDefault 3a");
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(proxy).build();
            logger.debug("....using proxy latest before createDefault 4");
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)httpClient).buildClient();
            logger.debug("....using proxy latest before createDefault 5");
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            logger.debug("before getting a Graph client:" + tokenCredAuthProvider);
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
        }
        logger.debug("Graph client:" + graphClient);
        return graphClient;
    }

    private static boolean isPBDrive(String webUrl) {
        boolean pbDrive = false;
        try {
            String docLibraryName = webUrl.substring(webUrl.lastIndexOf("/") + 1);
            if (!StringUtils.isEmpty((Object)docLibraryName) && docLibraryName.equalsIgnoreCase("PB")) {
                pbDrive = true;
            }
        }
        catch (Exception e) {
            logger.error(webUrl + "...unable to get drive .... " + e.getMessage());
            pbDrive = false;
        }
        return pbDrive;
    }

    private static void sleep() {
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e1) {
            logger.error("InterruptedException:" + e1);
        }
    }

    private RetryPolicy<String> getRetryPolicy() {
        logger.debug("retryService:" + this.retryService);
        RetryPolicyTable policyTable = this.retryService.getRetryPolicyTable(1, "");
        RetryPolicy retryPolicy = this.retryService.valueOf(policyTable);
        return retryPolicy;
    }

    public static String getPBFolderItemIdWithErrorCode(String emailId) {
        String pbFolderItemId = "";
        try {
            GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (com.microsoft.graph.models.User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug("..userid  val$$$$..." + userId);
            if (StringUtils.isEmpty((Object)userId)) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + emailId + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (com.microsoft.graph.models.User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            logger.debug("..userid after principalname val$$$$..." + userId);
            UserRequestBuilder users = graphClient.users(userId);
            DriveCollectionRequestBuilder drives = users.drives();
            DriveCollectionRequest buildRequests = (DriveCollectionRequest)drives.buildRequest(new Option[0]);
            DriveCollectionPage DriveCollectionPages = (DriveCollectionPage)buildRequests.get();
            for (Drive drive : DriveCollectionPages.getCurrentPage()) {
                if (!OneDriveUtil.isPBDrive(drive.webUrl)) continue;
                pbFolderItemId = drive.id;
            }
            if (StringUtils.isEmpty((Object)pbFolderItemId)) {
                logger.debug(".....trytocreate pb for email...." + emailId);
                OneDriveUtil.createDriveInsideList(graphClient, emailId);
                return OneDriveUtil.getPBFolderItemIdWithErrorCode(emailId);
            }
        }
        catch (GraphServiceException e) {
            e.printStackTrace();
            logger.debug(emailId + ".....driveid error code ...." + e.getResponseCode());
            pbFolderItemId = "" + e.getResponseCode();
            logger.error("error getting drive id for one drive upload", (Throwable)e);
        }
        return pbFolderItemId;
    }

    public static String getPBFolderItemIdForSPWithErrorCode(String siteName) {
        String pbFolderItemId = "";
        try {
            GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
            SiteCollectionPage siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)graphClient.sites().buildRequest(new Option[0])).get();
            List currentPageVal = null;
            SiteCollectionRequestBuilder nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage();
            HashMap<String, String> siteMap = new HashMap<String, String>();
            do {
                currentPageVal = siteCollectionPage.getCurrentPage();
                for (Object site : siteCollectionPage.getCurrentPage()) {
                    if (!((Site)site).webUrl.contains("sites/")) continue;
                    siteMap.put(((Site)site).name, ((Site)site).id);
                }
                nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage();
                if (nextPage == null) continue;
                siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)nextPage.buildRequest(new Option[0])).get();
            } while (currentPageVal.size() > 0 && nextPage != null && siteCollectionPage != null && nextPage != null);
            String siteId = "";
            for (Map.Entry entry : siteMap.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(siteName)) continue;
                siteId = (String)entry.getValue();
            }
            DriveCollectionPage driveCollectionPage = (DriveCollectionPage)((DriveCollectionRequest)graphClient.sites(siteId).drives().buildRequest(new Option[0])).get();
            for (Drive drive : driveCollectionPage.getCurrentPage()) {
                logger.debug("........drivename......." + drive.name);
                if (!"PB".equalsIgnoreCase(drive.name)) continue;
                pbFolderItemId = drive.id;
            }
            if (StringUtils.isEmpty((Object)pbFolderItemId)) {
                logger.debug(".....trytocreate pb for email...." + siteId);
                OneDriveUtil.createDriveInsideSite(graphClient, siteId);
                return OneDriveUtil.getPBFolderItemIdForSPWithErrorCode(siteName);
            }
        }
        catch (GraphServiceException e) {
            e.printStackTrace();
            logger.debug(siteName + ".....driveid error code ...." + e.getResponseCode());
            pbFolderItemId = "" + e.getResponseCode();
            logger.error("error getting drive id for one drive upload", (Throwable)e);
        }
        return pbFolderItemId;
    }

    public static String getPBFolderItemIdWithErrorCode(GraphServiceClient<Request> graphClient, String emailId) {
        String pbFolderItemId = "";
        try {
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (com.microsoft.graph.models.User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug("..userid is not there..." + userId);
            if (StringUtils.isEmpty((Object)userId)) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + emailId + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (com.microsoft.graph.models.User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            UserRequestBuilder users = graphClient.users(userId);
            DriveCollectionRequestBuilder drives = users.drives();
            DriveCollectionRequest buildRequests = (DriveCollectionRequest)drives.buildRequest(new Option[0]);
            DriveCollectionPage DriveCollectionPages = (DriveCollectionPage)buildRequests.get();
            for (Drive drive : DriveCollectionPages.getCurrentPage()) {
                if (!OneDriveUtil.isPBDrive(drive.webUrl)) continue;
                pbFolderItemId = drive.id;
            }
            if (StringUtils.isEmpty((Object)pbFolderItemId)) {
                logger.debug(".....trytocreate pb for email...." + emailId);
                OneDriveUtil.createDriveInsideList(graphClient, emailId);
                return OneDriveUtil.getPBFolderItemIdWithErrorCode(emailId);
            }
        }
        catch (GraphServiceException e) {
            logger.debug(".....driveid error code ...." + e.getResponseCode());
            pbFolderItemId = "" + e.getResponseCode();
            logger.error("error getting drive id for one drive upload", (Throwable)e);
        }
        return pbFolderItemId;
    }

    public static String getUserIdFromAzure(String emailId) {
        String userIdFromAzure = "";
        try {
            GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (com.microsoft.graph.models.User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug("..userid  val$$$$..." + userId);
            if (StringUtils.isEmpty((Object)userId)) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + emailId + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (com.microsoft.graph.models.User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            logger.debug("..userid after principalname val$$$$..." + userId);
            userIdFromAzure = userId;
        }
        catch (GraphServiceException e) {
            e.printStackTrace();
            logger.debug(emailId + ".....driveid error code ...." + e.getResponseCode());
            userIdFromAzure = "";
            logger.error("error getting drive id for one drive upload", (Throwable)e);
        }
        return userIdFromAzure;
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }

    private static String getPersonalSiteId(String emailId, String sharePointUrl) {
        String spUrl = sharePointUrl;
        spUrl = spUrl.replaceAll("https://", "");
        spUrl = spUrl.replaceAll("/", "");
        String personalEmailId = OneDriveUtil.getEmailId(emailId);
        String personalSiteId = "";
        String siteUrl = "https://graph.microsoft.com/v1.0/sites/" + spUrl + ":/personal/" + personalEmailId;
        logger.debug("...siteurl...." + siteUrl);
        try {
            Request request1 = new Request.Builder().url(siteUrl).build();
            Call call1 = Graph.getInstance().getOkHttpClient().newCall(request1);
            Response response1 = call1.execute();
            int responseCode1 = response1.code();
            logger.debug("...response code..." + responseCode1);
            String bodyStr = response1.body().string();
            logger.debug("...." + bodyStr);
            JSONObject jsonObject = new JSONObject(bodyStr);
            personalSiteId = (String)jsonObject.get("id");
            logger.debug(jsonObject.get("webUrl") + "...." + personalSiteId);
        }
        catch (IOException ee) {
            logger.error(sharePointUrl + "...unable to get site id..." + emailId);
        }
        return personalSiteId;
    }

    private static void createDriveInsideList(GraphServiceClient<Request> graphClient, String emailId) {
        String siteId = OneDriveUtil.getPersonalSiteId(emailId, PCHelperConstant.getMSSharePointUrl());
        Site site = graphClient.sites(siteId).buildRequest(new Option[0]).get();
        logger.debug("..before creating.." + site.name + "...." + site.webUrl);
        com.microsoft.graph.models.List list = new com.microsoft.graph.models.List();
        list.displayName = "PB";
        list.description = "MY Description";
        ListInfo listInfo = new ListInfo();
        listInfo.template = "documentLibrary";
        list.list = listInfo;
        ((ListCollectionRequest)graphClient.sites(siteId).lists().buildRequest(new Option[0])).post(list);
    }

    private static void createDriveInsideSite(GraphServiceClient<Request> graphClient, String siteId) {
        logger.debug("..before creating PB.....");
        com.microsoft.graph.models.List list = new com.microsoft.graph.models.List();
        list.displayName = "PB";
        list.description = "MY Description";
        ListInfo listInfo = new ListInfo();
        listInfo.template = "documentLibrary";
        list.list = listInfo;
        ((ListCollectionRequest)graphClient.sites(siteId).lists().buildRequest(new Option[0])).post(list);
    }

    private synchronized void setUserElement(PciAuthorizationTokenElement pciTokenElement, boolean isSync, String emailId, User user, String deviceUUID, String actualUserName) {
        logger.error("MAP-VAL................" + this.userCountMap + "...." + emailId);
        if (this.userCountMap.get(actualUserName) == null) {
            ArrayList<Integer> folderNameList;
            logger.debug("inside getUserElement nulll " + actualUserName);
            String lastCloudStoragePath = this.checkOneDriveStoragePath(pciTokenElement.getUserName(), isSync, user);
            int count = this.getCountOFFilesInFolder(pciTokenElement, lastCloudStoragePath, deviceUUID);
            logger.debug(".......folder count before assigning setuserElement..... " + count);
            while (count >= 4000 && (count = this.getCountOFFilesInFolder(pciTokenElement, lastCloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList = this.splitPathAndGetFolderDepth(lastCloudStoragePath), count), deviceUUID)) >= 4000) {
            }
            logger.debug(".......folder count after assigning setuserElement..... " + count + "......." + lastCloudStoragePath);
            UserOdbElement userOdbElement = new UserOdbElement(count, System.currentTimeMillis(), lastCloudStoragePath);
            this.userCountMap.put(actualUserName, userOdbElement);
        }
    }

    private synchronized void updateOdbCount(boolean isSync, String userName, int count, String emailId, PciAuthorizationTokenElement pciTokenElement, String deviceUUID, String actualUserName) {
        if (this.userCountMap.get(actualUserName).getCount() >= 4000) {
            ArrayList<Integer> folderNameList = this.splitPathAndGetFolderDepth(this.userCountMap.get(actualUserName).getPath());
            String cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, this.userCountMap.get(actualUserName).getCount());
            int filesInFoldercount = this.getCountOFFilesInFolder(pciTokenElement, cloudStoragePath, deviceUUID);
            logger.debug(".......folder count before assigning..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount);
            if (filesInFoldercount != 0 && filesInFoldercount < 4000) {
                this.userCountMap.get(actualUserName).setCount(filesInFoldercount + 1);
            } else {
                while (filesInFoldercount >= 4000) {
                    logger.error("...greater than 4000.....check here... " + emailId);
                    folderNameList = this.splitPathAndGetFolderDepth(cloudStoragePath);
                    filesInFoldercount = this.getCountOFFilesInFolder(pciTokenElement, cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, filesInFoldercount), deviceUUID);
                    if (filesInFoldercount >= 4000) continue;
                }
                logger.debug(".......folder count after finding correct path..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount);
                this.userCountMap.get(actualUserName).setCount(1);
                this.userCountMap.get(actualUserName).setPath(cloudStoragePath);
                this.utilService.updateUserStoragePath(1, userName, this.userCountMap.get(actualUserName).getPath(), isSync);
                Set<String> values = this.userCountMap.keySet();
                for (String user : values) {
                    logger.debug(".................users in memcached...." + user);
                }
            }
        } else {
            this.userCountMap.get(actualUserName).setCount(count + 1);
        }
    }

    private synchronized void updateOdbCountForSPUsingGraph(boolean isSync, String userName, int count, String deviceUUID, String actualUserName, User user, String siteName) {
        if (this.userCountMap.get(actualUserName).getCount() >= 4000) {
            ArrayList<Integer> folderNameList = this.splitPathAndGetFolderDepth(this.userCountMap.get(actualUserName).getPath());
            String cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, this.userCountMap.get(actualUserName).getCount());
            int filesInFoldercount = this.getCountOFFilesInFolderForSPUsingGraph(deviceUUID, cloudStoragePath, user, siteName);
            logger.debug(".......folder count before assigning..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount);
            if (filesInFoldercount != 0 && filesInFoldercount < 4000) {
                this.userCountMap.get(actualUserName).setCount(filesInFoldercount + 1);
            } else {
                while (filesInFoldercount >= 4000) {
                    logger.error("...greater than 4000.....check here... " + userName);
                    folderNameList = this.splitPathAndGetFolderDepth(cloudStoragePath);
                    filesInFoldercount = this.getCountOFFilesInFolderForSPUsingGraph(deviceUUID, cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, filesInFoldercount), user, siteName);
                    if (filesInFoldercount >= 4000) continue;
                }
                logger.debug(".......folder count after finding correct path..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount);
                this.userCountMap.get(actualUserName).setCount(1);
                this.userCountMap.get(actualUserName).setPath(cloudStoragePath);
                this.utilService.updateUserStoragePath(1, userName, this.userCountMap.get(actualUserName).getPath(), isSync);
            }
        } else {
            this.userCountMap.get(actualUserName).setCount(count + 1);
        }
    }

    private synchronized void updateOdbCountUsingGraph(boolean isSync, String userName, int count, String emailId, String deviceUUID, String actualUserName, User user) {
        if (this.userCountMap.get(actualUserName).getCount() >= 4000) {
            ArrayList<Integer> folderNameList = this.splitPathAndGetFolderDepth(this.userCountMap.get(actualUserName).getPath());
            String cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, this.userCountMap.get(actualUserName).getCount());
            int filesInFoldercount = this.getCountOFFilesInFolderUsingGraph(emailId, deviceUUID, cloudStoragePath, user);
            logger.debug(".......folder count before assigning..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount);
            if (filesInFoldercount != 0 && filesInFoldercount < 4000) {
                this.userCountMap.get(actualUserName).setCount(filesInFoldercount + 1);
            } else {
                while (filesInFoldercount >= 4000) {
                    logger.error("...greater than 4000.....check here... " + emailId);
                    folderNameList = this.splitPathAndGetFolderDepth(cloudStoragePath);
                    filesInFoldercount = this.getCountOFFilesInFolderUsingGraph(emailId, deviceUUID, cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, filesInFoldercount), user);
                    if (filesInFoldercount >= 4000) continue;
                }
                logger.debug(".......folder count after finding correct path..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount);
                this.userCountMap.get(actualUserName).setCount(1);
                this.userCountMap.get(actualUserName).setPath(cloudStoragePath);
                this.utilService.updateUserStoragePath(1, userName, this.userCountMap.get(actualUserName).getPath(), isSync);
            }
        } else {
            this.userCountMap.get(actualUserName).setCount(count + 1);
        }
    }

    public boolean isODBCountApiCallReq(String userName) {
        boolean isODBCountApiCallReq = true;
        if (this.userCountMap.get(userName) != null && this.userCountMap.get(userName).getCount() < 4000 && this.userCountMap.get(userName).getCount() % PCHelperConstant.getODBCallFrequency() != 0) {
            isODBCountApiCallReq = false;
        }
        return isODBCountApiCallReq;
    }

    public FileStatusElement uploadToODB(PciAuthorizationTokenElement pciTokenElement, boolean isSync, FileStatusElement fileStatusElement, File encryptedFile, String lastStoragePathForSameFile, String deviceUUID, String actualUserName, String gateWayName, String uplodingFileName, boolean isChunkDeleteProcessStarted) {
        User user = this.utilService.getUserInfoByName(1, pciTokenElement.getUserName());
        String emailId = user.getOdbLoginId();
        boolean muxedEnabled = PCHelperConstant.isMuxedEnabled();
        if (muxedEnabled && StringUtils.isEmpty((Object)emailId)) {
            this.utilService.updateUserBackupTargetStatus(1, user.getUserName(), 204);
            fileStatusElement.setUploadStatus(false);
            logger.debug("...muxedEnabled..." + muxedEnabled + "...user OdbLoginId is empty or return...");
            return fileStatusElement;
        }
        if (StringUtils.isEmpty((Object)emailId)) {
            emailId = user.getEmailId();
        }
        logger.debug("Email Id>>>>>" + emailId + "....user name:" + user.getUserName());
        boolean isOdbApiCallRequired = this.isODBCountApiCallReq(emailId);
        if (this.userCountMap.get(actualUserName) == null) {
            this.setUserElement(pciTokenElement, isSync, emailId, user, deviceUUID, actualUserName);
        } else {
            this.setCountForUser(pciTokenElement, isSync, pciTokenElement.getUserName(), isOdbApiCallRequired, emailId, deviceUUID, actualUserName);
        }
        logger.debug(emailId + " before  setCountForUser.......... " + isOdbApiCallRequired);
        String userStoragepath = this.userCountMap.get(actualUserName).getPath();
        if (StringUtils.isEmpty((Object)userStoragepath)) {
            userStoragepath = isSync ? user.getCloudSyncStoragePath() : user.getCloudBkpStoragePath();
            if (StringUtils.isEmpty((Object)userStoragepath)) {
                userStoragepath = "1";
            }
            logger.debug("....user storagepath for user ..." + user.getUserName() + "....path...." + userStoragepath);
        }
        logger.error(userStoragepath + " latest COUNT>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> " + this.userCountMap.get(actualUserName).getCount());
        FileStatusElement elementAfterUpload = this.office365UploadService.uploadFileToODB(pciTokenElement.getAccessToken(), pciTokenElement, encryptedFile, userStoragepath, deviceUUID, gateWayName, uplodingFileName, fileStatusElement, isChunkDeleteProcessStarted);
        String encodedFileName = elementAfterUpload.getEncodedFileName();
        fileStatusElement.setEncodedFileName(encodedFileName);
        fileStatusElement.setUploadStatuscode(elementAfterUpload.getUploadStatuscode());
        if (!StringUtils.isEmpty((Object)elementAfterUpload.getOdbLoginId())) {
            fileStatusElement.setOdbLoginId(elementAfterUpload.getOdbLoginId());
        }
        logger.debug(" END OF next file ..... " + userStoragepath);
        fileStatusElement.setCloudStoragePath(userStoragepath);
        fileStatusElement.setUploadStatus(true);
        if (StringUtils.isEmpty((Object)encodedFileName)) {
            fileStatusElement.setUploadStatus(false);
            logger.debug("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount());
            if (this.userCountMap.get(actualUserName) != null) {
                logger.debug("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount());
                this.decreOdbCount(this.userCountMap.get(actualUserName).getCount(), actualUserName);
            }
        }
        if (this.userCountMap.size() > 500) {
            this.removeOldUser();
        }
        return fileStatusElement;
    }

    public FileStatusElement uploadToODBUsingGraph(PciAuthorizationTokenElement pciTokenElement, boolean isSync, FileStatusElement fileStatusElement, File encryptedFile, String lastStoragePathForSameFile, String deviceUUID, User user, String gateWayName, String uplodingFileName, String driveId, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        String emailId = user.getOdbLoginId();
        boolean muxedEnabled = PCHelperConstant.isMuxedEnabled();
        if (muxedEnabled && StringUtils.isEmpty((Object)emailId)) {
            this.utilService.updateUserBackupTargetStatus(1, user.getUserName(), 204);
            fileStatusElement.setUploadStatus(false);
            logger.debug("...muxedEnabled..." + muxedEnabled + "...user OdbLoginId is empty or return...");
            return fileStatusElement;
        }
        if (StringUtils.isEmpty((Object)emailId)) {
            emailId = user.getEmailId();
        }
        String actualUserName = user.getUserName();
        logger.debug("Email Id>>>>>" + emailId + "....user name:" + user.getUserName());
        boolean isOdbApiCallRequired = this.isODBCountApiCallReq(actualUserName);
        if (this.userCountMap.get(actualUserName) == null) {
            this.setUserElementUsingGraph(isSync, emailId, user, deviceUUID, actualUserName);
        } else {
            this.setCountForUserUsingGraph(isSync, pciTokenElement.getUserName(), isOdbApiCallRequired, emailId, deviceUUID, actualUserName, user);
        }
        logger.debug(emailId + " before  setCountForUser.......... " + isOdbApiCallRequired);
        String userStoragepath = this.userCountMap.get(actualUserName).getPath();
        if (StringUtils.isEmpty((Object)userStoragepath)) {
            userStoragepath = isSync ? user.getCloudSyncStoragePath() : user.getCloudBkpStoragePath();
            if (StringUtils.isEmpty((Object)userStoragepath)) {
                userStoragepath = "1";
            }
            logger.debug("....user storagepath for user ..." + user.getUserName() + "....path...." + userStoragepath);
        }
        logger.error(userStoragepath + " latest COUNT>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> " + this.userCountMap.get(actualUserName).getCount());
        FileStatusElement elementAfterUpload = this.graphUploadService.uploadFileToODB(pciTokenElement, encryptedFile, userStoragepath, deviceUUID, gateWayName, uplodingFileName, fileStatusElement, driveId, graphClient, okHttpClient);
        String encodedFileName = elementAfterUpload.getEncodedFileName();
        fileStatusElement.setEncodedFileName(encodedFileName);
        fileStatusElement.setUploadStatuscode(elementAfterUpload.getUploadStatuscode());
        if (!StringUtils.isEmpty((Object)elementAfterUpload.getOdbLoginId())) {
            fileStatusElement.setOdbLoginId(elementAfterUpload.getOdbLoginId());
        }
        logger.debug(" END OF next file ..... " + userStoragepath);
        fileStatusElement.setCloudStoragePath(userStoragepath);
        fileStatusElement.setUploadStatus(true);
        if (StringUtils.isEmpty((Object)encodedFileName)) {
            fileStatusElement.setUploadStatus(false);
            logger.debug("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount());
            if (this.userCountMap.get(actualUserName) != null) {
                logger.debug("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount());
                this.decreOdbCount(this.userCountMap.get(actualUserName).getCount(), actualUserName);
            }
        }
        if (this.userCountMap.size() > 500) {
            this.removeOldUser();
        }
        return fileStatusElement;
    }

    public FileStatusElement uploadToOneDriveUsingGraph(PciAuthorizationTokenElement pciTokenElement, File encryptedFile, String uplodingFileName, String driveId, String storagePath) {
        User user = this.utilService.getUserInfoByName(1, pciTokenElement.getUserName());
        String emailId = user.getEmailId();
        FileStatusElement elementAfterUpload = this.graphUploadService.uploadToOneDriveUsingGraph(pciTokenElement, encryptedFile, uplodingFileName, emailId, user.getUserName(), storagePath);
        return elementAfterUpload;
    }

    private synchronized void decreOdbCount(int count, String actualUserName) {
        if (this.userCountMap.get(actualUserName) != null) {
            this.userCountMap.get(actualUserName).setCount(count - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCountForUser(PciAuthorizationTokenElement pciTokenElement, boolean isSync, String userName, boolean isOdbApiCallRequired, String emailId, String deviceUUID, String actualUserName) {
        if (!this.userObjectMap.containsKey(emailId)) {
            Object object = new Object();
            this.userObjectMap.put(emailId, object);
        }
        Object obj = this.userObjectMap.get(emailId);
        logger.debug(obj + "..... obj synchronized ....." + emailId);
        if (isOdbApiCallRequired) {
            Object object = obj;
            synchronized (object) {
                if (this.isODBCountApiCallReq(emailId)) {
                    int count = this.getCountOFFilesInFolder(pciTokenElement, this.userCountMap.get(actualUserName).getPath(), deviceUUID);
                    if (count <= 0) {
                        count = this.userCountMap.get(actualUserName).getCount();
                    }
                    this.updateOdbCount(isSync, userName, count, emailId, pciTokenElement, deviceUUID, actualUserName);
                } else {
                    this.updateOdbCount(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, pciTokenElement, deviceUUID, actualUserName);
                }
            }
            logger.debug("INSID isOdbApiCallRequired.....");
        } else {
            this.updateOdbCount(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, pciTokenElement, deviceUUID, actualUserName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCountForUserUsingGraph(boolean isSync, String userName, boolean isOdbApiCallRequired, String emailId, String deviceUUID, String actualUserName, User user) {
        if (!this.userObjectMap.containsKey(emailId)) {
            Object object = new Object();
            this.userObjectMap.put(emailId, object);
        }
        Object obj = this.userObjectMap.get(emailId);
        logger.debug(obj + "..... obj synchronized ....." + emailId + "...odbcall required..." + isOdbApiCallRequired);
        if (isOdbApiCallRequired) {
            Object object = obj;
            synchronized (object) {
                if (this.isODBCountApiCallReq(emailId)) {
                    int count = this.getCountOFFilesInFolderUsingGraph(emailId, deviceUUID, this.userCountMap.get(actualUserName).getPath(), user);
                    if (count <= 0) {
                        count = this.userCountMap.get(actualUserName).getCount();
                    }
                    this.updateOdbCountUsingGraph(isSync, userName, count, emailId, deviceUUID, actualUserName, user);
                } else {
                    this.updateOdbCountUsingGraph(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, deviceUUID, actualUserName, user);
                }
            }
            logger.debug("INSID isOdbApiCallRequired.....");
        } else {
            this.updateOdbCountUsingGraph(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, deviceUUID, actualUserName, user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCountForUserForSPUsingGraph(boolean isSync, String userName, boolean isOdbApiCallRequired, String emailId, String deviceUUID, String actualUserName, User user, String siteName) {
        if (!this.userObjectMap.containsKey(emailId)) {
            Object object = new Object();
            this.userObjectMap.put(emailId, object);
        }
        Object obj = this.userObjectMap.get(emailId);
        logger.debug(obj + "..... obj synchronized ....." + emailId + "...odbcall required..." + isOdbApiCallRequired);
        if (isOdbApiCallRequired) {
            Object object = obj;
            synchronized (object) {
                if (this.isODBCountApiCallReq(emailId)) {
                    int count = this.getCountOFFilesInFolderForSPUsingGraph(deviceUUID, this.userCountMap.get(actualUserName).getPath(), user, siteName);
                    if (count <= 0) {
                        count = this.userCountMap.get(actualUserName).getCount();
                    }
                    this.updateOdbCountForSPUsingGraph(isSync, userName, count, deviceUUID, actualUserName, user, siteName);
                } else {
                    this.updateOdbCountForSPUsingGraph(isSync, userName, this.userCountMap.get(actualUserName).getCount(), deviceUUID, actualUserName, user, siteName);
                }
            }
            logger.debug("INSID isOdbApiCallRequired.....");
        } else {
            this.updateOdbCountForSPUsingGraph(isSync, userName, this.userCountMap.get(actualUserName).getCount(), deviceUUID, actualUserName, user, siteName);
        }
    }

    private void removeOldUser() {
        HashMap<String, Long> userMap = new HashMap<String, Long>();
        for (Map.Entry<String, UserOdbElement> entry : this.userCountMap.entrySet()) {
            String key = entry.getKey();
            UserOdbElement userOdbElement = entry.getValue();
            userMap.put(key, userOdbElement.getTimeMillis());
        }
        String userToBeRemoved = Collections.min(userMap.entrySet(), new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return o1.getValue().intValue() - o2.getValue().intValue();
            }
        }).getKey();
        if (!StringUtils.isEmpty((Object)userToBeRemoved)) {
            Long oldestTimeStamp = (Long)userMap.get(userToBeRemoved);
            int fiveMinsInactivePeriod = 300000;
            if (oldestTimeStamp != null && System.currentTimeMillis() > oldestTimeStamp + (long)fiveMinsInactivePeriod) {
                logger.debug("removing user .... " + userToBeRemoved);
                this.userCountMap.remove(userToBeRemoved);
            }
        }
    }

    private int getCountOFFilesInFolder(PciAuthorizationTokenElement pciTokenElement, String lastCloudStoragePath, String deviceUUID) {
        return this.office365UploadService.getCountOfFilesInFolder(pciTokenElement, lastCloudStoragePath, deviceUUID);
    }

    private synchronized String checkOneDriveStoragePath(String userName, boolean isSync, User user) {
        String cloudStoragePath = "1";
        if (isSync) {
            if (!StringUtils.isEmpty((Object)user.getCloudSyncStoragePath())) {
                cloudStoragePath = user.getCloudSyncStoragePath();
            }
        } else if (!StringUtils.isEmpty((Object)user.getCloudBkpStoragePath())) {
            cloudStoragePath = user.getCloudBkpStoragePath();
        }
        if (StringUtils.isEmpty((Object)cloudStoragePath)) {
            cloudStoragePath = "1";
        }
        logger.debug(userName + "Inside check onedrivepath>>>>>>>>>>>>" + cloudStoragePath);
        return cloudStoragePath;
    }

    private String checkOneDriveStoragePathAndCount(ArrayList<Integer> folderNameList, int count) {
        int countTemp = count;
        String cloudStoragePath = "";
        int folderDepthSize = folderNameList.size();
        int folderValue = folderNameList.get(0);
        if (folderDepthSize == 1 && folderValue <= 900) {
            logger.debug("Folder DEpth Size 1 folder value>>>>>>" + folderValue);
            if (countTemp < 4000) {
                cloudStoragePath = String.valueOf(folderValue);
                logger.debug("Folder DEpth Size 1 folder value count less than 500>>>>>>." + countTemp);
            } else if (folderValue < 900) {
                countTemp = 0;
                folderNameList.set(0, folderValue + 1);
                cloudStoragePath = String.valueOf(folderValue + 1);
                logger.debug("count >= MAX_FILE_COUNT ........... " + cloudStoragePath);
            } else if (folderValue >= 900) {
                folderNameList.clear();
                countTemp = 0;
                folderNameList.add(0, 1);
                folderNameList.add(1, 1);
                cloudStoragePath = "1/1";
                logger.debug("folderValue >= 900 ........... " + cloudStoragePath);
            }
            ++countTemp;
        } else {
            int lastFolder = folderNameList.get(folderDepthSize - 1);
            int previousFolder = 0;
            if (folderDepthSize > 1) {
                previousFolder = folderNameList.get(folderDepthSize - 2);
            }
            if (lastFolder <= 900) {
                if (countTemp < 4000) {
                    cloudStoragePath = String.valueOf(previousFolder + "/" + lastFolder);
                    logger.debug("else count < MAX_FILE_COUNT ........... " + cloudStoragePath);
                } else if (lastFolder < 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, lastFolder + 1);
                    cloudStoragePath = String.valueOf(previousFolder + "/" + ++lastFolder);
                    logger.debug("else count >= MAX_FILE_COUNT ........... " + cloudStoragePath);
                } else if (lastFolder >= 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, 1);
                    if (folderDepthSize > 1) {
                        folderNameList.set(folderDepthSize - 2, previousFolder + 1);
                    }
                    cloudStoragePath = ++previousFolder + "/1";
                    logger.debug("else lastFolder >= 900 ........... " + cloudStoragePath);
                }
            } else if (lastFolder >= 900) {
                countTemp = 0;
                folderNameList.set(folderDepthSize - 1, 1);
                if (folderDepthSize > 1) {
                    folderNameList.set(folderDepthSize - 2, previousFolder + 1);
                }
                cloudStoragePath = ++previousFolder + "/1";
                logger.debug("else lastFolder >= 900 ........... " + cloudStoragePath);
            }
            ++countTemp;
        }
        logger.debug("4000 max size " + cloudStoragePath + " endo of method ........" + countTemp);
        return cloudStoragePath;
    }

    private ArrayList<Integer> splitPathAndGetFolderDepth(String cloudStoragePath) {
        ArrayList<Integer> pathListNumbers = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)cloudStoragePath)) {
            String[] pathList;
            for (String path : pathList = cloudStoragePath.split("/")) {
                pathListNumbers.add(Integer.parseInt(path));
            }
        } else {
            pathListNumbers.add(1);
        }
        return pathListNumbers;
    }

    public FileStatusElement deleteFromODB(PciAuthorizationTokenElement pciTokenElement, String fileNameTodownload, String lastStoragePathForSameFile, String deviceUUID) {
        return this.office365UploadService.deleteFileFromODB(pciTokenElement, fileNameTodownload, lastStoragePathForSameFile, deviceUUID);
    }

    public void updateBkpOverviewForDeletedFiles(int cloudId, String deviceUUID, Long deletedFileSize) {
        logger.debug(".....processing for thread...." + Thread.currentThread().getName());
        try {
            long updatedSize = -deletedFileSize.longValue();
            logger.debug(deviceUUID + "....updateBkpOverviewForDeletedFiles%%......" + updatedSize + "...rem..." + updatedSize);
            this.backupOverViewDao.updateSizeDeviceBackupOverView(cloudId, deviceUUID, Long.valueOf(updatedSize), null, null, null);
        }
        catch (Exception e) {
            logger.error("...Exception :" + e.getMessage());
        }
        catch (Error ee) {
            logger.error("...Exception :" + ee.getMessage());
        }
    }

    public void updateSizeInDeviceBackupOverview(int cloudId, String deviceUUID, Long sizeToUpdatePG, Long sizeToUpdateInCloud, Long latestVersionSize, Long pgCompressedSize) {
        logger.debug(".....processing for thread...." + Thread.currentThread().getName() + " sizeToUpdatePG " + sizeToUpdatePG + " sizeToUpdateInCloud " + sizeToUpdateInCloud + " latestVersionSize " + latestVersionSize + " pgCompressedSize " + pgCompressedSize);
        this.backupOverViewDao.updateSizeDeviceBackupOverView(cloudId, deviceUUID, sizeToUpdatePG, sizeToUpdateInCloud, latestVersionSize, pgCompressedSize);
    }

    public FileStatusElement deleteFromODBUsingGraph(String fileName, String cloudStoragePath, String deviceUUID, String driveId) {
        return this.graphUploadService.deleteFileFromODB(fileName, cloudStoragePath, deviceUUID, driveId);
    }

    public FileStatusElement uploadToSPUsingGraph(String driveId, boolean isSync, FileStatusElement fileStatusElement, File encryptedFile, String lastStoragePathForSameFile, String deviceUUID, User user, String gateWayName, String uplodingFileName, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient, String storagePooldestination) {
        String emailId = user.getOdbLoginId();
        boolean muxedEnabled = PCHelperConstant.isMuxedEnabled();
        if (muxedEnabled && StringUtils.isEmpty((Object)emailId)) {
            this.utilService.updateUserBackupTargetStatus(1, user.getUserName(), 204);
            fileStatusElement.setUploadStatus(false);
            logger.debug("...muxedEnabled..." + muxedEnabled + "...user OdbLoginId is empty or return...");
            return fileStatusElement;
        }
        if (StringUtils.isEmpty((Object)emailId)) {
            emailId = user.getEmailId();
        }
        String actualUserName = user.getUserName();
        logger.debug("Email Id>>>>>" + emailId + "....user name:" + user.getUserName());
        boolean isOdbApiCallRequired = this.isODBCountApiCallReq(actualUserName);
        if (this.userCountMap.get(actualUserName) == null) {
            this.setUserElementForSPUsingGraph(isSync, user, deviceUUID, actualUserName, storagePooldestination);
        } else {
            this.setCountForUserForSPUsingGraph(isSync, actualUserName, isOdbApiCallRequired, emailId, deviceUUID, actualUserName, user, storagePooldestination);
        }
        logger.debug(emailId + " before  setCountForUser1.......... " + isOdbApiCallRequired);
        logger.debug("....userCountMap for user ..." + this.userCountMap);
        UserOdbElement userOdbElement = new UserOdbElement(1, System.currentTimeMillis(), "1");
        this.userCountMap.put(actualUserName, userOdbElement);
        String userStoragepath = this.userCountMap.get(actualUserName).getPath();
        if (StringUtils.isEmpty((Object)userStoragepath)) {
            userStoragepath = isSync ? user.getCloudSyncStoragePath() : user.getCloudBkpStoragePath();
            if (StringUtils.isEmpty((Object)userStoragepath)) {
                userStoragepath = "1";
            }
            logger.debug("....user storagepath for user ..." + user.getUserName() + "....path...." + userStoragepath);
        }
        logger.error(userStoragepath + " latest COUNT>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> " + this.userCountMap.get(actualUserName).getCount());
        FileStatusElement elementAfterUpload = this.graphUploadService.uploadFileToSP(driveId, encryptedFile, userStoragepath, deviceUUID, gateWayName, uplodingFileName, fileStatusElement, graphClient, okHttpClient, storagePooldestination, actualUserName);
        String encodedFileName = elementAfterUpload.getEncodedFileName();
        fileStatusElement.setEncodedFileName(encodedFileName);
        fileStatusElement.setUploadStatuscode(elementAfterUpload.getUploadStatuscode());
        if (!StringUtils.isEmpty((Object)elementAfterUpload.getOdbLoginId())) {
            fileStatusElement.setOdbLoginId(elementAfterUpload.getOdbLoginId());
        }
        logger.debug(" END OF next file ..... " + userStoragepath);
        fileStatusElement.setCloudStoragePath(userStoragepath);
        fileStatusElement.setUploadStatus(true);
        if (StringUtils.isEmpty((Object)encodedFileName)) {
            fileStatusElement.setUploadStatus(false);
            logger.debug("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount());
            if (this.userCountMap.get(actualUserName) != null) {
                logger.debug("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount());
                this.decreOdbCount(this.userCountMap.get(actualUserName).getCount(), actualUserName);
            }
        }
        if (this.userCountMap.size() > 500) {
            this.removeOldUser();
        }
        return fileStatusElement;
    }

    public static Drive getDriveForUser(int cloudId, String userName) {
        Drive drive = null;
        try {
            GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + userName + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (com.microsoft.graph.models.User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            if (StringUtils.isEmpty((Object)userId)) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + userName + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                for (com.microsoft.graph.models.User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + userName);
            drive = graphClient.users(userId).drive().buildRequest(new Option[0]).get();
            if (drive != null) {
                logger.debug(userName + "....drive id for user ... " + drive.id);
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    drive = OneDriveUtil.getDriveForUser(cloudId, userName);
                }
                catch (InterruptedException interruptedException) {}
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + userName);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return drive;
    }

    public class UserOdbElement {
        Integer count;
        Long timeMillis;
        String path;

        public UserOdbElement(Integer count, Long timeMillis, String path) {
            this.count = count;
            this.timeMillis = timeMillis;
            this.path = path;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Long getTimeMillis() {
            return this.timeMillis;
        }

        public void setTimeMillis(Long timeMillis) {
            this.timeMillis = timeMillis;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

