/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.util.CollectionUtils;

public class NegativeVersionUtility {
    static AtomicInteger devcount = new AtomicInteger();

    public static void main(String[] args) throws ConfigurationException {
        try {
            PropertiesConfiguration config = null;
            config = new PropertiesConfiguration(args[0]);
            String mongoIP = config.getProperty("mongoIP").toString();
            String mongoPort = config.getProperty("mongoPort").toString();
            String deviceUUIDList = "";
            if (config.getProperty("deviceUUID") != null) {
                deviceUUIDList = config.getProperty("deviceUUID").toString();
            }
            if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
                System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
                throw new ArrayIndexOutOfBoundsException();
            }
            System.out.println("mongo IP:" + mongoIP);
            String connectionUri = "mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001";
            MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
            builder.threadsAllowedToBlockForConnectionMultiplier(5000);
            builder.connectionsPerHost(1000);
            builder.minConnectionsPerHost(250);
            MongoClientURI uri = new MongoClientURI(connectionUri, builder);
            MongoClient clientObj = new MongoClient(uri);
            MongoDatabase db = clientObj.getDatabase(uri.getDatabase());
            System.out.println("connectivity success  ");
            ArrayList<String> list = new ArrayList<String>();
            MongoCollection<Document> latestdeviceBkpOverviewColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
            DistinctIterable<String> iterable = latestdeviceBkpOverviewColl.distinct("deviceUUID", String.class);
            MongoCursor cursor = iterable.iterator();
            while (cursor.hasNext()) {
                String deviceUUID = (String)cursor.next();
                list.add(deviceUUID);
            }
            cursor.close();
            FindIterable<Document> devices = null;
            MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
            if (!StringUtils.isEmpty(deviceUUIDList)) {
                String[] deviceUUIDs;
                System.out.println("....deviceuuuid is mentioned.... so using it .. " + deviceUUIDList);
                list = new ArrayList();
                String[] stringArray = deviceUUIDs = deviceUUIDList.split(",");
                int n = deviceUUIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    String uuid = stringArray[n2];
                    uuid = uuid.replace("[", "");
                    uuid = uuid.replace("]", "");
                    uuid = uuid.trim();
                    list.add(uuid);
                    ++n2;
                }
                BasicDBObject inQuery = new BasicDBObject();
                inQuery.append("deviceUUID", new BasicDBObject("$in", list));
                devices = deviceColl.find(inQuery);
            } else if (!CollectionUtils.isEmpty(list)) {
                BasicDBObject ninQuery = new BasicDBObject();
                ninQuery.append("deviceUUID", new BasicDBObject("$nin", list));
                devices = deviceColl.find(ninQuery);
            } else {
                devices = deviceColl.find();
            }
            ArrayList<Device> devList = new ArrayList<Device>();
            for (Document dev : devices) {
                Device device2 = new Device();
                device2.setDeviceUUID(dev.getString("deviceUUID"));
                device2.setDestCollection(dev.getString("destCollection"));
                device2.setUserName(dev.getString("userName"));
                devList.add(device2);
            }
            System.out.println(String.valueOf(list.size()) + "...size..." + devList.size());
            list = null;
            devList.parallelStream().forEach(device -> NegativeVersionUtility.updateDevices(db, devList.size(), device));
            clientObj.close();
        }
        catch (Exception e) {
            System.out.println("Exception..." + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void updateDevices(MongoDatabase db, long devices, Device device) {
        String deviceUUID = device.getDeviceUUID();
        NegativeVersionUtility.updateLatestVerSizeForDevice(db, deviceUUID, device.getDestCollection(), device.getUserName(), devices);
    }

    private static void updateLatestVerSizeForDevice(MongoDatabase db, String deviceUUID, String destCollection, String userName, long devices) {
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("userName", userName));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        ArrayList allFoldersList = new ArrayList();
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");
        String strDate = dateFormat.format(date);
        System.out.println(String.valueOf(strDate) + "$$$$getting folders..........for device ......" + deviceUUID);
        MongoCollection<Document> bkpColl = db.getCollection(destCollection);
        FindIterable<Document> files = bkpColl.find(andQuery);
        files.forEach(document -> allFoldersList.add(document));
        files = null;
        date = Calendar.getInstance().getTime();
        strDate = dateFormat.format(date);
        System.out.println(String.valueOf(strDate) + "$$$$Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
        AtomicLong latestFileSizes = new AtomicLong();
        AtomicInteger folderCount = new AtomicInteger();
        AtomicLong allFileSizes = new AtomicLong();
        ForkJoinPool pool = new ForkJoinPool(20);
        boolean isFailure = false;
        try {
            allFoldersList.parallelStream().forEach(folder -> NegativeVersionUtility.getAllFoldersSize(deviceUUID, allFoldersList, bkpColl, latestFileSizes, folderCount, folder, userName, allFileSizes));
        }
        catch (Exception e) {
            isFailure = true;
        }
        date = Calendar.getInstance().getTime();
        strDate = dateFormat.format(date);
        System.out.println(String.valueOf(strDate) + "$$$$Total size...................................... :" + latestFileSizes.get() + " for deviceUUID " + deviceUUID);
        if (isFailure) {
            System.out.println("....failure for deviceuuid.." + deviceUUID);
        }
        if (!isFailure) {
            MongoCollection<Document> latestDeviceBkpOverviewColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
            andQuery = new BasicDBObject();
            whereQuery = new ArrayList();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            andQuery.put("$and", whereQuery);
            latestDeviceBkpOverviewColl.deleteMany(andQuery);
            Document doc = new Document();
            doc.put("deviceUUID", (Object)deviceUUID);
            doc.put("latestVersionsSize", (Object)latestFileSizes.get());
            latestDeviceBkpOverviewColl.insertOne(doc);
            MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
            Document deviceBkpOverviewInfo = (Document)deviceBkpOverviewColl.find(andQuery).first();
            System.out.println("......existing storageutilized....and update...." + deviceBkpOverviewInfo.get("storageUtilized") + "/" + allFileSizes.get());
            BasicDBObject updateFields = new BasicDBObject();
            BasicDBObject updateQuery = new BasicDBObject();
            updateFields.append("storageUtilized", allFileSizes.get());
            updateQuery.append("$set", updateFields);
            deviceBkpOverviewColl.updateOne(andQuery, updateQuery);
            devcount.incrementAndGet();
            date = Calendar.getInstance().getTime();
            strDate = dateFormat.format(date);
            long freeMemory = Runtime.getRuntime().freeMemory();
            System.out.println(String.valueOf(strDate) + "...." + freeMemory + "...." + userName + "....device" + " to update .######################.. " + deviceUUID + "...size va..." + latestFileSizes.get() + "/" + allFileSizes.get() + "....." + devcount.get() + "/" + devices);
        }
    }

    private static void getAllFoldersSize(String deviceUUID, List<Document> allFoldersList, MongoCollection bkpColl, AtomicLong latestFileSizes, AtomicInteger folderCount, Document folder, String userName, AtomicLong allFileSizes) {
        String folderName = "";
        folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
        BasicDBObject andQuery = new BasicDBObject();
        System.out.println(String.valueOf(deviceUUID) + "... processing..." + folderName);
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("userName", userName));
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("devicePath", folderName));
        whereQuery.add(new BasicDBObject("present", true));
        whereQuery.add(new BasicDBObject("folder", false));
        andQuery.put("$and", whereQuery);
        FindIterable files = bkpColl.find(andQuery);
        ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
        ArrayList allDocsList = new ArrayList();
        files.forEach(document -> allDocsList.add(document));
        for (Document document2 : allDocsList) {
            NegativeVersionUtility.addFilesToList(allFilesList, document2);
            if (document2.getLong("size") == null) continue;
            allFileSizes.addAndGet(document2.getLong("size"));
        }
        List<BackUpImage> list = NegativeVersionUtility.getFilteredBackupImageList(allFilesList);
        long folderSize = 0L;
        for (BackUpImage image : list) {
            latestFileSizes.addAndGet(image.getSize());
            folderSize += image.getSize();
        }
        allFilesList = new ArrayList();
        bkpColl = null;
        folderCount.incrementAndGet();
        System.out.println("... completed folders for device..." + deviceUUID + "...." + folderCount.get() + "/" + allFoldersList.size());
    }

    private static void addFilesToList(List<BackUpImage> allFilesList, Document document) {
        BackUpImage backUpImage = new BackUpImage();
        backUpImage.setDevicePath(document.getString("devicePath"));
        backUpImage.setFileName(document.getString("fileName"));
        backUpImage.setLastServerModifiedTime(document.getLong("lastServerModifiedTime"));
        if (!StringUtils.isEmpty(backUpImage.getDevicePath()) && !StringUtils.isEmpty(backUpImage.getFileName())) {
            backUpImage.setSize(document.getLong("size"));
            allFilesList.add(backUpImage);
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }
}

