/*
 * Decompiled with CFR 0.152.
 */
package sprinf;

import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GraphServiceClient;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class MainClass {
    public static void main(String[] args2) {
        Properties p = new Properties();
        String file = args2[0];
        try {
            p.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String clientId = p.getProperty("clientId");
        String clientSecret = p.getProperty("clientSecretId");
        String tenant = p.getProperty("tenant");
        String users = p.getProperty("id");
        List<String> items = Arrays.asList(users.split("\\s*,\\s*"));
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(clientSecret).tenantId(tenant)).build();
        List<String> scopes = Arrays.asList("https://graph.microsoft.com/.default");
        TokenCredentialAuthProvider tokenCredentialAuthProvider = new TokenCredentialAuthProvider(scopes, clientSecretCredential);
        IBaseClient graphClient = ((GraphServiceClient.Builder)GraphServiceClient.builder().authenticationProvider(tokenCredentialAuthProvider)).buildClient();
        ListIterator<String> it = items.listIterator();
        while (it.hasNext()) {
            User user = ((GraphServiceClient)graphClient).users(it.next()).buildRequest(new Option[0]).get();
            String userId = user.id;
            Drive drive = ((GraphServiceClient)graphClient).users(userId).drive().buildRequest(new Option[0]).select("quota").get();
            double total = drive.quota.total.longValue();
            double remaining = drive.quota.remaining.longValue();
            double used = drive.quota.used.longValue();
            String currentState = drive.quota.state;
            Long deletedFiles = drive.quota.deleted;
            System.out.println("----------------------");
            System.out.println("The Total Storage is " + MainClass.callTotal(total));
            System.out.println("The Used Storage is " + MainClass.callTotal(used));
            System.out.println("The Remaining Storage is " + MainClass.callTotal(remaining));
            System.out.println("The Current State of the OneDrive: " + currentState);
            System.out.println("The total deleted size is : " + MainClass.callTotal(deletedFiles.longValue()));
        }
    }

    private static String callTotal(double total) {
        double totalKb = total / 1024.0;
        double totalMb = totalKb / 1024.0;
        double totalGb = totalMb / 1024.0;
        DecimalFormat formatter = new DecimalFormat("#0000.0");
        String Finals = null;
        Finals = totalGb > 0.0 ? String.valueOf(formatter.format(totalGb)) + " GB" : (totalMb > 0.0 ? String.valueOf(formatter.format(totalMb)) + " MB" : String.valueOf(formatter.format(totalKb)) + " KB");
        return Finals;
    }
}

