/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import reactor.netty.channel.ChannelMetricsRecorder;

final class AddressResolverGroupMetrics<T extends SocketAddress>
extends AddressResolverGroup<T> {
    final AddressResolverGroup<T> resolverGroup;
    final ChannelMetricsRecorder recorder;

    AddressResolverGroupMetrics(AddressResolverGroup<T> resolverGroup, ChannelMetricsRecorder recorder) {
        this.resolverGroup = resolverGroup;
        this.recorder = recorder;
    }

    @Override
    protected AddressResolver<T> newResolver(EventExecutor executor) {
        final AddressResolver<T> resolver = this.resolverGroup.getResolver(executor);
        return new AddressResolver<T>(){

            @Override
            public boolean isSupported(SocketAddress address) {
                return resolver.isSupported(address);
            }

            @Override
            public boolean isResolved(SocketAddress address) {
                return resolver.isResolved(address);
            }

            @Override
            public Future<T> resolve(SocketAddress address) {
                return this.resolveInternal(address, () -> resolver.resolve(address));
            }

            @Override
            public Future<T> resolve(SocketAddress address, Promise<T> promise) {
                return this.resolveInternal(address, () -> resolver.resolve(address, promise));
            }

            @Override
            public Future<List<T>> resolveAll(SocketAddress address) {
                return this.resolveAllInternal(address, () -> resolver.resolveAll(address));
            }

            @Override
            public Future<List<T>> resolveAll(SocketAddress address, Promise<List<T>> promise) {
                return this.resolveAllInternal(address, () -> resolver.resolveAll(address, promise));
            }

            @Override
            public void close() {
                resolver.close();
            }

            Future<T> resolveInternal(SocketAddress address, Supplier<Future<T>> resolver2) {
                long resolveTimeStart = System.nanoTime();
                return resolver2.get().addListener(future -> this.record(resolveTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR", address));
            }

            Future<List<T>> resolveAllInternal(SocketAddress address, Supplier<Future<List<T>>> resolver2) {
                long resolveTimeStart = System.nanoTime();
                return resolver2.get().addListener(future -> this.record(resolveTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR", address));
            }

            void record(long resolveTimeStart, String status, SocketAddress remoteAddress) {
                AddressResolverGroupMetrics.this.recorder.recordResolveAddressTime(remoteAddress, Duration.ofNanos(System.nanoTime() - resolveTimeStart), status);
            }
        };
    }
}

