/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import io.netty.channel.ChannelDuplexHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Function;
import reactor.netty.http.server.logging.AccessLog;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.util.annotation.Nullable;

class BaseAccessLogHandler
extends ChannelDuplexHandler {
    static final String DEFAULT_LOG_FORMAT = "{} - {} [{}] \"{} {} {}\" {} {} {} ms";
    static final Function<AccessLogArgProvider, AccessLog> DEFAULT_ACCESS_LOG = args2 -> AccessLog.create(DEFAULT_LOG_FORMAT, BaseAccessLogHandler.applyAddress(args2.remoteAddress()), args2.user(), args2.zonedDateTime(), args2.method(), args2.uri(), args2.protocol(), args2.status(), args2.contentLength() > -1L ? Long.valueOf(args2.contentLength()) : "-", args2.duration());
    final Function<AccessLogArgProvider, AccessLog> accessLog;

    BaseAccessLogHandler(@Nullable Function<AccessLogArgProvider, AccessLog> accessLog) {
        this.accessLog = accessLog == null ? DEFAULT_ACCESS_LOG : accessLog;
    }

    static String applyAddress(@Nullable SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort();
        }
        return "-";
    }
}

