/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.transport.AddressUtils;

final class DefaultHttpForwardedHeaderHandler
implements BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> {
    static final DefaultHttpForwardedHeaderHandler INSTANCE = new DefaultHttpForwardedHeaderHandler();
    static final String FORWARDED_HEADER = "Forwarded";
    static final String X_FORWARDED_IP_HEADER = "X-Forwarded-For";
    static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    static final Pattern FORWARDED_HOST_PATTERN = Pattern.compile("host=\"?([^;,\"]+)\"?");
    static final Pattern FORWARDED_PROTO_PATTERN = Pattern.compile("proto=\"?([^;,\"]+)\"?");
    static final Pattern FORWARDED_FOR_PATTERN = Pattern.compile("for=\"?([^;,\"]+)\"?");

    DefaultHttpForwardedHeaderHandler() {
    }

    @Override
    public ConnectionInfo apply(ConnectionInfo connectionInfo, HttpRequest request) {
        String forwardedHeader = request.headers().get(FORWARDED_HEADER);
        if (forwardedHeader != null) {
            return this.parseForwardedInfo(connectionInfo, forwardedHeader);
        }
        return this.parseXForwardedInfo(connectionInfo, request);
    }

    private ConnectionInfo parseForwardedInfo(ConnectionInfo connectionInfo, String forwardedHeader) {
        Matcher forMatcher;
        Matcher protoMatcher;
        String forwarded = forwardedHeader.split(",", 2)[0];
        Matcher hostMatcher = FORWARDED_HOST_PATTERN.matcher(forwarded);
        if (hostMatcher.find()) {
            connectionInfo = connectionInfo.withHostAddress(AddressUtils.parseAddress(hostMatcher.group(1), connectionInfo.getHostAddress().getPort()));
        }
        if ((protoMatcher = FORWARDED_PROTO_PATTERN.matcher(forwarded)).find()) {
            connectionInfo = connectionInfo.withScheme(protoMatcher.group(1).trim());
        }
        if ((forMatcher = FORWARDED_FOR_PATTERN.matcher(forwarded)).find()) {
            connectionInfo = connectionInfo.withRemoteAddress(AddressUtils.parseAddress(forMatcher.group(1).trim(), connectionInfo.getRemoteAddress().getPort()));
        }
        return connectionInfo;
    }

    private ConnectionInfo parseXForwardedInfo(ConnectionInfo connectionInfo, HttpRequest request) {
        String protoHeader;
        String hostHeader;
        String ipHeader = request.headers().get(X_FORWARDED_IP_HEADER);
        if (ipHeader != null) {
            InetSocketAddress remoteAddress = AddressUtils.parseAddress(ipHeader.split(",", 2)[0], connectionInfo.getRemoteAddress().getPort());
            connectionInfo = connectionInfo.withRemoteAddress(remoteAddress);
        }
        if ((hostHeader = request.headers().get(X_FORWARDED_HOST_HEADER)) != null) {
            String portHeader = request.headers().get(X_FORWARDED_PORT_HEADER);
            InetSocketAddress hostAddress = connectionInfo.getHostAddress();
            if (portHeader != null) {
                int port;
                try {
                    port = Integer.parseInt(portHeader.split(",", 2)[0].trim());
                }
                catch (NumberFormatException e) {
                    port = hostAddress.getPort();
                }
                hostAddress = AddressUtils.createUnresolved(hostHeader.split(",", 2)[0].trim(), port);
            } else {
                hostAddress = AddressUtils.createUnresolved(hostHeader.split(",", 2)[0].trim(), hostAddress.getPort());
            }
            connectionInfo = connectionInfo.withHostAddress(hostAddress);
        }
        if ((protoHeader = request.headers().get(X_FORWARDED_PROTO_HEADER)) != null) {
            connectionInfo = connectionInfo.withScheme(protoHeader.split(",", 2)[0].trim());
        }
        return connectionInfo;
    }
}

