/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.tcp.SslProvider;

final class HttpClientSecure {
    static final Consumer<? super SslHandler> DEFAULT_HOSTNAME_VERIFICATION;
    static final reactor.netty.tcp.SslProvider HTTP2_SSL_PROVIDER;
    static final reactor.netty.tcp.SslProvider DEFAULT_HTTP_SSL_PROVIDER;
    static final reactor.netty.tcp.SslProvider DEFAULT_HTTP2_SSL_PROVIDER;

    private HttpClientSecure() {
    }

    static reactor.netty.tcp.SslProvider defaultSslProvider(HttpClientConfig config) {
        if (config.checkProtocol(2)) {
            return DEFAULT_HTTP2_SSL_PROVIDER;
        }
        return DEFAULT_HTTP_SSL_PROVIDER;
    }

    static boolean hasDefaultSslProvider(HttpClientConfig config) {
        return DEFAULT_HTTP_SSL_PROVIDER == config.sslProvider || DEFAULT_HTTP2_SSL_PROVIDER == config.sslProvider;
    }

    static reactor.netty.tcp.SslProvider sslProvider(reactor.netty.tcp.SslProvider sslProvider) {
        return reactor.netty.tcp.SslProvider.addHandlerConfigurator(sslProvider, DEFAULT_HOSTNAME_VERIFICATION);
    }

    static {
        reactor.netty.tcp.SslProvider sslProvider;
        DEFAULT_HOSTNAME_VERIFICATION = handler -> {
            SSLEngine sslEngine = handler.engine();
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        };
        try {
            SslProvider provider = SslProvider.isAlpnSupported(SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK;
            SslContextBuilder sslCtxBuilder = SslContextBuilder.forClient().sslProvider(provider).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, "h2", "http/1.1"));
            sslProvider = reactor.netty.tcp.SslProvider.builder().sslContext(sslCtxBuilder).defaultConfiguration(SslProvider.DefaultConfigurationType.H2).build();
        }
        catch (Exception e) {
            sslProvider = null;
        }
        HTTP2_SSL_PROVIDER = sslProvider;
        DEFAULT_HTTP_SSL_PROVIDER = reactor.netty.tcp.SslProvider.addHandlerConfigurator(reactor.netty.tcp.SslProvider.defaultClientProvider(), DEFAULT_HOSTNAME_VERIFICATION);
        DEFAULT_HTTP2_SSL_PROVIDER = reactor.netty.tcp.SslProvider.addHandlerConfigurator(HTTP2_SSL_PROVIDER, DEFAULT_HOSTNAME_VERIFICATION);
    }
}

