/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.ssl.OpenSsl;
import java.net.SocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.ByteBufMono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.NettyOutbound;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.http.Http2SettingsSpec;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.HttpResources;
import reactor.netty.http.client.Http2Resources;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.HttpClientConnect;
import reactor.netty.http.client.HttpClientFinalizer;
import reactor.netty.http.client.HttpClientForm;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.http.client.HttpClientSecure;
import reactor.netty.http.client.HttpClientTcpConfig;
import reactor.netty.http.client.HttpConnectionProvider;
import reactor.netty.http.client.HttpResponseDecoderSpec;
import reactor.netty.http.client.WebsocketClientSpec;
import reactor.netty.http.client.WebsocketFinalizer;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpClient;
import reactor.netty.tcp.TcpClientConfig;
import reactor.netty.transport.ClientTransport;
import reactor.util.Metrics;
import reactor.util.annotation.Nullable;

public abstract class HttpClient
extends ClientTransport<HttpClient, HttpClientConfig> {
    public static final String USER_AGENT = String.format("ReactorNetty/%s", HttpClient.reactorNettyVersion());
    static final String HTTP_SCHEME = "http";
    static final String HTTPS_SCHEME = "https";
    static final String WS_SCHEME = "ws";
    static final String WSS_SCHEME = "wss";

    public static HttpClient create() {
        return new HttpClientConnect(new HttpConnectionProvider(HttpResources.get(), Http2Resources::get));
    }

    public static HttpClient create(ConnectionProvider connectionProvider) {
        Objects.requireNonNull(connectionProvider, "connectionProvider");
        return new HttpClientConnect(new HttpConnectionProvider(connectionProvider));
    }

    @Deprecated
    public static HttpClient from(TcpClient tcpClient) {
        Objects.requireNonNull(tcpClient, "tcpClient");
        return HttpClientConnect.applyTcpClientConfig((TcpClientConfig)tcpClient.configuration());
    }

    public static HttpClient newConnection() {
        return new HttpClientConnect(new HttpConnectionProvider(ConnectionProvider.newConnection()));
    }

    public final HttpClient baseUrl(String baseUrl) {
        Objects.requireNonNull(baseUrl, "baseUrl");
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).baseUrl = baseUrl;
        return dup;
    }

    public final HttpClient compress(boolean compressionEnabled) {
        if (compressionEnabled) {
            if (!((HttpClientConfig)this.configuration()).acceptGzip) {
                HttpClient dup = (HttpClient)this.duplicate();
                HttpHeaders headers = ((HttpClientConfig)this.configuration()).headers.copy();
                headers.add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
                ((HttpClientConfig)dup.configuration()).headers = headers;
                ((HttpClientConfig)dup.configuration()).acceptGzip = true;
                return dup;
            }
        } else if (((HttpClientConfig)this.configuration()).acceptGzip) {
            HttpClient dup = (HttpClient)this.duplicate();
            if (HttpClient.isCompressing(((HttpClientConfig)this.configuration()).headers)) {
                HttpHeaders headers = ((HttpClientConfig)this.configuration()).headers.copy();
                headers.remove(HttpHeaderNames.ACCEPT_ENCODING);
                ((HttpClientConfig)dup.configuration()).headers = headers;
            }
            ((HttpClientConfig)dup.configuration()).acceptGzip = false;
            return dup;
        }
        return this;
    }

    public final HttpClient cookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "cookie");
        if (!cookie.value().isEmpty()) {
            HttpClient dup = (HttpClient)this.duplicate();
            HttpHeaders headers = ((HttpClientConfig)this.configuration()).headers.copy();
            headers.add((CharSequence)HttpHeaderNames.COOKIE, (Object)((HttpClientConfig)dup.configuration()).cookieEncoder.encode(cookie));
            ((HttpClientConfig)dup.configuration()).headers = headers;
            return dup;
        }
        return this;
    }

    public final HttpClient cookie(String name, Consumer<? super Cookie> cookieBuilder) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(cookieBuilder, "cookieBuilder");
        DefaultCookie cookie = new DefaultCookie(name, "");
        cookieBuilder.accept(cookie);
        return this.cookie(cookie);
    }

    public final HttpClient cookieCodec(ClientCookieEncoder encoder) {
        Objects.requireNonNull(encoder, "encoder");
        ClientCookieDecoder decoder = encoder == ClientCookieEncoder.LAX ? ClientCookieDecoder.LAX : ClientCookieDecoder.STRICT;
        return this.cookieCodec(encoder, decoder);
    }

    public final HttpClient cookieCodec(ClientCookieEncoder encoder, ClientCookieDecoder decoder) {
        Objects.requireNonNull(encoder, "encoder");
        Objects.requireNonNull(decoder, "decoder");
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).cookieEncoder = encoder;
        ((HttpClientConfig)dup.configuration()).cookieDecoder = decoder;
        return dup;
    }

    public final HttpClient cookiesWhen(String name, Function<? super Cookie, Mono<? extends Cookie>> cookieBuilder) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(cookieBuilder, "cookieBuilder");
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).deferredConf(config -> ((Mono)cookieBuilder.apply(new DefaultCookie(name, ""))).map(c -> {
            if (!c.value().isEmpty()) {
                HttpHeaders headers = ((HttpClientConfig)this.configuration()).headers.copy();
                headers.add((CharSequence)HttpHeaderNames.COOKIE, (Object)config.cookieEncoder.encode((Cookie)c));
                config.headers = headers;
            }
            return config;
        }));
        return dup;
    }

    public final RequestSender delete() {
        return this.request(HttpMethod.DELETE);
    }

    public final HttpClient disableRetry(boolean disableRetry) {
        if (disableRetry == ((HttpClientConfig)this.configuration()).retryDisabled) {
            return this;
        }
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).retryDisabled = disableRetry;
        return dup;
    }

    public final HttpClient doAfterRequest(BiConsumer<? super HttpClientRequest, ? super Connection> doAfterRequest) {
        Objects.requireNonNull(doAfterRequest, "doAfterRequest");
        HttpClient dup = (HttpClient)this.duplicate();
        BiConsumer<? super HttpClientRequest, ? super Connection> current = ((HttpClientConfig)this.configuration()).doAfterRequest;
        ((HttpClientConfig)dup.configuration()).doAfterRequest = current == null ? doAfterRequest : current.andThen(doAfterRequest);
        return dup;
    }

    public final HttpClient doAfterResponseSuccess(BiConsumer<? super HttpClientResponse, ? super Connection> doAfterResponseSuccess) {
        Objects.requireNonNull(doAfterResponseSuccess, "doAfterResponseSuccess");
        HttpClient dup = (HttpClient)this.duplicate();
        BiConsumer<? super HttpClientResponse, ? super Connection> current = ((HttpClientConfig)this.configuration()).doAfterResponseSuccess;
        ((HttpClientConfig)dup.configuration()).doAfterResponseSuccess = current == null ? doAfterResponseSuccess : current.andThen(doAfterResponseSuccess);
        return dup;
    }

    public final HttpClient doOnError(BiConsumer<? super HttpClientRequest, ? super Throwable> doOnRequestError, BiConsumer<? super HttpClientResponse, ? super Throwable> doOnResponseError) {
        Objects.requireNonNull(doOnRequestError, "doOnRequestError");
        Objects.requireNonNull(doOnResponseError, "doOnResponseError");
        HttpClient dup = (HttpClient)this.duplicate();
        BiConsumer<? super HttpClientRequest, ? super Throwable> currentRequestError = ((HttpClientConfig)this.configuration()).doOnRequestError;
        ((HttpClientConfig)dup.configuration()).doOnRequestError = currentRequestError == null ? doOnRequestError : currentRequestError.andThen(doOnRequestError);
        BiConsumer<? super HttpClientResponse, ? super Throwable> currentResponseError = ((HttpClientConfig)this.configuration()).doOnResponseError;
        ((HttpClientConfig)dup.configuration()).doOnResponseError = currentResponseError == null ? doOnResponseError : currentResponseError.andThen(doOnResponseError);
        return dup;
    }

    public final HttpClient doOnRedirect(BiConsumer<? super HttpClientResponse, ? super Connection> doOnRedirect) {
        Objects.requireNonNull(doOnRedirect, "doOnRedirect");
        HttpClient dup = (HttpClient)this.duplicate();
        BiConsumer<? super HttpClientResponse, ? super Connection> current = ((HttpClientConfig)this.configuration()).doOnRedirect;
        ((HttpClientConfig)dup.configuration()).doOnRedirect = current == null ? doOnRedirect : current.andThen(doOnRedirect);
        return dup;
    }

    public final HttpClient doOnRequest(BiConsumer<? super HttpClientRequest, ? super Connection> doOnRequest) {
        Objects.requireNonNull(doOnRequest, "doOnRequest");
        HttpClient dup = (HttpClient)this.duplicate();
        BiConsumer<? super HttpClientRequest, ? super Connection> current = ((HttpClientConfig)this.configuration()).doOnRequest;
        ((HttpClientConfig)dup.configuration()).doOnRequest = current == null ? doOnRequest : current.andThen(doOnRequest);
        return dup;
    }

    public final HttpClient doOnRequestError(BiConsumer<? super HttpClientRequest, ? super Throwable> doOnRequestError) {
        Objects.requireNonNull(doOnRequestError, "doOnRequestError");
        HttpClient dup = (HttpClient)this.duplicate();
        BiConsumer<? super HttpClientRequest, ? super Throwable> current = ((HttpClientConfig)this.configuration()).doOnRequestError;
        ((HttpClientConfig)dup.configuration()).doOnRequestError = current == null ? doOnRequestError : current.andThen(doOnRequestError);
        return dup;
    }

    public final HttpClient doOnResponse(BiConsumer<? super HttpClientResponse, ? super Connection> doOnResponse) {
        Objects.requireNonNull(doOnResponse, "doOnResponse");
        HttpClient dup = (HttpClient)this.duplicate();
        BiConsumer<? super HttpClientResponse, ? super Connection> current = ((HttpClientConfig)this.configuration()).doOnResponse;
        ((HttpClientConfig)dup.configuration()).doOnResponse = current == null ? doOnResponse : current.andThen(doOnResponse);
        return dup;
    }

    public final HttpClient doOnResponseError(BiConsumer<? super HttpClientResponse, ? super Throwable> doOnResponseError) {
        Objects.requireNonNull(doOnResponseError, "doOnResponseError");
        HttpClient dup = (HttpClient)this.duplicate();
        BiConsumer<? super HttpClientResponse, ? super Throwable> current = ((HttpClientConfig)this.configuration()).doOnResponseError;
        ((HttpClientConfig)dup.configuration()).doOnResponseError = current == null ? doOnResponseError : current.andThen(doOnResponseError);
        return dup;
    }

    public final HttpClient followRedirect(BiPredicate<HttpClientRequest, HttpClientResponse> predicate) {
        return this.followRedirect(predicate, (Consumer<HttpClientRequest>)null);
    }

    public final HttpClient followRedirect(BiPredicate<HttpClientRequest, HttpClientResponse> predicate, @Nullable BiConsumer<HttpHeaders, HttpClientRequest> redirectRequestBiConsumer) {
        Objects.requireNonNull(predicate, "predicate");
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).followRedirectPredicate = predicate;
        ((HttpClientConfig)dup.configuration()).redirectRequestBiConsumer = redirectRequestBiConsumer;
        ((HttpClientConfig)dup.configuration()).redirectRequestConsumer = null;
        return dup;
    }

    public final HttpClient followRedirect(BiPredicate<HttpClientRequest, HttpClientResponse> predicate, @Nullable Consumer<HttpClientRequest> redirectRequestConsumer) {
        Objects.requireNonNull(predicate, "predicate");
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).followRedirectPredicate = predicate;
        ((HttpClientConfig)dup.configuration()).redirectRequestBiConsumer = null;
        ((HttpClientConfig)dup.configuration()).redirectRequestConsumer = redirectRequestConsumer;
        return dup;
    }

    public final HttpClient followRedirect(boolean followRedirect) {
        if (!followRedirect && ((HttpClientConfig)this.configuration()).followRedirectPredicate == null && ((HttpClientConfig)this.configuration()).redirectRequestConsumer == null && ((HttpClientConfig)this.configuration()).redirectRequestBiConsumer == null) {
            return this;
        }
        return this.followRedirect(followRedirect, (Consumer<HttpClientRequest>)null);
    }

    public final HttpClient followRedirect(boolean followRedirect, @Nullable BiConsumer<HttpHeaders, HttpClientRequest> redirectRequestBiConsumer) {
        if (followRedirect) {
            return this.followRedirect(HttpClientConfig.FOLLOW_REDIRECT_PREDICATE, redirectRequestBiConsumer);
        }
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).followRedirectPredicate = null;
        ((HttpClientConfig)dup.configuration()).redirectRequestBiConsumer = null;
        ((HttpClientConfig)dup.configuration()).redirectRequestConsumer = null;
        return dup;
    }

    public final HttpClient followRedirect(boolean followRedirect, @Nullable Consumer<HttpClientRequest> redirectRequestConsumer) {
        if (followRedirect) {
            return this.followRedirect(HttpClientConfig.FOLLOW_REDIRECT_PREDICATE, redirectRequestConsumer);
        }
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).followRedirectPredicate = null;
        ((HttpClientConfig)dup.configuration()).redirectRequestBiConsumer = null;
        ((HttpClientConfig)dup.configuration()).redirectRequestConsumer = null;
        return dup;
    }

    public final ResponseReceiver<?> get() {
        return this.request(HttpMethod.GET);
    }

    public final ResponseReceiver<?> head() {
        return this.request(HttpMethod.HEAD);
    }

    public final HttpClient headers(Consumer<? super HttpHeaders> headerBuilder) {
        Objects.requireNonNull(headerBuilder, "headerBuilder");
        HttpClient dup = (HttpClient)this.duplicate();
        HttpHeaders headers = ((HttpClientConfig)this.configuration()).headers.copy();
        headerBuilder.accept(headers);
        ((HttpClientConfig)dup.configuration()).headers = headers;
        return dup;
    }

    public final HttpClient headersWhen(Function<? super HttpHeaders, Mono<? extends HttpHeaders>> headerBuilder) {
        Objects.requireNonNull(headerBuilder, "headerBuilder");
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).deferredConf(config -> ((Mono)headerBuilder.apply(config.headers.copy())).map(h2 -> {
            config.headers = h2;
            return config;
        }));
        return dup;
    }

    public final HttpClient http2Settings(Consumer<Http2SettingsSpec.Builder> http2Settings) {
        Objects.requireNonNull(http2Settings, "http2Settings");
        Http2SettingsSpec.Builder builder = Http2SettingsSpec.builder();
        http2Settings.accept(builder);
        Http2SettingsSpec settings = builder.build();
        if (settings.equals(((HttpClientConfig)this.configuration()).http2Settings)) {
            return this;
        }
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).http2Settings = settings;
        return dup;
    }

    public final HttpClient httpResponseDecoder(Function<HttpResponseDecoderSpec, HttpResponseDecoderSpec> responseDecoderOptions) {
        Objects.requireNonNull(responseDecoderOptions, "responseDecoderOptions");
        HttpResponseDecoderSpec decoder = responseDecoderOptions.apply(new HttpResponseDecoderSpec()).build();
        if (decoder.equals(((HttpClientConfig)this.configuration()).decoder)) {
            return this;
        }
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).decoder = decoder;
        return dup;
    }

    public final HttpClient keepAlive(boolean keepAlive) {
        HttpClient dup = (HttpClient)this.duplicate();
        HttpHeaders headers = ((HttpClientConfig)this.configuration()).headers.copy();
        HttpUtil.setKeepAlive(headers, HttpVersion.HTTP_1_1, keepAlive);
        ((HttpClientConfig)dup.configuration()).headers = headers;
        return dup;
    }

    public final HttpClient mapConnect(Function<? super Mono<? extends Connection>, ? extends Mono<? extends Connection>> connector) {
        Objects.requireNonNull(connector, "mapConnect");
        HttpClient dup = (HttpClient)this.duplicate();
        Function<? super Mono<? extends Connection>, ? extends Mono<? extends Connection>> currentConnector = ((HttpClientConfig)this.configuration()).connector;
        ((HttpClientConfig)dup.configuration()).connector = currentConnector == null ? connector : currentConnector.andThen(connector);
        return dup;
    }

    public final HttpClient metrics(boolean enable, Function<String, String> uriTagValue) {
        if (enable) {
            if (!Metrics.isInstrumentationAvailable()) {
                throw new UnsupportedOperationException("To enable metrics, you must add the dependency `io.micrometer:micrometer-core` to the class path first");
            }
            HttpClient dup = (HttpClient)this.duplicate();
            ((HttpClientConfig)dup.configuration()).metricsRecorder(() -> ((HttpClientConfig)this.configuration()).defaultMetricsRecorder());
            ((HttpClientConfig)dup.configuration()).uriTagValue = uriTagValue;
            return dup;
        }
        if (((HttpClientConfig)this.configuration()).metricsRecorder() != null) {
            HttpClient dup = (HttpClient)this.duplicate();
            ((HttpClientConfig)dup.configuration()).metricsRecorder(null);
            ((HttpClientConfig)dup.configuration()).uriTagValue = null;
            return dup;
        }
        return this;
    }

    @Override
    public final HttpClient metrics(boolean enable, Supplier<? extends ChannelMetricsRecorder> recorder) {
        return (HttpClient)super.metrics(enable, recorder);
    }

    public final HttpClient metrics(boolean enable, Supplier<? extends ChannelMetricsRecorder> recorder, Function<String, String> uriValue) {
        if (enable) {
            HttpClient dup = (HttpClient)this.duplicate();
            ((HttpClientConfig)dup.configuration()).metricsRecorder(recorder);
            ((HttpClientConfig)dup.configuration()).uriTagValue = uriValue;
            return dup;
        }
        if (((HttpClientConfig)this.configuration()).metricsRecorder() != null) {
            HttpClient dup = (HttpClient)this.duplicate();
            ((HttpClientConfig)dup.configuration()).metricsRecorder(null);
            ((HttpClientConfig)dup.configuration()).uriTagValue = null;
            return dup;
        }
        return this;
    }

    public final HttpClient noSSL() {
        if (((HttpClientConfig)this.configuration()).isSecure()) {
            HttpClient dup = (HttpClient)this.duplicate();
            ((HttpClientConfig)dup.configuration()).sslProvider = null;
            return dup;
        }
        return this;
    }

    @Override
    public final HttpClient observe(ConnectionObserver observer) {
        return (HttpClient)super.observe(observer);
    }

    public final ResponseReceiver<?> options() {
        return this.request(HttpMethod.OPTIONS);
    }

    public final RequestSender patch() {
        return this.request(HttpMethod.PATCH);
    }

    @Override
    public final HttpClient port(int port) {
        return (HttpClient)super.port(port);
    }

    public final RequestSender post() {
        return this.request(HttpMethod.POST);
    }

    public final HttpClient protocol(HttpProtocol ... supportedProtocols) {
        Objects.requireNonNull(supportedProtocols, "supportedProtocols");
        HttpClient dup = (HttpClient)this.duplicate();
        HttpClientConfig config = (HttpClientConfig)dup.configuration();
        config.protocols(supportedProtocols);
        boolean isH2c = config.checkProtocol(1);
        if ((!isH2c || config._protocols > 1) && HttpClientSecure.hasDefaultSslProvider(config)) {
            ((HttpClientConfig)dup.configuration()).sslProvider = HttpClientSecure.defaultSslProvider(config);
        }
        return dup;
    }

    public final RequestSender put() {
        return this.request(HttpMethod.PUT);
    }

    @Override
    public final HttpClient remoteAddress(Supplier<? extends SocketAddress> remoteAddressSupplier) {
        return (HttpClient)super.remoteAddress(remoteAddressSupplier);
    }

    public RequestSender request(HttpMethod method) {
        Objects.requireNonNull(method, "method");
        HttpClientFinalizer dup = new HttpClientFinalizer(new HttpClientConfig((HttpClientConfig)this.configuration()));
        dup.configuration().method = method;
        return dup;
    }

    public final HttpClient responseTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        if (Objects.equals(timeout2, ((HttpClientConfig)this.configuration()).responseTimeout)) {
            return this;
        }
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).responseTimeout = timeout2;
        return dup;
    }

    public final HttpClient secure() {
        SslProvider sslProvider = HttpClientSecure.defaultSslProvider((HttpClientConfig)this.configuration());
        if (sslProvider.equals(((HttpClientConfig)this.configuration()).sslProvider)) {
            return this;
        }
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).sslProvider = sslProvider;
        return dup;
    }

    public final HttpClient secure(Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        Objects.requireNonNull(sslProviderBuilder, "sslProviderBuilder");
        SslProvider.SslContextSpec builder = SslProvider.builder();
        sslProviderBuilder.accept(builder);
        SslProvider sslProvider = HttpClientSecure.sslProvider(((SslProvider.Builder)((Object)builder)).build());
        if (sslProvider.equals(((HttpClientConfig)this.configuration()).sslProvider)) {
            return this;
        }
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).sslProvider = sslProvider;
        return dup;
    }

    public HttpClient secure(SslProvider sslProvider) {
        Objects.requireNonNull(sslProvider, "sslProvider");
        HttpClient dup = (HttpClient)this.duplicate();
        ((HttpClientConfig)dup.configuration()).sslProvider = sslProvider;
        return dup;
    }

    @Deprecated
    public final HttpClient tcpConfiguration(Function<? super TcpClient, ? extends TcpClient> tcpMapper) {
        Objects.requireNonNull(tcpMapper, "tcpMapper");
        HttpClientTcpConfig tcpClient = new HttpClientTcpConfig(this);
        tcpMapper.apply(tcpClient);
        return tcpClient.httpClient;
    }

    @Override
    public Mono<Void> warmup() {
        return Mono.when(super.warmup(), Mono.fromRunnable(OpenSsl::version));
    }

    public final WebsocketSender websocket() {
        return this.websocket(WebsocketClientSpec.builder().build());
    }

    public final WebsocketSender websocket(WebsocketClientSpec websocketClientSpec) {
        Objects.requireNonNull(websocketClientSpec, "websocketClientSpec");
        WebsocketFinalizer dup = new WebsocketFinalizer(new HttpClientConfig((HttpClientConfig)this.configuration()));
        HttpClientConfig config = dup.configuration();
        config.websocketClientSpec = websocketClientSpec;
        return dup;
    }

    @Override
    public final HttpClient wiretap(boolean enable) {
        return (HttpClient)super.wiretap(enable);
    }

    static boolean isCompressing(HttpHeaders h2) {
        return h2.contains(HttpHeaderNames.ACCEPT_ENCODING, HttpHeaderValues.GZIP, true);
    }

    static String reactorNettyVersion() {
        return Optional.ofNullable(HttpClient.class.getPackage().getImplementationVersion()).orElse("dev");
    }

    public static interface RedirectSendHandler
    extends BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> {
    }

    public static interface WebsocketReceiver<S extends WebsocketReceiver<?>>
    extends UriConfiguration<S> {
        public Mono<? extends Connection> connect();

        public <V> Flux<V> handle(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<V>> var1);

        public ByteBufFlux receive();
    }

    public static interface ResponseReceiver<S extends ResponseReceiver<?>>
    extends UriConfiguration<S> {
        public Mono<HttpClientResponse> response();

        public <V> Flux<V> response(BiFunction<? super HttpClientResponse, ? super ByteBufFlux, ? extends Publisher<V>> var1);

        public <V> Flux<V> responseConnection(BiFunction<? super HttpClientResponse, ? super Connection, ? extends Publisher<V>> var1);

        public ByteBufFlux responseContent();

        public <V> Mono<V> responseSingle(BiFunction<? super HttpClientResponse, ? super ByteBufMono, ? extends Mono<V>> var1);
    }

    public static interface WebsocketSender
    extends WebsocketReceiver<WebsocketSender> {
        public WebsocketReceiver<?> send(Function<? super HttpClientRequest, ? extends Publisher<Void>> var1);
    }

    public static interface RequestSender
    extends ResponseReceiver<RequestSender> {
        public ResponseReceiver<?> send(Publisher<? extends ByteBuf> var1);

        public ResponseReceiver<?> send(BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> var1);

        default public ResponseReceiver<?> sendForm(BiConsumer<? super HttpClientRequest, HttpClientForm> formCallback) {
            return this.sendForm(formCallback, null);
        }

        public ResponseReceiver<?> sendForm(BiConsumer<? super HttpClientRequest, HttpClientForm> var1, @Nullable Consumer<Flux<Long>> var2);
    }

    public static interface UriConfiguration<S extends UriConfiguration<?>> {
        public S uri(String var1);

        public S uri(Mono<String> var1);

        public S uri(URI var1);
    }
}

