/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.math.ec;

import java.math.BigInteger;
import org.spongycastle.math.ec.AbstractECMultiplier;
import org.spongycastle.math.ec.ECPoint;

public class ZSignedDigitL2RMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        ECPoint addP = p.normalize();
        ECPoint subP = addP.negate();
        ECPoint R0 = addP;
        int n = k.bitLength();
        int s2 = k.getLowestSetBit();
        int i = n;
        while (--i > s2) {
            R0 = R0.twicePlus(k.testBit(i) ? addP : subP);
        }
        R0 = R0.timesPow2(s2);
        return R0;
    }
}

