/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.math.ec;

import java.math.BigInteger;
import org.spongycastle.math.ec.AbstractECMultiplier;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.math.ec.WNafUtil;

public class NafL2RMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        int[] naf = WNafUtil.generateCompactNaf(k);
        ECPoint addP = p.normalize();
        ECPoint subP = addP.negate();
        ECPoint R2 = p.getCurve().getInfinity();
        int i = naf.length;
        while (--i >= 0) {
            int ni = naf[i];
            int digit = ni >> 16;
            int zeroes = ni & 0xFFFF;
            R2 = R2.twicePlus(digit < 0 ? subP : addP);
            R2 = R2.timesPow2(zeroes);
        }
        return R2;
    }
}

