/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.math.ec;

import java.math.BigInteger;
import org.spongycastle.math.ec.AbstractECMultiplier;
import org.spongycastle.math.ec.ECPoint;

public class MontgomeryLadderMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        int n;
        ECPoint[] R2 = new ECPoint[]{p.getCurve().getInfinity(), p};
        int i = n = k.bitLength();
        while (--i >= 0) {
            int b = k.testBit(i) ? 1 : 0;
            int bp = 1 - b;
            R2[bp] = R2[bp].add(R2[b]);
            R2[b] = R2[b].twice();
        }
        return R2[0];
    }
}

