/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.spongycastle.crypto.tls.Certificate;
import org.spongycastle.crypto.tls.CertificateRequest;
import org.spongycastle.crypto.tls.CertificateStatus;
import org.spongycastle.crypto.tls.CipherSuite;
import org.spongycastle.crypto.tls.DTLSProtocol;
import org.spongycastle.crypto.tls.DTLSRecordLayer;
import org.spongycastle.crypto.tls.DTLSReliableHandshake;
import org.spongycastle.crypto.tls.DTLSTransport;
import org.spongycastle.crypto.tls.DatagramTransport;
import org.spongycastle.crypto.tls.DigitallySigned;
import org.spongycastle.crypto.tls.NewSessionTicket;
import org.spongycastle.crypto.tls.ProtocolVersion;
import org.spongycastle.crypto.tls.SecurityParameters;
import org.spongycastle.crypto.tls.SessionParameters;
import org.spongycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.spongycastle.crypto.tls.TlsAuthentication;
import org.spongycastle.crypto.tls.TlsClient;
import org.spongycastle.crypto.tls.TlsClientContextImpl;
import org.spongycastle.crypto.tls.TlsCredentials;
import org.spongycastle.crypto.tls.TlsExtensionsUtils;
import org.spongycastle.crypto.tls.TlsFatalAlert;
import org.spongycastle.crypto.tls.TlsHandshakeHash;
import org.spongycastle.crypto.tls.TlsKeyExchange;
import org.spongycastle.crypto.tls.TlsProtocol;
import org.spongycastle.crypto.tls.TlsSession;
import org.spongycastle.crypto.tls.TlsSessionImpl;
import org.spongycastle.crypto.tls.TlsSignerCredentials;
import org.spongycastle.crypto.tls.TlsUtils;
import org.spongycastle.util.Arrays;

public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSClientProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public DTLSTransport connect(TlsClient client, DatagramTransport transport) throws IOException {
        SessionParameters sessionParameters;
        if (client == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.entity = 1;
        ClientHandshakeState state = new ClientHandshakeState();
        state.client = client;
        state.clientContext = new TlsClientContextImpl(this.secureRandom, securityParameters);
        securityParameters.clientRandom = TlsProtocol.createRandomBlock(client.shouldUseGMTUnixTime(), state.clientContext.getNonceRandomGenerator());
        client.init(state.clientContext);
        DTLSRecordLayer recordLayer = new DTLSRecordLayer(transport, state.clientContext, client, 22);
        TlsSession sessionToResume = state.client.getSessionToResume();
        if (sessionToResume != null && sessionToResume.isResumable() && (sessionParameters = sessionToResume.exportSessionParameters()) != null) {
            state.tlsSession = sessionToResume;
            state.sessionParameters = sessionParameters;
        }
        try {
            return this.clientHandshake(state, recordLayer);
        }
        catch (TlsFatalAlert fatalAlert) {
            recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (IOException e) {
            recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState state, DTLSRecordLayer recordLayer) throws IOException {
        ProtocolVersion recordLayerVersion;
        SecurityParameters securityParameters = state.clientContext.getSecurityParameters();
        DTLSReliableHandshake handshake2 = new DTLSReliableHandshake(state.clientContext, recordLayer);
        byte[] clientHelloBody = this.generateClientHello(state, state.client);
        recordLayer.setWriteVersion(ProtocolVersion.DTLSv10);
        handshake2.sendMessage((short)1, clientHelloBody);
        DTLSReliableHandshake.Message serverMessage = handshake2.receiveMessage();
        while (serverMessage.getType() == 3) {
            ProtocolVersion client_version;
            recordLayerVersion = recordLayer.getReadVersion();
            if (!recordLayerVersion.isEqualOrEarlierVersionOf(client_version = state.clientContext.getClientVersion())) {
                throw new TlsFatalAlert(47);
            }
            recordLayer.setReadVersion(null);
            byte[] cookie = this.processHelloVerifyRequest(state, serverMessage.getBody());
            byte[] patched = DTLSClientProtocol.patchClientHelloWithCookie(clientHelloBody, cookie);
            handshake2.resetHandshakeMessagesDigest();
            handshake2.sendMessage((short)1, patched);
            serverMessage = handshake2.receiveMessage();
        }
        if (serverMessage.getType() != 2) {
            throw new TlsFatalAlert(10);
        }
        recordLayerVersion = recordLayer.getReadVersion();
        this.reportServerVersion(state, recordLayerVersion);
        recordLayer.setWriteVersion(recordLayerVersion);
        this.processServerHello(state, serverMessage.getBody());
        handshake2.notifyHelloComplete();
        DTLSClientProtocol.applyMaxFragmentLengthExtension(recordLayer, securityParameters.maxFragmentLength);
        if (state.resumedSession) {
            securityParameters.masterSecret = Arrays.clone(state.sessionParameters.getMasterSecret());
            recordLayer.initPendingEpoch(state.client.getCipher());
            byte[] expectedServerVerifyData = TlsUtils.calculateVerifyData(state.clientContext, "server finished", TlsProtocol.getCurrentPRFHash(state.clientContext, handshake2.getHandshakeHash(), null));
            this.processFinished(handshake2.receiveMessageBody((short)20), expectedServerVerifyData);
            byte[] clientVerifyData = TlsUtils.calculateVerifyData(state.clientContext, "client finished", TlsProtocol.getCurrentPRFHash(state.clientContext, handshake2.getHandshakeHash(), null));
            handshake2.sendMessage((short)20, clientVerifyData);
            handshake2.finish();
            state.clientContext.setResumableSession(state.tlsSession);
            state.client.notifyHandshakeComplete();
            return new DTLSTransport(recordLayer);
        }
        this.invalidateSession(state);
        if (state.selectedSessionID.length > 0) {
            state.tlsSession = new TlsSessionImpl(state.selectedSessionID, null);
        }
        if ((serverMessage = handshake2.receiveMessage()).getType() == 23) {
            this.processServerSupplementalData(state, serverMessage.getBody());
            serverMessage = handshake2.receiveMessage();
        } else {
            state.client.processServerSupplementalData(null);
        }
        state.keyExchange = state.client.getKeyExchange();
        state.keyExchange.init(state.clientContext);
        Certificate serverCertificate = null;
        if (serverMessage.getType() == 11) {
            serverCertificate = this.processServerCertificate(state, serverMessage.getBody());
            serverMessage = handshake2.receiveMessage();
        } else {
            state.keyExchange.skipServerCredentials();
        }
        if (serverCertificate == null || serverCertificate.isEmpty()) {
            state.allowCertificateStatus = false;
        }
        if (serverMessage.getType() == 22) {
            this.processCertificateStatus(state, serverMessage.getBody());
            serverMessage = handshake2.receiveMessage();
        }
        if (serverMessage.getType() == 12) {
            this.processServerKeyExchange(state, serverMessage.getBody());
            serverMessage = handshake2.receiveMessage();
        } else {
            state.keyExchange.skipServerKeyExchange();
        }
        if (serverMessage.getType() == 13) {
            this.processCertificateRequest(state, serverMessage.getBody());
            TlsUtils.trackHashAlgorithms(handshake2.getHandshakeHash(), state.certificateRequest.getSupportedSignatureAlgorithms());
            serverMessage = handshake2.receiveMessage();
        }
        if (serverMessage.getType() == 14) {
            if (serverMessage.getBody().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        handshake2.getHandshakeHash().sealHashAlgorithms();
        Vector clientSupplementalData = state.client.getClientSupplementalData();
        if (clientSupplementalData != null) {
            byte[] supplementalDataBody = DTLSClientProtocol.generateSupplementalData(clientSupplementalData);
            handshake2.sendMessage((short)23, supplementalDataBody);
        }
        if (state.certificateRequest != null) {
            state.clientCredentials = state.authentication.getClientCredentials(state.certificateRequest);
            Certificate clientCertificate = null;
            if (state.clientCredentials != null) {
                clientCertificate = state.clientCredentials.getCertificate();
            }
            if (clientCertificate == null) {
                clientCertificate = Certificate.EMPTY_CHAIN;
            }
            byte[] certificateBody = DTLSClientProtocol.generateCertificate(clientCertificate);
            handshake2.sendMessage((short)11, certificateBody);
        }
        if (state.clientCredentials != null) {
            state.keyExchange.processClientCredentials(state.clientCredentials);
        } else {
            state.keyExchange.skipClientCredentials();
        }
        byte[] clientKeyExchangeBody = this.generateClientKeyExchange(state);
        handshake2.sendMessage((short)16, clientKeyExchangeBody);
        TlsHandshakeHash prepareFinishHash = handshake2.prepareToFinish();
        securityParameters.sessionHash = TlsProtocol.getCurrentPRFHash(state.clientContext, prepareFinishHash, null);
        TlsProtocol.establishMasterSecret(state.clientContext, state.keyExchange);
        recordLayer.initPendingEpoch(state.client.getCipher());
        if (state.clientCredentials != null && state.clientCredentials instanceof TlsSignerCredentials) {
            TlsSignerCredentials signerCredentials = (TlsSignerCredentials)state.clientCredentials;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(state.clientContext, signerCredentials);
            byte[] hash = signatureAndHashAlgorithm == null ? securityParameters.getSessionHash() : prepareFinishHash.getFinalHash(signatureAndHashAlgorithm.getHash());
            byte[] signature = signerCredentials.generateCertificateSignature(hash);
            DigitallySigned certificateVerify = new DigitallySigned(signatureAndHashAlgorithm, signature);
            byte[] certificateVerifyBody = this.generateCertificateVerify(state, certificateVerify);
            handshake2.sendMessage((short)15, certificateVerifyBody);
        }
        byte[] clientVerifyData = TlsUtils.calculateVerifyData(state.clientContext, "client finished", TlsProtocol.getCurrentPRFHash(state.clientContext, handshake2.getHandshakeHash(), null));
        handshake2.sendMessage((short)20, clientVerifyData);
        if (state.expectSessionTicket) {
            serverMessage = handshake2.receiveMessage();
            if (serverMessage.getType() == 4) {
                this.processNewSessionTicket(state, serverMessage.getBody());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        byte[] expectedServerVerifyData = TlsUtils.calculateVerifyData(state.clientContext, "server finished", TlsProtocol.getCurrentPRFHash(state.clientContext, handshake2.getHandshakeHash(), null));
        this.processFinished(handshake2.receiveMessageBody((short)20), expectedServerVerifyData);
        handshake2.finish();
        if (state.tlsSession != null) {
            state.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setMasterSecret(securityParameters.getMasterSecret()).setPeerCertificate(serverCertificate).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(state.serverExtensions).build();
            state.tlsSession = TlsUtils.importSession(state.tlsSession.getSessionID(), state.sessionParameters);
            state.clientContext.setResumableSession(state.tlsSession);
        }
        state.client.notifyHandshakeComplete();
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState state, DigitallySigned certificateVerify) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        certificateVerify.encode(buf);
        return buf.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState state, TlsClient client) throws IOException {
        boolean noRenegSCSV;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ProtocolVersion client_version = client.getClientVersion();
        if (!client_version.isDTLS()) {
            throw new TlsFatalAlert(80);
        }
        TlsClientContextImpl context = state.clientContext;
        context.setClientVersion(client_version);
        TlsUtils.writeVersion(client_version, buf);
        SecurityParameters securityParameters = context.getSecurityParameters();
        buf.write(securityParameters.getClientRandom());
        byte[] session_id = TlsUtils.EMPTY_BYTES;
        if (state.tlsSession != null && ((session_id = state.tlsSession.getSessionID()) == null || session_id.length > 32)) {
            session_id = TlsUtils.EMPTY_BYTES;
        }
        TlsUtils.writeOpaque8(session_id, buf);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, buf);
        boolean fallback = client.isFallback();
        state.offeredCipherSuites = client.getCipherSuites();
        state.clientExtensions = client.getClientExtensions();
        byte[] renegExtData = TlsUtils.getExtensionData(state.clientExtensions, TlsProtocol.EXT_RenegotiationInfo);
        boolean noRenegExt = null == renegExtData;
        boolean bl = noRenegSCSV = !Arrays.contains(state.offeredCipherSuites, 255);
        if (noRenegExt && noRenegSCSV) {
            state.offeredCipherSuites = Arrays.append(state.offeredCipherSuites, 255);
        }
        if (fallback && !Arrays.contains(state.offeredCipherSuites, 22016)) {
            state.offeredCipherSuites = Arrays.append(state.offeredCipherSuites, 22016);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(state.offeredCipherSuites, buf);
        state.offeredCompressionMethods = new short[]{0};
        TlsUtils.writeUint8ArrayWithUint8Length(state.offeredCompressionMethods, buf);
        if (state.clientExtensions != null) {
            TlsProtocol.writeExtensions(buf, state.clientExtensions);
        }
        return buf.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState state) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        state.keyExchange.generateClientKeyExchange(buf);
        return buf.toByteArray();
    }

    protected void invalidateSession(ClientHandshakeState state) {
        if (state.sessionParameters != null) {
            state.sessionParameters.clear();
            state.sessionParameters = null;
        }
        if (state.tlsSession != null) {
            state.tlsSession.invalidate();
            state.tlsSession = null;
        }
    }

    protected void processCertificateRequest(ClientHandshakeState state, byte[] body) throws IOException {
        if (state.authentication == null) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.certificateRequest = CertificateRequest.parse(state.clientContext, buf);
        TlsProtocol.assertEmpty(buf);
        state.keyExchange.validateCertificateRequest(state.certificateRequest);
    }

    protected void processCertificateStatus(ClientHandshakeState state, byte[] body) throws IOException {
        if (!state.allowCertificateStatus) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.certificateStatus = CertificateStatus.parse(buf);
        TlsProtocol.assertEmpty(buf);
    }

    protected byte[] processHelloVerifyRequest(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        ProtocolVersion server_version = TlsUtils.readVersion(buf);
        byte[] cookie = TlsUtils.readOpaque8(buf);
        TlsProtocol.assertEmpty(buf);
        if (!server_version.isEqualOrEarlierVersionOf(state.clientContext.getClientVersion())) {
            throw new TlsFatalAlert(47);
        }
        if (!ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(server_version) && cookie.length > 32) {
            throw new TlsFatalAlert(47);
        }
        return cookie;
    }

    protected void processNewSessionTicket(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(buf);
        TlsProtocol.assertEmpty(buf);
        state.client.notifyNewSessionTicket(newSessionTicket);
    }

    protected Certificate processServerCertificate(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        Certificate serverCertificate = Certificate.parse(buf);
        TlsProtocol.assertEmpty(buf);
        state.keyExchange.processServerCertificate(serverCertificate);
        state.authentication = state.client.getAuthentication();
        state.authentication.notifyServerCertificate(serverCertificate);
        return serverCertificate;
    }

    protected void processServerHello(ClientHandshakeState state, byte[] body) throws IOException {
        byte[] renegExtData;
        SecurityParameters securityParameters = state.clientContext.getSecurityParameters();
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        ProtocolVersion server_version = TlsUtils.readVersion(buf);
        this.reportServerVersion(state, server_version);
        securityParameters.serverRandom = TlsUtils.readFully(32, (InputStream)buf);
        state.selectedSessionID = TlsUtils.readOpaque8(buf);
        if (state.selectedSessionID.length > 32) {
            throw new TlsFatalAlert(47);
        }
        state.client.notifySessionID(state.selectedSessionID);
        state.resumedSession = state.selectedSessionID.length > 0 && state.tlsSession != null && Arrays.areEqual(state.selectedSessionID, state.tlsSession.getSessionID());
        int selectedCipherSuite = TlsUtils.readUint16(buf);
        if (!Arrays.contains(state.offeredCipherSuites, selectedCipherSuite) || selectedCipherSuite == 0 || CipherSuite.isSCSV(selectedCipherSuite) || !TlsUtils.isValidCipherSuiteForVersion(selectedCipherSuite, state.clientContext.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        DTLSClientProtocol.validateSelectedCipherSuite(selectedCipherSuite, (short)47);
        state.client.notifySelectedCipherSuite(selectedCipherSuite);
        short selectedCompressionMethod = TlsUtils.readUint8(buf);
        if (!Arrays.contains(state.offeredCompressionMethods, selectedCompressionMethod)) {
            throw new TlsFatalAlert(47);
        }
        state.client.notifySelectedCompressionMethod(selectedCompressionMethod);
        state.serverExtensions = TlsProtocol.readExtensions(buf);
        if (state.serverExtensions != null) {
            Enumeration e = state.serverExtensions.keys();
            while (e.hasMoreElements()) {
                Integer extType = (Integer)e.nextElement();
                if (extType.equals(TlsProtocol.EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(state.clientExtensions, extType)) {
                    throw new TlsFatalAlert(110);
                }
                if (!state.resumedSession) continue;
            }
        }
        if ((renegExtData = TlsUtils.getExtensionData(state.serverExtensions, TlsProtocol.EXT_RenegotiationInfo)) != null) {
            state.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual(renegExtData, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        state.client.notifySecureRenegotiation(state.secure_renegotiation);
        Hashtable sessionClientExtensions = state.clientExtensions;
        Hashtable sessionServerExtensions = state.serverExtensions;
        if (state.resumedSession) {
            if (selectedCipherSuite != state.sessionParameters.getCipherSuite() || selectedCompressionMethod != state.sessionParameters.getCompressionAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            sessionClientExtensions = null;
            sessionServerExtensions = state.sessionParameters.readServerExtensions();
        }
        securityParameters.cipherSuite = selectedCipherSuite;
        securityParameters.compressionAlgorithm = selectedCompressionMethod;
        if (sessionServerExtensions != null) {
            boolean serverSentEncryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(sessionServerExtensions);
            if (serverSentEncryptThenMAC && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = serverSentEncryptThenMAC;
            securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(sessionServerExtensions);
            securityParameters.maxFragmentLength = DTLSClientProtocol.evaluateMaxFragmentLengthExtension(state.resumedSession, sessionClientExtensions, sessionServerExtensions, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(sessionServerExtensions);
            state.allowCertificateStatus = !state.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl = state.expectSessionTicket = !state.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(sessionServerExtensions, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (sessionClientExtensions != null) {
            state.client.processServerExtensions(sessionServerExtensions);
        }
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm(state.clientContext, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
    }

    protected void processServerKeyExchange(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.keyExchange.processServerKeyExchange(buf);
        TlsProtocol.assertEmpty(buf);
    }

    protected void processServerSupplementalData(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        Vector serverSupplementalData = TlsProtocol.readSupplementalDataMessage(buf);
        state.client.processServerSupplementalData(serverSupplementalData);
    }

    protected void reportServerVersion(ClientHandshakeState state, ProtocolVersion server_version) throws IOException {
        TlsClientContextImpl clientContext = state.clientContext;
        ProtocolVersion currentServerVersion = clientContext.getServerVersion();
        if (null == currentServerVersion) {
            clientContext.setServerVersion(server_version);
            state.client.notifyServerVersion(server_version);
        } else if (!currentServerVersion.equals(server_version)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected static byte[] patchClientHelloWithCookie(byte[] clientHelloBody, byte[] cookie) throws IOException {
        int sessionIDPos = 34;
        short sessionIDLength = TlsUtils.readUint8(clientHelloBody, sessionIDPos);
        int cookieLengthPos = sessionIDPos + 1 + sessionIDLength;
        int cookiePos = cookieLengthPos + 1;
        byte[] patched = new byte[clientHelloBody.length + cookie.length];
        System.arraycopy(clientHelloBody, 0, patched, 0, cookieLengthPos);
        TlsUtils.checkUint8(cookie.length);
        TlsUtils.writeUint8(cookie.length, patched, cookieLengthPos);
        System.arraycopy(cookie, 0, patched, cookiePos, cookie.length);
        System.arraycopy(clientHelloBody, cookiePos, patched, cookiePos + cookie.length, clientHelloBody.length - cookiePos);
        return patched;
    }

    protected static class ClientHandshakeState {
        TlsClient client = null;
        TlsClientContextImpl clientContext = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        int[] offeredCipherSuites = null;
        short[] offeredCompressionMethods = null;
        Hashtable clientExtensions = null;
        Hashtable serverExtensions = null;
        byte[] selectedSessionID = null;
        boolean resumedSession = false;
        boolean secure_renegotiation = false;
        boolean allowCertificateStatus = false;
        boolean expectSessionTicket = false;
        TlsKeyExchange keyExchange = null;
        TlsAuthentication authentication = null;
        CertificateStatus certificateStatus = null;
        CertificateRequest certificateRequest = null;
        TlsCredentials clientCredentials = null;

        protected ClientHandshakeState() {
        }
    }
}

