/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.kems;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.DerivationFunction;
import org.spongycastle.crypto.KeyEncapsulation;
import org.spongycastle.crypto.params.ECDomainParameters;
import org.spongycastle.crypto.params.ECKeyParameters;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;
import org.spongycastle.crypto.params.KDFParameters;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.math.ec.ECCurve;
import org.spongycastle.math.ec.ECMultiplier;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.math.ec.FixedPointCombMultiplier;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.BigIntegers;

public class ECIESKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DerivationFunction kdf;
    private SecureRandom rnd;
    private ECKeyParameters key;
    private boolean CofactorMode;
    private boolean OldCofactorMode;
    private boolean SingleHashMode;

    public ECIESKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd) {
        this.kdf = kdf;
        this.rnd = rnd;
        this.CofactorMode = false;
        this.OldCofactorMode = false;
        this.SingleHashMode = false;
    }

    public ECIESKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd, boolean cofactorMode, boolean oldCofactorMode, boolean singleHashMode) {
        this.kdf = kdf;
        this.rnd = rnd;
        this.CofactorMode = cofactorMode;
        this.OldCofactorMode = oldCofactorMode;
        this.SingleHashMode = singleHashMode;
    }

    public void init(CipherParameters key) throws IllegalArgumentException {
        if (!(key instanceof ECKeyParameters)) {
            throw new IllegalArgumentException("EC key required");
        }
        this.key = (ECKeyParameters)key;
    }

    public CipherParameters encrypt(byte[] out, int outOff, int keyLen) throws IllegalArgumentException {
        if (!(this.key instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        ECPublicKeyParameters ecPubKey = (ECPublicKeyParameters)this.key;
        ECDomainParameters ecParams = ecPubKey.getParameters();
        ECCurve curve = ecParams.getCurve();
        BigInteger n = ecParams.getN();
        BigInteger h2 = ecParams.getH();
        BigInteger r = BigIntegers.createRandomInRange(ONE, n, this.rnd);
        BigInteger rPrime = this.CofactorMode ? r.multiply(h2).mod(n) : r;
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        ECPoint[] ghTilde = new ECPoint[]{basePointMultiplier.multiply(ecParams.getG(), r), ecPubKey.getQ().multiply(rPrime)};
        curve.normalizeAll(ghTilde);
        ECPoint gTilde = ghTilde[0];
        ECPoint hTilde = ghTilde[1];
        byte[] C2 = gTilde.getEncoded(false);
        System.arraycopy(C2, 0, out, outOff, C2.length);
        byte[] PEH = hTilde.getAffineXCoord().getEncoded();
        return this.deriveKey(keyLen, C2, PEH);
    }

    public CipherParameters encrypt(byte[] out, int keyLen) {
        return this.encrypt(out, 0, keyLen);
    }

    public CipherParameters decrypt(byte[] in, int inOff, int inLen, int keyLen) throws IllegalArgumentException {
        ECPoint gTilde;
        if (!(this.key instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("Private key required for encryption");
        }
        ECPrivateKeyParameters ecPrivKey = (ECPrivateKeyParameters)this.key;
        ECDomainParameters ecParams = ecPrivKey.getParameters();
        ECCurve curve = ecParams.getCurve();
        BigInteger n = ecParams.getN();
        BigInteger h2 = ecParams.getH();
        byte[] C2 = new byte[inLen];
        System.arraycopy(in, inOff, C2, 0, inLen);
        ECPoint gHat = gTilde = curve.decodePoint(C2);
        if (this.CofactorMode || this.OldCofactorMode) {
            gHat = gHat.multiply(h2);
        }
        BigInteger xHat = ecPrivKey.getD();
        if (this.CofactorMode) {
            xHat = xHat.multiply(h2.modInverse(n)).mod(n);
        }
        ECPoint hTilde = gHat.multiply(xHat).normalize();
        byte[] PEH = hTilde.getAffineXCoord().getEncoded();
        return this.deriveKey(keyLen, C2, PEH);
    }

    public CipherParameters decrypt(byte[] in, int keyLen) {
        return this.decrypt(in, 0, in.length, keyLen);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyParameter deriveKey(int keyLen, byte[] C2, byte[] PEH) {
        byte[] kdfInput = PEH;
        if (this.SingleHashMode) {
            kdfInput = Arrays.concatenate(C2, PEH);
            Arrays.fill(PEH, (byte)0);
        }
        try {
            this.kdf.init(new KDFParameters(kdfInput, null));
            byte[] K2 = new byte[keyLen];
            this.kdf.generateBytes(K2, 0, K2.length);
            KeyParameter keyParameter = new KeyParameter(K2);
            return keyParameter;
        }
        finally {
            Arrays.fill(kdfInput, (byte)0);
        }
    }
}

