/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.spongycastle.crypto.params.DHParameters;
import org.spongycastle.math.ec.WNafUtil;
import org.spongycastle.util.BigIntegers;

class DHKeyGeneratorHelper {
    static final DHKeyGeneratorHelper INSTANCE = new DHKeyGeneratorHelper();
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private DHKeyGeneratorHelper() {
    }

    BigInteger calculatePrivate(DHParameters dhParams, SecureRandom random) {
        BigInteger x;
        BigInteger q;
        int limit = dhParams.getL();
        if (limit != 0) {
            BigInteger x2;
            int minWeight = limit >>> 2;
            while (WNafUtil.getNafWeight(x2 = new BigInteger(limit, random).setBit(limit - 1)) < minWeight) {
            }
            return x2;
        }
        BigInteger min2 = TWO;
        int m3 = dhParams.getM();
        if (m3 != 0) {
            min2 = ONE.shiftLeft(m3 - 1);
        }
        if ((q = dhParams.getQ()) == null) {
            q = dhParams.getP();
        }
        BigInteger max = q.subtract(TWO);
        int minWeight = max.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(x = BigIntegers.createRandomInRange(min2, max, random)) < minWeight) {
        }
        return x;
    }

    BigInteger calculatePublic(DHParameters dhParams, BigInteger x) {
        return dhParams.getG().modPow(x, dhParams.getP());
    }
}

