/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.xml;

import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.stax.OutputFactoryImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.linguafranca.xml.XmlEventTransformer;

public class XmlOutputStreamFilter
extends PipedOutputStream {
    protected Future<Boolean> future;
    protected PipedInputStream pipedInputStream = new PipedInputStream(this);

    public XmlOutputStreamFilter(final OutputStream outputStream2, final XmlEventTransformer eventTransformer) throws IOException {
        Callable<Boolean> output = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    XMLEventReader eventReader = new InputFactoryImpl().createXMLEventReader(XmlOutputStreamFilter.this.pipedInputStream);
                    XMLEventWriter eventWriter = new OutputFactoryImpl().createXMLEventWriter(outputStream2);
                    XMLEvent event = null;
                    while (eventReader.hasNext()) {
                        event = eventReader.nextEvent();
                        event = eventTransformer.transform(event);
                        eventWriter.add(event);
                        eventWriter.flush();
                    }
                    eventReader.close();
                    eventWriter.flush();
                    eventWriter.close();
                    outputStream2.flush();
                    outputStream2.close();
                }
                catch (IOException | XMLStreamException e) {
                    throw new IllegalStateException(e);
                }
                return true;
            }
        };
        this.future = Executors.newSingleThreadExecutor().submit(output);
    }

    public void cancel(boolean interrupt) {
        this.future.cancel(interrupt);
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public boolean await() throws IOException {
        try {
            return this.future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

