/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.stream_3_1;

import java.security.MessageDigest;
import org.linguafranca.pwdb.kdbx.StreamEncryptor;
import org.linguafranca.pwdb.security.Encryption;
import org.spongycastle.crypto.engines.Salsa20Engine;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.ParametersWithIV;
import org.spongycastle.util.encoders.Hex;

public class Salsa20StreamEncryptor
implements StreamEncryptor {
    private final Salsa20Engine salsa20;
    private final byte[] key;
    private static final byte[] SALSA20_IV = Hex.decode("E830094B97205D2A".getBytes());

    public static Salsa20Engine createSalsa20(byte[] key) {
        MessageDigest md = Encryption.getMessageDigestInstance();
        KeyParameter keyParameter = new KeyParameter(md.digest(key));
        ParametersWithIV ivParameter = new ParametersWithIV(keyParameter, SALSA20_IV);
        Salsa20Engine engine = new Salsa20Engine();
        engine.init(true, ivParameter);
        return engine;
    }

    public Salsa20StreamEncryptor(byte[] key) {
        this.key = key;
        this.salsa20 = Salsa20StreamEncryptor.createSalsa20(key);
    }

    @Override
    public byte[] getKey() {
        return this.key;
    }

    @Override
    public byte[] decrypt(byte[] encryptedText) {
        byte[] output = new byte[encryptedText.length];
        this.salsa20.processBytes(encryptedText, 0, encryptedText.length, output, 0);
        return output;
    }

    @Override
    public byte[] encrypt(byte[] decryptedText) {
        byte[] output = new byte[decryptedText.length];
        this.salsa20.processBytes(decryptedText, 0, decryptedText.length, output, 0);
        return output;
    }
}

