/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.stream_3_1;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.hashedblock.HashedBlockInputStream;
import org.linguafranca.pwdb.hashedblock.HashedBlockOutputStream;
import org.linguafranca.pwdb.kdbx.stream_3_1.KdbxHeader;
import org.linguafranca.pwdb.security.Encryption;

public class KdbxSerializer {
    private static final int SIG1 = -1700603645;
    private static final int SIG2 = -1253311641;
    private static final int FILE_VERSION_CRITICAL_MASK = -65536;
    private static final int FILE_VERSION_32 = 196609;

    private KdbxSerializer() {
    }

    public static InputStream createUnencryptedInputStream(Credentials credentials, KdbxHeader kdbxHeader, InputStream inputStream2) throws IOException {
        KdbxSerializer.readKdbxHeader(kdbxHeader, inputStream2);
        InputStream decryptedInputStream = kdbxHeader.createDecryptedStream(credentials.getKey(), inputStream2);
        KdbxSerializer.checkStartBytes(kdbxHeader, decryptedInputStream);
        HashedBlockInputStream blockInputStream = new HashedBlockInputStream(decryptedInputStream, true);
        if (kdbxHeader.getCompressionFlags().equals((Object)KdbxHeader.CompressionFlags.NONE)) {
            return blockInputStream;
        }
        return new GZIPInputStream(blockInputStream);
    }

    public static OutputStream createEncryptedOutputStream(Credentials credentials, KdbxHeader kdbxHeader, OutputStream outputStream2) throws IOException {
        KdbxSerializer.writeKdbxHeader(kdbxHeader, outputStream2);
        OutputStream encryptedOutputStream = kdbxHeader.createEncryptedStream(credentials.getKey(), outputStream2);
        KdbxSerializer.writeStartBytes(kdbxHeader, encryptedOutputStream);
        HashedBlockOutputStream blockOutputStream = new HashedBlockOutputStream(encryptedOutputStream, true);
        if (kdbxHeader.getCompressionFlags().equals((Object)KdbxHeader.CompressionFlags.NONE)) {
            return blockOutputStream;
        }
        return new GZIPOutputStream(blockOutputStream);
    }

    private static void checkStartBytes(KdbxHeader kdbxHeader, InputStream decryptedInputStream) throws IOException {
        LittleEndianDataInputStream ledis = new LittleEndianDataInputStream(decryptedInputStream);
        byte[] startBytes = new byte[32];
        ledis.readFully(startBytes);
        if (!Arrays.equals(startBytes, kdbxHeader.getStreamStartBytes())) {
            throw new IllegalStateException("Inconsistent stream start bytes. This usually means the credentials were wrong.");
        }
    }

    private static void writeStartBytes(KdbxHeader kdbxHeader, OutputStream encryptedOutputStream) throws IOException {
        LittleEndianDataOutputStream ledos = new LittleEndianDataOutputStream(encryptedOutputStream);
        ledos.write(kdbxHeader.getStreamStartBytes());
    }

    private static boolean verifyMagicNumber(LittleEndianDataInputStream ledis) throws IOException {
        int sig1 = ledis.readInt();
        int sig2 = ledis.readInt();
        return sig1 == -1700603645 && sig2 == -1253311641;
    }

    private static boolean verifyFileVersion(LittleEndianDataInputStream ledis) throws IOException {
        return (ledis.readInt() & 0xFFFF0000) <= 196608;
    }

    public static KdbxHeader readKdbxHeader(KdbxHeader kdbxHeader, InputStream inputStream2) throws IOException {
        byte headerType;
        MessageDigest digest = Encryption.getMessageDigestInstance();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream2, digest);
        LittleEndianDataInputStream ledis = new LittleEndianDataInputStream(digestInputStream);
        if (!KdbxSerializer.verifyMagicNumber(ledis)) {
            throw new IllegalStateException("Magic number did not match");
        }
        if (!KdbxSerializer.verifyFileVersion(ledis)) {
            throw new IllegalStateException("File version did not match");
        }
        block12: while ((headerType = ledis.readByte()) != 0) {
            switch (headerType) {
                case 1: {
                    KdbxSerializer.getByteArray(ledis);
                    continue block12;
                }
                case 2: {
                    kdbxHeader.setCipherUuid(KdbxSerializer.getByteArray(ledis));
                    continue block12;
                }
                case 3: {
                    kdbxHeader.setCompressionFlags(KdbxSerializer.getInt(ledis));
                    continue block12;
                }
                case 4: {
                    kdbxHeader.setMasterSeed(KdbxSerializer.getByteArray(ledis));
                    continue block12;
                }
                case 5: {
                    kdbxHeader.setTransformSeed(KdbxSerializer.getByteArray(ledis));
                    continue block12;
                }
                case 6: {
                    kdbxHeader.setTransformRounds(KdbxSerializer.getLong(ledis));
                    continue block12;
                }
                case 7: {
                    kdbxHeader.setEncryptionIv(KdbxSerializer.getByteArray(ledis));
                    continue block12;
                }
                case 8: {
                    kdbxHeader.setProtectedStreamKey(KdbxSerializer.getByteArray(ledis));
                    continue block12;
                }
                case 9: {
                    kdbxHeader.setStreamStartBytes(KdbxSerializer.getByteArray(ledis));
                    continue block12;
                }
                case 10: {
                    kdbxHeader.setInnerRandomStreamId(KdbxSerializer.getInt(ledis));
                    continue block12;
                }
            }
            throw new IllegalStateException("Unknown File Header");
        }
        KdbxSerializer.getByteArray(ledis);
        kdbxHeader.setHeaderHash(digest.digest());
        return kdbxHeader;
    }

    public static void writeKdbxHeader(KdbxHeader kdbxHeader, OutputStream outputStream2) throws IOException {
        MessageDigest messageDigest = Encryption.getMessageDigestInstance();
        DigestOutputStream digestOutputStream = new DigestOutputStream(outputStream2, messageDigest);
        LittleEndianDataOutputStream ledos = new LittleEndianDataOutputStream(digestOutputStream);
        ledos.writeInt(-1700603645);
        ledos.writeInt(-1253311641);
        ledos.writeInt(196609);
        ledos.writeByte(2);
        ledos.writeShort(16);
        byte[] b = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putLong(kdbxHeader.getCipherUuid().getMostSignificantBits());
        bb.putLong(8, kdbxHeader.getCipherUuid().getLeastSignificantBits());
        ledos.write(b);
        ledos.writeByte(3);
        ledos.writeShort(4);
        ledos.writeInt(kdbxHeader.getCompressionFlags().ordinal());
        ledos.writeByte(4);
        ledos.writeShort(kdbxHeader.getMasterSeed().length);
        ledos.write(kdbxHeader.getMasterSeed());
        ledos.writeByte(5);
        ledos.writeShort(kdbxHeader.getTransformSeed().length);
        ledos.write(kdbxHeader.getTransformSeed());
        ledos.writeByte(6);
        ledos.writeShort(8);
        ledos.writeLong(kdbxHeader.getTransformRounds());
        ledos.writeByte(7);
        ledos.writeShort(kdbxHeader.getEncryptionIv().length);
        ledos.write(kdbxHeader.getEncryptionIv());
        ledos.writeByte(8);
        ledos.writeShort(kdbxHeader.getProtectedStreamKey().length);
        ledos.write(kdbxHeader.getProtectedStreamKey());
        ledos.writeByte(9);
        ledos.writeShort(kdbxHeader.getStreamStartBytes().length);
        ledos.write(kdbxHeader.getStreamStartBytes());
        ledos.writeByte(10);
        ledos.writeShort(4);
        ledos.writeInt(kdbxHeader.getProtectedStreamAlgorithm().ordinal());
        ledos.writeByte(0);
        ledos.writeShort(0);
        MessageDigest digest = digestOutputStream.getMessageDigest();
        kdbxHeader.setHeaderHash(digest.digest());
    }

    private static int getInt(LittleEndianDataInputStream ledis) throws IOException {
        short fieldLength = ledis.readShort();
        if (fieldLength != 4) {
            throw new IllegalStateException("Int required but length was " + fieldLength);
        }
        return ledis.readInt();
    }

    private static long getLong(LittleEndianDataInputStream ledis) throws IOException {
        short fieldLength = ledis.readShort();
        if (fieldLength != 8) {
            throw new IllegalStateException("Long required but length was " + fieldLength);
        }
        return ledis.readLong();
    }

    private static byte[] getByteArray(LittleEndianDataInputStream ledis) throws IOException {
        short fieldLength = ledis.readShort();
        byte[] value = new byte[fieldLength];
        ledis.readFully(value);
        return value;
    }

    private static class HeaderType {
        static final byte END = 0;
        static final byte COMMENT = 1;
        static final byte CIPHER_ID = 2;
        static final byte COMPRESSION_FLAGS = 3;
        static final byte MASTER_SEED = 4;
        static final byte TRANSFORM_SEED = 5;
        static final byte TRANSFORM_ROUNDS = 6;
        static final byte ENCRYPTION_IV = 7;
        static final byte PROTECTED_STREAM_KEY = 8;
        static final byte STREAM_START_BYTES = 9;
        static final byte INNER_RANDOM_STREAM_ID = 10;

        private HeaderType() {
        }
    }
}

