/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.stream_3_1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.UUID;
import org.linguafranca.pwdb.security.Encryption;

public class KdbxHeader {
    public static final UUID AES_CIPHER = UUID.fromString("31C1F2E6-BF71-4350-BE58-05216AFC5AFF");
    private UUID cipherUuid;
    private CompressionFlags compressionFlags;
    private byte[] masterSeed;
    private byte[] transformSeed;
    private long transformRounds;
    private byte[] encryptionIv;
    private byte[] protectedStreamKey;
    private ProtectedStreamAlgorithm protectedStreamAlgorithm;
    private byte[] streamStartBytes;
    private byte[] headerHash;

    public KdbxHeader() {
        SecureRandom random = new SecureRandom();
        this.cipherUuid = AES_CIPHER;
        this.compressionFlags = CompressionFlags.GZIP;
        this.masterSeed = random.generateSeed(32);
        this.transformSeed = random.generateSeed(32);
        this.transformRounds = 6000L;
        this.encryptionIv = random.generateSeed(16);
        this.protectedStreamKey = random.generateSeed(32);
        this.streamStartBytes = new byte[32];
        this.protectedStreamAlgorithm = ProtectedStreamAlgorithm.SALSA_20;
    }

    public InputStream createDecryptedStream(byte[] digest, InputStream inputStream2) throws IOException {
        byte[] finalKeyDigest = Encryption.getFinalKeyDigest(digest, this.getMasterSeed(), this.getTransformSeed(), this.getTransformRounds());
        return Encryption.getDecryptedInputStream(inputStream2, finalKeyDigest, this.getEncryptionIv());
    }

    public OutputStream createEncryptedStream(byte[] digest, OutputStream outputStream2) throws IOException {
        byte[] finalKeyDigest = Encryption.getFinalKeyDigest(digest, this.getMasterSeed(), this.getTransformSeed(), this.getTransformRounds());
        return Encryption.getEncryptedOutputStream(outputStream2, finalKeyDigest, this.getEncryptionIv());
    }

    public UUID getCipherUuid() {
        return this.cipherUuid;
    }

    public CompressionFlags getCompressionFlags() {
        return this.compressionFlags;
    }

    public byte[] getMasterSeed() {
        return this.masterSeed;
    }

    public byte[] getTransformSeed() {
        return this.transformSeed;
    }

    public long getTransformRounds() {
        return this.transformRounds;
    }

    public byte[] getEncryptionIv() {
        return this.encryptionIv;
    }

    public byte[] getProtectedStreamKey() {
        return this.protectedStreamKey;
    }

    public byte[] getStreamStartBytes() {
        return this.streamStartBytes;
    }

    public ProtectedStreamAlgorithm getProtectedStreamAlgorithm() {
        return this.protectedStreamAlgorithm;
    }

    public byte[] getHeaderHash() {
        return this.headerHash;
    }

    public void setCipherUuid(byte[] uuid) {
        ByteBuffer b = ByteBuffer.wrap(uuid);
        UUID incoming = new UUID(b.getLong(), b.getLong(8));
        if (!incoming.equals(AES_CIPHER)) {
            throw new IllegalStateException("Unknown Cipher UUID " + incoming.toString());
        }
        this.cipherUuid = incoming;
    }

    public void setCompressionFlags(int flags) {
        this.compressionFlags = CompressionFlags.values()[flags];
    }

    public void setMasterSeed(byte[] masterSeed) {
        this.masterSeed = masterSeed;
    }

    public void setTransformSeed(byte[] transformSeed) {
        this.transformSeed = transformSeed;
    }

    public void setTransformRounds(long transformRounds) {
        this.transformRounds = transformRounds;
    }

    public void setEncryptionIv(byte[] encryptionIv) {
        this.encryptionIv = encryptionIv;
    }

    public void setProtectedStreamKey(byte[] protectedStreamKey) {
        this.protectedStreamKey = protectedStreamKey;
    }

    public void setStreamStartBytes(byte[] streamStartBytes) {
        this.streamStartBytes = streamStartBytes;
    }

    public void setInnerRandomStreamId(int innerRandomStreamId) {
        this.protectedStreamAlgorithm = ProtectedStreamAlgorithm.values()[innerRandomStreamId];
    }

    public void setHeaderHash(byte[] headerHash) {
        this.headerHash = headerHash;
    }

    public static enum ProtectedStreamAlgorithm {
        NONE,
        ARC_FOUR,
        SALSA_20;

    }

    public static enum CompressionFlags {
        NONE,
        GZIP;

    }
}

