/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.simple;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.linguafranca.pwdb.base.AbstractEntry;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.simple.SimpleDatabase;
import org.linguafranca.pwdb.kdbx.simple.SimpleGroup;
import org.linguafranca.pwdb.kdbx.simple.SimpleIcon;
import org.linguafranca.pwdb.kdbx.simple.converter.UuidConverter;
import org.linguafranca.pwdb.kdbx.simple.model.EntryClasses;
import org.linguafranca.pwdb.kdbx.simple.model.KeePassFile;
import org.linguafranca.pwdb.kdbx.simple.model.Times;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Transient;
import org.simpleframework.xml.convert.Convert;

@Root(name="Entry")
public class SimpleEntry
extends AbstractEntry<SimpleDatabase, SimpleGroup, SimpleEntry, SimpleIcon> {
    @Element(name="UUID", type=UUID.class)
    @Convert(value=UuidConverter.class)
    protected UUID uuid;
    @Element(name="IconID")
    protected int iconID = 0;
    @Element(name="CustomIconUUID", type=UUID.class, required=false)
    @Convert(value=UuidConverter.class)
    protected UUID customIconUUID;
    @Element(name="ForegroundColor", required=false)
    protected String foregroundColor;
    @Element(name="BackgroundColor", required=false)
    protected String backgroundColor;
    @Element(name="OverrideURL", required=false)
    protected String overrideURL;
    @Element(name="Tags", required=false)
    protected String tags;
    @Element(name="Times")
    protected Times times;
    @ElementList(inline=true)
    protected List<EntryClasses.StringProperty> string = new ArrayList<EntryClasses.StringProperty>();
    @ElementList(inline=true, required=false)
    protected List<EntryClasses.BinaryProperty> binary = new ArrayList<EntryClasses.BinaryProperty>();
    @Element(name="AutoType", required=false)
    protected EntryClasses.AutoType autoType;
    @ElementList(name="History", required=false)
    protected List<SimpleEntry> history;
    @Transient
    SimpleDatabase database;
    @Transient
    SimpleGroup parent;

    protected SimpleEntry() {
        this.times = new Times();
        this.uuid = UUID.randomUUID();
    }

    public static SimpleEntry createEntry(SimpleDatabase database) {
        SimpleEntry result = new SimpleEntry();
        result.database = database;
        result.parent = null;
        for (String p : STANDARD_PROPERTY_NAMES) {
            result.string.add(new EntryClasses.StringProperty(p, new EntryClasses.StringProperty.Value("")));
        }
        return result;
    }

    @Override
    public String getProperty(String s2) {
        return EntryClasses.getStringContent(EntryClasses.getStringProperty(s2, this.string));
    }

    @Override
    public void setProperty(String s2, String s1) {
        EntryClasses.StringProperty sp = EntryClasses.getStringProperty(s2, this.string);
        if (sp != null) {
            this.string.remove(sp);
        }
        this.string.add(new EntryClasses.StringProperty(s2, new EntryClasses.StringProperty.Value(s1)));
        this.touch();
    }

    @Override
    public boolean removeProperty(String name) throws IllegalArgumentException {
        if (STANDARD_PROPERTY_NAMES.contains(name)) {
            throw new IllegalArgumentException("may not remove property: " + name);
        }
        EntryClasses.StringProperty sp = EntryClasses.getStringProperty(name, this.string);
        if (sp == null) {
            return false;
        }
        this.string.remove(sp);
        this.touch();
        return true;
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (EntryClasses.StringProperty property : this.string) {
            result.add(property.getKey());
        }
        return result;
    }

    @Override
    public byte[] getBinaryProperty(String s2) {
        EntryClasses.BinaryProperty bp = EntryClasses.getBinaryProp(s2, this.binary);
        if (bp == null) {
            return null;
        }
        KeePassFile.Binaries.Binary binary = null;
        for (KeePassFile.Binaries.Binary b : this.database.getBinaries()) {
            if (!b.getId().equals(Integer.valueOf(EntryClasses.getBinaryContent(bp)))) continue;
            binary = b;
        }
        if (binary == null) {
            return null;
        }
        return Helpers.decodeBase64Content(binary.getValue().getBytes(), binary.getCompressed());
    }

    @Override
    public void setBinaryProperty(String s2, byte[] bytes) {
        EntryClasses.BinaryProperty bp = EntryClasses.getBinaryProp(s2, this.binary);
        if (bp != null) {
            this.binary.remove(bp);
        }
        Integer max = -1;
        for (KeePassFile.Binaries.Binary binary : this.database.getBinaries()) {
            if (binary.getId() <= max) continue;
            max = binary.getId();
        }
        Integer n = max;
        Integer n2 = max = Integer.valueOf(max + 1);
        KeePassFile.Binaries.Binary newBin = new KeePassFile.Binaries.Binary();
        newBin.setId(max);
        newBin.setValue(Helpers.encodeBase64Content(bytes, true));
        newBin.setCompressed(true);
        this.database.getBinaries().add(newBin);
        EntryClasses.BinaryProperty binaryProperty = new EntryClasses.BinaryProperty();
        binaryProperty.setKey(s2);
        EntryClasses.BinaryProperty.Value fieldValue = new EntryClasses.BinaryProperty.Value();
        fieldValue.setRef(String.valueOf(max));
        binaryProperty.setValue(fieldValue);
        this.binary.add(binaryProperty);
        this.touch();
    }

    @Override
    public boolean removeBinaryProperty(String name) throws UnsupportedOperationException {
        EntryClasses.BinaryProperty bp = EntryClasses.getBinaryProp(name, this.binary);
        if (bp != null) {
            this.binary.remove(bp);
            this.touch();
            return true;
        }
        return false;
    }

    @Override
    public List<String> getBinaryPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (EntryClasses.BinaryProperty property : this.binary) {
            result.add(property.getKey());
        }
        return result;
    }

    @Override
    public SimpleGroup getParent() {
        return this.parent;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public SimpleIcon getIcon() {
        return new SimpleIcon(this.iconID);
    }

    @Override
    public void setIcon(SimpleIcon icon) {
        this.iconID = icon.getIndex();
    }

    @Override
    public Date getLastAccessTime() {
        return this.times.getLastAccessTime();
    }

    @Override
    public Date getCreationTime() {
        return this.times.getCreationTime();
    }

    @Override
    public boolean getExpires() {
        return this.times.getExpires();
    }

    @Override
    public void setExpires(boolean expires) {
        this.times.setExpires(expires);
    }

    @Override
    public Date getExpiryTime() {
        return this.times.getExpiryTime();
    }

    @Override
    public void setExpiryTime(Date expiryTime) throws IllegalArgumentException {
        if (expiryTime == null) {
            throw new IllegalArgumentException("expiryTime may not be null");
        }
        this.times.setExpiryTime(expiryTime);
    }

    @Override
    public Date getLastModificationTime() {
        return this.times.getLastModificationTime();
    }

    @Override
    protected void touch() {
        this.times.setLastModificationTime(new Date());
        this.database.setDirty(true);
    }
}

