/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.simple;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.base.AbstractDatabase;
import org.linguafranca.pwdb.kdbx.simple.SimpleEntry;
import org.linguafranca.pwdb.kdbx.simple.SimpleGroup;
import org.linguafranca.pwdb.kdbx.simple.SimpleIcon;
import org.linguafranca.pwdb.kdbx.simple.converter.EmptyStringConverter;
import org.linguafranca.pwdb.kdbx.simple.model.EntryClasses;
import org.linguafranca.pwdb.kdbx.simple.model.KeePassFile;
import org.linguafranca.pwdb.kdbx.simple.transformer.KdbxInputTransformer;
import org.linguafranca.pwdb.kdbx.simple.transformer.KdbxOutputTransformer;
import org.linguafranca.pwdb.kdbx.stream_3_1.KdbxHeader;
import org.linguafranca.pwdb.kdbx.stream_3_1.KdbxSerializer;
import org.linguafranca.pwdb.kdbx.stream_3_1.Salsa20StreamEncryptor;
import org.linguafranca.xml.XmlInputStreamFilter;
import org.linguafranca.xml.XmlOutputStreamFilter;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.convert.Registry;
import org.simpleframework.xml.convert.RegistryStrategy;
import org.simpleframework.xml.core.Persister;

public class SimpleDatabase
extends AbstractDatabase<SimpleDatabase, SimpleGroup, SimpleEntry, SimpleIcon> {
    KeePassFile keePassFile;

    public SimpleDatabase() {
        try {
            this.keePassFile = SimpleDatabase.createEmptyDatabase();
            this.keePassFile.root.group.database = this;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected SimpleDatabase(KeePassFile keePassFile) {
        this.keePassFile = keePassFile;
        this.keePassFile.root.group.database = this;
        SimpleDatabase.fixUp(this.keePassFile.root.group);
    }

    @Override
    public SimpleGroup getRootGroup() {
        return this.keePassFile.root.getGroup();
    }

    @Override
    public SimpleGroup newGroup() {
        return SimpleGroup.createGroup(this);
    }

    @Override
    public SimpleEntry newEntry() {
        return SimpleEntry.createEntry(this);
    }

    @Override
    public SimpleIcon newIcon() {
        return new SimpleIcon();
    }

    @Override
    public SimpleIcon newIcon(Integer integer) {
        SimpleIcon ic = this.newIcon();
        ic.setIndex(integer);
        return ic;
    }

    @Override
    public boolean isRecycleBinEnabled() {
        return this.keePassFile.meta.recycleBinEnabled;
    }

    @Override
    public void enableRecycleBin(boolean enable) {
        this.keePassFile.meta.recycleBinEnabled = enable;
    }

    @Override
    public SimpleGroup getRecycleBin() {
        UUID recycleBinUuid = this.keePassFile.meta.recycleBinUUID;
        SimpleGroup g2 = (SimpleGroup)this.findGroup(recycleBinUuid);
        if (g2 == null && this.isRecycleBinEnabled()) {
            g2 = (SimpleGroup)this.newGroup("Recycle Bin");
            this.getRootGroup().addGroup(g2);
            this.keePassFile.meta.recycleBinUUID = g2.getUuid();
            this.keePassFile.meta.recycleBinChanged = new Date();
        }
        return g2;
    }

    @Override
    public String getName() {
        return this.keePassFile.meta.databaseName;
    }

    @Override
    public void setName(String s2) {
        this.keePassFile.meta.databaseName = s2;
        this.keePassFile.meta.databaseNameChanged = new Date();
        this.setDirty(true);
    }

    @Override
    public String getDescription() {
        return this.keePassFile.meta.databaseDescription;
    }

    @Override
    public void setDescription(String s2) {
        this.keePassFile.meta.databaseDescription = s2;
        this.keePassFile.meta.databaseDescriptionChanged = new Date();
        this.setDirty(true);
    }

    private static KeePassFile createEmptyDatabase() throws Exception {
        InputStream inputStream2 = SimpleDatabase.class.getClassLoader().getResourceAsStream("base.kdbx.xml");
        return (KeePassFile)((Object)SimpleDatabase.getSerializer().read(KeePassFile.class, inputStream2));
    }

    public static SimpleDatabase loadXml(InputStream inputStream2) throws Exception {
        KeePassFile result = (KeePassFile)((Object)SimpleDatabase.getSerializer().read(KeePassFile.class, inputStream2));
        result.root.group.uuid = UUID.randomUUID();
        return new SimpleDatabase(result);
    }

    public static SimpleDatabase load(Credentials credentials, InputStream inputStream2) throws Exception {
        KdbxHeader kdbxHeader = new KdbxHeader();
        InputStream kdbxInnerStream = KdbxSerializer.createUnencryptedInputStream(credentials, kdbxHeader, inputStream2);
        XmlInputStreamFilter plainTextXmlStream = new XmlInputStreamFilter(kdbxInnerStream, new KdbxInputTransformer(new Salsa20StreamEncryptor(kdbxHeader.getProtectedStreamKey())));
        KeePassFile result = (KeePassFile)((Object)SimpleDatabase.getSerializer().read(KeePassFile.class, (InputStream)plainTextXmlStream));
        if (!Arrays.equals(result.meta.headerHash.getContent(), kdbxHeader.getHeaderHash())) {
            throw new IllegalStateException("Header Hash Mismatch");
        }
        return new SimpleDatabase(result);
    }

    public void save(OutputStream outputStream2) {
        try {
            SimpleDatabase.prepareForSave(this.keePassFile.root.group);
            SimpleDatabase.getSerializer().write((Object)this.keePassFile, outputStream2);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void save(Credentials credentials, OutputStream outputStream2) throws IOException {
        try {
            KdbxHeader kdbxHeader = new KdbxHeader();
            OutputStream kdbxInnerStream = KdbxSerializer.createEncryptedOutputStream(credentials, kdbxHeader, outputStream2);
            this.keePassFile.meta.headerHash.setContent(kdbxHeader.getHeaderHash());
            XmlOutputStreamFilter plainTextOutputStream = new XmlOutputStreamFilter(kdbxInnerStream, new KdbxOutputTransformer(new Salsa20StreamEncryptor(kdbxHeader.getProtectedStreamKey())));
            SimpleDatabase.prepareForSave(this.keePassFile.root.group);
            SimpleDatabase.getSerializer().write((Object)this.keePassFile, plainTextOutputStream);
            plainTextOutputStream.close();
            plainTextOutputStream.await();
            this.setDirty(false);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean shouldProtect(String s2) {
        return this.keePassFile.meta.memoryProtection.shouldProtect(s2);
    }

    public List<KeePassFile.Binaries.Binary> getBinaries() {
        return this.keePassFile.getBinaries();
    }

    private static Serializer getSerializer() throws Exception {
        Registry registry = new Registry();
        registry.bind(String.class, EmptyStringConverter.class);
        AnnotationStrategy strategy = new AnnotationStrategy(new RegistryStrategy(registry));
        return new Persister(strategy);
    }

    private static void fixUp(SimpleGroup parent) {
        for (SimpleGroup group : parent.group) {
            group.parent = parent;
            group.database = parent.database;
            SimpleDatabase.fixUp(group);
        }
        for (SimpleEntry entry : parent.entry) {
            entry.database = parent.database;
            entry.parent = parent;
        }
    }

    private static void prepareForSave(SimpleGroup parent) {
        for (SimpleGroup group : parent.group) {
            SimpleDatabase.prepareForSave(group);
        }
        for (SimpleEntry entry : parent.entry) {
            for (EntryClasses.StringProperty property : entry.string) {
                boolean shouldProtect = parent.database.shouldProtect(property.getKey());
                property.getValue().setProtected(shouldProtect);
            }
        }
    }
}

