/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.base.AbstractDatabase;
import org.linguafranca.pwdb.kdbx.StreamFormat;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbEntry;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbGroup;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbIcon;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbSerializableDatabase;
import org.linguafranca.pwdb.kdbx.jaxb.binding.KeePassFile;
import org.linguafranca.pwdb.kdbx.jaxb.binding.ObjectFactory;
import org.linguafranca.pwdb.kdbx.stream_3_1.KdbxStreamFormat;

public class JaxbDatabase
extends AbstractDatabase<JaxbDatabase, JaxbGroup, JaxbEntry, JaxbIcon> {
    private KeePassFile keePassFile;
    private ObjectFactory objectFactory = new ObjectFactory();
    private JaxbGroup root;

    public JaxbDatabase() {
        this(JaxbDatabase.createEmptyDatabase().getKeePassFile());
    }

    public JaxbDatabase(KeePassFile keePassFile) {
        this.keePassFile = keePassFile;
        this.root = new JaxbGroup(this, keePassFile.getRoot().getGroup());
    }

    public static JaxbDatabase createEmptyDatabase() {
        InputStream inputStream2 = JaxbDatabase.class.getClassLoader().getResourceAsStream("base.kdbx.xml");
        KeePassFile keePassFile = new JaxbSerializableDatabase().load((InputStream)inputStream2).keePassFile;
        keePassFile.getRoot().getGroup().setUUID(UUID.randomUUID());
        return new JaxbDatabase(keePassFile);
    }

    public static JaxbDatabase load(Credentials creds, InputStream inputStream2) {
        KdbxStreamFormat format = new KdbxStreamFormat();
        return JaxbDatabase.load(format, creds, inputStream2);
    }

    @NotNull
    public static JaxbDatabase load(StreamFormat format, Credentials creds, InputStream inputStream2) {
        JaxbSerializableDatabase db = new JaxbSerializableDatabase();
        try {
            format.load(db, creds, inputStream2);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new JaxbDatabase(db.getKeePassFile());
    }

    @Override
    public void save(Credentials creds, OutputStream outputStream2) throws IOException {
        this.save(new KdbxStreamFormat(), creds, outputStream2);
    }

    public void save(StreamFormat format, Credentials creds, OutputStream outputStream2) throws IOException {
        JaxbSerializableDatabase jsd = new JaxbSerializableDatabase();
        jsd.setKeePassFile(this.keePassFile);
        format.save(jsd, creds, outputStream2);
        this.setDirty(false);
    }

    @Override
    public JaxbGroup getRootGroup() {
        return this.root;
    }

    @Override
    public JaxbGroup getRecycleBin() {
        UUID recycleBinUuid = this.keePassFile.getMeta().getRecycleBinUUID();
        JaxbGroup g2 = (JaxbGroup)this.findGroup(recycleBinUuid);
        if (g2 == null && !this.isRecycleBinEnabled()) {
            return null;
        }
        if (g2 == null) {
            g2 = (JaxbGroup)this.newGroup("Recycle Bin");
            this.getRootGroup().addGroup(g2);
            this.keePassFile.getMeta().setRecycleBinUUID(g2.getUuid());
            this.keePassFile.getMeta().setRecycleBinChanged(new Date());
        }
        return g2;
    }

    @Override
    public boolean isRecycleBinEnabled() {
        return this.keePassFile.getMeta().getRecycleBinEnabled();
    }

    @Override
    public void enableRecycleBin(boolean enable) {
        this.keePassFile.getMeta().setRecycleBinEnabled(enable);
    }

    @Override
    public JaxbGroup newGroup() {
        return new JaxbGroup(this);
    }

    @Override
    public JaxbEntry newEntry() {
        return new JaxbEntry(this);
    }

    @Override
    public JaxbIcon newIcon() {
        return new JaxbIcon();
    }

    @Override
    public JaxbIcon newIcon(Integer i) {
        return new JaxbIcon(i);
    }

    @Override
    public String getDescription() {
        return this.keePassFile.getMeta().getDatabaseDescription();
    }

    @Override
    public void setDescription(String description) {
        this.keePassFile.getMeta().setDatabaseDescription(description);
    }

    @Override
    public boolean shouldProtect(String propertyName) {
        switch (propertyName.toLowerCase()) {
            case "title": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectTitle();
            }
            case "username": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectUserName();
            }
            case "password": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectPassword();
            }
            case "url": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectURL();
            }
            case "notes": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectNotes();
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.keePassFile.getMeta().getDatabaseName();
    }

    @Override
    public void setName(String s2) {
        this.keePassFile.getMeta().setDatabaseName(s2);
        this.keePassFile.getMeta().setDatabaseNameChanged(new Date());
    }

    public KeePassFile getKeePassFile() {
        return this.keePassFile;
    }

    ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }
}

