/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.linguafranca.pwdb.base.AbstractGroup;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.dom.DomDatabaseWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomEntryWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomHelper;
import org.linguafranca.pwdb.kdbx.dom.DomIconWrapper;
import org.w3c.dom.Element;

public class DomGroupWrapper
extends AbstractGroup<DomDatabaseWrapper, DomGroupWrapper, DomEntryWrapper, DomIconWrapper> {
    static Map<String, DomHelper.ValueCreator> mandatoryGroupElements = new HashMap<String, DomHelper.ValueCreator>(){
        {
            this.put("UUID", new DomHelper.UuidValueCreator());
            this.put("Name", new DomHelper.ConstantValueCreator(""));
            this.put("Notes", new DomHelper.ConstantValueCreator(""));
            this.put("IconID", new DomHelper.ConstantValueCreator("0"));
            this.put("Times", new DomHelper.ConstantValueCreator(""));
            this.put("Times/LastModificationTime", new DomHelper.DateValueCreator());
            this.put("Times/CreationTime", new DomHelper.DateValueCreator());
            this.put("Times/LastAccessTime", new DomHelper.DateValueCreator());
            this.put("Times/ExpiryTime", new DomHelper.DateValueCreator());
            this.put("Times/Expires", new DomHelper.ConstantValueCreator("False"));
            this.put("Times/UsageCount", new DomHelper.ConstantValueCreator("0"));
            this.put("Times/LocationChanged", new DomHelper.DateValueCreator());
        }
    };
    private final Element element;
    private final DomDatabaseWrapper database;

    public DomGroupWrapper(Element element, DomDatabaseWrapper database, boolean newGroup) {
        this.database = database;
        this.element = element;
        if (newGroup) {
            DomHelper.ensureElements(this.element, mandatoryGroupElements);
        }
    }

    @Override
    public boolean isRootGroup() {
        Element parent = (Element)this.element.getParentNode();
        return parent != null && parent.getTagName().equals("Root");
    }

    @Override
    public boolean isRecycleBin() {
        String UUIDcontent = DomHelper.getElementContent("RecycleBinUuid", this.database.dbMeta);
        if (UUIDcontent != null) {
            UUID uuid = Helpers.uuidFromBase64(UUIDcontent);
            return uuid.equals(this.getUuid());
        }
        return false;
    }

    @Override
    @Nullable
    public DomGroupWrapper getParent() {
        Element parent = (Element)this.element.getParentNode();
        if (parent == null) {
            return null;
        }
        if (this.element == this.element.getOwnerDocument().getDocumentElement().getElementsByTagName("Group").item(0)) {
            return null;
        }
        return new DomGroupWrapper(parent, this.database, false);
    }

    @Override
    public void setParent(DomGroupWrapper parent) {
        parent.addGroup(this);
    }

    @Override
    public List<DomGroupWrapper> getGroups() {
        List<Element> elements = DomHelper.getElements("Group", this.element);
        ArrayList<DomGroupWrapper> result = new ArrayList<DomGroupWrapper>(elements.size());
        for (Element e : elements) {
            result.add(new DomGroupWrapper(e, this.database, false));
        }
        return result;
    }

    @Override
    public int getGroupsCount() {
        List<Element> elements = DomHelper.getElements("Group", this.element);
        return elements.size();
    }

    @Override
    public DomGroupWrapper addGroup(DomGroupWrapper group) {
        if (group.isRootGroup()) {
            throw new IllegalStateException("Cannot set root group as child of another group");
        }
        if (group.getParent() != null) {
            group.getParent().touch();
            group.getParent().removeGroup(group);
        }
        this.element.appendChild(group.element);
        DomHelper.touchElement("Times/LocationChanged", group.element);
        this.touch();
        return group;
    }

    @Override
    public DomGroupWrapper removeGroup(DomGroupWrapper g1) {
        this.element.removeChild(g1.element);
        this.database.setDirty(true);
        return g1;
    }

    @Override
    public List<DomEntryWrapper> getEntries() {
        List<Element> elements = DomHelper.getElements("Entry", this.element);
        ArrayList<DomEntryWrapper> entries = new ArrayList<DomEntryWrapper>(elements.size());
        for (Element e : elements) {
            entries.add(new DomEntryWrapper(e, this.database, false));
        }
        return entries;
    }

    @Override
    public int getEntriesCount() {
        return DomHelper.getElementsCount("Entry", this.element);
    }

    @Override
    public DomEntryWrapper addEntry(DomEntryWrapper entry) {
        if (entry.getParent() != null) {
            entry.element.getParentNode().removeChild(this.element);
        }
        this.element.appendChild(entry.element);
        this.database.setDirty(true);
        return entry;
    }

    @Override
    public DomEntryWrapper removeEntry(DomEntryWrapper e12) {
        this.element.removeChild(e12.element);
        this.database.setDirty(true);
        return e12;
    }

    @Override
    public String getName() {
        return DomHelper.getElementContent("Name", this.element);
    }

    @Override
    public void setName(String name) {
        DomHelper.setElementContent("Name", this.element, name);
        this.database.setDirty(true);
    }

    @Override
    public UUID getUuid() {
        String encodedUuid = DomHelper.getElementContent("UUID", this.element);
        return Helpers.uuidFromBase64(encodedUuid);
    }

    @Override
    public DomIconWrapper getIcon() {
        return new DomIconWrapper(DomHelper.getElement("IconID", this.element, false));
    }

    @Override
    public void setIcon(DomIconWrapper icon) {
        DomHelper.setElementContent("IconID", this.element, String.valueOf(icon.getIndex()));
        this.database.setDirty(true);
    }

    @Override
    public DomDatabaseWrapper getDatabase() {
        return this.database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomGroupWrapper that = (DomGroupWrapper)o;
        return this.element.equals(that.element) && this.database.equals(that.database);
    }

    private void touch() {
        DomHelper.touchElement("Times/LastModificationTime", this.element);
        this.database.setDirty(true);
    }
}

